/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements pixel-wise generic operation on one image.


This class is parameterized over the type of the input image and the
type of the output image. It is also parameterized by the operation to
be applied, using a Functor style.

UnaryFunctorImageFilter allows the output dimension of the filter to be larger than the input
dimension. Thus subclasses of the UnaryFunctorImageFilter (like the CastImageFilter ) can be used to promote a 2D image to a 3D image, etc.


See:
 UnaryGeneratorImageFilter

 BinaryFunctorImageFilter TernaryFunctorImageFilter

 itk::simple::BitwiseNot for the procedural interface

 itk::UnaryFunctorImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBitwiseNotImageFilter.h
*/
public class BitwiseNotImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BitwiseNotImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BitwiseNotImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BitwiseNotImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BitwiseNotImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BitwiseNotImageFilter::~BitwiseNotImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BitwiseNotImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BitwiseNotImageFilter::BitwiseNotImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BitwiseNotImageFilter() {
    this(SimpleITKJNI.new_BitwiseNotImageFilter(), true);
  }

  /**
std::string itk::simple::BitwiseNotImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BitwiseNotImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BitwiseNotImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BitwiseNotImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BitwiseNotImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BitwiseNotImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
