/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.version;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.VersionFilter;

public final class ChainedVersionFilter
implements VersionFilter {
    private final VersionFilter[] filters;
    private int hashCode;

    public static VersionFilter newInstance(VersionFilter filter1, VersionFilter filter2) {
        if (filter1 == null) {
            return filter2;
        }
        if (filter2 == null) {
            return filter1;
        }
        return new ChainedVersionFilter(new VersionFilter[]{filter1, filter2});
    }

    public static VersionFilter newInstance(VersionFilter ... filters) {
        if (filters.length <= 1) {
            if (filters.length <= 0) {
                return null;
            }
            return filters[0];
        }
        return new ChainedVersionFilter((VersionFilter[])filters.clone());
    }

    public static VersionFilter newInstance(Collection<? extends VersionFilter> filters) {
        if (filters.size() <= 1) {
            if (filters.isEmpty()) {
                return null;
            }
            return filters.iterator().next();
        }
        return new ChainedVersionFilter(filters.toArray(new VersionFilter[0]));
    }

    private ChainedVersionFilter(VersionFilter[] filters) {
        this.filters = filters;
    }

    @Override
    public void filterVersions(VersionFilter.VersionFilterContext context) throws RepositoryException {
        int n = this.filters.length;
        for (int i = 0; i < n && context.getCount() > 0; ++i) {
            this.filters[i].filterVersions(context);
        }
    }

    @Override
    public VersionFilter deriveChildFilter(DependencyCollectionContext context) {
        VersionFilter[] children2 = null;
        int removed = 0;
        int n = this.filters.length;
        for (int i = 0; i < n; ++i) {
            VersionFilter child = this.filters[i].deriveChildFilter(context);
            if (children2 != null) {
                children2[i - removed] = child;
            } else if (child != this.filters[i]) {
                children2 = new VersionFilter[this.filters.length];
                System.arraycopy(this.filters, 0, children2, 0, i);
                children2[i - removed] = child;
            }
            if (child != null) continue;
            ++removed;
        }
        if (children2 == null) {
            return this;
        }
        if (removed > 0) {
            int count2 = this.filters.length - removed;
            if (count2 <= 0) {
                return null;
            }
            if (count2 == 1) {
                return children2[0];
            }
            VersionFilter[] tmp = new VersionFilter[count2];
            System.arraycopy(children2, 0, tmp, 0, count2);
            children2 = tmp;
        }
        return new ChainedVersionFilter(children2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ChainedVersionFilter that = (ChainedVersionFilter)obj;
        return Arrays.equals(this.filters, that.filters);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = this.getClass().hashCode();
            this.hashCode = hash = hash * 31 + Arrays.hashCode(this.filters);
        }
        return this.hashCode;
    }
}

