/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests.bazel;

import com.intellij.tests.IgnoreException;
import com.intellij.tests.bazel.EntryDetails;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;
import org.opentest4j.TestAbortedException;

class TestData {
    private final TestIdentifier id;
    private final List<ReportEntry> reportEntries = Collections.synchronizedList(new ArrayList());
    private Instant started = Instant.now();
    private Instant finished = null;
    private String reason;
    private TestExecutionResult result;
    private boolean dynamic;

    TestData(TestIdentifier id) {
        this.id = id;
    }

    public TestIdentifier getId() {
        return this.id;
    }

    public TestData started() {
        this.started = Instant.now();
        return this;
    }

    public TestData mark(TestExecutionResult result) {
        Optional maybeThrowable;
        if (result.getStatus() == TestExecutionResult.Status.ABORTED && (maybeThrowable = result.getThrowable()).isPresent() && maybeThrowable.get() instanceof TestAbortedException) {
            this.skipReason(((Throwable)maybeThrowable.get()).getMessage());
        }
        this.finished = Instant.now();
        this.result = result;
        return this;
    }

    public TestData skipReason(String reason) {
        this.reason = reason;
        return this;
    }

    public String getSkipReason() {
        return this.reason;
    }

    public TestExecutionResult getResult() {
        return this.result;
    }

    public Duration getDuration() {
        if (this.finished == null) {
            return null;
        }
        return Duration.between(this.started, this.finished);
    }

    public boolean isError() {
        TestExecutionResult result = this.getResult();
        if (result == null || result.getStatus() == TestExecutionResult.Status.SUCCESSFUL || this.isSkipped()) {
            return false;
        }
        return result.getThrowable().map(thr -> thr instanceof AssertionError).orElse(false);
    }

    public boolean isFailure() {
        TestExecutionResult result = this.getResult();
        if (result == null || result.getStatus() == TestExecutionResult.Status.SUCCESSFUL || this.isSkipped()) {
            return false;
        }
        if (result.getStatus() == TestExecutionResult.Status.ABORTED) {
            return true;
        }
        return result.getThrowable().map(thr -> !(thr instanceof AssertionError)).orElse(false);
    }

    public boolean isDisabled() {
        return this.getResult() == null;
    }

    public boolean isSkipped() {
        if (this.getResult() == null) {
            return false;
        }
        if (this.getSkipReason() != null) {
            return true;
        }
        return this.getResult().getThrowable().map(IgnoreException::isIgnoringThrowable).orElse(false);
    }

    public TestData addReportEntry(ReportEntry entry) {
        this.reportEntries.add(entry);
        return this;
    }

    public String getStdOut() {
        return this.reportEntries.stream().map(EntryDetails::getStdOut).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String getStdErr() {
        return this.reportEntries.stream().map(EntryDetails::getStdErr).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public TestData setDynamic(boolean isDynamic) {
        this.dynamic = isDynamic;
        return this;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Instant getStarted() {
        return this.started;
    }

    public String toString() {
        return "TestData{id=" + String.valueOf(this.id) + ", reportEntries=" + String.valueOf(this.reportEntries) + ", started=" + String.valueOf(this.started) + ", finished=" + String.valueOf(this.finished) + ", reason='" + this.reason + "', result=" + String.valueOf(this.result) + ", dynamic=" + this.dynamic + "}";
    }
}

