/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.plugins.ide.idea.model.FilePath;
import org.gradle.plugins.ide.idea.model.JarDirectory;
import org.gradle.plugins.ide.idea.model.ModuleLibrary;
import org.jspecify.annotations.Nullable;

public class SingleEntryModuleLibrary
extends ModuleLibrary {
    private ModuleVersionIdentifier moduleVersion;

    public SingleEntryModuleLibrary(FilePath library, Set<FilePath> javadoc, Set<FilePath> source, String scope) {
        super(Collections.singletonList(library), javadoc, source, new ArrayList<JarDirectory>(), scope);
    }

    public SingleEntryModuleLibrary(FilePath library, @Nullable FilePath javadoc, @Nullable FilePath source, String scope) {
        super(Collections.singletonList(library), javadoc != null ? Collections.singletonList(javadoc) : new ArrayList(), source != null ? Collections.singletonList(source) : new ArrayList(), new LinkedHashSet<JarDirectory>(), scope);
    }

    public SingleEntryModuleLibrary(FilePath library, String scope) {
        this(library, new LinkedHashSet<FilePath>(), new LinkedHashSet<FilePath>(), scope);
    }

    public @Nullable ModuleVersionIdentifier getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(@Nullable ModuleVersionIdentifier moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public File getLibraryFile() {
        return ((FilePath)this.getClasses().iterator().next()).getFile();
    }

    public File getJavadocFile() {
        if (this.getJavadoc().size() > 0) {
            return ((FilePath)this.getJavadoc().iterator().next()).getFile();
        }
        return null;
    }

    public File getSourceFile() {
        if (this.getSources().size() > 0) {
            return ((FilePath)this.getSources().iterator().next()).getFile();
        }
        return null;
    }
}

