/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeParticipant;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class ResourceModelScopeParticipant
implements ISynchronizationScopeParticipant,
IResourceChangeListener,
IPropertyChangeListener {
    private final ModelProvider provider;
    private final ISynchronizationScope scope;

    public ResourceModelScopeParticipant(ModelProvider provider, ISynchronizationScope scope) {
        this.provider = provider;
        this.scope = scope;
        if (this.hasWorkspaceMapping()) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        if (this.hasWorkingSetMappings()) {
            PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private boolean hasWorkingSetMappings() {
        ResourceMapping[] mappings;
        ResourceMapping[] resourceMappingArray = mappings = this.scope.getMappings(this.provider.getDescriptor().getId());
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            Object modelObject = mapping.getModelObject();
            if (modelObject instanceof IWorkingSet) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasWorkspaceMapping() {
        ResourceMapping[] mappings;
        ResourceMapping[] resourceMappingArray = mappings = this.scope.getMappings(this.provider.getDescriptor().getId());
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ModelProvider provider;
            IResource resource;
            ResourceMapping mapping = resourceMappingArray[n2];
            Object modelObject = mapping.getModelObject();
            if (modelObject instanceof IResource ? (resource = (IResource)modelObject).getType() == 8 : modelObject instanceof ModelProvider && (provider = (ModelProvider)modelObject).getId().equals("org.eclipse.core.resources.modelProvider")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ResourceMapping[] handleContextChange(ISynchronizationScope scope, IResource[] resources, IProject[] projects) {
        HashSet<ResourceMapping> result = new HashSet<ResourceMapping>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.collectMappings(project, result);
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void collectMappings(IProject project, Set<ResourceMapping> result) {
        var7_4 = mappings = this.scope.getMappings(this.provider.getDescriptor().getId());
        var6_5 = mappings.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            mapping = var7_4[var5_6];
            refresh = false;
            modelObject = mapping.getModelObject();
            if (modelObject instanceof IWorkingSet) {
                set = (IWorkingSet)modelObject;
                var15_17 = elements = set.getElements();
                var14_16 = elements.length;
                var13_13 = 0;
                while (var13_13 < var14_16) {
                    adaptable = var15_17[var13_13];
                    m = (ResourceMapping)Adapters.adapt((Object)adaptable, ResourceMapping.class);
                    if (m != null) {
                        var21_23 = p = m.getProjects();
                        var20_22 = p.length;
                        var19_21 = 0;
                        while (var19_21 < var20_22) {
                            mp = var21_23[var19_21];
                            if (mp.equals((Object)project)) {
                                refresh = true;
                                break;
                            }
                            ++var19_21;
                        }
                    }
                    if (!refresh) {
                        ++var13_13;
                        continue;
                    }
                    break;
                }
            } else if (modelObject instanceof IResource) {
                resource = (IResource)modelObject;
                if (resource.getType() == 8) {
                    refresh = true;
                }
            } else if (modelObject instanceof ModelProvider) {
                mp = (ModelProvider)modelObject;
                try {
                    list = mp.getMappings((IResource)project, ResourceMappingContext.LOCAL_CONTEXT, null);
                    if (list.length <= 0) ** GOTO lbl47
                    refresh = true;
                }
                catch (CoreException e) {
                    TeamUIPlugin.log(e);
                }
            }
            if (refresh) {
                result.add(mapping);
            }
            ++var5_6;
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta[] children;
        HashSet<ResourceMapping> result = new HashSet<ResourceMapping>();
        IResourceDelta[] iResourceDeltaArray = children = event.getDelta().getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            IResource resource = delta.getResource();
            if (resource.getType() == 4 && ((delta.getKind() & 3) != 0 || (delta.getFlags() & 0x4000) != 0) && this.isInContext(resource)) {
                this.collectMappings((IProject)resource, result);
            }
            ++n2;
        }
        if (!result.isEmpty()) {
            this.fireChange(result.toArray(new ResourceMapping[result.size()]));
        }
    }

    private boolean isInContext(IResource resource) {
        IProject[] projects;
        IProject[] iProjectArray = projects = this.scope.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.equals((Object)resource.getProject())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void fireChange(ResourceMapping[] mappings) {
        this.scope.refresh(mappings);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "workingSetContentChange") {
            ResourceMapping[] mappings;
            IWorkingSet newSet = (IWorkingSet)event.getNewValue();
            ResourceMapping[] resourceMappingArray = mappings = this.scope.getMappings(this.provider.getDescriptor().getId());
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceMapping mapping = resourceMappingArray[n2];
                if (newSet == mapping.getModelObject()) {
                    this.fireChange(new ResourceMapping[]{mapping});
                }
                ++n2;
            }
        } else {
            event.getProperty();
        }
    }
}

