/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;
import org.eclipse.team.internal.ui.mapping.FuzzFactorDialog;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchModelSynchronizeParticipant;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriber;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchSubscriberMergeContext;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class FuzzFactorAction
extends Action {
    private final ISynchronizePageConfiguration configuration;
    private final ApplyPatchModelSynchronizeParticipant participant;
    private final ApplyPatchSubscriberMergeContext context;
    private final ApplyPatchSubscriber subscriber;

    public FuzzFactorAction(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        this.participant = (ApplyPatchModelSynchronizeParticipant)configuration.getParticipant();
        this.context = (ApplyPatchSubscriberMergeContext)this.participant.getContext();
        this.subscriber = (ApplyPatchSubscriber)this.context.getSubscriber();
    }

    public void run() {
        FuzzFactorDialog dialog = new FuzzFactorDialog(Display.getCurrent().getActiveShell(), this.subscriber.getPatcher());
        if (dialog.open() == 0) {
            int oldValue = this.subscriber.getPatcher().getFuzz();
            int newValue = dialog.getFuzzFactor();
            if (newValue != oldValue) {
                SubscriberDiffTreeEventHandler handler = (SubscriberDiffTreeEventHandler)this.context.getAdapter(SubscriberDiffTreeEventHandler.class);
                handler.reset();
                this.subscriber.getPatcher().setFuzz(newValue);
                this.participant.refresh(this.configuration.getSite().getWorkbenchSite(), this.context.getScope().getMappings());
            }
        }
    }
}

