/* where-clause.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from where-clause.vala, do not modify */

/* where-clause.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "zeitgeist-internal.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ZEITGEIST_WHERE_CLAUSE_0_PROPERTY,
	ZEITGEIST_WHERE_CLAUSE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_where_clause_properties[ZEITGEIST_WHERE_CLAUSE_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistWhereClausePrivate {
	ZeitgeistWhereClauseType clause_type;
	gboolean negated;
	GPtrArray* conditions;
	GPtrArray* arguments;
	gboolean is_simple;
};

static gint ZeitgeistWhereClause_private_offset;
static gpointer zeitgeist_where_clause_parent_class = NULL;
static gchar** zeitgeist_where_clause_RELATION_SIGNS;
static gint zeitgeist_where_clause_RELATION_SIGNS_length1;
static gchar** zeitgeist_where_clause_RELATION_SIGNS = NULL;
static gint zeitgeist_where_clause_RELATION_SIGNS_length1 = 0;
static gint _zeitgeist_where_clause_RELATION_SIGNS_size_ = 0;

static void _g_free0_ (gpointer var);
static gchar* zeitgeist_where_clause_get_search_table_for_column (const gchar* column);
static gchar* zeitgeist_where_clause_optimize_glob (const gchar* column,
                                             const gchar* table,
                                             GPtrArray** args);
static gpointer* zeitgeist_where_clause_generic_array_to_unowned_array (ZeitgeistWhereClause* self,
                                                                 GType t_type,
                                                                 GBoxedCopyFunc t_dup_func,
                                                                 GDestroyNotify t_destroy_func,
                                                                 GPtrArray* gptrarr,
                                                                 gint* result_length1);
static gpointer* _vala_array_dup1 (gpointer* self,
                            gssize length,
                            GBoxedCopyFunc t_dup_func);
static void zeitgeist_where_clause_finalize (GObject * obj);
static GType zeitgeist_where_clause_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
zeitgeist_where_clause_get_instance_private (ZeitgeistWhereClause* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistWhereClause_private_offset);
}

static GType
zeitgeist_where_clause_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ZEITGEIST_WHERE_CLAUSE_TYPE_AND, "ZEITGEIST_WHERE_CLAUSE_TYPE_AND", "and"}, {ZEITGEIST_WHERE_CLAUSE_TYPE_OR, "ZEITGEIST_WHERE_CLAUSE_TYPE_OR", "or"}, {0, NULL, NULL}};
	GType zeitgeist_where_clause_type_type_id;
	zeitgeist_where_clause_type_type_id = g_enum_register_static ("ZeitgeistWhereClauseType", values);
	return zeitgeist_where_clause_type_type_id;
}

GType
zeitgeist_where_clause_type_get_type (void)
{
	static volatile gsize zeitgeist_where_clause_type_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_where_clause_type_type_id__once)) {
		GType zeitgeist_where_clause_type_type_id;
		zeitgeist_where_clause_type_type_id = zeitgeist_where_clause_type_get_type_once ();
		g_once_init_leave (&zeitgeist_where_clause_type_type_id__once, zeitgeist_where_clause_type_type_id);
	}
	return zeitgeist_where_clause_type_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

ZeitgeistWhereClause*
zeitgeist_where_clause_construct (GType object_type,
                                  ZeitgeistWhereClauseType type,
                                  gboolean negate)
{
	ZeitgeistWhereClause * self = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	self = (ZeitgeistWhereClause*) g_object_new (object_type, NULL);
	self->priv->clause_type = type;
	self->priv->negated = negate;
	self->priv->is_simple = TRUE;
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->conditions);
	self->priv->conditions = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->arguments);
	self->priv->arguments = _tmp1_;
	return self;
}

ZeitgeistWhereClause*
zeitgeist_where_clause_new (ZeitgeistWhereClauseType type,
                            gboolean negate)
{
	return zeitgeist_where_clause_construct (ZEITGEIST_TYPE_WHERE_CLAUSE, type, negate);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

gint
zeitgeist_where_clause_get_conditions_length (ZeitgeistWhereClause* self)
{
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
zeitgeist_where_clause_has_non_timestamp_condition (ZeitgeistWhereClause* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				GPtrArray* _tmp5_;
				gconstpointer _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->conditions;
				_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->conditions;
				_tmp6_ = g_ptr_array_index (_tmp5_, (guint) i);
				if (!g_str_has_prefix ((const gchar*) _tmp6_, "timestamp")) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

void
zeitgeist_where_clause_add (ZeitgeistWhereClause* self,
                            const gchar* condition,
                            const gchar* argument)
{
	GPtrArray* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (condition != NULL);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = g_strdup (condition);
	g_ptr_array_add (_tmp0_, _tmp1_);
	if (argument != NULL) {
		GPtrArray* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->arguments;
		_tmp3_ = g_strdup (argument);
		g_ptr_array_add (_tmp2_, _tmp3_);
	}
}

void
zeitgeist_where_clause_add_with_array (ZeitgeistWhereClause* self,
                                       const gchar* condition,
                                       GPtrArray* args)
{
	GPtrArray* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (condition != NULL);
	g_return_if_fail (args != NULL);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = g_strdup (condition);
	g_ptr_array_add (_tmp0_, _tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gconstpointer _tmp7_;
				gchar* _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					i = i + 1;
					_tmp3_ = i;
				}
				_tmp2_ = FALSE;
				_tmp4_ = vala_g_ptr_array_get_length (args);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->arguments;
				_tmp7_ = g_ptr_array_index (args, (guint) i);
				_tmp8_ = g_strdup ((const gchar*) _tmp7_);
				g_ptr_array_add (_tmp6_, _tmp8_);
			}
		}
	}
}

static gchar*
zeitgeist_where_clause_get_search_table_for_column (const gchar* column)
{
	gchar* search_table = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	gchar* result;
	g_return_val_if_fail (column != NULL, NULL);
	_tmp0_ = column;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("origin")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("subj_origin"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("subj_origin_current"))))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("subj_id"))))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("subj_id_current"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("uri");
				_g_free0 (search_table);
				search_table = _tmp3_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("subj_mimetype")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("mimetype");
				_g_free0 (search_table);
				search_table = _tmp4_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("subj_text_id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("text");
				_g_free0 (search_table);
				search_table = _tmp5_;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("subj_storage_id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("storage");
				_g_free0 (search_table);
				search_table = _tmp6_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup (column);
				_g_free0 (search_table);
				search_table = _tmp7_;
				break;
			}
		}
	}
	result = search_table;
	return result;
}

void
zeitgeist_where_clause_add_match_condition (ZeitgeistWhereClause* self,
                                            const gchar* column,
                                            gint val,
                                            gboolean negation)
{
	const gchar* _tmp0_ = NULL;
	gchar* sql = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (column != NULL);
	if (negation) {
		_tmp0_ = "!";
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup_printf ("%s %s= %d", column, _tmp0_, val);
	sql = _tmp1_;
	zeitgeist_where_clause_add (self, sql, NULL);
	_g_free0 (sql);
}

void
zeitgeist_where_clause_add_text_condition_subquery (ZeitgeistWhereClause* self,
                                                    const gchar* column,
                                                    const gchar* val,
                                                    gboolean negation)
{
	gchar* search_table = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* sql = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (column != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = zeitgeist_where_clause_get_search_table_for_column (column);
	search_table = _tmp0_;
	if (negation) {
		_tmp1_ = "!";
	} else {
		_tmp1_ = "";
	}
	_tmp2_ = search_table;
	_tmp3_ = g_strdup_printf ("%s %s= (SELECT id FROM %s WHERE value = ?)", column, _tmp1_, _tmp2_);
	sql = _tmp3_;
	zeitgeist_where_clause_add (self, sql, val);
	self->priv->is_simple = FALSE;
	_g_free0 (sql);
	_g_free0 (search_table);
}

void
zeitgeist_where_clause_add_text_condition (ZeitgeistWhereClause* self,
                                           const gchar* column,
                                           const gchar* val,
                                           gboolean negation)
{
	const gchar* _tmp0_ = NULL;
	gchar* sql = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (column != NULL);
	g_return_if_fail (val != NULL);
	if (negation) {
		_tmp0_ = "!";
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup_printf ("%s %s= ?", column, _tmp0_);
	sql = _tmp1_;
	zeitgeist_where_clause_add (self, sql, val);
	_g_free0 (sql);
}

void
zeitgeist_where_clause_add_wildcard_condition (ZeitgeistWhereClause* self,
                                               const gchar* column,
                                               const gchar* needle,
                                               gboolean negation)
{
	gchar* search_table = NULL;
	gchar* _tmp0_;
	GPtrArray* values = NULL;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	gchar* _tmp3_;
	gchar* optimized_glob = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* sql = NULL;
	const gchar* _tmp10_;
	GPtrArray* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (column != NULL);
	g_return_if_fail (needle != NULL);
	_tmp0_ = zeitgeist_where_clause_get_search_table_for_column (column);
	search_table = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	values = _tmp1_;
	_tmp2_ = values;
	_tmp3_ = g_strdup (needle);
	g_ptr_array_add (_tmp2_, _tmp3_);
	_tmp4_ = search_table;
	_tmp5_ = zeitgeist_where_clause_optimize_glob ("id", _tmp4_, &values);
	optimized_glob = _tmp5_;
	if (!negation) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = optimized_glob;
		_tmp7_ = g_strdup_printf ("%s IN (%s)", column, _tmp6_);
		_g_free0 (sql);
		sql = _tmp7_;
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = optimized_glob;
		_tmp9_ = g_strdup_printf ("(%s NOT IN (%s) OR %s is NULL)", column, _tmp8_, column);
		_g_free0 (sql);
		sql = _tmp9_;
	}
	_tmp10_ = sql;
	_tmp11_ = values;
	zeitgeist_where_clause_add_with_array (self, _tmp10_, _tmp11_);
	self->priv->is_simple = FALSE;
	_g_free0 (sql);
	_g_free0 (optimized_glob);
	_g_ptr_array_unref0 (values);
	_g_free0 (search_table);
}

void
zeitgeist_where_clause_extend (ZeitgeistWhereClause* self,
                               ZeitgeistWhereClause* clause)
{
	gchar* sql = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GPtrArray* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clause != NULL);
	if (zeitgeist_where_clause_is_empty (clause)) {
		return;
	}
	_tmp0_ = zeitgeist_where_clause_get_sql_conditions (clause);
	sql = _tmp0_;
	_tmp1_ = sql;
	_tmp2_ = clause->priv->arguments;
	zeitgeist_where_clause_add_with_array (self, _tmp1_, _tmp2_);
	self->priv->is_simple = zeitgeist_where_clause_get_is_simple (clause);
	_g_free0 (sql);
}

gboolean
zeitgeist_where_clause_is_empty (ZeitgeistWhereClause* self)
{
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}

gboolean
zeitgeist_where_clause_may_have_results (ZeitgeistWhereClause* self)
{
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

gboolean
zeitgeist_where_clause_get_is_simple (ZeitgeistWhereClause* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->is_simple;
	return result;
}

void
zeitgeist_where_clause_set_is_simple (ZeitgeistWhereClause* self,
                                      gboolean simple)
{
	g_return_if_fail (self != NULL);
	self->priv->is_simple = simple;
}

/**
         * This is dangerous. Only use it if you're made full of awesome.
         */
static gpointer*
_vala_array_dup1 (gpointer* self,
                  gssize length,
                  GBoxedCopyFunc t_dup_func)
{
	if (length > 0) {
		gpointer* result;
		gssize i;
		result = g_new0 (gpointer, length);
		for (i = 0; i < length; i++) {
			gpointer _tmp0_;
			_tmp0_ = ((self[i] != NULL) && (t_dup_func != NULL)) ? t_dup_func ((gpointer) self[i]) : ((gpointer) self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gpointer*
zeitgeist_where_clause_generic_array_to_unowned_array (ZeitgeistWhereClause* self,
                                                       GType t_type,
                                                       GBoxedCopyFunc t_dup_func,
                                                       GDestroyNotify t_destroy_func,
                                                       GPtrArray* gptrarr,
                                                       gint* result_length1)
{
	glong* pointers = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong* _tmp2_;
	gint pointers_length1;
	gint _pointers_size_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint _tmp5_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* _tmp7_;
	gint _tmp7__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gptrarr != NULL, NULL);
	_tmp0_ = vala_g_ptr_array_get_length (gptrarr);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (glong, _tmp1_);
	pointers = _tmp2_;
	pointers_length1 = _tmp1_;
	_pointers_size_ = pointers_length1;
	_tmp3_ = gptrarr->pdata;
	_tmp3__length1 = gptrarr->len;
	_tmp4_ = vala_g_ptr_array_get_length (gptrarr);
	_tmp5_ = _tmp4_;
	memcpy (pointers, (void*) _tmp3_, (gsize) (_tmp5_ * sizeof (void*)));
	_tmp6_ = (((gpointer*) pointers) != NULL) ? _vala_array_dup1 ((gpointer*) pointers, pointers_length1, t_dup_func) : ((gpointer*) pointers);
	_tmp6__length1 = pointers_length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	pointers = (g_free (pointers), NULL);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
zeitgeist_where_clause_get_sql_conditions (ZeitgeistWhereClause* self)
{
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* negation_sign = NULL;
	gchar* _tmp4_;
	gchar* relation_sign = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GPtrArray* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gchar* conditions_string = NULL;
	const gchar* _tmp15_;
	GPtrArray* _tmp16_;
	gint _tmp17_ = 0;
	gpointer* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->conditions;
	_tmp1_ = vala_g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ > 0, "conditions.length > 0");
	if (self->priv->negated) {
		_tmp3_ = "NOT ";
	} else {
		_tmp3_ = "";
	}
	_tmp4_ = g_strdup (_tmp3_);
	negation_sign = _tmp4_;
	_tmp5_ = zeitgeist_where_clause_RELATION_SIGNS;
	_tmp5__length1 = zeitgeist_where_clause_RELATION_SIGNS_length1;
	_tmp6_ = _tmp5_[self->priv->clause_type];
	_tmp7_ = g_strdup (_tmp6_);
	relation_sign = _tmp7_;
	_tmp8_ = self->priv->conditions;
	_tmp9_ = vala_g_ptr_array_get_length (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == 1) {
		const gchar* _tmp11_;
		GPtrArray* _tmp12_;
		gconstpointer _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = negation_sign;
		_tmp12_ = self->priv->conditions;
		_tmp13_ = g_ptr_array_index (_tmp12_, (guint) 0);
		_tmp14_ = g_strdup_printf ("%s%s", _tmp11_, (const gchar*) _tmp13_);
		result = _tmp14_;
		_g_free0 (relation_sign);
		_g_free0 (negation_sign);
		return result;
	}
	_tmp15_ = relation_sign;
	_tmp16_ = self->priv->conditions;
	_tmp18_ = zeitgeist_where_clause_generic_array_to_unowned_array (self, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp16_, &_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp19__length1 = _tmp17_;
	_tmp20_ = _vala_g_strjoinv (_tmp15_, _tmp19_, (gint) _tmp17_);
	_tmp21_ = _tmp20_;
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	conditions_string = _tmp21_;
	_tmp22_ = negation_sign;
	_tmp23_ = conditions_string;
	_tmp24_ = g_strdup_printf ("%s(%s)", _tmp22_, _tmp23_);
	result = _tmp24_;
	_g_free0 (conditions_string);
	_g_free0 (relation_sign);
	_g_free0 (negation_sign);
	return result;
}

GPtrArray*
zeitgeist_where_clause_get_bind_arguments (ZeitgeistWhereClause* self)
{
	GPtrArray* _tmp0_;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->arguments;
	result = _tmp0_;
	return result;
}

/**
         * Return an optimized version of the GLOB statement as described in
         * http://www.sqlite.org/optoverview.html "4.0 The LIKE optimization".
         */
static gchar*
zeitgeist_where_clause_optimize_glob (const gchar* column,
                                      const gchar* table,
                                      GPtrArray** args)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* sql = NULL;
	gchar* prefix = NULL;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (column != NULL, NULL);
	g_return_val_if_fail (table != NULL, NULL);
	g_return_val_if_fail (*args != NULL, NULL);
	_tmp0_ = vala_g_ptr_array_get_length (*args);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ == 1, "args.length == 1", NULL);
	_tmp2_ = g_ptr_array_index (*args, (guint) 0);
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
	prefix = _tmp3_;
	_tmp4_ = prefix;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup_printf ("SELECT %s FROM %s", column, table);
		_g_free0 (sql);
		sql = _tmp5_;
	} else {
		if (FALSE) {
		} else {
			gchar* _tmp6_;
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = g_strdup_printf ("SELECT %s FROM %s WHERE (value >= ? AND value < ?)", column, table);
			_g_free0 (sql);
			sql = _tmp6_;
			_tmp7_ = prefix;
			_tmp8_ = zeitgeist_where_clause_get_right_boundary (_tmp7_);
			g_ptr_array_add (*args, _tmp8_);
		}
	}
	result = sql;
	_g_free0 (prefix);
	return result;
}

/**
         * Return the smallest string which is greater than the given `text`.
         */
static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
zeitgeist_where_clause_get_right_boundary (const gchar* text)
{
	gint len = 0;
	gunichar charpoint = 0U;
	gchar* head = NULL;
	gchar* _tmp6_;
	const gchar* _tmp9_;
	GString* _tmp10_;
	GString* _tmp11_;
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (text != NULL, NULL);
	if (g_strcmp0 (text, "") == 0) {
		GString* _tmp0_;
		GString* _tmp1_;
		GString* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = g_string_new ("");
		_tmp1_ = _tmp0_;
		_tmp2_ = g_string_append_unichar (_tmp1_, (gunichar) 0x10ffff);
		_tmp3_ = _tmp2_->str;
		_tmp4_ = g_strdup (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_string_free0 (_tmp1_);
		result = _tmp5_;
		return result;
	}
	len = g_utf8_strlen (text, (gssize) -1) - 1;
	charpoint = string_get_char (text, (glong) string_index_of_nth_char (text, (glong) len));
	_tmp6_ = string_substring (text, (glong) 0, (glong) string_index_of_nth_char (text, (glong) len));
	head = _tmp6_;
	if (charpoint == ((gunichar) 0x10ffff)) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = head;
		_tmp8_ = zeitgeist_where_clause_get_right_boundary (_tmp7_);
		result = _tmp8_;
		_g_free0 (head);
		return result;
	}
	_tmp9_ = head;
	_tmp10_ = g_string_new ("");
	_tmp11_ = _tmp10_;
	_tmp12_ = g_string_append_unichar (_tmp11_, charpoint + 1);
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_g_string_free0 (_tmp11_);
	result = _tmp15_;
	_g_free0 (head);
	return result;
}

static void
zeitgeist_where_clause_class_init (ZeitgeistWhereClauseClass * klass,
                                   gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	zeitgeist_where_clause_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistWhereClause_private_offset);
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_where_clause_finalize;
	_tmp0_ = g_strdup (" AND ");
	_tmp1_ = g_strdup (" OR ");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	zeitgeist_where_clause_RELATION_SIGNS = _tmp2_;
	zeitgeist_where_clause_RELATION_SIGNS_length1 = 2;
	_zeitgeist_where_clause_RELATION_SIGNS_size_ = zeitgeist_where_clause_RELATION_SIGNS_length1;
}

static void
zeitgeist_where_clause_instance_init (ZeitgeistWhereClause * self,
                                      gpointer klass)
{
	self->priv = zeitgeist_where_clause_get_instance_private (self);
}

static void
zeitgeist_where_clause_finalize (GObject * obj)
{
	ZeitgeistWhereClause * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_WHERE_CLAUSE, ZeitgeistWhereClause);
	_g_ptr_array_unref0 (self->priv->conditions);
	_g_ptr_array_unref0 (self->priv->arguments);
	G_OBJECT_CLASS (zeitgeist_where_clause_parent_class)->finalize (obj);
}

/**
     * This class provides a convenient representation a SQL `WHERE' clause,
     * composed of a set of conditions joined together.
     *
     * The relation between conditions can be either of type *AND* or *OR*, but
     * not both. To create more complex clauses, use several `WhereClause`
     * instances and joining them together using `extend`.
     *
     * Instances of this class can then be used to obtain a line of SQL code and
     * a list of arguments, for use with SQLite 3.
     */
static GType
zeitgeist_where_clause_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistWhereClauseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_where_clause_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistWhereClause), 0, (GInstanceInitFunc) zeitgeist_where_clause_instance_init, NULL };
	GType zeitgeist_where_clause_type_id;
	zeitgeist_where_clause_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistWhereClause", &g_define_type_info, 0);
	ZeitgeistWhereClause_private_offset = g_type_add_instance_private (zeitgeist_where_clause_type_id, sizeof (ZeitgeistWhereClausePrivate));
	return zeitgeist_where_clause_type_id;
}

GType
zeitgeist_where_clause_get_type (void)
{
	static volatile gsize zeitgeist_where_clause_type_id__once = 0;
	if (g_once_init_enter (&zeitgeist_where_clause_type_id__once)) {
		GType zeitgeist_where_clause_type_id;
		zeitgeist_where_clause_type_id = zeitgeist_where_clause_get_type_once ();
		g_once_init_leave (&zeitgeist_where_clause_type_id__once, zeitgeist_where_clause_type_id);
	}
	return zeitgeist_where_clause_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

