/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SESSION)

#include "JSMediaMetadataInit.h"

#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSMediaImage.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_SESSION)

template<> ConversionResult<IDLDictionary<MediaMetadataInit>> convertDictionary<MediaMetadataInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaMetadataInit result;
    JSValue albumValue;
    if (isNullOrUndefined)
        albumValue = jsUndefined();
    else {
        albumValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "album"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto albumConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, albumValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (albumConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.album = albumConversionResult.releaseReturnValue();
    JSValue artistValue;
    if (isNullOrUndefined)
        artistValue = jsUndefined();
    else {
        artistValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "artist"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto artistConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, artistValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (artistConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.artist = artistConversionResult.releaseReturnValue();
    JSValue artworkValue;
    if (isNullOrUndefined)
        artworkValue = jsUndefined();
    else {
        artworkValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "artwork"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto artworkConversionResult = convertOptionalWithDefault<IDLSequence<IDLDictionary<MediaImage>>>(lexicalGlobalObject, artworkValue, [&]() -> ConversionResult<IDLSequence<IDLDictionary<MediaImage>>> { return Converter<IDLSequence<IDLDictionary<MediaImage>>>::ReturnType { }; });
    if (artworkConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.artwork = artworkConversionResult.releaseReturnValue();
    JSValue titleValue;
    if (isNullOrUndefined)
        titleValue = jsUndefined();
    else {
        titleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "title"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto titleConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, titleValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (titleConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.title = titleConversionResult.releaseReturnValue();
#if ENABLE(MEDIA_SESSION_PLAYLIST)
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().mediaSessionPlaylistEnabled) {
        JSValue trackIdentifierValue;
        if (isNullOrUndefined)
            trackIdentifierValue = jsUndefined();
        else {
            trackIdentifierValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "trackIdentifier"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto trackIdentifierConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, trackIdentifierValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
        if (trackIdentifierConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.trackIdentifier = trackIdentifierConversionResult.releaseReturnValue();
    }
#endif
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(MEDIA_SESSION)
