// python wrapper for ttkTriangulationManager
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTriangulationManager.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTriangulationManager(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTriangulationManager_ClassNew(); }


static PyObject *
PyttkTriangulationManager_SetPreconditioningStrategy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPreconditioningStrategy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPreconditioningStrategy(temp0);
    }
    else
    {
      op->ttkTriangulationManager::SetPreconditioningStrategy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_SetPeriodicity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPeriodicity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPeriodicity(temp0);
    }
    else
    {
      op->ttkTriangulationManager::SetPeriodicity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_GetPeriodicity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPeriodicity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPeriodicity() :
      op->ttkTriangulationManager::GetPeriodicity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_SetThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThreshold(temp0);
    }
    else
    {
      op->ttkTriangulationManager::SetThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_GetThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetThreshold() :
      op->ttkTriangulationManager::GetThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_GetDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataArraySelection *tempr = (ap.IsBound() ?
      op->GetDataArraySelection() :
      op->ttkTriangulationManager::GetDataArraySelection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_SetDataArraySelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDataArraySelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  vtkSmartPointer<vtkDataArraySelection> temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkDataArraySelection"))
  {
    if (ap.IsBound())
    {
      op->SetDataArraySelection(temp0);
    }
    else
    {
      op->ttkTriangulationManager::SetDataArraySelection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTriangulationManager::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTriangulationManager::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTriangulationManager *tempr = ttkTriangulationManager::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTriangulationManager *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTriangulationManager::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTriangulationManager::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTriangulationManager_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTriangulationManager *op = static_cast<ttkTriangulationManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTriangulationManager::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkTriangulationManager_Methods[] = {
  {"SetPreconditioningStrategy", PyttkTriangulationManager_SetPreconditioningStrategy, METH_VARARGS,
   "SetPreconditioningStrategy(self, _arg:int) -> None\nC++: virtual void SetPreconditioningStrategy(int _arg)\n\n"},
  {"SetPeriodicity", PyttkTriangulationManager_SetPeriodicity, METH_VARARGS,
   "SetPeriodicity(self, _arg:bool) -> None\nC++: virtual void SetPeriodicity(bool _arg)\n\n"},
  {"GetPeriodicity", PyttkTriangulationManager_GetPeriodicity, METH_VARARGS,
   "GetPeriodicity(self) -> bool\nC++: virtual bool GetPeriodicity()\n\n"},
  {"SetThreshold", PyttkTriangulationManager_SetThreshold, METH_VARARGS,
   "SetThreshold(self, _arg:int) -> None\nC++: virtual void SetThreshold(int _arg)\n\n"},
  {"GetThreshold", PyttkTriangulationManager_GetThreshold, METH_VARARGS,
   "GetThreshold(self) -> int\nC++: virtual int GetThreshold()\n\n"},
  {"GetDataArraySelection", PyttkTriangulationManager_GetDataArraySelection, METH_VARARGS,
   "GetDataArraySelection(self) -> vtkDataArraySelection\nC++: vtkDataArraySelection *GetDataArraySelection()\n\n"},
  {"SetDataArraySelection", PyttkTriangulationManager_SetDataArraySelection, METH_VARARGS,
   "SetDataArraySelection(self, selection:vtkDataArraySelection)\n    -> None\nC++: void SetDataArraySelection(\n    const vtkSmartPointer<vtkDataArraySelection> &selection)\n\n"},
  {"IsTypeOf", PyttkTriangulationManager_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTriangulationManager_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTriangulationManager_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTriangulationManager\nC++: static ttkTriangulationManager *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTriangulationManager_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTriangulationManager\nC++: ttkTriangulationManager *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTriangulationManager_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTriangulationManager_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTriangulationManager_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("preconditioning_strategy"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationManager_SetPreconditioningStrategy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationManager_SetPreconditioningStrategy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPreconditioningStrategy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("periodicity"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTriangulationManager_GetPeriodicity(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationManager_SetPeriodicity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationManager_SetPeriodicity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPeriodicity/SetPeriodicity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTriangulationManager_GetThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationManager_SetThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationManager_SetThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThreshold/SetThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_array_selection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTriangulationManager_SetDataArraySelection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTriangulationManager_SetDataArraySelection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_array_selection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTriangulationManager_GetDataArraySelection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataArraySelection\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTriangulationManager_Doc =
  "ttkTriangulationManager - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Pierre Guillou <pierre.guillou@lip6.fr>\\date March 2022.\n\n"
  "TTK VTK-filter that manages ttk::Triangulation options.\n\n"
  "\\sa ttk::Triangulation\n"
  "\\sa ttkAlgorithm\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/clusteringKelvinHelmholtzInstabilities/\"\n"
  "  > Clustering Kelvin Helmholtz Instabilities example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/compactTriangulation/\"\n"
  "  > Compact Triangulation example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTriangulationManager_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTriangulationManager.ttkTriangulationManager", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTriangulationManager_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTriangulationManager_StaticNew()
{
  return ttkTriangulationManager::New();
}

PyObject *PyttkTriangulationManager_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTriangulationManager_Type, PyttkTriangulationManager_Methods,
    "ttkTriangulationManager",
 &PyttkTriangulationManager_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTriangulationManager_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTriangulationManager(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTriangulationManager_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTriangulationManager", o) != 0)
  {
    Py_DECREF(o);
  }

}

