/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkMorphologicalWatershedFromMarkersImageFilter.h"
#include "itkMorphologicalWatershedFromMarkersImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
MorphologicalWatershedFromMarkersImageFilter::MorphologicalWatershedFromMarkersImageFilter ()
{

  this->m_DualMemberFactory.reset( new detail::DualMemberFunctionFactory<MemberFunctionType>( this ) );
  using PixelIDTypeList2 = IntegerPixelIDTypeList;
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 3 > ();
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 2 > ();





}

//
// Destructor
//
MorphologicalWatershedFromMarkersImageFilter::~MorphologicalWatershedFromMarkersImageFilter() = default;

//
// ToString
//
std::string MorphologicalWatershedFromMarkersImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::MorphologicalWatershedFromMarkersImageFilter\n";
  out << "  MarkWatershedLine: ";
  this->ToStringHelper(out, this->m_MarkWatershedLine);
  out << std::endl;
  out << "  FullyConnected: ";
  this->ToStringHelper(out, this->m_FullyConnected);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}



//
// Execute
//
Image MorphologicalWatershedFromMarkersImageFilter::Execute ( const Image & image, const Image & markerImage )
{
  const PixelIDValueEnum type1 = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, markerImage, "markerImage" );
  CheckImageMatchingSize(  image, markerImage, "markerImage" );
  const PixelIDValueType type2 = markerImage.GetPixelIDValue();

  return this->m_DualMemberFactory->GetMemberFunction( type1, type2, dimension )( &image, &markerImage );
}




//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType, class TImageType2>
Image MorphologicalWatershedFromMarkersImageFilter::DualExecuteInternal ( const Image * inImage, const Image * inMarkerImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;
  using InputImageType2 = TImageType2;

  using OutputImageType = InputImageType;



  using FilterType = itk::MorphologicalWatershedFromMarkersImageFilter<InputImageType, InputImageType2>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  assert( inMarkerImage != nullptr );
  filter->SetMarkerImage( this->CastImageToITK<typename FilterType::LabelImageType>(*inMarkerImage) );


  filter->SetMarkWatershedLine ( this->m_MarkWatershedLine );
  filter->SetFullyConnected ( this->m_FullyConnected );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}




//-----------------------------------------------------------------------------

//
// Function to run the Execute method of this filter
//
Image MorphologicalWatershedFromMarkers ( const Image & image, const Image & markerImage, bool markWatershedLine, bool fullyConnected )
{
  MorphologicalWatershedFromMarkersImageFilter filter;
  filter.SetMarkWatershedLine( markWatershedLine );  filter.SetFullyConnected( fullyConnected );
  return filter.Execute ( image, markerImage );
}


}
