/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkLabelStatisticsImageFilter.h"
#include "itkLabelStatisticsImageFilter.h"

// Additional include files
#include "sitkMinimumMaximumImageFilter.h"
#include "algorithm"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
LabelStatisticsImageFilter::LabelStatisticsImageFilter ()
{

  this->m_DualMemberFactory.reset( new detail::DualMemberFunctionFactory<MemberFunctionType>( this ) );
  using PixelIDTypeList2 = IntegerPixelIDTypeList;
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 3 > ();
  this->m_DualMemberFactory->RegisterMemberFunctions< PixelIDTypeList, PixelIDTypeList2, 2 > ();





}

//
// Destructor
//
LabelStatisticsImageFilter::~LabelStatisticsImageFilter(){
  if (this->m_Filter != nullptr)
    {
      m_Filter->UnRegister();
    }
}


//
// ToString
//
std::string LabelStatisticsImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::LabelStatisticsImageFilter\n";
  out << "  UseHistograms: ";
  this->ToStringHelper(out, this->m_UseHistograms);
  out << std::endl;
  out << "  Labels: " << this->m_Labels << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}


//
// Custom Methods
//

bool LabelStatisticsImageFilter::HasLabel(int64_t label )
{
  return std::find(m_Labels.begin(),m_Labels.end(), label) != m_Labels.end();
}

uint64_t LabelStatisticsImageFilter::GetNumberOfLabels( )
{
  return m_Labels.size();
}


//
// Execute
//
void LabelStatisticsImageFilter::Execute ( const Image & image, const Image & labelImage )
{
  const PixelIDValueEnum type1 = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, labelImage, "labelImage" );
  CheckImageMatchingSize(  image, labelImage, "labelImage" );
  const PixelIDValueType type2 = labelImage.GetPixelIDValue();

  return this->m_DualMemberFactory->GetMemberFunction( type1, type2, dimension )( &image, &labelImage );
}




//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType, class TImageType2>
void LabelStatisticsImageFilter::DualExecuteInternal ( const Image * inImage, const Image * inLabelImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;
  using InputImageType2 = TImageType2;

  using OutputImageType = InputImageType;



  using FilterType = itk::LabelStatisticsImageFilter<InputImageType,InputImageType2>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  assert( inLabelImage != nullptr );
  filter->SetLabelInput( this->CastImageToITK<typename FilterType::LabelImageType>(*inLabelImage) );


  if( m_UseHistograms)
    {
    using PixelType = typename TImageType::PixelType;
    if( std::is_same< PixelType, uint8_t >::value || std::is_same< PixelType, int8_t >::value )
      {
      //NOTE:  This is a heuristic that works exact median only for
      //(unsigned) char images.
      filter->SetHistogramParameters(256,std::numeric_limits<PixelType>::min()-0.5,std::numeric_limits<PixelType>::max()+0.5 );
      }
    else
      {
      itk::simple::MinimumMaximumImageFilter stats;
      stats.Execute( *inImage );
      filter->SetHistogramParameters(256,stats.GetMinimum(), stats.GetMaximum() );
      }
    }




  // release the old filter ( and output data )
  if ( this->m_Filter != nullptr)
    {
      this->m_pfGetMinimum = nullptr;
      this->m_pfGetMaximum = nullptr;
      this->m_pfGetMean = nullptr;
      this->m_pfGetMedian = nullptr;
      this->m_pfGetSigma = nullptr;
      this->m_pfGetVariance = nullptr;
      this->m_pfGetSum = nullptr;
      this->m_pfGetCount = nullptr;
      this->m_pfGetBoundingBox = nullptr;
      this->m_pfGetRegion = nullptr;
      this->m_Filter->UnRegister();
      this->m_Filter = nullptr;
    }

  this->m_Filter = filter;
  this->m_Filter->Register();


  this->PreUpdate( filter.GetPointer() );

  this->m_pfGetMinimum = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetMinimum(std::forward<decltype(label)>(label));
    return value;
  };
  this->m_pfGetMaximum = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetMaximum(std::forward<decltype(label)>(label));
    return value;
  };
  this->m_pfGetMean = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetMean(std::forward<decltype(label)>(label));
    return value;
  };
  this->m_pfGetMedian = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetMedian(std::forward<decltype(label)>(label));
    return value;
  };
  this->m_pfGetSigma = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetSigma(std::forward<decltype(label)>(label));
    return value;
  };
  this->m_pfGetVariance = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetVariance(std::forward<decltype(label)>(label));
    return value;
  };
  this->m_pfGetSum = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetSum(std::forward<decltype(label)>(label));
    return value;
  };
  this->m_pfGetCount = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetCount(std::forward<decltype(label)>(label));
    return value;
  };
  this->m_pfGetBoundingBox = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetBoundingBox(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return std::vector<int>(value.begin(), value.end());
  };
  this->m_pfGetRegion = [ f = filter.GetPointer() ](auto && label) {
    const auto & value = f->GetRegion(std::forward<decltype(label)>(label));
    using T = typename std::remove_cv< typename std::remove_reference<decltype(value)>::type>::type;
    return sitkITKImageRegionToSTL(value);
  };


  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();

  const std::vector<typename FilterType::LabelPixelType> tempLabels = filter->GetValidLabelValues();
  this->m_Labels = std::vector<int64_t>(tempLabels.begin(), tempLabels.end());

  return;

}




//-----------------------------------------------------------------------------



}
