/* This file is part of GDB.

   Copyright 2002, 2007 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   --

   This file was generated by the program igen */

#ifndef ICACHE_C
#define ICACHE_C


#include "cpu.h"
#include "idecode.h"
#include "semantics.h"
#include "icache.h"
#ifdef HAVE_COMMON_FPU
#include "sim-inline.h"
#include "sim-fpu.h"
#endif
#include "support.h"


PSIM_INLINE_ICACHE\
(unsigned_word)
icache_illegal
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry)
{
  /* semantic routine */
#line 982 "../../sim/ppc/powerpc.igen"
  program_interrupt(processor, cia,
                    illegal_instruction_program_interrupt);
  error("Internal function must longjump\n");
  return 0;
#line 52 "icache.c"
}

PSIM_INLINE_ICACHE\
(unsigned_word)
icache_floating_point_unavailable
(cpu *processor,
 instruction_word instruction,
 unsigned_word cia,
 idecode_cache *cache_entry)
{
  /* semantic routine */
#line 990 "../../sim/ppc/powerpc.igen"
  floating_point_unavailable_interrupt(processor, cia);
  error("Internal function must longjump\n");
  return 0;
#line 68 "icache.c"
}


EXTERN_ICACHE\
(unsigned_word)
icache_instruction_call(cpu *processor,
                        instruction_word instruction,
                        unsigned_word cia,
                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_instruction_call
#undef MY_PREFIX
#define MY_PREFIX instruction_call
#line 1493 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode instruction_call\n"));
#line 85 "icache.c"

  /* validate: 0.0,6./,11./,16./,21./,31.1 */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x1)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.0,6./,11./,16./,21./,31.1 #define get-values-from-icache|put-values-in-icache */
#line 94 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_instruction_call;

    /* semantic routine */
#line 1493 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics instruction_call\n"));
#line 104 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_instruction_call, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1493 "../../sim/ppc/powerpc.igen"
    {
      if (!os_emul_instruction_call(processor, cia, real_addr(cia, 1)))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
    }
#line 119 "icache.c"
    return nia;
    /* extraction: 0.0,6./,11./,16./,21./,31.1 #undef get-values-from-icache|put-values-in-icache */
#line 122 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Trap_Word_Immediate(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Trap_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Trap_Word_Immediate
#line 2897 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Trap Word Immediate\n"));
#line 141 "icache.c"

  /* validate: 0.3,6.TO,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0xc000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.3,6.TO,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 2897 "../../sim/ppc/powerpc.igen"
    unsigned const TO ATTRIBUTE_UNUSED = cache_entry->crack.D.TO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 161 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Trap_Word_Immediate;

    /* semantic routine */
#line 2897 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Trap Word Immediate\n"));
#line 171 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Trap_Word_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2897 "../../sim/ppc/powerpc.igen"
    {
      signed_word a = EXTENDED(*rA);
      signed_word b = EXTS(SI);
      if ((a < b && TO_0_)
          || (a > b && TO_1_)
          || (a == b && TO_2_)
          || ((unsigned_word)a < (unsigned_word)b && TO_3_)
          || ((unsigned_word)a > (unsigned_word)b && TO_4_)
          )
        program_interrupt(processor, cia,
                          trap_program_interrupt);
    }
#line 193 "icache.c"
    return nia;
    /* extraction: 0.3,6.TO,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 197 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_Low_Immediate(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Immediate
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Immediate
#line 2687 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply Low Immediate\n"));
#line 216 "icache.c"

  /* validate: 0.7,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x1c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.7,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 240 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_Low_Immediate;

    /* semantic routine */
#line 2687 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply Low Immediate\n"));
#line 250 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_Low_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2687 "../../sim/ppc/powerpc.igen"
    {
      signed_word prod = *rA * EXTS(SI);
      *rT = prod;
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
    }
#line 265 "icache.c"
    return nia;
    /* extraction: 0.7,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 269 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Immediate_Carrying(cpu *processor,
                                        instruction_word instruction,
                                        unsigned_word cia,
                                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Immediate_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Immediate_Carrying
#line 2574 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Immediate Carrying\n"));
#line 288 "icache.c"

  /* validate: 0.8,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x20000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.8,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 312 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Immediate_Carrying;

    /* semantic routine */
#line 2574 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Immediate Carrying\n"));
#line 322 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Immediate_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2574 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(EXTS(SI));
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, 0/*OE*/, 0/*Rc*/);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
    }
#line 340 "icache.c"
    return nia;
    /* extraction: 0.8,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 344 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Compare_Logical_Immediate(cpu *processor,
                                 instruction_word instruction,
                                 unsigned_word cia,
                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Logical_Immediate
#undef MY_PREFIX
#define MY_PREFIX Compare_Logical_Immediate
#line 2833 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Compare Logical Immediate\n"));
#line 363 "icache.c"

  /* validate: 0.10,6.BF,9./,10.L,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc400000) != 0x28000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.10,6.BF,9./,10.L,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 67 "../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.D.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 2833 "../../sim/ppc/powerpc.igen"
    unsigned const L ATTRIBUTE_UNUSED = cache_entry->crack.D.L = EXTRACTED32(instruction, 10, 10); /* default in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2833 "../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 387 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Compare_Logical_Immediate;

    /* semantic routine */
#line 2833 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Compare Logical Immediate\n"));
#line 397 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Compare_Logical_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2833 "../../sim/ppc/powerpc.igen"
    {
      if (!is_64bit_mode && L)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        unsigned_word a;
        unsigned_word b = UI;
        if (L == 0)
          a = MASKED(*rA, 32, 63);
        else
          a = *rA;
        CR_COMPARE(BF, a, b);
      }
      PPC_INSN_INT_CR(0, RA_BITMASK, BF_BITMASK);
    }
#line 422 "icache.c"
    return nia;
    /* extraction: 0.10,6.BF,9./,10.L,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 426 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Compare_Immediate(cpu *processor,
                         instruction_word instruction,
                         unsigned_word cia,
                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Immediate
#undef MY_PREFIX
#define MY_PREFIX Compare_Immediate
#line 2791 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Compare Immediate\n"));
#line 445 "icache.c"

  /* validate: 0.11,6.BF,9./,10.L,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc400000) != 0x2c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.11,6.BF,9./,10.L,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 67 "../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.D.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 2791 "../../sim/ppc/powerpc.igen"
    unsigned const L ATTRIBUTE_UNUSED = cache_entry->crack.D.L = EXTRACTED32(instruction, 10, 10); /* default in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 469 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Compare_Immediate;

    /* semantic routine */
#line 2791 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Compare Immediate\n"));
#line 479 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Compare_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2791 "../../sim/ppc/powerpc.igen"
    {
      if (!is_64bit_mode && L)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        signed_word a;
        signed_word b = EXTS(SI);
        if (L == 0)
          a = EXTENDED(*rA);
        else
          a = *rA;
        CR_COMPARE(BF, a, b);
      }
      PPC_INSN_INT_CR(0, RA_BITMASK, BF_BITMASK);
    }
#line 504 "icache.c"
    return nia;
    /* extraction: 0.11,6.BF,9./,10.L,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 508 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_Carrying(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Carrying
#line 2554 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate Carrying\n"));
#line 527 "icache.c"

  /* validate: 0.12,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x30000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.12,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 551 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_Carrying;

    /* semantic routine */
#line 2554 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate Carrying\n"));
#line 561 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2554 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(EXTS(SI));
      ALU_END(*rT, 1/*CA*/, 0/*OE*/, 0/*Rc*/);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 0/*Rc*/);
    }
#line 577 "icache.c"
    return nia;
    /* extraction: 0.12,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 581 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_Carrying_and_Record(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Carrying_and_Record
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Carrying_and_Record
#line 2564 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate Carrying and Record\n"));
#line 600 "icache.c"

  /* validate: 0.13,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x34000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.13,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 624 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_Carrying_and_Record;

    /* semantic routine */
#line 2564 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate Carrying and Record\n"));
#line 634 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate_Carrying_and_Record, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2564 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(EXTS(SI));
      ALU_END(*rT, 1/*CA*/, 0/*OE*/, 1/*Rc*/);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, 1/*Rc*/);
    }
#line 650 "icache.c"
    return nia;
    /* extraction: 0.13,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 654 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_RA0(cpu *processor,
                         instruction_word instruction,
                         unsigned_word cia,
                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_RA0
#line 2512 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate\n"));
#line 673 "icache.c"

  /* validate: 0.14,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x38000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.14,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = 0; /* in icache - constant field */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 1 /* RA == 0 */ /* semantic compute - constant compare */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 697 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_RA0;

    /* semantic routine */
#line 2512 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate\n"));
#line 707 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2512 "../../sim/ppc/powerpc.igen"
    {
      if (RA_is_0)	*rT = EXTS(SI);
      else		*rT = *rA + EXTS(SI);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
    }
#line 723 "icache.c"
    return nia;
    /* extraction: 0.14,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 727 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_RA(cpu *processor,
                        instruction_word instruction,
                        unsigned_word cia,
                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_RA
#line 2512 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate\n"));
#line 746 "icache.c"

  /* validate: 0.14,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x38000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.14,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 0 /* RA == 0 */ /* semantic compute - constant compare */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 770 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_RA;

    /* semantic routine */
#line 2512 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate\n"));
#line 780 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2512 "../../sim/ppc/powerpc.igen"
    {
      if (RA_is_0)	*rT = EXTS(SI);
      else		*rT = *rA + EXTS(SI);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
    }
#line 796 "icache.c"
    return nia;
    /* extraction: 0.14,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 800 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_Shifted_RA0(cpu *processor,
                                 instruction_word instruction,
                                 unsigned_word cia,
                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Shifted_RA0
#line 2522 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate Shifted\n"));
#line 819 "icache.c"

  /* validate: 0.15,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x3c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.15,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = 0; /* in icache - constant field */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 1 /* RA == 0 */ /* semantic compute - constant compare */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 843 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_Shifted_RA0;

    /* semantic routine */
#line 2522 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate Shifted\n"));
#line 853 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2522 "../../sim/ppc/powerpc.igen"
    {
      if (RA_is_0)	*rT = EXTS(SI) << 16;
      else		*rT = *rA + (EXTS(SI) << 16);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
    }
#line 869 "icache.c"
    return nia;
    /* extraction: 0.15,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 873 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Immediate_Shifted_RA(cpu *processor,
                                instruction_word instruction,
                                unsigned_word cia,
                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX Add_Immediate_Shifted_RA
#line 2522 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Immediate Shifted\n"));
#line 892 "icache.c"

  /* validate: 0.15,6.RT,11.RA,16.SI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x3c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.15,6.RT,11.RA,16.SI #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.D.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.D.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 0 /* RA == 0 */ /* semantic compute - constant compare */
#line 64 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_SI ATTRIBUTE_UNUSED = cache_entry->crack.D.EXTS_SI = ((signed_word)(int16_t)instruction); /* in icache - extraction */
#line 916 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Immediate_Shifted_RA;

    /* semantic routine */
#line 2522 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Immediate Shifted\n"));
#line 926 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2522 "../../sim/ppc/powerpc.igen"
    {
      if (RA_is_0)	*rT = EXTS(SI) << 16;
      else		*rT = *rA + (EXTS(SI) << 16);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rT, (long)*rT));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1), 0);
    }
#line 942 "icache.c"
    return nia;
    /* extraction: 0.15,6.RT,11.RA,16.SI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 946 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO0
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 965 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 985 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO0;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 995 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1044 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1048 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO1
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1067 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1087 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO1;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1097 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1146 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1150 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO2(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO2
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1169 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 2; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1189 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO2;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1199 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1248 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1252 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO3(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO3
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1271 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 3; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1291 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO3;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1301 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1350 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1354 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO4(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO4
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1373 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 4; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1393 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO4;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1403 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1452 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1456 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO5(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO5
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1475 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 5; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1495 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO5;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1505 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1554 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1558 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO6(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO6
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1577 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 6; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1597 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO6;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1607 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1656 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1660 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO7(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO7
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1679 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 7; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1699 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO7;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1709 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1758 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1762 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO8(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO8
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1781 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 8; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1801 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO8;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1811 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1860 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1864 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO9(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO9
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1883 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 9; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1903 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO9;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 1913 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 1962 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 1966 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO10(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO10
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 1985 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 10; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2005 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO10;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2015 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2064 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2068 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO11(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO11
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2087 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 11; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2107 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO11;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2117 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2166 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2170 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO12(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO12
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2189 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 12; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2209 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO12;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2219 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2268 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2272 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO13(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO13
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2291 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 13; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2311 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO13;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2321 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2370 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2374 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO14(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO14
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2393 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 14; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2413 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO14;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2423 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2472 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2476 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO15(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO15
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2495 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 15; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2515 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO15;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2525 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2574 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2578 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO16(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO16
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2597 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 16; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2617 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO16;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2627 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2676 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2680 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO17(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO17
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2699 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 17; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2719 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO17;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2729 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2778 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2782 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO18(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO18
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2801 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 18; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2821 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO18;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2831 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2880 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2884 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO19(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO19
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 2903 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 19; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2923 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO19;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 2933 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 2982 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 2986 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO20(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO20
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3005 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 20; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3025 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO20;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3035 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3084 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3088 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO21(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO21
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3107 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 21; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3127 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO21;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3137 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3186 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3190 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO22(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO22
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3209 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 22; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3229 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO22;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3239 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3288 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3292 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO23(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO23
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3311 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 23; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3331 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO23;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3341 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3390 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3394 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO24(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO24
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3413 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 24; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3433 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO24;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3443 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3492 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3496 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO25(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO25
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3515 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 25; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3535 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO25;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3545 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3594 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3598 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO26(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO26
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3617 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 26; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3637 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO26;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3647 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3696 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3700 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO27(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO27
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3719 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 27; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3739 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO27;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3749 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3798 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3802 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO28(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO28
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3821 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 28; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3841 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO28;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3851 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 3900 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 3904 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO29(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO29
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 3923 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 29; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 3943 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO29;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 3953 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4002 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4006 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO30(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO30
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4025 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 30; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 4045 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO30;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4055 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4104 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4108 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK0_BO31(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK0_BO31
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4127 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 31; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 4147 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK0_BO31;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4157 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4206 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4210 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO0
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4229 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4249 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO0;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4259 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4308 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4312 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO1
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4331 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4351 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO1;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4361 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4410 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4414 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO2(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO2
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4433 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 2; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4453 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO2;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4463 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4512 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4516 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO3(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO3
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4535 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 3; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4555 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO3;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4565 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4614 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4618 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO4(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO4
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4637 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 4; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4657 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO4;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4667 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4716 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4720 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO5(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO5
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4739 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 5; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4759 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO5;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4769 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4818 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4822 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO6(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO6
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4841 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 6; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4861 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO6;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4871 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 4920 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 4924 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO7(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO7
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 4943 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 7; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 4963 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO7;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 4973 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5022 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5026 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO8(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO8
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5045 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 8; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5065 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO8;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5075 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5124 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5128 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO9(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO9
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5147 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 9; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5167 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO9;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5177 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5226 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5230 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO10(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO10
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5249 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 10; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5269 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO10;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5279 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5328 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5332 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO11(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO11
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5351 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 11; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5371 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO11;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5381 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5430 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5434 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO12(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO12
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5453 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 12; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5473 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO12;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5483 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5532 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5536 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO13(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO13
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5555 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 13; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5575 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO13;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5585 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5634 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5638 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO14(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO14
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5657 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 14; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5677 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO14;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5687 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5736 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5740 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO15(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO15
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5759 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 15; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5779 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO15;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5789 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5838 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5842 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO16(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO16
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5861 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 16; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5881 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO16;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5891 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 5940 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 5944 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO17(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO17
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 5963 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 17; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 5983 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO17;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 5993 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6042 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6046 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO18(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO18
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6065 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 18; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6085 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO18;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6095 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6144 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6148 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO19(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO19
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6167 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 19; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6187 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO19;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6197 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6246 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6250 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO20(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO20
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6269 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 20; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6289 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO20;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6299 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6348 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6352 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO21(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO21
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6371 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 21; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6391 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO21;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6401 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6450 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6454 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO22(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO22
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6473 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 22; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6493 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO22;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6503 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6552 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6556 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO23(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO23
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6575 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 23; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6595 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO23;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6605 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6654 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6658 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO24(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO24
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6677 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 24; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6697 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO24;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6707 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6756 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6760 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO25(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO25
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6779 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 25; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6799 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO25;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6809 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6858 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6862 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO26(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO26
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6881 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 26; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 6901 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO26;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 6911 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 6960 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 6964 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO27(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO27
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 6983 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 27; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7003 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO27;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7013 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7062 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7066 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO28(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO28
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7085 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 28; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7105 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO28;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7115 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7164 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7168 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO29(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO29
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7187 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 29; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7207 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO29;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7217 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7266 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7270 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO30(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO30
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7289 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 30; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7309 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO30;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7319 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7368 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7372 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA0_LK1_BO31(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA0_LK1_BO31
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7391 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 31; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 7411 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA0_LK1_BO31;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7421 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7470 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7474 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO0
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7493 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7513 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO0;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7523 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7572 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7576 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO1
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7595 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7615 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO1;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7625 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7674 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7678 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO2(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO2
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7697 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 2; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7717 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO2;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7727 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7776 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7780 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO3(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO3
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7799 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 3; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7819 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO3;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7829 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7878 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7882 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO4(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO4
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 7901 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 4; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 7921 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO4;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 7931 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 7980 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 7984 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO5(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO5
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8003 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 5; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8023 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO5;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8033 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8082 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8086 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO6(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO6
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8105 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 6; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8125 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO6;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8135 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8184 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8188 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO7(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO7
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8207 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 7; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8227 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO7;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8237 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8286 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8290 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO8(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO8
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8309 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 8; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8329 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO8;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8339 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8388 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8392 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO9(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO9
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8411 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 9; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8431 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO9;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8441 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8490 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8494 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO10(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO10
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8513 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 10; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8533 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO10;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8543 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8592 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8596 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO11(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO11
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8615 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 11; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8635 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO11;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8645 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8694 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8698 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO12(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO12
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8717 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 12; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8737 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO12;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8747 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8796 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8800 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO13(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO13
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8819 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 13; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8839 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO13;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8849 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 8898 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 8902 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO14(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO14
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 8921 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 14; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 8941 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO14;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 8951 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9000 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9004 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO15(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO15
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9023 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 15; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9043 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO15;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9053 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9102 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9106 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO16(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO16
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9125 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 16; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9145 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO16;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9155 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9204 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9208 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO17(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO17
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9227 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 17; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9247 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO17;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9257 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9306 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9310 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO18(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO18
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9329 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 18; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9349 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO18;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9359 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9408 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9412 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO19(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO19
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9431 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 19; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9451 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO19;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9461 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9510 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9514 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO20(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO20
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9533 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 20; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9553 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO20;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9563 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9612 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9616 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO21(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO21
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9635 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 21; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9655 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO21;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9665 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9714 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9718 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO22(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO22
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9737 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 22; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9757 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO22;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9767 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9816 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9820 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO23(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO23
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9839 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 23; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9859 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO23;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9869 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 9918 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 9922 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO24(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO24
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 9941 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 24; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 9961 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO24;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 9971 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10020 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10024 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO25(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO25
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10043 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 25; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10063 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO25;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10073 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10122 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10126 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO26(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO26
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10145 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 26; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10165 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO26;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10175 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10224 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10228 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO27(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO27
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10247 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 27; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10267 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO27;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10277 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10326 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10330 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO28(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO28
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10349 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 28; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10369 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO28;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10379 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10428 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10432 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO29(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO29
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10451 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 29; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10471 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO29;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10481 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10530 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10534 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO30(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO30
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10553 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 30; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10573 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO30;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10583 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10632 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10636 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK0_BO31(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK0_BO31
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10655 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 31; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 10675 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK0_BO31;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10685 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10734 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10738 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO0
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10757 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 10777 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO0;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10787 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10836 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10840 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO1
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10859 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 10879 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO1;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10889 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 10938 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 10942 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO2(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO2
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 10961 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 2; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 10981 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO2;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 10991 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11040 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11044 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO3(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO3
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11063 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 3; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11083 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO3;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11093 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11142 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11146 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO4(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO4
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11165 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 4; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11185 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO4;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11195 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11244 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11248 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO5(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO5
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11267 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 5; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11287 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO5;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11297 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11346 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11350 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO6(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO6
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11369 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 6; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11389 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO6;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11399 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11448 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11452 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO7(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO7
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11471 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 7; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11491 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO7;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11501 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11550 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11554 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO8(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO8
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11573 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 8; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11593 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO8;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11603 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11652 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11656 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO9(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO9
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11675 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 9; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11695 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO9;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11705 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11754 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11758 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO10(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO10
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11777 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 10; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11797 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO10;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11807 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11856 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11860 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO11(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO11
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11879 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 11; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 11899 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO11;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 11909 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 11958 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 11962 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO12(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO12
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 11981 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 12; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12001 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO12;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12011 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12060 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12064 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO13(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO13
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12083 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 13; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12103 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO13;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12113 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12162 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12166 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO14(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO14
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12185 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 14; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12205 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO14;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12215 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12264 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12268 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO15(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO15
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12287 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 15; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12307 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO15;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12317 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12366 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12370 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO16(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO16
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12389 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 16; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12409 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO16;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12419 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12468 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12472 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO17(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO17
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12491 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 17; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12511 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO17;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12521 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12570 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12574 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO18(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO18
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12593 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 18; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12613 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO18;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12623 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12672 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12676 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO19(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO19
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12695 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 19; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12715 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO19;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12725 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12774 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12778 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO20(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO20
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12797 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 20; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12817 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO20;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12827 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12876 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12880 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO21(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO21
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 12899 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 21; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 12919 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO21;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 12929 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 12978 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 12982 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO22(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO22
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13001 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 22; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13021 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO22;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13031 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13080 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13084 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO23(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO23
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13103 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 23; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13123 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO23;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13133 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13182 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13186 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO24(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO24
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13205 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 24; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13225 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO24;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13235 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13284 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13288 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO25(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO25
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13307 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 25; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13327 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO25;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13337 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13386 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13390 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO26(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO26
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13409 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 26; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13429 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO26;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13439 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13488 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13492 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO27(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO27
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13511 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 27; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13531 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO27;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13541 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13590 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13594 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO28(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO28
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13613 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 28; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13633 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO28;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13643 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13692 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13696 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO29(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO29
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13715 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 29; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13735 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO29;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13745 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13794 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13798 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO30(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO30
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13817 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 30; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13837 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO30;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13847 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13896 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 13900 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_AA1_LK1_BO31(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_AA1_LK1_BO31
#line 1518 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional\n"));
#line 13919 "icache.c"

  /* validate: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x40000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = 31; /* default in icache - constant field */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.B.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 77 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_BD_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.B.EXTS_BD_0b00 = (((signed_word)(int16_t)instruction) & ~3); /* in icache - extraction */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1518 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 13939 "icache.c"

#define insn cache_entry->crack.B.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_AA1_LK1_BO31;

    /* semantic routine */
#line 1518 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional\n"));
#line 13949 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1518 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != (BO_3_));
      cond_ok = BO_0_ || ((CR_BI_) == (BO_1_));
      if (ctr_ok && cond_ok) {
        if (AA) NIA = IEA(EXTS(BD_0b00));
        else    NIA = IEA(CIA + EXTS(BD_0b00));
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as "normal".
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), succeed, BO);
      if (! BO_0_) {
        int reverse;
        if (BO_4_) {	/* branch prediction bit set, reverse sense of test */
          reverse = EXTS(BD_0b00) < 0;
        } else {	/* branch prediction bit not set */
          reverse = EXTS(BD_0b00) >= 0;
        }
        if (CURRENT_MODEL_ISSUE > 0)
          model_branch_predict(cpu_model(processor), reverse ? !succeed : succeed);
      }
    }
#line 13998 "icache.c"
    return nia;
    /* extraction: 0.16,6.BO,11.BI,16.BD,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 14002 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_System_Call(cpu *processor,
                   instruction_word instruction,
                   unsigned_word cia,
                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_System_Call
#undef MY_PREFIX
#define MY_PREFIX System_Call
#line 1630 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode System Call\n"));
#line 14021 "icache.c"

  /* validate: 0.17,6./,11./,16./,30.1,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x44000002)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.17,6./,11./,16./,30.1,31./ #define get-values-from-icache|put-values-in-icache */
#line 14030 "icache.c"

#define insn cache_entry->crack.SC.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_System_Call;

    /* semantic routine */
#line 1630 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics System Call\n"));
#line 14040 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_System_Call, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1630 "../../sim/ppc/powerpc.igen"
    {
      if (CURRENT_MODEL_ISSUE > 0)
        model_serialize(MY_INDEX, cpu_model(processor));
      system_call_interrupt(processor, cia);
    }
#line 14055 "icache.c"
    return nia;
    /* extraction: 0.17,6./,11./,16./,30.1,31./ #undef get-values-from-icache|put-values-in-icache */
#line 14058 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_AA0_LK0(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA0_LK0
#line 1505 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch\n"));
#line 14077 "icache.c"

  /* validate: 0.18,6.LI,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x48000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 78 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_LI_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.I.EXTS_LI_0b00 = ((((signed_word)(int32_t)(instruction << 6)) >> 6) & ~0x3); /* in icache - extraction */
#line 1505 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1505 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 14092 "icache.c"

#define insn cache_entry->crack.I.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_AA0_LK0;

    /* semantic routine */
#line 1505 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch\n"));
#line 14102 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1505 "../../sim/ppc/powerpc.igen"
    {
      /* option_mpc860c0:
      No problem here because this branch is predicted taken (unconditional). */
      if (AA) NIA = IEA(EXTS(LI_0b00));
      else    NIA = IEA(CIA + EXTS(LI_0b00));
      if (LK) LR = (spreg)CIA+4;
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), 1, -1);
    }
#line 14121 "icache.c"
    return nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#line 14124 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_AA0_LK1(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA0_LK1
#line 1505 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch\n"));
#line 14143 "icache.c"

  /* validate: 0.18,6.LI,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x48000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 78 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_LI_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.I.EXTS_LI_0b00 = ((((signed_word)(int32_t)(instruction << 6)) >> 6) & ~0x3); /* in icache - extraction */
#line 1505 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 1505 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 14158 "icache.c"

#define insn cache_entry->crack.I.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_AA0_LK1;

    /* semantic routine */
#line 1505 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch\n"));
#line 14168 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1505 "../../sim/ppc/powerpc.igen"
    {
      /* option_mpc860c0:
      No problem here because this branch is predicted taken (unconditional). */
      if (AA) NIA = IEA(EXTS(LI_0b00));
      else    NIA = IEA(CIA + EXTS(LI_0b00));
      if (LK) LR = (spreg)CIA+4;
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), 1, -1);
    }
#line 14187 "icache.c"
    return nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#line 14190 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_AA1_LK0(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA1_LK0
#line 1505 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch\n"));
#line 14209 "icache.c"

  /* validate: 0.18,6.LI,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x48000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 78 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_LI_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.I.EXTS_LI_0b00 = ((((signed_word)(int32_t)(instruction << 6)) >> 6) & ~0x3); /* in icache - extraction */
#line 1505 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1505 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 14224 "icache.c"

#define insn cache_entry->crack.I.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_AA1_LK0;

    /* semantic routine */
#line 1505 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch\n"));
#line 14234 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1505 "../../sim/ppc/powerpc.igen"
    {
      /* option_mpc860c0:
      No problem here because this branch is predicted taken (unconditional). */
      if (AA) NIA = IEA(EXTS(LI_0b00));
      else    NIA = IEA(CIA + EXTS(LI_0b00));
      if (LK) LR = (spreg)CIA+4;
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), 1, -1);
    }
#line 14253 "icache.c"
    return nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#line 14256 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_AA1_LK1(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch
#undef MY_PREFIX
#define MY_PREFIX Branch_AA1_LK1
#line 1505 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch\n"));
#line 14275 "icache.c"

  /* validate: 0.18,6.LI,30.AA,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x48000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #define get-values-from-icache|put-values-in-icache */
#line 78 "../../sim/ppc/powerpc.igen"
    unsigned_word const EXTS_LI_0b00 ATTRIBUTE_UNUSED = cache_entry->crack.I.EXTS_LI_0b00 = ((((signed_word)(int32_t)(instruction << 6)) >> 6) & ~0x3); /* in icache - extraction */
#line 1505 "../../sim/ppc/powerpc.igen"
    unsigned const AA ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 1505 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 14290 "icache.c"

#define insn cache_entry->crack.I.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_AA1_LK1;

    /* semantic routine */
#line 1505 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch\n"));
#line 14300 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1505 "../../sim/ppc/powerpc.igen"
    {
      /* option_mpc860c0:
      No problem here because this branch is predicted taken (unconditional). */
      if (AA) NIA = IEA(EXTS(LI_0b00));
      else    NIA = IEA(CIA + EXTS(LI_0b00));
      if (LK) LR = (spreg)CIA+4;
      if (CURRENT_MODEL_ISSUE > 0)
        model_branches(cpu_model(processor), 1, -1);
    }
#line 14319 "icache.c"
    return nia;
    /* extraction: 0.18,6.LI,30.AA,31.LK #undef get-values-from-icache|put-values-in-icache */
#line 14322 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_Condition_Register_Field(cpu *processor,
                                     instruction_word instruction,
                                     unsigned_word cia,
                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_Condition_Register_Field
#undef MY_PREFIX
#define MY_PREFIX Move_Condition_Register_Field
#line 1709 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move Condition Register Field\n"));
#line 14341 "icache.c"

  /* validate: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc63ffff) != 0x4c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ #define get-values-from-icache|put-values-in-icache */
#line 67 "../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.XL.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 1709 "../../sim/ppc/powerpc.igen"
    unsigned const BFA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BFA = EXTRACTED32(instruction, 11, 13); /* default in icache - extraction */
#line 14356 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_Condition_Register_Field;

    /* semantic routine */
#line 1709 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move Condition Register Field\n"));
#line 14366 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_Condition_Register_Field, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1709 "../../sim/ppc/powerpc.igen"
    {
      MBLIT32(CR, 4*BF, 4*BF+3, EXTRACTED32(CR, 4*BFA, 4*BFA+3));
      PPC_INSN_CR(BF_BITMASK, 1 << BFA);
    }
#line 14380 "icache.c"
    return nia;
    /* extraction: 0.19,6.BF,9./,11.BFA,14./,16./,21.0,31./ #undef get-values-from-icache|put-values-in-icache */
#line 14383 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_to_Link_Register_LK0(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Link_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Link_Register_LK0
#line 1561 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional to Link Register\n"));
#line 14402 "icache.c"

  /* validate: 0.19,6.BO,11.BI,16./,21.16,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x4c000020)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1561 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = cache_entry->crack.XL.BO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 1561 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 14418 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_to_Link_Register_LK0;

    /* semantic routine */
#line 1561 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional to Link Register\n"));
#line 14428 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional_to_Link_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1561 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != BO_3_);
      cond_ok = BO_0_ || (CR_BI_ == BO_1_);
      if (ctr_ok && cond_ok) {
        NIA = IEA(LR_0b00);
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as not-taken.
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0) {
        model_branches(cpu_model(processor), succeed, BO);
        if (! BO_0_)
          model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
      }
    }
#line 14469 "icache.c"
    return nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 14473 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_to_Link_Register_LK1(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Link_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Link_Register_LK1
#line 1561 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional to Link Register\n"));
#line 14492 "icache.c"

  /* validate: 0.19,6.BO,11.BI,16./,21.16,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x4c000020)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1561 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = cache_entry->crack.XL.BO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 1561 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 14508 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_to_Link_Register_LK1;

    /* semantic routine */
#line 1561 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional to Link Register\n"));
#line 14518 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional_to_Link_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1561 "../../sim/ppc/powerpc.igen"
    {
      int M, ctr_ok, cond_ok, succeed;
      if (is_64bit_implementation && is_64bit_mode) M = 0;
      else                                          M = 32;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      if (!BO_2_) CTR = CTR - 1;
      ctr_ok = BO_2_ || ((MASKED(CTR, M, 63) != 0) != BO_3_);
      cond_ok = BO_0_ || (CR_BI_ == BO_1_);
      if (ctr_ok && cond_ok) {
        NIA = IEA(LR_0b00);
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as not-taken.
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0) {
        model_branches(cpu_model(processor), succeed, BO);
        if (! BO_0_)
          model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
      }
    }
#line 14559 "icache.c"
    return nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.16,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 14563 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_NOR(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_NOR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_NOR
#line 1674 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register NOR\n"));
#line 14582 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.33,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000042)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.33,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 14605 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_NOR;

    /* semantic routine */
#line 1674 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register NOR\n"));
#line 14615 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_NOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1674 "../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, !(CR_BA_ || CR_BB_));
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 14629 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.33,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 14634 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Return_From_Interrupt(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Return_From_Interrupt
#undef MY_PREFIX
#define MY_PREFIX Return_From_Interrupt
#line 4861 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Return From Interrupt\n"));
#line 14653 "icache.c"

  /* validate: 0.19,6./,11./,16./,21.50,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x4c000064)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6./,11./,16./,21.50,31./ #define get-values-from-icache|put-values-in-icache */
#line 14662 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Return_From_Interrupt;

    /* semantic routine */
#line 4861 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Return From Interrupt\n"));
#line 14672 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Return_From_Interrupt, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4861 "../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor)) {
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      }
      else {
        MSR = (MASKED(SRR1, 0, 32)
               | MASKED(SRR1, 37, 41)
               | MASKED(SRR1, 48, 63));
        NIA = MASKED(SRR0, 0, 61);
        cpu_synchronize_context(processor, cia);
        check_masked_interrupts(processor);
      }
    }
#line 14696 "icache.c"
    return nia;
    /* extraction: 0.19,6./,11./,16./,21.50,31./ #undef get-values-from-icache|put-values-in-icache */
#line 14699 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_AND_with_Complement(cpu *processor,
                                              instruction_word instruction,
                                              unsigned_word cia,
                                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_AND_with_Complement
#line 1690 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register AND with Complement\n"));
#line 14718 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.129,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000102)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.129,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 14741 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_AND_with_Complement;

    /* semantic routine */
#line 1690 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register AND with Complement\n"));
#line 14751 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_AND_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1690 "../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ && !CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 14765 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.129,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 14770 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Instruction_Synchronize(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Instruction_Synchronize
#undef MY_PREFIX
#define MY_PREFIX Instruction_Synchronize
#line 4774 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Instruction Synchronize\n"));
#line 14789 "icache.c"

  /* validate: 0.19,6./,11./,16./,21.150,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x4c00012c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6./,11./,16./,21.150,31./ #define get-values-from-icache|put-values-in-icache */
#line 14798 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Instruction_Synchronize;

    /* semantic routine */
#line 4774 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Instruction Synchronize\n"));
#line 14808 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Instruction_Synchronize, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4774 "../../sim/ppc/powerpc.igen"
    {
      cpu_synchronize_context(processor, cia);
      PPC_INSN_INT(0, 0, 0);
    }
#line 14822 "icache.c"
    return nia;
    /* extraction: 0.19,6./,11./,16./,21.150,31./ #undef get-values-from-icache|put-values-in-icache */
#line 14825 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_XOR(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_XOR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_XOR
#line 1658 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register XOR\n"));
#line 14844 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.193,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000182)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.193,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 14867 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_XOR;

    /* semantic routine */
#line 1658 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register XOR\n"));
#line 14877 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_XOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1658 "../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ != CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 14891 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.193,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 14896 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_NAND(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_NAND
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_NAND
#line 1666 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register NAND\n"));
#line 14915 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.225,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c0001c2)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.225,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 14938 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_NAND;

    /* semantic routine */
#line 1666 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register NAND\n"));
#line 14948 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_NAND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1666 "../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, !(CR_BA_ && CR_BB_));
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 14962 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.225,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 14967 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_AND(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_AND
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_AND
#line 1642 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register AND\n"));
#line 14986 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.257,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000202)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.257,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 15009 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_AND;

    /* semantic routine */
#line 1642 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register AND\n"));
#line 15019 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_AND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1642 "../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ && CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 15033 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.257,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 15038 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_Equivalent(cpu *processor,
                                     instruction_word instruction,
                                     unsigned_word cia,
                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_Equivalent
#line 1682 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register Equivalent\n"));
#line 15057 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.289,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000242)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.289,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 15080 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_Equivalent;

    /* semantic routine */
#line 1682 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register Equivalent\n"));
#line 15090 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_Equivalent, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1682 "../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ == CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 15104 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.289,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 15109 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_OR_with_Complement(cpu *processor,
                                             instruction_word instruction,
                                             unsigned_word cia,
                                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_OR_with_Complement
#line 1698 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register OR with Complement\n"));
#line 15128 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.417,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000342)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.417,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 15151 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_OR_with_Complement;

    /* semantic routine */
#line 1698 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register OR with Complement\n"));
#line 15161 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_OR_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1698 "../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ || !CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 15175 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.417,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 15180 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Condition_Register_OR(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Condition_Register_OR
#undef MY_PREFIX
#define MY_PREFIX Condition_Register_OR
#line 1650 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Condition Register OR\n"));
#line 15199 "icache.c"

  /* validate: 0.19,6.BT,11.BA,16.BB,21.449,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x4c000382)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.449,31./ #define get-values-from-icache|put-values-in-icache */
#line 75 "../../sim/ppc/powerpc.igen"
    unsigned const BT ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 76 "../../sim/ppc/powerpc.igen"
    uint32_t const BT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BT_BITMASK = (1 << BT); /* in icache - extraction */
#define BA EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 70 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BA ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BA = BIT32(BA); /* in icache - extraction */
#line 71 "../../sim/ppc/powerpc.igen"
    uint32_t const BA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BA_BITMASK = (1 << BA); /* in icache - extraction */
#define BB EXTRACTED32(instruction, 16, 20) /* icache scratch - extraction */
#line 73 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BB ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BB = BIT32(BB); /* in icache - extraction */
#line 74 "../../sim/ppc/powerpc.igen"
    uint32_t const BB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XL.BB_BITMASK = (1 << BB); /* in icache - extraction */
#line 15222 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Condition_Register_OR;

    /* semantic routine */
#line 1650 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Condition Register OR\n"));
#line 15232 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Condition_Register_OR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1650 "../../sim/ppc/powerpc.igen"
    {
      BLIT32(CR, BT, CR_BA_ || CR_BB_);
      PPC_INSN_CR(BT_BITMASK, BA_BITMASK | BB_BITMASK);
    }
#line 15246 "icache.c"
    return nia;
    /* extraction: 0.19,6.BT,11.BA,16.BB,21.449,31./ #undef get-values-from-icache|put-values-in-icache */
#undef BA
#undef BB
#line 15251 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_to_Count_Register_LK0(cpu *processor,
                                                instruction_word instruction,
                                                unsigned_word cia,
                                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Count_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Count_Register_LK0
#line 1596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional to Count Register\n"));
#line 15270 "icache.c"

  /* validate: 0.19,6.BO,11.BI,16./,21.528,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x4c000420)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1596 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = cache_entry->crack.XL.BO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 1596 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 15286 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_to_Count_Register_LK0;

    /* semantic routine */
#line 1596 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional to Count Register\n"));
#line 15296 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional_to_Count_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1596 "../../sim/ppc/powerpc.igen"
    {
      int cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      cond_ok = BO_0_ || (CR_BI_ == BO_1_);
      if (cond_ok) {
        NIA = IEA(CTR_0b00);
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as not-taken.
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0) {
        model_branches(cpu_model(processor), succeed, BO);
        if (! BO_0_)
          model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
      }
    }
#line 15333 "icache.c"
    return nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 15337 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Branch_Conditional_to_Count_Register_LK1(cpu *processor,
                                                instruction_word instruction,
                                                unsigned_word cia,
                                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Branch_Conditional_to_Count_Register
#undef MY_PREFIX
#define MY_PREFIX Branch_Conditional_to_Count_Register_LK1
#line 1596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Branch Conditional to Count Register\n"));
#line 15356 "icache.c"

  /* validate: 0.19,6.BO,11.BI,16./,21.528,31.LK */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x4c000420)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #define get-values-from-icache|put-values-in-icache */
#line 1596 "../../sim/ppc/powerpc.igen"
    unsigned const BO ATTRIBUTE_UNUSED = cache_entry->crack.XL.BO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#define BI EXTRACTED32(instruction, 11, 15) /* icache scratch - extraction */
#line 66 "../../sim/ppc/powerpc.igen"
    unsigned const BIT32_BI ATTRIBUTE_UNUSED = cache_entry->crack.XL.BIT32_BI = BIT32(BI); /* in icache - extraction */
#line 1596 "../../sim/ppc/powerpc.igen"
    unsigned const LK ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 15372 "icache.c"

#define insn cache_entry->crack.XL.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Branch_Conditional_to_Count_Register_LK1;

    /* semantic routine */
#line 1596 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Branch Conditional to Count Register\n"));
#line 15382 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Branch_Conditional_to_Count_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1596 "../../sim/ppc/powerpc.igen"
    {
      int cond_ok, succeed;
      if (CURRENT_MODEL_ISSUE > 0 && ! BO_0_)
        model_wait_for_cr(cpu_model(processor), BIT32_BI);
      cond_ok = BO_0_ || (CR_BI_ == BO_1_);
      if (cond_ok) {
        NIA = IEA(CTR_0b00);
        succeed = 1;
      }
      else
        succeed = 0;
      if (LK) LR = (spreg)IEA(CIA + 4);
      if (option_mpc860c0 && (!BO_0_ || !BO_2_) && !BO_4_) {
        /* This branch is predicted as not-taken.
        If this is a forward branch and it is near the end of a page,
        we've detected a problematic branch. */
        if (succeed && NIA > CIA) {
          if (MPC860C0_PAGE_SIZE - (CIA & (MPC860C0_PAGE_SIZE-1)) <= option_mpc860c0)
            program_interrupt(processor, cia, mpc860c0_instruction_program_interrupt);
        }
      }
      if (CURRENT_MODEL_ISSUE > 0) {
        model_branches(cpu_model(processor), succeed, BO);
        if (! BO_0_)
          model_branch_predict(cpu_model(processor), BO_4_ ? !succeed : succeed);
      }
    }
#line 15419 "icache.c"
    return nia;
    /* extraction: 0.19,6.BO,11.BI,16./,21.528,31.LK #undef get-values-from-icache|put-values-in-icache */
#undef BI
#line 15423 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0(cpu *processor,
                                                       instruction_word instruction,
                                                       unsigned_word cia,
                                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_Mask_Insert
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0
#line 3231 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word Immediate then Mask Insert\n"));
#line 15442 "icache.c"

  /* validate: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x50000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3231 "../../sim/ppc/powerpc.igen"
    unsigned const SH ATTRIBUTE_UNUSED = cache_entry->crack.M.SH = EXTRACTED32(instruction, 16, 20); /* default in icache - extraction */
#line 3231 "../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3231 "../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3231 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 15472 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc0;

    /* semantic routine */
#line 3231 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then Mask Insert\n"));
#line 15482 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_Immediate_then_Mask_Insert, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3231 "../../sim/ppc/powerpc.igen"
    {
      long n = SH;
      uint32_t r = ROTL32(*rS, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = (r & m) | (*rA & ~m);
      *rA = result;
      ITRACE(trace_alu, (": n=%ld *rS=0x%lx r=0x%lx m=0x%lx result=0x%lx\n",
                         n, (unsigned long)*rS, (unsigned long)r, (unsigned long)m,
      		   (unsigned long)result));
      CR0_COMPARE(result, 0, Rc);
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 15504 "icache.c"
    return nia;
    /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15508 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1(cpu *processor,
                                                       instruction_word instruction,
                                                       unsigned_word cia,
                                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_Mask_Insert
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1
#line 3231 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word Immediate then Mask Insert\n"));
#line 15527 "icache.c"

  /* validate: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x50000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3231 "../../sim/ppc/powerpc.igen"
    unsigned const SH ATTRIBUTE_UNUSED = cache_entry->crack.M.SH = EXTRACTED32(instruction, 16, 20); /* default in icache - extraction */
#line 3231 "../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3231 "../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3231 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 15557 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_Immediate_then_Mask_Insert_Rc1;

    /* semantic routine */
#line 3231 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then Mask Insert\n"));
#line 15567 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_Immediate_then_Mask_Insert, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3231 "../../sim/ppc/powerpc.igen"
    {
      long n = SH;
      uint32_t r = ROTL32(*rS, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = (r & m) | (*rA & ~m);
      *rA = result;
      ITRACE(trace_alu, (": n=%ld *rS=0x%lx r=0x%lx m=0x%lx result=0x%lx\n",
                         n, (unsigned long)*rS, (unsigned long)r, (unsigned long)m,
      		   (unsigned long)result));
      CR0_COMPARE(result, 0, Rc);
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 15589 "icache.c"
    return nia;
    /* extraction: 0.20,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15593 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0(cpu *processor,
                                                         instruction_word instruction,
                                                         unsigned_word cia,
                                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0
#line 3178 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word Immediate then AND with Mask\n"));
#line 15612 "icache.c"

  /* validate: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x54000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3178 "../../sim/ppc/powerpc.igen"
    unsigned const SH ATTRIBUTE_UNUSED = cache_entry->crack.M.SH = EXTRACTED32(instruction, 16, 20); /* default in icache - extraction */
#line 3178 "../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3178 "../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3178 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 15642 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc0;

    /* semantic routine */
#line 3178 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then AND with Mask\n"));
#line 15652 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_Immediate_then_AND_with_Mask, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3178 "../../sim/ppc/powerpc.igen"
    {
      long n = SH;
      uint32_t s = *rS;
      uint32_t r = ROTL32(s, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = r & m;
      *rA = result;
      CR0_COMPARE(result, 0, Rc);
      ITRACE(trace_alu,
             ("n=%ld, s=0x%lx, r=0x%lx, m=0x%lx, result=0x%lx, cr=0x%lx\n",
              n, (unsigned long)s, (unsigned long)r, (unsigned long)m,
      	(unsigned long)result, (unsigned long)CR));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 15676 "icache.c"
    return nia;
    /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15680 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1(cpu *processor,
                                                         instruction_word instruction,
                                                         unsigned_word cia,
                                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_Immediate_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1
#line 3178 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word Immediate then AND with Mask\n"));
#line 15699 "icache.c"

  /* validate: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x54000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3178 "../../sim/ppc/powerpc.igen"
    unsigned const SH ATTRIBUTE_UNUSED = cache_entry->crack.M.SH = EXTRACTED32(instruction, 16, 20); /* default in icache - extraction */
#line 3178 "../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3178 "../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3178 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 15729 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_Immediate_then_AND_with_Mask_Rc1;

    /* semantic routine */
#line 3178 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word Immediate then AND with Mask\n"));
#line 15739 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_Immediate_then_AND_with_Mask, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3178 "../../sim/ppc/powerpc.igen"
    {
      long n = SH;
      uint32_t s = *rS;
      uint32_t r = ROTL32(s, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = r & m;
      *rA = result;
      CR0_COMPARE(result, 0, Rc);
      ITRACE(trace_alu,
             ("n=%ld, s=0x%lx, r=0x%lx, m=0x%lx, result=0x%lx, cr=0x%lx\n",
              n, (unsigned long)s, (unsigned long)r, (unsigned long)m,
      	(unsigned long)result, (unsigned long)CR));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 15763 "icache.c"
    return nia;
    /* extraction: 0.21,6.RS,11.RA,16.SH,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15767 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_then_AND_with_Mask_Rc0(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_then_AND_with_Mask_Rc0
#line 3210 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word then AND with Mask\n"));
#line 15786 "icache.c"

  /* validate: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x5c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.M.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.M.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3210 "../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3210 "../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3210 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 15820 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_then_AND_with_Mask_Rc0;

    /* semantic routine */
#line 3210 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word then AND with Mask\n"));
#line 15830 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_then_AND_with_Mask, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3210 "../../sim/ppc/powerpc.igen"
    {
      long n = MASKED(*rB, 59, 63);
      uint32_t r = ROTL32(*rS, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = r & m;
      *rA = result;
      CR0_COMPARE(result, 0, Rc);
    }
#line 15848 "icache.c"
    return nia;
    /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15852 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Rotate_Left_Word_then_AND_with_Mask_Rc1(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Rotate_Left_Word_then_AND_with_Mask
#undef MY_PREFIX
#define MY_PREFIX Rotate_Left_Word_then_AND_with_Mask_Rc1
#line 3210 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Rotate Left Word then AND with Mask\n"));
#line 15871 "icache.c"

  /* validate: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x5c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.M.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.M.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.M.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.M.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.M.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.M.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.M.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3210 "../../sim/ppc/powerpc.igen"
    unsigned const MB ATTRIBUTE_UNUSED = cache_entry->crack.M.MB = EXTRACTED32(instruction, 21, 25); /* default in icache - extraction */
#line 3210 "../../sim/ppc/powerpc.igen"
    unsigned const ME ATTRIBUTE_UNUSED = cache_entry->crack.M.ME = EXTRACTED32(instruction, 26, 30); /* default in icache - extraction */
#line 3210 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 15905 "icache.c"

#define insn cache_entry->crack.M.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Rotate_Left_Word_then_AND_with_Mask_Rc1;

    /* semantic routine */
#line 3210 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Rotate Left Word then AND with Mask\n"));
#line 15915 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Rotate_Left_Word_then_AND_with_Mask, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3210 "../../sim/ppc/powerpc.igen"
    {
      long n = MASKED(*rB, 59, 63);
      uint32_t r = ROTL32(*rS, n);
      uint32_t m = MASK(MB+32, ME+32);
      signed_word result = r & m;
      *rA = result;
      CR0_COMPARE(result, 0, Rc);
    }
#line 15933 "icache.c"
    return nia;
    /* extraction: 0.23,6.RS,11.RA,16.RB,21.MB,26.ME,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 15937 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_Immediate(cpu *processor,
                    instruction_word instruction,
                    unsigned_word cia,
                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_Immediate
#undef MY_PREFIX
#define MY_PREFIX OR_Immediate
#line 2974 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR Immediate\n"));
#line 15956 "icache.c"

  /* validate: 0.24,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x60000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.24,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2974 "../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 15980 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_Immediate;

    /* semantic routine */
#line 2974 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR Immediate\n"));
#line 15990 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2974 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | UI;
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
    }
#line 16005 "icache.c"
    return nia;
    /* extraction: 0.24,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16009 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_Immediate_Shifted(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX OR_Immediate_Shifted
#line 2983 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR Immediate Shifted\n"));
#line 16028 "icache.c"

  /* validate: 0.25,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x64000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.25,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2983 "../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16052 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_Immediate_Shifted;

    /* semantic routine */
#line 2983 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR Immediate Shifted\n"));
#line 16062 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2983 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | (UI << 16);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
    }
#line 16077 "icache.c"
    return nia;
    /* extraction: 0.25,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16081 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_XOR_Immediate(cpu *processor,
                     instruction_word instruction,
                     unsigned_word cia,
                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR_Immediate
#undef MY_PREFIX
#define MY_PREFIX XOR_Immediate
#line 2992 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode XOR Immediate\n"));
#line 16100 "icache.c"

  /* validate: 0.26,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x68000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.26,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2992 "../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16124 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_XOR_Immediate;

    /* semantic routine */
#line 2992 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics XOR Immediate\n"));
#line 16134 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_XOR_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2992 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS ^ UI;
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
    }
#line 16149 "icache.c"
    return nia;
    /* extraction: 0.26,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16153 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_XOR_Immediate_Shifted(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX XOR_Immediate_Shifted
#line 3001 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode XOR Immediate Shifted\n"));
#line 16172 "icache.c"

  /* validate: 0.27,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x6c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.27,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3001 "../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16196 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_XOR_Immediate_Shifted;

    /* semantic routine */
#line 3001 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics XOR Immediate Shifted\n"));
#line 16206 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_XOR_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3001 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS ^ (UI << 16);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 0/*Rc*/);
    }
#line 16221 "icache.c"
    return nia;
    /* extraction: 0.27,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16225 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_Immediate(cpu *processor,
                     instruction_word instruction,
                     unsigned_word cia,
                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_Immediate
#undef MY_PREFIX
#define MY_PREFIX AND_Immediate
#line 2954 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND Immediate\n"));
#line 16244 "icache.c"

  /* validate: 0.28,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x70000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.28,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2954 "../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16268 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_Immediate;

    /* semantic routine */
#line 2954 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND Immediate\n"));
#line 16278 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2954 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & UI;
      CR0_COMPARE(*rA, 0, 1/*Rc*/);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 1/*Rc*/);
    }
#line 16294 "icache.c"
    return nia;
    /* extraction: 0.28,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16298 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_Immediate_Shifted(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_Immediate_Shifted
#undef MY_PREFIX
#define MY_PREFIX AND_Immediate_Shifted
#line 2964 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND Immediate Shifted\n"));
#line 16317 "icache.c"

  /* validate: 0.29,6.RS,11.RA,16.UI */
  if (WITH_RESERVED_BITS && (instruction & 0xfc000000) != 0x74000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.29,6.RS,11.RA,16.UI #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.D.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.D.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.D.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.D.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.D.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2964 "../../sim/ppc/powerpc.igen"
    unsigned const UI ATTRIBUTE_UNUSED = cache_entry->crack.D.UI = EXTRACTED32(instruction, 16, 31); /* default in icache - extraction */
#line 16341 "icache.c"

#define insn cache_entry->crack.D.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_Immediate_Shifted;

    /* semantic routine */
#line 2964 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND Immediate Shifted\n"));
#line 16351 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND_Immediate_Shifted, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2964 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & (UI << 16);
      CR0_COMPARE(*rA, 0, 1/*Rc*/);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, 1/*Rc*/);
    }
#line 16367 "icache.c"
    return nia;
    /* extraction: 0.29,6.RS,11.RA,16.UI #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16371 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Compare(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare
#undef MY_PREFIX
#define MY_PREFIX Compare
#line 2810 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Compare\n"));
#line 16390 "icache.c"

  /* validate: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc4007ff) != 0x7c000000)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ #define get-values-from-icache|put-values-in-icache */
#line 67 "../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.X.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 2810 "../../sim/ppc/powerpc.igen"
    unsigned const L ATTRIBUTE_UNUSED = cache_entry->crack.X.L = EXTRACTED32(instruction, 10, 10); /* default in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 16418 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Compare;

    /* semantic routine */
#line 2810 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Compare\n"));
#line 16428 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Compare, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2810 "../../sim/ppc/powerpc.igen"
    {
      if (!is_64bit_mode && L)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        signed_word a;
        signed_word b;
        if (L == 0) {
          a = EXTENDED(*rA);
          b = EXTENDED(*rB);
        }
        else {
          a = *rA;
          b = *rB;
        }
        CR_COMPARE(BF, a, b);
      }
      PPC_INSN_INT_CR(0, RA_BITMASK | RB_BITMASK, BF_BITMASK);
    }
#line 16457 "icache.c"
    return nia;
    /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.0,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16461 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Trap_Word(cpu *processor,
                 instruction_word instruction,
                 unsigned_word cia,
                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Trap_Word
#undef MY_PREFIX
#define MY_PREFIX Trap_Word
#line 2930 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Trap Word\n"));
#line 16480 "icache.c"

  /* validate: 0.31,6.TO,11.RA,16.RB,21.4,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c000008)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.TO,11.RA,16.RB,21.4,31./ #define get-values-from-icache|put-values-in-icache */
#line 2930 "../../sim/ppc/powerpc.igen"
    unsigned const TO ATTRIBUTE_UNUSED = cache_entry->crack.X.TO = EXTRACTED32(instruction, 6, 10); /* default in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 16504 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Trap_Word;

    /* semantic routine */
#line 2930 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Trap Word\n"));
#line 16514 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Trap_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2930 "../../sim/ppc/powerpc.igen"
    {
      signed_word a = EXTENDED(*rA);
      signed_word b = EXTENDED(*rB);
      if (TO == 12 && rA == rB) {
        ITRACE(trace_breakpoint, ("breakpoint\n"));
        cpu_halt(processor, cia, was_trap, 0);
      }
      else if ((a < b && TO_0_)
          || (a > b && TO_1_)
          || (a == b && TO_2_)
          || ((unsigned_word)a < (unsigned_word)b && TO_3_)
          || ((unsigned_word)a > (unsigned_word)b && TO_4_)
          )
        program_interrupt(processor, cia,
                          trap_program_interrupt);
    }
#line 16540 "icache.c"
    return nia;
    /* extraction: 0.31,6.TO,11.RA,16.RB,21.4,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16544 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Carrying_OE0_Rc0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE0_Rc0
#line 2596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Carrying\n"));
#line 16563 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000010)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2596 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2596 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 16595 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Carrying_OE0_Rc0;

    /* semantic routine */
#line 2596 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 16605 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2596 "../../sim/ppc/powerpc.igen"
    {
      /* RT <- ~RA + RB + 1 === RT <- RB - RA */
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16624 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16628 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Carrying_OE0_Rc1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE0_Rc1
#line 2596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Carrying\n"));
#line 16647 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000010)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2596 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2596 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 16679 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Carrying_OE0_Rc1;

    /* semantic routine */
#line 2596 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 16689 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2596 "../../sim/ppc/powerpc.igen"
    {
      /* RT <- ~RA + RB + 1 === RT <- RB - RA */
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16708 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16712 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Carrying_OE0_Rc0(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE0_Rc0
#line 2586 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Carrying\n"));
#line 16731 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000014)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2586 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2586 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 16763 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Carrying_OE0_Rc0;

    /* semantic routine */
#line 2586 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 16773 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2586 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16789 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16793 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Carrying_OE0_Rc1(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE0_Rc1
#line 2586 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Carrying\n"));
#line 16812 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000014)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2586 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2586 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 16844 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Carrying_OE0_Rc1;

    /* semantic routine */
#line 2586 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 16854 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2586 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16870 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16874 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_High_Word_Unsigned_Rc0(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Unsigned_Rc0
#line 2730 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply High Word Unsigned\n"));
#line 16893 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000016)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2730 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 16923 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_High_Word_Unsigned_Rc0;

    /* semantic routine */
#line 2730 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply High Word Unsigned\n"));
#line 16933 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_High_Word_Unsigned, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2730 "../../sim/ppc/powerpc.igen"
    {
      uint64_t a = (uint32_t)(*rA);
      uint64_t b = (uint32_t)(*rB);
      uint64_t prod = a * b;
      signed_word t = EXTRACTED64(prod, 0, 31);
      *rT = t;
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 16952 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 16956 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_High_Word_Unsigned_Rc1(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Unsigned_Rc1
#line 2730 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply High Word Unsigned\n"));
#line 16975 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000016)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2730 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17005 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_High_Word_Unsigned_Rc1;

    /* semantic routine */
#line 2730 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply High Word Unsigned\n"));
#line 17015 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_High_Word_Unsigned, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2730 "../../sim/ppc/powerpc.igen"
    {
      uint64_t a = (uint32_t)(*rA);
      uint64_t b = (uint32_t)(*rB);
      uint64_t prod = a * b;
      signed_word t = EXTRACTED64(prod, 0, 31);
      *rT = t;
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 17034 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.11,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17038 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_From_Condition_Register(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Condition_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Condition_Register
#line 3452 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move From Condition Register\n"));
#line 17057 "icache.c"

  /* validate: 0.31,6.RT,11./,16./,21.19,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc1fffff) != 0x7c000026)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11./,16./,21.19,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 17072 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_From_Condition_Register;

    /* semantic routine */
#line 3452 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move From Condition Register\n"));
#line 17082 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_From_Condition_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3452 "../../sim/ppc/powerpc.igen"
    {
      *rT = (uint32_t)CR;
      PPC_INSN_MFCR(RT_BITMASK);
    }
#line 17096 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11./,16./,21.19,31./ #undef get-values-from-icache|put-values-in-icache */
#line 17099 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Word_And_Reserve_Indexed(cpu *processor,
                                     instruction_word instruction,
                                     unsigned_word cia,
                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_And_Reserve_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_And_Reserve_Indexed
#line 2422 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Word And Reserve Indexed\n"));
#line 17118 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.20,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c000028)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.20,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 17146 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Word_And_Reserve_Indexed;

    /* semantic routine */
#line 2422 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Word And Reserve Indexed\n"));
#line 17156 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Word_And_Reserve_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2422 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      RESERVE = 1;
      RESERVE_ADDR = real_addr(EA, 1/*is-read?*/);
      RESERVE_DATA = MEM(unsigned, EA, 4);
      *rT = RESERVE_DATA;
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 17178 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.20,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17182 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Word_and_Zero_Indexed(cpu *processor,
                                  instruction_word instruction,
                                  unsigned_word cia,
                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_Indexed
#line 1898 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Word and Zero Indexed\n"));
#line 17201 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.23,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00002e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.23,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 17229 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Word_and_Zero_Indexed;

    /* semantic routine */
#line 1898 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Word and Zero Indexed\n"));
#line 17239 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Word_and_Zero_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1898 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = MEM(unsigned, EA, 4);
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 17258 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.23,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17262 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Shift_Left_Word_Rc0(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Left_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Left_Word_Rc0
#line 3250 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Shift Left Word\n"));
#line 17281 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000030)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3250 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 17311 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Shift_Left_Word_Rc0;

    /* semantic routine */
#line 3250 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Shift Left Word\n"));
#line 17321 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Shift_Left_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3250 "../../sim/ppc/powerpc.igen"
    {
      int n = MASKED(*rB, 58, 63);
      uint32_t source = *rS;
      signed_word shifted;
      if (n < 32)
        shifted = (source << n);
      else
        shifted = 0;
      *rA = shifted;
      CR0_COMPARE(shifted, 0, Rc);
      ITRACE(trace_alu,
             ("n=%d, source=0x%lx, shifted=0x%lx\n",
              n, (unsigned long)source, (unsigned long)shifted));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 17346 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17350 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Shift_Left_Word_Rc1(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Left_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Left_Word_Rc1
#line 3250 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Shift Left Word\n"));
#line 17369 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000030)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3250 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17399 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Shift_Left_Word_Rc1;

    /* semantic routine */
#line 3250 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Shift Left Word\n"));
#line 17409 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Shift_Left_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3250 "../../sim/ppc/powerpc.igen"
    {
      int n = MASKED(*rB, 58, 63);
      uint32_t source = *rS;
      signed_word shifted;
      if (n < 32)
        shifted = (source << n);
      else
        shifted = 0;
      *rA = shifted;
      CR0_COMPARE(shifted, 0, Rc);
      ITRACE(trace_alu,
             ("n=%d, source=0x%lx, shifted=0x%lx\n",
              n, (unsigned long)source, (unsigned long)shifted));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 17434 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.24,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17438 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Count_Leading_Zeros_Word_Rc0(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Count_Leading_Zeros_Word
#undef MY_PREFIX
#define MY_PREFIX Count_Leading_Zeros_Word_Rc0
#line 3129 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Count Leading Zeros Word\n"));
#line 17457 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16./,21.26,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x7c000034)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3129 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 17481 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Count_Leading_Zeros_Word_Rc0;

    /* semantic routine */
#line 3129 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Count Leading Zeros Word\n"));
#line 17491 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Count_Leading_Zeros_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3129 "../../sim/ppc/powerpc.igen"
    {
      int count = 0;
      uint32_t mask = BIT32(0);
      uint32_t source = *rS;
      while (!(source & mask) && mask != 0) {
        mask >>= 1;
        count++;
      }
      *rA = count;
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      CR0_COMPARE(count, 0, Rc); /* FIXME - is this correct */
    }
#line 17513 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17517 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Count_Leading_Zeros_Word_Rc1(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Count_Leading_Zeros_Word
#undef MY_PREFIX
#define MY_PREFIX Count_Leading_Zeros_Word_Rc1
#line 3129 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Count Leading Zeros Word\n"));
#line 17536 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16./,21.26,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fffe) != 0x7c000034)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 3129 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17560 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Count_Leading_Zeros_Word_Rc1;

    /* semantic routine */
#line 3129 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Count Leading Zeros Word\n"));
#line 17570 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Count_Leading_Zeros_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3129 "../../sim/ppc/powerpc.igen"
    {
      int count = 0;
      uint32_t mask = BIT32(0);
      uint32_t source = *rS;
      while (!(source & mask) && mask != 0) {
        mask >>= 1;
        count++;
      }
      *rA = count;
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      CR0_COMPARE(count, 0, Rc); /* FIXME - is this correct */
    }
#line 17592 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16./,21.26,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17596 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_Rc0(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND
#undef MY_PREFIX
#define MY_PREFIX AND_Rc0
#line 3010 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND\n"));
#line 17615 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000038)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3010 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 17645 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_Rc0;

    /* semantic routine */
#line 3010 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND\n"));
#line 17655 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3010 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 17671 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17675 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_Rc1(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND
#undef MY_PREFIX
#define MY_PREFIX AND_Rc1
#line 3010 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND\n"));
#line 17694 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000038)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3010 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17724 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_Rc1;

    /* semantic routine */
#line 3010 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND\n"));
#line 17734 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3010 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 17750 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.28,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17754 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Compare_Logical(cpu *processor,
                       instruction_word instruction,
                       unsigned_word cia,
                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Compare_Logical
#undef MY_PREFIX
#define MY_PREFIX Compare_Logical
#line 2852 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Compare Logical\n"));
#line 17773 "icache.c"

  /* validate: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc4007ff) != 0x7c000040)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ #define get-values-from-icache|put-values-in-icache */
#line 67 "../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.X.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 2852 "../../sim/ppc/powerpc.igen"
    unsigned const L ATTRIBUTE_UNUSED = cache_entry->crack.X.L = EXTRACTED32(instruction, 10, 10); /* default in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 17801 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Compare_Logical;

    /* semantic routine */
#line 2852 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Compare Logical\n"));
#line 17811 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Compare_Logical, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2852 "../../sim/ppc/powerpc.igen"
    {
      if (!is_64bit_mode && L)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        unsigned_word a;
        unsigned_word b;
        if (L == 0) {
          a = MASKED(*rA, 32, 63);
          b = MASKED(*rB, 32, 63);
        }
        else {
          a = *rA;
          b = *rB;
        }
        CR_COMPARE(BF, a, b);
      }
      PPC_INSN_INT_CR(0, RA_BITMASK | RB_BITMASK, BF_BITMASK);
    }
#line 17840 "icache.c"
    return nia;
    /* extraction: 0.31,6.BF,9./,10.L,11.RA,16.RB,21.32,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17844 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_OE0_Rc0(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE0_Rc0
#line 2542 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From\n"));
#line 17863 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000050)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2542 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2542 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 17895 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_OE0_Rc0;

    /* semantic routine */
#line 2542 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 17905 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2542 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 17923 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 17927 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_OE0_Rc1(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE0_Rc1
#line 2542 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From\n"));
#line 17946 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000050)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2542 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2542 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 17978 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_OE0_Rc1;

    /* semantic routine */
#line 2542 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 17988 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2542 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 18006 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18010 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Store(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Store
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Store
#line 4811 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Store\n"));
#line 18029 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.54,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c00006c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.54,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18051 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Store;

    /* semantic routine */
#line 4811 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Store\n"));
#line 18061 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Store, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4811 "../../sim/ppc/powerpc.igen"
    {
      TRACE(trace_tbd,("Data Cache Block Store\n"));
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
    }
#line 18075 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.54,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18079 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Word_and_Zero_with_Update_Indexed(cpu *processor,
                                              instruction_word instruction,
                                              unsigned_word cia,
                                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_and_Zero_with_Update_Indexed
#line 1925 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Word and Zero with Update Indexed\n"));
#line 18098 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.55,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00006e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.55,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18126 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Word_and_Zero_with_Update_Indexed;

    /* semantic routine */
#line 1925 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Word and Zero with Update Indexed\n"));
#line 18136 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Word_and_Zero_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1925 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0 || RA == RT)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *rT = MEM(unsigned, EA, 4);
      *rA = EA;
      PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
    }
#line 18156 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.55,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18160 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_with_Complement_Rc0(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX AND_with_Complement_Rc0
#line 3070 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND with Complement\n"));
#line 18179 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000078)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3070 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 18209 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_with_Complement_Rc0;

    /* semantic routine */
#line 3070 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND with Complement\n"));
#line 18219 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3070 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & ~*rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 18235 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18239 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_AND_with_Complement_Rc1(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_AND_with_Complement
#undef MY_PREFIX
#define MY_PREFIX AND_with_Complement_Rc1
#line 3070 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode AND with Complement\n"));
#line 18258 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000078)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3070 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 18288 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_AND_with_Complement_Rc1;

    /* semantic routine */
#line 3070 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics AND with Complement\n"));
#line 18298 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_AND_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3070 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS & ~*rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 18314 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.60,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18318 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_High_Word_Rc0(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Rc0
#line 2715 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply High Word\n"));
#line 18337 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000096)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2715 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 18367 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_High_Word_Rc0;

    /* semantic routine */
#line 2715 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply High Word\n"));
#line 18377 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_High_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2715 "../../sim/ppc/powerpc.igen"
    {
      int64_t a = (int32_t)(*rA);
      int64_t b = (int32_t)(*rB);
      int64_t prod = a * b;
      signed_word t = EXTRACTED64(prod, 0, 31);
      *rT = t;
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 18396 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18400 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_High_Word_Rc1(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_High_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_High_Word_Rc1
#line 2715 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply High Word\n"));
#line 18419 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000096)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2715 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 18449 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_High_Word_Rc1;

    /* semantic routine */
#line 2715 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply High Word\n"));
#line 18459 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_High_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2715 "../../sim/ppc/powerpc.igen"
    {
      int64_t a = (int32_t)(*rA);
      int64_t b = (int32_t)(*rB);
      int64_t prod = a * b;
      signed_word t = EXTRACTED64(prod, 0, 31);
      *rT = t;
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 18478 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21./,22.75,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18482 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_From_Machine_State_Register(cpu *processor,
                                        instruction_word instruction,
                                        unsigned_word cia,
                                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Machine_State_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Machine_State_Register
#line 4898 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move From Machine State Register\n"));
#line 18501 "icache.c"

  /* validate: 0.31,6.RT,11./,16./,21.83,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc1fffff) != 0x7c0000a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11./,16./,21.83,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 18516 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_From_Machine_State_Register;

    /* semantic routine */
#line 4898 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move From Machine State Register\n"));
#line 18526 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_From_Machine_State_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4898 "../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else {
        *rT = MSR;
        check_masked_interrupts(processor);
      }
    }
#line 18545 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11./,16./,21.83,31./ #undef get-values-from-icache|put-values-in-icache */
#line 18548 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Flush(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Flush
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Flush
#line 4819 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Flush\n"));
#line 18567 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.86,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c0000ac)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.86,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18589 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Flush;

    /* semantic routine */
#line 4819 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Flush\n"));
#line 18599 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Flush, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4819 "../../sim/ppc/powerpc.igen"
    {
      TRACE(trace_tbd,("Data Cache Block Flush\n"));
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
    }
#line 18613 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.86,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18617 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Byte_and_Zero_Indexed(cpu *processor,
                                  instruction_word instruction,
                                  unsigned_word cia,
                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_Indexed
#line 1736 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Byte and Zero Indexed\n"));
#line 18636 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.87,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0000ae)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.87,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18664 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Byte_and_Zero_Indexed;

    /* semantic routine */
#line 1736 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Byte and Zero Indexed\n"));
#line 18674 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Byte_and_Zero_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1736 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = MEM(unsigned, EA, 1);
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 18693 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.87,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18697 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Negate_OE0_Rc0(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE0_Rc0
#line 2676 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Negate\n"));
#line 18716 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0000d0)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2676 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2676 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 18742 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Negate_OE0_Rc0;

    /* semantic routine */
#line 2676 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Negate\n"));
#line 18752 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Negate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2676 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(1);
      ALU_END(*rT,0/*CA*/,OE,Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 18769 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18773 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Negate_OE0_Rc1(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Negate
#undef MY_PREFIX
#define MY_PREFIX Negate_OE0_Rc1
#line 2676 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Negate\n"));
#line 18792 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0000d0)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2676 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2676 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 18818 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Negate_OE0_Rc1;

    /* semantic routine */
#line 2676 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Negate\n"));
#line 18828 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Negate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2676 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(1);
      ALU_END(*rT,0/*CA*/,OE,Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 18845 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.104,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18849 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Byte_and_Zero_with_Update_Indexed(cpu *processor,
                                              instruction_word instruction,
                                              unsigned_word cia,
                                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Byte_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Byte_and_Zero_with_Update_Indexed
#line 1763 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Byte and Zero with Update Indexed\n"));
#line 18868 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.119,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0000ee)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.119,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 18896 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Byte_and_Zero_with_Update_Indexed;

    /* semantic routine */
#line 1763 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Byte and Zero with Update Indexed\n"));
#line 18906 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Byte_and_Zero_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1763 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0 || RA == RT)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *rT = MEM(unsigned, EA, 1);
      *rA = EA;
      PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
    }
#line 18926 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.119,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 18930 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_NOR_Rc0(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_NOR
#undef MY_PREFIX
#define MY_PREFIX NOR_Rc0
#line 3050 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode NOR\n"));
#line 18949 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c0000f8)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3050 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 18979 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_NOR_Rc0;

    /* semantic routine */
#line 3050 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics NOR\n"));
#line 18989 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_NOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3050 "../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS | *rB);
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 19005 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19009 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_NOR_Rc1(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_NOR
#undef MY_PREFIX
#define MY_PREFIX NOR_Rc1
#line 3050 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode NOR\n"));
#line 19028 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c0000f8)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3050 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 19058 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_NOR_Rc1;

    /* semantic routine */
#line 3050 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics NOR\n"));
#line 19068 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_NOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3050 "../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS | *rB);
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 19084 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.124,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19088 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Extended_OE0_Rc0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE0_Rc0
#line 2620 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Extended\n"));
#line 19107 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000110)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2620 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2620 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 19139 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Extended_OE0_Rc0;

    /* semantic routine */
#line 2620 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 19149 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2620 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 19167 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19171 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Extended_OE0_Rc1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Extended_OE0_Rc1
#line 2620 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Extended\n"));
#line 19190 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000110)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2620 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2620 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 19222 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Extended_OE0_Rc1;

    /* semantic routine */
#line 2620 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Extended\n"));
#line 19232 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2620 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 19250 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.136,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19254 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Extended_OE0_Rc0(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE0_Rc0
#line 2609 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Extended\n"));
#line 19273 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000114)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2609 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2609 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 19305 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Extended_OE0_Rc0;

    /* semantic routine */
#line 2609 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 19315 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2609 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 19332 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19336 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Extended_OE0_Rc1(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_Extended_OE0_Rc1
#line 2609 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Extended\n"));
#line 19355 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000114)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2609 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2609 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 19387 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Extended_OE0_Rc1;

    /* semantic routine */
#line 2609 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Extended\n"));
#line 19397 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2609 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 19414 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.138,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19418 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_to_Condition_Register_Fields(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Condition_Register_Fields
#undef MY_PREFIX
#define MY_PREFIX Move_to_Condition_Register_Fields
#line 3429 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move to Condition Register Fields\n"));
#line 19437 "icache.c"

  /* validate: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc100fff) != 0x7c000120)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 3429 "../../sim/ppc/powerpc.igen"
    unsigned const FXM ATTRIBUTE_UNUSED = cache_entry->crack.XFX.FXM = EXTRACTED32(instruction, 12, 19); /* default in icache - extraction */
#line 19454 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_to_Condition_Register_Fields;

    /* semantic routine */
#line 3429 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move to Condition Register Fields\n"));
#line 19464 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_to_Condition_Register_Fields, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3429 "../../sim/ppc/powerpc.igen"
    {
      if (FXM == 0xff) {
        CR = *rS;
      }
      else {
        unsigned_word mask = 0;
        unsigned_word f;
        for (f = 0; f < 8; f++) {
          if (FXM & (0x80 >> f))
            mask |= (0xf << 4*(7-f));
        }
        CR = (MASKED(*rS, 32, 63) & mask) | (CR & ~mask);
      }
      PPC_INSN_MTCR(RS_BITMASK, FXM);
    }
#line 19489 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11./,12.FXM,20./,21.144,31./ #undef get-values-from-icache|put-values-in-icache */
#line 19492 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_To_Machine_State_Register(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Machine_State_Register
#undef MY_PREFIX
#define MY_PREFIX Move_To_Machine_State_Register
#line 4885 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move To Machine State Register\n"));
#line 19511 "icache.c"

  /* validate: 0.31,6.RS,11./,16./,21.146,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc1fffff) != 0x7c000124)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11./,16./,21.146,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 19526 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_To_Machine_State_Register;

    /* semantic routine */
#line 4885 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move To Machine State Register\n"));
#line 19536 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_To_Machine_State_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4885 "../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else {
        MSR = *rS;
        check_masked_interrupts(processor);
      }
    }
#line 19555 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11./,16./,21.146,31./ #undef get-values-from-icache|put-values-in-icache */
#line 19558 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Word_Conditional_Indexed(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_Conditional_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_Conditional_Indexed
#line 2450 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Word Conditional Indexed\n"));
#line 19577 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.150,31.1 */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00012d)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.150,31.1 #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 19605 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Word_Conditional_Indexed;

    /* semantic routine */
#line 2450 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Word Conditional Indexed\n"));
#line 19615 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Word_Conditional_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2450 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      if (RESERVE) {
        if (RESERVE_ADDR == real_addr(EA, 0/*is-read?*/)
            && /*HACK*/ RESERVE_DATA == MEM(unsigned, EA, 4)) {
          STORE(EA, 4, *rS);
          CR_SET_XER_SO(0, cr_i_zero);
        }
        else {
          /* ment to randomly to store, we never do! */	
          CR_SET_XER_SO(0, 0);
        }
        RESERVE = 0;
      }
      else {
        CR_SET_XER_SO(0, 0);
      }
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 1/*Rc*/);
    }
#line 19648 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.150,31.1 #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19652 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Word_Indexed(cpu *processor,
                          instruction_word instruction,
                          unsigned_word cia,
                          idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_Indexed
#line 2125 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Word Indexed\n"));
#line 19671 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.151,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00012e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.151,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 19699 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Word_Indexed;

    /* semantic routine */
#line 2125 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Word Indexed\n"));
#line 19709 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Word_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2125 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      STORE(EA, 4, *rS);
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
    }
#line 19728 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.151,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19732 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Word_with_Update_Indexed(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Word_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Word_with_Update_Indexed
#line 2152 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Word with Update Indexed\n"));
#line 19751 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.183,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00016e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.183,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 19779 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Word_with_Update_Indexed;

    /* semantic routine */
#line 2152 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Word with Update Indexed\n"));
#line 19789 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Word_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2152 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      STORE(EA, 4, *rS);
      *rA = EA;
      PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
    }
#line 19809 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.183,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19813 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_from_Zero_Extended_OE0_Rc0(cpu *processor,
                                           instruction_word instruction,
                                           unsigned_word cia,
                                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE0_Rc0
#line 2665 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract from Zero Extended\n"));
#line 19832 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c000190)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2665 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2665 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 19858 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_from_Zero_Extended_OE0_Rc0;

    /* semantic routine */
#line 2665 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 19868 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2665 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 19885 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19889 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_from_Zero_Extended_OE0_Rc1(cpu *processor,
                                           instruction_word instruction,
                                           unsigned_word cia,
                                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_from_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_from_Zero_Extended_OE0_Rc1
#line 2665 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract from Zero Extended\n"));
#line 19908 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c000190)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2665 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2665 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 19934 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_from_Zero_Extended_OE0_Rc1;

    /* semantic routine */
#line 2665 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract from Zero Extended\n"));
#line 19944 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_from_Zero_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2665 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 19961 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.200,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 19965 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_to_Zero_Extended_OE0_Rc0(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE0_Rc0
#line 2655 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add to Zero Extended\n"));
#line 19984 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c000194)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2655 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2655 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 20010 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_to_Zero_Extended_OE0_Rc0;

    /* semantic routine */
#line 2655 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 20020 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_to_Zero_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2655 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20036 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20040 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_to_Zero_Extended_OE0_Rc1(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Zero_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Zero_Extended_OE0_Rc1
#line 2655 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add to Zero Extended\n"));
#line 20059 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c000194)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2655 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2655 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 20085 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_to_Zero_Extended_OE0_Rc1;

    /* semantic routine */
#line 2655 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add to Zero Extended\n"));
#line 20095 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_to_Zero_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2655 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD_CA;
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20111 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.202,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20115 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_To_Segment_Register(cpu *processor,
                                instruction_word instruction,
                                unsigned_word cia,
                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Segment_Register
#undef MY_PREFIX
#define MY_PREFIX Move_To_Segment_Register
#line 4931 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move To Segment Register\n"));
#line 20134 "icache.c"

  /* validate: 0.31,6.RS,11./,12.SR,16./,21.210,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc10ffff) != 0x7c0001a4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11./,12.SR,16./,21.210,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 4931 "../../sim/ppc/powerpc.igen"
    unsigned const SR ATTRIBUTE_UNUSED = cache_entry->crack.X.SR = EXTRACTED32(instruction, 12, 15); /* default in icache - extraction */
#line 20151 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_To_Segment_Register;

    /* semantic routine */
#line 4931 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move To Segment Register\n"));
#line 20161 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_To_Segment_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4931 "../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else
        SEGREG(SR) = *rS;
    }
#line 20178 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11./,12.SR,16./,21.210,31./ #undef get-values-from-icache|put-values-in-icache */
#line 20181 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Byte_Indexed(cpu *processor,
                          instruction_word instruction,
                          unsigned_word cia,
                          idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_Indexed
#line 2017 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Byte Indexed\n"));
#line 20200 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.215,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0001ae)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.215,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 20228 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Byte_Indexed;

    /* semantic routine */
#line 2017 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Byte Indexed\n"));
#line 20238 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Byte_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2017 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      STORE(EA, 1, *rS);
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
    }
#line 20257 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.215,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20261 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Minus_One_Extended_OE0_Rc0(cpu *processor,
                                                instruction_word instruction,
                                                unsigned_word cia,
                                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE0_Rc0
#line 2643 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Minus One Extended\n"));
#line 20280 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0001d0)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2643 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2643 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 20306 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Minus_One_Extended_OE0_Rc0;

    /* semantic routine */
#line 2643 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 20316 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2643 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD_CA;
      ALU_ADD(-1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20334 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20338 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Minus_One_Extended_OE0_Rc1(cpu *processor,
                                                instruction_word instruction,
                                                unsigned_word cia,
                                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Minus_One_Extended_OE0_Rc1
#line 2643 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Minus One Extended\n"));
#line 20357 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0001d0)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2643 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2643 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 20383 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Minus_One_Extended_OE0_Rc1;

    /* semantic routine */
#line 2643 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Minus One Extended\n"));
#line 20393 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Minus_One_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2643 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD_CA;
      ALU_ADD(-1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20411 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.232,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20415 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_to_Minus_One_Extended_OE0_Rc0(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE0_Rc0
#line 2632 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add to Minus One Extended\n"));
#line 20434 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0001d4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2632 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2632 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 20460 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_to_Minus_One_Extended_OE0_Rc0;

    /* semantic routine */
#line 2632 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 20470 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2632 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD_CA;
      ALU_ADD(-1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20487 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20491 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_to_Minus_One_Extended_OE0_Rc1(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_to_Minus_One_Extended
#undef MY_PREFIX
#define MY_PREFIX Add_to_Minus_One_Extended_OE0_Rc1
#line 2632 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add to Minus One Extended\n"));
#line 20510 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc00fbfe) != 0x7c0001d4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2632 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2632 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 20536 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_to_Minus_One_Extended_OE0_Rc1;

    /* semantic routine */
#line 2632 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add to Minus One Extended\n"));
#line 20546 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_to_Minus_One_Extended, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2632 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD_CA;
      ALU_ADD(-1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK, Rc);
    }
#line 20563 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16./,21.OE,22.234,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20567 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_Low_Word_OE0_Rc0(cpu *processor,
                                 instruction_word instruction,
                                 unsigned_word cia,
                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE0_Rc0
#line 2698 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply Low Word\n"));
#line 20586 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c0001d6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2698 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2698 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 20618 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_Low_Word_OE0_Rc0;

    /* semantic routine */
#line 2698 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 20628 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_Low_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2698 "../../sim/ppc/powerpc.igen"
    {
      int64_t a = (int32_t)(*rA);
      int64_t b = (int32_t)(*rB);
      int64_t prod = a * b;
      signed_word t = prod;
      *rT = *rA * *rB;
      if (t != prod && OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 20649 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20653 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Multiply_Low_Word_OE0_Rc1(cpu *processor,
                                 instruction_word instruction,
                                 unsigned_word cia,
                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Multiply_Low_Word
#undef MY_PREFIX
#define MY_PREFIX Multiply_Low_Word_OE0_Rc1
#line 2698 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Multiply Low Word\n"));
#line 20672 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c0001d6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2698 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2698 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 20704 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Multiply_Low_Word_OE0_Rc1;

    /* semantic routine */
#line 2698 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Multiply Low Word\n"));
#line 20714 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Multiply_Low_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2698 "../../sim/ppc/powerpc.igen"
    {
      int64_t a = (int32_t)(*rA);
      int64_t b = (int32_t)(*rB);
      int64_t prod = a * b;
      signed_word t = prod;
      *rT = *rA * *rB;
      if (t != prod && OE)
        XER |= (xer_overflow | xer_summary_overflow);
      CR0_COMPARE(t, 0, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 20735 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.235,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20739 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_To_Segment_Register_Indirect(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_To_Segment_Register_Indirect
#undef MY_PREFIX
#define MY_PREFIX Move_To_Segment_Register_Indirect
#line 4942 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move To Segment Register Indirect\n"));
#line 20758 "icache.c"

  /* validate: 0.31,6.RS,11./,16.RB,21.242,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc1f07ff) != 0x7c0001e4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11./,16.RB,21.242,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 20779 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_To_Segment_Register_Indirect;

    /* semantic routine */
#line 4942 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move To Segment Register Indirect\n"));
#line 20789 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_To_Segment_Register_Indirect, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4942 "../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else
        SEGREG(EXTRACTED32(*rB, 0, 3)) = *rS;
    }
#line 20806 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11./,16.RB,21.242,31./ #undef get-values-from-icache|put-values-in-icache */
#line 20809 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Touch_for_Store(cpu *processor,
                                        instruction_word instruction,
                                        unsigned_word cia,
                                        idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Touch_for_Store
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Touch_for_Store
#line 4795 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Touch for Store\n"));
#line 20828 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.246,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c0001ec)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.246,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 20850 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Touch_for_Store;

    /* semantic routine */
#line 4795 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Touch for Store\n"));
#line 20860 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Touch_for_Store, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4795 "../../sim/ppc/powerpc.igen"
    {
      TRACE(trace_tbd,("Data Cache Block Touch for Store\n"));
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
    }
#line 20874 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.246,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20878 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Byte_with_Update_Indexed(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Byte_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Byte_with_Update_Indexed
#line 2044 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Byte with Update Indexed\n"));
#line 20897 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.247,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0001ee)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.247,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 20925 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Byte_with_Update_Indexed;

    /* semantic routine */
#line 2044 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Byte with Update Indexed\n"));
#line 20935 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Byte_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2044 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      STORE(EA, 1, *rS);
      *rA = EA;
      PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
    }
#line 20955 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.247,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 20959 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_OE0_Rc0(cpu *processor,
                   instruction_word instruction,
                   unsigned_word cia,
                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE0_Rc0
#line 2532 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add\n"));
#line 20978 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000214)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2532 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2532 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 21010 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_OE0_Rc0;

    /* semantic routine */
#line 2532 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add\n"));
#line 21020 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2532 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 21036 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21040 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_OE0_Rc1(cpu *processor,
                   instruction_word instruction,
                   unsigned_word cia,
                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add
#undef MY_PREFIX
#define MY_PREFIX Add_OE0_Rc1
#line 2532 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add\n"));
#line 21059 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000214)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2532 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2532 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 21091 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_OE0_Rc1;

    /* semantic routine */
#line 2532 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add\n"));
#line 21101 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2532 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 21117 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.266,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21121 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Touch(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Touch
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Touch
#line 4787 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Touch\n"));
#line 21140 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.278,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c00022c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.278,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21162 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Touch;

    /* semantic routine */
#line 4787 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Touch\n"));
#line 21172 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Touch, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4787 "../../sim/ppc/powerpc.igen"
    {
      TRACE(trace_tbd,("Data Cache Block Touch\n"));
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK, 0/*Rc*/);
    }
#line 21186 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.278,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21190 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Halfword_and_Zero_Indexed(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_Indexed
#line 1790 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Halfword and Zero Indexed\n"));
#line 21209 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.279,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00022e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.279,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21237 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Halfword_and_Zero_Indexed;

    /* semantic routine */
#line 1790 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Halfword and Zero Indexed\n"));
#line 21247 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Halfword_and_Zero_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1790 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = MEM(unsigned, EA, 2);
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 21266 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.279,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21270 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Equivalent_Rc0(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Equivalent_Rc0
#line 3060 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Equivalent\n"));
#line 21289 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000238)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3060 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 21319 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Equivalent_Rc0;

    /* semantic routine */
#line 3060 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Equivalent\n"));
#line 21329 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Equivalent, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3060 "../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS ^ *rB); /* A === B */
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 21345 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21349 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Equivalent_Rc1(cpu *processor,
                      instruction_word instruction,
                      unsigned_word cia,
                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Equivalent
#undef MY_PREFIX
#define MY_PREFIX Equivalent_Rc1
#line 3060 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Equivalent\n"));
#line 21368 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000238)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3060 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 21398 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Equivalent_Rc1;

    /* semantic routine */
#line 3060 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Equivalent\n"));
#line 21408 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Equivalent, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3060 "../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS ^ *rB); /* A === B */
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 21424 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.284,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21428 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_TLB_Invalidate_Entry(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Invalidate_Entry
#undef MY_PREFIX
#define MY_PREFIX TLB_Invalidate_Entry
#line 4980 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode TLB Invalidate Entry\n"));
#line 21447 "icache.c"

  /* validate: 0.31,6./,11./,16.RB,21.306,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffff07ff) != 0x7c000264)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11./,16.RB,21.306,31./ #define get-values-from-icache|put-values-in-icache */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21462 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_TLB_Invalidate_Entry;

    /* semantic routine */
#line 4980 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics TLB Invalidate Entry\n"));
#line 21472 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_TLB_Invalidate_Entry, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4980 "../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else {
        int nr = 0;
        cpu *proc;
        while (1) {
          proc = psim_cpu(cpu_system(processor), nr);
          if (proc == NULL) break;
          cpu_page_tlb_invalidate_entry(proc, *rB);
          nr++;
        }
      }
    }
#line 21497 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11./,16.RB,21.306,31./ #undef get-values-from-icache|put-values-in-icache */
#line 21500 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Halfword_and_Zero_with_Update_Indexed(cpu *processor,
                                                  instruction_word instruction,
                                                  unsigned_word cia,
                                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_and_Zero_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_and_Zero_with_Update_Indexed
#line 1817 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Halfword and Zero with Update Indexed\n"));
#line 21519 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.311,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00026e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.311,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21547 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Halfword_and_Zero_with_Update_Indexed;

    /* semantic routine */
#line 1817 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Halfword and Zero with Update Indexed\n"));
#line 21557 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Halfword_and_Zero_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1817 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0 || RA == RT)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *rT = MEM(unsigned, EA, 2);
      *rA = EA;
      PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
    }
#line 21577 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.311,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21581 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_XOR_Rc0(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR
#undef MY_PREFIX
#define MY_PREFIX XOR_Rc0
#line 3030 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode XOR\n"));
#line 21600 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000278)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3030 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 21630 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_XOR_Rc0;

    /* semantic routine */
#line 3030 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics XOR\n"));
#line 21640 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_XOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3030 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS ^ *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 21656 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21660 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_XOR_Rc1(cpu *processor,
               instruction_word instruction,
               unsigned_word cia,
               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_XOR
#undef MY_PREFIX
#define MY_PREFIX XOR_Rc1
#line 3030 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode XOR\n"));
#line 21679 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000278)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3030 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 21709 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_XOR_Rc1;

    /* semantic routine */
#line 3030 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics XOR\n"));
#line 21719 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_XOR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3030 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS ^ *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 21735 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.316,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 21739 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_from_Special_Purpose_Register_SPR256(cpu *processor,
                                                 instruction_word instruction,
                                                 unsigned_word cia,
                                                 idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_from_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_from_Special_Purpose_Register_SPR256
#line 3388 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move from Special Purpose Register\n"));
#line 21758 "icache.c"

  /* validate: 0.31,6.RT,11.SPR,21.339,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 3388 "../../sim/ppc/powerpc.igen"
    unsigned const SPR ATTRIBUTE_UNUSED = 256; /* default in icache - constant field */
#line 21775 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_from_Special_Purpose_Register_SPR256;

    /* semantic routine */
#line 3388 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move from Special Purpose Register\n"));
#line 21785 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_from_Special_Purpose_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3388 "../../sim/ppc/powerpc.igen"
    {
      int n = (SPR_5_9_ << 5) | SPR_0_4_;
      if (SPR_0_ && IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else if (!spr_is_valid(n))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        /* HACK - time base registers need to be calculated */
        if (WITH_TIME_BASE) {
          switch (n) {
          case spr_dec:
            *rT = cpu_get_decrementer(processor);
            break;
      	case spr_tbrl:
        	  if (is_64bit_implementation) *rT = TB;
        	  else                         *rT = EXTRACTED64(TB, 32, 63);
      	break;
      	case spr_tbru:
        	  if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
      	  else                         *rT = EXTRACTED64(TB, 0, 31);
      	break;
          case spr_tbu:
          case spr_tbl:
            /* NOTE - these SPR's are not readable. Use mftb[ul] */
          default:
            *rT = SPREG(n);
            break;
          }
        }
        else {
          *rT = SPREG(n);
        }
      }
      PPC_INSN_FROM_SPR(RT_BITMASK, n);
    }
#line 21832 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #undef get-values-from-icache|put-values-in-icache */
#line 21835 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_from_Special_Purpose_Register_SPR(cpu *processor,
                                              instruction_word instruction,
                                              unsigned_word cia,
                                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_from_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_from_Special_Purpose_Register_SPR
#line 3388 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move from Special Purpose Register\n"));
#line 21854 "icache.c"

  /* validate: 0.31,6.RT,11.SPR,21.339,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 3388 "../../sim/ppc/powerpc.igen"
    unsigned const SPR ATTRIBUTE_UNUSED = cache_entry->crack.XFX.SPR = EXTRACTED32(instruction, 11, 20); /* default in icache - extraction */
#line 21871 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_from_Special_Purpose_Register_SPR;

    /* semantic routine */
#line 3388 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move from Special Purpose Register\n"));
#line 21881 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_from_Special_Purpose_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3388 "../../sim/ppc/powerpc.igen"
    {
      int n = (SPR_5_9_ << 5) | SPR_0_4_;
      if (SPR_0_ && IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else if (!spr_is_valid(n))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        /* HACK - time base registers need to be calculated */
        if (WITH_TIME_BASE) {
          switch (n) {
          case spr_dec:
            *rT = cpu_get_decrementer(processor);
            break;
      	case spr_tbrl:
        	  if (is_64bit_implementation) *rT = TB;
        	  else                         *rT = EXTRACTED64(TB, 32, 63);
      	break;
      	case spr_tbru:
        	  if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
      	  else                         *rT = EXTRACTED64(TB, 0, 31);
      	break;
          case spr_tbu:
          case spr_tbl:
            /* NOTE - these SPR's are not readable. Use mftb[ul] */
          default:
            *rT = SPREG(n);
            break;
          }
        }
        else {
          *rT = SPREG(n);
        }
      }
      PPC_INSN_FROM_SPR(RT_BITMASK, n);
    }
#line 21928 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.SPR,21.339,31./ #undef get-values-from-icache|put-values-in-icache */
#line 21931 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Halfword_Algebraic_Indexed(cpu *processor,
                                       instruction_word instruction,
                                       unsigned_word cia,
                                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_Indexed
#line 1844 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Halfword Algebraic Indexed\n"));
#line 21950 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.343,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002ae)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.343,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 21978 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Halfword_Algebraic_Indexed;

    /* semantic routine */
#line 1844 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Halfword Algebraic Indexed\n"));
#line 21988 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Halfword_Algebraic_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1844 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = MEM(signed, EA, 2);
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 22007 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.343,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22011 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_TLB_Invalidate_All(cpu *processor,
                          instruction_word instruction,
                          unsigned_word cia,
                          idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Invalidate_All
#undef MY_PREFIX
#define MY_PREFIX TLB_Invalidate_All
#line 4995 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode TLB Invalidate All\n"));
#line 22030 "icache.c"

  /* validate: 0.31,6./,11./,16./,21.370,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x7c0002e4)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11./,16./,21.370,31./ #define get-values-from-icache|put-values-in-icache */
#line 22039 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_TLB_Invalidate_All;

    /* semantic routine */
#line 4995 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics TLB Invalidate All\n"));
#line 22049 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_TLB_Invalidate_All, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4995 "../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else {
        int nr = 0;
        cpu *proc;
        while (1) {
          proc = psim_cpu(cpu_system(processor), nr);
          if (proc == NULL) break;
          cpu_page_tlb_invalidate_all(proc);
          nr++;
        }
      }
    }
#line 22074 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11./,16./,21.370,31./ #undef get-values-from-icache|put-values-in-icache */
#line 22077 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_From_Time_Base(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Time_Base
#undef MY_PREFIX
#define MY_PREFIX Move_From_Time_Base
#line 4838 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move From Time Base\n"));
#line 22096 "icache.c"

  /* validate: 0.31,6.RT,11.tbr,21.371,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002e6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.tbr,21.371,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 4838 "../../sim/ppc/powerpc.igen"
    unsigned const tbr ATTRIBUTE_UNUSED = cache_entry->crack.XFX.tbr = EXTRACTED32(instruction, 11, 20); /* default in icache - extraction */
#line 22113 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_From_Time_Base;

    /* semantic routine */
#line 4838 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move From Time Base\n"));
#line 22123 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_From_Time_Base, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4838 "../../sim/ppc/powerpc.igen"
    {
      int n = (tbr_5_9_ << 5) | tbr_0_4_;
      if (n == 268) {
        if (is_64bit_implementation) *rT = TB;
        else                         *rT = EXTRACTED64(TB, 32, 63);
      }
      else if (n == 269) {
        if (is_64bit_implementation) *rT = EXTRACTED64(TB, 0, 31);
        else                         *rT = EXTRACTED64(TB, 0, 31);
      }
      else
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
    }
#line 22147 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.tbr,21.371,31./ #undef get-values-from-icache|put-values-in-icache */
#line 22150 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Halfword_Algebraic_with_Update_Indexed(cpu *processor,
                                                   instruction_word instruction,
                                                   unsigned_word cia,
                                                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Halfword_Algebraic_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Halfword_Algebraic_with_Update_Indexed
#line 1871 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Halfword Algebraic with Update Indexed\n"));
#line 22169 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.375,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0002ee)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.375,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 22197 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Halfword_Algebraic_with_Update_Indexed;

    /* semantic routine */
#line 1871 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Halfword Algebraic with Update Indexed\n"));
#line 22207 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Halfword_Algebraic_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 1871 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0 || RA == RT)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *rT = MEM(signed, EA, 2);
      *rA = EA;
      PPC_INSN_INT(RT_BITMASK | RA_BITMASK, RA_BITMASK | RB_BITMASK, 0);
    }
#line 22227 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.375,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22231 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Half_Word_Indexed(cpu *processor,
                               instruction_word instruction,
                               unsigned_word cia,
                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_Indexed
#line 2071 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Half Word Indexed\n"));
#line 22250 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.407,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00032e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.407,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 22278 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Half_Word_Indexed;

    /* semantic routine */
#line 2071 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Half Word Indexed\n"));
#line 22288 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Half_Word_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2071 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      STORE(EA, 2, *rS);
      PPC_INSN_INT(0, (RA_BITMASK & ~1) | RB_BITMASK | RS_BITMASK, 0);
    }
#line 22307 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.407,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22311 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_with_Complement_Rc0(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX OR_with_Complement_Rc0
#line 3080 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR with Complement\n"));
#line 22330 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000338)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3080 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 22360 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_with_Complement_Rc0;

    /* semantic routine */
#line 3080 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR with Complement\n"));
#line 22370 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3080 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | ~*rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 22386 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22390 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_with_Complement_Rc1(cpu *processor,
                              instruction_word instruction,
                              unsigned_word cia,
                              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR_with_Complement
#undef MY_PREFIX
#define MY_PREFIX OR_with_Complement_Rc1
#line 3080 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR with Complement\n"));
#line 22409 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000338)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3080 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 22439 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_with_Complement_Rc1;

    /* semantic routine */
#line 3080 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR with Complement\n"));
#line 22449 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR_with_Complement, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3080 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | ~*rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 22465 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.412,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22469 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Store_Half_Word_with_Update_Indexed(cpu *processor,
                                           instruction_word instruction,
                                           unsigned_word cia,
                                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Store_Half_Word_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Store_Half_Word_with_Update_Indexed
#line 2098 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Store Half Word with Update Indexed\n"));
#line 22488 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.439,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00036e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.439,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 22516 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Store_Half_Word_with_Update_Indexed;

    /* semantic routine */
#line 2098 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Store Half Word with Update Indexed\n"));
#line 22526 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Store_Half_Word_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2098 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      STORE(EA, 2, *rS);
      *rA = EA;
      PPC_INSN_INT(RA_BITMASK, RA_BITMASK | RB_BITMASK | RS_BITMASK, 0);
    }
#line 22546 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.439,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22550 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_Rc0(cpu *processor,
              instruction_word instruction,
              unsigned_word cia,
              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR
#undef MY_PREFIX
#define MY_PREFIX OR_Rc0
#line 3020 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR\n"));
#line 22569 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000378)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3020 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 22599 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_Rc0;

    /* semantic routine */
#line 3020 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR\n"));
#line 22609 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3020 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 22625 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22629 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_OR_Rc1(cpu *processor,
              instruction_word instruction,
              unsigned_word cia,
              idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_OR
#undef MY_PREFIX
#define MY_PREFIX OR_Rc1
#line 3020 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode OR\n"));
#line 22648 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000378)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3020 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 22678 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_OR_Rc1;

    /* semantic routine */
#line 3020 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics OR\n"));
#line 22688 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_OR, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3020 "../../sim/ppc/powerpc.igen"
    {
      *rA = *rS | *rB;
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 22704 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.444,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22708 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Divide_Word_Unsigned_OE0_Rc0(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE0_Rc0
#line 2767 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Divide Word Unsigned\n"));
#line 22727 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000396)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2767 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2767 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 22759 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Divide_Word_Unsigned_OE0_Rc0;

    /* semantic routine */
#line 2767 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 22769 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Divide_Word_Unsigned, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2767 "../../sim/ppc/powerpc.igen"
    {
      uint64_t dividend = (uint32_t)(*rA);
      uint64_t divisor = (uint32_t)(*rB);
      if (divisor == 0) {
        if (OE)
          XER |= (xer_overflow | xer_summary_overflow);
        CR0_COMPARE(0, 0, Rc);
      }
      else {
        uint64_t quotent = dividend / divisor;
        *rT = quotent;
        CR0_COMPARE((signed_word)quotent, 0, Rc);
      }
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 22794 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22798 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Divide_Word_Unsigned_OE0_Rc1(cpu *processor,
                                    instruction_word instruction,
                                    unsigned_word cia,
                                    idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word_Unsigned
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_Unsigned_OE0_Rc1
#line 2767 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Divide Word Unsigned\n"));
#line 22817 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000396)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2767 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2767 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 22849 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Divide_Word_Unsigned_OE0_Rc1;

    /* semantic routine */
#line 2767 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Divide Word Unsigned\n"));
#line 22859 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Divide_Word_Unsigned, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2767 "../../sim/ppc/powerpc.igen"
    {
      uint64_t dividend = (uint32_t)(*rA);
      uint64_t divisor = (uint32_t)(*rB);
      if (divisor == 0) {
        if (OE)
          XER |= (xer_overflow | xer_summary_overflow);
        CR0_COMPARE(0, 0, Rc);
      }
      else {
        uint64_t quotent = dividend / divisor;
        *rT = quotent;
        CR0_COMPARE((signed_word)quotent, 0, Rc);
      }
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 22884 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.459,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 22888 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_to_Special_Purpose_Register_SPR256(cpu *processor,
                                               instruction_word instruction,
                                               unsigned_word cia,
                                               idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_to_Special_Purpose_Register_SPR256
#line 3344 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move to Special Purpose Register\n"));
#line 22907 "icache.c"

  /* validate: 0.31,6.RS,11.SPR,21.467,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0003a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 3344 "../../sim/ppc/powerpc.igen"
    unsigned const SPR ATTRIBUTE_UNUSED = 256; /* default in icache - constant field */
#line 22924 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_to_Special_Purpose_Register_SPR256;

    /* semantic routine */
#line 3344 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move to Special Purpose Register\n"));
#line 22934 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_to_Special_Purpose_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3344 "../../sim/ppc/powerpc.igen"
    {
      int n = (SPR_5_9_ << 5) | SPR_0_4_;
      if (SPR_0_ && IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else if (!spr_is_valid(n)
               || spr_is_readonly(n))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        spreg new_val = (spr_length(n) == 64
      		   ? *rS
      		   : MASKED(*rS, 32, 63));
        /* HACK - time base registers need to be updated immediately */
        if (WITH_TIME_BASE) {
          switch (n) {
          case spr_tbu:
            cpu_set_time_base(processor,
                              (MASKED64(cpu_get_time_base(processor), 32, 63)
                               | INSERTED64(new_val, 0, 31)));
            break;
          case spr_tbl:
            cpu_set_time_base(processor,
                              (MASKED64(cpu_get_time_base(processor), 0, 31)
                               | INSERTED64(new_val, 32, 63)));
            break;
          case spr_dec:
            cpu_set_decrementer(processor, new_val);
            break;
          default:
            SPREG(n) = new_val;
            break;
          }
        }
        else {
          SPREG(n) = new_val;
        }
      }
      PPC_INSN_TO_SPR(RS_BITMASK, n);
    }
#line 22984 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #undef get-values-from-icache|put-values-in-icache */
#line 22987 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_to_Special_Purpose_Register_SPR(cpu *processor,
                                            instruction_word instruction,
                                            unsigned_word cia,
                                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Special_Purpose_Register
#undef MY_PREFIX
#define MY_PREFIX Move_to_Special_Purpose_Register_SPR
#line 3344 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move to Special Purpose Register\n"));
#line 23006 "icache.c"

  /* validate: 0.31,6.RS,11.SPR,21.467,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0003a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.XFX.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XFX.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 3344 "../../sim/ppc/powerpc.igen"
    unsigned const SPR ATTRIBUTE_UNUSED = cache_entry->crack.XFX.SPR = EXTRACTED32(instruction, 11, 20); /* default in icache - extraction */
#line 23023 "icache.c"

#define insn cache_entry->crack.XFX.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_to_Special_Purpose_Register_SPR;

    /* semantic routine */
#line 3344 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move to Special Purpose Register\n"));
#line 23033 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_to_Special_Purpose_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3344 "../../sim/ppc/powerpc.igen"
    {
      int n = (SPR_5_9_ << 5) | SPR_0_4_;
      if (SPR_0_ && IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else if (!spr_is_valid(n)
               || spr_is_readonly(n))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      else {
        spreg new_val = (spr_length(n) == 64
      		   ? *rS
      		   : MASKED(*rS, 32, 63));
        /* HACK - time base registers need to be updated immediately */
        if (WITH_TIME_BASE) {
          switch (n) {
          case spr_tbu:
            cpu_set_time_base(processor,
                              (MASKED64(cpu_get_time_base(processor), 32, 63)
                               | INSERTED64(new_val, 0, 31)));
            break;
          case spr_tbl:
            cpu_set_time_base(processor,
                              (MASKED64(cpu_get_time_base(processor), 0, 31)
                               | INSERTED64(new_val, 32, 63)));
            break;
          case spr_dec:
            cpu_set_decrementer(processor, new_val);
            break;
          default:
            SPREG(n) = new_val;
            break;
          }
        }
        else {
          SPREG(n) = new_val;
        }
      }
      PPC_INSN_TO_SPR(RS_BITMASK, n);
    }
#line 23083 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.SPR,21.467,31./ #undef get-values-from-icache|put-values-in-icache */
#line 23086 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Data_Cache_Block_Invalidate(cpu *processor,
                                   instruction_word instruction,
                                   unsigned_word cia,
                                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Data_Cache_Block_Invalidate
#undef MY_PREFIX
#define MY_PREFIX Data_Cache_Block_Invalidate
#line 4916 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Data Cache Block Invalidate\n"));
#line 23105 "icache.c"

  /* validate: 0.31,6./,11.RA,16.RB,21.470,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffe007ff) != 0x7c0003ac)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.470,31./ #define get-values-from-icache|put-values-in-icache */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 23127 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Data_Cache_Block_Invalidate;

    /* semantic routine */
#line 4916 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Data Cache Block Invalidate\n"));
#line 23137 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Data_Cache_Block_Invalidate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4916 "../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else
        TRACE(trace_tbd,("Data Cache Block Invalidate\n"));
    }
#line 23154 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11.RA,16.RB,21.470,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23158 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_NAND_Rc0(cpu *processor,
                instruction_word instruction,
                unsigned_word cia,
                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_NAND
#undef MY_PREFIX
#define MY_PREFIX NAND_Rc0
#line 3040 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode NAND\n"));
#line 23177 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c0003b8)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3040 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 23207 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_NAND_Rc0;

    /* semantic routine */
#line 3040 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics NAND\n"));
#line 23217 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_NAND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3040 "../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS & *rB);
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 23233 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23237 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_NAND_Rc1(cpu *processor,
                instruction_word instruction,
                unsigned_word cia,
                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_NAND
#undef MY_PREFIX
#define MY_PREFIX NAND_Rc1
#line 3040 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode NAND\n"));
#line 23256 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c0003b8)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3040 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 23286 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_NAND_Rc1;

    /* semantic routine */
#line 3040 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics NAND\n"));
#line 23296 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_NAND, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3040 "../../sim/ppc/powerpc.igen"
    {
      *rA = ~(*rS & *rB);
      CR0_COMPARE(*rA, 0, Rc);
      ITRACE(trace_alu, (" Result = %ld (0x%lx)\n", (long)*rA, (long)*rA));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK | RB_BITMASK, Rc);
    }
#line 23312 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.476,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23316 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Divide_Word_OE0_Rc0(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE0_Rc0
#line 2745 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Divide Word\n"));
#line 23335 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c0003d6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2745 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2745 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 23367 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Divide_Word_OE0_Rc0;

    /* semantic routine */
#line 2745 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 23377 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Divide_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2745 "../../sim/ppc/powerpc.igen"
    {
      int64_t dividend = (int32_t)(*rA);
      int64_t divisor = (int32_t)(*rB);
      if (divisor == 0 /* nb 0x8000..0 is sign extended */
          || (dividend == 0x80000000 && divisor == -1)) {
        if (OE)
          XER |= (xer_overflow | xer_summary_overflow);
        CR0_COMPARE(0, 0, Rc);
      }
      else {
        int64_t quotent = dividend / divisor;
        *rT = quotent;
        CR0_COMPARE((signed_word)quotent, 0, Rc);
      }
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23403 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23407 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Divide_Word_OE0_Rc1(cpu *processor,
                           instruction_word instruction,
                           unsigned_word cia,
                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Divide_Word
#undef MY_PREFIX
#define MY_PREFIX Divide_Word_OE0_Rc1
#line 2745 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Divide Word\n"));
#line 23426 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c0003d6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2745 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 2745 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 23458 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Divide_Word_OE0_Rc1;

    /* semantic routine */
#line 2745 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Divide Word\n"));
#line 23468 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Divide_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2745 "../../sim/ppc/powerpc.igen"
    {
      int64_t dividend = (int32_t)(*rA);
      int64_t divisor = (int32_t)(*rB);
      if (divisor == 0 /* nb 0x8000..0 is sign extended */
          || (dividend == 0x80000000 && divisor == -1)) {
        if (OE)
          XER |= (xer_overflow | xer_summary_overflow);
        CR0_COMPARE(0, 0, Rc);
      }
      else {
        int64_t quotent = dividend / divisor;
        *rT = quotent;
        CR0_COMPARE((signed_word)quotent, 0, Rc);
      }
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23494 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.491,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23498 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_to_Condition_Register_from_XER(cpu *processor,
                                           instruction_word instruction,
                                           unsigned_word cia,
                                           idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_to_Condition_Register_from_XER
#undef MY_PREFIX
#define MY_PREFIX Move_to_Condition_Register_from_XER
#line 3444 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move to Condition Register from XER\n"));
#line 23517 "icache.c"

  /* validate: 0.31,6.BF,9./,11./,16./,21.512,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc7fffff) != 0x7c000400)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.BF,9./,11./,16./,21.512,31./ #define get-values-from-icache|put-values-in-icache */
#line 67 "../../sim/ppc/powerpc.igen"
    unsigned const BF ATTRIBUTE_UNUSED = cache_entry->crack.X.BF = EXTRACTED32(instruction, 6, 8); /* in icache - extraction */
#line 68 "../../sim/ppc/powerpc.igen"
    uint32_t const BF_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.BF_BITMASK = (1 << BF); /* in icache - extraction */
#line 23530 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_to_Condition_Register_from_XER;

    /* semantic routine */
#line 3444 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move to Condition Register from XER\n"));
#line 23540 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_to_Condition_Register_from_XER, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3444 "../../sim/ppc/powerpc.igen"
    error("%s:%d:0x%08lx:%s unimplemented\n",
          itable[MY_INDEX].file, itable[MY_INDEX].line_nr, (long)cia, itable[MY_INDEX].name);
#line 23552 "icache.c"
    return nia;
    /* extraction: 0.31,6.BF,9./,11./,16./,21.512,31./ #undef get-values-from-icache|put-values-in-icache */
#line 23555 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Carrying_OE1_Rc0(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE1_Rc0
#line 2596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Carrying\n"));
#line 23574 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000010)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2596 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2596 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 23606 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Carrying_OE1_Rc0;

    /* semantic routine */
#line 2596 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 23616 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2596 "../../sim/ppc/powerpc.igen"
    {
      /* RT <- ~RA + RB + 1 === RT <- RB - RA */
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23635 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23639 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_Carrying_OE1_Rc1(cpu *processor,
                                      instruction_word instruction,
                                      unsigned_word cia,
                                      idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From_Carrying
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_Carrying_OE1_Rc1
#line 2596 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From Carrying\n"));
#line 23658 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000010)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2596 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2596 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 23690 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_Carrying_OE1_Rc1;

    /* semantic routine */
#line 2596 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From Carrying\n"));
#line 23700 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2596 "../../sim/ppc/powerpc.igen"
    {
      /* RT <- ~RA + RB + 1 === RT <- RB - RA */
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23719 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.8,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23723 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Carrying_OE1_Rc0(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE1_Rc0
#line 2586 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Carrying\n"));
#line 23742 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000014)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2586 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2586 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 23774 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Carrying_OE1_Rc0;

    /* semantic routine */
#line 2586 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 23784 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2586 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23800 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23804 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Add_Carrying_OE1_Rc1(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Add_Carrying
#undef MY_PREFIX
#define MY_PREFIX Add_Carrying_OE1_Rc1
#line 2586 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Add Carrying\n"));
#line 23823 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000014)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2586 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2586 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 23855 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Add_Carrying_OE1_Rc1;

    /* semantic routine */
#line 2586 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Add Carrying\n"));
#line 23865 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Add_Carrying, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2586 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_ADD(*rB);
      ALU_END(*rT, 1/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 23881 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.10,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23885 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_String_Word_Indexed(cpu *processor,
                                instruction_word instruction,
                                unsigned_word cia,
                                idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_String_Word_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_String_Word_Indexed
#line 2328 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load String Word Indexed\n"));
#line 23904 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.533,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00042a)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.533,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 23932 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_String_Word_Indexed;

    /* semantic routine */
#line 2328 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load String Word Indexed\n"));
#line 23942 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_String_Word_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2328 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      unsigned_word b;
      int n;
      int r;
      int i;
      int nr;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      n = EXTRACTED32(XER, 25, 31);
      r = RT - 1;
      i = 32;
      nr = (n + 3) / 4;
      if (((RT + nr >= 32)
           ? ((RA >= RT || RA < (RT + nr) % 32)
              || (RB >= RT || RB < (RT + nr) % 32))
           : ((RA >= RT && RA < RT + nr)
              || (RB >= RT && RB < RT + nr)))
          || (RT == RA || RT == RB))
        program_interrupt(processor, cia,
                        illegal_instruction_program_interrupt);
      if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
        alignment_interrupt(processor, cia, EA);
      while (n > 0) {
        if (i == 32) {
          r = (r + 1) % 32;
          GPR(r) = 0;
        }
        GPR(r) |= INSERTED(MEM(unsigned, EA, 1), i, i+7);
        i = i + 8;
        if (i == 64) i = 32;
        EA = EA + 1;
        n = n - 1;
      }
    }
#line 23988 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.533,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 23992 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_Word_ByteReverse_Indexed(cpu *processor,
                                     instruction_word instruction,
                                     unsigned_word cia,
                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_Word_ByteReverse_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_Word_ByteReverse_Indexed
#line 2215 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Word Byte-Reverse Indexed\n"));
#line 24011 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.534,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00042c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.534,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 24039 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_Word_ByteReverse_Indexed;

    /* semantic routine */
#line 2215 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Word Byte-Reverse Indexed\n"));
#line 24049 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_Word_ByteReverse_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2215 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *rT = SWAP_4(MEM(unsigned, EA, 4));
      PPC_INSN_INT(RT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 24068 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.534,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24072 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_FloatingPoint_Single_Indexed(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_Indexed
#line 3477 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Floating-Point Single Indexed\n"));
#line 24091 "icache.c"

  /* validate: 0.31,6.FRT,11.RA,16.RB,21.535,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00042e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP hardware exists */
  if (CURRENT_FLOATING_POINT != HARD_FLOATING_POINT)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP available according to MSR[FP] */
  if (!IS_FP_AVAILABLE(processor))
    return icache_floating_point_unavailable(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.535,31./ #define get-values-from-icache|put-values-in-icache */
#define FRT EXTRACTED32(instruction, 6, 10) /* icache scratch - extraction */
#line 62 "../../sim/ppc/powerpc.igen"
    uint64_t * const frT ATTRIBUTE_UNUSED = cache_entry->crack.X.frT = (cpu_registers(processor)->fpr + FRT); /* in icache - extraction */
#line 63 "../../sim/ppc/powerpc.igen"
    uint32_t const FRT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.FRT_BITMASK = (1 << FRT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 24126 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_FloatingPoint_Single_Indexed;

    /* semantic routine */
#line 3477 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Floating-Point Single Indexed\n"));
#line 24136 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_FloatingPoint_Single_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3477 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *frT = DOUBLE(MEM(unsigned, EA, 4));
      PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 24155 "icache.c"
    return nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.535,31./ #undef get-values-from-icache|put-values-in-icache */
#undef FRT
#undef RA_is_0
#line 24160 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Shift_Right_Word_Rc0(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Word_Rc0
#line 3271 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Shift Right Word\n"));
#line 24179 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000430)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3271 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 24209 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Shift_Right_Word_Rc0;

    /* semantic routine */
#line 3271 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Shift Right Word\n"));
#line 24219 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Shift_Right_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3271 "../../sim/ppc/powerpc.igen"
    {
      int n = MASKED(*rB, 58, 63);
      uint32_t source = *rS;
      signed_word shifted;
      if (n < 32)
        shifted = (source >> n);
      else
        shifted = 0;
      *rA = shifted;
      CR0_COMPARE(shifted, 0, Rc);
      ITRACE(trace_alu, \
             ("n=%d, source=0x%lx, shifted=0x%lx\n",
              n, (unsigned long)source, (unsigned long)shifted));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 24244 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24248 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Shift_Right_Word_Rc1(cpu *processor,
                            instruction_word instruction,
                            unsigned_word cia,
                            idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Shift_Right_Word
#undef MY_PREFIX
#define MY_PREFIX Shift_Right_Word_Rc1
#line 3271 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Shift Right Word\n"));
#line 24267 "icache.c"

  /* validate: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007fe) != 0x7c000430)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 43 "../../sim/ppc/powerpc.igen"
    unsigned const RS ATTRIBUTE_UNUSED = cache_entry->crack.X.RS = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 44 "../../sim/ppc/powerpc.igen"
    signed_word * const rS ATTRIBUTE_UNUSED = cache_entry->crack.X.rS = (cpu_registers(processor)->gpr + RS); /* in icache - extraction */
#line 45 "../../sim/ppc/powerpc.igen"
    uint32_t const RS_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RS_BITMASK = (1 << RS); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 3271 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 24297 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Shift_Right_Word_Rc1;

    /* semantic routine */
#line 3271 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Shift Right Word\n"));
#line 24307 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Shift_Right_Word, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3271 "../../sim/ppc/powerpc.igen"
    {
      int n = MASKED(*rB, 58, 63);
      uint32_t source = *rS;
      signed_word shifted;
      if (n < 32)
        shifted = (source >> n);
      else
        shifted = 0;
      *rA = shifted;
      CR0_COMPARE(shifted, 0, Rc);
      ITRACE(trace_alu, \
             ("n=%d, source=0x%lx, shifted=0x%lx\n",
              n, (unsigned long)source, (unsigned long)shifted));
      PPC_INSN_INT(RA_BITMASK, RS_BITMASK, Rc);
    }
#line 24332 "icache.c"
    return nia;
    /* extraction: 0.31,6.RS,11.RA,16.RB,21.536,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24336 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_OE1_Rc0(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE1_Rc0
#line 2542 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From\n"));
#line 24355 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000050)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2542 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2542 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 0; /* default in icache - constant field */
#line 24387 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_OE1_Rc0;

    /* semantic routine */
#line 2542 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 24397 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2542 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 24415 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24419 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Subtract_From_OE1_Rc1(cpu *processor,
                             instruction_word instruction,
                             unsigned_word cia,
                             idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Subtract_From
#undef MY_PREFIX
#define MY_PREFIX Subtract_From_OE1_Rc1
#line 2542 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Subtract From\n"));
#line 24438 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0003fe) != 0x7c000050)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.XO.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.XO.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.XO.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.XO.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 2542 "../../sim/ppc/powerpc.igen"
    unsigned const OE ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 2542 "../../sim/ppc/powerpc.igen"
    unsigned const Rc ATTRIBUTE_UNUSED = 1; /* default in icache - constant field */
#line 24470 "icache.c"

#define insn cache_entry->crack.XO.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Subtract_From_OE1_Rc1;

    /* semantic routine */
#line 2542 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Subtract From\n"));
#line 24480 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Subtract_From, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2542 "../../sim/ppc/powerpc.igen"
    {
      ALU_BEGIN(*rA);
      ALU_NOT;
      ALU_ADD(*rB);
      ALU_ADD(1);
      ALU_END(*rT, 0/*CA*/, OE, Rc);
      PPC_INSN_INT(RT_BITMASK, RA_BITMASK | RB_BITMASK, Rc);
    }
#line 24498 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.RB,21.OE,22.40,31.Rc #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24502 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_TLB_Synchronize(cpu *processor,
                       instruction_word instruction,
                       unsigned_word cia,
                       idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_TLB_Synchronize
#undef MY_PREFIX
#define MY_PREFIX TLB_Synchronize
#line 5010 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode TLB Synchronize\n"));
#line 24521 "icache.c"

  /* validate: 0.31,6./,11./,16./,21.566,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xffffffff) != 0x7c00046c)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,11./,16./,21.566,31./ #define get-values-from-icache|put-values-in-icache */
#line 24530 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_TLB_Synchronize;

    /* semantic routine */
#line 5010 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics TLB Synchronize\n"));
#line 24540 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_TLB_Synchronize, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 5010 "../../sim/ppc/powerpc.igen"
    {
      /* nothing happens here - always in sync */
    }
#line 24553 "icache.c"
    return nia;
    /* extraction: 0.31,6./,11./,16./,21.566,31./ #undef get-values-from-icache|put-values-in-icache */
#line 24556 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_FloatingPoint_Single_with_Update_Indexed(cpu *processor,
                                                     instruction_word instruction,
                                                     unsigned_word cia,
                                                     idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Single_with_Update_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Single_with_Update_Indexed
#line 3504 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Floating-Point Single with Update Indexed\n"));
#line 24575 "icache.c"

  /* validate: 0.31,6.FRT,11.RA,16.RB,21.567,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c00046e)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP hardware exists */
  if (CURRENT_FLOATING_POINT != HARD_FLOATING_POINT)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP available according to MSR[FP] */
  if (!IS_FP_AVAILABLE(processor))
    return icache_floating_point_unavailable(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.567,31./ #define get-values-from-icache|put-values-in-icache */
#define FRT EXTRACTED32(instruction, 6, 10) /* icache scratch - extraction */
#line 62 "../../sim/ppc/powerpc.igen"
    uint64_t * const frT ATTRIBUTE_UNUSED = cache_entry->crack.X.frT = (cpu_registers(processor)->fpr + FRT); /* in icache - extraction */
#line 63 "../../sim/ppc/powerpc.igen"
    uint32_t const FRT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.FRT_BITMASK = (1 << FRT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 24610 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_FloatingPoint_Single_with_Update_Indexed;

    /* semantic routine */
#line 3504 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Floating-Point Single with Update Indexed\n"));
#line 24620 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_FloatingPoint_Single_with_Update_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3504 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      if (RA_is_0)
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      EA = *rA + *rB;
      *frT = DOUBLE(MEM(unsigned, EA, 4));
      *rA = EA;
      PPC_INSN_INT_FLOAT(RA_BITMASK, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 24640 "icache.c"
    return nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.567,31./ #undef get-values-from-icache|put-values-in-icache */
#undef FRT
#undef RA_is_0
#line 24645 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Move_From_Segment_Register(cpu *processor,
                                  instruction_word instruction,
                                  unsigned_word cia,
                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Move_From_Segment_Register
#undef MY_PREFIX
#define MY_PREFIX Move_From_Segment_Register
#line 4953 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Move From Segment Register\n"));
#line 24664 "icache.c"

  /* validate: 0.31,6.RT,11./,12.SR,16./,21.595,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc10ffff) != 0x7c0004a6)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11./,12.SR,16./,21.595,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 4953 "../../sim/ppc/powerpc.igen"
    unsigned const SR ATTRIBUTE_UNUSED = cache_entry->crack.X.SR = EXTRACTED32(instruction, 12, 15); /* default in icache - extraction */
#line 24681 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Move_From_Segment_Register;

    /* semantic routine */
#line 4953 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Move From Segment Register\n"));
#line 24691 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Move_From_Segment_Register, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 4953 "../../sim/ppc/powerpc.igen"
    {
      if (IS_PROBLEM_STATE(processor))
        program_interrupt(processor, cia,
                          privileged_instruction_program_interrupt);
      else
        *rT = SEGREG(SR);
    }
#line 24708 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11./,12.SR,16./,21.595,31./ #undef get-values-from-icache|put-values-in-icache */
#line 24711 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_String_Word_Immediate(cpu *processor,
                                  instruction_word instruction,
                                  unsigned_word cia,
                                  idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_String_Word_Immediate
#undef MY_PREFIX
#define MY_PREFIX Load_String_Word_Immediate
#line 2296 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load String Word Immediate\n"));
#line 24730 "icache.c"

  /* validate: 0.31,6.RT,11.RA,16.NB,21.597,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0004aa)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.RT,11.RA,16.NB,21.597,31./ #define get-values-from-icache|put-values-in-icache */
#line 40 "../../sim/ppc/powerpc.igen"
    unsigned const RT ATTRIBUTE_UNUSED = cache_entry->crack.X.RT = EXTRACTED32(instruction, 6, 10); /* in icache - extraction */
#line 41 "../../sim/ppc/powerpc.igen"
    signed_word * const rT ATTRIBUTE_UNUSED = cache_entry->crack.X.rT = (cpu_registers(processor)->gpr + RT); /* in icache - extraction */
#line 42 "../../sim/ppc/powerpc.igen"
    uint32_t const RT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RT_BITMASK = (1 << RT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 2296 "../../sim/ppc/powerpc.igen"
    unsigned const NB ATTRIBUTE_UNUSED = cache_entry->crack.X.NB = EXTRACTED32(instruction, 16, 20); /* default in icache - extraction */
#line 24754 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_String_Word_Immediate;

    /* semantic routine */
#line 2296 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load String Word Immediate\n"));
#line 24764 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_String_Word_Immediate, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2296 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word EA;
      int n;
      int r;
      int i;
      int nr;
      if (RA_is_0) EA = 0;
      else         EA = *rA;
      if (NB == 0) n = 32;
      else         n = NB;
      r = RT - 1;
      i = 32;
      nr = (n + 3) / 4;
      if ((RT + nr >= 32)
          ? (RA >= RT || RA < (RT + nr) % 32)
          : (RA >= RT && RA < RT + nr))
        program_interrupt(processor, cia,
                          illegal_instruction_program_interrupt);
      if (CURRENT_ALIGNMENT == STRICT_ALIGNMENT)
        alignment_interrupt(processor, cia, EA);
      while (n > 0) {
        if (i == 32) {
          r = (r + 1) % 32;
          GPR(r) = 0;
        }
        GPR(r) |= INSERTED(MEM(unsigned, EA, 1), i, i+7);
        i = i + 8;
        if (i == 64) i = 32;
        EA = EA + 1;
        n = n - 1;
      }
    }
#line 24806 "icache.c"
    return nia;
    /* extraction: 0.31,6.RT,11.RA,16.NB,21.597,31./ #undef get-values-from-icache|put-values-in-icache */
#undef RA_is_0
#line 24810 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Synchronize(cpu *processor,
                   instruction_word instruction,
                   unsigned_word cia,
                   idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Synchronize
#undef MY_PREFIX
#define MY_PREFIX Synchronize
#line 2500 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Synchronize\n"));
#line 24829 "icache.c"

  /* validate: 0.31,6./,9.L,11./,16./,21.598,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xff9fffff) != 0x7c0004ac)
    return icache_illegal(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6./,9.L,11./,16./,21.598,31./ #define get-values-from-icache|put-values-in-icache */
#line 2500 "../../sim/ppc/powerpc.igen"
    unsigned const L ATTRIBUTE_UNUSED = cache_entry->crack.X.L = EXTRACTED32(instruction, 9, 10); /* default in icache - extraction */
#line 24840 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Synchronize;

    /* semantic routine */
#line 2500 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Synchronize\n"));
#line 24850 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Synchronize, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 2500 "../../sim/ppc/powerpc.igen"
    {
      /* do nothing */
    }
#line 24863 "icache.c"
    return nia;
    /* extraction: 0.31,6./,9.L,11./,16./,21.598,31./ #undef get-values-from-icache|put-values-in-icache */
#line 24866 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(unsigned_word)
icache_Load_FloatingPoint_Double_Indexed(cpu *processor,
                                         instruction_word instruction,
                                         unsigned_word cia,
                                         idecode_cache *cache_entry)
{
#undef MY_INDEX
#define MY_INDEX itable_Load_FloatingPoint_Double_Indexed
#undef MY_PREFIX
#define MY_PREFIX Load_FloatingPoint_Double_Indexed
#line 3531 "../../sim/ppc/powerpc.igen"
  ITRACE(trace_idecode, ("idecode Load Floating-Point Double Indexed\n"));
#line 24885 "icache.c"

  /* validate: 0.31,6.FRT,11.RA,16.RB,21.599,31./ */
  if (WITH_RESERVED_BITS && (instruction & 0xfc0007ff) != 0x7c0004ae)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP hardware exists */
  if (CURRENT_FLOATING_POINT != HARD_FLOATING_POINT)
    return icache_illegal(processor, instruction, cia, cache_entry);

  /* Validate: FP available according to MSR[FP] */
  if (!IS_FP_AVAILABLE(processor))
    return icache_floating_point_unavailable(processor, instruction, cia, cache_entry);

  {
    unsigned_word nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.599,31./ #define get-values-from-icache|put-values-in-icache */
#define FRT EXTRACTED32(instruction, 6, 10) /* icache scratch - extraction */
#line 62 "../../sim/ppc/powerpc.igen"
    uint64_t * const frT ATTRIBUTE_UNUSED = cache_entry->crack.X.frT = (cpu_registers(processor)->fpr + FRT); /* in icache - extraction */
#line 63 "../../sim/ppc/powerpc.igen"
    uint32_t const FRT_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.FRT_BITMASK = (1 << FRT); /* in icache - extraction */
#line 36 "../../sim/ppc/powerpc.igen"
    unsigned const RA ATTRIBUTE_UNUSED = cache_entry->crack.X.RA = EXTRACTED32(instruction, 11, 15); /* in icache - extraction */
#line 37 "../../sim/ppc/powerpc.igen"
    signed_word * const rA ATTRIBUTE_UNUSED = cache_entry->crack.X.rA = (cpu_registers(processor)->gpr + RA); /* in icache - extraction */
#line 38 "../../sim/ppc/powerpc.igen"
    uint32_t const RA_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RA_BITMASK = (1 << RA); /* in icache - extraction */
#define RA_is_0 (RA == 0) /* semantic compute - extraction */
#line 46 "../../sim/ppc/powerpc.igen"
    unsigned const RB ATTRIBUTE_UNUSED = cache_entry->crack.X.RB = EXTRACTED32(instruction, 16, 20); /* in icache - extraction */
#line 47 "../../sim/ppc/powerpc.igen"
    signed_word * const rB ATTRIBUTE_UNUSED = cache_entry->crack.X.rB = (cpu_registers(processor)->gpr + RB); /* in icache - extraction */
#line 48 "../../sim/ppc/powerpc.igen"
    uint32_t const RB_BITMASK ATTRIBUTE_UNUSED = cache_entry->crack.X.RB_BITMASK = (1 << RB); /* in icache - extraction */
#line 24920 "icache.c"

#define insn cache_entry->crack.X.insn = instruction

    cache_entry->address = cia;
    cache_entry->semantic = semantic_Load_FloatingPoint_Double_Indexed;

    /* semantic routine */
#line 3531 "../../sim/ppc/powerpc.igen"
    ITRACE(trace_semantics, ("semantics Load Floating-Point Double Indexed\n"));
#line 24930 "icache.c"

    /* monitoring: */
    if (WITH_MON & MONITOR_INSTRUCTION_ISSUE) {
      mon_issue(itable_Load_FloatingPoint_Double_Indexed, processor, cia);
    }

    /* semantics: */
    nia = cia + 4;
#line 3531 "../../sim/ppc/powerpc.igen"
    {
      unsigned_word b;
      unsigned_word EA;
      if (RA_is_0) b = 0;
      else         b = *rA;
      EA = b + *rB;
      *frT = MEM(unsigned, EA, 8);
      PPC_INSN_INT_FLOAT(0, FRT_BITMASK, (RA_BITMASK & ~1) | RB_BITMASK, 0);
    }
#line 24949 "icache.c"
    return nia;
    /* extraction: 0.31,6.FRT,11.RA,16.RB,21.599,31./ #undef get-values-from-icache|put-values-in-icache */
#undef FRT
#undef RA_is_0
#line 24954 "icache.c"

#undef insn
  }
}

EXTERN_ICACHE\
(uns