// python wrapper for vtkPVFileInformationHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVFileInformationHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVFileInformationHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVFileInformationHelper_ClassNew(); }


static PyObject *
PyvtkPVFileInformationHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVFileInformationHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVFileInformationHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVFileInformationHelper *tempr = vtkPVFileInformationHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVFileInformationHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVFileInformationHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVFileInformationHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVFileInformationHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SetPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPath(temp0);
    }
    else
    {
      op->vtkPVFileInformationHelper::SetPath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetPath() :
      op->vtkPVFileInformationHelper::GetPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SetWorkingDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWorkingDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWorkingDirectory(temp0);
    }
    else
    {
      op->vtkPVFileInformationHelper::SetWorkingDirectory(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetWorkingDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWorkingDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetWorkingDirectory() :
      op->vtkPVFileInformationHelper::GetWorkingDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetDirectoryListing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDirectoryListing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDirectoryListing() :
      op->vtkPVFileInformationHelper::GetDirectoryListing());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SetDirectoryListing(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDirectoryListing");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDirectoryListing(temp0);
    }
    else
    {
      op->vtkPVFileInformationHelper::SetDirectoryListing(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_DirectoryListingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DirectoryListingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DirectoryListingOn();
    }
    else
    {
      op->vtkPVFileInformationHelper::DirectoryListingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_DirectoryListingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DirectoryListingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DirectoryListingOff();
    }
    else
    {
      op->vtkPVFileInformationHelper::DirectoryListingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetSpecialDirectories(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSpecialDirectories");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSpecialDirectories() :
      op->vtkPVFileInformationHelper::GetSpecialDirectories());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SetSpecialDirectories(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecialDirectories");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSpecialDirectories(temp0);
    }
    else
    {
      op->vtkPVFileInformationHelper::SetSpecialDirectories(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SpecialDirectoriesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SpecialDirectoriesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SpecialDirectoriesOn();
    }
    else
    {
      op->vtkPVFileInformationHelper::SpecialDirectoriesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SpecialDirectoriesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SpecialDirectoriesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SpecialDirectoriesOff();
    }
    else
    {
      op->vtkPVFileInformationHelper::SpecialDirectoriesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetExamplesInSpecialDirectories(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExamplesInSpecialDirectories");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExamplesInSpecialDirectories() :
      op->vtkPVFileInformationHelper::GetExamplesInSpecialDirectories());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SetExamplesInSpecialDirectories(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExamplesInSpecialDirectories");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExamplesInSpecialDirectories(temp0);
    }
    else
    {
      op->vtkPVFileInformationHelper::SetExamplesInSpecialDirectories(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_ExamplesInSpecialDirectoriesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExamplesInSpecialDirectoriesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExamplesInSpecialDirectoriesOn();
    }
    else
    {
      op->vtkPVFileInformationHelper::ExamplesInSpecialDirectoriesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_ExamplesInSpecialDirectoriesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExamplesInSpecialDirectoriesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExamplesInSpecialDirectoriesOff();
    }
    else
    {
      op->vtkPVFileInformationHelper::ExamplesInSpecialDirectoriesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetFastFileTypeDetection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFastFileTypeDetection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFastFileTypeDetection() :
      op->vtkPVFileInformationHelper::GetFastFileTypeDetection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SetFastFileTypeDetection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFastFileTypeDetection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFastFileTypeDetection(temp0);
    }
    else
    {
      op->vtkPVFileInformationHelper::SetFastFileTypeDetection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetGroupFileSequences(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGroupFileSequences");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGroupFileSequences() :
      op->vtkPVFileInformationHelper::GetGroupFileSequences());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SetGroupFileSequences(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGroupFileSequences");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGroupFileSequences(temp0);
    }
    else
    {
      op->vtkPVFileInformationHelper::SetGroupFileSequences(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GroupFileSequencesOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GroupFileSequencesOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GroupFileSequencesOn();
    }
    else
    {
      op->vtkPVFileInformationHelper::GroupFileSequencesOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GroupFileSequencesOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GroupFileSequencesOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GroupFileSequencesOff();
    }
    else
    {
      op->vtkPVFileInformationHelper::GroupFileSequencesOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetPathSeparator(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPathSeparator");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetPathSeparator() :
      op->vtkPVFileInformationHelper::GetPathSeparator());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetActiveFileIsReadable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveFileIsReadable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetActiveFileIsReadable() :
      op->vtkPVFileInformationHelper::GetActiveFileIsReadable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetActiveFileIsDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActiveFileIsDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetActiveFileIsDirectory() :
      op->vtkPVFileInformationHelper::GetActiveFileIsDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_GetReadDetailedFileInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReadDetailedFileInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetReadDetailedFileInformation() :
      op->vtkPVFileInformationHelper::GetReadDetailedFileInformation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVFileInformationHelper_SetReadDetailedFileInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReadDetailedFileInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVFileInformationHelper *op = static_cast<vtkPVFileInformationHelper *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReadDetailedFileInformation(temp0);
    }
    else
    {
      op->vtkPVFileInformationHelper::SetReadDetailedFileInformation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVFileInformationHelper_Methods[] = {
  {"IsTypeOf", PyvtkPVFileInformationHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVFileInformationHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVFileInformationHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVFileInformationHelper\nC++: static vtkPVFileInformationHelper *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVFileInformationHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVFileInformationHelper\nC++: vtkPVFileInformationHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVFileInformationHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVFileInformationHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetPath", PyvtkPVFileInformationHelper_SetPath, METH_VARARGS,
   "SetPath(self, _arg:str) -> None\nC++: virtual void SetPath(const char *_arg)\n\nGet/Set the path to the directory/file whose information we are\ninterested in. This is ignored when SpecialDirectories is set to\nTrue.\n"},
  {"GetPath", PyvtkPVFileInformationHelper_GetPath, METH_VARARGS,
   "GetPath(self) -> str\nC++: virtual char *GetPath()\n\n"},
  {"SetWorkingDirectory", PyvtkPVFileInformationHelper_SetWorkingDirectory, METH_VARARGS,
   "SetWorkingDirectory(self, _arg:str) -> None\nC++: virtual void SetWorkingDirectory(const char *_arg)\n\nGet/Set the current working directory. This is needed if Path is\nrelative. The relative path will be converted to absolute path\nusing the working directory specified before obtaining\ninformation about it. If 0 (default), then the application's\ncurrent working directory will be used to flatten relative paths.\n"},
  {"GetWorkingDirectory", PyvtkPVFileInformationHelper_GetWorkingDirectory, METH_VARARGS,
   "GetWorkingDirectory(self) -> str\nC++: virtual char *GetWorkingDirectory()\n\n"},
  {"GetDirectoryListing", PyvtkPVFileInformationHelper_GetDirectoryListing, METH_VARARGS,
   "GetDirectoryListing(self) -> int\nC++: virtual int GetDirectoryListing()\n\nGet/Set if the we should attempt to get the information of\ncontents if Path is a directory. Default value is 0. This is\nignored when SpecialDirectories is set to True.\n"},
  {"SetDirectoryListing", PyvtkPVFileInformationHelper_SetDirectoryListing, METH_VARARGS,
   "SetDirectoryListing(self, _arg:int) -> None\nC++: virtual void SetDirectoryListing(int _arg)\n\n"},
  {"DirectoryListingOn", PyvtkPVFileInformationHelper_DirectoryListingOn, METH_VARARGS,
   "DirectoryListingOn(self) -> None\nC++: virtual void DirectoryListingOn()\n\n"},
  {"DirectoryListingOff", PyvtkPVFileInformationHelper_DirectoryListingOff, METH_VARARGS,
   "DirectoryListingOff(self) -> None\nC++: virtual void DirectoryListingOff()\n\n"},
  {"GetSpecialDirectories", PyvtkPVFileInformationHelper_GetSpecialDirectories, METH_VARARGS,
   "GetSpecialDirectories(self) -> int\nC++: virtual int GetSpecialDirectories()\n\nGet/Set if the query is for special directories. Off by default.\nIf set to true, Path and DirectoryListing are ignored and the\nvtkPVFileInformation object is populated with information about\nspecial directories such as \"My Documents\", \"Desktop\" etc on\nWindows systems and \"Home\" on Unix based systems.\n"},
  {"SetSpecialDirectories", PyvtkPVFileInformationHelper_SetSpecialDirectories, METH_VARARGS,
   "SetSpecialDirectories(self, _arg:int) -> None\nC++: virtual void SetSpecialDirectories(int _arg)\n\n"},
  {"SpecialDirectoriesOn", PyvtkPVFileInformationHelper_SpecialDirectoriesOn, METH_VARARGS,
   "SpecialDirectoriesOn(self) -> None\nC++: virtual void SpecialDirectoriesOn()\n\n"},
  {"SpecialDirectoriesOff", PyvtkPVFileInformationHelper_SpecialDirectoriesOff, METH_VARARGS,
   "SpecialDirectoriesOff(self) -> None\nC++: virtual void SpecialDirectoriesOff()\n\n"},
  {"GetExamplesInSpecialDirectories", PyvtkPVFileInformationHelper_GetExamplesInSpecialDirectories, METH_VARARGS,
   "GetExamplesInSpecialDirectories(self) -> bool\nC++: virtual bool GetExamplesInSpecialDirectories()\n\nGet/Set if special directories includes the Examples placeholder.\nOn by default.\n"},
  {"SetExamplesInSpecialDirectories", PyvtkPVFileInformationHelper_SetExamplesInSpecialDirectories, METH_VARARGS,
   "SetExamplesInSpecialDirectories(self, _arg:bool) -> None\nC++: virtual void SetExamplesInSpecialDirectories(bool _arg)\n\n"},
  {"ExamplesInSpecialDirectoriesOn", PyvtkPVFileInformationHelper_ExamplesInSpecialDirectoriesOn, METH_VARARGS,
   "ExamplesInSpecialDirectoriesOn(self) -> None\nC++: virtual void ExamplesInSpecialDirectoriesOn()\n\n"},
  {"ExamplesInSpecialDirectoriesOff", PyvtkPVFileInformationHelper_ExamplesInSpecialDirectoriesOff, METH_VARARGS,
   "ExamplesInSpecialDirectoriesOff(self) -> None\nC++: virtual void ExamplesInSpecialDirectoriesOff()\n\n"},
  {"GetFastFileTypeDetection", PyvtkPVFileInformationHelper_GetFastFileTypeDetection, METH_VARARGS,
   "GetFastFileTypeDetection(self) -> int\nC++: virtual int GetFastFileTypeDetection()\n\nWhen on, while listing a directory, whenever a group of files is\nencountered, we verify the type/accessibility of only the first\nfile in the group and assume that all other have similar\npermissions. On by default.\n"},
  {"SetFastFileTypeDetection", PyvtkPVFileInformationHelper_SetFastFileTypeDetection, METH_VARARGS,
   "SetFastFileTypeDetection(self, _arg:int) -> None\nC++: virtual void SetFastFileTypeDetection(int _arg)\n\n"},
  {"GetGroupFileSequences", PyvtkPVFileInformationHelper_GetGroupFileSequences, METH_VARARGS,
   "GetGroupFileSequences(self) -> bool\nC++: virtual bool GetGroupFileSequences()\n\nGroups file sequences when found. A file sequence could be\n[foo1.png, foo2.png, foo6.png]. When turned on, the series of\nfiles is grouped and our sequence example is named foo..png and\noriginal files are discarded from the listing. By default, this\nflag is set to true.\n"},
  {"SetGroupFileSequences", PyvtkPVFileInformationHelper_SetGroupFileSequences, METH_VARARGS,
   "SetGroupFileSequences(self, _arg:bool) -> None\nC++: virtual void SetGroupFileSequences(bool _arg)\n\n"},
  {"GroupFileSequencesOn", PyvtkPVFileInformationHelper_GroupFileSequencesOn, METH_VARARGS,
   "GroupFileSequencesOn(self) -> None\nC++: virtual void GroupFileSequencesOn()\n\n"},
  {"GroupFileSequencesOff", PyvtkPVFileInformationHelper_GroupFileSequencesOff, METH_VARARGS,
   "GroupFileSequencesOff(self) -> None\nC++: virtual void GroupFileSequencesOff()\n\n"},
  {"GetPathSeparator", PyvtkPVFileInformationHelper_GetPathSeparator, METH_VARARGS,
   "GetPathSeparator(self) -> str\nC++: virtual char *GetPathSeparator()\n\nReturns the platform specific path separator.\n"},
  {"GetActiveFileIsReadable", PyvtkPVFileInformationHelper_GetActiveFileIsReadable, METH_VARARGS,
   "GetActiveFileIsReadable(self) -> bool\nC++: bool GetActiveFileIsReadable()\n\nReturns if this->Path is a readable file.\n"},
  {"GetActiveFileIsDirectory", PyvtkPVFileInformationHelper_GetActiveFileIsDirectory, METH_VARARGS,
   "GetActiveFileIsDirectory(self) -> bool\nC++: bool GetActiveFileIsDirectory()\n\nReturns if this->Path is a directory.\n"},
  {"GetReadDetailedFileInformation", PyvtkPVFileInformationHelper_GetReadDetailedFileInformation, METH_VARARGS,
   "GetReadDetailedFileInformation(self) -> bool\nC++: virtual bool GetReadDetailedFileInformation()\n\nWhen off, while listing a directory we skip the expensive fstat\ncall on every file and instead return only their names and basic\ninformation about them. Defaults to off. To enable the detailed\ninformation like file size and modified time turn this on.\n"},
  {"SetReadDetailedFileInformation", PyvtkPVFileInformationHelper_SetReadDetailedFileInformation, METH_VARARGS,
   "SetReadDetailedFileInformation(self, _arg:bool) -> None\nC++: virtual void SetReadDetailedFileInformation(bool _arg)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVFileInformationHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFileInformationHelper_SetPath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFileInformationHelper_SetPath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPath/SetPath\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("working_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetWorkingDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFileInformationHelper_SetWorkingDirectory(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFileInformationHelper_SetWorkingDirectory(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWorkingDirectory/SetWorkingDirectory\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("directory_listing"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetDirectoryListing(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFileInformationHelper_SetDirectoryListing(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFileInformationHelper_SetDirectoryListing(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDirectoryListing/SetDirectoryListing\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("special_directories"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetSpecialDirectories(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFileInformationHelper_SetSpecialDirectories(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFileInformationHelper_SetSpecialDirectories(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSpecialDirectories/SetSpecialDirectories\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("examples_in_special_directories"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetExamplesInSpecialDirectories(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFileInformationHelper_SetExamplesInSpecialDirectories(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFileInformationHelper_SetExamplesInSpecialDirectories(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExamplesInSpecialDirectories/SetExamplesInSpecialDirectories\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("fast_file_type_detection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetFastFileTypeDetection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFileInformationHelper_SetFastFileTypeDetection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFileInformationHelper_SetFastFileTypeDetection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFastFileTypeDetection/SetFastFileTypeDetection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("group_file_sequences"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetGroupFileSequences(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFileInformationHelper_SetGroupFileSequences(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFileInformationHelper_SetGroupFileSequences(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGroupFileSequences/SetGroupFileSequences\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("read_detailed_file_information"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetReadDetailedFileInformation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVFileInformationHelper_SetReadDetailedFileInformation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVFileInformationHelper_SetReadDetailedFileInformation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReadDetailedFileInformation/SetReadDetailedFileInformation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("path_separator"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetPathSeparator(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPathSeparator\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_file_is_readable"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetActiveFileIsReadable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveFileIsReadable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("active_file_is_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVFileInformationHelper_GetActiveFileIsDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetActiveFileIsDirectory\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVFileInformationHelper_Doc =
  "vtkPVFileInformationHelper - server side object used to gather\ninformation from, by vtkPVFileInformation.\n\n"
  "Superclass: vtkObject\n\n"
  "When collection information, ProcessModule cannot pass parameters to\n"
  "the information object. In case of vtkPVFileInformation, we need data\n"
  "on the server side such as which directory/file are we concerned\n"
  "with. To make such information available, we use\n"
  "vtkPVFileInformationHelper. One creates a server side representation\n"
  "of vtkPVFileInformationHelper and sets attributes on it, then\n"
  "requests a gather information on the helper object.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVFileInformationHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkPVFileInformationHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVFileInformationHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVFileInformationHelper_StaticNew()
{
  return vtkPVFileInformationHelper::New();
}

PyObject *PyvtkPVFileInformationHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVFileInformationHelper_Type, PyvtkPVFileInformationHelper_Methods,
    "vtkPVFileInformationHelper",
 &PyvtkPVFileInformationHelper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVFileInformationHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVFileInformationHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVFileInformationHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVFileInformationHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

