#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkImplicitTextureCoords_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkScalarsToTextureFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTextureMapToCylinder_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTextureMapToPlane_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTextureMapToSphere_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkThresholdTextureCoords_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTransformTextureCoords_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTriangularTCoords_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersTextureCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkImplicitTextureCoords_Init(csi);
  vtkScalarsToTextureFilter_Init(csi);
  vtkTextureMapToCylinder_Init(csi);
  vtkTextureMapToPlane_Init(csi);
  vtkTextureMapToSphere_Init(csi);
  vtkThresholdTextureCoords_Init(csi);
  vtkTransformTextureCoords_Init(csi);
  vtkTriangularTCoords_Init(csi);
}
