#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0071\x006c\x0074";
static constexpr OUStringLiteral langDefaultName = u"\x0043\x0061\x0074\x0061\x006c\x0061\x006e\x0020\x0028\x0056\x0061\x006c\x0065\x006e\x0063\x0069\x0061\x006e\x0029";
static constexpr OUStringLiteral countryID = u"\x0045\x0053";
static constexpr OUStringLiteral countryDefaultName = u"\x0053\x0070\x0061\x0069\x006e";
static constexpr OUStringLiteral Variant = u"\x0063\x0061\x002d\x0045\x0053\x002d\x0076\x0061\x006c\x0065\x006e\x0063\x0069\x0061";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_ca_ES_valencia(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_ca_ES_valencia(sal_Int16& count)
{
	return getLocaleItem_ca_ES(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x20a7, 0x2d, 0x38, 0x30, 0x33, 0x5d, 0x0};
extern OUString const * getAllFormats0_ca_ES(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_ca_ES_valencia(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_ca_ES(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_ca_ES_valencia(sal_Int16& count)
{
	return getDateAcceptancePatterns_ca_ES(count);
}
extern const OUString *  getCollatorImplementation_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_ca_ES_valencia(sal_Int16& count)
{
	return getCollatorImplementation_ca_ES(count);
}
extern const OUString *  getCollationOptions_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_ca_ES_valencia(sal_Int16& count)
{
	return getCollationOptions_ca_ES(count);
}
extern const OUString *  getSearchOptions_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_ca_ES_valencia(sal_Int16& count)
{
	return getSearchOptions_ca_ES(count);
}
extern const OUString *  getIndexAlgorithm_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_ca_ES_valencia(sal_Int16& count)
{
	return getIndexAlgorithm_ca_ES(count);
}
extern const OUString *  getUnicodeScripts_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_ca_ES_valencia(sal_Int16& count)
{
	return getUnicodeScripts_ca_ES(count);
}
extern const OUString *  getFollowPageWords_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_ca_ES_valencia(sal_Int16& count)
{
	return getFollowPageWords_ca_ES(count);
}
extern const OUString *  getAllCalendars_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_ca_ES_valencia(sal_Int16& count)
{
	return getAllCalendars_ca_ES(count);
}
extern const OUString *  getAllCurrencies_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCurrencies_ca_ES_valencia(sal_Int16& count)
{
	return getAllCurrencies_ca_ES(count);
}
extern const OUString *  getTransliterations_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_ca_ES_valencia(sal_Int16& count)
{
	return getTransliterations_ca_ES(count);
}
extern const OUString *  getForbiddenCharacters_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_ca_ES_valencia(sal_Int16& count)
{
	return getForbiddenCharacters_ca_ES(count);
}
extern const OUString *  getBreakIteratorRules_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_ca_ES_valencia(sal_Int16& count)
{
	return getBreakIteratorRules_ca_ES(count);
}
extern const OUString *  getReservedWords_ca_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_ca_ES_valencia(sal_Int16& count)
{
	return getReservedWords_ca_ES(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_ca_ES(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_ca_ES_valencia(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_ca_ES(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_ca_ES(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_ca_ES_valencia(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_ca_ES(nStyles, nLevels, nAttributes);
}
} // extern "C"

