
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kunitconversion_python.h"

// main header
#include "kunitconversion_wrapper.h"

// inner classes
#include "kunitconversion_converter_wrapper.h"
#include "kunitconversion_updatejob_wrapper.h"
#include "kunitconversion_unitcategory_wrapper.h"
#include "kunitconversion_value_wrapper.h"
#include "kunitconversion_unit_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KUnitConversion_Type = nullptr;
static PyTypeObject *Sbk_KUnitConversion_TypeF(void)
{
    return _Sbk_KUnitConversion_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KUnitConversion_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KUnitConversion");
    return -1;
}


static const char *Sbk_KUnitConversion_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KUnitConversion_EnumFlagInfo[] = {
    "CategoryId:IntEnum",
    "UnitId:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUnitConversion_methods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KUnitConversion_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUnitConversion_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUnitConversion_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUnitConversion_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUnitConversion_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUnitConversion_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUnitConversion_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUnitConversion_spec = {
    "1:KUnitConversion.KUnitConversion",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUnitConversion_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KUnitConversion_CategoryId(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KUnitConversion::CategoryId>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KUnitConversion::CategoryId *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KUnitConversion_CategoryId_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_CategoryId_IDX])))
        return Enum_PythonToCpp_KUnitConversion_CategoryId;
    return {};
}

static PyObject *KUnitConversion_CategoryId_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KUnitConversion::CategoryId>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KUnitConversion::CategoryId *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Enum_PythonToCpp_KUnitConversion_UnitId(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KUnitConversion::UnitId>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KUnitConversion::UnitId *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KUnitConversion_UnitId_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitId_IDX])))
        return Enum_PythonToCpp_KUnitConversion_UnitId;
    return {};
}

static PyObject *KUnitConversion_UnitId_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KUnitConversion::UnitId>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KUnitConversion::UnitId *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUnitConversionKUnitConversion_SignatureStrings[] = {
    nullptr}; // Sentinel
#else
static constexpr size_t KUnitConversionKUnitConversion_SignatureByteSize = 0;
static constexpr uint8_t KUnitConversionKUnitConversion_SignatureBytes[1] = {
    0x00
};
#endif

PyTypeObject *init_KUnitConversionKUnitConversion(PyObject *module)
{
    if (SbkKUnitConversionTypeStructs[SBK_KUnitConversionKUnitConversion_IDX].type != nullptr)
        return SbkKUnitConversionTypeStructs[SBK_KUnitConversionKUnitConversion_IDX].type;

    Shiboken::AutoDecRef Sbk_KUnitConversion_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KUnitConversion_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KUnitConversion",
        "KUnitConversion",
        &Sbk_KUnitConversion_spec,
        nullptr,
        Sbk_KUnitConversion_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KUnitConversion_Type; // references _Sbk_KUnitConversion_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUnitConversionKUnitConversion_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUnitConversionKUnitConversion_SignatureBytes, KUnitConversionKUnitConversion_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUnitConversion_PropertyStrings);
    SbkKUnitConversionTypeStructs[SBK_KUnitConversionKUnitConversion_IDX].type = pyType;


    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KUnitConversion_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'CategoryId'.
    const char *CategoryId_Initializer[] = {
        "InvalidCategory",
        "LengthCategory",
        "AreaCategory",
        "VolumeCategory",
        "TemperatureCategory",
        "VelocityCategory",
        "MassCategory",
        "PressureCategory",
        "EnergyCategory",
        "CurrencyCategory",
        "PowerCategory",
        "TimeCategory",
        "FuelEfficiencyCategory",
        "DensityCategory",
        "WeightPerAreaCategory",
        "AccelerationCategory",
        "AngleCategory",
        "FrequencyCategory",
        "ForceCategory",
        "ThermalConductivityCategory",
        "ThermalFluxCategory",
        "ThermalGenerationCategory",
        "VoltageCategory",
        "ElectricalCurrentCategory",
        "ElectricalResistanceCategory",
        "PermeabilityCategory",
        "BinaryDataCategory",
        nullptr};
    // "int8_t" used instead of "int"
    constexpr int8_t CategoryId_InitializerValues[] = {
        int8_t(KUnitConversion::CategoryId::InvalidCategory),              // -0x01 -1
        int8_t(KUnitConversion::CategoryId::LengthCategory),               //  0x00  0
        int8_t(KUnitConversion::CategoryId::AreaCategory),                 //  0x01  1
        int8_t(KUnitConversion::CategoryId::VolumeCategory),               //  0x02  2
        int8_t(KUnitConversion::CategoryId::TemperatureCategory),          //  0x03  3
        int8_t(KUnitConversion::CategoryId::VelocityCategory),             //  0x04  4
        int8_t(KUnitConversion::CategoryId::MassCategory),                 //  0x05  5
        int8_t(KUnitConversion::CategoryId::PressureCategory),             //  0x06  6
        int8_t(KUnitConversion::CategoryId::EnergyCategory),               //  0x07  7
        int8_t(KUnitConversion::CategoryId::CurrencyCategory),             //  0x08  8
        int8_t(KUnitConversion::CategoryId::PowerCategory),                //  0x09  9
        int8_t(KUnitConversion::CategoryId::TimeCategory),                 //  0x0a  10
        int8_t(KUnitConversion::CategoryId::FuelEfficiencyCategory),       //  0x0b  11
        int8_t(KUnitConversion::CategoryId::DensityCategory),              //  0x0c  12
        int8_t(KUnitConversion::CategoryId::WeightPerAreaCategory),        //  0x0d  13
        int8_t(KUnitConversion::CategoryId::AccelerationCategory),         //  0x0e  14
        int8_t(KUnitConversion::CategoryId::AngleCategory),                //  0x0f  15
        int8_t(KUnitConversion::CategoryId::FrequencyCategory),            //  0x10  16
        int8_t(KUnitConversion::CategoryId::ForceCategory),                //  0x11  17
        int8_t(KUnitConversion::CategoryId::ThermalConductivityCategory),  //  0x12  18
        int8_t(KUnitConversion::CategoryId::ThermalFluxCategory),          //  0x13  19
        int8_t(KUnitConversion::CategoryId::ThermalGenerationCategory),    //  0x14  20
        int8_t(KUnitConversion::CategoryId::VoltageCategory),              //  0x15  21
        int8_t(KUnitConversion::CategoryId::ElectricalCurrentCategory),    //  0x16  22
        int8_t(KUnitConversion::CategoryId::ElectricalResistanceCategory), //  0x17  23
        int8_t(KUnitConversion::CategoryId::PermeabilityCategory),         //  0x18  24
        int8_t(KUnitConversion::CategoryId::BinaryDataCategory)            //  0x19  25
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KUnitConversion_TypeF(),
        "1:KUnitConversion.KUnitConversion.CategoryId",
        CategoryId_Initializer, CategoryId_InitializerValues);
    SbkKUnitConversionTypeStructs[SBK_KUnitConversion_CategoryId_IDX].type = EType;
    // Register converter for enum 'KUnitConversion::CategoryId'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KUnitConversion_CategoryId_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KUnitConversion_CategoryId,
            is_Enum_PythonToCpp_KUnitConversion_CategoryId_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::CategoryId");
        Shiboken::Conversions::registerConverterAlias(converter, "CategoryId");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'CategoryId' enum.

    // Initialization of enum 'UnitId'.
    const char *UnitId_Initializer[] = {
        "InvalidUnit",
        "NoUnit",
        "Percent",
        "SquareYottameter",
        "SquareZettameter",
        "SquareExameter",
        "SquarePetameter",
        "SquareTerameter",
        "SquareGigameter",
        "SquareMegameter",
        "SquareKilometer",
        "SquareHectometer",
        "SquareDecameter",
        "SquareMeter",
        "SquareDecimeter",
        "SquareCentimeter",
        "SquareMillimeter",
        "SquareMicrometer",
        "SquareNanometer",
        "SquarePicometer",
        "SquareFemtometer",
        "SquareAttometer",
        "SquareZeptometer",
        "SquareYoctometer",
        "Acre",
        "SquareFoot",
        "SquareInch",
        "SquareMile",
        "Yottameter",
        "Zettameter",
        "Exameter",
        "Petameter",
        "Terameter",
        "Gigameter",
        "Megameter",
        "Kilometer",
        "Hectometer",
        "Decameter",
        "Meter",
        "Decimeter",
        "Centimeter",
        "Millimeter",
        "Micrometer",
        "Nanometer",
        "Picometer",
        "Femtometer",
        "Attometer",
        "Zeptometer",
        "Yoctometer",
        "Inch",
        "Foot",
        "Yard",
        "Mile",
        "NauticalMile",
        "LightYear",
        "Parsec",
        "AstronomicalUnit",
        "Thou",
        "Angstrom",
        "RackUnit",
        "Link",
        "Chain",
        "Furlong",
        "Fathom",
        "RodPerchPole",
        "CubicYottameter",
        "CubicZettameter",
        "CubicExameter",
        "CubicPetameter",
        "CubicTerameter",
        "CubicGigameter",
        "CubicMegameter",
        "CubicKilometer",
        "CubicHectometer",
        "CubicDecameter",
        "CubicMeter",
        "CubicDecimeter",
        "CubicCentimeter",
        "CubicMillimeter",
        "CubicMicrometer",
        "CubicNanometer",
        "CubicPicometer",
        "CubicFemtometer",
        "CubicAttometer",
        "CubicZeptometer",
        "CubicYoctometer",
        "Yottaliter",
        "Zettaliter",
        "Exaliter",
        "Petaliter",
        "Teraliter",
        "Gigaliter",
        "Megaliter",
        "Kiloliter",
        "Hectoliter",
        "Decaliter",
        "Liter",
        "Deciliter",
        "Centiliter",
        "Milliliter",
        "Microliter",
        "Nanoliter",
        "Picoliter",
        "Femtoliter",
        "Attoliter",
        "Zeptoliter",
        "Yoctoliter",
        "CubicFoot",
        "CubicInch",
        "CubicMile",
        "FluidOunce",
        "Cup",
        "Teaspoon",
        "Tablespoon",
        "GallonUS",
        "PintImperial",
        "OilBarrel",
        "GallonImperial",
        "PintUS",
        "Yottagram",
        "Zettagram",
        "Exagram",
        "Petagram",
        "Teragram",
        "Gigagram",
        "Megagram",
        "Kilogram",
        "Hectogram",
        "Decagram",
        "Gram",
        "Decigram",
        "Centigram",
        "Milligram",
        "Microgram",
        "Nanogram",
        "Picogram",
        "Femtogram",
        "Attogram",
        "Zeptogram",
        "Yoctogram",
        "Ton",
        "Carat",
        "Pound",
        "Ounce",
        "TroyOunce",
        "MassNewton",
        "Kilonewton",
        "Stone",
        "Yottapascal",
        "Zettapascal",
        "Exapascal",
        "Petapascal",
        "Terapascal",
        "Gigapascal",
        "Megapascal",
        "Kilopascal",
        "Hectopascal",
        "Decapascal",
        "Pascal",
        "Decipascal",
        "Centipascal",
        "Millipascal",
        "Micropascal",
        "Nanopascal",
        "Picopascal",
        "Femtopascal",
        "Attopascal",
        "Zeptopascal",
        "Yoctopascal",
        "Bar",
        "Millibar",
        "Decibar",
        "Torr",
        "TechnicalAtmosphere",
        "Atmosphere",
        "PoundForcePerSquareInch",
        "InchesOfMercury",
        "MillimetersOfMercury",
        "Kelvin",
        "Celsius",
        "Fahrenheit",
        "Rankine",
        "Delisle",
        "TemperatureNewton",
        "Reaumur",
        "Romer",
        "Yottajoule",
        "Zettajoule",
        "Exajoule",
        "Petajoule",
        "Terajoule",
        "Gigajoule",
        "Megajoule",
        "Kilojoule",
        "Hectojoule",
        "Decajoule",
        "Joule",
        "Decijoule",
        "Centijoule",
        "Millijoule",
        "Microjoule",
        "Nanojoule",
        "Picojoule",
        "Femtojoule",
        "Attojoule",
        "Zeptojoule",
        "Yoctojoule",
        "GuidelineDailyAmount",
        "Electronvolt",
        "Rydberg",
        "Kilocalorie",
        "PhotonWavelength",
        "KiloJoulePerMole",
        "JoulePerMole",
        "Btu",
        "Erg",
        "Eur",
        "Ats",
        "Bef",
        "Nlg",
        "Fim",
        "Frf",
        "Dem",
        "Iep",
        "Itl",
        "Luf",
        "Pte",
        "Esp",
        "Grd",
        "Sit",
        "Cyp",
        "Mtl",
        "Skk",
        "Usd",
        "Jpy",
        "Bgn",
        "Czk",
        "Dkk",
        "Eek",
        "Gbp",
        "Huf",
        "Ltl",
        "Lvl",
        "Pln",
        "Ron",
        "Sek",
        "Chf",
        "Nok",
        "Hrk",
        "Rub",
        "Try",
        "Aud",
        "Brl",
        "Cad",
        "Cny",
        "Hkd",
        "Idr",
        "Inr",
        "Krw",
        "Mxn",
        "Myr",
        "Nzd",
        "Php",
        "Sgd",
        "Thb",
        "Zar",
        "Ils",
        "Isk",
        "Xpf",
        "MeterPerSecond",
        "KilometerPerHour",
        "MilePerHour",
        "FootPerSecond",
        "InchPerSecond",
        "Knot",
        "Mach",
        "SpeedOfLight",
        "Beaufort",
        "Yottawatt",
        "Zettawatt",
        "Exawatt",
        "Petawatt",
        "Terawatt",
        "Gigawatt",
        "Megawatt",
        "Kilowatt",
        "Hectowatt",
        "Decawatt",
        "Watt",
        "Deciwatt",
        "Centiwatt",
        "Milliwatt",
        "Microwatt",
        "Nanowatt",
        "Picowatt",
        "Femtowatt",
        "Attowatt",
        "Zeptowatt",
        "Yoctowatt",
        "Horsepower",
        "DecibelKilowatt",
        "DecibelWatt",
        "DecibelMilliwatt",
        "DecibelMicrowatt",
        "Yottasecond",
        "Zettasecond",
        "Exasecond",
        "Petasecond",
        "Terasecond",
        "Gigasecond",
        "Megasecond",
        "Kilosecond",
        "Hectosecond",
        "Decasecond",
        "Second",
        "Decisecond",
        "Centisecond",
        "Millisecond",
        "Microsecond",
        "Nanosecond",
        "Picosecond",
        "Femtosecond",
        "Attosecond",
        "Zeptosecond",
        "Yoctosecond",
        "Minute",
        "Hour",
        "Day",
        "Week",
        "JulianYear",
        "LeapYear",
        "Year",
        "LitersPer100Kilometers",
        "MilePerUsGallon",
        "MilePerImperialGallon",
        "KilometrePerLitre",
        "YottakilogramsPerCubicMeter",
        "ZettakilogramPerCubicMeter",
        "ExakilogramPerCubicMeter",
        "PetakilogramPerCubicMeter",
        "TerakilogramPerCubicMeter",
        "GigakilogramPerCubicMeter",
        "MegakilogramPerCubicMeter",
        "KilokilogramPerCubicMeter",
        "HectokilogramsPerCubicMeter",
        "DecakilogramsPerCubicMeter",
        "KilogramsPerCubicMeter",
        "DecikilogramsPerCubicMeter",
        "CentikilogramsPerCubicMeter",
        "MillikilogramsPerCubicMeter",
        "MicrokilogramsPerCubicMeter",
        "NanokilogramsPerCubicMeter",
        "PicokilogramsPerCubicMeter",
        "FemtokilogramsPerCubicMeter",
        "AttokilogramsPerCubicMeter",
        "ZeptokilogramsPerCubicMeter",
        "YoctokilogramsPerCubicMeter",
        "KilogramPerLiter",
        "GramPerLiter",
        "GramPerMilliliter",
        "OuncePerCubicInch",
        "OuncePerCubicFoot",
        "OuncePerCubicYard",
        "PoundPerCubicInch",
        "PoundPerCubicFoot",
        "PoundPerCubicYard",
        "GramsPerSquareMeter",
        "OuncesPerSquareYard",
        "MetresPerSecondSquared",
        "FeetPerSecondSquared",
        "StandardGravity",
        "Yottanewton",
        "Zettanewton",
        "Exanewton",
        "Petanewton",
        "Teranewton",
        "Giganewton",
        "Meganewton",
        "KilonewtonForce",
        "Hectonewton",
        "Decanewton",
        "Newton",
        "Decinewton",
        "Centinewton",
        "Millinewton",
        "Micronewton",
        "Nanonewton",
        "Piconewton",
        "Femtonewton",
        "Attonewton",
        "Zeptonewton",
        "Yoctonewton",
        "Dyne",
        "Kilopond",
        "PoundForce",
        "Poundal",
        "Degree",
        "Radian",
        "Gradian",
        "ArcMinute",
        "ArcSecond",
        "Yottahertz",
        "Zettahertz",
        "Exahertz",
        "Petahertz",
        "Terahertz",
        "Gigahertz",
        "Megahertz",
        "Kilohertz",
        "Hectohertz",
        "Decahertz",
        "Hertz",
        "Decihertz",
        "Centihertz",
        "Millihertz",
        "Microhertz",
        "Nanohertz",
        "Picohertz",
        "Femtohertz",
        "Attohertz",
        "Zeptohertz",
        "Yoctohertz",
        "RPM",
        "WattPerMeterKelvin",
        "BtuPerFootHourFahrenheit",
        "BtuPerSquareFootHourFahrenheitPerInch",
        "WattPerSquareMeter",
        "BtuPerHourPerSquareFoot",
        "WattPerCubicMeter",
        "BtuPerHourPerCubicFoot",
        "Yottavolts",
        "Zettavolts",
        "Exavolts",
        "Petavolts",
        "Teravolts",
        "Gigavolts",
        "Megavolts",
        "Kilovolts",
        "Hectovolts",
        "Decavolts",
        "Volts",
        "Decivolts",
        "Centivolts",
        "Millivolts",
        "Microvolts",
        "Nanovolts",
        "Picovolts",
        "Femtovolts",
        "Attovolts",
        "Zeptovolts",
        "Yoctovolts",
        "Statvolts",
        "Yottaampere",
        "Zettaampere",
        "Exaampere",
        "Petaampere",
        "Teraampere",
        "Gigaampere",
        "Megaampere",
        "Kiloampere",
        "Hectoampere",
        "Decaampere",
        "Ampere",
        "Deciampere",
        "Centiampere",
        "Milliampere",
        "Microampere",
        "Nanoampere",
        "Picoampere",
        "Femtoampere",
        "Attoampere",
        "Zeptoampere",
        "Yoctoampere",
        "Yottaohms",
        "Zettaohms",
        "Exaohms",
        "Petaohms",
        "Teraohms",
        "Gigaohms",
        "Megaohms",
        "Kiloohms",
        "Hectoohms",
        "Decaohms",
        "Ohms",
        "Deciohms",
        "Centiohms",
        "Milliohms",
        "Microohms",
        "Nanoohms",
        "Picoohms",
        "Femtoohms",
        "Attoohms",
        "Zeptoohms",
        "Yoctoohms",
        "Darcy",
        "MiliDarcy",
        "PermeabilitySquareMicrometer",
        "Yobibyte",
        "Yobibit",
        "Yottabyte",
        "Yottabit",
        "Zebibyte",
        "Zebibit",
        "Zettabyte",
        "Zettabit",
        "Exbibyte",
        "Exbibit",
        "Exabyte",
        "Exabit",
        "Pebibyte",
        "Pebibit",
        "Petabyte",
        "Petabit",
        "Tebibyte",
        "Tebibit",
        "Terabyte",
        "Terabit",
        "Gibibyte",
        "Gibibit",
        "Gigabyte",
        "Gigabit",
        "Mebibyte",
        "Mebibit",
        "Megabyte",
        "Megabit",
        "Kibibyte",
        "Kibibit",
        "Kilobyte",
        "Kilobit",
        "Byte",
        "Bit",
        nullptr};
    // "int32_t" used instead of "int"
    constexpr int32_t UnitId_InitializerValues[] = {
        int32_t(KUnitConversion::UnitId::InvalidUnit),                           // -0x00000001 -1
        int32_t(KUnitConversion::UnitId::NoUnit),                                //  0x00000000  0
        int32_t(KUnitConversion::UnitId::Percent),                               //  0x00000001  1
        int32_t(KUnitConversion::UnitId::SquareYottameter),                      //  0x000003e8  1000
        int32_t(KUnitConversion::UnitId::SquareZettameter),                      //  0x000003e9  1001
        int32_t(KUnitConversion::UnitId::SquareExameter),                        //  0x000003ea  1002
        int32_t(KUnitConversion::UnitId::SquarePetameter),                       //  0x000003eb  1003
        int32_t(KUnitConversion::UnitId::SquareTerameter),                       //  0x000003ec  1004
        int32_t(KUnitConversion::UnitId::SquareGigameter),                       //  0x000003ed  1005
        int32_t(KUnitConversion::UnitId::SquareMegameter),                       //  0x000003ee  1006
        int32_t(KUnitConversion::UnitId::SquareKilometer),                       //  0x000003ef  1007
        int32_t(KUnitConversion::UnitId::SquareHectometer),                      //  0x000003f0  1008
        int32_t(KUnitConversion::UnitId::SquareDecameter),                       //  0x000003f1  1009
        int32_t(KUnitConversion::UnitId::SquareMeter),                           //  0x000003f2  1010
        int32_t(KUnitConversion::UnitId::SquareDecimeter),                       //  0x000003f3  1011
        int32_t(KUnitConversion::UnitId::SquareCentimeter),                      //  0x000003f4  1012
        int32_t(KUnitConversion::UnitId::SquareMillimeter),                      //  0x000003f5  1013
        int32_t(KUnitConversion::UnitId::SquareMicrometer),                      //  0x000003f6  1014
        int32_t(KUnitConversion::UnitId::SquareNanometer),                       //  0x000003f7  1015
        int32_t(KUnitConversion::UnitId::SquarePicometer),                       //  0x000003f8  1016
        int32_t(KUnitConversion::UnitId::SquareFemtometer),                      //  0x000003f9  1017
        int32_t(KUnitConversion::UnitId::SquareAttometer),                       //  0x000003fa  1018
        int32_t(KUnitConversion::UnitId::SquareZeptometer),                      //  0x000003fb  1019
        int32_t(KUnitConversion::UnitId::SquareYoctometer),                      //  0x000003fc  1020
        int32_t(KUnitConversion::UnitId::Acre),                                  //  0x000003fd  1021
        int32_t(KUnitConversion::UnitId::SquareFoot),                            //  0x000003fe  1022
        int32_t(KUnitConversion::UnitId::SquareInch),                            //  0x000003ff  1023
        int32_t(KUnitConversion::UnitId::SquareMile),                            //  0x00000400  1024
        int32_t(KUnitConversion::UnitId::Yottameter),                            //  0x000007d0  2000
        int32_t(KUnitConversion::UnitId::Zettameter),                            //  0x000007d1  2001
        int32_t(KUnitConversion::UnitId::Exameter),                              //  0x000007d2  2002
        int32_t(KUnitConversion::UnitId::Petameter),                             //  0x000007d3  2003
        int32_t(KUnitConversion::UnitId::Terameter),                             //  0x000007d4  2004
        int32_t(KUnitConversion::UnitId::Gigameter),                             //  0x000007d5  2005
        int32_t(KUnitConversion::UnitId::Megameter),                             //  0x000007d6  2006
        int32_t(KUnitConversion::UnitId::Kilometer),                             //  0x000007d7  2007
        int32_t(KUnitConversion::UnitId::Hectometer),                            //  0x000007d8  2008
        int32_t(KUnitConversion::UnitId::Decameter),                             //  0x000007d9  2009
        int32_t(KUnitConversion::UnitId::Meter),                                 //  0x000007da  2010
        int32_t(KUnitConversion::UnitId::Decimeter),                             //  0x000007db  2011
        int32_t(KUnitConversion::UnitId::Centimeter),                            //  0x000007dc  2012
        int32_t(KUnitConversion::UnitId::Millimeter),                            //  0x000007dd  2013
        int32_t(KUnitConversion::UnitId::Micrometer),                            //  0x000007de  2014
        int32_t(KUnitConversion::UnitId::Nanometer),                             //  0x000007df  2015
        int32_t(KUnitConversion::UnitId::Picometer),                             //  0x000007e0  2016
        int32_t(KUnitConversion::UnitId::Femtometer),                            //  0x000007e1  2017
        int32_t(KUnitConversion::UnitId::Attometer),                             //  0x000007e2  2018
        int32_t(KUnitConversion::UnitId::Zeptometer),                            //  0x000007e3  2019
        int32_t(KUnitConversion::UnitId::Yoctometer),                            //  0x000007e4  2020
        int32_t(KUnitConversion::UnitId::Inch),                                  //  0x000007e5  2021
        int32_t(KUnitConversion::UnitId::Foot),                                  //  0x000007e6  2022
        int32_t(KUnitConversion::UnitId::Yard),                                  //  0x000007e7  2023
        int32_t(KUnitConversion::UnitId::Mile),                                  //  0x000007e8  2024
        int32_t(KUnitConversion::UnitId::NauticalMile),                          //  0x000007e9  2025
        int32_t(KUnitConversion::UnitId::LightYear),                             //  0x000007ea  2026
        int32_t(KUnitConversion::UnitId::Parsec),                                //  0x000007eb  2027
        int32_t(KUnitConversion::UnitId::AstronomicalUnit),                      //  0x000007ec  2028
        int32_t(KUnitConversion::UnitId::Thou),                                  //  0x000007ed  2029
        int32_t(KUnitConversion::UnitId::Angstrom),                              //  0x000007ee  2030
        int32_t(KUnitConversion::UnitId::RackUnit),                              //  0x000007ef  2031
        int32_t(KUnitConversion::UnitId::Link),                                  //  0x000007f0  2032
        int32_t(KUnitConversion::UnitId::Chain),                                 //  0x000007f1  2033
        int32_t(KUnitConversion::UnitId::Furlong),                               //  0x000007f2  2034
        int32_t(KUnitConversion::UnitId::Fathom),                                //  0x000007f3  2035
        int32_t(KUnitConversion::UnitId::RodPerchPole),                          //  0x000007f4  2036
        int32_t(KUnitConversion::UnitId::CubicYottameter),                       //  0x00000bb8  3000
        int32_t(KUnitConversion::UnitId::CubicZettameter),                       //  0x00000bb9  3001
        int32_t(KUnitConversion::UnitId::CubicExameter),                         //  0x00000bba  3002
        int32_t(KUnitConversion::UnitId::CubicPetameter),                        //  0x00000bbb  3003
        int32_t(KUnitConversion::UnitId::CubicTerameter),                        //  0x00000bbc  3004
        int32_t(KUnitConversion::UnitId::CubicGigameter),                        //  0x00000bbd  3005
        int32_t(KUnitConversion::UnitId::CubicMegameter),                        //  0x00000bbe  3006
        int32_t(KUnitConversion::UnitId::CubicKilometer),                        //  0x00000bbf  3007
        int32_t(KUnitConversion::UnitId::CubicHectometer),                       //  0x00000bc0  3008
        int32_t(KUnitConversion::UnitId::CubicDecameter),                        //  0x00000bc1  3009
        int32_t(KUnitConversion::UnitId::CubicMeter),                            //  0x00000bc2  3010
        int32_t(KUnitConversion::UnitId::CubicDecimeter),                        //  0x00000bc3  3011
        int32_t(KUnitConversion::UnitId::CubicCentimeter),                       //  0x00000bc4  3012
        int32_t(KUnitConversion::UnitId::CubicMillimeter),                       //  0x00000bc5  3013
        int32_t(KUnitConversion::UnitId::CubicMicrometer),                       //  0x00000bc6  3014
        int32_t(KUnitConversion::UnitId::CubicNanometer),                        //  0x00000bc7  3015
        int32_t(KUnitConversion::UnitId::CubicPicometer),                        //  0x00000bc8  3016
        int32_t(KUnitConversion::UnitId::CubicFemtometer),                       //  0x00000bc9  3017
        int32_t(KUnitConversion::UnitId::CubicAttometer),                        //  0x00000bca  3018
        int32_t(KUnitConversion::UnitId::CubicZeptometer),                       //  0x00000bcb  3019
        int32_t(KUnitConversion::UnitId::CubicYoctometer),                       //  0x00000bcc  3020
        int32_t(KUnitConversion::UnitId::Yottaliter),                            //  0x00000bcd  3021
        int32_t(KUnitConversion::UnitId::Zettaliter),                            //  0x00000bce  3022
        int32_t(KUnitConversion::UnitId::Exaliter),                              //  0x00000bcf  3023
        int32_t(KUnitConversion::UnitId::Petaliter),                             //  0x00000bd0  3024
        int32_t(KUnitConversion::UnitId::Teraliter),                             //  0x00000bd1  3025
        int32_t(KUnitConversion::UnitId::Gigaliter),                             //  0x00000bd2  3026
        int32_t(KUnitConversion::UnitId::Megaliter),                             //  0x00000bd3  3027
        int32_t(KUnitConversion::UnitId::Kiloliter),                             //  0x00000bd4  3028
        int32_t(KUnitConversion::UnitId::Hectoliter),                            //  0x00000bd5  3029
        int32_t(KUnitConversion::UnitId::Decaliter),                             //  0x00000bd6  3030
        int32_t(KUnitConversion::UnitId::Liter),                                 //  0x00000bd7  3031
        int32_t(KUnitConversion::UnitId::Deciliter),                             //  0x00000bd8  3032
        int32_t(KUnitConversion::UnitId::Centiliter),                            //  0x00000bd9  3033
        int32_t(KUnitConversion::UnitId::Milliliter),                            //  0x00000bda  3034
        int32_t(KUnitConversion::UnitId::Microliter),                            //  0x00000bdb  3035
        int32_t(KUnitConversion::UnitId::Nanoliter),                             //  0x00000bdc  3036
        int32_t(KUnitConversion::UnitId::Picoliter),                             //  0x00000bdd  3037
        int32_t(KUnitConversion::UnitId::Femtoliter),                            //  0x00000bde  3038
        int32_t(KUnitConversion::UnitId::Attoliter),                             //  0x00000bdf  3039
        int32_t(KUnitConversion::UnitId::Zeptoliter),                            //  0x00000be0  3040
        int32_t(KUnitConversion::UnitId::Yoctoliter),                            //  0x00000be1  3041
        int32_t(KUnitConversion::UnitId::CubicFoot),                             //  0x00000be2  3042
        int32_t(KUnitConversion::UnitId::CubicInch),                             //  0x00000be3  3043
        int32_t(KUnitConversion::UnitId::CubicMile),                             //  0x00000be4  3044
        int32_t(KUnitConversion::UnitId::FluidOunce),                            //  0x00000be5  3045
        int32_t(KUnitConversion::UnitId::Cup),                                   //  0x00000be6  3046
        int32_t(KUnitConversion::UnitId::Teaspoon),                              //  0x00000be7  3047
        int32_t(KUnitConversion::UnitId::Tablespoon),                            //  0x00000be8  3048
        int32_t(KUnitConversion::UnitId::GallonUS),                              //  0x00000be9  3049
        int32_t(KUnitConversion::UnitId::PintImperial),                          //  0x00000bea  3050
        int32_t(KUnitConversion::UnitId::OilBarrel),                             //  0x00000beb  3051
        int32_t(KUnitConversion::UnitId::GallonImperial),                        //  0x00000bec  3052
        int32_t(KUnitConversion::UnitId::PintUS),                                //  0x00000bed  3053
        int32_t(KUnitConversion::UnitId::Yottagram),                             //  0x00000fa0  4000
        int32_t(KUnitConversion::UnitId::Zettagram),                             //  0x00000fa1  4001
        int32_t(KUnitConversion::UnitId::Exagram),                               //  0x00000fa2  4002
        int32_t(KUnitConversion::UnitId::Petagram),                              //  0x00000fa3  4003
        int32_t(KUnitConversion::UnitId::Teragram),                              //  0x00000fa4  4004
        int32_t(KUnitConversion::UnitId::Gigagram),                              //  0x00000fa5  4005
        int32_t(KUnitConversion::UnitId::Megagram),                              //  0x00000fa6  4006
        int32_t(KUnitConversion::UnitId::Kilogram),                              //  0x00000fa7  4007
        int32_t(KUnitConversion::UnitId::Hectogram),                             //  0x00000fa8  4008
        int32_t(KUnitConversion::UnitId::Decagram),                              //  0x00000fa9  4009
        int32_t(KUnitConversion::UnitId::Gram),                                  //  0x00000faa  4010
        int32_t(KUnitConversion::UnitId::Decigram),                              //  0x00000fab  4011
        int32_t(KUnitConversion::UnitId::Centigram),                             //  0x00000fac  4012
        int32_t(KUnitConversion::UnitId::Milligram),                             //  0x00000fad  4013
        int32_t(KUnitConversion::UnitId::Microgram),                             //  0x00000fae  4014
        int32_t(KUnitConversion::UnitId::Nanogram),                              //  0x00000faf  4015
        int32_t(KUnitConversion::UnitId::Picogram),                              //  0x00000fb0  4016
        int32_t(KUnitConversion::UnitId::Femtogram),                             //  0x00000fb1  4017
        int32_t(KUnitConversion::UnitId::Attogram),                              //  0x00000fb2  4018
        int32_t(KUnitConversion::UnitId::Zeptogram),                             //  0x00000fb3  4019
        int32_t(KUnitConversion::UnitId::Yoctogram),                             //  0x00000fb4  4020
        int32_t(KUnitConversion::UnitId::Ton),                                   //  0x00000fb5  4021
        int32_t(KUnitConversion::UnitId::Carat),                                 //  0x00000fb6  4022
        int32_t(KUnitConversion::UnitId::Pound),                                 //  0x00000fb7  4023
        int32_t(KUnitConversion::UnitId::Ounce),                                 //  0x00000fb8  4024
        int32_t(KUnitConversion::UnitId::TroyOunce),                             //  0x00000fb9  4025
        int32_t(KUnitConversion::UnitId::MassNewton),                            //  0x00000fba  4026
        int32_t(KUnitConversion::UnitId::Kilonewton),                            //  0x00000fbb  4027
        int32_t(KUnitConversion::UnitId::Stone),                                 //  0x00000fbc  4028
        int32_t(KUnitConversion::UnitId::Yottapascal),                           //  0x00001388  5000
        int32_t(KUnitConversion::UnitId::Zettapascal),                           //  0x00001389  5001
        int32_t(KUnitConversion::UnitId::Exapascal),                             //  0x0000138a  5002
        int32_t(KUnitConversion::UnitId::Petapascal),                            //  0x0000138b  5003
        int32_t(KUnitConversion::UnitId::Terapascal),                            //  0x0000138c  5004
        int32_t(KUnitConversion::UnitId::Gigapascal),                            //  0x0000138d  5005
        int32_t(KUnitConversion::UnitId::Megapascal),                            //  0x0000138e  5006
        int32_t(KUnitConversion::UnitId::Kilopascal),                            //  0x0000138f  5007
        int32_t(KUnitConversion::UnitId::Hectopascal),                           //  0x00001390  5008
        int32_t(KUnitConversion::UnitId::Decapascal),                            //  0x00001391  5009
        int32_t(KUnitConversion::UnitId::Pascal),                                //  0x00001392  5010
        int32_t(KUnitConversion::UnitId::Decipascal),                            //  0x00001393  5011
        int32_t(KUnitConversion::UnitId::Centipascal),                           //  0x00001394  5012
        int32_t(KUnitConversion::UnitId::Millipascal),                           //  0x00001395  5013
        int32_t(KUnitConversion::UnitId::Micropascal),                           //  0x00001396  5014
        int32_t(KUnitConversion::UnitId::Nanopascal),                            //  0x00001397  5015
        int32_t(KUnitConversion::UnitId::Picopascal),                            //  0x00001398  5016
        int32_t(KUnitConversion::UnitId::Femtopascal),                           //  0x00001399  5017
        int32_t(KUnitConversion::UnitId::Attopascal),                            //  0x0000139a  5018
        int32_t(KUnitConversion::UnitId::Zeptopascal),                           //  0x0000139b  5019
        int32_t(KUnitConversion::UnitId::Yoctopascal),                           //  0x0000139c  5020
        int32_t(KUnitConversion::UnitId::Bar),                                   //  0x0000139d  5021
        int32_t(KUnitConversion::UnitId::Millibar),                              //  0x0000139e  5022
        int32_t(KUnitConversion::UnitId::Decibar),                               //  0x0000139f  5023
        int32_t(KUnitConversion::UnitId::Torr),                                  //  0x000013a0  5024
        int32_t(KUnitConversion::UnitId::TechnicalAtmosphere),                   //  0x000013a1  5025
        int32_t(KUnitConversion::UnitId::Atmosphere),                            //  0x000013a2  5026
        int32_t(KUnitConversion::UnitId::PoundForcePerSquareInch),               //  0x000013a3  5027
        int32_t(KUnitConversion::UnitId::InchesOfMercury),                       //  0x000013a4  5028
        int32_t(KUnitConversion::UnitId::MillimetersOfMercury),                  //  0x000013a5  5029
        int32_t(KUnitConversion::UnitId::Kelvin),                                //  0x00001770  6000
        int32_t(KUnitConversion::UnitId::Celsius),                               //  0x00001771  6001
        int32_t(KUnitConversion::UnitId::Fahrenheit),                            //  0x00001772  6002
        int32_t(KUnitConversion::UnitId::Rankine),                               //  0x00001773  6003
        int32_t(KUnitConversion::UnitId::Delisle),                               //  0x00001774  6004
        int32_t(KUnitConversion::UnitId::TemperatureNewton),                     //  0x00001775  6005
        int32_t(KUnitConversion::UnitId::Reaumur),                               //  0x00001776  6006
        int32_t(KUnitConversion::UnitId::Romer),                                 //  0x00001777  6007
        int32_t(KUnitConversion::UnitId::Yottajoule),                            //  0x00001b58  7000
        int32_t(KUnitConversion::UnitId::Zettajoule),                            //  0x00001b59  7001
        int32_t(KUnitConversion::UnitId::Exajoule),                              //  0x00001b5a  7002
        int32_t(KUnitConversion::UnitId::Petajoule),                             //  0x00001b5b  7003
        int32_t(KUnitConversion::UnitId::Terajoule),                             //  0x00001b5c  7004
        int32_t(KUnitConversion::UnitId::Gigajoule),                             //  0x00001b5d  7005
        int32_t(KUnitConversion::UnitId::Megajoule),                             //  0x00001b5e  7006
        int32_t(KUnitConversion::UnitId::Kilojoule),                             //  0x00001b5f  7007
        int32_t(KUnitConversion::UnitId::Hectojoule),                            //  0x00001b60  7008
        int32_t(KUnitConversion::UnitId::Decajoule),                             //  0x00001b61  7009
        int32_t(KUnitConversion::UnitId::Joule),                                 //  0x00001b62  7010
        int32_t(KUnitConversion::UnitId::Decijoule),                             //  0x00001b63  7011
        int32_t(KUnitConversion::UnitId::Centijoule),                            //  0x00001b64  7012
        int32_t(KUnitConversion::UnitId::Millijoule),                            //  0x00001b65  7013
        int32_t(KUnitConversion::UnitId::Microjoule),                            //  0x00001b66  7014
        int32_t(KUnitConversion::UnitId::Nanojoule),                             //  0x00001b67  7015
        int32_t(KUnitConversion::UnitId::Picojoule),                             //  0x00001b68  7016
        int32_t(KUnitConversion::UnitId::Femtojoule),                            //  0x00001b69  7017
        int32_t(KUnitConversion::UnitId::Attojoule),                             //  0x00001b6a  7018
        int32_t(KUnitConversion::UnitId::Zeptojoule),                            //  0x00001b6b  7019
        int32_t(KUnitConversion::UnitId::Yoctojoule),                            //  0x00001b6c  7020
        int32_t(KUnitConversion::UnitId::GuidelineDailyAmount),                  //  0x00001b6d  7021
        int32_t(KUnitConversion::UnitId::Electronvolt),                          //  0x00001b6e  7022
        int32_t(KUnitConversion::UnitId::Rydberg),                               //  0x00001b6f  7023
        int32_t(KUnitConversion::UnitId::Kilocalorie),                           //  0x00001b70  7024
        int32_t(KUnitConversion::UnitId::PhotonWavelength),                      //  0x00001b71  7025
        int32_t(KUnitConversion::UnitId::KiloJoulePerMole),                      //  0x00001b72  7026
        int32_t(KUnitConversion::UnitId::JoulePerMole),                          //  0x00001b73  7027
        int32_t(KUnitConversion::UnitId::Btu),                                   //  0x00001b74  7028
        int32_t(KUnitConversion::UnitId::Erg),                                   //  0x00001b75  7029
        int32_t(KUnitConversion::UnitId::Eur),                                   //  0x00001f40  8000
        int32_t(KUnitConversion::UnitId::Ats),                                   //  0x00001f41  8001
        int32_t(KUnitConversion::UnitId::Bef),                                   //  0x00001f42  8002
        int32_t(KUnitConversion::UnitId::Nlg),                                   //  0x00001f43  8003
        int32_t(KUnitConversion::UnitId::Fim),                                   //  0x00001f44  8004
        int32_t(KUnitConversion::UnitId::Frf),                                   //  0x00001f45  8005
        int32_t(KUnitConversion::UnitId::Dem),                                   //  0x00001f46  8006
        int32_t(KUnitConversion::UnitId::Iep),                                   //  0x00001f47  8007
        int32_t(KUnitConversion::UnitId::Itl),                                   //  0x00001f48  8008
        int32_t(KUnitConversion::UnitId::Luf),                                   //  0x00001f49  8009
        int32_t(KUnitConversion::UnitId::Pte),                                   //  0x00001f4a  8010
        int32_t(KUnitConversion::UnitId::Esp),                                   //  0x00001f4b  8011
        int32_t(KUnitConversion::UnitId::Grd),                                   //  0x00001f4c  8012
        int32_t(KUnitConversion::UnitId::Sit),                                   //  0x00001f4d  8013
        int32_t(KUnitConversion::UnitId::Cyp),                                   //  0x00001f4e  8014
        int32_t(KUnitConversion::UnitId::Mtl),                                   //  0x00001f4f  8015
        int32_t(KUnitConversion::UnitId::Skk),                                   //  0x00001f50  8016
        int32_t(KUnitConversion::UnitId::Usd),                                   //  0x00001f51  8017
        int32_t(KUnitConversion::UnitId::Jpy),                                   //  0x00001f52  8018
        int32_t(KUnitConversion::UnitId::Bgn),                                   //  0x00001f53  8019
        int32_t(KUnitConversion::UnitId::Czk),                                   //  0x00001f54  8020
        int32_t(KUnitConversion::UnitId::Dkk),                                   //  0x00001f55  8021
        int32_t(KUnitConversion::UnitId::Eek),                                   //  0x00001f56  8022
        int32_t(KUnitConversion::UnitId::Gbp),                                   //  0x00001f57  8023
        int32_t(KUnitConversion::UnitId::Huf),                                   //  0x00001f58  8024
        int32_t(KUnitConversion::UnitId::Ltl),                                   //  0x00001f59  8025
        int32_t(KUnitConversion::UnitId::Lvl),                                   //  0x00001f5a  8026
        int32_t(KUnitConversion::UnitId::Pln),                                   //  0x00001f5b  8027
        int32_t(KUnitConversion::UnitId::Ron),                                   //  0x00001f5c  8028
        int32_t(KUnitConversion::UnitId::Sek),                                   //  0x00001f5d  8029
        int32_t(KUnitConversion::UnitId::Chf),                                   //  0x00001f5e  8030
        int32_t(KUnitConversion::UnitId::Nok),                                   //  0x00001f5f  8031
        int32_t(KUnitConversion::UnitId::Hrk),                                   //  0x00001f60  8032
        int32_t(KUnitConversion::UnitId::Rub),                                   //  0x00001f61  8033
        int32_t(KUnitConversion::UnitId::Try),                                   //  0x00001f62  8034
        int32_t(KUnitConversion::UnitId::Aud),                                   //  0x00001f63  8035
        int32_t(KUnitConversion::UnitId::Brl),                                   //  0x00001f64  8036
        int32_t(KUnitConversion::UnitId::Cad),                                   //  0x00001f65  8037
        int32_t(KUnitConversion::UnitId::Cny),                                   //  0x00001f66  8038
        int32_t(KUnitConversion::UnitId::Hkd),                                   //  0x00001f67  8039
        int32_t(KUnitConversion::UnitId::Idr),                                   //  0x00001f68  8040
        int32_t(KUnitConversion::UnitId::Inr),                                   //  0x00001f69  8041
        int32_t(KUnitConversion::UnitId::Krw),                                   //  0x00001f6a  8042
        int32_t(KUnitConversion::UnitId::Mxn),                                   //  0x00001f6b  8043
        int32_t(KUnitConversion::UnitId::Myr),                                   //  0x00001f6c  8044
        int32_t(KUnitConversion::UnitId::Nzd),                                   //  0x00001f6d  8045
        int32_t(KUnitConversion::UnitId::Php),                                   //  0x00001f6e  8046
        int32_t(KUnitConversion::UnitId::Sgd),                                   //  0x00001f6f  8047
        int32_t(KUnitConversion::UnitId::Thb),                                   //  0x00001f70  8048
        int32_t(KUnitConversion::UnitId::Zar),                                   //  0x00001f71  8049
        int32_t(KUnitConversion::UnitId::Ils),                                   //  0x00001f72  8050
        int32_t(KUnitConversion::UnitId::Isk),                                   //  0x00001f73  8051
        int32_t(KUnitConversion::UnitId::Xpf),                                   //  0x00001f74  8052
        int32_t(KUnitConversion::UnitId::MeterPerSecond),                        //  0x00002328  9000
        int32_t(KUnitConversion::UnitId::KilometerPerHour),                      //  0x00002329  9001
        int32_t(KUnitConversion::UnitId::MilePerHour),                           //  0x0000232a  9002
        int32_t(KUnitConversion::UnitId::FootPerSecond),                         //  0x0000232b  9003
        int32_t(KUnitConversion::UnitId::InchPerSecond),                         //  0x0000232c  9004
        int32_t(KUnitConversion::UnitId::Knot),                                  //  0x0000232d  9005
        int32_t(KUnitConversion::UnitId::Mach),                                  //  0x0000232e  9006
        int32_t(KUnitConversion::UnitId::SpeedOfLight),                          //  0x0000232f  9007
        int32_t(KUnitConversion::UnitId::Beaufort),                              //  0x00002330  9008
        int32_t(KUnitConversion::UnitId::Yottawatt),                             //  0x00002710  10000
        int32_t(KUnitConversion::UnitId::Zettawatt),                             //  0x00002711  10001
        int32_t(KUnitConversion::UnitId::Exawatt),                               //  0x00002712  10002
        int32_t(KUnitConversion::UnitId::Petawatt),                              //  0x00002713  10003
        int32_t(KUnitConversion::UnitId::Terawatt),                              //  0x00002714  10004
        int32_t(KUnitConversion::UnitId::Gigawatt),                              //  0x00002715  10005
        int32_t(KUnitConversion::UnitId::Megawatt),                              //  0x00002716  10006
        int32_t(KUnitConversion::UnitId::Kilowatt),                              //  0x00002717  10007
        int32_t(KUnitConversion::UnitId::Hectowatt),                             //  0x00002718  10008
        int32_t(KUnitConversion::UnitId::Decawatt),                              //  0x00002719  10009
        int32_t(KUnitConversion::UnitId::Watt),                                  //  0x0000271a  10010
        int32_t(KUnitConversion::UnitId::Deciwatt),                              //  0x0000271b  10011
        int32_t(KUnitConversion::UnitId::Centiwatt),                             //  0x0000271c  10012
        int32_t(KUnitConversion::UnitId::Milliwatt),                             //  0x0000271d  10013
        int32_t(KUnitConversion::UnitId::Microwatt),                             //  0x0000271e  10014
        int32_t(KUnitConversion::UnitId::Nanowatt),                              //  0x0000271f  10015
        int32_t(KUnitConversion::UnitId::Picowatt),                              //  0x00002720  10016
        int32_t(KUnitConversion::UnitId::Femtowatt),                             //  0x00002721  10017
        int32_t(KUnitConversion::UnitId::Attowatt),                              //  0x00002722  10018
        int32_t(KUnitConversion::UnitId::Zeptowatt),                             //  0x00002723  10019
        int32_t(KUnitConversion::UnitId::Yoctowatt),                             //  0x00002724  10020
        int32_t(KUnitConversion::UnitId::Horsepower),                            //  0x00002725  10021
        int32_t(KUnitConversion::UnitId::DecibelKilowatt),                       //  0x00002726  10022
        int32_t(KUnitConversion::UnitId::DecibelWatt),                           //  0x00002727  10023
        int32_t(KUnitConversion::UnitId::DecibelMilliwatt),                      //  0x00002728  10024
        int32_t(KUnitConversion::UnitId::DecibelMicrowatt),                      //  0x00002729  10025
        int32_t(KUnitConversion::UnitId::Yottasecond),                           //  0x00002af8  11000
        int32_t(KUnitConversion::UnitId::Zettasecond),                           //  0x00002af9  11001
        int32_t(KUnitConversion::UnitId::Exasecond),                             //  0x00002afa  11002
        int32_t(KUnitConversion::UnitId::Petasecond),                            //  0x00002afb  11003
        int32_t(KUnitConversion::UnitId::Terasecond),                            //  0x00002afc  11004
        int32_t(KUnitConversion::UnitId::Gigasecond),                            //  0x00002afd  11005
        int32_t(KUnitConversion::UnitId::Megasecond),                            //  0x00002afe  11006
        int32_t(KUnitConversion::UnitId::Kilosecond),                            //  0x00002aff  11007
        int32_t(KUnitConversion::UnitId::Hectosecond),                           //  0x00002b00  11008
        int32_t(KUnitConversion::UnitId::Decasecond),                            //  0x00002b01  11009
        int32_t(KUnitConversion::UnitId::Second),                                //  0x00002b02  11010
        int32_t(KUnitConversion::UnitId::Decisecond),                            //  0x00002b03  11011
        int32_t(KUnitConversion::UnitId::Centisecond),                           //  0x00002b04  11012
        int32_t(KUnitConversion::UnitId::Millisecond),                           //  0x00002b05  11013
        int32_t(KUnitConversion::UnitId::Microsecond),                           //  0x00002b06  11014
        int32_t(KUnitConversion::UnitId::Nanosecond),                            //  0x00002b07  11015
        int32_t(KUnitConversion::UnitId::Picosecond),                            //  0x00002b08  11016
        int32_t(KUnitConversion::UnitId::Femtosecond),                           //  0x00002b09  11017
        int32_t(KUnitConversion::UnitId::Attosecond),                            //  0x00002b0a  11018
        int32_t(KUnitConversion::UnitId::Zeptosecond),                           //  0x00002b0b  11019
        int32_t(KUnitConversion::UnitId::Yoctosecond),                           //  0x00002b0c  11020
        int32_t(KUnitConversion::UnitId::Minute),                                //  0x00002b0d  11021
        int32_t(KUnitConversion::UnitId::Hour),                                  //  0x00002b0e  11022
        int32_t(KUnitConversion::UnitId::Day),                                   //  0x00002b0f  11023
        int32_t(KUnitConversion::UnitId::Week),                                  //  0x00002b10  11024
        int32_t(KUnitConversion::UnitId::JulianYear),                            //  0x00002b11  11025
        int32_t(KUnitConversion::UnitId::LeapYear),                              //  0x00002b12  11026
        int32_t(KUnitConversion::UnitId::Year),                                  //  0x00002b13  11027
        int32_t(KUnitConversion::UnitId::LitersPer100Kilometers),                //  0x00002ee0  12000
        int32_t(KUnitConversion::UnitId::MilePerUsGallon),                       //  0x00002ee1  12001
        int32_t(KUnitConversion::UnitId::MilePerImperialGallon),                 //  0x00002ee2  12002
        int32_t(KUnitConversion::UnitId::KilometrePerLitre),                     //  0x00002ee3  12003
        int32_t(KUnitConversion::UnitId::YottakilogramsPerCubicMeter),           //  0x000032c8  13000
        int32_t(KUnitConversion::UnitId::ZettakilogramPerCubicMeter),            //  0x000032c9  13001
        int32_t(KUnitConversion::UnitId::ExakilogramPerCubicMeter),              //  0x000032ca  13002
        int32_t(KUnitConversion::UnitId::PetakilogramPerCubicMeter),             //  0x000032cb  13003
        int32_t(KUnitConversion::UnitId::TerakilogramPerCubicMeter),             //  0x000032cc  13004
        int32_t(KUnitConversion::UnitId::GigakilogramPerCubicMeter),             //  0x000032cd  13005
        int32_t(KUnitConversion::UnitId::MegakilogramPerCubicMeter),             //  0x000032ce  13006
        int32_t(KUnitConversion::UnitId::KilokilogramPerCubicMeter),             //  0x000032cf  13007
        int32_t(KUnitConversion::UnitId::HectokilogramsPerCubicMeter),           //  0x000032d0  13008
        int32_t(KUnitConversion::UnitId::DecakilogramsPerCubicMeter),            //  0x000032d1  13009
        int32_t(KUnitConversion::UnitId::KilogramsPerCubicMeter),                //  0x000032d2  13010
        int32_t(KUnitConversion::UnitId::DecikilogramsPerCubicMeter),            //  0x000032d3  13011
        int32_t(KUnitConversion::UnitId::CentikilogramsPerCubicMeter),           //  0x000032d4  13012
        int32_t(KUnitConversion::UnitId::MillikilogramsPerCubicMeter),           //  0x000032d5  13013
        int32_t(KUnitConversion::UnitId::MicrokilogramsPerCubicMeter),           //  0x000032d6  13014
        int32_t(KUnitConversion::UnitId::NanokilogramsPerCubicMeter),            //  0x000032d7  13015
        int32_t(KUnitConversion::UnitId::PicokilogramsPerCubicMeter),            //  0x000032d8  13016
        int32_t(KUnitConversion::UnitId::FemtokilogramsPerCubicMeter),           //  0x000032d9  13017
        int32_t(KUnitConversion::UnitId::AttokilogramsPerCubicMeter),            //  0x000032da  13018
        int32_t(KUnitConversion::UnitId::ZeptokilogramsPerCubicMeter),           //  0x000032db  13019
        int32_t(KUnitConversion::UnitId::YoctokilogramsPerCubicMeter),           //  0x000032dc  13020
        int32_t(KUnitConversion::UnitId::KilogramPerLiter),                      //  0x000032dd  13021
        int32_t(KUnitConversion::UnitId::GramPerLiter),                          //  0x000032de  13022
        int32_t(KUnitConversion::UnitId::GramPerMilliliter),                     //  0x000032df  13023
        int32_t(KUnitConversion::UnitId::OuncePerCubicInch),                     //  0x000032e0  13024
        int32_t(KUnitConversion::UnitId::OuncePerCubicFoot),                     //  0x000032e1  13025
        int32_t(KUnitConversion::UnitId::OuncePerCubicYard),                     //  0x000032e2  13026
        int32_t(KUnitConversion::UnitId::PoundPerCubicInch),                     //  0x000032e3  13027
        int32_t(KUnitConversion::UnitId::PoundPerCubicFoot),                     //  0x000032e4  13028
        int32_t(KUnitConversion::UnitId::PoundPerCubicYard),                     //  0x000032e5  13029
        int32_t(KUnitConversion::UnitId::GramsPerSquareMeter),                   //  0x000032e6  13030
        int32_t(KUnitConversion::UnitId::OuncesPerSquareYard),                   //  0x000032e7  13031
        int32_t(KUnitConversion::UnitId::MetresPerSecondSquared),                //  0x000036b0  14000
        int32_t(KUnitConversion::UnitId::FeetPerSecondSquared),                  //  0x000036b1  14001
        int32_t(KUnitConversion::UnitId::StandardGravity),                       //  0x000036b2  14002
        int32_t(KUnitConversion::UnitId::Yottanewton),                           //  0x00003a98  15000
        int32_t(KUnitConversion::UnitId::Zettanewton),                           //  0x00003a99  15001
        int32_t(KUnitConversion::UnitId::Exanewton),                             //  0x00003a9a  15002
        int32_t(KUnitConversion::UnitId::Petanewton),                            //  0x00003a9b  15003
        int32_t(KUnitConversion::UnitId::Teranewton),                            //  0x00003a9c  15004
        int32_t(KUnitConversion::UnitId::Giganewton),                            //  0x00003a9d  15005
        int32_t(KUnitConversion::UnitId::Meganewton),                            //  0x00003a9e  15006
        int32_t(KUnitConversion::UnitId::KilonewtonForce),                       //  0x00003a9f  15007
        int32_t(KUnitConversion::UnitId::Hectonewton),                           //  0x00003aa0  15008
        int32_t(KUnitConversion::UnitId::Decanewton),                            //  0x00003aa1  15009
        int32_t(KUnitConversion::UnitId::Newton),                                //  0x00003aa2  15010
        int32_t(KUnitConversion::UnitId::Decinewton),                            //  0x00003aa3  15011
        int32_t(KUnitConversion::UnitId::Centinewton),                           //  0x00003aa4  15012
        int32_t(KUnitConversion::UnitId::Millinewton),                           //  0x00003aa5  15013
        int32_t(KUnitConversion::UnitId::Micronewton),                           //  0x00003aa6  15014
        int32_t(KUnitConversion::UnitId::Nanonewton),                            //  0x00003aa7  15015
        int32_t(KUnitConversion::UnitId::Piconewton),                            //  0x00003aa8  15016
        int32_t(KUnitConversion::UnitId::Femtonewton),                           //  0x00003aa9  15017
        int32_t(KUnitConversion::UnitId::Attonewton),                            //  0x00003aaa  15018
        int32_t(KUnitConversion::UnitId::Zeptonewton),                           //  0x00003aab  15019
        int32_t(KUnitConversion::UnitId::Yoctonewton),                           //  0x00003aac  15020
        int32_t(KUnitConversion::UnitId::Dyne),                                  //  0x00003aad  15021
        int32_t(KUnitConversion::UnitId::Kilopond),                              //  0x00003aae  15022
        int32_t(KUnitConversion::UnitId::PoundForce),                            //  0x00003aaf  15023
        int32_t(KUnitConversion::UnitId::Poundal),                               //  0x00003ab0  15024
        int32_t(KUnitConversion::UnitId::Degree),                                //  0x00003e80  16000
        int32_t(KUnitConversion::UnitId::Radian),                                //  0x00003e81  16001
        int32_t(KUnitConversion::UnitId::Gradian),                               //  0x00003e82  16002
        int32_t(KUnitConversion::UnitId::ArcMinute),                             //  0x00003e83  16003
        int32_t(KUnitConversion::UnitId::ArcSecond),                             //  0x00003e84  16004
        int32_t(KUnitConversion::UnitId::Yottahertz),                            //  0x00004268  17000
        int32_t(KUnitConversion::UnitId::Zettahertz),                            //  0x00004269  17001
        int32_t(KUnitConversion::UnitId::Exahertz),                              //  0x0000426a  17002
        int32_t(KUnitConversion::UnitId::Petahertz),                             //  0x0000426b  17003
        int32_t(KUnitConversion::UnitId::Terahertz),                             //  0x0000426c  17004
        int32_t(KUnitConversion::UnitId::Gigahertz),                             //  0x0000426d  17005
        int32_t(KUnitConversion::UnitId::Megahertz),                             //  0x0000426e  17006
        int32_t(KUnitConversion::UnitId::Kilohertz),                             //  0x0000426f  17007
        int32_t(KUnitConversion::UnitId::Hectohertz),                            //  0x00004270  17008
        int32_t(KUnitConversion::UnitId::Decahertz),                             //  0x00004271  17009
        int32_t(KUnitConversion::UnitId::Hertz),                                 //  0x00004272  17010
        int32_t(KUnitConversion::UnitId::Decihertz),                             //  0x00004273  17011
        int32_t(KUnitConversion::UnitId::Centihertz),                            //  0x00004274  17012
        int32_t(KUnitConversion::UnitId::Millihertz),                            //  0x00004275  17013
        int32_t(KUnitConversion::UnitId::Microhertz),                            //  0x00004276  17014
        int32_t(KUnitConversion::UnitId::Nanohertz),                             //  0x00004277  17015
        int32_t(KUnitConversion::UnitId::Picohertz),                             //  0x00004278  17016
        int32_t(KUnitConversion::UnitId::Femtohertz),                            //  0x00004279  17017
        int32_t(KUnitConversion::UnitId::Attohertz),                             //  0x0000427a  17018
        int32_t(KUnitConversion::UnitId::Zeptohertz),                            //  0x0000427b  17019
        int32_t(KUnitConversion::UnitId::Yoctohertz),                            //  0x0000427c  17020
        int32_t(KUnitConversion::UnitId::RPM),                                   //  0x0000427d  17021
        int32_t(KUnitConversion::UnitId::WattPerMeterKelvin),                    //  0x00004650  18000
        int32_t(KUnitConversion::UnitId::BtuPerFootHourFahrenheit),              //  0x00004651  18001
        int32_t(KUnitConversion::UnitId::BtuPerSquareFootHourFahrenheitPerInch), //  0x00004652  18002
        int32_t(KUnitConversion::UnitId::WattPerSquareMeter),                    //  0x00004a38  19000
        int32_t(KUnitConversion::UnitId::BtuPerHourPerSquareFoot),               //  0x00004a39  19001
        int32_t(KUnitConversion::UnitId::WattPerCubicMeter),                     //  0x00004e20  20000
        int32_t(KUnitConversion::UnitId::BtuPerHourPerCubicFoot),                //  0x00004e21  20001
        int32_t(KUnitConversion::UnitId::Yottavolts),                            //  0x00007530  30000
        int32_t(KUnitConversion::UnitId::Zettavolts),                            //  0x00007531  30001
        int32_t(KUnitConversion::UnitId::Exavolts),                              //  0x00007532  30002
        int32_t(KUnitConversion::UnitId::Petavolts),                             //  0x00007533  30003
        int32_t(KUnitConversion::UnitId::Teravolts),                             //  0x00007534  30004
        int32_t(KUnitConversion::UnitId::Gigavolts),                             //  0x00007535  30005
        int32_t(KUnitConversion::UnitId::Megavolts),                             //  0x00007536  30006
        int32_t(KUnitConversion::UnitId::Kilovolts),                             //  0x00007537  30007
        int32_t(KUnitConversion::UnitId::Hectovolts),                            //  0x00007538  30008
        int32_t(KUnitConversion::UnitId::Decavolts),                             //  0x00007539  30009
        int32_t(KUnitConversion::UnitId::Volts),                                 //  0x0000753a  30010
        int32_t(KUnitConversion::UnitId::Decivolts),                             //  0x0000753b  30011
        int32_t(KUnitConversion::UnitId::Centivolts),                            //  0x0000753c  30012
        int32_t(KUnitConversion::UnitId::Millivolts),                            //  0x0000753d  30013
        int32_t(KUnitConversion::UnitId::Microvolts),                            //  0x0000753e  30014
        int32_t(KUnitConversion::UnitId::Nanovolts),                             //  0x0000753f  30015
        int32_t(KUnitConversion::UnitId::Picovolts),                             //  0x00007540  30016
        int32_t(KUnitConversion::UnitId::Femtovolts),                            //  0x00007541  30017
        int32_t(KUnitConversion::UnitId::Attovolts),                             //  0x00007542  30018
        int32_t(KUnitConversion::UnitId::Zeptovolts),                            //  0x00007543  30019
        int32_t(KUnitConversion::UnitId::Yoctovolts),                            //  0x00007544  30020
        int32_t(KUnitConversion::UnitId::Statvolts),                             //  0x00007545  30021
        int32_t(KUnitConversion::UnitId::Yottaampere),                           //  0x00007918  31000
        int32_t(KUnitConversion::UnitId::Zettaampere),                           //  0x00007919  31001
        int32_t(KUnitConversion::UnitId::Exaampere),                             //  0x0000791a  31002
        int32_t(KUnitConversion::UnitId::Petaampere),                            //  0x0000791b  31003
        int32_t(KUnitConversion::UnitId::Teraampere),                            //  0x0000791c  31004
        int32_t(KUnitConversion::UnitId::Gigaampere),                            //  0x0000791d  31005
        int32_t(KUnitConversion::UnitId::Megaampere),                            //  0x0000791e  31006
        int32_t(KUnitConversion::UnitId::Kiloampere),                            //  0x0000791f  31007
        int32_t(KUnitConversion::UnitId::Hectoampere),                           //  0x00007920  31008
        int32_t(KUnitConversion::UnitId::Decaampere),                            //  0x00007921  31009
        int32_t(KUnitConversion::UnitId::Ampere),                                //  0x00007922  31010
        int32_t(KUnitConversion::UnitId::Deciampere),                            //  0x00007923  31011
        int32_t(KUnitConversion::UnitId::Centiampere),                           //  0x00007924  31012
        int32_t(KUnitConversion::UnitId::Milliampere),                           //  0x00007925  31013
        int32_t(KUnitConversion::UnitId::Microampere),                           //  0x00007926  31014
        int32_t(KUnitConversion::UnitId::Nanoampere),                            //  0x00007927  31015
        int32_t(KUnitConversion::UnitId::Picoampere),                            //  0x00007928  31016
        int32_t(KUnitConversion::UnitId::Femtoampere),                           //  0x00007929  31017
        int32_t(KUnitConversion::UnitId::Attoampere),                            //  0x0000792a  31018
        int32_t(KUnitConversion::UnitId::Zeptoampere),                           //  0x0000792b  31019
        int32_t(KUnitConversion::UnitId::Yoctoampere),                           //  0x0000792c  31020
        int32_t(KUnitConversion::UnitId::Yottaohms),                             //  0x00007d00  32000
        int32_t(KUnitConversion::UnitId::Zettaohms),                             //  0x00007d01  32001
        int32_t(KUnitConversion::UnitId::Exaohms),                               //  0x00007d02  32002
        int32_t(KUnitConversion::UnitId::Petaohms),                              //  0x00007d03  32003
        int32_t(KUnitConversion::UnitId::Teraohms),                              //  0x00007d04  32004
        int32_t(KUnitConversion::UnitId::Gigaohms),                              //  0x00007d05  32005
        int32_t(KUnitConversion::UnitId::Megaohms),                              //  0x00007d06  32006
        int32_t(KUnitConversion::UnitId::Kiloohms),                              //  0x00007d07  32007
        int32_t(KUnitConversion::UnitId::Hectoohms),                             //  0x00007d08  32008
        int32_t(KUnitConversion::UnitId::Decaohms),                              //  0x00007d09  32009
        int32_t(KUnitConversion::UnitId::Ohms),                                  //  0x00007d0a  32010
        int32_t(KUnitConversion::UnitId::Deciohms),                              //  0x00007d0b  32011
        int32_t(KUnitConversion::UnitId::Centiohms),                             //  0x00007d0c  32012
        int32_t(KUnitConversion::UnitId::Milliohms),                             //  0x00007d0d  32013
        int32_t(KUnitConversion::UnitId::Microohms),                             //  0x00007d0e  32014
        int32_t(KUnitConversion::UnitId::Nanoohms),                              //  0x00007d0f  32015
        int32_t(KUnitConversion::UnitId::Picoohms),                              //  0x00007d10  32016
        int32_t(KUnitConversion::UnitId::Femtoohms),                             //  0x00007d11  32017
        int32_t(KUnitConversion::UnitId::Attoohms),                              //  0x00007d12  32018
        int32_t(KUnitConversion::UnitId::Zeptoohms),                             //  0x00007d13  32019
        int32_t(KUnitConversion::UnitId::Yoctoohms),                             //  0x00007d14  32020
        int32_t(KUnitConversion::UnitId::Darcy),                                 //  0x000080e8  33000
        int32_t(KUnitConversion::UnitId::MiliDarcy),                             //  0x000080e9  33001
        int32_t(KUnitConversion::UnitId::PermeabilitySquareMicrometer),          //  0x000080ea  33002
        int32_t(KUnitConversion::UnitId::Yobibyte),                              //  0x000084d0  34000
        int32_t(KUnitConversion::UnitId::Yobibit),                               //  0x000084d1  34001
        int32_t(KUnitConversion::UnitId::Yottabyte),                             //  0x000084d2  34002
        int32_t(KUnitConversion::UnitId::Yottabit),                              //  0x000084d3  34003
        int32_t(KUnitConversion::UnitId::Zebibyte),                              //  0x000084d4  34004
        int32_t(KUnitConversion::UnitId::Zebibit),                               //  0x000084d5  34005
        int32_t(KUnitConversion::UnitId::Zettabyte),                             //  0x000084d6  34006
        int32_t(KUnitConversion::UnitId::Zettabit),                              //  0x000084d7  34007
        int32_t(KUnitConversion::UnitId::Exbibyte),                              //  0x000084d8  34008
        int32_t(KUnitConversion::UnitId::Exbibit),                               //  0x000084d9  34009
        int32_t(KUnitConversion::UnitId::Exabyte),                               //  0x000084da  34010
        int32_t(KUnitConversion::UnitId::Exabit),                                //  0x000084db  34011
        int32_t(KUnitConversion::UnitId::Pebibyte),                              //  0x000084dc  34012
        int32_t(KUnitConversion::UnitId::Pebibit),                               //  0x000084dd  34013
        int32_t(KUnitConversion::UnitId::Petabyte),                              //  0x000084de  34014
        int32_t(KUnitConversion::UnitId::Petabit),                               //  0x000084df  34015
        int32_t(KUnitConversion::UnitId::Tebibyte),                              //  0x000084e0  34016
        int32_t(KUnitConversion::UnitId::Tebibit),                               //  0x000084e1  34017
        int32_t(KUnitConversion::UnitId::Terabyte),                              //  0x000084e2  34018
        int32_t(KUnitConversion::UnitId::Terabit),                               //  0x000084e3  34019
        int32_t(KUnitConversion::UnitId::Gibibyte),                              //  0x000084e4  34020
        int32_t(KUnitConversion::UnitId::Gibibit),                               //  0x000084e5  34021
        int32_t(KUnitConversion::UnitId::Gigabyte),                              //  0x000084e6  34022
        int32_t(KUnitConversion::UnitId::Gigabit),                               //  0x000084e7  34023
        int32_t(KUnitConversion::UnitId::Mebibyte),                              //  0x000084e8  34024
        int32_t(KUnitConversion::UnitId::Mebibit),                               //  0x000084e9  34025
        int32_t(KUnitConversion::UnitId::Megabyte),                              //  0x000084ea  34026
        int32_t(KUnitConversion::UnitId::Megabit),                               //  0x000084eb  34027
        int32_t(KUnitConversion::UnitId::Kibibyte),                              //  0x000084ec  34028
        int32_t(KUnitConversion::UnitId::Kibibit),                               //  0x000084ed  34029
        int32_t(KUnitConversion::UnitId::Kilobyte),                              //  0x000084ee  34030
        int32_t(KUnitConversion::UnitId::Kilobit),                               //  0x000084ef  34031
        int32_t(KUnitConversion::UnitId::Byte),                                  //  0x000084f0  34032
        int32_t(KUnitConversion::UnitId::Bit)                                    //  0x000084f1  34033
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KUnitConversion_TypeF(),
        "1:KUnitConversion.KUnitConversion.UnitId",
        UnitId_Initializer, UnitId_InitializerValues);
    SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitId_IDX].type = EType;
    // Register converter for enum 'KUnitConversion::UnitId'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KUnitConversion_UnitId_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KUnitConversion_UnitId,
            is_Enum_PythonToCpp_KUnitConversion_UnitId_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::UnitId");
        Shiboken::Conversions::registerConverterAlias(converter, "UnitId");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'UnitId' enum.

    qRegisterMetaType< ::KUnitConversion::CategoryId >("KUnitConversion::CategoryId");
    qRegisterMetaType< ::KUnitConversion::UnitId >("KUnitConversion::UnitId");

    return pyType;
}
