{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Shows text in a predefined area.
-- 
-- You likely want to use @GtkLabel@ instead as this widget is intended only
-- for a small subset of use cases. The main scenario envisaged is inside lists
-- such as @GtkColumnView@.
-- 
-- While a @GtkLabel@ sizes itself depending on the text that is displayed,
-- @GtkInscription@ is given a size and inscribes the given text into that
-- space as well as it can.
-- 
-- Users of this widget should take care to plan behaviour for the common case
-- where the text doesn\'t fit exactly in the allocated space.
-- 
-- == CSS nodes
-- 
-- @GtkInscription@ has a single CSS node with the name label.
-- 
-- /Since: 4.8/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Inscription
    ( 

-- * Exported types
    Inscription(..)                         ,
    IsInscription                           ,
    toInscription                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateCaretPosition]("GI.Gtk.Interfaces.AccessibleText#g:method:updateCaretPosition"), [updateContents]("GI.Gtk.Interfaces.AccessibleText#g:method:updateContents"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateSelectionBound]("GI.Gtk.Interfaces.AccessibleText#g:method:updateSelectionBound"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getAttributes]("GI.Gtk.Objects.Inscription#g:method:getAttributes"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMinChars]("GI.Gtk.Objects.Inscription#g:method:getMinChars"), [getMinLines]("GI.Gtk.Objects.Inscription#g:method:getMinLines"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNatChars]("GI.Gtk.Objects.Inscription#g:method:getNatChars"), [getNatLines]("GI.Gtk.Objects.Inscription#g:method:getNatLines"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getText]("GI.Gtk.Objects.Inscription#g:method:getText"), [getTextOverflow]("GI.Gtk.Objects.Inscription#g:method:getTextOverflow"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth"), [getWrapMode]("GI.Gtk.Objects.Inscription#g:method:getWrapMode"), [getXalign]("GI.Gtk.Objects.Inscription#g:method:getXalign"), [getYalign]("GI.Gtk.Objects.Inscription#g:method:getYalign").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAttributes]("GI.Gtk.Objects.Inscription#g:method:setAttributes"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMarkup]("GI.Gtk.Objects.Inscription#g:method:setMarkup"), [setMinChars]("GI.Gtk.Objects.Inscription#g:method:setMinChars"), [setMinLines]("GI.Gtk.Objects.Inscription#g:method:setMinLines"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setNatChars]("GI.Gtk.Objects.Inscription#g:method:setNatChars"), [setNatLines]("GI.Gtk.Objects.Inscription#g:method:setNatLines"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setText]("GI.Gtk.Objects.Inscription#g:method:setText"), [setTextOverflow]("GI.Gtk.Objects.Inscription#g:method:setTextOverflow"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setWrapMode]("GI.Gtk.Objects.Inscription#g:method:setWrapMode"), [setXalign]("GI.Gtk.Objects.Inscription#g:method:setXalign"), [setYalign]("GI.Gtk.Objects.Inscription#g:method:setYalign").

#if defined(ENABLE_OVERLOADING)
    ResolveInscriptionMethod                ,
#endif

-- ** getAttributes #method:getAttributes#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetAttributesMethodInfo      ,
#endif
    inscriptionGetAttributes                ,


-- ** getMinChars #method:getMinChars#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetMinCharsMethodInfo        ,
#endif
    inscriptionGetMinChars                  ,


-- ** getMinLines #method:getMinLines#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetMinLinesMethodInfo        ,
#endif
    inscriptionGetMinLines                  ,


-- ** getNatChars #method:getNatChars#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetNatCharsMethodInfo        ,
#endif
    inscriptionGetNatChars                  ,


-- ** getNatLines #method:getNatLines#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetNatLinesMethodInfo        ,
#endif
    inscriptionGetNatLines                  ,


-- ** getText #method:getText#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetTextMethodInfo            ,
#endif
    inscriptionGetText                      ,


-- ** getTextOverflow #method:getTextOverflow#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetTextOverflowMethodInfo    ,
#endif
    inscriptionGetTextOverflow              ,


-- ** getWrapMode #method:getWrapMode#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetWrapModeMethodInfo        ,
#endif
    inscriptionGetWrapMode                  ,


-- ** getXalign #method:getXalign#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetXalignMethodInfo          ,
#endif
    inscriptionGetXalign                    ,


-- ** getYalign #method:getYalign#

#if defined(ENABLE_OVERLOADING)
    InscriptionGetYalignMethodInfo          ,
#endif
    inscriptionGetYalign                    ,


-- ** new #method:new#

    inscriptionNew                          ,


-- ** setAttributes #method:setAttributes#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetAttributesMethodInfo      ,
#endif
    inscriptionSetAttributes                ,


-- ** setMarkup #method:setMarkup#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetMarkupMethodInfo          ,
#endif
    inscriptionSetMarkup                    ,


-- ** setMinChars #method:setMinChars#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetMinCharsMethodInfo        ,
#endif
    inscriptionSetMinChars                  ,


-- ** setMinLines #method:setMinLines#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetMinLinesMethodInfo        ,
#endif
    inscriptionSetMinLines                  ,


-- ** setNatChars #method:setNatChars#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetNatCharsMethodInfo        ,
#endif
    inscriptionSetNatChars                  ,


-- ** setNatLines #method:setNatLines#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetNatLinesMethodInfo        ,
#endif
    inscriptionSetNatLines                  ,


-- ** setText #method:setText#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetTextMethodInfo            ,
#endif
    inscriptionSetText                      ,


-- ** setTextOverflow #method:setTextOverflow#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetTextOverflowMethodInfo    ,
#endif
    inscriptionSetTextOverflow              ,


-- ** setWrapMode #method:setWrapMode#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetWrapModeMethodInfo        ,
#endif
    inscriptionSetWrapMode                  ,


-- ** setXalign #method:setXalign#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetXalignMethodInfo          ,
#endif
    inscriptionSetXalign                    ,


-- ** setYalign #method:setYalign#

#if defined(ENABLE_OVERLOADING)
    InscriptionSetYalignMethodInfo          ,
#endif
    inscriptionSetYalign                    ,




 -- * Properties


-- ** attributes #attr:attributes#
-- | A list of style attributes to apply to the text of the inscription.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionAttributesPropertyInfo       ,
#endif
    clearInscriptionAttributes              ,
    constructInscriptionAttributes          ,
    getInscriptionAttributes                ,
#if defined(ENABLE_OVERLOADING)
    inscriptionAttributes                   ,
#endif
    setInscriptionAttributes                ,


-- ** markup #attr:markup#
-- | Utility property that sets both the [Inscription:text]("GI.Gtk.Objects.Inscription#g:attr:text") and
-- [Inscription:attributes]("GI.Gtk.Objects.Inscription#g:attr:attributes") properties, mainly intended for use in
-- GtkBuilder ui files to ease translation support and bindings.
-- 
-- This function uses 'GI.Pango.Functions.parseMarkup' to parse the markup into text and
-- attributes. The markup must be valid. If you cannot ensure that, consider using
-- 'GI.Pango.Functions.parseMarkup' and setting the two properties yourself.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionMarkupPropertyInfo           ,
#endif
    clearInscriptionMarkup                  ,
    constructInscriptionMarkup              ,
#if defined(ENABLE_OVERLOADING)
    inscriptionMarkup                       ,
#endif
    setInscriptionMarkup                    ,


-- ** minChars #attr:minChars#
-- | The number of characters that should fit into the inscription at minimum.
-- 
-- This influences the requested width, not the width actually given to the widget,
-- which might turn out to be larger.
-- 
-- Note that this is an approximate character width, so some characters might be
-- wider and some might be thinner, so do not expect the number of characters to
-- exactly match.
-- 
-- If you set this property to 0, the inscription will not request any width at all
-- and its width will be determined entirely by its surroundings.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionMinCharsPropertyInfo         ,
#endif
    constructInscriptionMinChars            ,
    getInscriptionMinChars                  ,
#if defined(ENABLE_OVERLOADING)
    inscriptionMinChars                     ,
#endif
    setInscriptionMinChars                  ,


-- ** minLines #attr:minLines#
-- | The number of lines that should fit into the inscription at minimum.
-- 
-- This influences the requested height, not the height actually given to the widget,
-- which might turn out to be larger.
-- 
-- Note that this is an approximate line height, so if the text uses things like fancy
-- Unicode or attribute that influence the height, the text might not fit.
-- 
-- If you set this property to 0, the inscription will not request any height at all
-- and its height will be determined entirely by its surroundings.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionMinLinesPropertyInfo         ,
#endif
    constructInscriptionMinLines            ,
    getInscriptionMinLines                  ,
#if defined(ENABLE_OVERLOADING)
    inscriptionMinLines                     ,
#endif
    setInscriptionMinLines                  ,


-- ** natChars #attr:natChars#
-- | The number of characters that should ideally fit into the inscription.
-- 
-- This influences the requested width, not the width actually given to the widget.
-- The widget might turn out larger as well as smaller.
-- 
-- If this property is set to a value smaller than [Inscription:minChars]("GI.Gtk.Objects.Inscription#g:attr:minChars"),
-- that value will be used. In particular, for the default value of 0, this will always
-- be the case.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionNatCharsPropertyInfo         ,
#endif
    constructInscriptionNatChars            ,
    getInscriptionNatChars                  ,
#if defined(ENABLE_OVERLOADING)
    inscriptionNatChars                     ,
#endif
    setInscriptionNatChars                  ,


-- ** natLines #attr:natLines#
-- | The number of lines that should ideally fit into the inscription.
-- 
-- This influences the requested height, not the height actually given to the widget.
-- The widget might turn out larger as well as smaller.
-- 
-- If this property is set to a value smaller than [Inscription:minLines]("GI.Gtk.Objects.Inscription#g:attr:minLines"),
-- that value will be used. In particular, for the default value of 0, this will always
-- be the case.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionNatLinesPropertyInfo         ,
#endif
    constructInscriptionNatLines            ,
    getInscriptionNatLines                  ,
#if defined(ENABLE_OVERLOADING)
    inscriptionNatLines                     ,
#endif
    setInscriptionNatLines                  ,


-- ** text #attr:text#
-- | The displayed text.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionTextPropertyInfo             ,
#endif
    clearInscriptionText                    ,
    constructInscriptionText                ,
    getInscriptionText                      ,
#if defined(ENABLE_OVERLOADING)
    inscriptionText                         ,
#endif
    setInscriptionText                      ,


-- ** textOverflow #attr:textOverflow#
-- | The overflow method to use for the text.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionTextOverflowPropertyInfo     ,
#endif
    constructInscriptionTextOverflow        ,
    getInscriptionTextOverflow              ,
#if defined(ENABLE_OVERLOADING)
    inscriptionTextOverflow                 ,
#endif
    setInscriptionTextOverflow              ,


-- ** wrapMode #attr:wrapMode#
-- | Controls how the line wrapping is done.
-- 
-- Note that unlike @GtkLabel@, the default here is 'GI.Pango.Enums.WrapModeWordChar'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionWrapModePropertyInfo         ,
#endif
    constructInscriptionWrapMode            ,
    getInscriptionWrapMode                  ,
#if defined(ENABLE_OVERLOADING)
    inscriptionWrapMode                     ,
#endif
    setInscriptionWrapMode                  ,


-- ** xalign #attr:xalign#
-- | The horizontal alignment of the text inside the allocated size.
-- 
-- Compare this to [Widget:halign]("GI.Gtk.Objects.Widget#g:attr:halign"), which determines how the
-- inscription\'s size allocation is positioned in the available space.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionXalignPropertyInfo           ,
#endif
    constructInscriptionXalign              ,
    getInscriptionXalign                    ,
#if defined(ENABLE_OVERLOADING)
    inscriptionXalign                       ,
#endif
    setInscriptionXalign                    ,


-- ** yalign #attr:yalign#
-- | The vertical alignment of the text inside the allocated size.
-- 
-- Compare this to [Widget:valign]("GI.Gtk.Objects.Widget#g:attr:valign"), which determines how the
-- inscription\'s size allocation is positioned in the available space.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    InscriptionYalignPropertyInfo           ,
#endif
    constructInscriptionYalign              ,
    getInscriptionYalign                    ,
#if defined(ENABLE_OVERLOADING)
    inscriptionYalign                       ,
#endif
    setInscriptionYalign                    ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleText as Gtk.AccessibleText
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.AttrList as Pango.AttrList

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleText as Gtk.AccessibleText
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Structs.AttrList as Pango.AttrList

#endif

-- | Memory-managed wrapper type.
newtype Inscription = Inscription (SP.ManagedPtr Inscription)
    deriving (Eq)

instance SP.ManagedPtrNewtype Inscription where
    toManagedPtr (Inscription p) = p

foreign import ccall "gtk_inscription_get_type"
    c_gtk_inscription_get_type :: IO B.Types.GType

instance B.Types.TypedObject Inscription where
    glibType = c_gtk_inscription_get_type

instance B.Types.GObject Inscription

-- | Type class for types which can be safely cast to t'Inscription', for instance with `toInscription`.
class (SP.GObject o, O.IsDescendantOf Inscription o) => IsInscription o
instance (SP.GObject o, O.IsDescendantOf Inscription o) => IsInscription o

instance O.HasParentTypes Inscription
type instance O.ParentTypes Inscription = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AccessibleText.AccessibleText, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'Inscription', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toInscription :: (MIO.MonadIO m, IsInscription o) => o -> m Inscription
toInscription = MIO.liftIO . B.ManagedPtr.unsafeCastTo Inscription

-- | Convert t'Inscription' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Inscription) where
    gvalueGType_ = c_gtk_inscription_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Inscription)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Inscription)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Inscription ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveInscriptionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveInscriptionMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveInscriptionMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveInscriptionMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveInscriptionMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveInscriptionMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveInscriptionMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveInscriptionMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveInscriptionMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveInscriptionMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveInscriptionMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveInscriptionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveInscriptionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveInscriptionMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveInscriptionMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveInscriptionMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveInscriptionMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveInscriptionMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveInscriptionMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveInscriptionMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveInscriptionMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveInscriptionMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveInscriptionMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveInscriptionMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveInscriptionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveInscriptionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveInscriptionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveInscriptionMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveInscriptionMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveInscriptionMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveInscriptionMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveInscriptionMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveInscriptionMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveInscriptionMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveInscriptionMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveInscriptionMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveInscriptionMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveInscriptionMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveInscriptionMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveInscriptionMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveInscriptionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveInscriptionMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveInscriptionMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveInscriptionMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveInscriptionMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveInscriptionMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveInscriptionMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveInscriptionMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveInscriptionMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveInscriptionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveInscriptionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveInscriptionMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveInscriptionMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveInscriptionMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveInscriptionMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveInscriptionMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveInscriptionMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveInscriptionMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveInscriptionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveInscriptionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveInscriptionMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveInscriptionMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveInscriptionMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveInscriptionMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveInscriptionMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveInscriptionMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveInscriptionMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveInscriptionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveInscriptionMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveInscriptionMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveInscriptionMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveInscriptionMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveInscriptionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveInscriptionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveInscriptionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveInscriptionMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveInscriptionMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveInscriptionMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveInscriptionMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveInscriptionMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveInscriptionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveInscriptionMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveInscriptionMethod "updateCaretPosition" o = Gtk.AccessibleText.AccessibleTextUpdateCaretPositionMethodInfo
    ResolveInscriptionMethod "updateContents" o = Gtk.AccessibleText.AccessibleTextUpdateContentsMethodInfo
    ResolveInscriptionMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveInscriptionMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveInscriptionMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveInscriptionMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveInscriptionMethod "updateSelectionBound" o = Gtk.AccessibleText.AccessibleTextUpdateSelectionBoundMethodInfo
    ResolveInscriptionMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveInscriptionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveInscriptionMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveInscriptionMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveInscriptionMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveInscriptionMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveInscriptionMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveInscriptionMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveInscriptionMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveInscriptionMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveInscriptionMethod "getAttributes" o = InscriptionGetAttributesMethodInfo
    ResolveInscriptionMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveInscriptionMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveInscriptionMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveInscriptionMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveInscriptionMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveInscriptionMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveInscriptionMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveInscriptionMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveInscriptionMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveInscriptionMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveInscriptionMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveInscriptionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveInscriptionMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveInscriptionMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveInscriptionMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveInscriptionMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveInscriptionMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveInscriptionMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveInscriptionMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveInscriptionMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveInscriptionMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveInscriptionMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveInscriptionMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveInscriptionMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveInscriptionMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveInscriptionMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveInscriptionMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveInscriptionMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveInscriptionMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveInscriptionMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveInscriptionMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveInscriptionMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveInscriptionMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveInscriptionMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveInscriptionMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveInscriptionMethod "getMinChars" o = InscriptionGetMinCharsMethodInfo
    ResolveInscriptionMethod "getMinLines" o = InscriptionGetMinLinesMethodInfo
    ResolveInscriptionMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveInscriptionMethod "getNatChars" o = InscriptionGetNatCharsMethodInfo
    ResolveInscriptionMethod "getNatLines" o = InscriptionGetNatLinesMethodInfo
    ResolveInscriptionMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveInscriptionMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveInscriptionMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveInscriptionMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveInscriptionMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveInscriptionMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveInscriptionMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveInscriptionMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveInscriptionMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveInscriptionMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveInscriptionMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveInscriptionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveInscriptionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveInscriptionMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveInscriptionMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveInscriptionMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveInscriptionMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveInscriptionMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveInscriptionMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveInscriptionMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveInscriptionMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveInscriptionMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveInscriptionMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveInscriptionMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveInscriptionMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveInscriptionMethod "getText" o = InscriptionGetTextMethodInfo
    ResolveInscriptionMethod "getTextOverflow" o = InscriptionGetTextOverflowMethodInfo
    ResolveInscriptionMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveInscriptionMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveInscriptionMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveInscriptionMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveInscriptionMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveInscriptionMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveInscriptionMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveInscriptionMethod "getWrapMode" o = InscriptionGetWrapModeMethodInfo
    ResolveInscriptionMethod "getXalign" o = InscriptionGetXalignMethodInfo
    ResolveInscriptionMethod "getYalign" o = InscriptionGetYalignMethodInfo
    ResolveInscriptionMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveInscriptionMethod "setAttributes" o = InscriptionSetAttributesMethodInfo
    ResolveInscriptionMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveInscriptionMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveInscriptionMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveInscriptionMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveInscriptionMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveInscriptionMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveInscriptionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveInscriptionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveInscriptionMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveInscriptionMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveInscriptionMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveInscriptionMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveInscriptionMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveInscriptionMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveInscriptionMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveInscriptionMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveInscriptionMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveInscriptionMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveInscriptionMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveInscriptionMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveInscriptionMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveInscriptionMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveInscriptionMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveInscriptionMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveInscriptionMethod "setMarkup" o = InscriptionSetMarkupMethodInfo
    ResolveInscriptionMethod "setMinChars" o = InscriptionSetMinCharsMethodInfo
    ResolveInscriptionMethod "setMinLines" o = InscriptionSetMinLinesMethodInfo
    ResolveInscriptionMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveInscriptionMethod "setNatChars" o = InscriptionSetNatCharsMethodInfo
    ResolveInscriptionMethod "setNatLines" o = InscriptionSetNatLinesMethodInfo
    ResolveInscriptionMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveInscriptionMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveInscriptionMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveInscriptionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveInscriptionMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveInscriptionMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveInscriptionMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveInscriptionMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveInscriptionMethod "setText" o = InscriptionSetTextMethodInfo
    ResolveInscriptionMethod "setTextOverflow" o = InscriptionSetTextOverflowMethodInfo
    ResolveInscriptionMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveInscriptionMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveInscriptionMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveInscriptionMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveInscriptionMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveInscriptionMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveInscriptionMethod "setWrapMode" o = InscriptionSetWrapModeMethodInfo
    ResolveInscriptionMethod "setXalign" o = InscriptionSetXalignMethodInfo
    ResolveInscriptionMethod "setYalign" o = InscriptionSetYalignMethodInfo
    ResolveInscriptionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveInscriptionMethod t Inscription, O.OverloadedMethod info Inscription p) => OL.IsLabel t (Inscription -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveInscriptionMethod t Inscription, O.OverloadedMethod info Inscription p, R.HasField t Inscription p) => R.HasField t Inscription p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveInscriptionMethod t Inscription, O.OverloadedMethodInfo info Inscription) => OL.IsLabel t (O.MethodProxy info Inscription) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "attributes"
   -- Type: TInterface (Name {namespace = "Pango", name = "AttrList"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@attributes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #attributes
-- @
getInscriptionAttributes :: (MonadIO m, IsInscription o) => o -> m (Maybe Pango.AttrList.AttrList)
getInscriptionAttributes obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "attributes" Pango.AttrList.AttrList

-- | Set the value of the “@attributes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #attributes 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionAttributes :: (MonadIO m, IsInscription o) => o -> Pango.AttrList.AttrList -> m ()
setInscriptionAttributes obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "attributes" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@attributes@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionAttributes :: (IsInscription o, MIO.MonadIO m) => Pango.AttrList.AttrList -> m (GValueConstruct o)
constructInscriptionAttributes val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "attributes" (P.Just val)

-- | Set the value of the “@attributes@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #attributes
-- @
clearInscriptionAttributes :: (MonadIO m, IsInscription o) => o -> m ()
clearInscriptionAttributes obj = liftIO $ B.Properties.setObjectPropertyBoxed obj "attributes" (Nothing :: Maybe Pango.AttrList.AttrList)

#if defined(ENABLE_OVERLOADING)
data InscriptionAttributesPropertyInfo
instance AttrInfo InscriptionAttributesPropertyInfo where
    type AttrAllowedOps InscriptionAttributesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint InscriptionAttributesPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionAttributesPropertyInfo = (~) Pango.AttrList.AttrList
    type AttrTransferTypeConstraint InscriptionAttributesPropertyInfo = (~) Pango.AttrList.AttrList
    type AttrTransferType InscriptionAttributesPropertyInfo = Pango.AttrList.AttrList
    type AttrGetType InscriptionAttributesPropertyInfo = (Maybe Pango.AttrList.AttrList)
    type AttrLabel InscriptionAttributesPropertyInfo = "attributes"
    type AttrOrigin InscriptionAttributesPropertyInfo = Inscription
    attrGet = getInscriptionAttributes
    attrSet = setInscriptionAttributes
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionAttributes
    attrClear = clearInscriptionAttributes
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.attributes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:attributes"
        })
#endif

-- VVV Prop "markup"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Set the value of the “@markup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #markup 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionMarkup :: (MonadIO m, IsInscription o) => o -> T.Text -> m ()
setInscriptionMarkup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "markup" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@markup@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionMarkup :: (IsInscription o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructInscriptionMarkup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "markup" (P.Just val)

-- | Set the value of the “@markup@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #markup
-- @
clearInscriptionMarkup :: (MonadIO m, IsInscription o) => o -> m ()
clearInscriptionMarkup obj = liftIO $ B.Properties.setObjectPropertyString obj "markup" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data InscriptionMarkupPropertyInfo
instance AttrInfo InscriptionMarkupPropertyInfo where
    type AttrAllowedOps InscriptionMarkupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint InscriptionMarkupPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionMarkupPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint InscriptionMarkupPropertyInfo = (~) T.Text
    type AttrTransferType InscriptionMarkupPropertyInfo = T.Text
    type AttrGetType InscriptionMarkupPropertyInfo = ()
    type AttrLabel InscriptionMarkupPropertyInfo = "markup"
    type AttrOrigin InscriptionMarkupPropertyInfo = Inscription
    attrGet = undefined
    attrSet = setInscriptionMarkup
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionMarkup
    attrClear = clearInscriptionMarkup
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.markup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:markup"
        })
#endif

-- VVV Prop "min-chars"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@min-chars@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #minChars
-- @
getInscriptionMinChars :: (MonadIO m, IsInscription o) => o -> m Word32
getInscriptionMinChars obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "min-chars"

-- | Set the value of the “@min-chars@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #minChars 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionMinChars :: (MonadIO m, IsInscription o) => o -> Word32 -> m ()
setInscriptionMinChars obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "min-chars" val

-- | Construct a t'GValueConstruct' with valid value for the “@min-chars@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionMinChars :: (IsInscription o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInscriptionMinChars val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "min-chars" val

#if defined(ENABLE_OVERLOADING)
data InscriptionMinCharsPropertyInfo
instance AttrInfo InscriptionMinCharsPropertyInfo where
    type AttrAllowedOps InscriptionMinCharsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint InscriptionMinCharsPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionMinCharsPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InscriptionMinCharsPropertyInfo = (~) Word32
    type AttrTransferType InscriptionMinCharsPropertyInfo = Word32
    type AttrGetType InscriptionMinCharsPropertyInfo = Word32
    type AttrLabel InscriptionMinCharsPropertyInfo = "min-chars"
    type AttrOrigin InscriptionMinCharsPropertyInfo = Inscription
    attrGet = getInscriptionMinChars
    attrSet = setInscriptionMinChars
    attrPut = setInscriptionMinChars
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionMinChars
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.minChars"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:minChars"
        })
#endif

-- VVV Prop "min-lines"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@min-lines@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #minLines
-- @
getInscriptionMinLines :: (MonadIO m, IsInscription o) => o -> m Word32
getInscriptionMinLines obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "min-lines"

-- | Set the value of the “@min-lines@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #minLines 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionMinLines :: (MonadIO m, IsInscription o) => o -> Word32 -> m ()
setInscriptionMinLines obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "min-lines" val

-- | Construct a t'GValueConstruct' with valid value for the “@min-lines@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionMinLines :: (IsInscription o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInscriptionMinLines val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "min-lines" val

#if defined(ENABLE_OVERLOADING)
data InscriptionMinLinesPropertyInfo
instance AttrInfo InscriptionMinLinesPropertyInfo where
    type AttrAllowedOps InscriptionMinLinesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint InscriptionMinLinesPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionMinLinesPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InscriptionMinLinesPropertyInfo = (~) Word32
    type AttrTransferType InscriptionMinLinesPropertyInfo = Word32
    type AttrGetType InscriptionMinLinesPropertyInfo = Word32
    type AttrLabel InscriptionMinLinesPropertyInfo = "min-lines"
    type AttrOrigin InscriptionMinLinesPropertyInfo = Inscription
    attrGet = getInscriptionMinLines
    attrSet = setInscriptionMinLines
    attrPut = setInscriptionMinLines
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionMinLines
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.minLines"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:minLines"
        })
#endif

-- VVV Prop "nat-chars"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@nat-chars@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #natChars
-- @
getInscriptionNatChars :: (MonadIO m, IsInscription o) => o -> m Word32
getInscriptionNatChars obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "nat-chars"

-- | Set the value of the “@nat-chars@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #natChars 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionNatChars :: (MonadIO m, IsInscription o) => o -> Word32 -> m ()
setInscriptionNatChars obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "nat-chars" val

-- | Construct a t'GValueConstruct' with valid value for the “@nat-chars@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionNatChars :: (IsInscription o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInscriptionNatChars val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "nat-chars" val

#if defined(ENABLE_OVERLOADING)
data InscriptionNatCharsPropertyInfo
instance AttrInfo InscriptionNatCharsPropertyInfo where
    type AttrAllowedOps InscriptionNatCharsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint InscriptionNatCharsPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionNatCharsPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InscriptionNatCharsPropertyInfo = (~) Word32
    type AttrTransferType InscriptionNatCharsPropertyInfo = Word32
    type AttrGetType InscriptionNatCharsPropertyInfo = Word32
    type AttrLabel InscriptionNatCharsPropertyInfo = "nat-chars"
    type AttrOrigin InscriptionNatCharsPropertyInfo = Inscription
    attrGet = getInscriptionNatChars
    attrSet = setInscriptionNatChars
    attrPut = setInscriptionNatChars
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionNatChars
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.natChars"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:natChars"
        })
#endif

-- VVV Prop "nat-lines"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@nat-lines@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #natLines
-- @
getInscriptionNatLines :: (MonadIO m, IsInscription o) => o -> m Word32
getInscriptionNatLines obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "nat-lines"

-- | Set the value of the “@nat-lines@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #natLines 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionNatLines :: (MonadIO m, IsInscription o) => o -> Word32 -> m ()
setInscriptionNatLines obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "nat-lines" val

-- | Construct a t'GValueConstruct' with valid value for the “@nat-lines@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionNatLines :: (IsInscription o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructInscriptionNatLines val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "nat-lines" val

#if defined(ENABLE_OVERLOADING)
data InscriptionNatLinesPropertyInfo
instance AttrInfo InscriptionNatLinesPropertyInfo where
    type AttrAllowedOps InscriptionNatLinesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint InscriptionNatLinesPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionNatLinesPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint InscriptionNatLinesPropertyInfo = (~) Word32
    type AttrTransferType InscriptionNatLinesPropertyInfo = Word32
    type AttrGetType InscriptionNatLinesPropertyInfo = Word32
    type AttrLabel InscriptionNatLinesPropertyInfo = "nat-lines"
    type AttrOrigin InscriptionNatLinesPropertyInfo = Inscription
    attrGet = getInscriptionNatLines
    attrSet = setInscriptionNatLines
    attrPut = setInscriptionNatLines
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionNatLines
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.natLines"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:natLines"
        })
#endif

-- VVV Prop "text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #text
-- @
getInscriptionText :: (MonadIO m, IsInscription o) => o -> m (Maybe T.Text)
getInscriptionText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "text"

-- | Set the value of the “@text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #text 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionText :: (MonadIO m, IsInscription o) => o -> T.Text -> m ()
setInscriptionText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "text" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionText :: (IsInscription o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructInscriptionText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "text" (P.Just val)

-- | Set the value of the “@text@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #text
-- @
clearInscriptionText :: (MonadIO m, IsInscription o) => o -> m ()
clearInscriptionText obj = liftIO $ B.Properties.setObjectPropertyString obj "text" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data InscriptionTextPropertyInfo
instance AttrInfo InscriptionTextPropertyInfo where
    type AttrAllowedOps InscriptionTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint InscriptionTextPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint InscriptionTextPropertyInfo = (~) T.Text
    type AttrTransferType InscriptionTextPropertyInfo = T.Text
    type AttrGetType InscriptionTextPropertyInfo = (Maybe T.Text)
    type AttrLabel InscriptionTextPropertyInfo = "text"
    type AttrOrigin InscriptionTextPropertyInfo = Inscription
    attrGet = getInscriptionText
    attrSet = setInscriptionText
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionText
    attrClear = clearInscriptionText
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.text"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:text"
        })
#endif

-- VVV Prop "text-overflow"
   -- Type: TInterface (Name {namespace = "Gtk", name = "InscriptionOverflow"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@text-overflow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #textOverflow
-- @
getInscriptionTextOverflow :: (MonadIO m, IsInscription o) => o -> m Gtk.Enums.InscriptionOverflow
getInscriptionTextOverflow obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "text-overflow"

-- | Set the value of the “@text-overflow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #textOverflow 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionTextOverflow :: (MonadIO m, IsInscription o) => o -> Gtk.Enums.InscriptionOverflow -> m ()
setInscriptionTextOverflow obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "text-overflow" val

-- | Construct a t'GValueConstruct' with valid value for the “@text-overflow@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionTextOverflow :: (IsInscription o, MIO.MonadIO m) => Gtk.Enums.InscriptionOverflow -> m (GValueConstruct o)
constructInscriptionTextOverflow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "text-overflow" val

#if defined(ENABLE_OVERLOADING)
data InscriptionTextOverflowPropertyInfo
instance AttrInfo InscriptionTextOverflowPropertyInfo where
    type AttrAllowedOps InscriptionTextOverflowPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint InscriptionTextOverflowPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionTextOverflowPropertyInfo = (~) Gtk.Enums.InscriptionOverflow
    type AttrTransferTypeConstraint InscriptionTextOverflowPropertyInfo = (~) Gtk.Enums.InscriptionOverflow
    type AttrTransferType InscriptionTextOverflowPropertyInfo = Gtk.Enums.InscriptionOverflow
    type AttrGetType InscriptionTextOverflowPropertyInfo = Gtk.Enums.InscriptionOverflow
    type AttrLabel InscriptionTextOverflowPropertyInfo = "text-overflow"
    type AttrOrigin InscriptionTextOverflowPropertyInfo = Inscription
    attrGet = getInscriptionTextOverflow
    attrSet = setInscriptionTextOverflow
    attrPut = setInscriptionTextOverflow
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionTextOverflow
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.textOverflow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:textOverflow"
        })
#endif

-- VVV Prop "wrap-mode"
   -- Type: TInterface (Name {namespace = "Pango", name = "WrapMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@wrap-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #wrapMode
-- @
getInscriptionWrapMode :: (MonadIO m, IsInscription o) => o -> m Pango.Enums.WrapMode
getInscriptionWrapMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "wrap-mode"

-- | Set the value of the “@wrap-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #wrapMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionWrapMode :: (MonadIO m, IsInscription o) => o -> Pango.Enums.WrapMode -> m ()
setInscriptionWrapMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "wrap-mode" val

-- | Construct a t'GValueConstruct' with valid value for the “@wrap-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionWrapMode :: (IsInscription o, MIO.MonadIO m) => Pango.Enums.WrapMode -> m (GValueConstruct o)
constructInscriptionWrapMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "wrap-mode" val

#if defined(ENABLE_OVERLOADING)
data InscriptionWrapModePropertyInfo
instance AttrInfo InscriptionWrapModePropertyInfo where
    type AttrAllowedOps InscriptionWrapModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint InscriptionWrapModePropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionWrapModePropertyInfo = (~) Pango.Enums.WrapMode
    type AttrTransferTypeConstraint InscriptionWrapModePropertyInfo = (~) Pango.Enums.WrapMode
    type AttrTransferType InscriptionWrapModePropertyInfo = Pango.Enums.WrapMode
    type AttrGetType InscriptionWrapModePropertyInfo = Pango.Enums.WrapMode
    type AttrLabel InscriptionWrapModePropertyInfo = "wrap-mode"
    type AttrOrigin InscriptionWrapModePropertyInfo = Inscription
    attrGet = getInscriptionWrapMode
    attrSet = setInscriptionWrapMode
    attrPut = setInscriptionWrapMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionWrapMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.wrapMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:wrapMode"
        })
#endif

-- VVV Prop "xalign"
   -- Type: TBasicType TFloat
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@xalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #xalign
-- @
getInscriptionXalign :: (MonadIO m, IsInscription o) => o -> m Float
getInscriptionXalign obj = MIO.liftIO $ B.Properties.getObjectPropertyFloat obj "xalign"

-- | Set the value of the “@xalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #xalign 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionXalign :: (MonadIO m, IsInscription o) => o -> Float -> m ()
setInscriptionXalign obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFloat obj "xalign" val

-- | Construct a t'GValueConstruct' with valid value for the “@xalign@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionXalign :: (IsInscription o, MIO.MonadIO m) => Float -> m (GValueConstruct o)
constructInscriptionXalign val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFloat "xalign" val

#if defined(ENABLE_OVERLOADING)
data InscriptionXalignPropertyInfo
instance AttrInfo InscriptionXalignPropertyInfo where
    type AttrAllowedOps InscriptionXalignPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint InscriptionXalignPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionXalignPropertyInfo = (~) Float
    type AttrTransferTypeConstraint InscriptionXalignPropertyInfo = (~) Float
    type AttrTransferType InscriptionXalignPropertyInfo = Float
    type AttrGetType InscriptionXalignPropertyInfo = Float
    type AttrLabel InscriptionXalignPropertyInfo = "xalign"
    type AttrOrigin InscriptionXalignPropertyInfo = Inscription
    attrGet = getInscriptionXalign
    attrSet = setInscriptionXalign
    attrPut = setInscriptionXalign
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionXalign
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.xalign"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:xalign"
        })
#endif

-- VVV Prop "yalign"
   -- Type: TBasicType TFloat
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@yalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' inscription #yalign
-- @
getInscriptionYalign :: (MonadIO m, IsInscription o) => o -> m Float
getInscriptionYalign obj = MIO.liftIO $ B.Properties.getObjectPropertyFloat obj "yalign"

-- | Set the value of the “@yalign@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' inscription [ #yalign 'Data.GI.Base.Attributes.:=' value ]
-- @
setInscriptionYalign :: (MonadIO m, IsInscription o) => o -> Float -> m ()
setInscriptionYalign obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFloat obj "yalign" val

-- | Construct a t'GValueConstruct' with valid value for the “@yalign@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructInscriptionYalign :: (IsInscription o, MIO.MonadIO m) => Float -> m (GValueConstruct o)
constructInscriptionYalign val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFloat "yalign" val

#if defined(ENABLE_OVERLOADING)
data InscriptionYalignPropertyInfo
instance AttrInfo InscriptionYalignPropertyInfo where
    type AttrAllowedOps InscriptionYalignPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint InscriptionYalignPropertyInfo = IsInscription
    type AttrSetTypeConstraint InscriptionYalignPropertyInfo = (~) Float
    type AttrTransferTypeConstraint InscriptionYalignPropertyInfo = (~) Float
    type AttrTransferType InscriptionYalignPropertyInfo = Float
    type AttrGetType InscriptionYalignPropertyInfo = Float
    type AttrLabel InscriptionYalignPropertyInfo = "yalign"
    type AttrOrigin InscriptionYalignPropertyInfo = Inscription
    attrGet = getInscriptionYalign
    attrSet = setInscriptionYalign
    attrPut = setInscriptionYalign
    attrTransfer _ v = do
        return v
    attrConstruct = constructInscriptionYalign
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.yalign"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#g:attr:yalign"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Inscription
type instance O.AttributeList Inscription = InscriptionAttributeList
type InscriptionAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("attributes", InscriptionAttributesPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("markup", InscriptionMarkupPropertyInfo), '("minChars", InscriptionMinCharsPropertyInfo), '("minLines", InscriptionMinLinesPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("natChars", InscriptionNatCharsPropertyInfo), '("natLines", InscriptionNatLinesPropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("text", InscriptionTextPropertyInfo), '("textOverflow", InscriptionTextOverflowPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo), '("wrapMode", InscriptionWrapModePropertyInfo), '("xalign", InscriptionXalignPropertyInfo), '("yalign", InscriptionYalignPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
inscriptionAttributes :: AttrLabelProxy "attributes"
inscriptionAttributes = AttrLabelProxy

inscriptionMarkup :: AttrLabelProxy "markup"
inscriptionMarkup = AttrLabelProxy

inscriptionMinChars :: AttrLabelProxy "minChars"
inscriptionMinChars = AttrLabelProxy

inscriptionMinLines :: AttrLabelProxy "minLines"
inscriptionMinLines = AttrLabelProxy

inscriptionNatChars :: AttrLabelProxy "natChars"
inscriptionNatChars = AttrLabelProxy

inscriptionNatLines :: AttrLabelProxy "natLines"
inscriptionNatLines = AttrLabelProxy

inscriptionText :: AttrLabelProxy "text"
inscriptionText = AttrLabelProxy

inscriptionTextOverflow :: AttrLabelProxy "textOverflow"
inscriptionTextOverflow = AttrLabelProxy

inscriptionWrapMode :: AttrLabelProxy "wrapMode"
inscriptionWrapMode = AttrLabelProxy

inscriptionXalign :: AttrLabelProxy "xalign"
inscriptionXalign = AttrLabelProxy

inscriptionYalign :: AttrLabelProxy "yalign"
inscriptionYalign = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Inscription = InscriptionSignalList
type InscriptionSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Inscription::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The text to display."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Inscription" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_new" gtk_inscription_new :: 
    CString ->                              -- text : TBasicType TUTF8
    IO (Ptr Inscription)

-- | Creates a new @GtkInscription@ with the given text.
-- 
-- /Since: 4.8/
inscriptionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@text@/: The text to display.
    -> m Inscription
    -- ^ __Returns:__ a new @GtkInscription@
inscriptionNew text = liftIO $ do
    maybeText <- case text of
        Nothing -> return FP.nullPtr
        Just jText -> do
            jText' <- textToCString jText
            return jText'
    result <- gtk_inscription_new maybeText
    checkUnexpectedReturnNULL "inscriptionNew" result
    result' <- (newObject Inscription) result
    freeMem maybeText
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Inscription::get_attributes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "AttrList" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_attributes" gtk_inscription_get_attributes :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO (Ptr Pango.AttrList.AttrList)

-- | Gets the inscription\'s attribute list.
-- 
-- /Since: 4.8/
inscriptionGetAttributes ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m (Maybe Pango.AttrList.AttrList)
    -- ^ __Returns:__ the attribute list
inscriptionGetAttributes self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_attributes self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newBoxed Pango.AttrList.AttrList) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data InscriptionGetAttributesMethodInfo
instance (signature ~ (m (Maybe Pango.AttrList.AttrList)), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetAttributesMethodInfo a signature where
    overloadedMethod = inscriptionGetAttributes

instance O.OverloadedMethodInfo InscriptionGetAttributesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetAttributes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetAttributes"
        })


#endif

-- method Inscription::get_min_chars
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_min_chars" gtk_inscription_get_min_chars :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO Word32

-- | Gets the @min-chars@ of the inscription.
-- 
-- See the [Inscription:minChars]("GI.Gtk.Objects.Inscription#g:attr:minChars") property.
-- 
-- /Since: 4.8/
inscriptionGetMinChars ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m Word32
    -- ^ __Returns:__ the min-chars property
inscriptionGetMinChars self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_min_chars self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data InscriptionGetMinCharsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetMinCharsMethodInfo a signature where
    overloadedMethod = inscriptionGetMinChars

instance O.OverloadedMethodInfo InscriptionGetMinCharsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetMinChars",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetMinChars"
        })


#endif

-- method Inscription::get_min_lines
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_min_lines" gtk_inscription_get_min_lines :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO Word32

-- | Gets the @min-lines@ of the inscription.
-- 
-- See the [Inscription:minLines]("GI.Gtk.Objects.Inscription#g:attr:minLines") property.
-- 
-- /Since: 4.8/
inscriptionGetMinLines ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m Word32
    -- ^ __Returns:__ the min-lines property
inscriptionGetMinLines self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_min_lines self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data InscriptionGetMinLinesMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetMinLinesMethodInfo a signature where
    overloadedMethod = inscriptionGetMinLines

instance O.OverloadedMethodInfo InscriptionGetMinLinesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetMinLines",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetMinLines"
        })


#endif

-- method Inscription::get_nat_chars
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_nat_chars" gtk_inscription_get_nat_chars :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO Word32

-- | Gets the @nat-chars@ of the inscription.
-- 
-- See the [Inscription:natChars]("GI.Gtk.Objects.Inscription#g:attr:natChars") property.
-- 
-- /Since: 4.8/
inscriptionGetNatChars ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m Word32
    -- ^ __Returns:__ the nat-chars property
inscriptionGetNatChars self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_nat_chars self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data InscriptionGetNatCharsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetNatCharsMethodInfo a signature where
    overloadedMethod = inscriptionGetNatChars

instance O.OverloadedMethodInfo InscriptionGetNatCharsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetNatChars",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetNatChars"
        })


#endif

-- method Inscription::get_nat_lines
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_nat_lines" gtk_inscription_get_nat_lines :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO Word32

-- | Gets the @nat-lines@ of the inscription.
-- 
-- See the [Inscription:natLines]("GI.Gtk.Objects.Inscription#g:attr:natLines") property.
-- 
-- /Since: 4.8/
inscriptionGetNatLines ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m Word32
    -- ^ __Returns:__ the nat-lines property
inscriptionGetNatLines self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_nat_lines self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data InscriptionGetNatLinesMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetNatLinesMethodInfo a signature where
    overloadedMethod = inscriptionGetNatLines

instance O.OverloadedMethodInfo InscriptionGetNatLinesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetNatLines",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetNatLines"
        })


#endif

-- method Inscription::get_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_text" gtk_inscription_get_text :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO CString

-- | Gets the text that is displayed.
-- 
-- /Since: 4.8/
inscriptionGetText ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The displayed text
inscriptionGetText self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_text self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data InscriptionGetTextMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetTextMethodInfo a signature where
    overloadedMethod = inscriptionGetText

instance O.OverloadedMethodInfo InscriptionGetTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetText"
        })


#endif

-- method Inscription::get_text_overflow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "InscriptionOverflow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_text_overflow" gtk_inscription_get_text_overflow :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO CUInt

-- | Gets the inscription\'s overflow method.
-- 
-- /Since: 4.8/
inscriptionGetTextOverflow ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m Gtk.Enums.InscriptionOverflow
    -- ^ __Returns:__ the overflow method
inscriptionGetTextOverflow self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_text_overflow self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data InscriptionGetTextOverflowMethodInfo
instance (signature ~ (m Gtk.Enums.InscriptionOverflow), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetTextOverflowMethodInfo a signature where
    overloadedMethod = inscriptionGetTextOverflow

instance O.OverloadedMethodInfo InscriptionGetTextOverflowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetTextOverflow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetTextOverflow"
        })


#endif

-- method Inscription::get_wrap_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "WrapMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_wrap_mode" gtk_inscription_get_wrap_mode :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO CUInt

-- | Returns line wrap mode used by the inscription.
-- 
-- See 'GI.Gtk.Objects.Inscription.inscriptionSetWrapMode'.
-- 
-- /Since: 4.8/
inscriptionGetWrapMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m Pango.Enums.WrapMode
    -- ^ __Returns:__ the line wrap mode
inscriptionGetWrapMode self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_wrap_mode self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data InscriptionGetWrapModeMethodInfo
instance (signature ~ (m Pango.Enums.WrapMode), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetWrapModeMethodInfo a signature where
    overloadedMethod = inscriptionGetWrapMode

instance O.OverloadedMethodInfo InscriptionGetWrapModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetWrapMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetWrapMode"
        })


#endif

-- method Inscription::get_xalign
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_xalign" gtk_inscription_get_xalign :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO CFloat

-- | Gets the @xalign@ of the inscription.
-- 
-- See the [Inscription:xalign]("GI.Gtk.Objects.Inscription#g:attr:xalign") property.
-- 
-- /Since: 4.8/
inscriptionGetXalign ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m Float
    -- ^ __Returns:__ the xalign property
inscriptionGetXalign self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_xalign self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data InscriptionGetXalignMethodInfo
instance (signature ~ (m Float), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetXalignMethodInfo a signature where
    overloadedMethod = inscriptionGetXalign

instance O.OverloadedMethodInfo InscriptionGetXalignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetXalign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetXalign"
        })


#endif

-- method Inscription::get_yalign
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_get_yalign" gtk_inscription_get_yalign :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    IO CFloat

-- | Gets the @yalign@ of the inscription.
-- 
-- See the [Inscription:yalign]("GI.Gtk.Objects.Inscription#g:attr:yalign") property.
-- 
-- /Since: 4.8/
inscriptionGetYalign ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> m Float
    -- ^ __Returns:__ the yalign property
inscriptionGetYalign self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_inscription_get_yalign self'
    let result' = realToFrac result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data InscriptionGetYalignMethodInfo
instance (signature ~ (m Float), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionGetYalignMethodInfo a signature where
    overloadedMethod = inscriptionGetYalign

instance O.OverloadedMethodInfo InscriptionGetYalignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionGetYalign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionGetYalign"
        })


#endif

-- method Inscription::set_attributes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attrs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrList" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a [struct@Pango.AttrList]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_attributes" gtk_inscription_set_attributes :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    Ptr Pango.AttrList.AttrList ->          -- attrs : TInterface (Name {namespace = "Pango", name = "AttrList"})
    IO ()

-- | Apply attributes to the inscription text.
-- 
-- These attributes will not be evaluated for sizing the inscription.
-- 
-- /Since: 4.8/
inscriptionSetAttributes ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Maybe (Pango.AttrList.AttrList)
    -- ^ /@attrs@/: a t'GI.Pango.Structs.AttrList.AttrList'
    -> m ()
inscriptionSetAttributes self attrs = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeAttrs <- case attrs of
        Nothing -> return FP.nullPtr
        Just jAttrs -> do
            jAttrs' <- unsafeManagedPtrGetPtr jAttrs
            return jAttrs'
    gtk_inscription_set_attributes self' maybeAttrs
    touchManagedPtr self
    whenJust attrs touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetAttributesMethodInfo
instance (signature ~ (Maybe (Pango.AttrList.AttrList) -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetAttributesMethodInfo a signature where
    overloadedMethod = inscriptionSetAttributes

instance O.OverloadedMethodInfo InscriptionSetAttributesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetAttributes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetAttributes"
        })


#endif

-- method Inscription::set_markup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "markup"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The markup to display"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_markup" gtk_inscription_set_markup :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    CString ->                              -- markup : TBasicType TUTF8
    IO ()

-- | Utility function to set the text and attributes to be displayed.
-- 
-- See the [Inscription:markup]("GI.Gtk.Objects.Inscription#g:attr:markup") property.
-- 
-- /Since: 4.8/
inscriptionSetMarkup ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Maybe (T.Text)
    -- ^ /@markup@/: The markup to display
    -> m ()
inscriptionSetMarkup self markup = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeMarkup <- case markup of
        Nothing -> return FP.nullPtr
        Just jMarkup -> do
            jMarkup' <- textToCString jMarkup
            return jMarkup'
    gtk_inscription_set_markup self' maybeMarkup
    touchManagedPtr self
    freeMem maybeMarkup
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetMarkupMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetMarkupMethodInfo a signature where
    overloadedMethod = inscriptionSetMarkup

instance O.OverloadedMethodInfo InscriptionSetMarkupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetMarkup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetMarkup"
        })


#endif

-- method Inscription::set_min_chars
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min_chars"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the minimum number of characters that should fit, approximately"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_min_chars" gtk_inscription_set_min_chars :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    Word32 ->                               -- min_chars : TBasicType TUInt
    IO ()

-- | Sets the @min-chars@ of the inscription.
-- 
-- See the [Inscription:minChars]("GI.Gtk.Objects.Inscription#g:attr:minChars") property.
-- 
-- /Since: 4.8/
inscriptionSetMinChars ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Word32
    -- ^ /@minChars@/: the minimum number of characters that should fit, approximately
    -> m ()
inscriptionSetMinChars self minChars = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_inscription_set_min_chars self' minChars
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetMinCharsMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetMinCharsMethodInfo a signature where
    overloadedMethod = inscriptionSetMinChars

instance O.OverloadedMethodInfo InscriptionSetMinCharsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetMinChars",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetMinChars"
        })


#endif

-- method Inscription::set_min_lines
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "min_lines"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the minimum number of lines that should fit, approximately"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_min_lines" gtk_inscription_set_min_lines :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    Word32 ->                               -- min_lines : TBasicType TUInt
    IO ()

-- | Sets the @min-lines@ of the inscription.
-- 
-- See the [Inscription:minLines]("GI.Gtk.Objects.Inscription#g:attr:minLines") property.
-- 
-- /Since: 4.8/
inscriptionSetMinLines ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Word32
    -- ^ /@minLines@/: the minimum number of lines that should fit, approximately
    -> m ()
inscriptionSetMinLines self minLines = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_inscription_set_min_lines self' minLines
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetMinLinesMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetMinLinesMethodInfo a signature where
    overloadedMethod = inscriptionSetMinLines

instance O.OverloadedMethodInfo InscriptionSetMinLinesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetMinLines",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetMinLines"
        })


#endif

-- method Inscription::set_nat_chars
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nat_chars"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the number of characters that should ideally fit, approximately"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_nat_chars" gtk_inscription_set_nat_chars :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    Word32 ->                               -- nat_chars : TBasicType TUInt
    IO ()

-- | Sets the @nat-chars@ of the inscription.
-- 
-- See the [Inscription:natChars]("GI.Gtk.Objects.Inscription#g:attr:natChars") property.
-- 
-- /Since: 4.8/
inscriptionSetNatChars ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Word32
    -- ^ /@natChars@/: the number of characters that should ideally fit, approximately
    -> m ()
inscriptionSetNatChars self natChars = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_inscription_set_nat_chars self' natChars
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetNatCharsMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetNatCharsMethodInfo a signature where
    overloadedMethod = inscriptionSetNatChars

instance O.OverloadedMethodInfo InscriptionSetNatCharsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetNatChars",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetNatChars"
        })


#endif

-- method Inscription::set_nat_lines
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nat_lines"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of lines that should ideally fit"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_nat_lines" gtk_inscription_set_nat_lines :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    Word32 ->                               -- nat_lines : TBasicType TUInt
    IO ()

-- | Sets the @nat-lines@ of the inscription.
-- 
-- See the [Inscription:natLines]("GI.Gtk.Objects.Inscription#g:attr:natLines") property.
-- 
-- /Since: 4.8/
inscriptionSetNatLines ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Word32
    -- ^ /@natLines@/: the number of lines that should ideally fit
    -> m ()
inscriptionSetNatLines self natLines = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_inscription_set_nat_lines self' natLines
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetNatLinesMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetNatLinesMethodInfo a signature where
    overloadedMethod = inscriptionSetNatLines

instance O.OverloadedMethodInfo InscriptionSetNatLinesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetNatLines",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetNatLines"
        })


#endif

-- method Inscription::set_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The text to display"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_text" gtk_inscription_set_text :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    CString ->                              -- text : TBasicType TUTF8
    IO ()

-- | Sets the text to be displayed.
-- 
-- /Since: 4.8/
inscriptionSetText ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Maybe (T.Text)
    -- ^ /@text@/: The text to display
    -> m ()
inscriptionSetText self text = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeText <- case text of
        Nothing -> return FP.nullPtr
        Just jText -> do
            jText' <- textToCString jText
            return jText'
    gtk_inscription_set_text self' maybeText
    touchManagedPtr self
    freeMem maybeText
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetTextMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetTextMethodInfo a signature where
    overloadedMethod = inscriptionSetText

instance O.OverloadedMethodInfo InscriptionSetTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetText"
        })


#endif

-- method Inscription::set_text_overflow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "overflow"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "InscriptionOverflow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the overflow method to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_text_overflow" gtk_inscription_set_text_overflow :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    CUInt ->                                -- overflow : TInterface (Name {namespace = "Gtk", name = "InscriptionOverflow"})
    IO ()

-- | Sets what to do when the text doesn\'t fit.
-- 
-- /Since: 4.8/
inscriptionSetTextOverflow ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Gtk.Enums.InscriptionOverflow
    -- ^ /@overflow@/: the overflow method to use
    -> m ()
inscriptionSetTextOverflow self overflow = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let overflow' = (fromIntegral . fromEnum) overflow
    gtk_inscription_set_text_overflow self' overflow'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetTextOverflowMethodInfo
instance (signature ~ (Gtk.Enums.InscriptionOverflow -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetTextOverflowMethodInfo a signature where
    overloadedMethod = inscriptionSetTextOverflow

instance O.OverloadedMethodInfo InscriptionSetTextOverflowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetTextOverflow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetTextOverflow"
        })


#endif

-- method Inscription::set_wrap_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "wrap_mode"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "WrapMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the line wrapping mode"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_wrap_mode" gtk_inscription_set_wrap_mode :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    CUInt ->                                -- wrap_mode : TInterface (Name {namespace = "Pango", name = "WrapMode"})
    IO ()

-- | Controls how line wrapping is done.
-- 
-- /Since: 4.8/
inscriptionSetWrapMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Pango.Enums.WrapMode
    -- ^ /@wrapMode@/: the line wrapping mode
    -> m ()
inscriptionSetWrapMode self wrapMode = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let wrapMode' = (fromIntegral . fromEnum) wrapMode
    gtk_inscription_set_wrap_mode self' wrapMode'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetWrapModeMethodInfo
instance (signature ~ (Pango.Enums.WrapMode -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetWrapModeMethodInfo a signature where
    overloadedMethod = inscriptionSetWrapMode

instance O.OverloadedMethodInfo InscriptionSetWrapModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetWrapMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetWrapMode"
        })


#endif

-- method Inscription::set_xalign
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xalign"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new xalign value, between 0 and 1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_xalign" gtk_inscription_set_xalign :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    CFloat ->                               -- xalign : TBasicType TFloat
    IO ()

-- | Sets the @xalign@ of the inscription.
-- 
-- See the [Inscription:xalign]("GI.Gtk.Objects.Inscription#g:attr:xalign") property.
-- 
-- /Since: 4.8/
inscriptionSetXalign ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Float
    -- ^ /@xalign@/: the new xalign value, between 0 and 1
    -> m ()
inscriptionSetXalign self xalign = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let xalign' = realToFrac xalign
    gtk_inscription_set_xalign self' xalign'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetXalignMethodInfo
instance (signature ~ (Float -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetXalignMethodInfo a signature where
    overloadedMethod = inscriptionSetXalign

instance O.OverloadedMethodInfo InscriptionSetXalignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetXalign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetXalign"
        })


#endif

-- method Inscription::set_yalign
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Inscription" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkInscription`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "yalign"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new yalign value, between 0 and 1"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_inscription_set_yalign" gtk_inscription_set_yalign :: 
    Ptr Inscription ->                      -- self : TInterface (Name {namespace = "Gtk", name = "Inscription"})
    CFloat ->                               -- yalign : TBasicType TFloat
    IO ()

-- | Sets the @yalign@ of the inscription.
-- 
-- See the [Inscription:yalign]("GI.Gtk.Objects.Inscription#g:attr:yalign") property.
-- 
-- /Since: 4.8/
inscriptionSetYalign ::
    (B.CallStack.HasCallStack, MonadIO m, IsInscription a) =>
    a
    -- ^ /@self@/: a @GtkInscription@
    -> Float
    -- ^ /@yalign@/: the new yalign value, between 0 and 1
    -> m ()
inscriptionSetYalign self yalign = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let yalign' = realToFrac yalign
    gtk_inscription_set_yalign self' yalign'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data InscriptionSetYalignMethodInfo
instance (signature ~ (Float -> m ()), MonadIO m, IsInscription a) => O.OverloadedMethod InscriptionSetYalignMethodInfo a signature where
    overloadedMethod = inscriptionSetYalign

instance O.OverloadedMethodInfo InscriptionSetYalignMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Inscription.inscriptionSetYalign",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-Inscription.html#v:inscriptionSetYalign"
        })


#endif


