/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_sink_f = R"doc(A graphical sink to display freq, spec, and time.

This is a QT-based graphical sink the takes a float stream and plots it. The default action is to plot the signal as a PSD (FFT), spectrogram (waterfall), and time domain plots. The plots may be turned off by setting the appropriate boolean value in the constructor to False.


Message Ports:

Constructor Specific Documentation:

Build a floating point qtgui sink.

Args:
    fftsize : size of the FFT to compute and display
    wintype : type of window to apply (see gnuradio/filter/firdes.h)
    fc : center frequency of signal (use for x-axis labels)
    bw : bandwidth of signal (used to set x-axis labels)
    name : title for the plot
    plotfreq : Toggle frequency plot on/off
    plotwaterfall : Toggle waterfall plot on/off
    plottime : Toggle time plot on/off
    plotconst : Toggle constellation plot on/off
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_sink_f_sink_f_0 = R"doc()doc";


static const char* __doc_gr_qtgui_sink_f_sink_f_1 = R"doc()doc";


static const char* __doc_gr_qtgui_sink_f_make = R"doc(A graphical sink to display freq, spec, and time.

This is a QT-based graphical sink the takes a float stream and plots it. The default action is to plot the signal as a PSD (FFT), spectrogram (waterfall), and time domain plots. The plots may be turned off by setting the appropriate boolean value in the constructor to False.


Message Ports:

Constructor Specific Documentation:

Build a floating point qtgui sink.

Args:
    fftsize : size of the FFT to compute and display
    wintype : type of window to apply (see gnuradio/filter/firdes.h)
    fc : center frequency of signal (use for x-axis labels)
    bw : bandwidth of signal (used to set x-axis labels)
    name : title for the plot
    plotfreq : Toggle frequency plot on/off
    plotwaterfall : Toggle waterfall plot on/off
    plottime : Toggle time plot on/off
    plotconst : Toggle constellation plot on/off
    parent : a QWidget parent object, if any)doc";


static const char* __doc_gr_qtgui_sink_f_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_sink_f_qwidget = R"doc()doc";


static const char* __doc_gr_qtgui_sink_f_set_fft_size = R"doc()doc";


static const char* __doc_gr_qtgui_sink_f_fft_size = R"doc()doc";


static const char* __doc_gr_qtgui_sink_f_set_frequency_range = R"doc()doc";


static const char* __doc_gr_qtgui_sink_f_set_fft_power_db = R"doc()doc";


static const char* __doc_gr_qtgui_sink_f_enable_rf_freq = R"doc()doc";


static const char* __doc_gr_qtgui_sink_f_set_update_time = R"doc()doc";
