/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_generic_decoder = R"doc(Parent class for FECAPI objects.

Parent of a decoder variable class for FECAPI that will fit into the gr::fec::decoder block to handle FEC decoding. This class provides the basic information required to fit into the FECAPI structure. It provides information about input and output data types, potential data conversions, and a few other parameters useful to establish the decoder's behavior.


We create objects from FECAPI-derived classes to go into the actual GNU Radio decoder block. Each object contains its own state and so there should be a one-to-one mapping of an FECAPI object and a GR decoder block. Sharing these objects is not guaranteed to be thread-safe.


This is a pure virtual class and must be derived from by a child class.)doc";


static const char* __doc_gr_fec_generic_decoder_generic_decoder_0 = R"doc()doc";


static const char* __doc_gr_fec_generic_decoder_generic_decoder_1 = R"doc()doc";


static const char* __doc_gr_fec_generic_decoder_generic_decoder_2 = R"doc()doc";


static const char* __doc_gr_fec_generic_decoder_generic_work = R"doc()doc";


static const char* __doc_gr_fec_generic_decoder_unique_id = R"doc()doc";


static const char* __doc_gr_fec_generic_decoder_alias = R"doc()doc";


static const char* __doc_gr_fec_generic_decoder_rate = R"doc(Returns the rate of the code. For every r input bits, there is 1 output bit, so the rate is 1/r. Used for setting things like the encoder block's relative rate.


This function MUST be reimplemented by the child class.)doc";


static const char* __doc_gr_fec_generic_decoder_get_input_size = R"doc(Returns the input size in items that the decoder object uses to decode a full frame. Often, this number is the number of bits per frame if the input format is unpacked. If the block expects packed bytes, then this value should be the number of bytes (number of bits / 8) per input frame.


The child class MUST implement this function.)doc";


static const char* __doc_gr_fec_generic_decoder_get_output_size = R"doc(Returns the output size in items that the decoder object produces after decoding a full frame. Often, this number is the number of bits in the outputted frame if the input format is unpacked. If the block produces packed bytes, then this value should be the number of bytes (number of bits / 8) per frame produced. This value is generally something like get_input_size()/R for a 1/R rate code.


The child class MUST implement this function.)doc";


static const char* __doc_gr_fec_generic_decoder_get_history = R"doc(Sets up history for the decoder when the decoder is required to look ahead in the data stream in order to finish its processing.


The child class MAY implement this function. If not reimplemented, it returns 0.)doc";


static const char* __doc_gr_fec_generic_decoder_get_shift = R"doc(Some decoders require the input items to float around a particular soft value. We can set that floating value by setting this value to return some non-zero number.


The fec.extended_decoder block will use this to create an add_const_ff block before the decoder block to adjust all input samples appropriately.


The child class MAY implement this function. If not reimplemented, it returns 0.)doc";


static const char* __doc_gr_fec_generic_decoder_get_input_item_size = R"doc(Sets the size of an input item, as in the size of a char or float item.


The child class SHOULD implement this function. If not reimplemented, it returns sizeof(float) as the decoders typically expect floating point input types.)doc";


static const char* __doc_gr_fec_generic_decoder_get_output_item_size = R"doc(Sets the size of an output item, as in the size of a char or float item.


The child class SHOULD implement this function. If not reimplemented, it returns sizeof(char) as the decoders typically expect to produce bits or bytes.)doc";


static const char* __doc_gr_fec_generic_decoder_get_input_conversion = R"doc(Set up a conversion type required to setup the data properly for this decoder. The decoder itself will not implement the conversion and expects an external wrapper (e.g., fec.extended_decoder) to read this value and \"do the right
thing\" to format the data.


The default behavior is 'none', which means no conversion is required. Whatever the get_input_item_size() value returns, the input is expected to conform directly to this.


This may also return 'uchar', which indicates that the wrapper should convert the standard float samples to unsigned characters, either hard sliced or 8-bit soft symbols. See gr::fec::code::cc_decoder as an example decoder that uses this conversion format.


If 'packed_bits', the block expects the inputs to be packed hard bits. Each input item is a unsigned char where each of the 8-bits is a hard bit value.


The child class SHOULD implement this function. If not reimplemented, it returns \"none\".)doc";


static const char* __doc_gr_fec_generic_decoder_get_output_conversion = R"doc(Set up a conversion type required to understand the output style of this decoder. Generally, follow-on processing expects unpacked bits, so we specify the conversion type here to indicate what the wrapper (e.g., fec.extended_decoder) should do to convert the output samples from the decoder into unpacked bits.


The default behavior is 'none', which means no conversion is required. This should mean that the output data is produced from this decoder as unpacked bit.


If 'unpack', the block produces packed bytes that should be unpacked by the wrapper. See gr::fec::code::ccsds_decoder as an example of a decoder that produces packed bytes.


The child class SHOULD implement this function. If not reimplemented, it returns \"none\".)doc";


static const char* __doc_gr_fec_generic_decoder_set_frame_size = R"doc(Updates the size of a decoded frame.


The child class MUST implement this function and interpret how the  information affects the block's behavior. It should also provide bounds checks.)doc";


static const char* __doc_gr_fec_generic_decoder_get_iterations = R"doc(Get repetitions to decode.


The child class should implement this function and return the number of iterations required to decode.)doc";


static const char* __doc_gr_fec_get_decoder_output_size = R"doc()doc";


static const char* __doc_gr_fec_get_decoder_input_size = R"doc()doc";


static const char* __doc_gr_fec_get_shift = R"doc()doc";


static const char* __doc_gr_fec_get_history = R"doc()doc";


static const char* __doc_gr_fec_get_decoder_input_item_size = R"doc()doc";


static const char* __doc_gr_fec_get_decoder_output_item_size = R"doc()doc";


static const char* __doc_gr_fec_get_decoder_input_conversion = R"doc()doc";


static const char* __doc_gr_fec_get_decoder_output_conversion = R"doc()doc";
