/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_ofdm_sync_sc_cfb = R"doc(Schmidl & Cox synchronisation for OFDM.

Input: complex samples. Output 0: Fine frequency offset, scaled by the OFDM symbol duration. This is  in [1]. The normalized frequency offset is then 2.0*output0/fft_len. Output 1: Beginning of the first OFDM symbol after the first (doubled) OFDM symbol. The beginning is marked with a 1 (it's 0 everywhere else).


The evaluation of the coarse frequency offset is  done in this block. Also, the initial equalizer taps are not calculated here.


Note that we use a different normalization factor in the timing metric than the authors do in their original work[1]. If the timing metric (8) is    we calculate the normalization as    i.e., we estimate the energy from  half-symbols. This avoids spurious detects at the end of a burst, when the energy level suddenly drops.


[1] Schmidl, T.M. and Cox, D.C., \"Robust frequency and timing synchronization for
OFDM\", Communications, IEEE Transactions on, 1997.

Constructor Specific Documentation:



Args:
    fft_len : FFT length
    cp_len : Length of the guard interval (cyclic prefix) in samples
    use_even_carriers : If true, the carriers in the sync preamble are occupied such that the even carriers are used (0, 2, 4, ...). If you use all carriers, that would include the DC carrier, so be careful.
    threshold : detection threshold. Default is 0.9.)doc";


static const char* __doc_gr_digital_ofdm_sync_sc_cfb_ofdm_sync_sc_cfb_0 = R"doc()doc";


static const char* __doc_gr_digital_ofdm_sync_sc_cfb_ofdm_sync_sc_cfb_1 = R"doc()doc";


static const char* __doc_gr_digital_ofdm_sync_sc_cfb_make = R"doc(Schmidl & Cox synchronisation for OFDM.

Input: complex samples. Output 0: Fine frequency offset, scaled by the OFDM symbol duration. This is  in [1]. The normalized frequency offset is then 2.0*output0/fft_len. Output 1: Beginning of the first OFDM symbol after the first (doubled) OFDM symbol. The beginning is marked with a 1 (it's 0 everywhere else).


The evaluation of the coarse frequency offset is  done in this block. Also, the initial equalizer taps are not calculated here.


Note that we use a different normalization factor in the timing metric than the authors do in their original work[1]. If the timing metric (8) is    we calculate the normalization as    i.e., we estimate the energy from  half-symbols. This avoids spurious detects at the end of a burst, when the energy level suddenly drops.


[1] Schmidl, T.M. and Cox, D.C., \"Robust frequency and timing synchronization for
OFDM\", Communications, IEEE Transactions on, 1997.

Constructor Specific Documentation:



Args:
    fft_len : FFT length
    cp_len : Length of the guard interval (cyclic prefix) in samples
    use_even_carriers : If true, the carriers in the sync preamble are occupied such that the even carriers are used (0, 2, 4, ...). If you use all carriers, that would include the DC carrier, so be careful.
    threshold : detection threshold. Default is 0.9.)doc";


static const char* __doc_gr_digital_ofdm_sync_sc_cfb_set_threshold = R"doc()doc";


static const char* __doc_gr_digital_ofdm_sync_sc_cfb_threshold = R"doc()doc";
