/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_costas_loop_cc = R"doc(A Costas loop carrier recovery module.

The Costas loop locks to the center frequency of a signal and downconverts it to baseband.





More details can be found online:


J. Feigin, \"Practical Costas loop design: Designing a simple
and inexpensive BPSK Costas loop carrier recovery circuit,\" RF signal processing, pp. 20-36, 2002.





The Costas loop can have two output streams: 
There is a single optional message input:

Constructor Specific Documentation:

Make a Costas loop carrier recovery block.

Args:
    loop_bw : internal 2nd order loop bandwidth (~ 2pi/100)
    order : the loop order, either 2, 4, or 8
    use_snr : Use or ignore SNR estimates (from noise message port) in measurements; also uses tanh instead of slicing.)doc";


static const char* __doc_gr_digital_costas_loop_cc_costas_loop_cc_0 = R"doc()doc";


static const char* __doc_gr_digital_costas_loop_cc_costas_loop_cc_1 = R"doc()doc";


static const char* __doc_gr_digital_costas_loop_cc_make = R"doc(A Costas loop carrier recovery module.

The Costas loop locks to the center frequency of a signal and downconverts it to baseband.





More details can be found online:


J. Feigin, \"Practical Costas loop design: Designing a simple
and inexpensive BPSK Costas loop carrier recovery circuit,\" RF signal processing, pp. 20-36, 2002.





The Costas loop can have two output streams: 
There is a single optional message input:

Constructor Specific Documentation:

Make a Costas loop carrier recovery block.

Args:
    loop_bw : internal 2nd order loop bandwidth (~ 2pi/100)
    order : the loop order, either 2, 4, or 8
    use_snr : Use or ignore SNR estimates (from noise message port) in measurements; also uses tanh instead of slicing.)doc";


static const char* __doc_gr_digital_costas_loop_cc_error = R"doc(Returns the current value of the loop error.)doc";
