
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in TopoShapeWirePyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of TopoShapeWirePy
PyTypeObject TopoShapeWirePy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.TopoShape",     /*tp_name*/
    sizeof(TopoShapeWirePy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "TopoShapeWire is the OpenCasCade topological wire wrapper",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::TopoShapeWirePy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::TopoShapeWirePy::GetterSetter,                     /*tp_getset */
    &Part::TopoShapePy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::TopoShapeWirePy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of TopoShapeWirePy
PyMethodDef TopoShapeWirePy::Methods[] = {
    {"makeOffset",
        reinterpret_cast<PyCFunction>( staticCallback_makeOffset ),
        METH_VARARGS,
        "Offset the shape by a given amount. DEPRECATED - use makeOffset2D instead."
    },
    {"add",
        reinterpret_cast<PyCFunction>( staticCallback_add ),
        METH_VARARGS,
        "Add an edge to the wire\n"
        "add(edge)"
    },
    {"fixWire",
        reinterpret_cast<PyCFunction>( staticCallback_fixWire ),
        METH_VARARGS,
        "Fix wire\n"
        "fixWire([face, tolerance])\n"
        "--\n"
        "A face and a tolerance can optionally be supplied to the algorithm:"
    },
    {"makeHomogenousWires",
        reinterpret_cast<PyCFunction>( staticCallback_makeHomogenousWires ),
        METH_VARARGS,
        "Make this and the given wire homogeneous to have the same number of edges\n"
        "makeHomogenousWires(wire) -> Wire"
    },
    {"makePipe",
        reinterpret_cast<PyCFunction>( staticCallback_makePipe ),
        METH_VARARGS,
        "Make a pipe by sweeping along a wire.\n"
        "makePipe(profile) -> Shape"
    },
    {"makePipeShell",
        reinterpret_cast<PyCFunction>( staticCallback_makePipeShell ),
        METH_VARARGS,
        "Make a loft defined by a list of profiles along a wire.\n"
        "makePipeShell(shapeList,[isSolid=False,isFrenet=False,transition=0]) -> Shape\n"
        "--\n"
        "Transition can be 0 (default), 1 (right corners) or 2 (rounded corners)."
    },
    {"makeEvolved",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_makeEvolved )),
        METH_VARARGS|METH_KEYWORDS,
        "Profile along the spine"
    },
    {"approximate",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_approximate )),
        METH_VARARGS|METH_KEYWORDS,
        "Approximate B-Spline-curve from this wire\n"
        "approximate([Tol2d,Tol3d=1e-4,MaxSegments=10,MaxDegree=3]) -> BSpline"
    },
    {"discretize",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_discretize )),
        METH_VARARGS|METH_KEYWORDS,
        "Discretizes the wire and returns a list of points.\n"
        "discretize(kwargs) -> list\n"
        "--\n"
        "The function accepts keywords as argument:\n"
        "discretize(Number=n) => gives a list of 'n' equidistant points\n"
        "discretize(QuasiNumber=n) => gives a list of 'n' quasi equidistant points (is faster than the method above)\n"
        "discretize(Distance=d) => gives a list of equidistant points with distance 'd'\n"
        "discretize(Deflection=d) => gives a list of points with a maximum deflection 'd' to the wire\n"
        "discretize(QuasiDeflection=d) => gives a list of points with a maximum deflection 'd' to the wire (faster)\n"
        "discretize(Angular=a,Curvature=c,[Minimum=m]) => gives a list of points with an angular deflection of 'a'\n"
        "                                    and a curvature deflection of 'c'. Optionally a minimum number of points\n"
        "                                    can be set which by default is set to 2.\n"
        "\n"
        "Optionally you can set the keywords 'First' and 'Last' to define a sub-range of the parameter range\n"
        "of the wire.\n"
        "\n"
        "If no keyword is given then it depends on whether the argument is an int or float.\n"
        "If it's an int then the behaviour is as if using the keyword 'Number', if it's float\n"
        "then the behaviour is as if using the keyword 'Distance'.\n"
        "\n"
        "Example:\n"
        "\n"
        "import Part\n"
        "V=App.Vector\n"
        "\n"
        "e1=Part.makeCircle(5,V(0,0,0),V(0,0,1),0,180)\n"
        "e2=Part.makeCircle(5,V(10,0,0),V(0,0,1),180,360)\n"
        "w=Part.Wire([e1,e2])\n"
        "\n"
        "p=w.discretize(Number=50)\n"
        "s=Part.Compound([Part.Vertex(i) for i in p])\n"
        "Part.show(s)\n"
        "\n"
        "\n"
        "p=w.discretize(Angular=0.09,Curvature=0.01,Minimum=100)\n"
        "s=Part.Compound([Part.Vertex(i) for i in p])\n"
        "Part.show(s)"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of TopoShapeWirePy
PyGetSetDef TopoShapeWirePy::GetterSetter[] = {
    {"Mass",
        (getter) staticCallback_getMass,
        (setter) staticCallback_setMass,
        "Returns the mass of the current system.",
        nullptr
    },
    {"CenterOfMass",
        (getter) staticCallback_getCenterOfMass,
        (setter) staticCallback_setCenterOfMass,
        "Returns the center of mass of the current system.\n"
        "If the gravitational field is uniform, it is the center of gravity.\n"
        "The coordinates returned for the center of mass are expressed in the\n"
        "absolute Cartesian coordinate system.",
        nullptr
    },
    {"MatrixOfInertia",
        (getter) staticCallback_getMatrixOfInertia,
        (setter) staticCallback_setMatrixOfInertia,
        "Returns the matrix of inertia. It is a symmetrical matrix.\n"
        "The coefficients of the matrix are the quadratic moments of\n"
        "inertia.\n"
        "\n"
        " | Ixx Ixy Ixz 0 |\n"
        " | Ixy Iyy Iyz 0 |\n"
        " | Ixz Iyz Izz 0 |\n"
        " | 0   0   0   1 |\n"
        "\n"
        "The moments of inertia are denoted by Ixx, Iyy, Izz.\n"
        "The products of inertia are denoted by Ixy, Ixz, Iyz.\n"
        "The matrix of inertia is returned in the central coordinate\n"
        "system (G, Gx, Gy, Gz) where G is the centre of mass of the\n"
        "system and Gx, Gy, Gz the directions parallel to the X(1,0,0)\n"
        "Y(0,1,0) Z(0,0,1) directions of the absolute cartesian\n"
        "coordinate system.",
        nullptr
    },
    {"StaticMoments",
        (getter) staticCallback_getStaticMoments,
        (setter) staticCallback_setStaticMoments,
        "Returns Ix, Iy, Iz, the static moments of inertia of the\n"
        " current system; i.e. the moments of inertia about the\n"
        " three axes of the Cartesian coordinate system.",
        nullptr
    },
    {"PrincipalProperties",
        (getter) staticCallback_getPrincipalProperties,
        (setter) staticCallback_setPrincipalProperties,
        "Computes the principal properties of inertia of the current system.\n"
        " There is always a set of axes for which the products\n"
        " of inertia of a geometric system are equal to 0; i.e. the\n"
        " matrix of inertia of the system is diagonal. These axes\n"
        " are the principal axes of inertia. Their origin is\n"
        " coincident with the center of mass of the system. The\n"
        " associated moments are called the principal moments of inertia.\n"
        " This function computes the eigen values and the\n"
        " eigen vectors of the matrix of inertia of the system.",
        nullptr
    },
    {"OrderedEdges",
        (getter) staticCallback_getOrderedEdges,
        (setter) staticCallback_setOrderedEdges,
        "List of ordered edges in this shape.",
        nullptr
    },
    {"Continuity",
        (getter) staticCallback_getContinuity,
        (setter) staticCallback_setContinuity,
        "Returns the continuity",
        nullptr
    },
    {"OrderedVertexes",
        (getter) staticCallback_getOrderedVertexes,
        (setter) staticCallback_setOrderedVertexes,
        "List of ordered vertexes in this shape.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// makeOffset() callback and implementer
// PyObject*  TopoShapeWirePy::makeOffset(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_makeOffset (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeOffset' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeWirePy*>(self)->makeOffset(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// add() callback and implementer
// PyObject*  TopoShapeWirePy::add(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_add (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'add' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeWirePy*>(self)->add(args);
        if (ret != nullptr)
            static_cast<TopoShapeWirePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// fixWire() callback and implementer
// PyObject*  TopoShapeWirePy::fixWire(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_fixWire (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'fixWire' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeWirePy*>(self)->fixWire(args);
        if (ret != nullptr)
            static_cast<TopoShapeWirePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeHomogenousWires() callback and implementer
// PyObject*  TopoShapeWirePy::makeHomogenousWires(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_makeHomogenousWires (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeHomogenousWires' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeWirePy*>(self)->makeHomogenousWires(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makePipe() callback and implementer
// PyObject*  TopoShapeWirePy::makePipe(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_makePipe (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makePipe' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeWirePy*>(self)->makePipe(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makePipeShell() callback and implementer
// PyObject*  TopoShapeWirePy::makePipeShell(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_makePipeShell (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makePipeShell' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeWirePy*>(self)->makePipeShell(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeEvolved() callback and implementer
// PyObject*  TopoShapeWirePy::makeEvolved(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_makeEvolved (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeEvolved' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeWirePy*>(self)->makeEvolved(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// approximate() callback and implementer
// PyObject*  TopoShapeWirePy::approximate(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_approximate (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'approximate' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeWirePy*>(self)->approximate(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// discretize() callback and implementer
// PyObject*  TopoShapeWirePy::discretize(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_discretize (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'discretize' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeWirePy*>(self)->discretize(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Mass() callback and implementer
// PyObject*  TopoShapeWirePy::Mass(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_getMass (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeWirePy*>(self)->getMass());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Mass' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeWirePy::staticCallback_setMass (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Mass' of object 'TopoShape' is read-only");
    return -1;
}

// CenterOfMass() callback and implementer
// PyObject*  TopoShapeWirePy::CenterOfMass(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_getCenterOfMass (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeWirePy*>(self)->getCenterOfMass());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'CenterOfMass' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeWirePy::staticCallback_setCenterOfMass (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'CenterOfMass' of object 'TopoShape' is read-only");
    return -1;
}

// MatrixOfInertia() callback and implementer
// PyObject*  TopoShapeWirePy::MatrixOfInertia(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_getMatrixOfInertia (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeWirePy*>(self)->getMatrixOfInertia());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MatrixOfInertia' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeWirePy::staticCallback_setMatrixOfInertia (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'MatrixOfInertia' of object 'TopoShape' is read-only");
    return -1;
}

// StaticMoments() callback and implementer
// PyObject*  TopoShapeWirePy::StaticMoments(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_getStaticMoments (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeWirePy*>(self)->getStaticMoments());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'StaticMoments' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeWirePy::staticCallback_setStaticMoments (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'StaticMoments' of object 'TopoShape' is read-only");
    return -1;
}

// PrincipalProperties() callback and implementer
// PyObject*  TopoShapeWirePy::PrincipalProperties(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_getPrincipalProperties (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeWirePy*>(self)->getPrincipalProperties());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'PrincipalProperties' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeWirePy::staticCallback_setPrincipalProperties (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'PrincipalProperties' of object 'TopoShape' is read-only");
    return -1;
}

// OrderedEdges() callback and implementer
// PyObject*  TopoShapeWirePy::OrderedEdges(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_getOrderedEdges (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeWirePy*>(self)->getOrderedEdges());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'OrderedEdges' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeWirePy::staticCallback_setOrderedEdges (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'OrderedEdges' of object 'TopoShape' is read-only");
    return -1;
}

// Continuity() callback and implementer
// PyObject*  TopoShapeWirePy::Continuity(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_getContinuity (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeWirePy*>(self)->getContinuity());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Continuity' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeWirePy::staticCallback_setContinuity (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Continuity' of object 'TopoShape' is read-only");
    return -1;
}

// OrderedVertexes() callback and implementer
// PyObject*  TopoShapeWirePy::OrderedVertexes(PyObject *args){};
// has to be implemented in TopoShapeWirePyImp.cpp
PyObject * TopoShapeWirePy::staticCallback_getOrderedVertexes (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeWirePy*>(self)->getOrderedVertexes());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'OrderedVertexes' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeWirePy::staticCallback_setOrderedVertexes (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'OrderedVertexes' of object 'TopoShape' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
TopoShapeWirePy::TopoShapeWirePy(TopoShape *pcObject, PyTypeObject *T)
    : TopoShapePy(static_cast<TopoShapePy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
TopoShapeWirePy::~TopoShapeWirePy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// TopoShapeWirePy representation
//--------------------------------------------------------------------------
PyObject *TopoShapeWirePy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// TopoShapeWirePy Attributes
//--------------------------------------------------------------------------
PyObject *TopoShapeWirePy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return TopoShapePy::_getattr(attr);
}

int TopoShapeWirePy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return TopoShapePy::_setattr(attr, value);
}

TopoShape *TopoShapeWirePy::getTopoShapePtr() const
{
    return static_cast<TopoShape *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in TopoShapeWirePyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *TopoShapeWirePy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of TopoShapeWirePy and the Twin object
    return new TopoShapeWirePy(new TopoShape);
}

// constructor method
int TopoShapeWirePy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string TopoShapeWirePy::representation() const
{
    return {"<TopoShape object>"};
}

PyObject* TopoShapeWirePy::makeOffset(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeWirePy::add(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeWirePy::fixWire(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeWirePy::makeHomogenousWires(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeWirePy::makePipe(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeWirePy::makePipeShell(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeWirePy::makeEvolved(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeWirePy::approximate(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeWirePy::discretize(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Object TopoShapeWirePy::getMass() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeWirePy::getCenterOfMass() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeWirePy::getMatrixOfInertia() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeWirePy::getStaticMoments() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Dict TopoShapeWirePy::getPrincipalProperties() const
{
    //return Py::Dict();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapeWirePy::getOrderedEdges() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::String TopoShapeWirePy::getContinuity() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::List TopoShapeWirePy::getOrderedVertexes() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *TopoShapeWirePy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int TopoShapeWirePy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



