
/* Automatically generated struct definitions for the Data API.
 * Do not edit manually, changes will be overwritten.           */

#define RNA_RUNTIME

#include <float.h>
#include <stdio.h>
#include <limits.h>
#include <limits>
#include <string.h>

#include <stddef.h>

#include <algorithm>

#include "MEM_guardedalloc.h"

#include "DNA_ID.h"
#include "DNA_scene_types.h"
#include "DNA_node_types.h"
#include "BLI_fileops.h"

#include "BLI_listbase.h"

#include "BLI_path_utils.hh"

#include "BLI_rect.h"

#include "BLI_string.h"

#include "BLI_string_utf8.h"

#include "BLI_utildefines.h"

#include "BKE_context.hh"
#include "BKE_lib_id.hh"
#include "BKE_main.hh"
#include "BKE_report.hh"
#include "RNA_define.hh"
#include "RNA_types.hh"
#include "rna_internal.hh"

#include "rna_prototypes_gen.hh"

#include "rna_mask.cc"

#pragma GCC diagnostic ignored "-Wunused-parameter"

/* Auto-generated Functions. */


extern PropertyRNA &rna_MaskParent_rna_properties;
extern PropertyRNA &rna_MaskParent_rna_type;
extern PropertyRNA &rna_MaskParent_id;
extern PropertyRNA &rna_MaskParent_id_type;
extern PropertyRNA &rna_MaskParent_type;
extern PropertyRNA &rna_MaskParent_parent;
extern PropertyRNA &rna_MaskParent_sub_parent;


extern PropertyRNA &rna_MaskSplinePointUW_rna_properties;
extern PropertyRNA &rna_MaskSplinePointUW_rna_type;
extern PropertyRNA &rna_MaskSplinePointUW_u;
extern PropertyRNA &rna_MaskSplinePointUW_weight;
extern PropertyRNA &rna_MaskSplinePointUW_select;


extern PropertyRNA &rna_MaskSplinePoint_rna_properties;
extern PropertyRNA &rna_MaskSplinePoint_rna_type;
extern PropertyRNA &rna_MaskSplinePoint_handle_left;
extern PropertyRNA &rna_MaskSplinePoint_co;
extern PropertyRNA &rna_MaskSplinePoint_handle_right;
extern PropertyRNA &rna_MaskSplinePoint_handle_type;
extern PropertyRNA &rna_MaskSplinePoint_handle_left_type;
extern PropertyRNA &rna_MaskSplinePoint_handle_right_type;
extern PropertyRNA &rna_MaskSplinePoint_weight;
extern PropertyRNA &rna_MaskSplinePoint_select;
extern PropertyRNA &rna_MaskSplinePoint_select_left_handle;
extern PropertyRNA &rna_MaskSplinePoint_select_control_point;
extern PropertyRNA &rna_MaskSplinePoint_select_right_handle;
extern PropertyRNA &rna_MaskSplinePoint_select_single_handle;
extern PropertyRNA &rna_MaskSplinePoint_parent;
extern PropertyRNA &rna_MaskSplinePoint_feather_points;


extern PropertyRNA &rna_MaskSpline_rna_properties;
extern PropertyRNA &rna_MaskSpline_rna_type;
extern PropertyRNA &rna_MaskSpline_offset_mode;
extern PropertyRNA &rna_MaskSpline_weight_interpolation;
extern PropertyRNA &rna_MaskSpline_use_cyclic;
extern PropertyRNA &rna_MaskSpline_use_fill;
extern PropertyRNA &rna_MaskSpline_use_self_intersection_check;
extern PropertyRNA &rna_MaskSpline_points;


extern PropertyRNA &rna_MaskSplines_rna_properties;
extern PropertyRNA &rna_MaskSplines_rna_type;
extern PropertyRNA &rna_MaskSplines_active;
extern PropertyRNA &rna_MaskSplines_active_point;

extern FunctionRNA rna_MaskSplines_new_func;
extern PropertyRNA &rna_MaskSplines_new_spline;

extern FunctionRNA rna_MaskSplines_remove_func;
extern PropertyRNA &rna_MaskSplines_remove_spline;



extern PropertyRNA &rna_MaskSplinePoints_rna_properties;
extern PropertyRNA &rna_MaskSplinePoints_rna_type;

extern FunctionRNA rna_MaskSplinePoints_add_func;
extern PropertyRNA &rna_MaskSplinePoints_add_count;

extern FunctionRNA rna_MaskSplinePoints_remove_func;
extern PropertyRNA &rna_MaskSplinePoints_remove_point;



extern PropertyRNA &rna_MaskLayer_rna_properties;
extern PropertyRNA &rna_MaskLayer_rna_type;
extern PropertyRNA &rna_MaskLayer_name;
extern PropertyRNA &rna_MaskLayer_splines;
extern PropertyRNA &rna_MaskLayer_hide;
extern PropertyRNA &rna_MaskLayer_hide_select;
extern PropertyRNA &rna_MaskLayer_hide_render;
extern PropertyRNA &rna_MaskLayer_select;
extern PropertyRNA &rna_MaskLayer_alpha;
extern PropertyRNA &rna_MaskLayer_blend;
extern PropertyRNA &rna_MaskLayer_invert;
extern PropertyRNA &rna_MaskLayer_falloff;
extern PropertyRNA &rna_MaskLayer_use_fill_holes;
extern PropertyRNA &rna_MaskLayer_use_fill_overlap;


extern PropertyRNA &rna_ID_rna_properties;
extern PropertyRNA &rna_ID_rna_type;
extern PropertyRNA &rna_ID_name;
extern PropertyRNA &rna_ID_name_full;
extern PropertyRNA &rna_ID_id_type;
extern PropertyRNA &rna_ID_session_uid;
extern PropertyRNA &rna_ID_is_evaluated;
extern PropertyRNA &rna_ID_original;
extern PropertyRNA &rna_ID_users;
extern PropertyRNA &rna_ID_use_fake_user;
extern PropertyRNA &rna_ID_use_extra_user;
extern PropertyRNA &rna_ID_is_embedded_data;
extern PropertyRNA &rna_ID_is_linked_packed;
extern PropertyRNA &rna_ID_is_missing;
extern PropertyRNA &rna_ID_is_runtime_data;
extern PropertyRNA &rna_ID_is_editable;
extern PropertyRNA &rna_ID_tag;
extern PropertyRNA &rna_ID_is_library_indirect;
extern PropertyRNA &rna_ID_library;
extern PropertyRNA &rna_ID_library_weak_reference;
extern PropertyRNA &rna_ID_asset_data;
extern PropertyRNA &rna_ID_override_library;
extern PropertyRNA &rna_ID_preview;

extern PropertyRNA &rna_Mask_layers;
extern PropertyRNA &rna_Mask_active_layer_index;
extern PropertyRNA &rna_Mask_frame_start;
extern PropertyRNA &rna_Mask_frame_end;
extern PropertyRNA &rna_Mask_animation_data;

extern FunctionRNA rna_ID_bl_system_properties_get_func;
extern PropertyRNA &rna_ID_bl_system_properties_get_do_create;
extern PropertyRNA &rna_ID_bl_system_properties_get_system_properties;

extern FunctionRNA rna_ID_rename_func;
extern PropertyRNA &rna_ID_rename_name;
extern PropertyRNA &rna_ID_rename_mode;
extern PropertyRNA &rna_ID_rename_id_rename_result;

extern FunctionRNA rna_ID_evaluated_get_func;
extern PropertyRNA &rna_ID_evaluated_get_depsgraph;
extern PropertyRNA &rna_ID_evaluated_get_id;

extern FunctionRNA rna_ID_copy_func;
extern PropertyRNA &rna_ID_copy_id;

extern FunctionRNA rna_ID_asset_mark_func;
extern FunctionRNA rna_ID_asset_clear_func;
extern FunctionRNA rna_ID_asset_generate_preview_func;
extern FunctionRNA rna_ID_override_create_func;
extern PropertyRNA &rna_ID_override_create_id;
extern PropertyRNA &rna_ID_override_create_remap_local_usages;

extern FunctionRNA rna_ID_override_hierarchy_create_func;
extern PropertyRNA &rna_ID_override_hierarchy_create_id;
extern PropertyRNA &rna_ID_override_hierarchy_create_scene;
extern PropertyRNA &rna_ID_override_hierarchy_create_view_layer;
extern PropertyRNA &rna_ID_override_hierarchy_create_reference;
extern PropertyRNA &rna_ID_override_hierarchy_create_do_fully_editable;

extern FunctionRNA rna_ID_user_clear_func;
extern FunctionRNA rna_ID_user_remap_func;
extern PropertyRNA &rna_ID_user_remap_new_id;

extern FunctionRNA rna_ID_make_local_func;
extern PropertyRNA &rna_ID_make_local_clear_proxy;
extern PropertyRNA &rna_ID_make_local_clear_liboverride;
extern PropertyRNA &rna_ID_make_local_clear_asset_data;
extern PropertyRNA &rna_ID_make_local_id;

extern FunctionRNA rna_ID_user_of_id_func;
extern PropertyRNA &rna_ID_user_of_id_id;
extern PropertyRNA &rna_ID_user_of_id_count;

extern FunctionRNA rna_ID_animation_data_create_func;
extern PropertyRNA &rna_ID_animation_data_create_anim_data;

extern FunctionRNA rna_ID_animation_data_clear_func;
extern FunctionRNA rna_ID_update_tag_func;
extern PropertyRNA &rna_ID_update_tag_refresh;

extern FunctionRNA rna_ID_preview_ensure_func;
extern PropertyRNA &rna_ID_preview_ensure_preview_image;



extern PropertyRNA &rna_MaskLayers_rna_properties;
extern PropertyRNA &rna_MaskLayers_rna_type;
extern PropertyRNA &rna_MaskLayers_active;

extern FunctionRNA rna_MaskLayers_new_func;
extern PropertyRNA &rna_MaskLayers_new_name;
extern PropertyRNA &rna_MaskLayers_new_layer;

extern FunctionRNA rna_MaskLayers_remove_func;
extern PropertyRNA &rna_MaskLayers_remove_layer;

extern FunctionRNA rna_MaskLayers_clear_func;

static PointerRNA MaskParent_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MaskParent_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskParent_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MaskParent_rna_properties_get(iter);
    }
}

extern void MaskParent_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskParent_rna_properties_get(iter);
    }
}

extern void MaskParent_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MaskParent_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MaskParent_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern PointerRNA MaskParent_id_get(PointerRNA *ptr)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_ID, data->id);
}

extern void MaskParent_id_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    if (value.data && ptr->owner_id && value.owner_id && !BKE_id_can_use_id(*ptr->owner_id, *value.owner_id)) {
      return;
    }
    if (value.data) {
        id_lib_extern((ID *)value.data);
    }
    *(void **)&data->id = value.data;
}

extern int MaskParent_id_type_get(PointerRNA *ptr)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    return (int)(data->id_type);
}

extern void MaskParent_id_type_set(PointerRNA *ptr, int value)
{
    PropEnumSetFunc fn = rna_MaskParent_id_type_set;
    fn(ptr, value);
}

extern int MaskParent_type_get(PointerRNA *ptr)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    return (int)(data->type);
}

extern void MaskParent_type_set(PointerRNA *ptr, int value)
{
    MaskParent *data = (MaskParent *)(ptr->data);
#ifdef __cplusplus
    data->type = (std::remove_reference_t<decltype(data->type)>)value;
#else
    data->type = value;
#endif
}

extern void MaskParent_parent_get(PointerRNA *ptr, char *value)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    strcpy(value, data->parent);
}

extern int MaskParent_parent_length(PointerRNA *ptr)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    return strlen(data->parent);
}

extern void MaskParent_parent_set(PointerRNA *ptr, const char *value)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    BLI_strncpy_utf8(data->parent, value, 256);
}

extern void MaskParent_sub_parent_get(PointerRNA *ptr, char *value)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    strcpy(value, data->sub_parent);
}

extern int MaskParent_sub_parent_length(PointerRNA *ptr)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    return strlen(data->sub_parent);
}

extern void MaskParent_sub_parent_set(PointerRNA *ptr, const char *value)
{
    MaskParent *data = (MaskParent *)(ptr->data);
    BLI_strncpy_utf8(data->sub_parent, value, 256);
}

static PointerRNA MaskSplinePointUW_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MaskSplinePointUW_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskSplinePointUW_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MaskSplinePointUW_rna_properties_get(iter);
    }
}

extern void MaskSplinePointUW_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskSplinePointUW_rna_properties_get(iter);
    }
}

extern void MaskSplinePointUW_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MaskSplinePointUW_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MaskSplinePointUW_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern float MaskSplinePointUW_u_get(PointerRNA *ptr)
{
    MaskSplinePointUW *data = (MaskSplinePointUW *)(ptr->data);
    return (float)(data->u);
}

extern void MaskSplinePointUW_u_set(PointerRNA *ptr, float value)
{
    MaskSplinePointUW *data = (MaskSplinePointUW *)(ptr->data);
#ifdef __cplusplus
    data->u = (std::remove_reference_t<decltype(data->u)>)std::clamp(value, 0.0f, 1.0f);
#else
    data->u = std::clamp(value, 0.0f, 1.0f);
#endif
}

extern float MaskSplinePointUW_weight_get(PointerRNA *ptr)
{
    MaskSplinePointUW *data = (MaskSplinePointUW *)(ptr->data);
    return (float)(data->w);
}

extern void MaskSplinePointUW_weight_set(PointerRNA *ptr, float value)
{
    MaskSplinePointUW *data = (MaskSplinePointUW *)(ptr->data);
#ifdef __cplusplus
    data->w = (std::remove_reference_t<decltype(data->w)>)std::clamp(value, 0.0f, 1.0f);
#else
    data->w = std::clamp(value, 0.0f, 1.0f);
#endif
}

extern bool MaskSplinePointUW_select_get(PointerRNA *ptr)
{
    MaskSplinePointUW *data = (MaskSplinePointUW *)(ptr->data);
    return (((data->flag) & 1) != 0);
}

extern void MaskSplinePointUW_select_set(PointerRNA *ptr, bool value)
{
    MaskSplinePointUW *data = (MaskSplinePointUW *)(ptr->data);
    if (value) { data->flag |= 1; }
    else { data->flag &= ~1; }
}

static PointerRNA MaskSplinePoint_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MaskSplinePoint_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskSplinePoint_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MaskSplinePoint_rna_properties_get(iter);
    }
}

extern void MaskSplinePoint_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskSplinePoint_rna_properties_get(iter);
    }
}

extern void MaskSplinePoint_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MaskSplinePoint_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MaskSplinePoint_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void MaskSplinePoint_handle_left_get(PointerRNA *ptr, float values[2])
{
    PropFloatArrayGetFunc fn = rna_MaskSplinePoint_handle1_get;
    fn(ptr, values);
}

extern void MaskSplinePoint_handle_left_set(PointerRNA *ptr, const float values[2])
{
    PropFloatArraySetFunc fn = rna_MaskSplinePoint_handle1_set;
    fn(ptr, values);
}

extern void MaskSplinePoint_co_get(PointerRNA *ptr, float values[2])
{
    PropFloatArrayGetFunc fn = rna_MaskSplinePoint_ctrlpoint_get;
    fn(ptr, values);
}

extern void MaskSplinePoint_co_set(PointerRNA *ptr, const float values[2])
{
    PropFloatArraySetFunc fn = rna_MaskSplinePoint_ctrlpoint_set;
    fn(ptr, values);
}

extern void MaskSplinePoint_handle_right_get(PointerRNA *ptr, float values[2])
{
    PropFloatArrayGetFunc fn = rna_MaskSplinePoint_handle2_get;
    fn(ptr, values);
}

extern void MaskSplinePoint_handle_right_set(PointerRNA *ptr, const float values[2])
{
    PropFloatArraySetFunc fn = rna_MaskSplinePoint_handle2_set;
    fn(ptr, values);
}

extern int MaskSplinePoint_handle_type_get(PointerRNA *ptr)
{
    PropEnumGetFunc fn = rna_MaskSplinePoint_handle_type_get;
    return fn(ptr);
}

extern void MaskSplinePoint_handle_type_set(PointerRNA *ptr, int value)
{
    PropEnumSetFunc fn = rna_MaskSplinePoint_handle_type_set;
    fn(ptr, value);
}

extern int MaskSplinePoint_handle_left_type_get(PointerRNA *ptr)
{
    PropEnumGetFunc fn = rna_MaskSplinePoint_handle_left_type_get;
    return fn(ptr);
}

extern void MaskSplinePoint_handle_left_type_set(PointerRNA *ptr, int value)
{
    PropEnumSetFunc fn = rna_MaskSplinePoint_handle_left_type_set;
    fn(ptr, value);
}

extern int MaskSplinePoint_handle_right_type_get(PointerRNA *ptr)
{
    PropEnumGetFunc fn = rna_MaskSplinePoint_handle_right_type_get;
    return fn(ptr);
}

extern void MaskSplinePoint_handle_right_type_set(PointerRNA *ptr, int value)
{
    PropEnumSetFunc fn = rna_MaskSplinePoint_handle_right_type_set;
    fn(ptr, value);
}

extern float MaskSplinePoint_weight_get(PointerRNA *ptr)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    return (float)(data->bezt.weight);
}

extern void MaskSplinePoint_weight_set(PointerRNA *ptr, float value)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
#ifdef __cplusplus
    data->bezt.weight = (std::remove_reference_t<decltype(data->bezt.weight)>)std::clamp(value, 0.0f, 1.0f);
#else
    data->bezt.weight = std::clamp(value, 0.0f, 1.0f);
#endif
}

extern bool MaskSplinePoint_select_get(PointerRNA *ptr)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    return (((data->bezt.f2) & 1) != 0);
}

extern void MaskSplinePoint_select_set(PointerRNA *ptr, bool value)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    if (value) { data->bezt.f2 |= 1; }
    else { data->bezt.f2 &= ~1; }
}

extern bool MaskSplinePoint_select_left_handle_get(PointerRNA *ptr)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    return (((data->bezt.f1) & 1) != 0);
}

extern void MaskSplinePoint_select_left_handle_set(PointerRNA *ptr, bool value)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    if (value) { data->bezt.f1 |= 1; }
    else { data->bezt.f1 &= ~1; }
}

extern bool MaskSplinePoint_select_control_point_get(PointerRNA *ptr)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    return (((data->bezt.f2) & 1) != 0);
}

extern void MaskSplinePoint_select_control_point_set(PointerRNA *ptr, bool value)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    if (value) { data->bezt.f2 |= 1; }
    else { data->bezt.f2 &= ~1; }
}

extern bool MaskSplinePoint_select_right_handle_get(PointerRNA *ptr)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    return (((data->bezt.f3) & 1) != 0);
}

extern void MaskSplinePoint_select_right_handle_set(PointerRNA *ptr, bool value)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    if (value) { data->bezt.f3 |= 1; }
    else { data->bezt.f3 &= ~1; }
}

extern bool MaskSplinePoint_select_single_handle_get(PointerRNA *ptr)
{
    PropBooleanGetFunc fn = rna_MaskSplinePoint_handle_single_select_get;
    return fn(ptr);
}

extern void MaskSplinePoint_select_single_handle_set(PointerRNA *ptr, bool value)
{
    PropBooleanSetFunc fn = rna_MaskSplinePoint_handle_single_select_set;
    fn(ptr, value);
}

extern PointerRNA MaskSplinePoint_parent_get(PointerRNA *ptr)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_MaskParent, &data->parent);
}

extern int MaskSplinePoint_feather_points_length(PointerRNA *ptr)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);
    return (data->uw == nullptr) ? 0 : data->tot_uw;
}

static PointerRNA MaskSplinePoint_feather_points_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_MaskSplinePointUW, rna_iterator_array_get(iter));
}

extern void MaskSplinePoint_feather_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    MaskSplinePoint *data = (MaskSplinePoint *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskSplinePoint_feather_points;

    rna_iterator_array_begin(iter, ptr, data->uw, sizeof(data->uw[0]), data->tot_uw, 0, nullptr);

    if (iter->valid) {
        iter->ptr = MaskSplinePoint_feather_points_get(iter);
    }
}

extern void MaskSplinePoint_feather_points_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_array_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskSplinePoint_feather_points_get(iter);
    }
}

extern void MaskSplinePoint_feather_points_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_array_end;
    fn(iter);
}

extern bool MaskSplinePoint_feather_points_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    MaskSplinePoint_feather_points_begin(&iter, ptr);

    if (iter.valid) {
        ArrayIterator *internal = &iter.internal.array;
        if (index < 0 || index >= internal->length) {
#ifdef __GNUC__
            printf("Array iterator out of range: %s (index %d)\n", __func__, index);
#else
            printf("Array iterator out of range: (index %d)\n", index);
#endif
        }
        else if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_array_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            internal->ptr += internal->itemsize * index;
            found = 1;
        }
        if (found) { *r_ptr = MaskSplinePoint_feather_points_get(&iter); }
    }

    MaskSplinePoint_feather_points_end(&iter);

    return found;
}

static PointerRNA MaskSpline_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MaskSpline_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskSpline_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MaskSpline_rna_properties_get(iter);
    }
}

extern void MaskSpline_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskSpline_rna_properties_get(iter);
    }
}

extern void MaskSpline_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MaskSpline_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MaskSpline_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int MaskSpline_offset_mode_get(PointerRNA *ptr)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
    return (int)(data->offset_mode);
}

extern void MaskSpline_offset_mode_set(PointerRNA *ptr, int value)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
#ifdef __cplusplus
    data->offset_mode = (std::remove_reference_t<decltype(data->offset_mode)>)value;
#else
    data->offset_mode = value;
#endif
}

extern int MaskSpline_weight_interpolation_get(PointerRNA *ptr)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
    return (int)(data->weight_interp);
}

extern void MaskSpline_weight_interpolation_set(PointerRNA *ptr, int value)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
#ifdef __cplusplus
    data->weight_interp = (std::remove_reference_t<decltype(data->weight_interp)>)value;
#else
    data->weight_interp = value;
#endif
}

extern bool MaskSpline_use_cyclic_get(PointerRNA *ptr)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
    return (((data->flag) & 2) != 0);
}

extern void MaskSpline_use_cyclic_set(PointerRNA *ptr, bool value)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
    if (value) { data->flag |= 2; }
    else { data->flag &= ~2; }
}

extern bool MaskSpline_use_fill_get(PointerRNA *ptr)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
    return !(((data->flag) & 4) != 0);
}

extern void MaskSpline_use_fill_set(PointerRNA *ptr, bool value)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
    if (!value) { data->flag |= 4; }
    else { data->flag &= ~4; }
}

extern bool MaskSpline_use_self_intersection_check_get(PointerRNA *ptr)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
    return (((data->flag) & 8) != 0);
}

extern void MaskSpline_use_self_intersection_check_set(PointerRNA *ptr, bool value)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
    if (value) { data->flag |= 8; }
    else { data->flag &= ~8; }
}

extern int MaskSpline_points_length(PointerRNA *ptr)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);
    return (data->points == nullptr) ? 0 : data->tot_point;
}

static PointerRNA MaskSpline_points_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_MaskSplinePoint, rna_iterator_array_get(iter));
}

extern void MaskSpline_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    MaskSpline *data = (MaskSpline *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskSpline_points;

    rna_iterator_array_begin(iter, ptr, data->points, sizeof(data->points[0]), data->tot_point, 0, nullptr);

    if (iter->valid) {
        iter->ptr = MaskSpline_points_get(iter);
    }
}

extern void MaskSpline_points_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_array_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskSpline_points_get(iter);
    }
}

extern void MaskSpline_points_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_array_end;
    fn(iter);
}

extern bool MaskSpline_points_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    MaskSpline_points_begin(&iter, ptr);

    if (iter.valid) {
        ArrayIterator *internal = &iter.internal.array;
        if (index < 0 || index >= internal->length) {
#ifdef __GNUC__
            printf("Array iterator out of range: %s (index %d)\n", __func__, index);
#else
            printf("Array iterator out of range: (index %d)\n", index);
#endif
        }
        else if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_array_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            internal->ptr += internal->itemsize * index;
            found = 1;
        }
        if (found) { *r_ptr = MaskSpline_points_get(&iter); }
    }

    MaskSpline_points_end(&iter);

    return found;
}

static PointerRNA MaskSplines_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MaskSplines_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskSplines_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MaskSplines_rna_properties_get(iter);
    }
}

extern void MaskSplines_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskSplines_rna_properties_get(iter);
    }
}

extern void MaskSplines_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MaskSplines_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MaskSplines_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern PointerRNA MaskSplines_active_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_MaskLayer_active_spline_get;
    return fn(ptr);
}

extern void MaskSplines_active_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    PropPointerSetFunc fn = rna_MaskLayer_active_spline_set;
    fn(ptr, value, reports);
}

extern PointerRNA MaskSplines_active_point_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_MaskLayer_active_spline_point_get;
    return fn(ptr);
}

extern void MaskSplines_active_point_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    PropPointerSetFunc fn = rna_MaskLayer_active_spline_point_set;
    fn(ptr, value, reports);
}

static PointerRNA MaskSplinePoints_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MaskSplinePoints_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskSplinePoints_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MaskSplinePoints_rna_properties_get(iter);
    }
}

extern void MaskSplinePoints_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskSplinePoints_rna_properties_get(iter);
    }
}

extern void MaskSplinePoints_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MaskSplinePoints_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MaskSplinePoints_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

static PointerRNA MaskLayer_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MaskLayer_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskLayer_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MaskLayer_rna_properties_get(iter);
    }
}

extern void MaskLayer_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskLayer_rna_properties_get(iter);
    }
}

extern void MaskLayer_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MaskLayer_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MaskLayer_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void MaskLayer_name_get(PointerRNA *ptr, char *value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    strcpy(value, data->name);
}

extern int MaskLayer_name_length(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return strlen(data->name);
}

extern void MaskLayer_name_set(PointerRNA *ptr, const char *value)
{
    PropStringSetFunc fn = rna_MaskLayer_name_set;
    fn(ptr, value);
}

static PointerRNA MaskLayer_splines_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_MaskSpline, rna_iterator_listbase_get(iter));
}

extern void MaskLayer_splines_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskLayer_splines;

    PropCollectionBeginFunc fn = rna_MaskLayer_splines_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MaskLayer_splines_get(iter);
    }
}

extern void MaskLayer_splines_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_listbase_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskLayer_splines_get(iter);
    }
}

extern void MaskLayer_splines_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MaskLayer_splines_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    MaskLayer_splines_begin(&iter, ptr);

    if (iter.valid) {
        ListBaseIterator *internal = &iter.internal.listbase;
        if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_listbase_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            while (index-- > 0 && internal->link) {
                internal->link = internal->link->next;
            }
            found = (index == -1 && internal->link);
        }
        if (found) { *r_ptr = MaskLayer_splines_get(&iter); }
    }

    MaskLayer_splines_end(&iter);

    return found;
}

extern bool MaskLayer_hide_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return (((data->visibility_flag) & 1) != 0);
}

extern void MaskLayer_hide_set(PointerRNA *ptr, bool value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    if (value) { data->visibility_flag |= 1; }
    else { data->visibility_flag &= ~1; }
}

extern bool MaskLayer_hide_select_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return (((data->visibility_flag) & 2) != 0);
}

extern void MaskLayer_hide_select_set(PointerRNA *ptr, bool value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    if (value) { data->visibility_flag |= 2; }
    else { data->visibility_flag &= ~2; }
}

extern bool MaskLayer_hide_render_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return (((data->visibility_flag) & 4) != 0);
}

extern void MaskLayer_hide_render_set(PointerRNA *ptr, bool value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    if (value) { data->visibility_flag |= 4; }
    else { data->visibility_flag &= ~4; }
}

extern bool MaskLayer_select_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return (((data->flag) & 32) != 0);
}

extern void MaskLayer_select_set(PointerRNA *ptr, bool value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    if (value) { data->flag |= 32; }
    else { data->flag &= ~32; }
}

extern float MaskLayer_alpha_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return (float)(data->alpha);
}

extern void MaskLayer_alpha_set(PointerRNA *ptr, float value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
#ifdef __cplusplus
    data->alpha = (std::remove_reference_t<decltype(data->alpha)>)value;
#else
    data->alpha = value;
#endif
}

extern int MaskLayer_blend_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return (int)(data->blend);
}

extern void MaskLayer_blend_set(PointerRNA *ptr, int value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
#ifdef __cplusplus
    data->blend = (std::remove_reference_t<decltype(data->blend)>)value;
#else
    data->blend = value;
#endif
}

extern bool MaskLayer_invert_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return (((data->blend_flag) & 1) != 0);
}

extern void MaskLayer_invert_set(PointerRNA *ptr, bool value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    if (value) { data->blend_flag |= 1; }
    else { data->blend_flag &= ~1; }
}

extern int MaskLayer_falloff_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return (int)(data->falloff);
}

extern void MaskLayer_falloff_set(PointerRNA *ptr, int value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
#ifdef __cplusplus
    data->falloff = (std::remove_reference_t<decltype(data->falloff)>)value;
#else
    data->falloff = value;
#endif
}

extern bool MaskLayer_use_fill_holes_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return !(((data->flag) & 64) != 0);
}

extern void MaskLayer_use_fill_holes_set(PointerRNA *ptr, bool value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    if (!value) { data->flag |= 64; }
    else { data->flag &= ~64; }
}

extern bool MaskLayer_use_fill_overlap_get(PointerRNA *ptr)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    return (((data->flag) & 128) != 0);
}

extern void MaskLayer_use_fill_overlap_set(PointerRNA *ptr, bool value)
{
    MaskLayer *data = (MaskLayer *)(ptr->data);
    if (value) { data->flag |= 128; }
    else { data->flag &= ~128; }
}

static PointerRNA Mask_layers_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_MaskLayer, rna_iterator_listbase_get(iter));
}

extern void Mask_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_Mask_layers;

    PropCollectionBeginFunc fn = rna_Mask_layers_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = Mask_layers_get(iter);
    }
}

extern void Mask_layers_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_listbase_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = Mask_layers_get(iter);
    }
}

extern void Mask_layers_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern int Mask_active_layer_index_get(PointerRNA *ptr)
{
    PropIntGetFunc fn = rna_Mask_layer_active_index_get;
    return fn(ptr);
}

extern void Mask_active_layer_index_set(PointerRNA *ptr, int value)
{
    PropIntSetFunc fn = rna_Mask_layer_active_index_set;
    fn(ptr, value);
}

extern int Mask_frame_start_get(PointerRNA *ptr)
{
    Mask *data = (Mask *)(ptr->data);
    return (int)(data->sfra);
}

extern void Mask_frame_start_set(PointerRNA *ptr, int value)
{
    PropIntSetFunc fn = rna_Mask_start_frame_set;
    fn(ptr, value);
}

extern int Mask_frame_end_get(PointerRNA *ptr)
{
    Mask *data = (Mask *)(ptr->data);
    return (int)(data->efra);
}

extern void Mask_frame_end_set(PointerRNA *ptr, int value)
{
    PropIntSetFunc fn = rna_Mask_end_frame_set;
    fn(ptr, value);
}

extern PointerRNA Mask_animation_data_get(PointerRNA *ptr)
{
    Mask *data = (Mask *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_AnimData, data->adt);
}

static PointerRNA MaskLayers_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void MaskLayers_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_MaskLayers_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = MaskLayers_rna_properties_get(iter);
    }
}

extern void MaskLayers_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = MaskLayers_rna_properties_get(iter);
    }
}

extern void MaskLayers_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool MaskLayers_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA MaskLayers_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern PointerRNA MaskLayers_active_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_Mask_layer_active_get;
    return fn(ptr);
}

extern void MaskLayers_active_set(PointerRNA *ptr, PointerRNA value, struct ReportList *reports)
{
    PropPointerSetFunc fn = rna_Mask_layer_active_set;
    fn(ptr, value, reports);
}





extern struct MaskSpline *MaskSplines_new_func(struct ID *_selfid, struct MaskLayer *_self)
{
	return rna_MaskLayer_spline_new(_selfid, _self);
}

static void MaskSplines_new_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct ID *_selfid;
	struct MaskLayer *_self;
	struct MaskSpline *spline;
	char *_data, *_retdata;
	
	_selfid = (struct ID *)_ptr->owner_id;
	_self = (struct MaskLayer *)_ptr->data;
	_data = (char *)_parms->data;
	_retdata = _data;
	
	spline = rna_MaskLayer_spline_new(_selfid, _self);
	*((struct MaskSpline **)_retdata) = spline;
}

extern void MaskSplines_remove_func(struct ID *_selfid, struct MaskLayer *_self, ReportList *reports, struct PointerRNA *spline)
{
	rna_MaskLayer_spline_remove(_selfid, _self, reports, spline);
}

static void MaskSplines_remove_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct ID *_selfid;
	struct MaskLayer *_self;
	struct PointerRNA *spline;
	char *_data;
	
	_selfid = (struct ID *)_ptr->owner_id;
	_self = (struct MaskLayer *)_ptr->data;
	_data = (char *)_parms->data;
	spline = *((struct PointerRNA **)_data);
	
	rna_MaskLayer_spline_remove(_selfid, _self, reports, spline);
}

/* Repeated prototypes to detect errors */

struct MaskSpline *rna_MaskLayer_spline_new(struct ID *_selfid, struct MaskLayer *_self);
void rna_MaskLayer_spline_remove(struct ID *_selfid, struct MaskLayer *_self, ReportList *reports, struct PointerRNA *spline);

extern void MaskSplinePoints_add_func(struct ID *_selfid, struct MaskSpline *_self, int count)
{
	rna_MaskSpline_points_add(_selfid, _self, count);
}

static void MaskSplinePoints_add_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct ID *_selfid;
	struct MaskSpline *_self;
	int count;
	char *_data;
	
	_selfid = (struct ID *)_ptr->owner_id;
	_self = (struct MaskSpline *)_ptr->data;
	_data = (char *)_parms->data;
	count = *((int *)_data);
	
	rna_MaskSpline_points_add(_selfid, _self, count);
}

extern void MaskSplinePoints_remove_func(struct ID *_selfid, struct MaskSpline *_self, ReportList *reports, struct PointerRNA *point)
{
	rna_MaskSpline_point_remove(_selfid, _self, reports, point);
}

static void MaskSplinePoints_remove_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct ID *_selfid;
	struct MaskSpline *_self;
	struct PointerRNA *point;
	char *_data;
	
	_selfid = (struct ID *)_ptr->owner_id;
	_self = (struct MaskSpline *)_ptr->data;
	_data = (char *)_parms->data;
	point = *((struct PointerRNA **)_data);
	
	rna_MaskSpline_point_remove(_selfid, _self, reports, point);
}

/* Repeated prototypes to detect errors */

void rna_MaskSpline_points_add(struct ID *_selfid, struct MaskSpline *_self, int count);
void rna_MaskSpline_point_remove(struct ID *_selfid, struct MaskSpline *_self, ReportList *reports, struct PointerRNA *point);



extern struct MaskLayer *MaskLayers_new_func(struct Mask *_self, const char * name)
{
	return rna_Mask_layers_new(_self, name);
}

static void MaskLayers_new_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct Mask *_self;
	const char * name;
	struct MaskLayer *layer;
	char *_data, *_retdata;
	
	_self = (struct Mask *)_ptr->data;
	_data = (char *)_parms->data;
	name = *((const char * *)_data);
	_data += 8;
	_retdata = _data;
	
	layer = rna_Mask_layers_new(_self, name);
	*((struct MaskLayer **)_retdata) = layer;
}

extern void MaskLayers_remove_func(struct Mask *_self, ReportList *reports, struct PointerRNA *layer)
{
	rna_Mask_layers_remove(_self, reports, layer);
}

static void MaskLayers_remove_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct Mask *_self;
	struct PointerRNA *layer;
	char *_data;
	
	_self = (struct Mask *)_ptr->data;
	_data = (char *)_parms->data;
	layer = *((struct PointerRNA **)_data);
	
	rna_Mask_layers_remove(_self, reports, layer);
}

extern void MaskLayers_clear_func(struct Mask *_self)
{
	rna_Mask_layers_clear(_self);
}

static void MaskLayers_clear_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct Mask *_self;
	_self = (struct Mask *)_ptr->data;
	
	rna_Mask_layers_clear(_self);
}

/* Repeated prototypes to detect errors */

struct MaskLayer *rna_Mask_layers_new(struct Mask *_self, const char * name);
void rna_Mask_layers_remove(struct Mask *_self, ReportList *reports, struct PointerRNA *layer);
void rna_Mask_layers_clear(struct Mask *_self);

/* Mask Parent */
static CollectionPropertyRNA rna_MaskParent_rna_properties_ = {
	{&rna_MaskParent_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskParent_rna_properties_begin, MaskParent_rna_properties_next, MaskParent_rna_properties_end, MaskParent_rna_properties_get, nullptr, nullptr, MaskParent_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MaskParent_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MaskParent_rna_properties_);

static PointerPropertyRNA rna_MaskParent_rna_type_ = {
	{&rna_MaskParent_id, &rna_MaskParent_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskParent_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MaskParent_rna_type = reinterpret_cast<PropertyRNA &>(rna_MaskParent_rna_type_);

static PointerPropertyRNA rna_MaskParent_id_ = {
	{&rna_MaskParent_id_type, &rna_MaskParent_rna_type,
	-1, "id", 8388737, 0, 0, 64, 0, PropertyPathTemplateType(0), "ID",
	"ID-block to which masking element would be parented to or to its property",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_parent, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskParent_id_get, MaskParent_id_set, rna_MaskParent_id_typef, nullptr,&RNA_ID
};
PropertyRNA &rna_MaskParent_id = reinterpret_cast<PropertyRNA &>(rna_MaskParent_id_);

static const EnumPropertyItem rna_MaskParent_id_type_items[2] = {
	{17229, "MOVIECLIP", 148, "Movie Clip", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_MaskParent_id_type_ = {
	{&rna_MaskParent_type, &rna_MaskParent_id,
	-1, "id_type", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "ID Type",
	"Type of ID-block that can be used",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_parent, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskParent_id_type_get, MaskParent_id_type_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_MaskParent_id_type_items, 1, 17229
};
PropertyRNA &rna_MaskParent_id_type = reinterpret_cast<PropertyRNA &>(rna_MaskParent_id_type_);

static const EnumPropertyItem rna_MaskParent_type_items[3] = {
	{0, "POINT_TRACK", 0, "Point Track", ""},
	{1, "PLANE_TRACK", 0, "Plane Track", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_MaskParent_type_ = {
	{&rna_MaskParent_parent, &rna_MaskParent_id_type,
	-1, "type", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Parent Type",
	"Parent Type",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_parent, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(MaskParent, type), RawPropertyType(0), nullptr},
	MaskParent_type_get, MaskParent_type_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_MaskParent_type_items, 2, 0
};
PropertyRNA &rna_MaskParent_type = reinterpret_cast<PropertyRNA &>(rna_MaskParent_type_);

static StringPropertyRNA rna_MaskParent_parent_ = {
	{&rna_MaskParent_sub_parent, &rna_MaskParent_type,
	-1, "parent", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Parent",
	"Name of parent object in specified data-block to which parenting happens",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {64, 0, 0}, 0,
	rna_Mask_update_parent, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskParent_parent_get, MaskParent_parent_length, MaskParent_parent_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 256, ""
};
PropertyRNA &rna_MaskParent_parent = reinterpret_cast<PropertyRNA &>(rna_MaskParent_parent_);

static StringPropertyRNA rna_MaskParent_sub_parent_ = {
	{nullptr, &rna_MaskParent_parent,
	-1, "sub_parent", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Sub Parent",
	"Name of parent sub-object in specified data-block to which parenting happens",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {64, 0, 0}, 0,
	rna_Mask_update_parent, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskParent_sub_parent_get, MaskParent_sub_parent_length, MaskParent_sub_parent_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 256, ""
};
PropertyRNA &rna_MaskParent_sub_parent = reinterpret_cast<PropertyRNA &>(rna_MaskParent_sub_parent_);

StructRNA RNA_MaskParent = {
	{(ContainerRNA *)&RNA_MaskSplinePointUW, (ContainerRNA *)&RNA_MovieTrackingObjects,
	nullptr,
	{&rna_MaskParent_rna_properties, &rna_MaskParent_sub_parent}},
	"MaskParent", nullptr, nullptr, 516, nullptr, "Mask Parent",
	"Parenting settings for masking element",
	"*", 63,
	nullptr, &rna_MaskParent_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Mask Spline UW Point */
static CollectionPropertyRNA rna_MaskSplinePointUW_rna_properties_ = {
	{&rna_MaskSplinePointUW_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePointUW_rna_properties_begin, MaskSplinePointUW_rna_properties_next, MaskSplinePointUW_rna_properties_end, MaskSplinePointUW_rna_properties_get, nullptr, nullptr, MaskSplinePointUW_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MaskSplinePointUW_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePointUW_rna_properties_);

static PointerPropertyRNA rna_MaskSplinePointUW_rna_type_ = {
	{&rna_MaskSplinePointUW_u, &rna_MaskSplinePointUW_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePointUW_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MaskSplinePointUW_rna_type = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePointUW_rna_type_);

static FloatPropertyRNA rna_MaskSplinePointUW_u_ = {
	{&rna_MaskSplinePointUW_weight, &rna_MaskSplinePointUW_rna_type,
	-1, "u", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "U",
	"U coordinate of point along spline segment",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(MaskSplinePointUW, u), RawPropertyType(5), nullptr},
	MaskSplinePointUW_u_get, MaskSplinePointUW_u_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_MaskSplinePointUW_u = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePointUW_u_);

static FloatPropertyRNA rna_MaskSplinePointUW_weight_ = {
	{&rna_MaskSplinePointUW_select, &rna_MaskSplinePointUW_u,
	-1, "weight", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Weight",
	"Weight of feather point",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(MaskSplinePointUW, w), RawPropertyType(5), nullptr},
	MaskSplinePointUW_weight_get, MaskSplinePointUW_weight_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_MaskSplinePointUW_weight = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePointUW_weight_);

static BoolPropertyRNA rna_MaskSplinePointUW_select_ = {
	{nullptr, &rna_MaskSplinePointUW_weight,
	-1, "select", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select",
	"Selection status",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePointUW_select_get, MaskSplinePointUW_select_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskSplinePointUW_select = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePointUW_select_);

StructRNA RNA_MaskSplinePointUW = {
	{(ContainerRNA *)&RNA_MaskSplinePoint, (ContainerRNA *)&RNA_MaskParent,
	nullptr,
	{&rna_MaskSplinePointUW_rna_properties, &rna_MaskSplinePointUW_select}},
	"MaskSplinePointUW", nullptr, nullptr, 516, nullptr, "Mask Spline UW Point",
	"Single point in spline segment defining feather",
	"*", 63,
	nullptr, &rna_MaskSplinePointUW_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Mask Spline Point */
static CollectionPropertyRNA rna_MaskSplinePoint_rna_properties_ = {
	{&rna_MaskSplinePoint_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_rna_properties_begin, MaskSplinePoint_rna_properties_next, MaskSplinePoint_rna_properties_end, MaskSplinePoint_rna_properties_get, nullptr, nullptr, MaskSplinePoint_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MaskSplinePoint_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_rna_properties_);

static PointerPropertyRNA rna_MaskSplinePoint_rna_type_ = {
	{&rna_MaskSplinePoint_handle_left, &rna_MaskSplinePoint_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MaskSplinePoint_rna_type = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_rna_type_);

static float rna_MaskSplinePoint_handle_left_default[2] = {
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_MaskSplinePoint_handle_left_ = {
	{&rna_MaskSplinePoint_co, &rna_MaskSplinePoint_rna_type,
	-1, "handle_left", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Handle 1",
	"Coordinates of the first handle",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_TRANSLATION) | int(PROP_UNIT_LENGTH)), nullptr, 1, {2, 0, 0}, 2,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, MaskSplinePoint_handle_left_get, MaskSplinePoint_handle_left_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -10000.0f, 10000.0f, -FLT_MAX, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_MaskSplinePoint_handle_left_default
};
PropertyRNA &rna_MaskSplinePoint_handle_left = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_handle_left_);

static float rna_MaskSplinePoint_co_default[2] = {
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_MaskSplinePoint_co_ = {
	{&rna_MaskSplinePoint_handle_right, &rna_MaskSplinePoint_handle_left,
	-1, "co", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Control Point",
	"Coordinates of the control point",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_TRANSLATION) | int(PROP_UNIT_LENGTH)), nullptr, 1, {2, 0, 0}, 2,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, MaskSplinePoint_co_get, MaskSplinePoint_co_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -10000.0f, 10000.0f, -FLT_MAX, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_MaskSplinePoint_co_default
};
PropertyRNA &rna_MaskSplinePoint_co = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_co_);

static float rna_MaskSplinePoint_handle_right_default[2] = {
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_MaskSplinePoint_handle_right_ = {
	{&rna_MaskSplinePoint_handle_type, &rna_MaskSplinePoint_co,
	-1, "handle_right", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Handle 2",
	"Coordinates of the second handle",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_TRANSLATION) | int(PROP_UNIT_LENGTH)), nullptr, 1, {2, 0, 0}, 2,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, MaskSplinePoint_handle_right_get, MaskSplinePoint_handle_right_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -10000.0f, 10000.0f, -FLT_MAX, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_MaskSplinePoint_handle_right_default
};
PropertyRNA &rna_MaskSplinePoint_handle_right = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_handle_right_);

static const EnumPropertyItem rna_MaskSplinePoint_handle_type_items[6] = {
	{1, "AUTO", 0, "Auto", ""},
	{2, "VECTOR", 0, "Vector", ""},
	{3, "ALIGNED", 0, "Aligned Single", ""},
	{5, "ALIGNED_DOUBLESIDE", 0, "Aligned", ""},
	{0, "FREE", 0, "Free", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_MaskSplinePoint_handle_type_ = {
	{&rna_MaskSplinePoint_handle_left_type, &rna_MaskSplinePoint_handle_right,
	-1, "handle_type", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Handle Type",
	"Handle type",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_handle_type_get, MaskSplinePoint_handle_type_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_MaskSplinePoint_handle_type_items, 5, 0
};
PropertyRNA &rna_MaskSplinePoint_handle_type = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_handle_type_);

static const EnumPropertyItem rna_MaskSplinePoint_handle_left_type_items[6] = {
	{1, "AUTO", 0, "Auto", ""},
	{2, "VECTOR", 0, "Vector", ""},
	{3, "ALIGNED", 0, "Aligned Single", ""},
	{5, "ALIGNED_DOUBLESIDE", 0, "Aligned", ""},
	{0, "FREE", 0, "Free", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_MaskSplinePoint_handle_left_type_ = {
	{&rna_MaskSplinePoint_handle_right_type, &rna_MaskSplinePoint_handle_type,
	-1, "handle_left_type", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Handle 1 Type",
	"Handle type",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_handle_left_type_get, MaskSplinePoint_handle_left_type_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_MaskSplinePoint_handle_left_type_items, 5, 0
};
PropertyRNA &rna_MaskSplinePoint_handle_left_type = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_handle_left_type_);

static const EnumPropertyItem rna_MaskSplinePoint_handle_right_type_items[6] = {
	{1, "AUTO", 0, "Auto", ""},
	{2, "VECTOR", 0, "Vector", ""},
	{3, "ALIGNED", 0, "Aligned Single", ""},
	{5, "ALIGNED_DOUBLESIDE", 0, "Aligned", ""},
	{0, "FREE", 0, "Free", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_MaskSplinePoint_handle_right_type_ = {
	{&rna_MaskSplinePoint_weight, &rna_MaskSplinePoint_handle_left_type,
	-1, "handle_right_type", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Handle 2 Type",
	"Handle type",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_handle_right_type_get, MaskSplinePoint_handle_right_type_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_MaskSplinePoint_handle_right_type_items, 5, 0
};
PropertyRNA &rna_MaskSplinePoint_handle_right_type = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_handle_right_type_);

static FloatPropertyRNA rna_MaskSplinePoint_weight_ = {
	{&rna_MaskSplinePoint_select, &rna_MaskSplinePoint_handle_right_type,
	-1, "weight", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Weight",
	"Weight of the point",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(MaskSplinePoint, bezt.weight), RawPropertyType(5), nullptr},
	MaskSplinePoint_weight_get, MaskSplinePoint_weight_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_MaskSplinePoint_weight = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_weight_);

static BoolPropertyRNA rna_MaskSplinePoint_select_ = {
	{&rna_MaskSplinePoint_select_left_handle, &rna_MaskSplinePoint_weight,
	-1, "select", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select",
	"Selection status of the control point. (Deprecated: use Select Control Point instead)",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_select_get, MaskSplinePoint_select_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskSplinePoint_select = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_select_);

static BoolPropertyRNA rna_MaskSplinePoint_select_left_handle_ = {
	{&rna_MaskSplinePoint_select_control_point, &rna_MaskSplinePoint_select,
	-1, "select_left_handle", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select Left Handle",
	"Selection status of the left handle",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_select_left_handle_get, MaskSplinePoint_select_left_handle_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskSplinePoint_select_left_handle = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_select_left_handle_);

static BoolPropertyRNA rna_MaskSplinePoint_select_control_point_ = {
	{&rna_MaskSplinePoint_select_right_handle, &rna_MaskSplinePoint_select_left_handle,
	-1, "select_control_point", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select Control Point",
	"Selection status of the control point",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_select_control_point_get, MaskSplinePoint_select_control_point_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskSplinePoint_select_control_point = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_select_control_point_);

static BoolPropertyRNA rna_MaskSplinePoint_select_right_handle_ = {
	{&rna_MaskSplinePoint_select_single_handle, &rna_MaskSplinePoint_select_control_point,
	-1, "select_right_handle", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select Right Handle",
	"Selection status of the right handle",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_select_right_handle_get, MaskSplinePoint_select_right_handle_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskSplinePoint_select_right_handle = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_select_right_handle_);

static BoolPropertyRNA rna_MaskSplinePoint_select_single_handle_ = {
	{&rna_MaskSplinePoint_parent, &rna_MaskSplinePoint_select_right_handle,
	-1, "select_single_handle", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select Aligned Single Handle",
	"Selection status of the Aligned Single handle",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_select_single_handle_get, MaskSplinePoint_select_single_handle_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskSplinePoint_select_single_handle = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_select_single_handle_);

static PointerPropertyRNA rna_MaskSplinePoint_parent_ = {
	{&rna_MaskSplinePoint_feather_points, &rna_MaskSplinePoint_select_single_handle,
	-1, "parent", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "parent",
	"",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_parent_get, nullptr, nullptr, nullptr,&RNA_MaskParent
};
PropertyRNA &rna_MaskSplinePoint_parent = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_parent_);

static CollectionPropertyRNA rna_MaskSplinePoint_feather_points_ = {
	{nullptr, &rna_MaskSplinePoint_parent,
	-1, "feather_points", 0, 0, 0, 8, 0, PropertyPathTemplateType(0), "Feather Points",
	"Points defining feather",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoint_feather_points_begin, MaskSplinePoint_feather_points_next, MaskSplinePoint_feather_points_end, MaskSplinePoint_feather_points_get, MaskSplinePoint_feather_points_length, MaskSplinePoint_feather_points_lookup_int, nullptr, nullptr, &RNA_MaskSplinePointUW
};
PropertyRNA &rna_MaskSplinePoint_feather_points = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoint_feather_points_);

StructRNA RNA_MaskSplinePoint = {
	{(ContainerRNA *)&RNA_MaskSpline, (ContainerRNA *)&RNA_MaskSplinePointUW,
	nullptr,
	{&rna_MaskSplinePoint_rna_properties, &rna_MaskSplinePoint_feather_points}},
	"MaskSplinePoint", nullptr, nullptr, 516, nullptr, "Mask Spline Point",
	"Single point in spline used for defining mask",
	"*", 63,
	nullptr, &rna_MaskSplinePoint_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Mask spline */
static CollectionPropertyRNA rna_MaskSpline_rna_properties_ = {
	{&rna_MaskSpline_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSpline_rna_properties_begin, MaskSpline_rna_properties_next, MaskSpline_rna_properties_end, MaskSpline_rna_properties_get, nullptr, nullptr, MaskSpline_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MaskSpline_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MaskSpline_rna_properties_);

static PointerPropertyRNA rna_MaskSpline_rna_type_ = {
	{&rna_MaskSpline_offset_mode, &rna_MaskSpline_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSpline_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MaskSpline_rna_type = reinterpret_cast<PropertyRNA &>(rna_MaskSpline_rna_type_);

static const EnumPropertyItem rna_MaskSpline_offset_mode_items[3] = {
	{0, "EVEN", 0, "Even", "Calculate even feather offset"},
	{1, "SMOOTH", 0, "Smooth", "Calculate feather offset as a second curve"},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_MaskSpline_offset_mode_ = {
	{&rna_MaskSpline_weight_interpolation, &rna_MaskSpline_rna_type,
	-1, "offset_mode", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Feather Offset",
	"The method used for calculating the feather offset",
	0, "Mask",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(MaskSpline, offset_mode), RawPropertyType(2), nullptr},
	MaskSpline_offset_mode_get, MaskSpline_offset_mode_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_MaskSpline_offset_mode_items, 2, 0
};
PropertyRNA &rna_MaskSpline_offset_mode = reinterpret_cast<PropertyRNA &>(rna_MaskSpline_offset_mode_);

static const EnumPropertyItem rna_MaskSpline_weight_interpolation_items[3] = {
	{1, "LINEAR", 0, "Linear", ""},
	{2, "EASE", 0, "Ease", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_MaskSpline_weight_interpolation_ = {
	{&rna_MaskSpline_use_cyclic, &rna_MaskSpline_offset_mode,
	-1, "weight_interpolation", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Weight Interpolation",
	"The type of weight interpolation for spline",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(MaskSpline, weight_interp), RawPropertyType(2), nullptr},
	MaskSpline_weight_interpolation_get, MaskSpline_weight_interpolation_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_MaskSpline_weight_interpolation_items, 2, 1
};
PropertyRNA &rna_MaskSpline_weight_interpolation = reinterpret_cast<PropertyRNA &>(rna_MaskSpline_weight_interpolation_);

static BoolPropertyRNA rna_MaskSpline_use_cyclic_ = {
	{&rna_MaskSpline_use_fill, &rna_MaskSpline_weight_interpolation,
	-1, "use_cyclic", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Cyclic",
	"Make this spline a closed loop",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSpline_use_cyclic_get, MaskSpline_use_cyclic_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskSpline_use_cyclic = reinterpret_cast<PropertyRNA &>(rna_MaskSpline_use_cyclic_);

static BoolPropertyRNA rna_MaskSpline_use_fill_ = {
	{&rna_MaskSpline_use_self_intersection_check, &rna_MaskSpline_use_cyclic,
	-1, "use_fill", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Fill",
	"Make this spline filled",
	0, "Mask",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSpline_use_fill_get, MaskSpline_use_fill_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskSpline_use_fill = reinterpret_cast<PropertyRNA &>(rna_MaskSpline_use_fill_);

static BoolPropertyRNA rna_MaskSpline_use_self_intersection_check_ = {
	{&rna_MaskSpline_points, &rna_MaskSpline_use_fill,
	-1, "use_self_intersection_check", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Self Intersection Check",
	"Prevent feather from self-intersections",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Mask_update_data, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSpline_use_self_intersection_check_get, MaskSpline_use_self_intersection_check_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskSpline_use_self_intersection_check = reinterpret_cast<PropertyRNA &>(rna_MaskSpline_use_self_intersection_check_);

static CollectionPropertyRNA rna_MaskSpline_points_ = {
	{nullptr, &rna_MaskSpline_use_self_intersection_check,
	-1, "points", 0, 0, 0, 8, 0, PropertyPathTemplateType(0), "Points",
	"Collection of points",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, &RNA_MaskSplinePoints},
	MaskSpline_points_begin, MaskSpline_points_next, MaskSpline_points_end, MaskSpline_points_get, MaskSpline_points_length, MaskSpline_points_lookup_int, nullptr, nullptr, &RNA_MaskSplinePoint
};
PropertyRNA &rna_MaskSpline_points = reinterpret_cast<PropertyRNA &>(rna_MaskSpline_points_);

StructRNA RNA_MaskSpline = {
	{(ContainerRNA *)&RNA_MaskSplines, (ContainerRNA *)&RNA_MaskSplinePoint,
	nullptr,
	{&rna_MaskSpline_rna_properties, &rna_MaskSpline_points}},
	"MaskSpline", nullptr, nullptr, 516, nullptr, "Mask spline",
	"Single spline used for defining mask shape",
	"*", 63,
	nullptr, &rna_MaskSpline_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Mask Splines */
static CollectionPropertyRNA rna_MaskSplines_rna_properties_ = {
	{&rna_MaskSplines_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplines_rna_properties_begin, MaskSplines_rna_properties_next, MaskSplines_rna_properties_end, MaskSplines_rna_properties_get, nullptr, nullptr, MaskSplines_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MaskSplines_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MaskSplines_rna_properties_);

static PointerPropertyRNA rna_MaskSplines_rna_type_ = {
	{&rna_MaskSplines_active, &rna_MaskSplines_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplines_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MaskSplines_rna_type = reinterpret_cast<PropertyRNA &>(rna_MaskSplines_rna_type_);

static PointerPropertyRNA rna_MaskSplines_active_ = {
	{&rna_MaskSplines_active_point, &rna_MaskSplines_rna_type,
	-1, "active", 41943041, 0, 0, 0, 0, PropertyPathTemplateType(0), "Active Spline",
	"Active spline of masking layer",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplines_active_get, MaskSplines_active_set, nullptr, nullptr,&RNA_MaskSpline
};
PropertyRNA &rna_MaskSplines_active = reinterpret_cast<PropertyRNA &>(rna_MaskSplines_active_);

static PointerPropertyRNA rna_MaskSplines_active_point_ = {
	{nullptr, &rna_MaskSplines_active,
	-1, "active_point", 41943041, 0, 0, 0, 0, PropertyPathTemplateType(0), "Active Point",
	"Active point of masking layer",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplines_active_point_get, MaskSplines_active_point_set, nullptr, nullptr,&RNA_MaskSplinePoint
};
PropertyRNA &rna_MaskSplines_active_point = reinterpret_cast<PropertyRNA &>(rna_MaskSplines_active_point_);

static PointerPropertyRNA rna_MaskSplines_new_spline_ = {
	{nullptr, nullptr,
	-1, "spline", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"The newly created spline",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_MaskSpline
};
PropertyRNA &rna_MaskSplines_new_spline = reinterpret_cast<PropertyRNA &>(rna_MaskSplines_new_spline_);

FunctionRNA rna_MaskSplines_new_func = {
	{(FunctionRNA *)&rna_MaskSplines_remove_func, nullptr,
	nullptr,
	{&rna_MaskSplines_new_spline, &rna_MaskSplines_new_spline}},
	"new", 2048, "Add a new spline to the layer",
	MaskSplines_new_call,
	&rna_MaskSplines_new_spline
};

static PointerPropertyRNA rna_MaskSplines_remove_spline_ = {
	{nullptr, nullptr,
	-1, "spline", 262144, 0, 5, 0, 0, PropertyPathTemplateType(0), "",
	"The spline to remove",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_MaskSpline
};
PropertyRNA &rna_MaskSplines_remove_spline = reinterpret_cast<PropertyRNA &>(rna_MaskSplines_remove_spline_);

FunctionRNA rna_MaskSplines_remove_func = {
	{nullptr, (FunctionRNA *)&rna_MaskSplines_new_func,
	nullptr,
	{&rna_MaskSplines_remove_spline, &rna_MaskSplines_remove_spline}},
	"remove", 2064, "Remove a spline from a layer",
	MaskSplines_remove_call,
	nullptr
};

StructRNA RNA_MaskSplines = {
	{(ContainerRNA *)&RNA_MaskSplinePoints, (ContainerRNA *)&RNA_MaskSpline,
	nullptr,
	{&rna_MaskSplines_rna_properties, &rna_MaskSplines_active_point}},
	"MaskSplines", nullptr, nullptr, 516, nullptr, "Mask Splines",
	"Collection of masking splines",
	"*", 63,
	nullptr, &rna_MaskSplines_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_MaskSplines_new_func, (FunctionRNA *)&rna_MaskSplines_remove_func}
};

/* Mask Spline Points */
static CollectionPropertyRNA rna_MaskSplinePoints_rna_properties_ = {
	{&rna_MaskSplinePoints_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoints_rna_properties_begin, MaskSplinePoints_rna_properties_next, MaskSplinePoints_rna_properties_end, MaskSplinePoints_rna_properties_get, nullptr, nullptr, MaskSplinePoints_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MaskSplinePoints_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoints_rna_properties_);

static PointerPropertyRNA rna_MaskSplinePoints_rna_type_ = {
	{nullptr, &rna_MaskSplinePoints_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskSplinePoints_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MaskSplinePoints_rna_type = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoints_rna_type_);

static IntPropertyRNA rna_MaskSplinePoints_add_count_ = {
	{nullptr, nullptr,
	-1, "count", 3, 0, 1, 0, 0, PropertyPathTemplateType(0), "Number",
	"Number of points to add to the spline",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 0, INT_MAX, 0, INT_MAX, 1, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_MaskSplinePoints_add_count = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoints_add_count_);

FunctionRNA rna_MaskSplinePoints_add_func = {
	{(FunctionRNA *)&rna_MaskSplinePoints_remove_func, nullptr,
	nullptr,
	{&rna_MaskSplinePoints_add_count, &rna_MaskSplinePoints_add_count}},
	"add", 2048, "Add a number of point to this spline",
	MaskSplinePoints_add_call,
	nullptr
};

static PointerPropertyRNA rna_MaskSplinePoints_remove_point_ = {
	{nullptr, nullptr,
	-1, "point", 262144, 0, 5, 0, 0, PropertyPathTemplateType(0), "",
	"The point to remove",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_MaskSplinePoint
};
PropertyRNA &rna_MaskSplinePoints_remove_point = reinterpret_cast<PropertyRNA &>(rna_MaskSplinePoints_remove_point_);

FunctionRNA rna_MaskSplinePoints_remove_func = {
	{nullptr, (FunctionRNA *)&rna_MaskSplinePoints_add_func,
	nullptr,
	{&rna_MaskSplinePoints_remove_point, &rna_MaskSplinePoints_remove_point}},
	"remove", 2064, "Remove a point from a spline",
	MaskSplinePoints_remove_call,
	nullptr
};

StructRNA RNA_MaskSplinePoints = {
	{(ContainerRNA *)&RNA_MaskLayer, (ContainerRNA *)&RNA_MaskSplines,
	nullptr,
	{&rna_MaskSplinePoints_rna_properties, &rna_MaskSplinePoints_rna_type}},
	"MaskSplinePoints", nullptr, nullptr, 516, nullptr, "Mask Spline Points",
	"Collection of masking spline points",
	"*", 63,
	nullptr, &rna_MaskSplinePoints_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_MaskSplinePoints_add_func, (FunctionRNA *)&rna_MaskSplinePoints_remove_func}
};

/* Mask Layer */
static CollectionPropertyRNA rna_MaskLayer_rna_properties_ = {
	{&rna_MaskLayer_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_rna_properties_begin, MaskLayer_rna_properties_next, MaskLayer_rna_properties_end, MaskLayer_rna_properties_get, nullptr, nullptr, MaskLayer_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MaskLayer_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_rna_properties_);

static PointerPropertyRNA rna_MaskLayer_rna_type_ = {
	{&rna_MaskLayer_name, &rna_MaskLayer_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MaskLayer_rna_type = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_rna_type_);

static StringPropertyRNA rna_MaskLayer_name_ = {
	{&rna_MaskLayer_splines, &rna_MaskLayer_rna_type,
	-1, "name", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Name",
	"Unique name of layer",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {64, 0, 0}, 0,
	rna_Mask_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_name_get, MaskLayer_name_length, MaskLayer_name_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 256, ""
};
PropertyRNA &rna_MaskLayer_name = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_name_);

static CollectionPropertyRNA rna_MaskLayer_splines_ = {
	{&rna_MaskLayer_hide, &rna_MaskLayer_name,
	-1, "splines", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Splines",
	"Collection of splines which defines this layer",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, &RNA_MaskSplines},
	MaskLayer_splines_begin, MaskLayer_splines_next, MaskLayer_splines_end, MaskLayer_splines_get, nullptr, MaskLayer_splines_lookup_int, nullptr, nullptr, &RNA_MaskSpline
};
PropertyRNA &rna_MaskLayer_splines = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_splines_);

static BoolPropertyRNA rna_MaskLayer_hide_ = {
	{&rna_MaskLayer_hide_select, &rna_MaskLayer_splines,
	-1, "hide", 4355, 0, 0, 0, 0, PropertyPathTemplateType(0), "Restrict View",
	"Restrict visibility in the viewport",
	32, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 370606080, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_hide_get, MaskLayer_hide_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskLayer_hide = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_hide_);

static BoolPropertyRNA rna_MaskLayer_hide_select_ = {
	{&rna_MaskLayer_hide_render, &rna_MaskLayer_hide,
	-1, "hide_select", 4355, 0, 0, 0, 0, PropertyPathTemplateType(0), "Restrict Select",
	"Restrict selection in the viewport",
	30, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 370606080, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_hide_select_get, MaskLayer_hide_select_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskLayer_hide_select = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_hide_select_);

static BoolPropertyRNA rna_MaskLayer_hide_render_ = {
	{&rna_MaskLayer_select, &rna_MaskLayer_hide_select,
	-1, "hide_render", 4355, 0, 0, 0, 0, PropertyPathTemplateType(0), "Restrict Render",
	"Restrict renderability",
	28, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_hide_render_get, MaskLayer_hide_render_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskLayer_hide_render = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_hide_render_);

static BoolPropertyRNA rna_MaskLayer_select_ = {
	{&rna_MaskLayer_alpha, &rna_MaskLayer_hide_render,
	-1, "select", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select",
	"Layer is selected for editing in the Dope Sheet",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_select_get, MaskLayer_select_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskLayer_select = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_select_);

static FloatPropertyRNA rna_MaskLayer_alpha_ = {
	{&rna_MaskLayer_blend, &rna_MaskLayer_select,
	-1, "alpha", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Opacity",
	"Render Opacity",
	0, "*",
	nullptr,
	PROP_FLOAT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(MaskLayer, alpha), RawPropertyType(5), nullptr},
	MaskLayer_alpha_get, MaskLayer_alpha_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, -FLT_MAX, FLT_MAX, 0.1000000015f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_MaskLayer_alpha = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_alpha_);

static const EnumPropertyItem rna_MaskLayer_blend_items[10] = {
	{7, "MERGE_ADD", 0, "Merge Add", ""},
	{8, "MERGE_SUBTRACT", 0, "Merge Subtract", ""},
	{0, "ADD", 0, "Add", ""},
	{1, "SUBTRACT", 0, "Subtract", ""},
	{2, "LIGHTEN", 0, "Lighten", ""},
	{3, "DARKEN", 0, "Darken", ""},
	{4, "MUL", 0, "Multiply", ""},
	{5, "REPLACE", 0, "Replace", ""},
	{6, "DIFFERENCE", 0, "Difference", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_MaskLayer_blend_ = {
	{&rna_MaskLayer_invert, &rna_MaskLayer_alpha,
	-1, "blend", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Blend",
	"Method of blending mask layers",
	0, "*",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(MaskLayer, blend), RawPropertyType(2), nullptr},
	MaskLayer_blend_get, MaskLayer_blend_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_MaskLayer_blend_items, 9, 0
};
PropertyRNA &rna_MaskLayer_blend = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_blend_);

static BoolPropertyRNA rna_MaskLayer_invert_ = {
	{&rna_MaskLayer_falloff, &rna_MaskLayer_blend,
	-1, "invert", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Invert",
	"Invert the mask black/white",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_invert_get, MaskLayer_invert_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskLayer_invert = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_invert_);

static EnumPropertyRNA rna_MaskLayer_falloff_ = {
	{&rna_MaskLayer_use_fill_holes, &rna_MaskLayer_invert,
	-1, "falloff", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Falloff",
	"Falloff type of the feather",
	0, "Curve",
	nullptr,
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(MaskLayer, falloff), RawPropertyType(2), nullptr},
	MaskLayer_falloff_get, MaskLayer_falloff_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, rna_enum_proportional_falloff_curve_only_items, 6, 0
};
PropertyRNA &rna_MaskLayer_falloff = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_falloff_);

static BoolPropertyRNA rna_MaskLayer_use_fill_holes_ = {
	{&rna_MaskLayer_use_fill_overlap, &rna_MaskLayer_falloff,
	-1, "use_fill_holes", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Calculate Holes",
	"Calculate holes when filling overlapping curves",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_use_fill_holes_get, MaskLayer_use_fill_holes_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskLayer_use_fill_holes = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_use_fill_holes_);

static BoolPropertyRNA rna_MaskLayer_use_fill_overlap_ = {
	{nullptr, &rna_MaskLayer_use_fill_holes,
	-1, "use_fill_overlap", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Calculate Overlap",
	"Calculate self intersections and overlap before filling",
	0, "*",
	nullptr,
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 369098753, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayer_use_fill_overlap_get, MaskLayer_use_fill_overlap_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_MaskLayer_use_fill_overlap = reinterpret_cast<PropertyRNA &>(rna_MaskLayer_use_fill_overlap_);

StructRNA RNA_MaskLayer = {
	{(ContainerRNA *)&RNA_Mask, (ContainerRNA *)&RNA_MaskSplinePoints,
	nullptr,
	{&rna_MaskLayer_rna_properties, &rna_MaskLayer_use_fill_overlap}},
	"MaskLayer", nullptr, nullptr, 516, nullptr, "Mask Layer",
	"Single layer used for masking pixels",
	"*", 63,
	&rna_MaskLayer_name, &rna_MaskLayer_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_MaskLayer_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Mask */
static CollectionPropertyRNA rna_Mask_layers_ = {
	{&rna_Mask_active_layer_index, nullptr,
	-1, "layers", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Layers",
	"Collection of layers which defines this mask",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, &RNA_MaskLayers},
	Mask_layers_begin, Mask_layers_next, Mask_layers_end, Mask_layers_get, nullptr, nullptr, nullptr, nullptr, &RNA_MaskLayer
};
PropertyRNA &rna_Mask_layers = reinterpret_cast<PropertyRNA &>(rna_Mask_layers_);

static IntPropertyRNA rna_Mask_active_layer_index_ = {
	{&rna_Mask_frame_start, &rna_Mask_layers,
	-1, "active_layer_index", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Active Shape Index",
	"Index of active layer in list of all mask\'s layers",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 370606080, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Mask_active_layer_index_get, Mask_active_layer_index_set, nullptr, nullptr, rna_Mask_layer_active_index_range, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -10000, 10000, INT_MIN, INT_MAX, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Mask_active_layer_index = reinterpret_cast<PropertyRNA &>(rna_Mask_active_layer_index_);

static IntPropertyRNA rna_Mask_frame_start_ = {
	{&rna_Mask_frame_end, &rna_Mask_active_layer_index,
	-1, "frame_start", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Start Frame",
	"First frame of the mask (used for sequencer)",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_TIME) | int(PROP_UNIT_TIME)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 370606080, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Mask_frame_start_get, Mask_frame_start_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 0, 1048574, 0, 1048574, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Mask_frame_start = reinterpret_cast<PropertyRNA &>(rna_Mask_frame_start_);

static IntPropertyRNA rna_Mask_frame_end_ = {
	{&rna_Mask_animation_data, &rna_Mask_frame_start,
	-1, "frame_end", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "End Frame",
	"Final frame of the mask (used for sequencer)",
	0, "*",
	nullptr,
	PROP_INT, PropertySubType(int(PROP_TIME) | int(PROP_UNIT_TIME)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 370606080, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Mask_frame_end_get, Mask_frame_end_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 0, 1048574, 0, 1048574, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Mask_frame_end = reinterpret_cast<PropertyRNA &>(rna_Mask_frame_end_);

static PointerPropertyRNA rna_Mask_animation_data_ = {
	{nullptr, &rna_Mask_frame_end,
	-1, "animation_data", 8388608, 1, 0, 0, 0, PropertyPathTemplateType(0), "Animation Data",
	"Animation data for this data-block",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, rna_AnimaData_override_apply,
	0, PROP_RAW_UNSET, nullptr},
	Mask_animation_data_get, nullptr, nullptr, nullptr,&RNA_AnimData
};
PropertyRNA &rna_Mask_animation_data = reinterpret_cast<PropertyRNA &>(rna_Mask_animation_data_);

StructRNA RNA_Mask = {
	{(ContainerRNA *)&RNA_MaskLayers, (ContainerRNA *)&RNA_MaskLayer,
	nullptr,
	{&rna_Mask_layers, &rna_Mask_animation_data}},
	"Mask", nullptr, nullptr, 519, nullptr, "Mask",
	"Mask data-block defining mask for compositing",
	"*", 464,
	&rna_ID_name, &rna_ID_rna_properties,
	&RNA_ID,
	nullptr,
	rna_ID_refine,
	nullptr,
	nullptr,
	nullptr,
	rna_ID_instance,
	rna_ID_idprops,
	rna_ID_system_idprops,
	{nullptr, nullptr}
};

/* Mask Layers */
static CollectionPropertyRNA rna_MaskLayers_rna_properties_ = {
	{&rna_MaskLayers_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	nullptr,
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayers_rna_properties_begin, MaskLayers_rna_properties_next, MaskLayers_rna_properties_end, MaskLayers_rna_properties_get, nullptr, nullptr, MaskLayers_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_MaskLayers_rna_properties = reinterpret_cast<PropertyRNA &>(rna_MaskLayers_rna_properties_);

static PointerPropertyRNA rna_MaskLayers_rna_type_ = {
	{&rna_MaskLayers_active, &rna_MaskLayers_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayers_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_MaskLayers_rna_type = reinterpret_cast<PropertyRNA &>(rna_MaskLayers_rna_type_);

static PointerPropertyRNA rna_MaskLayers_active_ = {
	{nullptr, &rna_MaskLayers_rna_type,
	-1, "active", 41943041, 0, 0, 0, 0, PropertyPathTemplateType(0), "Active Shape",
	"Active layer in this mask",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	MaskLayers_active_get, MaskLayers_active_set, nullptr, nullptr,&RNA_MaskLayer
};
PropertyRNA &rna_MaskLayers_active = reinterpret_cast<PropertyRNA &>(rna_MaskLayers_active_);

static StringPropertyRNA rna_MaskLayers_new_name_ = {
	{&rna_MaskLayers_new_layer, nullptr,
	-1, "name", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Name",
	"Name of new layer",
	0, "*",
	nullptr,
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 0, ""
};
PropertyRNA &rna_MaskLayers_new_name = reinterpret_cast<PropertyRNA &>(rna_MaskLayers_new_name_);

static PointerPropertyRNA rna_MaskLayers_new_layer_ = {
	{nullptr, &rna_MaskLayers_new_name,
	-1, "layer", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"New mask layer",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_MaskLayer
};
PropertyRNA &rna_MaskLayers_new_layer = reinterpret_cast<PropertyRNA &>(rna_MaskLayers_new_layer_);

FunctionRNA rna_MaskLayers_new_func = {
	{(FunctionRNA *)&rna_MaskLayers_remove_func, nullptr,
	nullptr,
	{&rna_MaskLayers_new_name, &rna_MaskLayers_new_layer}},
	"new", 0, "Add layer to this mask",
	MaskLayers_new_call,
	&rna_MaskLayers_new_layer
};

static PointerPropertyRNA rna_MaskLayers_remove_layer_ = {
	{nullptr, nullptr,
	-1, "layer", 262144, 0, 5, 0, 0, PropertyPathTemplateType(0), "",
	"Shape to be removed",
	0, "*",
	nullptr,
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_MaskLayer
};
PropertyRNA &rna_MaskLayers_remove_layer = reinterpret_cast<PropertyRNA &>(rna_MaskLayers_remove_layer_);

FunctionRNA rna_MaskLayers_remove_func = {
	{(FunctionRNA *)&rna_MaskLayers_clear_func, (FunctionRNA *)&rna_MaskLayers_new_func,
	nullptr,
	{&rna_MaskLayers_remove_layer, &rna_MaskLayers_remove_layer}},
	"remove", 16, "Remove layer from this mask",
	MaskLayers_remove_call,
	nullptr
};

FunctionRNA rna_MaskLayers_clear_func = {
	{nullptr, (FunctionRNA *)&rna_MaskLayers_remove_func,
	nullptr,
	{nullptr, nullptr}},
	"clear", 0, "Remove all mask layers",
	MaskLayers_clear_call,
	nullptr
};

StructRNA RNA_MaskLayers = {
	{(ContainerRNA *)&RNA_XrActionMap, (ContainerRNA *)&RNA_Mask,
	nullptr,
	{&rna_MaskLayers_rna_properties, &rna_MaskLayers_active}},
	"MaskLayers", nullptr, nullptr, 516, nullptr, "Mask Layers",
	"Collection of layers used by mask",
	"*", 63,
	nullptr, &rna_MaskLayers_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_MaskLayers_new_func, (FunctionRNA *)&rna_MaskLayers_clear_func}
};

