/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWorkerOptions.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSFetchRequestCredentials.h"
#include "JSWorkerType.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WorkerOptions>> convertDictionary<WorkerOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WorkerOptions result;
    JSValue credentialsValue;
    if (isNullOrUndefined)
        credentialsValue = jsUndefined();
    else {
        credentialsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "credentials"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto credentialsConversionResult = convertOptionalWithDefault<IDLEnumeration<FetchRequestCredentials>>(lexicalGlobalObject, credentialsValue, [&]() -> ConversionResult<IDLEnumeration<FetchRequestCredentials>> { return Converter<IDLEnumeration<FetchRequestCredentials>>::ReturnType { FetchRequestCredentials::SameOrigin }; });
    if (credentialsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.credentials = credentialsConversionResult.releaseReturnValue();
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto nameConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, nameValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto typeConversionResult = convertOptionalWithDefault<IDLEnumeration<WorkerType>>(lexicalGlobalObject, typeValue, [&]() -> ConversionResult<IDLEnumeration<WorkerType>> { return Converter<IDLEnumeration<WorkerType>>::ReturnType { WorkerType::Classic }; });
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

