/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPerformanceObserver.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSPerformanceEntry.h"
#include "JSPerformanceObserverCallback.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<PerformanceObserver::Init>> convertDictionary<PerformanceObserver::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PerformanceObserver::Init result;
    JSValue bufferedValue;
    if (isNullOrUndefined)
        bufferedValue = jsUndefined();
    else {
        bufferedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buffered"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bufferedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bufferedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bufferedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.buffered = bufferedConversionResult.releaseReturnValue();
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().eventTimingEnabled) {
        JSValue durationThresholdValue;
        if (isNullOrUndefined)
            durationThresholdValue = jsUndefined();
        else {
            durationThresholdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "durationThreshold"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        if (!durationThresholdValue.isUndefined()) {
            auto durationThresholdConversionResult = convert<IDLDouble>(lexicalGlobalObject, durationThresholdValue);
            if (durationThresholdConversionResult.hasException(throwScope)) [[unlikely]]
                return ConversionResultException { };
            result.durationThreshold = durationThresholdConversionResult.releaseReturnValue();
        }
    }
    JSValue entryTypesValue;
    if (isNullOrUndefined)
        entryTypesValue = jsUndefined();
    else {
        entryTypesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "entryTypes"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!entryTypesValue.isUndefined()) {
        auto entryTypesConversionResult = convert<IDLSequence<IDLDOMString>>(lexicalGlobalObject, entryTypesValue);
        if (entryTypesConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.entryTypes = entryTypesConversionResult.releaseReturnValue();
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!typeValue.isUndefined()) {
        auto typeConversionResult = convert<IDLDOMString>(lexicalGlobalObject, typeValue);
        if (typeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.type = typeConversionResult.releaseReturnValue();
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsPerformanceObserverPrototypeFunction_observe);
static JSC_DECLARE_HOST_FUNCTION(jsPerformanceObserverPrototypeFunction_disconnect);
static JSC_DECLARE_HOST_FUNCTION(jsPerformanceObserverPrototypeFunction_takeRecords);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceObserverConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPerformanceObserverConstructor_supportedEntryTypes);

class JSPerformanceObserverPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPerformanceObserverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPerformanceObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSPerformanceObserverPrototype>(vm)) JSPerformanceObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceObserverPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPerformanceObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPerformanceObserverPrototype, JSPerformanceObserverPrototype::Base);

using JSPerformanceObserverDOMConstructor = JSDOMConstructor<JSPerformanceObserver>;

/* Hash table for constructor */

static const std::array<HashTableValue, 1> JSPerformanceObserverConstructorTableValues {
    HashTableValue { "supportedEntryTypes"_s, static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly), NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceObserverConstructor_supportedEntryTypes, 0 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSPerformanceObserverDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSPerformanceObserverDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "PerformanceObserver"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callbackConversionResult = convert<IDLCallbackFunction<JSPerformanceObserverCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback"_s, "PerformanceObserver"_s, nullptr); });
    if (callbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = PerformanceObserver::create(*context, callbackConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<PerformanceObserver>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<PerformanceObserver>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSPerformanceObserverDOMConstructorConstruct, JSPerformanceObserverDOMConstructor::construct);

template<> const ClassInfo JSPerformanceObserverDOMConstructor::s_info = { "PerformanceObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceObserverDOMConstructor) };

template<> JSValue JSPerformanceObserverDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSPerformanceObserverDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PerformanceObserver"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPerformanceObserver::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSPerformanceObserver::info(), JSPerformanceObserverConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSPerformanceObserverPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPerformanceObserverConstructor, 0 } },
    HashTableValue { "observe"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPerformanceObserverPrototypeFunction_observe, 0 } },
    HashTableValue { "disconnect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPerformanceObserverPrototypeFunction_disconnect, 0 } },
    HashTableValue { "takeRecords"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsPerformanceObserverPrototypeFunction_takeRecords, 0 } },
};

const ClassInfo JSPerformanceObserverPrototype::s_info = { "PerformanceObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceObserverPrototype) };

void JSPerformanceObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPerformanceObserver::info(), JSPerformanceObserverPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPerformanceObserver::s_info = { "PerformanceObserver"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPerformanceObserver) };

JSPerformanceObserver::JSPerformanceObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PerformanceObserver>&& impl)
    : JSDOMWrapper<PerformanceObserver>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSPerformanceObserver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPerformanceObserverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSPerformanceObserverPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPerformanceObserver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPerformanceObserver>(vm, globalObject);
}

JSValue JSPerformanceObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceObserverDOMConstructor, DOMConstructorID::PerformanceObserver>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSPerformanceObserver::destroy(JSC::JSCell* cell)
{
    JSPerformanceObserver* thisObject = static_cast<JSPerformanceObserver*>(cell);
    thisObject->JSPerformanceObserver::~JSPerformanceObserver();
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceObserverConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPerformanceObserverPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPerformanceObserver::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsPerformanceObserverConstructor_supportedEntryTypesGetter(JSGlobalObject& lexicalGlobalObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return jsUndefined();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLDOMString>>(lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject), throwScope, PerformanceObserver::supportedEntryTypes(*context))));
}

JSC_DEFINE_CUSTOM_GETTER(jsPerformanceObserverConstructor_supportedEntryTypes, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPerformanceObserver>::getStatic<jsPerformanceObserverConstructor_supportedEntryTypesGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsPerformanceObserverPrototypeFunction_observeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPerformanceObserver>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<PerformanceObserver::Init>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.observe(optionsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPerformanceObserverPrototypeFunction_observe, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPerformanceObserver>::call<jsPerformanceObserverPrototypeFunction_observeBody>(*lexicalGlobalObject, *callFrame, "observe");
}

static inline JSC::EncodedJSValue jsPerformanceObserverPrototypeFunction_disconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPerformanceObserver>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.disconnect(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsPerformanceObserverPrototypeFunction_disconnect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPerformanceObserver>::call<jsPerformanceObserverPrototypeFunction_disconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

static inline JSC::EncodedJSValue jsPerformanceObserverPrototypeFunction_takeRecordsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSPerformanceObserver>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<PerformanceEntry>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.takeRecords())));
}

JSC_DEFINE_HOST_FUNCTION(jsPerformanceObserverPrototypeFunction_takeRecords, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSPerformanceObserver>::call<jsPerformanceObserverPrototypeFunction_takeRecordsBody>(*lexicalGlobalObject, *callFrame, "takeRecords");
}

JSC::GCClient::IsoSubspace* JSPerformanceObserver::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPerformanceObserver, UseCustomHeapCellType::No>(vm, "JSPerformanceObserver"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPerformanceObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPerformanceObserver = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPerformanceObserver.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPerformanceObserver = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSPerformanceObserver::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSPerformanceObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSPerformanceObserver);

template<typename Visitor>
void JSPerformanceObserver::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSPerformanceObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSPerformanceObserver::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSPerformanceObserver::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSPerformanceObserver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPerformanceObserver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

void JSPerformanceObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsPerformanceObserver = static_cast<JSPerformanceObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPerformanceObserver->protectedWrapped().ptr(), jsPerformanceObserver);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PerformanceObserver@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19PerformanceObserverE[]; }
#endif
template<std::same_as<PerformanceObserver> T>
static inline void verifyVTable(PerformanceObserver* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PerformanceObserver@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore19PerformanceObserverE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PerformanceObserver has subclasses. If PerformanceObserver has subclasses that get passed
        // to toJS() we currently require PerformanceObserver you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PerformanceObserver>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<PerformanceObserver>(impl.ptr());
#endif
    return createWrapper<PerformanceObserver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PerformanceObserver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

PerformanceObserver* JSPerformanceObserver::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSPerformanceObserver*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
