/*
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * Copyright (c) 2017 Canon Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableStreamBYOBReaderBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

constinit const JSC::ConstructAbility s_readableStreamBYOBReaderInitializeReadableStreamBYOBReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableStreamBYOBReaderInitializeReadableStreamBYOBReaderCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableStreamBYOBReaderInitializeReadableStreamBYOBReaderCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableStreamBYOBReaderInitializeReadableStreamBYOBReaderCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableStreamBYOBReaderInitializeReadableStreamBYOBReaderCodeLength = 766;
static constinit const JSC::Intrinsic s_readableStreamBYOBReaderInitializeReadableStreamBYOBReaderCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableStreamBYOBReaderInitializeReadableStreamBYOBReaderCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStream(stream)) {\n" \
    "        //\n" \
    "        let potentialInternalStream = @getInternalReadableStream(stream);\n" \
    "        if (potentialInternalStream === @undefined)\n" \
    "            @throwTypeError(\"ReadableStreamBYOBReader needs a ReadableStream\");\n" \
    "        stream = potentialInternalStream;\n" \
    "    }\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(@getByIdDirectPrivate(stream, \"readableStreamController\")))\n" \
    "        @throwTypeError(\"ReadableStreamBYOBReader needs a ReadableByteStreamController\");\n" \
    "    if (@isReadableStreamLocked(stream))\n" \
    "        @throwTypeError(\"ReadableStream is locked\");\n" \
    "\n" \
    "    @readableStreamReaderGenericInitialize(this, stream);\n" \
    "    @putByIdDirectPrivate(this, \"readIntoRequests\", []);\n" \
    "\n" \
    "    return this;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableStreamBYOBReaderCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableStreamBYOBReaderCancelCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableStreamBYOBReaderCancelCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableStreamBYOBReaderCancelCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableStreamBYOBReaderCancelCodeLength = 410;
static constinit const JSC::Intrinsic s_readableStreamBYOBReaderCancelCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableStreamBYOBReaderCancelCode =
    "(function (reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStreamBYOBReader(this))\n" \
    "        return @Promise.@reject(@makeThisTypeError(\"ReadableStreamBYOBReader\", \"cancel\"));\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(this, \"ownerReadableStream\"))\n" \
    "        return @Promise.@reject(@makeTypeError(\"cancel() called on a reader owned by no readable stream\"));\n" \
    "\n" \
    "    return @readableStreamReaderGenericCancel(this, reason);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableStreamBYOBReaderReadCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableStreamBYOBReaderReadCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableStreamBYOBReaderReadCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableStreamBYOBReaderReadCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableStreamBYOBReaderReadCodeLength = 762;
static constinit const JSC::Intrinsic s_readableStreamBYOBReaderReadCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableStreamBYOBReaderReadCode =
    "(function (view)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStreamBYOBReader(this))\n" \
    "        return @Promise.@reject(@makeThisTypeError(\"ReadableStreamBYOBReader\", \"read\"));\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(this, \"ownerReadableStream\"))\n" \
    "        return @Promise.@reject(@makeTypeError(\"read() called on a reader owned by no readable stream\"));\n" \
    "\n" \
    "    if (!@isObject(view))\n" \
    "        return @Promise.@reject(@makeTypeError(\"Provided view is not an object\"));\n" \
    "\n" \
    "    if (!@ArrayBuffer.@isView(view))\n" \
    "        return @Promise.@reject(@makeTypeError(\"Provided view is not an ArrayBufferView\"));\n" \
    "\n" \
    "    if (view.byteLength === 0)\n" \
    "        return @Promise.@reject(@makeTypeError(\"Provided view cannot have a 0 byteLength\"));\n" \
    "\n" \
    "    return @readableStreamBYOBReaderRead(this, view);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableStreamBYOBReaderReleaseLockCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableStreamBYOBReaderReleaseLockCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableStreamBYOBReaderReleaseLockCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableStreamBYOBReaderReleaseLockCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableStreamBYOBReaderReleaseLockCodeLength = 440;
static constinit const JSC::Intrinsic s_readableStreamBYOBReaderReleaseLockCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableStreamBYOBReaderReleaseLockCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStreamBYOBReader(this))\n" \
    "        throw @makeThisTypeError(\"ReadableStreamBYOBReader\", \"releaseLock\");\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(this, \"ownerReadableStream\"))\n" \
    "        return;\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(this, \"readIntoRequests\").length)\n" \
    "        @throwTypeError(\"There are still pending read requests, cannot release the lock\");\n" \
    "\n" \
    "    @readableStreamReaderGenericRelease(this);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableStreamBYOBReaderClosedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableStreamBYOBReaderClosedCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableStreamBYOBReaderClosedCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableStreamBYOBReaderClosedCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableStreamBYOBReaderClosedCodeLength = 250;
static constinit const JSC::Intrinsic s_readableStreamBYOBReaderClosedCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableStreamBYOBReaderClosedCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStreamBYOBReader(this))\n" \
    "        return @Promise.@reject(@makeGetterTypeError(\"ReadableStreamBYOBReader\", \"closed\"));\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"closedPromiseCapability\").promise;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = downcast<JSVMClientData>(vm.clientData); \
    return clientData->builtinFunctions().readableStreamBYOBReaderBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().readableStreamBYOBReaderBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_READABLESTREAMBYOBREADER_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
