// java wrapper for vtkWorldPointPicker object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkWorldPointPicker.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractPicker_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkWorldPointPicker_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkWorldPointPicker",dType)) { return me; }
  if ((res= vtkAbstractPicker_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWorldPointPicker_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWorldPointPicker* op = static_cast<vtkWorldPointPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWorldPointPicker_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWorldPointPicker* op = static_cast<vtkWorldPointPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWorldPointPicker_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWorldPointPicker* op = static_cast<vtkWorldPointPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWorldPointPicker_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWorldPointPicker* op = static_cast<vtkWorldPointPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWorldPointPicker_Pick_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jobject id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  vtkRenderer * temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id3));

  vtkWorldPointPicker* op = static_cast<vtkWorldPointPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWorldPointPicker_Pick_15(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkRenderer * temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkWorldPointPicker* op = static_cast<vtkWorldPointPicker*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Pick(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkWorldPointPicker_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkWorldPointPicker::New());
}
