// java wrapper for vtkImageSliceMapper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageSliceMapper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageMapper3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageSliceMapper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageSliceMapper",dType)) { return me; }
  if ((res= vtkImageMapper3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageSliceMapper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageSliceMapper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageSliceMapper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageSliceMapper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetSliceNumber_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceNumber(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageSliceMapper_GetSliceNumber_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceNumber();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageSliceMapper_GetSliceNumberMinValue_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceNumberMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageSliceMapper_GetSliceNumberMaxValue_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceNumberMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetOrientation_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageSliceMapper_GetOrientationMinValue_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageSliceMapper_GetOrientationMaxValue_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageSliceMapper_GetOrientation_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetOrientationToI_112(JNIEnv* env, jobject obj)
{

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientationToI();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetOrientationToJ_113(JNIEnv* env, jobject obj)
{

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientationToJ();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetOrientationToK_114(JNIEnv* env, jobject obj)
{

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientationToK();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetOrientationToX_115(JNIEnv* env, jobject obj)
{

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientationToX();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetOrientationToY_116(JNIEnv* env, jobject obj)
{

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientationToY();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetOrientationToZ_117(JNIEnv* env, jobject obj)
{

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientationToZ();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetCropping_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCropping(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_CroppingOn_119(JNIEnv* env, jobject obj)
{

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->CroppingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_CroppingOff_120(JNIEnv* env, jobject obj)
{

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->CroppingOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageSliceMapper_GetCropping_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCropping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetCroppingRegion_122(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCroppingRegion(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetCroppingRegion_123(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCroppingRegion(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageSliceMapper_GetCroppingRegion_124(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCroppingRegion();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_Render_125(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkImageSlice * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkImageSlice*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_ReleaseGraphicsResources_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageSliceMapper_GetMTime_127(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_GetBounds_128(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_GetIndexBounds_129(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetIndexBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_GetSlicePlaneInDataCoords_130(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1)
{
  vtkMatrix4x4 * temp0;
  double temp1[4];
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSlicePlaneInDataCoords(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 4, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageSliceMapper_SetDisplayExtent_131(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkImageSliceMapper* op = static_cast<vtkImageSliceMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayExtent(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageSliceMapper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageSliceMapper::New());
}
