// java wrapper for vtkAxisActor2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAxisActor2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkActor2D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAxisActor2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAxisActor2D",dType)) { return me; }
  if ((res= vtkActor2D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor2D_GetPoint1Coordinate_14(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint1Coordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetPoint1_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetPoint1_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor2D_GetPoint2Coordinate_17(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2Coordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetPoint2_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetPoint2_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetRange_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetRange_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxisActor2D_GetRange_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetRulerMode_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRulerMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetRulerMode_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRulerMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_RulerModeOn_115(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RulerModeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_RulerModeOff_116(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->RulerModeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetRulerDistance_117(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRulerDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetRulerDistanceMinValue_118(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRulerDistanceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetRulerDistanceMaxValue_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRulerDistanceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetRulerDistance_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRulerDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetNumberOfLabels_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfLabels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetNumberOfLabelsMinValue_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabelsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetNumberOfLabelsMaxValue_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabelsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetNumberOfLabels_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetPrecision_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetPrecisionMinValue_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPrecisionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetPrecisionMaxValue_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPrecisionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetPrecision_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPrecision();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetNotation_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNotation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetNotationMinValue_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNotationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetNotationMaxValue_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNotationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetNotation_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNotation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetLabelFormat_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelFormat(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxisActor2D_GetLabelFormat_134(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFormat();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetSnapLabelsToGrid_135(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSnapLabelsToGrid(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor2D_GetSnapLabelsToGrid_136(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSnapLabelsToGrid();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SnapLabelsToGridOn_137(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SnapLabelsToGridOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SnapLabelsToGridOff_138(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SnapLabelsToGridOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetAdjustLabels_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAdjustLabels(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetAdjustLabels_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_AdjustLabelsOn_141(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustLabelsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_AdjustLabelsOff_142(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AdjustLabelsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetSkipFirstTick_143(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSkipFirstTick(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAxisActor2D_GetSkipFirstTick_144(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSkipFirstTick();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SkipFirstTickOn_145(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SkipFirstTickOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SkipFirstTickOff_146(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SkipFirstTickOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_GetAdjustedRange_147(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetAdjustedRange(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetAdjustedNumberOfLabels_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAdjustedNumberOfLabels();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor2D_GetTickPositions_149(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickPositions();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetTitle_150(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitle(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAxisActor2D_GetTitle_151(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitle();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetTitleTextProperty_152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor2D_GetTitleTextProperty_153(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetLabelTextProperty_154(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxisActor2D_GetLabelTextProperty_155(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetTickLength_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickLength(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetTickLengthMinValue_157(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLengthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetTickLengthMaxValue_158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLengthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetTickLength_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetNumberOfMinorTicks_160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfMinorTicks(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetNumberOfMinorTicksMinValue_161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfMinorTicksMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetNumberOfMinorTicksMaxValue_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfMinorTicksMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetNumberOfMinorTicks_163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfMinorTicks();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetMinorTickLength_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinorTickLength(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetMinorTickLengthMinValue_165(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinorTickLengthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetMinorTickLengthMaxValue_166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinorTickLengthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetMinorTickLength_167(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinorTickLength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetTickOffset_168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickOffset(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetTickOffsetMinValue_169(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickOffsetMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetTickOffsetMaxValue_170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickOffsetMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetTickOffset_171(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickOffset();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetAxisVisibility_172(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxisVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetAxisVisibility_173(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxisVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_AxisVisibilityOn_174(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_AxisVisibilityOff_175(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxisVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetTickVisibility_176(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTickVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetTickVisibility_177(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTickVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_TickVisibilityOn_178(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TickVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_TickVisibilityOff_179(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TickVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetLabelVisibility_180(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetLabelVisibility_181(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_LabelVisibilityOn_182(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->LabelVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_LabelVisibilityOff_183(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->LabelVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetTitleVisibility_184(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitleVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetTitleVisibility_185(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitleVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_TitleVisibilityOn_186(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TitleVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_TitleVisibilityOff_187(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TitleVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetTitlePosition_188(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTitlePosition(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetTitlePosition_189(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTitlePosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetFontFactor_190(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFontFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetFontFactorMinValue_191(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontFactorMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetFontFactorMaxValue_192(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontFactorMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetFontFactor_193(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFontFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetLabelFactor_194(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetLabelFactorMinValue_195(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFactorMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetLabelFactorMaxValue_196(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFactorMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxisActor2D_GetLabelFactor_197(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelFactor();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_UpdateGeometryAndRenderOpaqueGeometry_198(JNIEnv* env, jobject obj,jobject id0,jboolean id1)
{
  vtkViewport * temp0;
  bool   temp1;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = (id1 != 0) ? true : false;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->UpdateGeometryAndRenderOpaqueGeometry(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_RenderOverlay_199(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOverlay(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_RenderOpaqueGeometry_1100(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_RenderTranslucentPolygonalGeometry_1101(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_HasTranslucentPolygonalGeometry_1102(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_ReleaseGraphicsResources_1103(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetSizeFontRelativeToAxis_1104(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSizeFontRelativeToAxis(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetSizeFontRelativeToAxis_1105(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSizeFontRelativeToAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SizeFontRelativeToAxisOn_1106(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SizeFontRelativeToAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SizeFontRelativeToAxisOff_1107(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SizeFontRelativeToAxisOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_SetUseFontSizeFromProperty_1108(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseFontSizeFromProperty(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxisActor2D_GetUseFontSizeFromProperty_1109(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseFontSizeFromProperty();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_UseFontSizeFromPropertyOn_1110(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseFontSizeFromPropertyOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_UseFontSizeFromPropertyOff_1111(JNIEnv* env, jobject obj)
{

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseFontSizeFromPropertyOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxisActor2D_ShallowCopy_1112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAxisActor2D* op = static_cast<vtkAxisActor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkAxisActor2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkAxisActor2D::New());
}
