// java wrapper for vtkGeneralizedKernel object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGeneralizedKernel.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkInterpolationKernel_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGeneralizedKernel_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGeneralizedKernel",dType)) { return me; }
  if ((res= vtkInterpolationKernel_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralizedKernel_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralizedKernel_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralizedKernel_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralizedKernel_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralizedKernel_ComputeBasis_14(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1,jlong id2)
{
  double temp0[3];
  vtkIdList * temp1;
  long long   temp2;
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeBasis(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralizedKernel_ComputeWeights_15(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1,jobject id2,jobject id3)
{
  double temp0[3];
  vtkIdList * temp1;
  vtkDoubleArray * temp2;
  vtkDoubleArray * temp3;
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeWeights(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeneralizedKernel_ComputeWeights_16(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1,jobject id2)
{
  double temp0[3];
  vtkIdList * temp1;
  vtkDoubleArray * temp2;
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeWeights(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralizedKernel_SetKernelFootprint_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKernelFootprint(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralizedKernel_GetKernelFootprint_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetKernelFootprint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralizedKernel_SetKernelFootprintToRadius_19(JNIEnv* env, jobject obj)
{

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKernelFootprintToRadius();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralizedKernel_SetKernelFootprintToNClosest_110(JNIEnv* env, jobject obj)
{

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetKernelFootprintToNClosest();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralizedKernel_SetRadius_111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGeneralizedKernel_GetRadiusMinValue_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGeneralizedKernel_GetRadiusMaxValue_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGeneralizedKernel_GetRadius_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralizedKernel_SetNumberOfPoints_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPoints(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralizedKernel_GetNumberOfPointsMinValue_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralizedKernel_GetNumberOfPointsMaxValue_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeneralizedKernel_GetNumberOfPoints_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralizedKernel_SetNormalizeWeights_119(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalizeWeights(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGeneralizedKernel_GetNormalizeWeights_120(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalizeWeights();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralizedKernel_NormalizeWeightsOn_121(JNIEnv* env, jobject obj)
{

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalizeWeightsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeneralizedKernel_NormalizeWeightsOff_122(JNIEnv* env, jobject obj)
{

  vtkGeneralizedKernel* op = static_cast<vtkGeneralizedKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->NormalizeWeightsOff();

}
