// java wrapper for vtkCoincidentPoints object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCoincidentPoints.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCoincidentPoints_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCoincidentPoints",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCoincidentPoints_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCoincidentPoints_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCoincidentPoints_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCoincidentPoints_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoincidentPoints_AddPoint_14(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddPoint(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCoincidentPoints_GetCoincidentPointIds_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  vtkIdList * temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoincidentPointIds(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCoincidentPoints_GetNextCoincidentPointIds_16(JNIEnv* env, jobject obj)
{
  vtkIdList * temp20;

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNextCoincidentPointIds();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoincidentPoints_InitTraversal_17(JNIEnv* env, jobject obj)
{

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitTraversal();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoincidentPoints_RemoveNonCoincidentPoints_18(JNIEnv* env, jobject obj)
{

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveNonCoincidentPoints();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoincidentPoints_Clear_19(JNIEnv* env, jobject obj)
{

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoincidentPoints_SpiralPoints_110(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkPoints * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id1));

  vtkCoincidentPoints* op = static_cast<vtkCoincidentPoints*>(vtkJavaGetPointerFromObject(env, obj));
  op->SpiralPoints(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCoincidentPoints_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCoincidentPoints::New());
}
