/** @file
 * VirtualBox API class wrapper code for IGuestFsInfo.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTFSINFO

#include "GuestFsInfoWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestFsInfoWrap)

//
// IFsInfo properties
//

STDMETHODIMP GuestFsInfoWrap::COMGETTER(FreeSize)(LONG64 *aFreeSize)
{
    LogRelFlow(("{%p} %s: enter aFreeSize=%p\n", this, "GuestFsInfo::getFreeSize", aFreeSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFreeSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_FREESIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFreeSize(aFreeSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_FREESIZE_RETURN(this, hrc, 0 /*normal*/,*aFreeSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_FREESIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aFreeSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_FREESIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aFreeSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFreeSize=%RI64 hrc=%Rhrc\n", this, "GuestFsInfo::getFreeSize", *aFreeSize, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(TotalSize)(LONG64 *aTotalSize)
{
    LogRelFlow(("{%p} %s: enter aTotalSize=%p\n", this, "GuestFsInfo::getTotalSize", aTotalSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTotalSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_TOTALSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTotalSize(aTotalSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_TOTALSIZE_RETURN(this, hrc, 0 /*normal*/,*aTotalSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_TOTALSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aTotalSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_TOTALSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aTotalSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTotalSize=%RI64 hrc=%Rhrc\n", this, "GuestFsInfo::getTotalSize", *aTotalSize, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(BlockSize)(ULONG *aBlockSize)
{
    LogRelFlow(("{%p} %s: enter aBlockSize=%p\n", this, "GuestFsInfo::getBlockSize", aBlockSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBlockSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_BLOCKSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBlockSize(aBlockSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_BLOCKSIZE_RETURN(this, hrc, 0 /*normal*/,*aBlockSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_BLOCKSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aBlockSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_BLOCKSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aBlockSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aBlockSize=%RU32 hrc=%Rhrc\n", this, "GuestFsInfo::getBlockSize", *aBlockSize, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(SectorSize)(ULONG *aSectorSize)
{
    LogRelFlow(("{%p} %s: enter aSectorSize=%p\n", this, "GuestFsInfo::getSectorSize", aSectorSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSectorSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SECTORSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSectorSize(aSectorSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SECTORSIZE_RETURN(this, hrc, 0 /*normal*/,*aSectorSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SECTORSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aSectorSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SECTORSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aSectorSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSectorSize=%RU32 hrc=%Rhrc\n", this, "GuestFsInfo::getSectorSize", *aSectorSize, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(SerialNumber)(ULONG *aSerialNumber)
{
    LogRelFlow(("{%p} %s: enter aSerialNumber=%p\n", this, "GuestFsInfo::getSerialNumber", aSerialNumber));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSerialNumber);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SERIALNUMBER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSerialNumber(aSerialNumber);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SERIALNUMBER_RETURN(this, hrc, 0 /*normal*/,*aSerialNumber);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SERIALNUMBER_RETURN(this, hrc, 1 /*hrc exception*/,*aSerialNumber);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SERIALNUMBER_RETURN(this, hrc, 9 /*unhandled exception*/,*aSerialNumber);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSerialNumber=%RU32 hrc=%Rhrc\n", this, "GuestFsInfo::getSerialNumber", *aSerialNumber, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(IsRemote)(BOOL *aIsRemote)
{
    LogRelFlow(("{%p} %s: enter aIsRemote=%p\n", this, "GuestFsInfo::getIsRemote", aIsRemote));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsRemote);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISREMOTE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsRemote(aIsRemote);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISREMOTE_RETURN(this, hrc, 0 /*normal*/,*aIsRemote != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISREMOTE_RETURN(this, hrc, 1 /*hrc exception*/,*aIsRemote != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISREMOTE_RETURN(this, hrc, 9 /*unhandled exception*/,*aIsRemote != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsRemote=%RTbool hrc=%Rhrc\n", this, "GuestFsInfo::getIsRemote", *aIsRemote, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(IsCaseSensitive)(BOOL *aIsCaseSensitive)
{
    LogRelFlow(("{%p} %s: enter aIsCaseSensitive=%p\n", this, "GuestFsInfo::getIsCaseSensitive", aIsCaseSensitive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsCaseSensitive);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISCASESENSITIVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsCaseSensitive(aIsCaseSensitive);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISCASESENSITIVE_RETURN(this, hrc, 0 /*normal*/,*aIsCaseSensitive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISCASESENSITIVE_RETURN(this, hrc, 1 /*hrc exception*/,*aIsCaseSensitive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISCASESENSITIVE_RETURN(this, hrc, 9 /*unhandled exception*/,*aIsCaseSensitive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsCaseSensitive=%RTbool hrc=%Rhrc\n", this, "GuestFsInfo::getIsCaseSensitive", *aIsCaseSensitive, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(IsReadOnly)(BOOL *aIsReadOnly)
{
    LogRelFlow(("{%p} %s: enter aIsReadOnly=%p\n", this, "GuestFsInfo::getIsReadOnly", aIsReadOnly));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsReadOnly);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISREADONLY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsReadOnly(aIsReadOnly);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISREADONLY_RETURN(this, hrc, 0 /*normal*/,*aIsReadOnly != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISREADONLY_RETURN(this, hrc, 1 /*hrc exception*/,*aIsReadOnly != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISREADONLY_RETURN(this, hrc, 9 /*unhandled exception*/,*aIsReadOnly != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsReadOnly=%RTbool hrc=%Rhrc\n", this, "GuestFsInfo::getIsReadOnly", *aIsReadOnly, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(IsCompressed)(BOOL *aIsCompressed)
{
    LogRelFlow(("{%p} %s: enter aIsCompressed=%p\n", this, "GuestFsInfo::getIsCompressed", aIsCompressed));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsCompressed);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISCOMPRESSED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsCompressed(aIsCompressed);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISCOMPRESSED_RETURN(this, hrc, 0 /*normal*/,*aIsCompressed != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISCOMPRESSED_RETURN(this, hrc, 1 /*hrc exception*/,*aIsCompressed != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_ISCOMPRESSED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIsCompressed != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsCompressed=%RTbool hrc=%Rhrc\n", this, "GuestFsInfo::getIsCompressed", *aIsCompressed, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(SupportsFileCompression)(BOOL *aSupportsFileCompression)
{
    LogRelFlow(("{%p} %s: enter aSupportsFileCompression=%p\n", this, "GuestFsInfo::getSupportsFileCompression", aSupportsFileCompression));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportsFileCompression);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SUPPORTSFILECOMPRESSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportsFileCompression(aSupportsFileCompression);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SUPPORTSFILECOMPRESSION_RETURN(this, hrc, 0 /*normal*/,*aSupportsFileCompression != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SUPPORTSFILECOMPRESSION_RETURN(this, hrc, 1 /*hrc exception*/,*aSupportsFileCompression != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_SUPPORTSFILECOMPRESSION_RETURN(this, hrc, 9 /*unhandled exception*/,*aSupportsFileCompression != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportsFileCompression=%RTbool hrc=%Rhrc\n", this, "GuestFsInfo::getSupportsFileCompression", *aSupportsFileCompression, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(MaxComponent)(ULONG *aMaxComponent)
{
    LogRelFlow(("{%p} %s: enter aMaxComponent=%p\n", this, "GuestFsInfo::getMaxComponent", aMaxComponent));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxComponent);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_MAXCOMPONENT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxComponent(aMaxComponent);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_MAXCOMPONENT_RETURN(this, hrc, 0 /*normal*/,*aMaxComponent);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_MAXCOMPONENT_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxComponent);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_MAXCOMPONENT_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxComponent);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxComponent=%RU32 hrc=%Rhrc\n", this, "GuestFsInfo::getMaxComponent", *aMaxComponent, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(Type)(BSTR *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "GuestFsInfo::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        BSTROutConverter TmpType(aType);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(TmpType.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,TmpType.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%ls hrc=%Rhrc\n", this, "GuestFsInfo::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(Label)(BSTR *aLabel)
{
    LogRelFlow(("{%p} %s: enter aLabel=%p\n", this, "GuestFsInfo::getLabel", aLabel));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLabel);
        BSTROutConverter TmpLabel(aLabel);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_LABEL_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLabel(TmpLabel.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_LABEL_RETURN(this, hrc, 0 /*normal*/,TmpLabel.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_LABEL_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_LABEL_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLabel=%ls hrc=%Rhrc\n", this, "GuestFsInfo::getLabel", *aLabel, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(MountPoint)(BSTR *aMountPoint)
{
    LogRelFlow(("{%p} %s: enter aMountPoint=%p\n", this, "GuestFsInfo::getMountPoint", aMountPoint));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMountPoint);
        BSTROutConverter TmpMountPoint(aMountPoint);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_MOUNTPOINT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMountPoint(TmpMountPoint.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_MOUNTPOINT_RETURN(this, hrc, 0 /*normal*/,TmpMountPoint.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_MOUNTPOINT_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFSINFO_GET_MOUNTPOINT_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMountPoint=%ls hrc=%Rhrc\n", this, "GuestFsInfo::getMountPoint", *aMountPoint, hrc));
    return hrc;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(InternalAndReservedAttribute1IFsInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(InternalAndReservedAttribute2IFsInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(InternalAndReservedAttribute3IFsInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(InternalAndReservedAttribute4IFsInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(InternalAndReservedAttribute5IFsInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(InternalAndReservedAttribute6IFsInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(InternalAndReservedAttribute7IFsInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFsInfoWrap::COMGETTER(InternalAndReservedAttribute8IFsInfo)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IGuestFsInfo properties
//

STDMETHODIMP GuestFsInfoWrap::COMGETTER(MidlDoesNotLikeEmptyInterfaces)(BOOL *aMidlDoesNotLikeEmptyInterfaces)
{
#if 0 /* This is a dummy attribute */
    LogRelFlow(("{%p} %s: enter aMidlDoesNotLikeEmptyInterfaces=%p\n", this, "GuestFsInfo::getMidlDoesNotLikeEmptyInterfaces", aMidlDoesNotLikeEmptyInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMidlDoesNotLikeEmptyInterfaces);
        
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMidlDoesNotLikeEmptyInterfaces(aMidlDoesNotLikeEmptyInterfaces);
        }
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
    }

    LogRelFlow(("{%p} %s: leave *aMidlDoesNotLikeEmptyInterfaces=%RTbool hrc=%Rhrc\n", this, "GuestFsInfo::getMidlDoesNotLikeEmptyInterfaces", *aMidlDoesNotLikeEmptyInterfaces, hrc));
    return hrc;
#else  /* dummy attribute */
    NOREF(aMidlDoesNotLikeEmptyInterfaces);
    return E_FAIL;
#endif /* dummy attribute */
}


//
// IFsInfo methods
//

//
// IGuestFsInfo methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestFsInfoWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestFsInfoWrap, IGuestFsInfo, IFsInfo)
#endif // VBOX_WITH_XPCOM
