/** @file
 * VirtualBox API class wrapper code for IDHCPGroupCondition.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_DHCPGROUPCONDITION

#include "DHCPGroupConditionWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DHCPGroupConditionWrap)

//
// IDHCPGroupCondition properties
//

STDMETHODIMP DHCPGroupConditionWrap::COMGETTER(Inclusive)(BOOL *aInclusive)
{
    LogRelFlow(("{%p} %s: enter aInclusive=%p\n", this, "DHCPGroupCondition::getInclusive", aInclusive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInclusive);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_INCLUSIVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInclusive(aInclusive);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_INCLUSIVE_RETURN(this, hrc, 0 /*normal*/,*aInclusive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_INCLUSIVE_RETURN(this, hrc, 1 /*hrc exception*/,*aInclusive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_INCLUSIVE_RETURN(this, hrc, 9 /*unhandled exception*/,*aInclusive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInclusive=%RTbool hrc=%Rhrc\n", this, "DHCPGroupCondition::getInclusive", *aInclusive, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConditionWrap::COMSETTER(Inclusive)(BOOL aInclusive)
{
    LogRelFlow(("{%p} %s: enter aInclusive=%RTbool\n", this, "DHCPGroupCondition::setInclusive", aInclusive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_INCLUSIVE_ENTER(this, aInclusive != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setInclusive(aInclusive != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_INCLUSIVE_RETURN(this, hrc, 0 /*normal*/,aInclusive != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_INCLUSIVE_RETURN(this, hrc, 1 /*hrc exception*/,aInclusive != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_INCLUSIVE_RETURN(this, hrc, 9 /*unhandled exception*/,aInclusive != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupCondition::setInclusive", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConditionWrap::COMGETTER(Type)(DHCPGroupConditionType_T *aType)
{
    LogRelFlow(("{%p} %s: enter aType=%p\n", this, "DHCPGroupCondition::getType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aType);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_TYPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_TYPE_RETURN(this, hrc, 0 /*normal*/,*aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,*aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aType=%RU32 hrc=%Rhrc\n", this, "DHCPGroupCondition::getType", *aType, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConditionWrap::COMSETTER(Type)(DHCPGroupConditionType_T aType)
{
    LogRelFlow(("{%p} %s: enter aType=%RU32\n", this, "DHCPGroupCondition::setType", aType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_TYPE_ENTER(this, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setType(aType);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_TYPE_RETURN(this, hrc, 0 /*normal*/,aType);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_TYPE_RETURN(this, hrc, 1 /*hrc exception*/,aType);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_TYPE_RETURN(this, hrc, 9 /*unhandled exception*/,aType);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupCondition::setType", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConditionWrap::COMGETTER(Value)(BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aValue=%p\n", this, "DHCPGroupCondition::getValue", aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);
        BSTROutConverter TmpValue(aValue);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_VALUE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getValue(TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_VALUE_RETURN(this, hrc, 0 /*normal*/,TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_VALUE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_GET_VALUE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValue=%ls hrc=%Rhrc\n", this, "DHCPGroupCondition::getValue", *aValue, hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConditionWrap::COMSETTER(Value)(IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s: enter aValue=%ls\n", this, "DHCPGroupCondition::setValue", aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_VALUE_ENTER(this, TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setValue(TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_VALUE_RETURN(this, hrc, 0 /*normal*/,TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_VALUE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_SET_VALUE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupCondition::setValue", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConditionWrap::COMGETTER(InternalAndReservedAttribute1IDHCPGroupCondition)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConditionWrap::COMGETTER(InternalAndReservedAttribute2IDHCPGroupCondition)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConditionWrap::COMGETTER(InternalAndReservedAttribute3IDHCPGroupCondition)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IDHCPGroupCondition methods
//

STDMETHODIMP DHCPGroupConditionWrap::Remove()
{
    LogRelFlow(("{%p} %s: enter\n", this, "DHCPGroupCondition::remove"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_REMOVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = remove();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_REMOVE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_REMOVE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGROUPCONDITION_REMOVE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGroupCondition::remove", hrc));
    return hrc;
}

STDMETHODIMP DHCPGroupConditionWrap::InternalAndReservedMethod1IDHCPGroupCondition()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConditionWrap::InternalAndReservedMethod2IDHCPGroupCondition()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGroupConditionWrap::InternalAndReservedMethod3IDHCPGroupCondition()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DHCPGroupConditionWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(DHCPGroupConditionWrap, IDHCPGroupCondition)
#endif // VBOX_WITH_XPCOM
