/** @file
 * VirtualBox API class wrapper code for IDHCPGlobalConfig.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_DHCPGLOBALCONFIG

#include "DHCPGlobalConfigWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DHCPGlobalConfigWrap)

//
// IDHCPConfig properties
//

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(Scope)(DHCPConfigScope_T *aScope)
{
    LogRelFlow(("{%p} %s: enter aScope=%p\n", this, "DHCPGlobalConfig::getScope", aScope));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aScope);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_SCOPE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getScope(aScope);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_SCOPE_RETURN(this, hrc, 0 /*normal*/,*aScope);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_SCOPE_RETURN(this, hrc, 1 /*hrc exception*/,*aScope);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_SCOPE_RETURN(this, hrc, 9 /*unhandled exception*/,*aScope);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aScope=%RU32 hrc=%Rhrc\n", this, "DHCPGlobalConfig::getScope", *aScope, hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(MinLeaseTime)(ULONG *aMinLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMinLeaseTime=%p\n", this, "DHCPGlobalConfig::getMinLeaseTime", aMinLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinLeaseTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_MINLEASETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinLeaseTime(aMinLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_MINLEASETIME_RETURN(this, hrc, 0 /*normal*/,*aMinLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_MINLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aMinLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_MINLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aMinLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinLeaseTime=%RU32 hrc=%Rhrc\n", this, "DHCPGlobalConfig::getMinLeaseTime", *aMinLeaseTime, hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMSETTER(MinLeaseTime)(ULONG aMinLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMinLeaseTime=%RU32\n", this, "DHCPGlobalConfig::setMinLeaseTime", aMinLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_MINLEASETIME_ENTER(this, aMinLeaseTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMinLeaseTime(aMinLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_MINLEASETIME_RETURN(this, hrc, 0 /*normal*/,aMinLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_MINLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,aMinLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_MINLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,aMinLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGlobalConfig::setMinLeaseTime", hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(DefaultLeaseTime)(ULONG *aDefaultLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aDefaultLeaseTime=%p\n", this, "DHCPGlobalConfig::getDefaultLeaseTime", aDefaultLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDefaultLeaseTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_DEFAULTLEASETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDefaultLeaseTime(aDefaultLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_DEFAULTLEASETIME_RETURN(this, hrc, 0 /*normal*/,*aDefaultLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_DEFAULTLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aDefaultLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_DEFAULTLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aDefaultLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDefaultLeaseTime=%RU32 hrc=%Rhrc\n", this, "DHCPGlobalConfig::getDefaultLeaseTime", *aDefaultLeaseTime, hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMSETTER(DefaultLeaseTime)(ULONG aDefaultLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aDefaultLeaseTime=%RU32\n", this, "DHCPGlobalConfig::setDefaultLeaseTime", aDefaultLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_DEFAULTLEASETIME_ENTER(this, aDefaultLeaseTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDefaultLeaseTime(aDefaultLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_DEFAULTLEASETIME_RETURN(this, hrc, 0 /*normal*/,aDefaultLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_DEFAULTLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,aDefaultLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_DEFAULTLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,aDefaultLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGlobalConfig::setDefaultLeaseTime", hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(MaxLeaseTime)(ULONG *aMaxLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMaxLeaseTime=%p\n", this, "DHCPGlobalConfig::getMaxLeaseTime", aMaxLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxLeaseTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_MAXLEASETIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxLeaseTime(aMaxLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_MAXLEASETIME_RETURN(this, hrc, 0 /*normal*/,*aMaxLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_MAXLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_MAXLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxLeaseTime=%RU32 hrc=%Rhrc\n", this, "DHCPGlobalConfig::getMaxLeaseTime", *aMaxLeaseTime, hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMSETTER(MaxLeaseTime)(ULONG aMaxLeaseTime)
{
    LogRelFlow(("{%p} %s: enter aMaxLeaseTime=%RU32\n", this, "DHCPGlobalConfig::setMaxLeaseTime", aMaxLeaseTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_MAXLEASETIME_ENTER(this, aMaxLeaseTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMaxLeaseTime(aMaxLeaseTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_MAXLEASETIME_RETURN(this, hrc, 0 /*normal*/,aMaxLeaseTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_MAXLEASETIME_RETURN(this, hrc, 1 /*hrc exception*/,aMaxLeaseTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_MAXLEASETIME_RETURN(this, hrc, 9 /*unhandled exception*/,aMaxLeaseTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGlobalConfig::setMaxLeaseTime", hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(ForcedOptions)(ComSafeArrayOut(DHCPOption_T, aForcedOptions))
{
    LogRelFlow(("{%p} %s: enter aForcedOptions=%p\n", this, "DHCPGlobalConfig::getForcedOptions", aForcedOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aForcedOptions);
        ArrayOutConverter<DHCPOption_T> TmpForcedOptions(ComSafeArrayOutArg(aForcedOptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_FORCEDOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getForcedOptions(TmpForcedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_FORCEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpForcedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_FORCEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_FORCEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aForcedOptions=%zu hrc=%Rhrc\n", this, "DHCPGlobalConfig::getForcedOptions", ComSafeArraySize(*aForcedOptions), hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMSETTER(ForcedOptions)(ComSafeArrayIn(DHCPOption_T, aForcedOptions))
{
    LogRelFlow(("{%p} %s: enter aForcedOptions=%zu\n", this, "DHCPGlobalConfig::setForcedOptions", ComSafeArraySize(aForcedOptions)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayInConverter<DHCPOption_T> TmpForcedOptions(ComSafeArrayInArg(aForcedOptions));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_FORCEDOPTIONS_ENTER(this, (uint32_t)TmpForcedOptions.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setForcedOptions(TmpForcedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_FORCEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpForcedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_FORCEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_FORCEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGlobalConfig::setForcedOptions", hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(SuppressedOptions)(ComSafeArrayOut(DHCPOption_T, aSuppressedOptions))
{
    LogRelFlow(("{%p} %s: enter aSuppressedOptions=%p\n", this, "DHCPGlobalConfig::getSuppressedOptions", aSuppressedOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSuppressedOptions);
        ArrayOutConverter<DHCPOption_T> TmpSuppressedOptions(ComSafeArrayOutArg(aSuppressedOptions));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_SUPPRESSEDOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSuppressedOptions(TmpSuppressedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSuppressedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSuppressedOptions=%zu hrc=%Rhrc\n", this, "DHCPGlobalConfig::getSuppressedOptions", ComSafeArraySize(*aSuppressedOptions), hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMSETTER(SuppressedOptions)(ComSafeArrayIn(DHCPOption_T, aSuppressedOptions))
{
    LogRelFlow(("{%p} %s: enter aSuppressedOptions=%zu\n", this, "DHCPGlobalConfig::setSuppressedOptions", ComSafeArraySize(aSuppressedOptions)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayInConverter<DHCPOption_T> TmpSuppressedOptions(ComSafeArrayInArg(aSuppressedOptions));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_SUPPRESSEDOPTIONS_ENTER(this, (uint32_t)TmpSuppressedOptions.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSuppressedOptions(TmpSuppressedOptions.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSuppressedOptions.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SET_SUPPRESSEDOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGlobalConfig::setSuppressedOptions", hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute1IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute2IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute3IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute4IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute5IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute6IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute7IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute8IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute9IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute10IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute11IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute12IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute13IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute14IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute15IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute16IDHCPConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IDHCPGlobalConfig properties
//

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute1IDHCPGlobalConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute2IDHCPGlobalConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute3IDHCPGlobalConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::COMGETTER(InternalAndReservedAttribute4IDHCPGlobalConfig)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IDHCPConfig methods
//

STDMETHODIMP DHCPGlobalConfigWrap::SetOption(DHCPOption_T aOption,
                                             DHCPOptionEncoding_T aEncoding,
                                             IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s: enter aOption=%RU32 aEncoding=%RU32 aValue=%ls\n", this, "DHCPGlobalConfig::setOption", aOption, aEncoding, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SETOPTION_ENTER(this, aOption, aEncoding, TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setOption(aOption,
                            aEncoding,
                            TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SETOPTION_RETURN(this, hrc, 0 /*normal*/, aOption, aEncoding, TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SETOPTION_RETURN(this, hrc, 1 /*hrc exception*/, aOption, aEncoding, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_SETOPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aOption, aEncoding, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGlobalConfig::setOption", hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::RemoveOption(DHCPOption_T aOption)
{
    LogRelFlow(("{%p} %s: enter aOption=%RU32\n", this, "DHCPGlobalConfig::removeOption", aOption));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVEOPTION_ENTER(this, aOption);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeOption(aOption);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVEOPTION_RETURN(this, hrc, 0 /*normal*/, aOption);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVEOPTION_RETURN(this, hrc, 1 /*hrc exception*/, aOption);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVEOPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aOption);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGlobalConfig::removeOption", hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::RemoveAllOptions()
{
    LogRelFlow(("{%p} %s: enter\n", this, "DHCPGlobalConfig::removeAllOptions"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVEALLOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeAllOptions();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVEALLOPTIONS_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVEALLOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVEALLOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGlobalConfig::removeAllOptions", hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::GetOption(DHCPOption_T aOption,
                                             DHCPOptionEncoding_T *aEncoding,
                                             BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aOption=%RU32 aEncoding=%p aValue=%p\n", this, "DHCPGlobalConfig::getOption", aOption, aEncoding, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEncoding);
        CheckComArgOutPointerValidThrow(aValue);


        
        
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GETOPTION_ENTER(this, aOption);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOption(aOption,
                            aEncoding,
                            TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GETOPTION_RETURN(this, hrc, 0 /*normal*/, aOption, *aEncoding, TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GETOPTION_RETURN(this, hrc, 1 /*hrc exception*/, aOption, *aEncoding, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GETOPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aOption, *aEncoding, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEncoding=%RU32 aValue=%ls hrc=%Rhrc\n", this, "DHCPGlobalConfig::getOption", *aEncoding, *aValue, hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::GetAllOptions(ComSafeArrayOut(DHCPOption_T, aOptions),
                                                 ComSafeArrayOut(DHCPOptionEncoding_T, aEncodings),
                                                 ComSafeArrayOut(BSTR, aValues))
{
    LogRelFlow(("{%p} %s: enter aOptions=%p aEncodings=%p aValues=%p\n", this, "DHCPGlobalConfig::getAllOptions", aOptions, aEncodings, aValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOptions);
        CheckComArgOutPointerValidThrow(aEncodings);
        CheckComArgOutPointerValidThrow(aValues);


        ArrayOutConverter<DHCPOption_T> TmpOptions(ComSafeArrayOutArg(aOptions));
        ArrayOutConverter<DHCPOptionEncoding_T> TmpEncodings(ComSafeArrayOutArg(aEncodings));
        ArrayBSTROutConverter TmpValues(ComSafeArrayOutArg(aValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GETALLOPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAllOptions(TmpOptions.array(),
                                TmpEncodings.array(),
                                TmpValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GETALLOPTIONS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpOptions.array().size(), NULL /*for now*/, (uint32_t)TmpEncodings.array().size(), NULL /*for now*/, (uint32_t)TmpValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GETALLOPTIONS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_GETALLOPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOptions=%zu *aEncodings=%zu aValues=%zu hrc=%Rhrc\n", this, "DHCPGlobalConfig::getAllOptions", ComSafeArraySize(*aOptions), ComSafeArraySize(*aEncodings), ComSafeArraySize(*aValues), hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::Remove()
{
    LogRelFlow(("{%p} %s: enter\n", this, "DHCPGlobalConfig::remove"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = remove();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DHCPGLOBALCONFIG_REMOVE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "DHCPGlobalConfig::remove", hrc));
    return hrc;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod1IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod2IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod3IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod4IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod5IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod6IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod7IDHCPConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod8IDHCPConfig()
{
    return E_NOTIMPL;
}

//
// IDHCPGlobalConfig methods
//

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod1IDHCPGlobalConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod2IDHCPGlobalConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod3IDHCPGlobalConfig()
{
    return E_NOTIMPL;
}

STDMETHODIMP DHCPGlobalConfigWrap::InternalAndReservedMethod4IDHCPGlobalConfig()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DHCPGlobalConfigWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(DHCPGlobalConfigWrap, IDHCPGlobalConfig, IDHCPConfig)
#endif // VBOX_WITH_XPCOM
