//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package azkeys

import "time"

// BackupKeyResult - The backup key result, containing the backup blob.
type BackupKeyResult struct {
	// READ-ONLY; The backup blob containing the backed up key.
	Value []byte `json:"value,omitempty" azure:"ro"`
}

// BackupKeyOptions contains the optional parameters for the Client.BackupKey method.
type BackupKeyOptions struct {
	// placeholder for future optional parameters
}

// CreateKeyOptions contains the optional parameters for the Client.CreateKey method.
type CreateKeyOptions struct {
	// placeholder for future optional parameters
}

// DecryptOptions contains the optional parameters for the Client.Decrypt method.
type DecryptOptions struct {
	// placeholder for future optional parameters
}

// DeleteKeyOptions contains the optional parameters for the Client.DeleteKey method.
type DeleteKeyOptions struct {
	// placeholder for future optional parameters
}

// EncryptOptions contains the optional parameters for the Client.Encrypt method.
type EncryptOptions struct {
	// placeholder for future optional parameters
}

// GetDeletedKeyOptions contains the optional parameters for the Client.GetDeletedKey method.
type GetDeletedKeyOptions struct {
	// placeholder for future optional parameters
}

// GetKeyOptions contains the optional parameters for the Client.GetKey method.
type GetKeyOptions struct {
	// placeholder for future optional parameters
}

// GetKeyRotationPolicyOptions contains the optional parameters for the Client.GetKeyRotationPolicy method.
type GetKeyRotationPolicyOptions struct {
	// placeholder for future optional parameters
}

// GetRandomBytesOptions contains the optional parameters for the Client.GetRandomBytes method.
type GetRandomBytesOptions struct {
	// placeholder for future optional parameters
}

// ImportKeyOptions contains the optional parameters for the Client.ImportKey method.
type ImportKeyOptions struct {
	// placeholder for future optional parameters
}

// ListDeletedKeysOptions contains the optional parameters for the Client.NewListDeletedKeysPager method.
type ListDeletedKeysOptions struct {
	// Maximum number of results to return in a page. If not specified the service will return up to 25 results.
	MaxResults *int32
}

// ListKeyVersionsOptions contains the optional parameters for the Client.NewListKeyVersionsPager method.
type ListKeyVersionsOptions struct {
	// Maximum number of results to return in a page. If not specified the service will return up to 25 results.
	MaxResults *int32
}

// ListKeysOptions contains the optional parameters for the Client.NewListKeysPager method.
type ListKeysOptions struct {
	// Maximum number of results to return in a page. If not specified the service will return up to 25 results.
	MaxResults *int32
}

// PurgeDeletedKeyOptions contains the optional parameters for the Client.PurgeDeletedKey method.
type PurgeDeletedKeyOptions struct {
	// placeholder for future optional parameters
}

// RecoverDeletedKeyOptions contains the optional parameters for the Client.RecoverDeletedKey method.
type RecoverDeletedKeyOptions struct {
	// placeholder for future optional parameters
}

// ReleaseOptions contains the optional parameters for the Client.Release method.
type ReleaseOptions struct {
	// placeholder for future optional parameters
}

// RestoreKeyOptions contains the optional parameters for the Client.RestoreKey method.
type RestoreKeyOptions struct {
	// placeholder for future optional parameters
}

// RotateKeyOptions contains the optional parameters for the Client.RotateKey method.
type RotateKeyOptions struct {
	// placeholder for future optional parameters
}

// SignOptions contains the optional parameters for the Client.Sign method.
type SignOptions struct {
	// placeholder for future optional parameters
}

// UnwrapKeyOptions contains the optional parameters for the Client.UnwrapKey method.
type UnwrapKeyOptions struct {
	// placeholder for future optional parameters
}

// UpdateKeyOptions contains the optional parameters for the Client.UpdateKey method.
type UpdateKeyOptions struct {
	// placeholder for future optional parameters
}

// UpdateKeyRotationPolicyOptions contains the optional parameters for the Client.UpdateKeyRotationPolicy method.
type UpdateKeyRotationPolicyOptions struct {
	// placeholder for future optional parameters
}

// VerifyOptions contains the optional parameters for the Client.Verify method.
type VerifyOptions struct {
	// placeholder for future optional parameters
}

// WrapKeyOptions contains the optional parameters for the Client.WrapKey method.
type WrapKeyOptions struct {
	// placeholder for future optional parameters
}

// CreateKeyParameters - The key create parameters.
type CreateKeyParameters struct {
	// REQUIRED; The type of key to create. For valid values, see JsonWebKeyType.
	Kty *JSONWebKeyType `json:"kty,omitempty"`

	// Elliptic curve name. For valid values, see JsonWebKeyCurveName.
	Curve *JSONWebKeyCurveName `json:"crv,omitempty"`

	// The attributes of a key managed by the key vault service.
	KeyAttributes *KeyAttributes         `json:"attributes,omitempty"`
	KeyOps        []*JSONWebKeyOperation `json:"key_ops,omitempty"`

	// The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize *int32 `json:"key_size,omitempty"`

	// The public exponent for a RSA key.
	PublicExponent *int32 `json:"public_exponent,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// DeletedKeyBundle - A DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion info
type DeletedKeyBundle struct {
	// The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`

	// The Json web key.
	Key *JSONWebKey `json:"key,omitempty"`

	// The url of the recovery object, used to identify and recover the deleted key.
	RecoveryID *string `json:"recoveryId,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The time when the key was deleted, in UTC
	DeletedDate *time.Time `json:"deletedDate,omitempty" azure:"ro"`

	// READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will
	// be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`

	// READ-ONLY; The time when the key is scheduled to be purged, in UTC
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`
}

// DeletedKeyItem - The deleted key item containing the deleted key metadata and information about deletion.
type DeletedKeyItem struct {
	// The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`

	// Key identifier.
	KID *ID `json:"kid,omitempty"`

	// The url of the recovery object, used to identify and recover the deleted key.
	RecoveryID *string `json:"recoveryId,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The time when the key was deleted, in UTC
	DeletedDate *time.Time `json:"deletedDate,omitempty" azure:"ro"`

	// READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will
	// be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`

	// READ-ONLY; The time when the key is scheduled to be purged, in UTC
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`
}

// DeletedKeyListResult - A list of keys that have been deleted in this vault.
type DeletedKeyListResult struct {
	// READ-ONLY; The URL to get the next set of deleted keys.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A response message containing a list of deleted keys in the vault along with a link to the next page of deleted
	// keys
	Value []*DeletedKeyItem `json:"value,omitempty" azure:"ro"`
}

// GetRandomBytesRequest - The get random bytes request object.
type GetRandomBytesRequest struct {
	// REQUIRED; The requested number of random bytes.
	Count *int32 `json:"count,omitempty"`
}

// ImportKeyParameters - The key import parameters.
type ImportKeyParameters struct {
	// REQUIRED; The Json web key
	Key *JSONWebKey `json:"key,omitempty"`

	// Whether to import as a hardware key (HSM) or software key.
	HSM *bool `json:"Hsm,omitempty"`

	// The key management attributes.
	KeyAttributes *KeyAttributes `json:"attributes,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// JSONWebKey - As of http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18
type JSONWebKey struct {
	// Elliptic curve name. For valid values, see JsonWebKeyCurveName.
	Crv *JSONWebKeyCurveName `json:"crv,omitempty"`

	// RSA private exponent, or the D component of an EC private key.
	D []byte `json:"d,omitempty"`

	// RSA private key parameter.
	DP []byte `json:"dp,omitempty"`

	// RSA private key parameter.
	DQ []byte `json:"dq,omitempty"`

	// RSA public exponent.
	E []byte `json:"e,omitempty"`

	// Symmetric key.
	K []byte `json:"k,omitempty"`

	// Key identifier.
	KID    *ID       `json:"kid,omitempty"`
	KeyOps []*string `json:"key_ops,omitempty"`

	// JsonWebKey Key Type (kty), as defined in https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40.
	Kty *JSONWebKeyType `json:"kty,omitempty"`

	// RSA modulus.
	N []byte `json:"n,omitempty"`

	// RSA secret prime.
	P []byte `json:"p,omitempty"`

	// RSA secret prime, with p < q.
	Q []byte `json:"q,omitempty"`

	// RSA private key parameter.
	QI []byte `json:"qi,omitempty"`

	// Protected Key, used with 'Bring Your Own Key'.
	T []byte `json:"key_hsm,omitempty"`

	// X component of an EC public key.
	X []byte `json:"x,omitempty"`

	// Y component of an EC public key.
	Y []byte `json:"y,omitempty"`
}

// KeyAttributes - The attributes of a key managed by the key vault service.
type KeyAttributes struct {
	// Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in UTC.
	Expires *time.Time `json:"exp,omitempty"`

	// Indicates if the private key can be exported. Release policy must be provided when creating the first version of an exportable
	// key.
	Exportable *bool `json:"exportable,omitempty"`

	// Not before date in UTC.
	NotBefore *time.Time `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in UTC.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
	RecoverableDays *int32 `json:"recoverableDays,omitempty" azure:"ro"`

	// READ-ONLY; Reflects the deletion recovery level currently in effect for keys in the current vault. If it contains 'Purgeable'
	// the key can be permanently deleted by a privileged user; otherwise, only the system
	// can purge the key, at the end of the retention interval.
	RecoveryLevel *DeletionRecoveryLevel `json:"recoveryLevel,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in UTC.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// KeyBundle - A KeyBundle consisting of a WebKey plus its attributes.
type KeyBundle struct {
	// The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`

	// The Json web key.
	Key *JSONWebKey `json:"key,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will
	// be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`
}

// KeyItem - The key item containing key metadata.
type KeyItem struct {
	// The key management attributes.
	Attributes *KeyAttributes `json:"attributes,omitempty"`

	// Key identifier.
	KID *ID `json:"kid,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; True if the key's lifetime is managed by key vault. If this is a key backing a certificate, then managed will
	// be true.
	Managed *bool `json:"managed,omitempty" azure:"ro"`
}

// KeyListResult - The key list result.
type KeyListResult struct {
	// READ-ONLY; The URL to get the next set of keys.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; A response message containing a list of keys in the key vault along with a link to the next page of keys.
	Value []*KeyItem `json:"value,omitempty" azure:"ro"`
}

// KeyOperationResult - The key operation result.
type KeyOperationResult struct {
	// READ-ONLY
	AdditionalAuthenticatedData []byte `json:"aad,omitempty" azure:"ro"`

	// READ-ONLY
	AuthenticationTag []byte `json:"tag,omitempty" azure:"ro"`

	// READ-ONLY
	IV []byte `json:"iv,omitempty" azure:"ro"`

	// READ-ONLY; Key identifier
	KID *ID `json:"kid,omitempty" azure:"ro"`

	// READ-ONLY
	Result []byte `json:"value,omitempty" azure:"ro"`
}

// KeyOperationsParameters - The key operations parameters.
type KeyOperationsParameters struct {
	// REQUIRED; algorithm identifier
	Algorithm *JSONWebKeyEncryptionAlgorithm `json:"alg,omitempty"`

	// REQUIRED
	Value []byte `json:"value,omitempty"`

	// Additional data to authenticate but not encrypt/decrypt when using authenticated crypto algorithms.
	AAD []byte `json:"aad,omitempty"`

	// Cryptographically random, non-repeating initialization vector for symmetric algorithms.
	IV []byte `json:"iv,omitempty"`

	// The tag to authenticate when performing decryption with an authenticated algorithm.
	Tag []byte `json:"tag,omitempty"`
}

// KeyReleasePolicy - The policy rules under which the key can be exported.
type KeyReleasePolicy struct {
	// Content type and version of key release policy
	ContentType *string `json:"contentType,omitempty"`

	// Blob encoding the policy rules under which the key can be released. Blob must be base64 URL encoded.
	EncodedPolicy []byte `json:"data,omitempty"`

	// Defines the mutability state of the policy. Once marked immutable, this flag cannot be reset and the policy cannot be changed
	// under any circumstances.
	Immutable *bool `json:"immutable,omitempty"`
}

// KeyReleaseResult - The release result, containing the released key.
type KeyReleaseResult struct {
	// READ-ONLY; A signed object containing the released key.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// KeyRotationPolicy - Management policy for a key.
type KeyRotationPolicy struct {
	// The key rotation policy attributes.
	Attributes *KeyRotationPolicyAttributes `json:"attributes,omitempty"`

	// Actions that will be performed by Key Vault over the lifetime of a key. For preview, lifetimeActions can only have two
	// items at maximum: one for rotate, one for notify. Notification time would be
	// default to 30 days before expiry and it is not configurable.
	LifetimeActions []*LifetimeActions `json:"lifetimeActions,omitempty"`

	// READ-ONLY; The key policy id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// KeyRotationPolicyAttributes - The key rotation policy attributes.
type KeyRotationPolicyAttributes struct {
	// The expiryTime will be applied on the new key version. It should be at least 28 days. It will be in ISO 8601 Format. Examples:
	// 90 days: P90D, 3 months: P3M, 48 hours: PT48H, 1 year and 10 days: P1Y10D
	ExpiryTime *string `json:"expiryTime,omitempty"`

	// READ-ONLY; The key rotation policy created time in UTC.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; The key rotation policy's last updated time in UTC.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// KeyVerifyResult - The key verify result.
type KeyVerifyResult struct {
	// READ-ONLY; True if the signature is verified, otherwise false.
	Value *bool `json:"value,omitempty" azure:"ro"`
}

// LifetimeActions - Action and its trigger that will be performed by Key Vault over the lifetime of a key.
type LifetimeActions struct {
	// The action that will be executed.
	Action *LifetimeActionsType `json:"action,omitempty"`

	// The condition that will execute the action.
	Trigger *LifetimeActionsTrigger `json:"trigger,omitempty"`
}

// LifetimeActionsTrigger - A condition to be satisfied for an action to be executed.
type LifetimeActionsTrigger struct {
	// Time after creation to attempt to rotate. It only applies to rotate. It will be in ISO 8601 duration format. Example: 90
	// days : "P90D"
	TimeAfterCreate *string `json:"timeAfterCreate,omitempty"`

	// Time before expiry to attempt to rotate or notify. It will be in ISO 8601 duration format. Example: 90 days : "P90D"
	TimeBeforeExpiry *string `json:"timeBeforeExpiry,omitempty"`
}

// LifetimeActionsType - The action that will be executed.
type LifetimeActionsType struct {
	// The type of the action.
	Type *KeyRotationPolicyAction `json:"type,omitempty"`
}

// RandomBytes - The get random bytes response object containing the bytes.
type RandomBytes struct {
	// REQUIRED; The bytes encoded as a base64url string.
	Value []byte `json:"value,omitempty"`
}

// ReleaseParameters - The release key parameters.
type ReleaseParameters struct {
	// REQUIRED; The attestation assertion for the target of the key release.
	TargetAttestationToken *string `json:"target,omitempty"`

	// The encryption algorithm to use to protected the exported key material
	Enc *KeyEncryptionAlgorithm `json:"enc,omitempty"`

	// A client provided nonce for freshness.
	Nonce *string `json:"nonce,omitempty"`
}

// RestoreKeyParameters - The key restore parameters.
type RestoreKeyParameters struct {
	// REQUIRED; The backup blob associated with a key bundle.
	KeyBundleBackup []byte `json:"value,omitempty"`
}

// SignParameters - The key operations parameters.
type SignParameters struct {
	// REQUIRED; The signing/verification algorithm identifier. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm.
	Algorithm *JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`

	// REQUIRED
	Value []byte `json:"value,omitempty"`
}

// UpdateKeyParameters - The key update parameters.
type UpdateKeyParameters struct {
	// The attributes of a key managed by the key vault service.
	KeyAttributes *KeyAttributes `json:"attributes,omitempty"`

	// Json web key operations. For more information on possible key operations, see JsonWebKeyOperation.
	KeyOps []*JSONWebKeyOperation `json:"key_ops,omitempty"`

	// The policy rules under which the key can be exported.
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VerifyParameters - The key verify parameters.
type VerifyParameters struct {
	// REQUIRED; The signing/verification algorithm. For more information on possible algorithm types, see JsonWebKeySignatureAlgorithm.
	Algorithm *JSONWebKeySignatureAlgorithm `json:"alg,omitempty"`

	// REQUIRED; The digest used for signing.
	Digest []byte `json:"digest,omitempty"`

	// REQUIRED; The signature to be verified.
	Signature []byte `json:"value,omitempty"`
}
