//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/usdImaging/usdImaging/usdRenderSettingsSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(UsdImagingUsdRenderSettingsSchemaTokens,
    USD_IMAGING_USD_RENDER_SETTINGS_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdVec2iDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetResolution() const
{
    return _GetTypedDataSource<HdVec2iDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->resolution);
}

HdFloatDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetPixelAspectRatio() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->pixelAspectRatio);
}

HdTokenDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetAspectRatioConformPolicy() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->aspectRatioConformPolicy);
}

HdVec4fDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetDataWindowNDC() const
{
    return _GetTypedDataSource<HdVec4fDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->dataWindowNDC);
}

HdBoolDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetDisableMotionBlur() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->disableMotionBlur);
}

HdBoolDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetDisableDepthOfField() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->disableDepthOfField);
}

HdPathDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetCamera() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->camera);
}

HdTokenArrayDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetIncludedPurposes() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->includedPurposes);
}

HdTokenArrayDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetMaterialBindingPurposes() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->materialBindingPurposes);
}

HdTokenDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetRenderingColorSpace() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->renderingColorSpace);
}

HdPathArrayDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetProducts() const
{
    return _GetTypedDataSource<HdPathArrayDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->products);
}

HdContainerDataSourceHandle
UsdImagingUsdRenderSettingsSchema::GetNamespacedSettings() const
{
    return _GetTypedDataSource<HdContainerDataSource>(
        UsdImagingUsdRenderSettingsSchemaTokens->namespacedSettings);
}

/*static*/
HdContainerDataSourceHandle
UsdImagingUsdRenderSettingsSchema::BuildRetained(
        const HdVec2iDataSourceHandle &resolution,
        const HdFloatDataSourceHandle &pixelAspectRatio,
        const HdTokenDataSourceHandle &aspectRatioConformPolicy,
        const HdVec4fDataSourceHandle &dataWindowNDC,
        const HdBoolDataSourceHandle &disableMotionBlur,
        const HdBoolDataSourceHandle &disableDepthOfField,
        const HdPathDataSourceHandle &camera,
        const HdTokenArrayDataSourceHandle &includedPurposes,
        const HdTokenArrayDataSourceHandle &materialBindingPurposes,
        const HdTokenDataSourceHandle &renderingColorSpace,
        const HdPathArrayDataSourceHandle &products,
        const HdContainerDataSourceHandle &namespacedSettings
)
{
    TfToken _names[12];
    HdDataSourceBaseHandle _values[12];

    size_t _count = 0;

    if (resolution) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->resolution;
        _values[_count++] = resolution;
    }

    if (pixelAspectRatio) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->pixelAspectRatio;
        _values[_count++] = pixelAspectRatio;
    }

    if (aspectRatioConformPolicy) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->aspectRatioConformPolicy;
        _values[_count++] = aspectRatioConformPolicy;
    }

    if (dataWindowNDC) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->dataWindowNDC;
        _values[_count++] = dataWindowNDC;
    }

    if (disableMotionBlur) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->disableMotionBlur;
        _values[_count++] = disableMotionBlur;
    }

    if (disableDepthOfField) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->disableDepthOfField;
        _values[_count++] = disableDepthOfField;
    }

    if (camera) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->camera;
        _values[_count++] = camera;
    }

    if (includedPurposes) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->includedPurposes;
        _values[_count++] = includedPurposes;
    }

    if (materialBindingPurposes) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->materialBindingPurposes;
        _values[_count++] = materialBindingPurposes;
    }

    if (renderingColorSpace) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->renderingColorSpace;
        _values[_count++] = renderingColorSpace;
    }

    if (products) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->products;
        _values[_count++] = products;
    }

    if (namespacedSettings) {
        _names[_count] = UsdImagingUsdRenderSettingsSchemaTokens->namespacedSettings;
        _values[_count++] = namespacedSettings;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetResolution(
    const HdVec2iDataSourceHandle &resolution)
{
    _resolution = resolution;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetPixelAspectRatio(
    const HdFloatDataSourceHandle &pixelAspectRatio)
{
    _pixelAspectRatio = pixelAspectRatio;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetAspectRatioConformPolicy(
    const HdTokenDataSourceHandle &aspectRatioConformPolicy)
{
    _aspectRatioConformPolicy = aspectRatioConformPolicy;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetDataWindowNDC(
    const HdVec4fDataSourceHandle &dataWindowNDC)
{
    _dataWindowNDC = dataWindowNDC;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetDisableMotionBlur(
    const HdBoolDataSourceHandle &disableMotionBlur)
{
    _disableMotionBlur = disableMotionBlur;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetDisableDepthOfField(
    const HdBoolDataSourceHandle &disableDepthOfField)
{
    _disableDepthOfField = disableDepthOfField;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetCamera(
    const HdPathDataSourceHandle &camera)
{
    _camera = camera;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetIncludedPurposes(
    const HdTokenArrayDataSourceHandle &includedPurposes)
{
    _includedPurposes = includedPurposes;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetMaterialBindingPurposes(
    const HdTokenArrayDataSourceHandle &materialBindingPurposes)
{
    _materialBindingPurposes = materialBindingPurposes;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetRenderingColorSpace(
    const HdTokenDataSourceHandle &renderingColorSpace)
{
    _renderingColorSpace = renderingColorSpace;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetProducts(
    const HdPathArrayDataSourceHandle &products)
{
    _products = products;
    return *this;
}

UsdImagingUsdRenderSettingsSchema::Builder &
UsdImagingUsdRenderSettingsSchema::Builder::SetNamespacedSettings(
    const HdContainerDataSourceHandle &namespacedSettings)
{
    _namespacedSettings = namespacedSettings;
    return *this;
}

HdContainerDataSourceHandle
UsdImagingUsdRenderSettingsSchema::Builder::Build()
{
    return UsdImagingUsdRenderSettingsSchema::BuildRetained(
        _resolution,
        _pixelAspectRatio,
        _aspectRatioConformPolicy,
        _dataWindowNDC,
        _disableMotionBlur,
        _disableDepthOfField,
        _camera,
        _includedPurposes,
        _materialBindingPurposes,
        _renderingColorSpace,
        _products,
        _namespacedSettings
    );
}

/*static*/
UsdImagingUsdRenderSettingsSchema
UsdImagingUsdRenderSettingsSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return UsdImagingUsdRenderSettingsSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                UsdImagingUsdRenderSettingsSchemaTokens->__usdRenderSettings))
        : nullptr);
}

/*static*/
const TfToken &
UsdImagingUsdRenderSettingsSchema::GetSchemaToken()
{
    return UsdImagingUsdRenderSettingsSchemaTokens->__usdRenderSettings;
}

/*static*/
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetResolutionLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->resolution);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetPixelAspectRatioLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->pixelAspectRatio);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetAspectRatioConformPolicyLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->aspectRatioConformPolicy);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetDataWindowNDCLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->dataWindowNDC);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetDisableMotionBlurLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->disableMotionBlur);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetDisableDepthOfFieldLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->disableDepthOfField);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetCameraLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->camera);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetIncludedPurposesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->includedPurposes);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetMaterialBindingPurposesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->materialBindingPurposes);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetRenderingColorSpaceLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->renderingColorSpace);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetProductsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->products);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdImagingUsdRenderSettingsSchema::GetNamespacedSettingsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdImagingUsdRenderSettingsSchemaTokens->namespacedSettings);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE