/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	resourcev1 "k8s.io/api/resource/v1"
	resource "k8s.io/apimachinery/pkg/api/resource"
	types "k8s.io/apimachinery/pkg/types"
)

// DeviceRequestAllocationResultApplyConfiguration represents a declarative configuration of the DeviceRequestAllocationResult type for use
// with apply.
//
// DeviceRequestAllocationResult contains the allocation result for one request.
type DeviceRequestAllocationResultApplyConfiguration struct {
	// Request is the name of the request in the claim which caused this
	// device to be allocated. If it references a subrequest in the
	// firstAvailable list on a DeviceRequest, this field must
	// include both the name of the main request and the subrequest
	// using the format <main request>/<subrequest>.
	//
	// Multiple devices may have been allocated per request.
	Request *string `json:"request,omitempty"`
	// Driver specifies the name of the DRA driver whose kubelet
	// plugin should be invoked to process the allocation once the claim is
	// needed on a node.
	//
	// Must be a DNS subdomain and should end with a DNS domain owned by the
	// vendor of the driver. It should use only lower case characters.
	Driver *string `json:"driver,omitempty"`
	// This name together with the driver name and the device name field
	// identify which device was allocated (`<driver name>/<pool name>/<device name>`).
	//
	// Must not be longer than 253 characters and may contain one or more
	// DNS sub-domains separated by slashes.
	Pool *string `json:"pool,omitempty"`
	// Device references one device instance via its name in the driver's
	// resource pool. It must be a DNS label.
	Device *string `json:"device,omitempty"`
	// AdminAccess indicates that this device was allocated for
	// administrative access. See the corresponding request field
	// for a definition of mode.
	//
	// This is an alpha field and requires enabling the DRAAdminAccess
	// feature gate. Admin access is disabled if this field is unset or
	// set to false, otherwise it is enabled.
	AdminAccess *bool `json:"adminAccess,omitempty"`
	// A copy of all tolerations specified in the request at the time
	// when the device got allocated.
	//
	// The maximum number of tolerations is 16.
	//
	// This is an alpha field and requires enabling the DRADeviceTaints
	// feature gate.
	Tolerations []DeviceTolerationApplyConfiguration `json:"tolerations,omitempty"`
	// BindingConditions contains a copy of the BindingConditions
	// from the corresponding ResourceSlice at the time of allocation.
	//
	// This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus
	// feature gates.
	BindingConditions []string `json:"bindingConditions,omitempty"`
	// BindingFailureConditions contains a copy of the BindingFailureConditions
	// from the corresponding ResourceSlice at the time of allocation.
	//
	// This is an alpha field and requires enabling the DRADeviceBindingConditions and DRAResourceClaimDeviceStatus
	// feature gates.
	BindingFailureConditions []string `json:"bindingFailureConditions,omitempty"`
	// ShareID uniquely identifies an individual allocation share of the device,
	// used when the device supports multiple simultaneous allocations.
	// It serves as an additional map key to differentiate concurrent shares
	// of the same device.
	ShareID *types.UID `json:"shareID,omitempty"`
	// ConsumedCapacity tracks the amount of capacity consumed per device as part of the claim request.
	// The consumed amount may differ from the requested amount: it is rounded up to the nearest valid
	// value based on the device’s requestPolicy if applicable (i.e., may not be less than the requested amount).
	//
	// The total consumed capacity for each device must not exceed the DeviceCapacity's Value.
	//
	// This field is populated only for devices that allow multiple allocations.
	// All capacity entries are included, even if the consumed amount is zero.
	ConsumedCapacity map[resourcev1.QualifiedName]resource.Quantity `json:"consumedCapacity,omitempty"`
}

// DeviceRequestAllocationResultApplyConfiguration constructs a declarative configuration of the DeviceRequestAllocationResult type for use with
// apply.
func DeviceRequestAllocationResult() *DeviceRequestAllocationResultApplyConfiguration {
	return &DeviceRequestAllocationResultApplyConfiguration{}
}

// WithRequest sets the Request field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Request field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithRequest(value string) *DeviceRequestAllocationResultApplyConfiguration {
	b.Request = &value
	return b
}

// WithDriver sets the Driver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Driver field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithDriver(value string) *DeviceRequestAllocationResultApplyConfiguration {
	b.Driver = &value
	return b
}

// WithPool sets the Pool field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Pool field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithPool(value string) *DeviceRequestAllocationResultApplyConfiguration {
	b.Pool = &value
	return b
}

// WithDevice sets the Device field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Device field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithDevice(value string) *DeviceRequestAllocationResultApplyConfiguration {
	b.Device = &value
	return b
}

// WithAdminAccess sets the AdminAccess field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AdminAccess field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithAdminAccess(value bool) *DeviceRequestAllocationResultApplyConfiguration {
	b.AdminAccess = &value
	return b
}

// WithTolerations adds the given value to the Tolerations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Tolerations field.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithTolerations(values ...*DeviceTolerationApplyConfiguration) *DeviceRequestAllocationResultApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTolerations")
		}
		b.Tolerations = append(b.Tolerations, *values[i])
	}
	return b
}

// WithBindingConditions adds the given value to the BindingConditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BindingConditions field.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithBindingConditions(values ...string) *DeviceRequestAllocationResultApplyConfiguration {
	for i := range values {
		b.BindingConditions = append(b.BindingConditions, values[i])
	}
	return b
}

// WithBindingFailureConditions adds the given value to the BindingFailureConditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BindingFailureConditions field.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithBindingFailureConditions(values ...string) *DeviceRequestAllocationResultApplyConfiguration {
	for i := range values {
		b.BindingFailureConditions = append(b.BindingFailureConditions, values[i])
	}
	return b
}

// WithShareID sets the ShareID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ShareID field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithShareID(value types.UID) *DeviceRequestAllocationResultApplyConfiguration {
	b.ShareID = &value
	return b
}

// WithConsumedCapacity puts the entries into the ConsumedCapacity field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the ConsumedCapacity field,
// overwriting an existing map entries in ConsumedCapacity field with the same key.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithConsumedCapacity(entries map[resourcev1.QualifiedName]resource.Quantity) *DeviceRequestAllocationResultApplyConfiguration {
	if b.ConsumedCapacity == nil && len(entries) > 0 {
		b.ConsumedCapacity = make(map[resourcev1.QualifiedName]resource.Quantity, len(entries))
	}
	for k, v := range entries {
		b.ConsumedCapacity[k] = v
	}
	return b
}
