// Copyright 2016 Emilie Gillet.
//
// Author: Emilie Gillet (emilie.o.gillet@gmail.com)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
// 
// See http://creativecommons.org/licenses/MIT/ for more information.
//
// -----------------------------------------------------------------------------
//
// LPC10 encoded words extracted from various TI ROMs.

#include "plaits/dsp/speech/lpc_speech_synth_words.h"

namespace plaits {

/* extern */
const uint8_t bank_0[] = {
  // red
  0x30, 0x4a, 0x57, 0xd8, 0x23, 0x2c, 0xc9, 0xa9,
  0x62, 0xa1, 0x88, 0xb2, 0x36, 0xa7, 0xca, 0x95,
  0xc3, 0xc3, 0x66, 0x9f, 0xb2, 0x64, 0x09, 0x4f,
  0x9b, 0x7d, 0x8a, 0x52, 0x24, 0x35, 0xb3, 0xec,
  0xc9, 0x6b, 0x92, 0xb2, 0xe8, 0xb0, 0x27, 0xcf,
  0x41, 0x2a, 0x63, 0xcc, 0x9e, 0x22, 0x3b, 0x8d,
  0xf2, 0x0e, 0x7b, 0xca, 0x1c, 0x34, 0xca, 0xda,
  0xec, 0x29, 0xb3, 0xb7, 0x28, 0x6b, 0xb3, 0xa7,
  0xce, 0xc1, 0xbc, 0xb2, 0xad, 0x9e, 0x2e, 0x05,
  0xcd, 0x8c, 0x96, 0x7a, 0xfa, 0xe4, 0xcd, 0x3b,
  0xd3, 0xcc, 0xe9, 0x8b, 0x76, 0xab, 0xa8, 0xd2,
  0x67, 0xac, 0x5e, 0xdc, 0x63, 0xe2, 0x9c, 0xa9,
  0x45, 0x71, 0xd3, 0x8e, 0x72, 0xa6, 0xee, 0x44,
  0x43, 0x6a, 0x2a, 0xc0, 0x98, 0x07, 0x0b, 0xb5,
  0xb0, 0x38, 0x6d, 0xae, 0x5a, 0x38, 0x7d, 0x8a,
  0x00, 0x00, 0xfc,
  // orange
  0xa3, 0x0d, 0xa3, 0x9a, 0x39, 0x23, 0x9f, 0xcc,
  0xd7, 0x0d, 0x57, 0x8b, 0x73, 0x92, 0x50, 0x2e,
  0x8d, 0xad, 0xc9, 0x89, 0x43, 0x99, 0x74, 0x8c,
  0xba, 0x23, 0xf6, 0xc3, 0xd3, 0xc8, 0x1b, 0x8d,
  0xc4, 0x4f, 0xb7, 0x64, 0x9d, 0x3c, 0x92, 0x30,
  0x92, 0x4b, 0x69, 0xf2, 0xc8, 0xc2, 0x54, 0x69,
  0x91, 0x39, 0xab, 0x08, 0xc3, 0xa9, 0x8c, 0xeb,
  0x8e, 0x3a, 0x4e, 0xaa, 0xc2, 0x2c, 0xd3, 0xda,
  0x38, 0xb0, 0x92, 0xb3, 0xe8, 0xe8, 0x63, 0xa3,
  0x0a, 0x8d, 0x30, 0xa3, 0x4f, 0x85, 0xda, 0x3d,
  0x83, 0xac, 0x21, 0x67, 0x6a, 0xb3, 0x0a, 0xb3,
  0x86, 0x92, 0xb0, 0xdc, 0x33, 0xcc, 0x18, 0xb3,
  0xa3, 0x8c, 0xd6, 0xc0, 0x6b, 0x2c, 0x01, 0xd3,
  0x3a, 0x2d, 0x8d, 0x29, 0x4b, 0x4a, 0x5d, 0xb5,
  0x5c, 0x66, 0xcb, 0x6d, 0xd9, 0x2c, 0x49, 0x99,
  0x8d, 0xb4, 0xd1, 0x34, 0x36, 0x69, 0xe1, 0xc6,
  0x2a, 0xd2, 0x91, 0xa4, 0x95, 0x1b, 0xcf, 0xce,
  0x82, 0xdb, 0xd6, 0x28, 0x39, 0xbc, 0xc5, 0xb1,
  0x03, 0x02, 0xe5, 0x48, 0xc0, 0x0c, 0x42, 0x0e,
  0x18, 0xa7, 0x4b, 0x01, 0x73, 0xa7, 0x01, 0x00,
  0xfc,
  // yellow
  0xa9, 0xda, 0x94, 0xdc, 0x32, 0xe4, 0xb6, 0xaa,
  0x03, 0xf2, 0xe8, 0xb2, 0x3b, 0x8a, 0x01, 0xb8,
  0xb2, 0xc7, 0xea, 0xca, 0x33, 0x36, 0xef, 0x0e,
  0x31, 0x27, 0x2f, 0x92, 0x3d, 0x3b, 0xa5, 0x9c,
  0xac, 0x78, 0xca, 0xae, 0xb0, 0x7c, 0xb2, 0x1a,
  0x39, 0x23, 0xd3, 0xca, 0xc9, 0x4a, 0x96, 0x28,
  0x6b, 0x2b, 0x27, 0xcb, 0x59, 0x33, 0xac, 0xc2,
  0x9c, 0x3c, 0x57, 0x2b, 0xb3, 0xb6, 0x72, 0xf2,
  0xd4, 0x2c, 0xdd, 0x2a, 0xcc, 0xca, 0x63, 0x4e,
  0x37, 0x8d, 0x28, 0xad, 0x08, 0x3e, 0x9a, 0xa4,
  0x23, 0x8f, 0x3a, 0xd4, 0x0a, 0xe6, 0xae, 0xdc,
  0x6a, 0x5f, 0xcb, 0x59, 0x3a, 0xca, 0x68, 0x43,
  0x19, 0x55, 0xa9, 0xb2, 0xa3, 0x0b, 0x3d, 0xd5,
  0x3c, 0xa3, 0xae, 0x2e, 0x94, 0x51, 0xf3, 0x8a,
  0xb2, 0xfa, 0x58, 0xd3, 0xdc, 0x2a, 0xec, 0xe9,
  0x53, 0x8a, 0x92, 0x68, 0x2b, 0x67, 0x48, 0x29,
  0x53, 0xbd, 0xc2, 0x9c, 0x21, 0x87, 0x4a, 0xd3,
  0x18, 0x73, 0xc6, 0x1c, 0xb2, 0x5c, 0x7d, 0xcc,
  0x19, 0xb3, 0xaf, 0x72, 0x93, 0x31, 0x6b, 0xcc,
  0x3e, 0xda, 0x55, 0xa6, 0xac, 0x29, 0xbb, 0x2a,
  0x33, 0xae, 0x3c, 0xa6, 0xe4, 0x2b, 0x4d, 0xa5,
  0x72, 0x9b, 0x63, 0xee, 0x14, 0xb1, 0xca, 0x61,
  0x8d, 0xb5, 0x9d, 0x58, 0x2a, 0x9b, 0x29, 0x84,
  0x0a, 0x64, 0xae, 0xa2, 0xa6, 0xe8, 0xda, 0xd0,
  0xc9, 0x0a, 0x00, 0xc0, 0xff,
  // green
  0x80, 0x1a, 0xf0, 0xd7, 0x88, 0x25, 0x8d, 0x68,
  0x40, 0x37, 0x9f, 0x4a, 0x4b, 0xa5, 0xce, 0x37,
  0xdd, 0xd5, 0x62, 0xaf, 0xb2, 0x94, 0x74, 0x17,
  0xb6, 0x3d, 0x6a, 0x1f, 0xdc, 0xc2, 0x23, 0x4e,
  0x2b, 0x4d, 0xe5, 0xcc, 0x08, 0x27, 0xa5, 0xb0,
  0x05, 0xab, 0xcd, 0x63, 0xb7, 0xc2, 0x47, 0x8a,
  0x71, 0x2f, 0xb2, 0x0a, 0xef, 0xd4, 0xb6, 0x38,
  0xf4, 0x2a, 0x92, 0x21, 0xdf, 0xb4, 0xc0, 0xa7,
  0xc8, 0x9a, 0x6c, 0x5b, 0x43, 0x9f, 0x22, 0x6b,
  0xb2, 0x19, 0x0b, 0x7d, 0xea, 0xaa, 0x48, 0x7b,
  0xdc, 0xf4, 0xe9, 0xaa, 0x22, 0xeb, 0x36, 0x2b,
  0x67, 0x68, 0x86, 0x34, 0xdb, 0xac, 0x9c, 0xa1,
  0x1b, 0x92, 0x6c, 0x8b, 0x73, 0x86, 0x61, 0x98,
  0xb3, 0x3d, 0xce, 0x19, 0xba, 0x25, 0x8d, 0x8c,
  0x28, 0x67, 0xea, 0x9e, 0x2c, 0x3c, 0xe3, 0x8c,
  0xa9, 0x7a, 0x92, 0xd4, 0x2c, 0x33, 0xa6, 0xe2,
  0xd0, 0x5c, 0x3b, 0xea, 0x98, 0x6b, 0x40, 0x57,
  0x1b, 0x3b, 0x6b, 0xae, 0x91, 0x4c, 0xb4, 0x93,
  0xb6, 0x29, 0x19, 0x0a, 0x8f, 0x56, 0x92, 0xca,
  0xa0, 0xc5, 0xad, 0x3c, 0x76, 0xf0, 0x9b, 0x56,
  0x47, 0xb7, 0x35, 0x00, 0x00, 0xff,
  // blue
  0xa2, 0x81, 0x39, 0xd2, 0x2c, 0xa3, 0xa8, 0x12,
  0x14, 0x2f, 0xf5, 0xb4, 0xa2, 0x4a, 0xd2, 0x39,
  0x3d, 0xcd, 0x71, 0xcb, 0xbb, 0x4e, 0x17, 0xb5,
  0x26, 0x2b, 0x8b, 0x2a, 0xd3, 0xc2, 0xcb, 0xac,
  0x3a, 0xe8, 0x4d, 0x53, 0xab, 0xda, 0x2a, 0xaf,
  0xde, 0xd1, 0xa3, 0x72, 0x29, 0x9d, 0xfc, 0x20,
  0xf7, 0x3a, 0xa5, 0x70, 0x62, 0x4b, 0x5d, 0xe3,
  0x94, 0x5c, 0x9b, 0x09, 0x53, 0xaf, 0x33, 0x72,
  0xa7, 0x3a, 0xc4, 0xa3, 0xce, 0x28, 0x8c, 0xdb,
  0x70, 0xc9, 0xd2, 0xa3, 0x50, 0x61, 0x3a, 0x39,
  0x2a, 0xaf, 0x5a, 0xfb, 0xae, 0xd2, 0x2a, 0x7c,
  0x5a, 0xe7, 0xc2, 0x23, 0xbb, 0xd2, 0xe9, 0x92,
  0x72, 0x77, 0xcf, 0x45, 0xa7, 0xcf, 0xca, 0x4d,
  0xc3, 0x57, 0x9e, 0x3e, 0x49, 0x0b, 0x0f, 0x5b,
  0x78, 0x86, 0xa4, 0x2d, 0xdc, 0xec, 0xf6, 0x1a,
  0xa2, 0xf6, 0x70, 0xb5, 0xdb, 0x6d, 0x08, 0x3e,
  0x5d, 0xd9, 0x6e, 0xb7, 0x31, 0xa4, 0x54, 0x56,
  0xaf, 0x13, 0x46, 0xef, 0xd2, 0x4c, 0xb5, 0xb6,
  0x99, 0xa2, 0x0b, 0x55, 0xe5, 0x70, 0x66, 0x8e,
  0xc9, 0x82, 0x49, 0xa3, 0xb2, 0x49, 0x07, 0x4d,
  0x61, 0xb7, 0x0b, 0x00, 0xf0,
  // indigo
  0xae, 0xa8, 0x86, 0xbc, 0x33, 0x94, 0x9e, 0x62,
  0x04, 0x43, 0x8b, 0xae, 0x7b, 0x8a, 0xa6, 0x48,
  0x63, 0xda, 0xca, 0xc9, 0x47, 0x74, 0x62, 0xef,
  0x26, 0x27, 0xef, 0x8a, 0xd5, 0xbb, 0x2d, 0x8f,
  0x2c, 0x49, 0x72, 0xef, 0xb2, 0x3d, 0x92, 0x20,
  0x39, 0xb3, 0xd2, 0x76, 0x4b, 0x9c, 0x92, 0xf2,
  0x4d, 0x86, 0x25, 0x51, 0x56, 0xc6, 0x57, 0x6c,
  0xa5, 0x8c, 0x26, 0x1f, 0x2b, 0x72, 0x14, 0x32,
  0x12, 0xa2, 0xd3, 0x9d, 0xce, 0xca, 0x87, 0x4d,
  0x15, 0x6d, 0xab, 0xa7, 0xa8, 0x86, 0xcd, 0x6a,
  0x6c, 0x9f, 0x2a, 0x1b, 0xb6, 0xae, 0xb6, 0x72,
  0xaa, 0x62, 0xd8, 0xb2, 0xdb, 0xce, 0x69, 0xab,
  0x65, 0xa9, 0x9c, 0x28, 0xad, 0xcf, 0x9a, 0x22,
  0xbd, 0x95, 0xa8, 0x91, 0x29, 0xeb, 0xc9, 0x90,
  0x4c, 0x00, 0x6c, 0xa9, 0x03, 0x90, 0x03, 0xf9,
  0xca, 0x8b, 0x13, 0xce, 0xec, 0x2a, 0x67, 0x28,
  0x4a, 0xad, 0x3d, 0x8b, 0x9c, 0x21, 0x5b, 0xb7,
  0xf0, 0xae, 0x72, 0x86, 0xe8, 0x2c, 0x23, 0x26,
  0xca, 0x19, 0x83, 0x2f, 0x0f, 0xef, 0xd2, 0x67,
  0x8c, 0x21, 0x3d, 0xbc, 0xaa, 0x9c, 0x31, 0xa4,
  0x54, 0x8f, 0xaa, 0x72, 0xc6, 0x10, 0x46, 0xdd,
  0x73, 0xd2, 0x19, 0x83, 0x5f, 0x35, 0xcf, 0xca,
  0x67, 0x4c, 0x31, 0x8a, 0xa5, 0x5a, 0x9d, 0x29,
  0xc6, 0x2c, 0xd6, 0x6c, 0x39, 0xa6, 0x98, 0x33,
  0x49, 0x6b, 0xe5, 0x98, 0x42, 0xaa, 0x44, 0x8d,
  0x56, 0x63, 0x0a, 0xb9, 0x02, 0x35, 0x5b, 0x8e,
  0xc5, 0xd5, 0x74, 0xd6, 0x6e, 0xa4, 0x96, 0xe4,
  0xc3, 0xcd, 0x3c, 0x09, 0x00, 0xfc,
  // violet
  0xa9, 0x11, 0x36, 0xb3, 0x5c, 0x23, 0xa6, 0x2e,
  0x48, 0x73, 0x55, 0x4b, 0x5a, 0x9a, 0xa4, 0x5d,
  0x4d, 0xd9, 0xc9, 0x68, 0xaa, 0x32, 0x77, 0x27,
  0x2b, 0xab, 0xae, 0x32, 0x22, 0x1c, 0x1d, 0x9f,
  0x32, 0xd9, 0x88, 0x14, 0xa9, 0x73, 0xca, 0x18,
  0xcb, 0x43, 0x6d, 0xea, 0xa9, 0xe2, 0x28, 0x0d,
  0xcd, 0x2a, 0xa7, 0x8a, 0x3b, 0xb8, 0x22, 0x43,
  0x9f, 0x3c, 0xf6, 0xd2, 0xd2, 0x1c, 0x7d, 0xf2,
  0xd8, 0xd2, 0x4b, 0xaa, 0xf4, 0xc9, 0x53, 0x1e,
  0xa9, 0xb4, 0x4a, 0x27, 0x4f, 0x2d, 0x74, 0xd2,
  0x23, 0x9f, 0x3c, 0xd5, 0xd0, 0xf1, 0x0c, 0x73,
  0xca, 0x9c, 0x2c, 0xca, 0x26, 0xcc, 0xa9, 0x4a,
  0x74, 0x2b, 0x9b, 0x2a, 0xa7, 0xc9, 0xd1, 0x3c,
  0x7d, 0xad, 0x9c, 0x2e, 0x9b, 0xd2, 0xb4, 0x2a,
  0x7d, 0xfa, 0x24, 0x47, 0xc3, 0xa3, 0xca, 0xe9,
  0x33, 0x1f, 0x57, 0xb5, 0x39, 0x6b, 0x88, 0xba,
  0xdc, 0xb8, 0xea, 0x9c, 0x21, 0xe9, 0x54, 0xd7,
  0xae, 0x72, 0x86, 0xa4, 0x53, 0x43, 0xbb, 0xca,
  0x19, 0x8a, 0xd2, 0x28, 0xe9, 0x2a, 0x67, 0x2c,
  0xd6, 0xcc, 0x6d, 0xaa, 0x9e, 0x39, 0x6b, 0xd7,
  0xb0, 0x1a, 0x72, 0xd6, 0x64, 0xdc, 0xc2, 0x6b,
  0x6c, 0x1a, 0xa2, 0x57, 0xb5, 0x98, 0xa2, 0xa6,
  0x51, 0xcd, 0xc3, 0x35, 0xac, 0x08, 0x20, 0x11,
  0x4d, 0x06, 0x34, 0x2e, 0xc6, 0x80, 0x2c, 0xdc,
  0x08, 0x90, 0x94, 0x39, 0x00, 0xc0, 0xff
};

/* extern */
const uint8_t bank_1[] = {
  // zero
  0x69, 0xfc, 0x59, 0xdd, 0x51, 0xd5, 0xd7, 0xa1,
  0x8f, 0x0a, 0x78, 0xc0, 0x52, 0x01, 0x0f, 0x50,
  0xac, 0xfc, 0xa8, 0x16, 0x15, 0xf2, 0x7b, 0xb2,
  0x19, 0x47, 0xd0, 0x64, 0xeb, 0x4d, 0x77, 0xba,
  0xb3, 0x91, 0x97, 0x24, 0x6e, 0x62, 0x6d, 0x5b,
  0x15, 0x0a, 0xa7, 0xb9, 0xc5, 0xab, 0xd5, 0xaa,
  0x63, 0xf0, 0xf0, 0xe2, 0x6c, 0xb3, 0x19, 0x5d,
  0x52, 0x1d, 0x19, 0x94, 0x6f, 0x76, 0x7d, 0xe8,
  0x43, 0x19, 0x83, 0xdc, 0x48, 0xc7, 0x2e, 0x71,
  0x8c, 0x93, 0x9f, 0xe0, 0xff,
  // one
  0xa6, 0x4e, 0xa8, 0x7a, 0x8d, 0xed, 0xc4, 0xb6,
  0xd5, 0x89, 0xd4, 0xbc, 0xa2, 0xdb, 0x91, 0x25,
  0xbe, 0x33, 0x4c, 0xd9, 0x4f, 0x92, 0x4d, 0x57,
  0x8a, 0x76, 0xbe, 0xf1, 0x89, 0xaa, 0x2e, 0x4f,
  0xd5, 0xcd, 0x37, 0xd9, 0x45, 0x6b, 0x87, 0x13,
  0x4c, 0x0d, 0xa7, 0xb5, 0xab, 0x7d, 0x1e, 0xe3,
  0x18, 0x67, 0x3f, 0xa7, 0xa5, 0xf9, 0xd0, 0x30,
  0x5b, 0x1d, 0x96, 0x9a, 0x34, 0x44, 0xbc, 0xb6,
  0x5d, 0xe0, 0xff,
  // two
  0x06, 0xb8, 0x59, 0x34, 0x00, 0x27, 0xd6, 0x38,
  0x60, 0x58, 0xd3, 0x11, 0x55, 0x2d, 0xaa, 0x65,
  0x9d, 0x4f, 0xd2, 0xb8, 0x39, 0x17, 0x67, 0xbf,
  0xc9, 0xce, 0x5a, 0x1e, 0xb5, 0x7a, 0x06, 0xf6,
  0xa9, 0x75, 0xed, 0x52, 0x6f, 0x55, 0xa5, 0x26,
  0x75, 0xc9, 0x93, 0x9f, 0xfc, 0x6c, 0x16, 0x63,
  0x3a, 0x34, 0x70, 0xaf, 0x5e, 0xe1, 0xff,
  // three
  0x0c, 0xe8, 0x2e, 0x94, 0x01, 0x4d, 0xba, 0x4a,
  0x40, 0x03, 0x16, 0x68, 0x41, 0x36, 0x1c, 0xe9,
  0xba, 0xb8, 0x45, 0x39, 0x70, 0x72, 0x84, 0xdb,
  0x11, 0xa7, 0xa8, 0x4e, 0xa3, 0xc9, 0x77, 0xbc,
  0x92, 0xd6, 0x52, 0xa8, 0x71, 0xed, 0x4a, 0x7a,
  0x4b, 0xa6, 0xe0, 0x37, 0x37, 0x5d, 0xe5, 0x48,
  0x8e, 0x94, 0xf1, 0x64, 0x76, 0xad, 0x1f, 0x55,
  0x91, 0xbc, 0x6e, 0xd7, 0xb1, 0xce, 0x75, 0xad,
  0x5b, 0xda, 0xc7, 0x70, 0x22, 0xcd, 0xc7, 0x79,
  0x8f, 0x3b, 0xfc,
  // four
  0x08, 0x68, 0x21, 0x0d, 0x03, 0x1c, 0x90, 0xc0,
  0x70, 0x93, 0xb2, 0x29, 0x87, 0x76, 0x2b, 0x28,
  0x5c, 0x7b, 0x06, 0xd9, 0xed, 0x60, 0x04, 0x51,
  0x54, 0x4d, 0xa2, 0xba, 0x19, 0xb5, 0x2c, 0xf8,
  0xea, 0x74, 0xca, 0xd3, 0xeb, 0xde, 0x97, 0x29,
  0xa4, 0xd4, 0x4e, 0xc9, 0x5f, 0xa7, 0xb2, 0xa5,
  0x9c, 0x1c, 0x63, 0xde, 0xf2, 0x91, 0xce, 0x34,
  0x84, 0x27, 0x2d, 0x4b, 0xb8, 0x52, 0x09, 0x9c,
  0x0e, 0xb7, 0xee, 0xcc, 0x5b, 0x70, 0xdd, 0xb2,
  0xc0, 0xff,
  // five
  0x08, 0x68, 0x4e, 0x9d, 0x02, 0x1c, 0x60, 0xc0,
  0x8c, 0x69, 0x12, 0xb0, 0xc0, 0x88, 0xaa, 0x8c,
  0x9c, 0xc0, 0x2d, 0x3b, 0x3a, 0x41, 0x31, 0x15,
  0xa3, 0xb6, 0xe4, 0x46, 0x37, 0xda, 0xc9, 0xce,
  0x56, 0xde, 0x54, 0x5b, 0x85, 0xbe, 0xd9, 0xd5,
  0x6c, 0x47, 0xdf, 0x6d, 0xb1, 0xa5, 0xbf, 0x99,
  0x7d, 0x1b, 0x5b, 0x30, 0x09, 0xaf, 0x2f, 0x6d,
  0xea, 0x31, 0xc4, 0x5c, 0xbe, 0xd6, 0x29, 0x2d,
  0xad, 0x88, 0x87, 0xe2, 0xd2, 0xb2, 0xf6, 0xe0,
  0x16, 0x2a, 0xb2, 0xe3, 0x6a, 0x57, 0xb9, 0xf2,
  0x15, 0xfe,
  // six
  0x04, 0xf8, 0xb9, 0x55, 0x01, 0xbf, 0xa5, 0x1b,
  0xe0, 0x37, 0x0f, 0x03, 0xfc, 0x96, 0x61, 0x80,
  0xdf, 0x3c, 0x0c, 0xf0, 0x93, 0xda, 0xea, 0x86,
  0x49, 0x53, 0x91, 0x37, 0xab, 0x6b, 0xd2, 0x55,
  0x23, 0xde, 0xac, 0xb9, 0xb9, 0x16, 0x09, 0xff,
  0xb2, 0xf6, 0x66, 0x93, 0x3c, 0x63, 0xf3, 0xbc,
  0x11, 0x3e, 0x45, 0xa9, 0x0a, 0xd5, 0x00, 0x00,
  0x02, 0x14, 0x97, 0xaa, 0x80, 0xab, 0x6b, 0x0d,
  0xf0, 0x63, 0xa5, 0x01, 0x7e, 0xcb, 0x30, 0xc0,
  0x6f, 0xe9, 0x0a, 0xf8, 0x25, 0x93, 0x01, 0x3f,
  0x57, 0xc0, 0xff,
  // seven
  0x0c, 0x78, 0xc6, 0x95, 0x01, 0x3f, 0xa5, 0x28,
  0xe0, 0xb7, 0x52, 0x0b, 0x04, 0xe0, 0xb7, 0x54,
  0x07, 0xfc, 0x52, 0x66, 0x80, 0x9f, 0xcb, 0x56,
  0x5d, 0x6c, 0x98, 0x47, 0x3e, 0x59, 0x5d, 0x89,
  0x69, 0x66, 0xb9, 0x7a, 0x74, 0x39, 0x86, 0x9b,
  0xd9, 0xa6, 0x34, 0xe4, 0x10, 0xae, 0xca, 0xad,
  0xc7, 0x90, 0x5d, 0x9a, 0xa9, 0xae, 0x1a, 0x6d,
  0xb1, 0xa5, 0x66, 0xf9, 0xb2, 0xb4, 0x4d, 0x63,
  0xb6, 0x84, 0x9a, 0x52, 0x77, 0x45, 0x11, 0x1a,
  0xaa, 0x4b, 0x35, 0x0c, 0x79, 0x4a, 0xb0, 0x49,
  0xd5, 0x50, 0xa2, 0x41, 0xa1, 0xc9, 0xe5, 0xd9,
  0xab, 0x89, 0x56, 0x04, 0xf8,
  // eight
  0x6d, 0x18, 0xde, 0x58, 0x23, 0x17, 0xaf, 0x61,
  0xe8, 0x20, 0xeb, 0x5c, 0xbc, 0xba, 0x61, 0x03,
  0xad, 0x73, 0xf6, 0x6a, 0x66, 0x4a, 0xd0, 0xcc,
  0xd9, 0xab, 0x1b, 0x45, 0xc1, 0xa3, 0x66, 0xaf,
  0x69, 0x36, 0x03, 0x8b, 0x5a, 0x9c, 0xd6, 0x51,
  0x04, 0xa2, 0x66, 0x96, 0x7b, 0xba, 0x47, 0xec,
  0xed, 0x8a, 0x08, 0x9a, 0xa2, 0x54, 0x85, 0x6a,
  0x00, 0x80, 0x02, 0x86, 0x74, 0x63, 0xc0, 0xe6,
  0x6a, 0xf0,
  // nine
  0xa2, 0x73, 0xdc, 0x33, 0xb5, 0x62, 0xb9, 0x36,
  0x0b, 0x8e, 0x34, 0x8f, 0xd3, 0xea, 0xae, 0x59,
  0xd2, 0x34, 0xe9, 0xa8, 0x86, 0x27, 0xc9, 0xd0,
  0x78, 0x2b, 0x6f, 0xce, 0xc2, 0x45, 0x1b, 0xaf,
  0xb4, 0xf8, 0x51, 0x73, 0x9d, 0xb3, 0xd2, 0x12,
  0xc7, 0x2c, 0x6d, 0xc9, 0x4a, 0x72, 0x4b, 0xf3,
  0x88, 0x26, 0x2b, 0xc9, 0x2d, 0xcc, 0x23, 0xea,
  0xac, 0x34, 0xb7, 0xd0, 0x88, 0x98, 0xb3, 0xf2,
  0x5c, 0x43, 0x32, 0x7d, 0xce, 0x2a, 0x4b, 0x0a,
  0xcd, 0xf4, 0x39, 0xab, 0xae, 0x3e, 0x24, 0xcb,
  0x67, 0xaf, 0xae, 0xd9, 0xe4, 0x18, 0x5f, 0xb4,
  0x86, 0x6e, 0x92, 0x62, 0x7d, 0xd1, 0x18, 0xbb,
  0x09, 0xf2, 0x8d, 0x59, 0x6d, 0xec, 0x3a, 0xd8,
  0x27, 0x16, 0xa6, 0xa5, 0x7b, 0xf2, 0x74, 0x4f,
  0x92, 0xd6, 0x1e, 0xc8, 0x4a, 0xc3, 0x49, 0x5a,
  0x9b, 0x25, 0x2b, 0xf5, 0x24, 0x69, 0xe9, 0xd1,
  0x24, 0x25, 0x27, 0xba, 0xa5, 0x25, 0x51, 0xd3,
  0xaa, 0x24, 0xe6, 0x5e, 0x54, 0x55, 0x3a, 0x14,
  0xfc,
  // ten
  0x0a, 0xd8, 0x5c, 0x4d, 0x03, 0x2b, 0xa8, 0x5e,
  0xc4, 0x33, 0x2b, 0xaf, 0x78, 0x84, 0x12, 0x0d,
  0x7b, 0xb3, 0xe2, 0x66, 0x43, 0xa2, 0xe3, 0xf6,
  0x4a, 0xaa, 0x4e, 0xc9, 0x89, 0xdb, 0x2b, 0x6b,
  0xba, 0xc5, 0xdb, 0x66, 0xaf, 0xb6, 0xe8, 0xe6,
  0x4c, 0xbf, 0x3d, 0xda, 0x6a, 0xc4, 0x4b, 0xca,
  0x49, 0x19, 0xba, 0x61, 0x2b, 0x09, 0x25, 0x6d,
  0xea, 0x5a, 0xb4, 0xc4, 0xed, 0xa6, 0x65, 0x18,
  0xe1, 0x56, 0xb7, 0x9a, 0x96, 0xa6, 0x44, 0x47,
  0xdc, 0x6e, 0x5e, 0xc2, 0xda, 0xa5, 0xf0, 0xb8,
  0xd9, 0x85, 0xff
};

/* extern */
const uint8_t bank_2[] = {
  // a
  0xa5, 0x2f, 0x96, 0xad, 0x7b, 0x6a, 0x9f, 0x6a,
  0xe4, 0x20, 0x8d, 0x9c, 0x73, 0xf3, 0x9b, 0xdd,
  0xec, 0xe6, 0x37, 0xbf, 0xe5, 0xaa, 0x66, 0x28,
  0xa0, 0xce, 0xd5, 0xbb, 0xd9, 0xed, 0xee, 0x66,
  0x3f, 0x87, 0x36, 0xce, 0x9c, 0x80, 0x51, 0x8b,
  0xeb, 0x54, 0xe7, 0xbc, 0xc2, 0xff,
  // b
  0xa6, 0x2a, 0xaa, 0x05, 0x5c, 0xd6, 0x8c, 0xb8,
  0xc7, 0x16, 0x70, 0x59, 0x33, 0xa2, 0x95, 0x0b,
  0xc1, 0xfd, 0xcd, 0x8c, 0x66, 0x38, 0xe3, 0x91,
  0xad, 0x98, 0x00, 0x55, 0x8b, 0x67, 0xd1, 0xdb,
  0xde, 0xd5, 0xa9, 0xce, 0x75, 0x2e, 0xeb, 0x2c,
  0x4d, 0x60, 0xbe, 0x26, 0xef, 0xf1, 0x88, 0x27,
  0xfc,
  // c
  0x04, 0xf8, 0xa5, 0x83, 0x03, 0x12, 0xb0, 0x80,
  0x07, 0x22, 0xb0, 0x9c, 0xee, 0x8d, 0x45, 0x7d,
  0xc9, 0x8a, 0x66, 0x29, 0x42, 0xf5, 0x35, 0x3b,
  0xda, 0xd1, 0x88, 0x67, 0x0d, 0x40, 0xcf, 0xd7,
  0x33, 0x19, 0xf9, 0xac, 0x06, 0x14, 0xb5, 0x68,
  0xd6, 0xbd, 0xeb, 0x7d, 0x1f, 0xd3, 0x32, 0x5b,
  0x02, 0x44, 0xbd, 0xce, 0x6b, 0x5e, 0xf3, 0x96,
  0xb6, 0x55, 0x0a, 0xc1, 0x73, 0x4d, 0xde, 0xf3,
  0x0e, 0xff,
  // d
  0x08, 0x20, 0xba, 0x0d, 0x03, 0x6d, 0x38, 0x2c,
  0x55, 0x45, 0xb3, 0x8c, 0xba, 0x05, 0x65, 0xd5,
  0x78, 0x32, 0xaa, 0xee, 0x85, 0x34, 0xf2, 0xf6,
  0xa8, 0x87, 0x33, 0xe0, 0xca, 0xc7, 0xad, 0x9e,
  0xce, 0x81, 0xbb, 0x66, 0xb7, 0x76, 0x06, 0x07,
  0xee, 0x9c, 0xd5, 0xba, 0xa9, 0x1d, 0x65, 0x72,
  0x11, 0xfc,
  // e
  0xa2, 0x5a, 0x95, 0x51, 0xba, 0x17, 0xf7, 0x62,
  0xe5, 0xab, 0x38, 0x42, 0xe4, 0x92, 0x9d, 0xef,
  0x6c, 0x65, 0x33, 0x3b, 0x50, 0xd6, 0x92, 0x9d,
  0xaf, 0x62, 0xc5, 0x04, 0xa8, 0x5a, 0xbc, 0xcb,
  0x5d, 0xed, 0x7a, 0x37, 0xbb, 0xdd, 0xc3, 0x1e,
  0xf6, 0x34, 0xa7, 0xbe, 0xf4, 0xa5, 0xad, 0xb3,
  0x34, 0x81, 0xf9, 0x1a, 0xf8,
  // f
  0xab, 0x1a, 0x61, 0x94, 0xdd, 0xd6, 0xdc, 0xf6,
  0x54, 0xdd, 0x37, 0xb9, 0xe7, 0xea, 0x53, 0x35,
  0xb3, 0x1c, 0xe1, 0xaf, 0x6f, 0x75, 0xdb, 0x35,
  0xd4, 0xe0, 0x56, 0x9c, 0x77, 0xdb, 0x58, 0x9d,
  0xeb, 0x98, 0x8c, 0x61, 0xc0, 0x30, 0xe9, 0x1a,
  0xb0, 0x80, 0x05, 0x14, 0x30, 0x6d, 0xbb, 0x06,
  0x24, 0x20, 0x01, 0x0e, 0x10, 0xa0, 0x06, 0x35,
  0xf8,
  // g
  0x6e, 0x3e, 0x29, 0x8d, 0x98, 0x95, 0xcd, 0x39,
  0x00, 0xab, 0x38, 0x95, 0xf4, 0xd4, 0xeb, 0x34,
  0x81, 0x7a, 0xe2, 0x51, 0x53, 0x50, 0x75, 0xeb,
  0x8e, 0x76, 0xb4, 0xc3, 0x15, 0x8d, 0x92, 0x48,
  0x99, 0xab, 0x77, 0xbc, 0xd3, 0x5d, 0x8e, 0x76,
  0x96, 0x04, 0x8c, 0x5a, 0x3c, 0xfb, 0xd9, 0xf7,
  0xa9, 0x4e, 0x75, 0x2b, 0xdb, 0x2a, 0x85, 0xe0,
  0xb9, 0x26, 0x1e, 0xf1, 0x80, 0xff,
  // h
  0xa5, 0x1d, 0x6d, 0x90, 0x2d, 0xd6, 0xec, 0xf2,
  0xe6, 0x37, 0xbb, 0xe9, 0x2e, 0x46, 0x3b, 0xa3,
  0x01, 0x6d, 0x2d, 0xce, 0xa3, 0x5d, 0xdd, 0xdc,
  0x3c, 0x61, 0x76, 0xc5, 0x25, 0xb3, 0x08, 0xe5,
  0x2e, 0x22, 0x1b, 0x00, 0x80, 0x01, 0x2b, 0x87,
  0x38, 0x60, 0xe5, 0xed, 0x08, 0x58, 0xc0, 0x02,
  0x16, 0xb0, 0x80, 0x06, 0x34, 0x40, 0x80, 0x76,
  0xd3, 0xe0, 0xff,
  // i
  0x2a, 0x8b, 0x63, 0xa8, 0xaa, 0x66, 0xad, 0xb6,
  0xa8, 0xcb, 0x08, 0xdd, 0x7c, 0x8b, 0x9b, 0xde,
  0xf4, 0x66, 0x37, 0x3b, 0x59, 0xb5, 0xa3, 0x15,
  0xba, 0xf8, 0xe6, 0xbb, 0xd8, 0xcd, 0x6e, 0x57,
  0xdf, 0x5c, 0x49, 0xa5, 0x2d, 0xde, 0x63, 0x1b,
  0x6b, 0x76, 0x29, 0xaf, 0xc7, 0x6d, 0xec, 0x31,
  0xd8, 0x5c, 0x1e, 0xf7, 0xb1, 0x4e, 0x75, 0x4a,
  0xf3, 0x28, 0x89, 0xe2, 0xf2, 0x38, 0x2f, 0x79,
  0x85, 0xff,
  // j
  0xae, 0x5e, 0xc1, 0x99, 0x54, 0xb2, 0x09, 0x60,
  0x49, 0x22, 0x07, 0xec, 0xa8, 0x16, 0x80, 0x5d,
  0x26, 0x47, 0xd5, 0xa3, 0x92, 0x78, 0x74, 0x3e,
  0x71, 0x2f, 0x21, 0x6a, 0xb1, 0xfa, 0xc6, 0x37,
  0xbe, 0xf1, 0x4d, 0x6f, 0x7a, 0xf3, 0x5d, 0x8d,
  0x7e, 0xb4, 0x22, 0x36, 0x7f, 0x53, 0xe7, 0xbe,
  0xb4, 0x6d, 0x96, 0x61, 0x34, 0xdb, 0x52, 0xb7,
  0xb4, 0x8f, 0xdc, 0x88, 0xe1, 0x5f, 0xf2, 0x9a,
  0x57, 0xf8,
  // k
  0x01, 0x18, 0x91, 0xb9, 0x00, 0x4d, 0x91, 0x46,
  0x60, 0x05, 0x2d, 0xb3, 0xb8, 0x67, 0xed, 0x13,
  0xf7, 0x14, 0x64, 0x11, 0x4b, 0x6e, 0x7c, 0xe3,
  0x1b, 0xdf, 0xf8, 0x14, 0xc3, 0x05, 0x6a, 0xe7,
  0xea, 0x5d, 0xef, 0x7a, 0xf7, 0x6d, 0x1a, 0xb1,
  0x00, 0x2b, 0xdf, 0xf4, 0xa9, 0x4d, 0xb3, 0x24,
  0x60, 0xd4, 0xe2, 0xba, 0xe6, 0x35, 0x6f, 0x69,
  0x1b, 0x43, 0x48, 0xa3, 0xeb, 0xe4, 0x0d, 0xfe,
  // l
  0xab, 0x6c, 0x2e, 0xd8, 0x2a, 0x37, 0xdf, 0xe2,
  0x16, 0xa7, 0xa8, 0x21, 0xbc, 0xc4, 0x17, 0xdf,
  0xe2, 0x16, 0xa7, 0xcc, 0x6a, 0xc3, 0x4d, 0x3a,
  0xdf, 0x72, 0xd5, 0x95, 0x6c, 0xa6, 0x71, 0x9e,
  0xd1, 0x35, 0x98, 0x53, 0x49, 0x5e, 0x7b, 0x57,
  0xc6, 0x0a, 0x7a, 0x43, 0xd9, 0x4f, 0x1c, 0xc3,
  0x54, 0xe0, 0xf4, 0x08, 0xf9, 0x09, 0x53, 0x03,
  0x31, 0x19, 0xa2, 0x25, 0x4e, 0xf0,
  // m
  0x29, 0xea, 0xc5, 0xd8, 0x73, 0x16, 0xcf, 0xe8,
  0x56, 0x37, 0xbf, 0xd9, 0x49, 0xbb, 0x6f, 0xf1,
  0xf0, 0xd5, 0x37, 0xbd, 0xd9, 0xce, 0x47, 0x55,
  0x63, 0x72, 0x98, 0x58, 0xee, 0x6d, 0xef, 0xdb,
  0xd0, 0x62, 0x72, 0x98, 0x58, 0xae, 0x63, 0x1d,
  0xd3, 0x58, 0x45, 0x72, 0x93, 0xd8, 0x8d, 0x93,
  0x9d, 0xec, 0x64, 0xe7, 0x30, 0x97, 0x58, 0xe1,
  0xa2, 0x4d, 0xe2, 0x12, 0x57, 0xf8,
  // n
  0x81, 0xed, 0xd1, 0xc8, 0xb3, 0x16, 0xef, 0xe2,
  0x64, 0xc3, 0x35, 0x59, 0xc4, 0xe3, 0x9b, 0xde,
  0xf4, 0xa6, 0x3b, 0x5f, 0xf9, 0x92, 0xcd, 0x91,
  0xb4, 0x78, 0xb7, 0xa3, 0x1f, 0x9e, 0x38, 0x2c,
  0x9c, 0xce, 0xbe, 0x0f, 0x75, 0x0e, 0xf3, 0xb0,
  0xc2, 0x61, 0x1e, 0x35, 0xce, 0x71, 0x89, 0x6b,
  0xdc, 0xd2, 0xd6, 0x4d, 0x49, 0xb8, 0xce, 0x0e,
  0xdb, 0x34, 0xad, 0x16, 0xbc, 0x19, 0xfe,
  // o
  0xa3, 0x68, 0xb4, 0xba, 0x8d, 0xbc, 0xad, 0xbc,
  0x92, 0xec, 0x0e, 0xf2, 0xb6, 0xd3, 0x1d, 0x8f,
  0xb8, 0xe0, 0xee, 0x16, 0xf6, 0x3f, 0x93, 0x59,
  0xcf, 0xa6, 0x0c, 0x91, 0xe5, 0x0c, 0x8b, 0xbf,
  0x30, 0x39, 0xd3, 0x1d, 0x28, 0x59, 0xe2, 0xe2,
  0x17, 0xbb, 0xfa, 0x1d, 0xfe,
  // p
  0x02, 0x88, 0x26, 0xd4, 0x00, 0x6d, 0x96, 0xb5,
  0xb8, 0x25, 0x05, 0x89, 0x6c, 0x3d, 0x92, 0xe6,
  0x51, 0xb3, 0xa6, 0xf4, 0x48, 0x66, 0x09, 0xa0,
  0x8c, 0xc7, 0x33, 0x9d, 0x79, 0xcb, 0x67, 0x0e,
  0x80, 0xca, 0xd7, 0xbd, 0x6c, 0xe5, 0x72, 0x06,
  0xb4, 0xb5, 0xba, 0x37, 0xbd, 0xab, 0x53, 0x5d,
  0xf2, 0x9e, 0xf7, 0x78, 0xc0, 0xff,
  // q
  0x0e, 0x98, 0xd5, 0x28, 0x02, 0x11, 0x18, 0xc9,
  0xcc, 0x46, 0x98, 0xf1, 0x66, 0x27, 0x27, 0x19,
  0x21, 0x99, 0x92, 0xb6, 0xdc, 0x6c, 0xe7, 0xab,
  0x28, 0xd2, 0x2d, 0x13, 0x3b, 0xef, 0xb2, 0xb5,
  0xce, 0x94, 0x47, 0xd0, 0xee, 0xda, 0xc7, 0x31,
  0xcf, 0x61, 0x31, 0x31, 0xa2, 0x50, 0xb6, 0xf8,
  0xd5, 0xef, 0xf0,
  // r
  0x2b, 0xce, 0x72, 0x33, 0x93, 0xbb, 0xdc, 0xf2,
  0x16, 0x37, 0xbf, 0xd9, 0x28, 0x52, 0x5c, 0xa9,
  0xa6, 0x4d, 0xb3, 0x6c, 0x5d, 0x0a, 0xcb, 0x71,
  0xd8, 0xbb, 0x0f, 0x7d, 0x2a, 0x73, 0xb6, 0xc7,
  0xf4, 0x94, 0x37, 0x2d, 0xa9, 0x34, 0xf8, 0x53,
  0x97, 0xb8, 0xc2, 0xff,
  // s
  0xab, 0x6f, 0xd9, 0x34, 0x6c, 0xe6, 0xdc, 0xe2,
  0x16, 0x37, 0xbf, 0xf9, 0x69, 0xaa, 0x0f, 0x2d,
  0xda, 0x25, 0x7b, 0x18, 0x53, 0x4d, 0x9a, 0xa2,
  0xe7, 0xb8, 0x2d, 0x23, 0xa5, 0x26, 0x71, 0x2a,
  0x03, 0xfc, 0x94, 0xe6, 0x01, 0x0f, 0x68, 0x40,
  0x03, 0x12, 0xe0, 0x00, 0x07, 0x30, 0x00, 0xff,
  // t
  0x01, 0xd8, 0xb6, 0xdd, 0x01, 0x2f, 0xf4, 0x38,
  0x60, 0xd5, 0xd1, 0x91, 0x4c, 0x97, 0x84, 0xe6,
  0x4b, 0x4e, 0x32, 0xb2, 0x10, 0x67, 0xcd, 0x19,
  0xc9, 0x2c, 0x01, 0x94, 0xf1, 0x78, 0x26, 0x33,
  0xe9, 0x69, 0x2f, 0x7b, 0x53, 0xbb, 0x36, 0xae,
  0x52, 0x08, 0x9e, 0x6b, 0xea, 0x5c, 0x97, 0xba,
  0x95, 0x7d, 0x45, 0x47, 0xac, 0x5a, 0x9c, 0x0f,
  0xf8,
  // u
  0xa1, 0x99, 0x9c, 0x94, 0x72, 0x26, 0x8d, 0x6a,
  0x07, 0x55, 0x90, 0x78, 0x3c, 0x8b, 0x99, 0x9f,
  0xac, 0x87, 0x60, 0x76, 0xda, 0x72, 0xb3, 0x93,
  0x35, 0xa5, 0x64, 0x2d, 0x7b, 0x6e, 0xbe, 0x9a,
  0x24, 0xdc, 0x32, 0xb1, 0x73, 0xef, 0xfa, 0x10,
  0x46, 0xab, 0xc6, 0xca, 0xe0, 0xb5, 0x5f, 0xcc,
  0xaa, 0xd4, 0x78, 0x1b, 0xb6, 0x53, 0xbb, 0x74,
  0xa7, 0x21, 0xbc, 0x04, 0xfe,
  // v
  0x66, 0xf0, 0xd2, 0x38, 0x43, 0xb3, 0xd8, 0x21,
  0xf4, 0x4d, 0xbb, 0x70, 0xb0, 0xdb, 0xd0, 0x0f,
  0x17, 0x2c, 0x26, 0xae, 0x53, 0x37, 0x6c, 0xbb,
  0x32, 0xab, 0x19, 0x75, 0xf7, 0x21, 0x6c, 0x9c,
  0xe5, 0x64, 0x33, 0xb6, 0x80, 0xcb, 0x9a, 0x1b,
  0xae, 0x60, 0xe5, 0x42, 0x70, 0x7f, 0xb3, 0x83,
  0xed, 0xef, 0x70, 0x25, 0x2b, 0x26, 0x40, 0xd5,
  0xe2, 0x99, 0xf7, 0xba, 0xb7, 0x75, 0xa8, 0x63,
  0x9d, 0xca, 0x32, 0x4b, 0x13, 0x98, 0xaf, 0xa9,
  0x4b, 0xde, 0xf3, 0x91, 0x8e, 0x19, 0x0b, 0x31,
  0xf3, 0x0d, 0xfc,
  // w
  0x21, 0xdb, 0xc2, 0x44, 0xc2, 0xfc, 0x9c, 0x64,
  0x88, 0x70, 0x09, 0x59, 0x7b, 0xe2, 0xca, 0x3b,
  0x3d, 0xa4, 0xcf, 0x0d, 0x56, 0x90, 0xc4, 0xa6,
  0xbb, 0xf4, 0x6e, 0x41, 0xe2, 0x9d, 0xea, 0xe2,
  0x4a, 0x65, 0x12, 0x65, 0xbb, 0xb3, 0xeb, 0x91,
  0x55, 0x12, 0x99, 0xc1, 0xd9, 0x6e, 0xb1, 0x9b,
  0xd1, 0x36, 0x92, 0x6a, 0xc9, 0x9b, 0x47, 0x3b,
  0x4c, 0x12, 0x46, 0x6c, 0x99, 0x5d, 0xef, 0x5b,
  0xdf, 0x92, 0x92, 0x64, 0x6c, 0xee, 0x43, 0x19,
  0x6b, 0x22, 0x71, 0x8f, 0xcf, 0x65, 0x29, 0x41,
  0xd4, 0xdd, 0x36, 0xa5, 0x2d, 0x19, 0xf5, 0x0c,
  0xee, 0x13, 0xb7, 0x7c, 0x98, 0xc3, 0x85, 0xc8,
  0x62, 0xee, 0x6d, 0x4f, 0xf8,
  // x
  0xad, 0x69, 0xc9, 0xc5, 0x32, 0x56, 0xdf, 0xfe,
  0x74, 0x2d, 0x35, 0x7b, 0xf8, 0xea, 0xdb, 0xdd,
  0xe1, 0x6c, 0x6d, 0x04, 0xa6, 0xc5, 0xea, 0xb9,
  0x87, 0xa3, 0x75, 0x23, 0x37, 0x4f, 0x83, 0x60,
  0x11, 0xca, 0x5d, 0x44, 0x36, 0x00, 0x28, 0xa0,
  0xe6, 0x31, 0x0f, 0x68, 0xc0, 0x00, 0xbf, 0x8d,
  0x79, 0xc0, 0x03, 0x16, 0xd0, 0x00, 0x07, 0xe0,
  0xff,
  // y
  0xaa, 0xb3, 0xa2, 0xa7, 0x95, 0xd2, 0xd8, 0x2e,
  0x57, 0x23, 0x2f, 0xb2, 0x7a, 0x1c, 0xb3, 0xde,
  0xec, 0xa4, 0x45, 0x6d, 0x56, 0xca, 0x9a, 0x9b,
  0xde, 0xf4, 0xe6, 0xbb, 0xd8, 0xc5, 0xaa, 0x8a,
  0x6f, 0x2b, 0xf3, 0x37, 0xbb, 0x1b, 0x5d, 0xd3,
  0x25, 0x39, 0xfa, 0xb9, 0x0f, 0x6d, 0xe8, 0x31,
  0xc4, 0x5c, 0x1e, 0xf7, 0xa1, 0x4f, 0x65, 0x1e,
  0xa5, 0x48, 0x5c, 0x1e, 0xd7, 0x25, 0x2f, 0x79,
  0x81, 0xff,
  // z
  0xad, 0xfb, 0xc6, 0x5c, 0x95, 0xd5, 0xf5, 0xce,
  0x02, 0xbb, 0x5b, 0xf9, 0x51, 0x2d, 0x2a, 0xe4,
  0x77, 0xe5, 0xa3, 0x3a, 0xb1, 0xfa, 0x9b, 0x9d,
  0xec, 0x78, 0xc5, 0x33, 0x27, 0x60, 0xd4, 0xe2,
  0x99, 0xce, 0x74, 0xd6, 0xb3, 0x9b, 0x43, 0x9f,
  0xfa, 0x54, 0xe6, 0x55, 0x0a, 0xc1, 0x73, 0x4d,
  0x9d, 0xeb, 0x92, 0xd6, 0x15, 0x12, 0xa0, 0x6b,
  0x75, 0x5e, 0xe1, 0xff
};

/* extern */
const uint8_t bank_3[] = {
  // alpha
  0x63, 0xac, 0x21, 0xb4, 0x3c, 0x16, 0xaf, 0xb2,
  0x84, 0xd2, 0x0a, 0x5f, 0xb3, 0xf2, 0xe2, 0xda,
  0x32, 0xf4, 0xcd, 0xca, 0x92, 0xdf, 0x28, 0xd7,
  0x27, 0x2b, 0xcd, 0xe2, 0x5b, 0x93, 0x57, 0xaf,
  0xac, 0xd0, 0x1b, 0x0b, 0xee, 0xb2, 0xb2, 0x24,
  0xae, 0xc3, 0x28, 0x4b, 0x29, 0x0a, 0xaf, 0x0e,
  0x13, 0x47, 0x02, 0xa8, 0xa6, 0x4c, 0x00, 0x4d,
  0x57, 0x08, 0xa0, 0x99, 0x0c, 0x01, 0x74, 0xed,
  0xb1, 0x8a, 0x22, 0xba, 0xd4, 0xa9, 0xcd, 0x2a,
  0x2a, 0xef, 0xd6, 0xe0, 0xbd, 0x6b, 0x6c, 0xac,
  0x5a, 0x83, 0xf7, 0xae, 0xad, 0xb1, 0x6a, 0x0b,
  0xde, 0x32, 0x96, 0xa2, 0x3a, 0xc2, 0x79, 0x73,
  0xdd, 0xf3, 0x01, 0xff,
  // bravo
  0x02, 0x10, 0x2c, 0x34, 0x94, 0x46, 0xaf, 0xc8,
  0x8a, 0xbd, 0x54, 0x84, 0xa9, 0xe6, 0x2d, 0xfc,
  0x46, 0x1e, 0x7b, 0x48, 0x87, 0x2a, 0x5f, 0x59,
  0x76, 0x13, 0xe9, 0xba, 0x7a, 0xa7, 0x3b, 0x9d,
  0x59, 0x29, 0xa3, 0xab, 0x48, 0xd7, 0xd5, 0xb1,
  0x0e, 0x6d, 0xf7, 0xa1, 0xe6, 0x2a, 0x3b, 0xb6,
  0xa5, 0x0d, 0xa9, 0x52, 0x55, 0x56, 0x8d, 0xb2,
  0x92, 0x6a, 0x77, 0xf1, 0xbb, 0xda, 0x86, 0xb2,
  0x3a, 0x44, 0xfd, 0xec, 0xdb, 0x50, 0x48, 0xd7,
  0x38, 0xb9, 0xef, 0x73, 0x9d, 0xc3, 0xec, 0x7d,
  0x67, 0xb0, 0xf4, 0x89, 0x6b, 0xdc, 0xe0, 0xff,
  // charlie
  0x06, 0xd8, 0x2d, 0x2c, 0x01, 0x33, 0xb7, 0x67,
  0xa0, 0xb9, 0xc5, 0x8d, 0xc8, 0xb2, 0xb7, 0x16,
  0x16, 0xbf, 0x26, 0x87, 0xf9, 0x5a, 0x94, 0xf3,
  0xb0, 0x1f, 0x75, 0x19, 0x51, 0xce, 0xcd, 0x71,
  0xd4, 0x65, 0xc4, 0x39, 0x8e, 0xda, 0x71, 0xb6,
  0x91, 0xc7, 0x30, 0xe9, 0x6e, 0x69, 0x4b, 0x5b,
  0x51, 0x8f, 0x15, 0x66, 0x49, 0xe3, 0x80, 0x31,
  0xa2, 0xe6, 0x7d, 0xcd, 0x55, 0xb6, 0x59, 0xd8,
  0xea, 0xb1, 0x0e, 0xde, 0xca, 0xe5, 0x9b, 0xc7,
  0xd6, 0x65, 0x92, 0x55, 0x6c, 0x2e, 0xfb, 0x30,
  0x49, 0x92, 0xb1, 0x3a, 0xed, 0xc3, 0x04, 0x72,
  0xe7, 0xe6, 0x70, 0x74, 0xeb, 0xa8, 0x93, 0xab,
  0xe1, 0xff,
  // delta
  0x0a, 0x28, 0x30, 0x6c, 0x8d, 0xc3, 0xa7, 0xaa,
  0x70, 0xd7, 0x55, 0x76, 0x5d, 0x22, 0xee, 0x5b,
  0x57, 0xd6, 0xf9, 0xb8, 0xa6, 0x6d, 0x59, 0x59,
  0x16, 0x9b, 0xa1, 0xde, 0x7b, 0x15, 0x99, 0x6d,
  0xa5, 0x58, 0xde, 0x55, 0x64, 0x11, 0x5d, 0xc2,
  0x69, 0x4a, 0x3b, 0x25, 0x5b, 0x85, 0x32, 0x21,
  0x40, 0x96, 0x26, 0x0e, 0x58, 0x4a, 0x33, 0x00,
  0x4b, 0xb5, 0xad, 0xaa, 0x9a, 0xf0, 0x30, 0xdf,
  0xb2, 0xbb, 0xd1, 0x37, 0x55, 0xe9, 0x21, 0x5d,
  0x7b, 0x3f, 0x96, 0xaa, 0xc6, 0x3c, 0xa5, 0x73,
  0x5f, 0xe1, 0xff,
  // echo
  0x2b, 0x6e, 0xb1, 0xd9, 0xd3, 0x36, 0xdf, 0xf2,
  0x16, 0x37, 0x27, 0xa9, 0x08, 0xe5, 0x2e, 0x22,
  0x1b, 0x20, 0x00, 0x25, 0xac, 0x2a, 0x20, 0xcf,
  0xd3, 0x92, 0x45, 0x53, 0x6a, 0xa9, 0x9e, 0x4f,
  0x99, 0x54, 0x47, 0xb9, 0xe4, 0xdf, 0xed, 0x6c,
  0x47, 0x9b, 0x45, 0x65, 0xbb, 0x78, 0x9f, 0xc3,
  0x1c, 0xd2, 0xe8, 0x43, 0x67, 0xb0, 0xe5, 0xcd,
  0x73, 0x58, 0x9d, 0xad, 0x2c, 0x15, 0x37, 0x71,
  0x85, 0xff,
  // foxtrot
  0x04, 0x18, 0xb6, 0x82, 0x00, 0xd3, 0x57, 0x08,
  0x60, 0xba, 0xf4, 0x91, 0xc7, 0x58, 0x15, 0xca,
  0x8b, 0x47, 0x9e, 0xfc, 0x64, 0x1a, 0xaf, 0x19,
  0x45, 0x4a, 0x9d, 0xa1, 0xfa, 0x64, 0x14, 0xa9,
  0x65, 0x86, 0xe4, 0xe2, 0x51, 0xa5, 0xee, 0x99,
  0x92, 0xab, 0x04, 0xe0, 0xa2, 0x93, 0x04, 0x08,
  0x90, 0x9d, 0x33, 0x03, 0x9e, 0x71, 0x65, 0xc0,
  0x4f, 0x29, 0x0a, 0xf8, 0xad, 0xd4, 0x02, 0x08,
  0x9e, 0xa2, 0x54, 0x85, 0x6a, 0x80, 0x00, 0x86,
  0x21, 0x57, 0xc0, 0x48, 0x53, 0x01, 0x18, 0x36,
  0xbc, 0x15, 0xa9, 0x4b, 0xaa, 0x4b, 0x9b, 0xd6,
  0xc7, 0xee, 0x11, 0x41, 0x6b, 0xdb, 0x9a, 0xec,
  0x94, 0x36, 0xed, 0x6d, 0x5b, 0x76, 0x93, 0x9e,
  0xfc, 0xa5, 0x5d, 0xd9, 0x4d, 0x58, 0xea, 0x9a,
  0x7e, 0xb5, 0x37, 0xc5, 0x76, 0x4f, 0x7f, 0x14,
  0xfe, 0xd8, 0xcd, 0x2b, 0x7a, 0xb2, 0xfa, 0x9b,
  0xf2, 0x88, 0xf0, 0xae, 0x08, 0x16, 0xa1, 0xdc,
  0x45, 0x64, 0x03, 0x80, 0x00, 0x8e, 0xe0, 0x30,
  0xc0, 0xb2, 0x53, 0xf0,
  // golf
  0x0a, 0x88, 0xa1, 0x71, 0x65, 0x85, 0x76, 0x45,
  0x8a, 0xff, 0x9b, 0xde, 0x78, 0xc5, 0x99, 0x5c,
  0xb7, 0x72, 0xde, 0x1d, 0xef, 0x7c, 0xd7, 0xb3,
  0x6f, 0x63, 0x54, 0x35, 0x63, 0xe4, 0xa6, 0xae,
  0x79, 0x33, 0x47, 0x94, 0x39, 0x63, 0xe4, 0x86,
  0x1f, 0x04, 0x98, 0x34, 0xdd, 0x02, 0x0e, 0x98,
  0x32, 0x5d, 0x03, 0x12, 0xe0, 0x00, 0xfc,
  // hotel
  0x08, 0xc8, 0x4a, 0x0c, 0x01, 0xc5, 0x74, 0x11,
  0xa0, 0xca, 0xea, 0xd1, 0x35, 0x5a, 0xdd, 0x46,
  0xde, 0x56, 0x5d, 0x49, 0x76, 0x07, 0x79, 0xdb,
  0xd5, 0xa8, 0x0a, 0xee, 0x6e, 0x61, 0xff, 0xbd,
  0xaa, 0x2d, 0x82, 0x44, 0x70, 0x17, 0x11, 0xd9,
  0x00, 0x02, 0xe8, 0x54, 0x2d, 0x00, 0xd5, 0x84,
  0x05, 0x60, 0x2a, 0xb3, 0x93, 0x37, 0x67, 0x66,
  0x9c, 0x6b, 0x4e, 0x5e, 0xbd, 0x9b, 0x6a, 0xdd,
  0x39, 0x79, 0xf1, 0xae, 0x6e, 0xbd, 0xf8, 0x54,
  0xc5, 0xa7, 0x85, 0xe5, 0xe2, 0x53, 0x17, 0xd5,
  0x9e, 0x2e, 0x9f, 0xcf, 0x58, 0xe4, 0xa6, 0x07,
  0xbf, 0x59, 0x5b, 0xc5, 0x33, 0x19, 0xd8, 0xa5,
  0x9c, 0x89, 0xce, 0x94, 0x61, 0x9b, 0x74, 0x79,
  0xdd, 0x13, 0xc4, 0x4b, 0xfc, 0xe5, 0x2e, 0xa7,
  0xae, 0x0a, 0xa5, 0x0d, 0xfc,
  // india
  0xa3, 0x98, 0xd6, 0x99, 0x32, 0x17, 0x8f, 0x7c,
  0x86, 0x16, 0x74, 0x5f, 0xb3, 0xf2, 0xe1, 0x4a,
  0xc4, 0xf4, 0xce, 0x4e, 0x47, 0xdc, 0x1d, 0x5a,
  0x46, 0x3a, 0x99, 0x71, 0x8b, 0xab, 0x82, 0xac,
  0x08, 0x27, 0x3e, 0x5d, 0xe5, 0x0c, 0x25, 0x42,
  0xbc, 0x7b, 0x55, 0xd3, 0x17, 0x61, 0xf8, 0x96,
  0x5d, 0xed, 0x7a, 0xf4, 0xcd, 0x8a, 0x44, 0xc6,
  0xe3, 0x31, 0x55, 0x1b, 0x62, 0x69, 0xaf, 0xc7,
  0x92, 0x9c, 0x7b, 0x66, 0x2c, 0x6e, 0x5b, 0xf6,
  0x69, 0x11, 0xf6, 0xaa, 0x1c, 0x29, 0xa4, 0x87,
  0xdb, 0xe7, 0x74, 0xe6, 0x14, 0x1e, 0x1a, 0xab,
  0xdd, 0x95, 0x62, 0x7a, 0x68, 0xac, 0x82, 0xff,
  // juliet
  0x61, 0x5d, 0x96, 0x49, 0x34, 0xd2, 0x06, 0x60,
  0xc7, 0x90, 0x0c, 0x8c, 0x66, 0xf6, 0x15, 0x22,
  0x4d, 0x37, 0xaa, 0x6a, 0xc8, 0x2c, 0x6d, 0xcd,
  0x28, 0xb2, 0x15, 0x8b, 0xe4, 0x35, 0xb3, 0x68,
  0x79, 0x51, 0xe6, 0xda, 0x9c, 0xbe, 0x15, 0x43,
  0x89, 0xf0, 0xa2, 0xdb, 0x95, 0x77, 0xa7, 0xa6,
  0x66, 0x49, 0x77, 0xb1, 0x9a, 0x9e, 0x0a, 0xd5,
  0x75, 0xeb, 0xee, 0xf6, 0xb0, 0xc6, 0xe6, 0x83,
  0xd2, 0xe3, 0xeb, 0x5e, 0xd7, 0xda, 0x5c, 0x48,
  0x87, 0x6d, 0x9e, 0x7b, 0xdf, 0xf3, 0x89, 0x40,
  0x11, 0xca, 0x5d, 0x44, 0x36, 0x00, 0x38, 0x60,
  0xea, 0x8c, 0x00, 0x2c, 0xb3, 0x6d, 0x01, 0x01,
  0x14, 0x5f, 0x8e, 0x01, 0xf8,
  // kilo
  0x06, 0xe8, 0x12, 0xd9, 0x02, 0x12, 0x68, 0xee,
  0x8c, 0x86, 0xd4, 0xf5, 0x76, 0x7a, 0xd3, 0x1d,
  0xee, 0x74, 0x4a, 0x54, 0x1e, 0x6f, 0xfa, 0x2b,
  0x5c, 0xdc, 0x42, 0x93, 0xb2, 0xed, 0x66, 0xb5,
  0x95, 0x7b, 0x8e, 0x53, 0xdf, 0x3d, 0xac, 0xa1,
  0xb0, 0xcc, 0x2a, 0xee, 0xbb, 0xa7, 0xb6, 0x24,
  0x53, 0xd9, 0x4a, 0x7d, 0xfb, 0x52, 0x36, 0x1f,
  0x2b, 0x1b, 0x75, 0x4d, 0xdc, 0xe2, 0x1e, 0x8e,
  0xa0, 0xa6, 0x32, 0xc8, 0xaf, 0xbb, 0x92, 0x18,
  0xaf, 0x20, 0x7d, 0xf0,
  // lima
  0xa1, 0x5f, 0x90, 0xba, 0xc0, 0xd7, 0xa6, 0x7e,
  0x00, 0x19, 0x85, 0x6a, 0xda, 0xca, 0xcd, 0x24,
  0xd9, 0xcc, 0xcb, 0x4a, 0x47, 0x76, 0x66, 0xf5,
  0x37, 0x3b, 0x9e, 0xe1, 0x88, 0x7a, 0x50, 0xd4,
  0x8e, 0xd9, 0x3d, 0xad, 0x45, 0x2b, 0xb3, 0x62,
  0xee, 0xf4, 0xb8, 0xb5, 0xac, 0xf5, 0xa8, 0x1b,
  0xaf, 0xcc, 0xa2, 0xce, 0xbb, 0xdd, 0xcb, 0xd8,
  0xb2, 0xda, 0xc8, 0xd0, 0x55, 0xfd, 0xac, 0x57,
  0xbd, 0xe0, 0xff,
  // mike
  0x66, 0x31, 0x3c, 0x7c, 0x52, 0xe3, 0xc4, 0x69,
  0xf5, 0x85, 0x57, 0x86, 0x51, 0xaa, 0xd3, 0x56,
  0x75, 0xa1, 0x69, 0x9d, 0x6f, 0x7d, 0xca, 0x6a,
  0x57, 0x23, 0x6d, 0xf5, 0xcd, 0x57, 0xd1, 0x4b,
  0x50, 0x78, 0x2c, 0xda, 0x75, 0x69, 0x46, 0x77,
  0xb4, 0xce, 0xdb, 0xb1, 0x45, 0xad, 0x08, 0xe5,
  0x2e, 0x22, 0x1b, 0x00, 0x18, 0xd0, 0x3c, 0x91,
  0x03, 0x5a, 0x09, 0xb1, 0x80, 0x00, 0xb2, 0x13,
  0x86, 0xff,
  // november
  0x66, 0x2c, 0x02, 0x62, 0x4b, 0xe3, 0x8e, 0xa1,
  0xeb, 0x10, 0x77, 0x6e, 0xb3, 0xb2, 0x2a, 0x2a,
  0x39, 0x74, 0xcb, 0x4a, 0x0b, 0xcb, 0xb2, 0xe4,
  0xae, 0x2b, 0x4d, 0xbc, 0xdb, 0x9c, 0xfa, 0xb6,
  0x2c, 0x8a, 0x29, 0x33, 0xee, 0x93, 0xf2, 0xa0,
  0xa6, 0xc4, 0xb9, 0x55, 0xa8, 0x92, 0xa8, 0x54,
  0xa7, 0xc4, 0xae, 0x1d, 0x32, 0xcc, 0x54, 0x2d,
  0xb7, 0xb1, 0xa9, 0x72, 0x53, 0x51, 0xbc, 0xb2,
  0xe2, 0x53, 0x2c, 0xb4, 0xf5, 0x4a, 0x8b, 0x2b,
  0xb5, 0xd2, 0xd5, 0x2b, 0x2d, 0xa6, 0xd4, 0xda,
  0x5a, 0xaf, 0x34, 0xfb, 0x32, 0x2b, 0x4b, 0xd3,
  0xd2, 0x14, 0xdc, 0xda, 0xc8, 0x4e, 0xc9, 0x52,
  0x24, 0x6b, 0x53, 0xb9, 0xaa, 0xf5, 0x51, 0xb5,
  0x42, 0xe9, 0x31, 0xc0, 0x9b, 0xb0, 0xd4, 0xa7,
  0xa6, 0xd4, 0x85, 0x6f, 0xca, 0x58, 0xc2, 0x0a,
  0x2e, 0xe6, 0x6b, 0x6b, 0x89, 0xc3, 0xb4, 0xd8,
  0x2f, 0x6d, 0x25, 0x0d, 0xd3, 0x52, 0xdf, 0x74,
  0x14, 0xdf, 0x44, 0x47, 0xfb, 0xd2, 0x51, 0x72,
  0xa2, 0x1e, 0x75, 0x09, 0x47, 0x89, 0x8d, 0x7c,
  0xb4, 0x07, 0xfe,
  // oscar
  0xab, 0xcd, 0xe2, 0xb2, 0x42, 0x3a, 0xdf, 0xe2,
  0xa6, 0x27, 0x49, 0xae, 0x7d, 0xc4, 0x17, 0xb7,
  0x38, 0x45, 0xaf, 0xa4, 0xb6, 0x6d, 0x80, 0x03,
  0xd8, 0x0c, 0xf0, 0xa7, 0x9b, 0x07, 0x3c, 0xe0,
  0x80, 0xeb, 0xb5, 0x11, 0x38, 0x45, 0xa9, 0x0a,
  0xd5, 0x00, 0x02, 0x34, 0x75, 0x65, 0xe6, 0xa6,
  0xae, 0xa2, 0x34, 0x6e, 0xaa, 0x8b, 0x9b, 0x24,
  0x13, 0xa5, 0xad, 0xca, 0xa9, 0xc8, 0x86, 0xf3,
  0xce, 0x7a, 0x76, 0x6d, 0xcc, 0xcd, 0xb0, 0x5a,
  0x7a, 0xcf, 0xb9, 0x2e, 0x75, 0x4b, 0x47, 0x89,
  0x83, 0x3a, 0xa9, 0x37, 0xdf, 0xe1, 0x29, 0xad,
  0x48, 0x87, 0xb3, 0xc0, 0xff,
  // papa
  0x0a, 0x28, 0x56, 0xb9, 0xe5, 0x45, 0x55, 0x84,
  0x49, 0xcc, 0x93, 0x67, 0xd7, 0x19, 0x26, 0x4b,
  0x4e, 0x91, 0xdd, 0x44, 0xba, 0xae, 0xbe, 0xc5,
  0x2c, 0x10, 0x24, 0x42, 0xb9, 0x8b, 0xc8, 0x06,
  0x60, 0x80, 0xf1, 0xe9, 0xab, 0xc9, 0xa6, 0x23,
  0xd4, 0x36, 0xdf, 0xe9, 0xcc, 0x55, 0x74, 0x86,
  0x6b, 0x9f, 0x71, 0x66, 0xbd, 0xe1, 0xe6, 0xbb,
  0xdb, 0x9f, 0x53, 0x45, 0x88, 0xcf, 0xae, 0x3f,
  0xfc,
  // quebec
  0x0c, 0x88, 0x7e, 0x8c, 0x02, 0xa5, 0x0c, 0x31,
  0xdd, 0x5c, 0xb2, 0xac, 0x3a, 0x5b, 0xcf, 0x4c,
  0xee, 0xbb, 0xbb, 0xde, 0xa5, 0xcd, 0xa8, 0xb4,
  0x75, 0x4d, 0x1c, 0xb7, 0xd1, 0xd5, 0x28, 0xee,
  0xe6, 0x5b, 0x76, 0x73, 0xea, 0x1a, 0xc4, 0x33,
  0xf3, 0xf1, 0xad, 0x77, 0x37, 0xa7, 0xb6, 0xb6,
  0xec, 0x12, 0x91, 0x9b, 0xf2, 0x8e, 0x40, 0x11,
  0xca, 0x5d, 0x44, 0x36, 0x80, 0x00, 0x7a, 0x2f,
  0x53, 0x40, 0x2d, 0x24, 0x14, 0x80, 0xff,
  // romeo
  0x22, 0xd7, 0x39, 0x38, 0xca, 0xec, 0xdb, 0xbe,
  0xb4, 0xa1, 0x98, 0x5a, 0xb9, 0xf2, 0x53, 0x46,
  0x6f, 0xe9, 0x69, 0xca, 0x4e, 0xd6, 0x89, 0x57,
  0x0e, 0x69, 0x3f, 0x71, 0x61, 0xd9, 0x95, 0x98,
  0x65, 0x87, 0x25, 0x6c, 0x86, 0x64, 0x4c, 0xac,
  0xf5, 0xf8, 0xa4, 0xcd, 0x86, 0x7a, 0xd0, 0xe6,
  0x55, 0x4f, 0xd7, 0x02, 0xa5, 0x7b, 0x76, 0xbd,
  0xdb, 0xdd, 0xaf, 0xa1, 0xaa, 0x54, 0x1d, 0xdb,
  0xb2, 0xa6, 0xec, 0xc3, 0xd3, 0x64, 0x73, 0x99,
  0x62, 0xc8, 0x2c, 0xd5, 0xdf, 0x69, 0x09, 0xa1,
  0x33, 0xd8, 0xf2, 0xe6, 0x25, 0xae, 0x6e, 0x0f,
  0xb6, 0xb2, 0x54, 0xdc, 0xf8, 0x1d, 0xfe,
  // sierra
  0x0c, 0xf8, 0xad, 0x54, 0x03, 0x06, 0xf8, 0x2d,
  0xd5, 0x01, 0xbf, 0x94, 0x39, 0xe0, 0xe7, 0x32,
  0x0b, 0xb4, 0xb0, 0x3b, 0x25, 0x75, 0x5f, 0xbd,
  0xe2, 0x11, 0x0d, 0x39, 0x63, 0xf5, 0x48, 0x46,
  0x34, 0xe0, 0xea, 0x4d, 0x23, 0x1d, 0x49, 0x91,
  0xbb, 0x56, 0x8d, 0x6c, 0x78, 0x45, 0xd9, 0x7c,
  0xb2, 0xf2, 0xe1, 0x9c, 0x78, 0xe2, 0xf1, 0xc9,
  0x87, 0x09, 0x92, 0xb1, 0xd7, 0x27, 0x6b, 0x2e,
  0xd9, 0xc7, 0x5e, 0x9f, 0xac, 0x84, 0xe4, 0x1c,
  0x79, 0xbd, 0xd2, 0xd4, 0xc4, 0xb2, 0x79, 0xcd,
  0xc8, 0x52, 0x97, 0xf0, 0xa6, 0x3c, 0xa3, 0x4c,
  0x53, 0xc3, 0x9a, 0xf2, 0x8c, 0x26, 0x55, 0x0b,
  0x1d, 0xea, 0xb3, 0xa6, 0x14, 0x3d, 0x2d, 0x35,
  0xcf, 0x99, 0xb2, 0x1b, 0xf3, 0xd0, 0x3e, 0x6b,
  0x29, 0x7a, 0xdc, 0x53, 0x36, 0x8f, 0x35, 0xc5,
  0xd6, 0x70, 0x7f, 0xd5, 0xf6, 0x14, 0xdb, 0xc2,
  0x7c, 0x55, 0x39, 0x73, 0x4c, 0x2f, 0xf1, 0x97,
  0xe9, 0xca, 0x6a, 0xb5, 0xc2, 0x76, 0x96, 0x2b,
  0x87, 0xd2, 0xd2, 0x58, 0x09, 0xff,
  // tango
  0x0e, 0xd8, 0x5c, 0xcd, 0x03, 0xcb, 0x2b, 0xd9,
  0xd4, 0x23, 0x2b, 0xad, 0xa8, 0x26, 0x57, 0x8f,
  0x58, 0xb2, 0xe2, 0x56, 0x5c, 0x2d, 0x63, 0xf6,
  0x8a, 0x5b, 0x36, 0xf5, 0xcc, 0x59, 0x2b, 0x6e,
  0x91, 0xb5, 0xdb, 0x42, 0xb7, 0xa4, 0x5a, 0xea,
  0x34, 0x57, 0x5d, 0xb2, 0x62, 0x68, 0x5c, 0x55,
  0xb5, 0x2b, 0xa2, 0xa2, 0x09, 0x13, 0xa7, 0xa5,
  0xad, 0x2a, 0x98, 0x53, 0x56, 0x8f, 0xbe, 0xb2,
  0x30, 0x19, 0xdd, 0xb3, 0xfa, 0x22, 0xcb, 0xa4,
  0xb4, 0xeb, 0xe8, 0xb2, 0xea, 0x90, 0x92, 0x2e,
  0x6d, 0x0a, 0xbe, 0xc3, 0x52, 0x3a, 0xa7, 0x35,
  0xc4, 0x0a, 0x4b, 0xd9, 0x5b, 0xf6, 0x50, 0x32,
  0x3c, 0xa4, 0x73, 0xb8, 0x43, 0x0b, 0x37, 0x93,
  0xd5, 0xe6, 0xf6, 0x35, 0xdd, 0x95, 0x7f, 0xab,
  0xdb, 0x87, 0xf2, 0x34, 0xde, 0x07, 0xff,
  // uniform
  0xa1, 0x3f, 0x56, 0x98, 0xd4, 0xb6, 0xe6, 0xae,
  0xd5, 0xc7, 0xa8, 0x01, 0xc5, 0xda, 0x53, 0x2d,
  0x97, 0x06, 0x12, 0xd9, 0x4f, 0xdc, 0x6d, 0x30,
  0xa6, 0x65, 0xdf, 0x61, 0xf3, 0x8b, 0x11, 0xcf,
  0xe0, 0xae, 0xc9, 0xcf, 0x4e, 0x5d, 0x38, 0xea,
  0x75, 0xff, 0x04, 0x45, 0x47, 0x84, 0xca, 0xe6,
  0x1d, 0xf7, 0x8c, 0x01, 0xcd, 0x97, 0x6a, 0x40,
  0x03, 0x1a, 0x28, 0x45, 0xd0, 0xdb, 0x61, 0xec,
  0x7d, 0x17, 0xbb, 0x3e, 0x4d, 0x16, 0xdb, 0x9a,
  0xea, 0xf5, 0x76, 0xab, 0x2f, 0x6a, 0x43, 0x46,
  0xbc, 0xcd, 0xb9, 0x6d, 0xd9, 0xb5, 0xda, 0x70,
  0xdf, 0xb2, 0xe6, 0x94, 0xea, 0xcd, 0x9d, 0xdd,
  0x9a, 0xbc, 0x73, 0xa9, 0x28, 0x35, 0x5b, 0x12,
  0x41, 0xe1, 0x96, 0xd4, 0x6d, 0x4d, 0x24, 0xa7,
  0x8a, 0x94, 0xb8, 0xfb, 0x3d, 0x1c, 0xcd, 0x76,
  0x78, 0x50, 0xea, 0x78, 0xc0, 0xff,
  // victor
  0xae, 0x6f, 0x52, 0x55, 0xcd, 0xdd, 0xa8, 0xb9,
  0x72, 0x55, 0x95, 0x70, 0xe3, 0xe6, 0xe9, 0xdd,
  0xd4, 0x84, 0x4e, 0x99, 0xa7, 0x4b, 0x0b, 0x65,
  0xa5, 0x2b, 0x6c, 0x2e, 0x4d, 0x42, 0xb6, 0xac,
  0xa8, 0xdb, 0x12, 0x49, 0x5d, 0xbd, 0xe2, 0x1e,
  0x02, 0x2d, 0x6c, 0x35, 0x30, 0xa0, 0x72, 0x46,
  0x04, 0x4e, 0x51, 0xaa, 0x42, 0x35, 0x00, 0x40,
  0x01, 0x33, 0x49, 0x3a, 0x60, 0x5a, 0xf1, 0xd2,
  0x95, 0x6c, 0x2c, 0x2d, 0x5d, 0x5a, 0x9f, 0x63,
  0x21, 0x9f, 0xe6, 0x2f, 0x73, 0x29, 0x4d, 0xbc,
  0x94, 0xaf, 0x2d, 0xa5, 0x34, 0xf1, 0x72, 0xb6,
  0xb4, 0x94, 0xba, 0x82, 0xc3, 0xfe, 0xcb, 0x5a,
  0x46, 0x93, 0x34, 0xe5, 0x2b, 0x5b, 0xe9, 0x85,
  0x5a, 0xe2, 0xc7, 0xed, 0xe5, 0x0a, 0xa7, 0x4b,
  0x27, 0xf8,
  // whiskey
  0x04, 0x88, 0xae, 0x8c, 0x03, 0x12, 0x08, 0x5e,
  0x74, 0x65, 0xe9, 0xec, 0x68, 0x04, 0x59, 0x46,
  0x78, 0x41, 0xd7, 0xe3, 0x37, 0x6d, 0x62, 0xc3,
  0x5b, 0xaf, 0xdf, 0xc2, 0xea, 0x54, 0xd2, 0xe3,
  0x89, 0x01, 0x7e, 0x2b, 0xf7, 0x80, 0x07, 0x14,
  0xd0, 0xe5, 0x15, 0x38, 0x60, 0x8c, 0x70, 0x03,
  0x04, 0x29, 0x36, 0xaa, 0x5e, 0x14, 0x34, 0x72,
  0xf6, 0xa8, 0xa6, 0x6f, 0x82, 0xf4, 0x2d, 0xb3,
  0xeb, 0x4b, 0x5a, 0x67, 0x6a, 0xc0, 0xf0, 0x2f,
  0x71, 0x4f, 0xc7, 0xa8, 0x8a, 0x1c, 0xb9, 0xd8,
  0xdf, 0xee, 0x1e, 0xbb, 0x59, 0xd0, 0xd6, 0xc2,
  0xff,
  // xray
  0x2b, 0xae, 0xde, 0xb4, 0x62, 0x66, 0x9f, 0xb0,
  0x75, 0x73, 0xd3, 0x6e, 0x72, 0xfc, 0x56, 0x54,
  0xcb, 0xba, 0xb6, 0x01, 0x92, 0xc7, 0x26, 0x40,
  0x4b, 0x43, 0x0c, 0xc8, 0x29, 0xc5, 0x01, 0xcf,
  0xb8, 0x1a, 0xe0, 0xa7, 0x14, 0x07, 0xfc, 0x56,
  0xea, 0x01, 0x05, 0x98, 0x60, 0x5a, 0x92, 0xd4,
  0x29, 0xb5, 0xb8, 0xeb, 0xc8, 0x52, 0x17, 0xb3,
  0x96, 0x6e, 0x23, 0x2f, 0x29, 0x54, 0x5b, 0xf6,
  0x8d, 0xae, 0xa9, 0x32, 0x5e, 0xdb, 0x37, 0xfa,
  0xa1, 0xdb, 0xb1, 0x74, 0xcb, 0x68, 0xbb, 0x49,
  0x91, 0xf6, 0xcd, 0x63, 0x1e, 0x3a, 0x85, 0x3a,
  0x56, 0xb7, 0x79, 0x98, 0x62, 0xea, 0xf8, 0xdc,
  0xf6, 0x9e, 0x83, 0xd4, 0xe3, 0x49, 0x38, 0x7a,
  0x71, 0x54, 0xaf, 0xd9, 0xe1, 0xe8, 0x53, 0x55,
  0xb8, 0xe7, 0xc2, 0xff,
  // yankee
  0x6e, 0xe8, 0x42, 0x58, 0xb6, 0x6b, 0xa7, 0x61,
  0x68, 0x25, 0xcc, 0x59, 0xb4, 0x86, 0x11, 0x82,
  0xc8, 0x6a, 0xf1, 0x2a, 0x47, 0x2e, 0x12, 0x8d,
  0x37, 0x27, 0xef, 0xc9, 0xc9, 0xa3, 0x6e, 0x9f,
  0x6c, 0xd4, 0x22, 0x73, 0x7f, 0xb4, 0x92, 0x51,
  0x0b, 0x2d, 0x62, 0xe2, 0x48, 0x46, 0x43, 0xd7,
  0x2e, 0x29, 0x2e, 0x4b, 0x92, 0xaa, 0x28, 0x5c,
  0x8b, 0xa6, 0x6a, 0xeb, 0x24, 0x95, 0xe3, 0x80,
  0x1d, 0x93, 0x35, 0x90, 0xf2, 0x59, 0x03, 0x45,
  0xb3, 0x75, 0x29, 0x47, 0x27, 0x96, 0x98, 0xc5,
  0x65, 0x18, 0xcd, 0x88, 0xbc, 0x16, 0xd7, 0x21,
  0xad, 0x63, 0x10, 0x49, 0x6e, 0xed, 0xb8, 0xf9,
  0x1d, 0xfe,
  // zulu
  0x6d, 0xf8, 0xde, 0xc4, 0xc4, 0xe8, 0x29, 0x60,
  0x00, 0x2e, 0x0f, 0x9c, 0x78, 0x29, 0x71, 0x2a,
  0x4e, 0x77, 0xc3, 0x15, 0x74, 0x2a, 0xae, 0xc3,
  0xce, 0x76, 0x30, 0xc2, 0xa5, 0x44, 0x78, 0xd1,
  0x6d, 0x4f, 0x46, 0x39, 0xb8, 0xbb, 0x07, 0xf6,
  0x5b, 0x6d, 0x91, 0x6e, 0xa9, 0xf2, 0x65, 0xf4,
  0xc9, 0x98, 0x97, 0x69, 0x9f, 0x3a, 0xe7, 0x2d,
  0x6c, 0xc1, 0x9a, 0x8f, 0xca, 0xde, 0x70, 0x04,
  0x9d, 0xee, 0xc9, 0x79, 0xe2, 0xe1, 0x1f, 0xf8
};

/* extern */
const uint8_t bank_4[] = {
  // analog
  0xa7, 0xa8, 0x51, 0xc3, 0x3b, 0xa4, 0x9c, 0xbc,
  0x66, 0x73, 0x8f, 0xb2, 0x73, 0xf2, 0x1a, 0x35,
  0xbc, 0x52, 0xf6, 0x49, 0x6b, 0x32, 0xf3, 0x48,
  0xc9, 0x27, 0xa9, 0x5e, 0xd3, 0x3a, 0x64, 0x9f,
  0xa4, 0x78, 0x75, 0x8f, 0xb2, 0x72, 0xd2, 0x6c,
  0xa4, 0x35, 0x43, 0xce, 0xc8, 0x82, 0xd6, 0xd6,
  0x30, 0x27, 0x2d, 0xf3, 0x5a, 0x5b, 0x22, 0x92,
  0x8e, 0xdc, 0x1b, 0x6d, 0x33, 0x73, 0xb2, 0x0a,
  0x6f, 0x23, 0x4d, 0xcd, 0xf1, 0xa8, 0x7c, 0x8d,
  0x20, 0xcb, 0xd4, 0xa3, 0xf6, 0x35, 0x9d, 0x25,
  0x13, 0xb7, 0xda, 0xc6, 0x35, 0x96, 0x98, 0xda,
  0x3a, 0x67, 0xce, 0x59, 0x7c, 0xce, 0xe8, 0x6c,
  0x58, 0x67, 0xae, 0x2a, 0xa7, 0x8b, 0x6e, 0x53,
  0x39, 0xa3, 0x9d, 0x3e, 0xba, 0x4d, 0xa5, 0x1a,
  0x7d, 0xfa, 0x18, 0x36, 0x94, 0xab, 0xca, 0xe9,
  0x93, 0xbb, 0x50, 0xce, 0x51, 0x67, 0x48, 0xe1,
  0xc2, 0x38, 0xc7, 0x9c, 0x21, 0xf9, 0x0b, 0x15,
  0x9f, 0x7c, 0xc6, 0x58, 0x56, 0xcd, 0x7c, 0xf2,
  0x19, 0x93, 0xbb, 0x30, 0xd3, 0xd9, 0x67, 0x2c,
  0x66, 0x32, 0x54, 0xe6, 0x9c, 0xb9, 0xa8, 0x8a,
  0x52, 0x99, 0x7d, 0xd6, 0x22, 0x53, 0x8b, 0x65,
  0x4e, 0xd9, 0xa2, 0x35, 0x4b, 0xa8, 0xb9, 0x6a,
  0x83, 0xc9, 0x4f, 0xd4, 0xed, 0x98, 0x0d, 0xa6,
  0x9a, 0x64, 0x89, 0xac, 0x00, 0x27, 0x78, 0x08,
  0x20, 0x04, 0x1d, 0x00, 0xc0, 0xff,
  // circuit
  0x0c, 0x98, 0xb2, 0x4d, 0x00, 0x47, 0x85, 0x0b,
  0xe0, 0xe8, 0x0c, 0x03, 0xbc, 0x90, 0xe1, 0x80,
  0x6f, 0xdd, 0x03, 0x70, 0xb5, 0x79, 0x01, 0x2a,
  0x51, 0x3f, 0x65, 0x72, 0xea, 0xe9, 0x19, 0xfb,
  0x94, 0x29, 0x8a, 0x57, 0x58, 0xa3, 0x53, 0xa5,
  0x42, 0x5e, 0x6e, 0x8d, 0x4f, 0x95, 0x0a, 0xeb,
  0x38, 0x2f, 0x59, 0x75, 0xac, 0xa4, 0x6b, 0x32,
  0x65, 0xd4, 0x79, 0x62, 0x0c, 0xc6, 0xe8, 0xd6,
  0xe6, 0x8d, 0x3e, 0x14, 0xb3, 0x08, 0xc0, 0x13,
  0x36, 0x01, 0x54, 0xc1, 0x02, 0x05, 0x54, 0xa3,
  0x62, 0x80, 0x20, 0x25, 0x4f, 0xdf, 0x2d, 0x8b,
  0x67, 0x46, 0x3e, 0x43, 0x73, 0x22, 0x9a, 0x59,
  0xe7, 0xcc, 0xcd, 0x8a, 0x5a, 0x66, 0xe5, 0xb3,
  0x34, 0x2f, 0x66, 0x59, 0x55, 0xcf, 0x5a, 0x3d,
  0xbb, 0x57, 0x85, 0x3d, 0x6b, 0x35, 0x62, 0x11,
  0x55, 0xf9, 0x6c, 0xd5, 0xa8, 0x46, 0x56, 0xe9,
  0xb6, 0x44, 0x61, 0xd5, 0x69, 0xa6, 0x08, 0xe0,
  0x70, 0x0c, 0x01, 0x06, 0xa6, 0x6a, 0xf1, 0xf6,
  0xa6, 0x91, 0x11, 0x6b, 0xc5, 0x4b, 0xa9, 0x79,
  0x66, 0x64, 0xa3, 0x36, 0x11, 0xdc, 0x5d, 0xb5,
  0x00, 0x00, 0xfe,
  // clock
  0xa0, 0x80, 0x72, 0x35, 0x14, 0x90, 0x36, 0xa5,
  0x01, 0xf2, 0x75, 0x35, 0x40, 0x32, 0x4b, 0x06,
  0x88, 0xba, 0x59, 0x01, 0xca, 0xb6, 0xb6, 0xda,
  0x84, 0x35, 0xd5, 0xb4, 0x57, 0x6a, 0x53, 0xc7,
  0x58, 0xc7, 0x4e, 0xab, 0x5c, 0x2b, 0x32, 0x6d,
  0x6b, 0xa3, 0xf2, 0x23, 0x54, 0xb5, 0x9d, 0xac,
  0x2a, 0xce, 0x0c, 0xf1, 0x55, 0xba, 0x9a, 0xb8,
  0x22, 0x39, 0x47, 0xf1, 0xe9, 0xe2, 0x8c, 0xe4,
  0x6c, 0xc5, 0x67, 0x88, 0xdb, 0x4b, 0x3a, 0x9c,
  0xac, 0x39, 0x1e, 0x0f, 0xf7, 0x92, 0xd3, 0xb6,
  0x58, 0x23, 0x95, 0xc3, 0x4a, 0x3b, 0x73, 0x8a,
  0x72, 0x0a, 0xcb, 0xe3, 0xaf, 0xc9, 0x26, 0x38,
  0x22, 0x1b, 0x20, 0x78, 0x11, 0x01, 0x04, 0xaf,
  0x44, 0x80, 0x10, 0x04, 0x08, 0x10, 0xb3, 0x12,
  0x01, 0x1c, 0x77, 0x41, 0x7e, 0x13, 0x6e, 0x51,
  0x9e, 0xb8, 0xf8, 0xb5, 0xb5, 0x86, 0x7b, 0x9c,
  0xe6, 0xb7, 0xde, 0xe4, 0xee, 0x75, 0x14, 0x50,
  0x92, 0xa9, 0x02, 0x6a, 0x61, 0x61, 0x40, 0x89,
  0xcc, 0x04, 0x48, 0x5a, 0x89, 0x00, 0xd1, 0x08,
  0x03, 0x00, 0xfc,
  // control
  0x50, 0x82, 0xda, 0x56, 0x32, 0x3d, 0xce, 0x09,
  0x5a, 0x38, 0xb1, 0x72, 0xcb, 0x27, 0x69, 0x75,
  0x4d, 0x4d, 0x93, 0x9e, 0xb2, 0x06, 0x55, 0x57,
  0xaf, 0x75, 0x9a, 0x1a, 0x45, 0x2d, 0x22, 0xd6,
  0x69, 0x6a, 0x10, 0x55, 0x8f, 0xc6, 0xa7, 0xa9,
  0x96, 0x9c, 0x23, 0x13, 0xae, 0x36, 0x4a, 0xca,
  0xf0, 0xb2, 0x3d, 0x9a, 0xa8, 0xa8, 0x2c, 0xda,
  0xd1, 0x68, 0x82, 0xe4, 0xd4, 0x1c, 0x45, 0xa3,
  0x89, 0x9a, 0x9d, 0xa7, 0x1d, 0xb5, 0xc6, 0x2b,
  0x09, 0xed, 0x95, 0x33, 0x9a, 0xa2, 0xd0, 0x2c,
  0x33, 0x69, 0x00, 0x66, 0x11, 0x0a, 0xc0, 0x9c,
  0x1d, 0x09, 0x98, 0x7d, 0x3c, 0x01, 0xbd, 0xa7,
  0x25, 0xa0, 0xd7, 0xb4, 0x00, 0xb4, 0x14, 0x71,
  0xd2, 0x16, 0xc2, 0x55, 0x55, 0xee, 0x49, 0x63,
  0xe1, 0xb0, 0x30, 0xb7, 0x27, 0x8b, 0x5d, 0xd2,
  0x4c, 0xd2, 0x9e, 0x22, 0x36, 0x69, 0x31, 0x69,
  0xbd, 0xca, 0x30, 0x2c, 0xc5, 0xb4, 0xd5, 0xa9,
  0x43, 0xcb, 0x10, 0xd3, 0x4e, 0xa7, 0x0d, 0xa5,
  0x43, 0x55, 0x56, 0x9d, 0x2e, 0xe4, 0x09, 0x76,
  0x5d, 0xb8, 0xfa, 0x90, 0x36, 0xc9, 0x75, 0xd5,
  0xea, 0x43, 0xda, 0x24, 0xd7, 0x55, 0x63, 0xf0,
  0x75, 0x9c, 0xdc, 0x66, 0xb6, 0xd1, 0x5f, 0x17,
  0xa9, 0x2a, 0xdc, 0x46, 0x77, 0x43, 0xa4, 0xb2,
  0x50, 0x99, 0xdc, 0x09, 0x92, 0xf1, 0xd0, 0x65,
  0xf2, 0x7d, 0x0c, 0xcb, 0x4b, 0x95, 0xd9, 0xcd,
  0x36, 0xf2, 0xa8, 0x99, 0x16, 0xdb, 0x46, 0xa1,
  0xa2, 0x66, 0x5a, 0x6c, 0xda, 0x00, 0xf3, 0x59,
  0x69, 0x35, 0x71, 0x0b, 0xcc, 0x6b, 0x13, 0x00,
  0x6f, 0x67, 0x00, 0xf8,
  // digital
  0x20, 0x80, 0xc4, 0x6c, 0x4e, 0xb6, 0x9c, 0xb2,
  0x69, 0xc6, 0x39, 0x79, 0x77, 0xc2, 0x1a, 0x13,
  0xe7, 0xe4, 0xdd, 0x2a, 0x9b, 0x77, 0x95, 0x93,
  0x37, 0xab, 0xe4, 0x59, 0x95, 0x4f, 0xde, 0xad,
  0x91, 0x46, 0x4d, 0x3e, 0x79, 0xb7, 0xca, 0xea,
  0x5d, 0xa5, 0xe5, 0x99, 0xb3, 0x67, 0x56, 0xa0,
  0x50, 0x1a, 0xe6, 0x95, 0x13, 0x42, 0x52, 0x59,
  0x31, 0x46, 0x75, 0xd7, 0x6e, 0xe9, 0x72, 0xca,
  0xa4, 0x9e, 0x24, 0x00, 0x8d, 0xa2, 0x25, 0xa0,
  0x10, 0x8c, 0xd3, 0x8c, 0xa0, 0x2a, 0x66, 0xad,
  0x4e, 0x57, 0xa4, 0x9a, 0x65, 0xa5, 0x3a, 0x5d,
  0x51, 0xe2, 0xd2, 0xde, 0x38, 0x00, 0x2a, 0x50,
  0x05, 0x40, 0x46, 0xee, 0xd5, 0x87, 0x2c, 0xa1,
  0x13, 0x8e, 0xcf, 0xe0, 0x93, 0xa6, 0x79, 0xd4,
  0x5e, 0x83, 0xef, 0x6a, 0xd6, 0x19, 0x65, 0x0d,
  0x3e, 0xa7, 0x71, 0x65, 0xa5, 0x31, 0xf8, 0xe1,
  0xa2, 0x5d, 0x61, 0xd7, 0x10, 0x52, 0x05, 0x79,
  0x8d, 0x5e, 0x63, 0xb4, 0x5d, 0x24, 0x7e, 0x7b,
  0x8d, 0xd1, 0x75, 0x13, 0xfb, 0xec, 0x35, 0x46,
  0x37, 0xc5, 0xec, 0x93, 0xc6, 0x14, 0xec, 0x34,
  0x71, 0x4c, 0x19, 0x53, 0x70, 0xd3, 0xc8, 0x39,
  0xa6, 0x4c, 0xc1, 0xcd, 0x20, 0xe7, 0x59, 0x00,
  0x80, 0xff,
  // electronic
  0xa7, 0xef, 0xd2, 0xc5, 0xdd, 0x2b, 0x9f, 0xbe,
  0x78, 0x17, 0xaf, 0x8a, 0x72, 0xba, 0x62, 0x5d,
  0xcd, 0xb3, 0xcc, 0xe9, 0xb2, 0xf6, 0x50, 0xab,
  0x29, 0xab, 0x8f, 0xdc, 0xd3, 0x35, 0xa6, 0x8e,
  0x3e, 0xd0, 0x0e, 0x33, 0x1f, 0xd3, 0x3a, 0x4f,
  0x36, 0xb9, 0xa2, 0x76, 0xeb, 0x3c, 0x5d, 0x97,
  0x88, 0x29, 0xab, 0x0d, 0x36, 0xcd, 0x6c, 0xc2,
  0x9e, 0x36, 0x79, 0x37, 0x8d, 0x91, 0x72, 0xda,
  0x1c, 0xdd, 0xb5, 0x46, 0xca, 0x69, 0x4b, 0x32,
  0xf7, 0x6a, 0xd9, 0xa7, 0x2d, 0x51, 0xc3, 0xb2,
  0x2c, 0x9f, 0xa6, 0x26, 0x0e, 0x89, 0x92, 0x1d,
  0xea, 0xec, 0xd5, 0x53, 0xdd, 0x32, 0xa9, 0x9b,
  0x32, 0xcd, 0x8a, 0x34, 0x0a, 0x68, 0x8e, 0x95,
  0x01, 0x99, 0x53, 0x10, 0x20, 0x11, 0x0a, 0x07,
  0x34, 0xa3, 0x9d, 0x80, 0x55, 0xd3, 0x13, 0x30,
  0xfa, 0x54, 0x02, 0x5a, 0xeb, 0x4c, 0x40, 0x8e,
  0x6c, 0x27, 0xcf, 0x8d, 0xdd, 0xd3, 0xec, 0x9c,
  0x22, 0x35, 0xae, 0x70, 0x4d, 0x73, 0x8a, 0xd4,
  0xb4, 0xcd, 0xad, 0xc9, 0x29, 0x52, 0xf5, 0x76,
  0x8d, 0x29, 0xa7, 0x48, 0x35, 0x33, 0x38, 0xab,
  0x9c, 0x32, 0xe5, 0xca, 0xe4, 0xa8, 0x7a, 0x9a,
  0x94, 0x2a, 0x5d, 0x32, 0xca, 0xe9, 0x52, 0x8b,
  0x34, 0x2f, 0x39, 0xa7, 0x4f, 0x39, 0xc3, 0x35,
  0xac, 0x9c, 0xb1, 0x84, 0x28, 0x0d, 0xb7, 0xbc,
  0xe6, 0x6a, 0xa5, 0x78, 0x24, 0x74, 0xdb, 0x82,
  0x92, 0x94, 0x76, 0x2b, 0x6b, 0x2f, 0xca, 0x4a,
  0x2b, 0x44, 0x9f, 0x2d, 0x1b, 0xb7, 0x8a, 0x10,
  0x73, 0xf6, 0x1a, 0x54, 0x2b, 0x3d, 0xf0, 0xd9,
  0x5b, 0x11, 0x8d, 0xf0, 0xd0, 0x67, 0x6b, 0x4d,
  0xc4, 0xdd, 0x4b, 0x0b, 0xc0, 0x6a, 0x32, 0x02,
  0xc8, 0xe0, 0x4e, 0x00, 0x6a, 0xd3, 0x13, 0xd9,
  0xc7, 0x79, 0x98, 0x2a, 0x29, 0x64, 0x6f, 0xcd,
  0x6a, 0xde, 0x44, 0x01, 0x3d, 0x3a, 0x29, 0xa0,
  0x79, 0x25, 0x01, 0x14, 0xc3, 0xcc, 0x80, 0xac,
  0x54, 0x08, 0x90, 0x0d, 0x09, 0x00, 0xc0, 0xff,
  // filter
  0x8c, 0x9f, 0x69, 0x2a, 0x3d, 0xe2, 0x38, 0x7e,
  0xfa, 0x9d, 0x72, 0x8f, 0xab, 0x80, 0x11, 0xca,
  0x05, 0xd0, 0x4d, 0x9a, 0x02, 0x86, 0x73, 0x73,
  0x40, 0x57, 0x69, 0x09, 0x90, 0x2a, 0xe2, 0x14,
  0x45, 0xbb, 0x86, 0x66, 0xe5, 0x53, 0x45, 0x33,
  0x1a, 0x9e, 0x45, 0x56, 0x15, 0xe4, 0xa7, 0xa9,
  0x95, 0x5a, 0x55, 0x12, 0xb1, 0x45, 0x52, 0x7b,
  0x55, 0x81, 0x6d, 0x07, 0x4b, 0x95, 0x51, 0x05,
  0xbe, 0x9d, 0xa0, 0x93, 0x4b, 0xe5, 0xc5, 0x85,
  0x92, 0xcf, 0x31, 0x5d, 0x04, 0x91, 0xe9, 0xe1,
  0x14, 0x1c, 0xd0, 0x58, 0x59, 0x00, 0x36, 0x31,
  0x4f, 0x40, 0xc6, 0x66, 0xa7, 0xcf, 0xc1, 0xcc,
  0xdd, 0x2b, 0x9f, 0xbe, 0x24, 0x89, 0x08, 0x8d,
  0xb3, 0xa6, 0x54, 0xa8, 0xc2, 0xac, 0xca, 0x9a,
  0x53, 0xa3, 0x2a, 0xf5, 0xca, 0x63, 0x8e, 0x85,
  0xb3, 0x5d, 0x26, 0x8d, 0x39, 0x57, 0xec, 0x52,
  0x1b, 0xd2, 0xe6, 0x5c, 0xb1, 0xda, 0x74, 0x50,
  0x5b, 0x52, 0xa1, 0x2c, 0xd3, 0x08, 0x65, 0xc9,
  0x05, 0x23, 0x4d, 0x23, 0xa6, 0x35, 0x67, 0xf4,
  0x70, 0xac, 0xe4, 0xd6, 0x14, 0x31, 0xdc, 0xa8,
  0x8a, 0x28, 0x63, 0x80, 0x52, 0xd7, 0xb0, 0x62,
  0xce, 0x11, 0x4c, 0x5d, 0x2a, 0x03, 0x00, 0xfc,
  // frequency
  0x04, 0xe8, 0x21, 0x9c, 0x00, 0xa3, 0x94, 0x33,
  0x60, 0x78, 0x33, 0x03, 0x54, 0x13, 0xe6, 0x80,
  0x61, 0x22, 0x1c, 0xd0, 0x6d, 0x78, 0x00, 0x9a,
  0x0a, 0x73, 0x40, 0xd3, 0x61, 0x27, 0x2e, 0x2a,
  0xdc, 0xdd, 0x9c, 0x8c, 0x30, 0x4c, 0xb4, 0x34,
  0x5d, 0xbd, 0x82, 0xd8, 0xc8, 0xc3, 0x74, 0xca,
  0x09, 0x72, 0x25, 0x0d, 0xd7, 0xc5, 0x27, 0xa8,
  0x95, 0xc4, 0xdd, 0x6e, 0x9f, 0xb0, 0x26, 0xe2,
  0xcc, 0x98, 0x72, 0xa2, 0xea, 0x89, 0x27, 0x73,
  0x54, 0x4a, 0x8a, 0x27, 0x2e, 0xa9, 0xb1, 0xac,
  0x60, 0xb6, 0xad, 0xc2, 0x6a, 0x97, 0x28, 0xe7,
  0xb2, 0x0e, 0x4f, 0x32, 0xdc, 0x94, 0xca, 0x4b,
  0x34, 0x76, 0xcb, 0xb3, 0x2b, 0x77, 0x05, 0xc7,
  0xab, 0x8f, 0xc9, 0xc2, 0x30, 0xe6, 0x9c, 0x3e,
  0x59, 0x8e, 0x56, 0x9b, 0x7d, 0xfa, 0xe2, 0x28,
  0x43, 0xab, 0xca, 0x19, 0x8a, 0x23, 0x77, 0x9f,
  0x28, 0x6b, 0xcc, 0x86, 0x22, 0x6c, 0xa3, 0x8c,
  0x31, 0x6a, 0xca, 0xf4, 0xb5, 0x3c, 0xa6, 0x24,
  0x29, 0x56, 0xc7, 0x6c, 0x99, 0x82, 0xe4, 0x7a,
  0x49, 0xb1, 0x63, 0xec, 0xc4, 0x45, 0xc3, 0x13,
  0x2b, 0xa0, 0x00, 0x77, 0x05, 0x2c, 0x16, 0xae,
  0x80, 0x23, 0xcd, 0x15, 0xb0, 0x78, 0xa8, 0x01,
  0x96, 0x4c, 0x75, 0x40, 0xc1, 0xae, 0x09, 0x10,
  0xd6, 0xf3, 0x8c, 0xdd, 0x2a, 0x79, 0xd4, 0x94,
  0x33, 0x76, 0x23, 0x14, 0x59, 0x93, 0xcf, 0xd4,
  0x8d, 0x50, 0x54, 0x4d, 0x3e, 0x53, 0x37, 0x42,
  0xd1, 0x35, 0xe5, 0xcc, 0x4d, 0x33, 0x67, 0x4f,
  0xd9, 0x33, 0x37, 0xc3, 0x1c, 0xbd, 0xa5, 0xc7,
  0x52, 0x24, 0x66, 0x4d, 0x84, 0x19, 0x4b, 0xb7,
  0x28, 0xb1, 0x19, 0x65, 0x2c, 0xc3, 0x22, 0xfb,
  0x76, 0x98, 0xb6, 0x0c, 0x03, 0x62, 0x5b, 0x61,
  0xcb, 0xd2, 0x0d, 0xa8, 0x5f, 0x85, 0x29, 0x6b,
  0x65, 0xa4, 0x7d, 0x1e, 0x06, 0x00, 0xe0, 0xff,
  // generator
  0xc8, 0x29, 0x98, 0xcb, 0x23, 0x24, 0x1b, 0x60,
  0x7a, 0xce, 0x04, 0xac, 0x28, 0x9a, 0x80, 0xd5,
  0xdb, 0x0b, 0x90, 0x05, 0xc5, 0x49, 0x8b, 0x67,
  0x8d, 0xce, 0xca, 0x27, 0x2d, 0x5e, 0x34, 0x23,
  0x2b, 0x9d, 0x34, 0x07, 0xb5, 0xf2, 0x8a, 0x74,
  0xd2, 0x12, 0xcd, 0xda, 0x32, 0xf2, 0x49, 0x73,
  0xd4, 0x28, 0xab, 0xc8, 0x27, 0xcb, 0xc9, 0xa2,
  0xb4, 0x2c, 0x9f, 0x2c, 0x45, 0x4d, 0xf3, 0xb0,
  0xb5, 0x8a, 0xec, 0xa5, 0xb1, 0x35, 0xd2, 0x29,
  0x72, 0x90, 0xa2, 0xd6, 0xca, 0xa7, 0xcc, 0x49,
  0x52, 0x86, 0x8b, 0xae, 0x2a, 0x17, 0x2a, 0x2d,
  0x1a, 0xbb, 0x9a, 0xd4, 0x29, 0xbd, 0xb0, 0xe1,
  0x68, 0x53, 0xc7, 0x31, 0xb5, 0x1a, 0xad, 0x8d,
  0x1d, 0xc7, 0xd4, 0x6a, 0xb6, 0x2e, 0x36, 0x1c,
  0x31, 0xab, 0x3c, 0xba, 0xdc, 0x31, 0xc3, 0x6d,
  0xc8, 0xe9, 0x52, 0x14, 0xeb, 0xe6, 0x4a, 0xa7,
  0xcb, 0x81, 0xbd, 0xc3, 0x4b, 0x9f, 0xbe, 0x18,
  0x89, 0x0e, 0x0b, 0x73, 0xfa, 0x62, 0x54, 0x27,
  0x2d, 0xf2, 0xe9, 0xb3, 0x32, 0xef, 0xb2, 0x30,
  0xa7, 0xcf, 0xc6, 0xb4, 0xd3, 0xcd, 0x9c, 0x3e,
  0x19, 0xb1, 0xca, 0x8c, 0x74, 0xfa, 0xe2, 0xd9,
  0xad, 0xb2, 0xd2, 0xe9, 0x93, 0x93, 0xf4, 0x76,
  0x5b, 0x67, 0xc8, 0x99, 0xd2, 0xdb, 0x63, 0xad,
  0x21, 0x65, 0x8a, 0x18, 0x89, 0x3c, 0x86, 0x5c,
  0x30, 0xb3, 0x65, 0x52, 0x1b, 0x52, 0xa6, 0xc8,
  0xe6, 0x21, 0x6d, 0xc8, 0x95, 0x2c, 0x97, 0x86,
  0xb4, 0xb1, 0x2c, 0x4c, 0x0f, 0x3d, 0xda, 0xc6,
  0xb2, 0x30, 0x3c, 0xf4, 0x70, 0x19, 0x4b, 0x27,
  0xf3, 0xe4, 0x23, 0x69, 0xac, 0x0b, 0x53, 0xcc,
  0x86, 0x86, 0xb1, 0x66, 0x0c, 0x75, 0x29, 0xea,
  0x96, 0x92, 0x39, 0xd4, 0xb9, 0x28, 0x01, 0xb8,
  0xc7, 0x02, 0x00, 0xf8,
  // instrument
  0x27, 0x2f, 0x82, 0xbd, 0xa6, 0xac, 0x9c, 0x7c,
  0x48, 0x61, 0xe9, 0x9a, 0x73, 0xf2, 0xee, 0x58,
  0xb4, 0xb2, 0xca, 0xc8, 0xbd, 0xe5, 0x6c, 0x6d,
  0xa6, 0x2d, 0x97, 0xd6, 0xda, 0xdd, 0xd5, 0xac,
  0x34, 0x13, 0xb3, 0x48, 0x0f, 0x9d, 0x80, 0x06,
  0x30, 0x02, 0xb0, 0x9d, 0x40, 0x00, 0x5e, 0x2d,
  0x0f, 0xc0, 0xee, 0xe3, 0x06, 0x58, 0xad, 0x52,
  0x01, 0x63, 0x76, 0x18, 0xa0, 0xcf, 0xee, 0x00,
  0xf4, 0x39, 0x55, 0x80, 0x5e, 0x55, 0x4e, 0x51,
  0xa3, 0xaa, 0x84, 0xa7, 0x3a, 0x55, 0xca, 0x98,
  0x51, 0x9e, 0xf8, 0xd4, 0x29, 0x63, 0x44, 0x79,
  0xe2, 0xd5, 0xa4, 0x44, 0x69, 0xa1, 0x8d, 0x5b,
  0x1b, 0x1d, 0xb4, 0x47, 0xd4, 0x6e, 0x6d, 0x72,
  0xd0, 0x1e, 0x59, 0x7b, 0xf4, 0xc9, 0x41, 0x69,
  0x54, 0xec, 0xd5, 0x17, 0x8f, 0x29, 0x19, 0x55,
  0x4e, 0x5f, 0x3c, 0xb9, 0xb9, 0xd7, 0x3e, 0x7d,
  0x8d, 0x66, 0xea, 0x56, 0xeb, 0xf4, 0x35, 0x9b,
  0x59, 0x78, 0x99, 0x33, 0xd4, 0xa2, 0x6e, 0x1e,
  0x61, 0xcf, 0x58, 0x93, 0x99, 0x46, 0x9a, 0x3e,
  0x63, 0x4d, 0x66, 0x96, 0x61, 0xe5, 0x8c, 0x2d,
  0x9a, 0xa9, 0x97, 0x95, 0x33, 0xb6, 0x60, 0xaa,
  0x56, 0x56, 0xda, 0x54, 0x2c, 0x05, 0x75, 0xca,
  0x6a, 0x63, 0x31, 0x98, 0xd2, 0x41, 0x2b, 0xf5,
  0x51, 0x61, 0xea, 0xb4, 0xec, 0x54, 0x55, 0x6e,
  0x1e, 0x61, 0xb6, 0x4f, 0xb2, 0x9c, 0x97, 0x55,
  0x99, 0x56, 0x40, 0xe1, 0x11, 0x00, 0x00, 0xff,
  // knob
  0xad, 0x31, 0xd2, 0xb3, 0x35, 0xa2, 0x96, 0x5a,
  0x4a, 0xef, 0x33, 0x37, 0x5b, 0x2a, 0xad, 0x64,
  0x32, 0x8b, 0xe1, 0xa8, 0x02, 0x57, 0xef, 0xcc,
  0x52, 0xa7, 0x48, 0x81, 0x25, 0x2a, 0xac, 0x9c,
  0x3c, 0x7b, 0x0d, 0xcb, 0x94, 0x7c, 0xb2, 0x50,
  0xdd, 0xc5, 0x42, 0xf2, 0xc9, 0x62, 0x0f, 0x09,
  0x0b, 0xb3, 0x27, 0x8b, 0x23, 0x29, 0xd2, 0xcc,
  0xac, 0x2c, 0x2e, 0x93, 0x8c, 0x10, 0xbb, 0xb2,
  0xb8, 0x4d, 0x32, 0x5c, 0xec, 0x2a, 0xe2, 0x32,
  0x93, 0x72, 0x29, 0xab, 0x8e, 0xd3, 0x4d, 0x32,
  0xc4, 0x9e, 0x26, 0xcd, 0xd0, 0x88, 0x30, 0x73,
  0xfa, 0x54, 0x2b, 0x4c, 0x2b, 0xec, 0x19, 0x52,
  0xae, 0x08, 0xcd, 0x30, 0x67, 0x48, 0x39, 0x23,
  0x34, 0xc2, 0x9c, 0x29, 0x95, 0x0a, 0xd7, 0x0c,
  0x73, 0xe6, 0x94, 0x2a, 0x42, 0xbd, 0xcc, 0x99,
  0x53, 0xcc, 0x70, 0xf5, 0x32, 0x63, 0x49, 0x2e,
  0x33, 0x54, 0xc7, 0x98, 0x85, 0x04, 0x2f, 0xd1,
  0xae, 0x62, 0x26, 0x9e, 0x43, 0xc3, 0xdd, 0x0e,
  0x01, 0xc0, 0x4b, 0x23, 0x80, 0x8c, 0x16, 0x04,
  0x10, 0xd1, 0x02, 0x00, 0xfe,
  // machine
  0xad, 0x4a, 0x1a, 0xdb, 0x2c, 0xe4, 0x94, 0xd6,
  0x49, 0xda, 0xf4, 0x92, 0x53, 0x5a, 0x23, 0x79,
  0xca, 0xc6, 0x74, 0x6b, 0x83, 0xc6, 0xae, 0x68,
  0x4b, 0xab, 0x8a, 0x96, 0x2a, 0xd3, 0x4b, 0xae,
  0x3a, 0x19, 0x8a, 0x1a, 0x29, 0x72, 0xea, 0x1e,
  0x44, 0x78, 0x74, 0x4c, 0x00, 0xbc, 0xc0, 0x28,
  0xc0, 0x08, 0x42, 0x05, 0x98, 0xb3, 0x2c, 0x01,
  0xf3, 0x74, 0x24, 0x60, 0xae, 0xcd, 0x04, 0xac,
  0xbd, 0x99, 0x80, 0x39, 0x4b, 0x4e, 0xdc, 0x3d,
  0x71, 0x64, 0xd4, 0x59, 0x71, 0x92, 0xec, 0xb3,
  0x16, 0x7a, 0xc5, 0x49, 0x72, 0xec, 0x9a, 0xa8,
  0x95, 0x64, 0x49, 0xbe, 0x13, 0x46, 0x57, 0x96,
  0x39, 0xfb, 0xae, 0x88, 0x59, 0x79, 0x11, 0xe4,
  0xd7, 0x26, 0xfe, 0xe4, 0x4d, 0xa1, 0x4e, 0x59,
  0x94, 0x53, 0x0d, 0x4f, 0x9c, 0x15, 0x56, 0x4f,
  0xdb, 0x3d, 0x6a, 0x46, 0xd8, 0x3d, 0x7d, 0xd3,
  0x68, 0x1d, 0x2e, 0xf7, 0x0c, 0x85, 0x4b, 0x94,
  0x9b, 0x9d, 0x33, 0x76, 0x43, 0x1e, 0x1e, 0x76,
  0xd6, 0x58, 0x3d, 0xa9, 0x6a, 0xdb, 0x19, 0x63,
  0x71, 0xe8, 0x52, 0x65, 0xbb, 0x8d, 0xd9, 0x60,
  0x6a, 0x95, 0xe3, 0x36, 0x65, 0x8b, 0xa1, 0x5d,
  0xb6, 0xc7, 0x54, 0x1c, 0x9a, 0x44, 0x39, 0x4a,
  0x53, 0x50, 0x94, 0xd6, 0x19, 0xab, 0x3c, 0x49,
  0x60, 0xf9, 0x14, 0x6d, 0x02, 0x78, 0x2e, 0x0d,
  0x00, 0xf0,
  // modular
  0xad, 0x8e, 0x86, 0xd2, 0xd3, 0x9d, 0x8c, 0x3a,
  0x69, 0xb2, 0xf0, 0x4a, 0xb2, 0xaa, 0xa4, 0xd8,
  0x42, 0xd3, 0xe9, 0x2a, 0x83, 0xe4, 0x48, 0x2f,
  0xa7, 0x23, 0xb7, 0x56, 0x3d, 0x34, 0x93, 0x9d,
  0x3c, 0x84, 0x08, 0x13, 0x89, 0x73, 0xe2, 0x54,
  0xaa, 0x55, 0x3d, 0xca, 0x89, 0x52, 0xcd, 0x16,
  0x8f, 0x28, 0x27, 0x4c, 0x2d, 0x5b, 0x2d, 0xe2,
  0x9c, 0x30, 0x8d, 0x28, 0xf1, 0xb2, 0x7b, 0xa2,
  0xb4, 0x22, 0xd5, 0xdb, 0xca, 0x89, 0xe3, 0x8c,
  0x74, 0x69, 0xab, 0x27, 0x4d, 0x35, 0xca, 0xb9,
  0xa3, 0x9c, 0x32, 0x47, 0xed, 0x90, 0x8e, 0xd2,
  0xda, 0x96, 0xa8, 0x45, 0x2d, 0xf1, 0x1a, 0xd7,
  0x70, 0x22, 0x8f, 0xc4, 0x67, 0x18, 0x86, 0x39,
  0x3a, 0x62, 0x9f, 0xbe, 0x2a, 0x72, 0xef, 0x6c,
  0xb0, 0xfa, 0x24, 0x24, 0xb3, 0x2b, 0xc2, 0xea,
  0xa3, 0xb4, 0x8c, 0xc9, 0x52, 0x6b, 0x88, 0xca,
  0x3c, 0xab, 0x0a, 0xaf, 0x21, 0xe8, 0xf0, 0xa8,
  0x8c, 0xbc, 0xc6, 0xe0, 0x33, 0xd8, 0xb2, 0xca,
  0x1a, 0x42, 0xa8, 0x10, 0xaf, 0xd8, 0x6b, 0x88,
  0x2e, 0x5b, 0xcc, 0x6b, 0x8e, 0x21, 0x86, 0x28,
  0x75, 0x8d, 0xb9, 0x86, 0xe4, 0x3c, 0x2d, 0x25,
  0xc5, 0x18, 0x72, 0xa1, 0xd2, 0xf4, 0x50, 0x63,
  0x28, 0x99, 0xdd, 0x53, 0x46, 0x8d, 0x21, 0x47,
  0xce, 0x08, 0x2a, 0x3d, 0xc6, 0x32, 0xd9, 0x2c,
  0x79, 0xd4, 0x1a, 0x6b, 0xe3, 0xb0, 0xe0, 0x8a,
  0x6d, 0xac, 0x1d, 0x53, 0x4d, 0x43, 0x97, 0xa9,
  0x54, 0x0c, 0x37, 0x1a, 0x52, 0xa6, 0x52, 0xd1,
  0xcd, 0x78, 0x48, 0x99, 0x6a, 0x27, 0x57, 0xe5,
  0xb1, 0x61, 0xa8, 0x9d, 0x5c, 0x95, 0xc7, 0x00,
  0x00, 0xfc,
  // modulator
  0xad, 0x0e, 0x9a, 0xd2, 0xd3, 0x9d, 0x8c, 0x2a,
  0x69, 0xb2, 0xb0, 0x4a, 0x72, 0xaa, 0xa4, 0xd8,
  0x42, 0xd3, 0xe9, 0x28, 0xbd, 0x94, 0x28, 0xab,
  0x64, 0x2b, 0x0f, 0x8a, 0xb3, 0xbc, 0x92, 0xad,
  0xcc, 0x68, 0x8b, 0xf2, 0xac, 0x7b, 0xe2, 0xd0,
  0xbd, 0xd8, 0xc3, 0xc9, 0x89, 0xe3, 0x8c, 0x10,
  0x73, 0x3b, 0x27, 0x4a, 0x23, 0x4d, 0x35, 0xec,
  0x9c, 0x30, 0xd5, 0x16, 0x33, 0x8f, 0x72, 0xc2,
  0x34, 0xdd, 0xdc, 0xcd, 0xca, 0x89, 0x52, 0xf5,
  0x34, 0x8b, 0x28, 0x27, 0xc9, 0x59, 0x5b, 0xbc,
  0xac, 0x9c, 0xac, 0x44, 0x09, 0xc9, 0xa8, 0xd2,
  0x9a, 0xe4, 0xb4, 0x54, 0xd9, 0x4e, 0xa9, 0xab,
  0x50, 0xd7, 0x30, 0xcb, 0xa7, 0xd9, 0x6b, 0x4b,
  0x59, 0x28, 0x9f, 0x6e, 0x59, 0x51, 0x89, 0x48,
  0x7d, 0xba, 0x6a, 0xc5, 0x3c, 0x33, 0xd6, 0xe9,
  0x5b, 0x54, 0x17, 0xf3, 0x59, 0xa7, 0xaf, 0x4e,
  0xc2, 0x3c, 0xa2, 0x8c, 0x21, 0xca, 0x2a, 0x65,
  0x5b, 0xd2, 0x06, 0x1f, 0xcb, 0xc9, 0xb3, 0xea,
  0xe8, 0x43, 0x28, 0xe5, 0x88, 0xaa, 0xab, 0x8f,
  0x21, 0xd4, 0xdc, 0xab, 0x9e, 0x3e, 0x05, 0x37,
  0x8b, 0x8c, 0x7b, 0xfa, 0x6a, 0xd5, 0xcd, 0xb3,
  0xce, 0xe9, 0xab, 0x13, 0xf3, 0xa8, 0xaa, 0xa7,
  0x2f, 0x9e, 0x2d, 0xb2, 0xa2, 0x9e, 0xa1, 0x58,
  0xd6, 0xca, 0x2a, 0xbd, 0x86, 0xa4, 0xc4, 0xb7,
  0x22, 0xe4, 0x18, 0x92, 0xe6, 0x8c, 0xaa, 0x4a,
  0x63, 0xc8, 0x86, 0xc2, 0x2b, 0x63, 0xad, 0xa1,
  0x44, 0x0a, 0x6b, 0xaf, 0xb5, 0x86, 0x92, 0x30,
  0xbd, 0xbc, 0xd6, 0x1a, 0x4a, 0x23, 0xf7, 0xd2,
  0x49, 0x63, 0x2c, 0x03, 0xd3, 0xdc, 0x27, 0x8d,
  0xb1, 0x4c, 0xb2, 0x48, 0xbe, 0xd4, 0xc6, 0xb2,
  0xb0, 0xd5, 0x7d, 0x58, 0x1a, 0x53, 0x26, 0xcd,
  0xc1, 0x4a, 0x65, 0xca, 0x89, 0xd5, 0x0b, 0x4b,
  0x85, 0xb1, 0x64, 0x54, 0x0f, 0xa9, 0xe5, 0xe6,
  0x52, 0x29, 0x54, 0xcc, 0x92, 0x9a, 0x4a, 0xc5,
  0x30, 0x93, 0x22, 0x04, 0xa0, 0x0e, 0x9b, 0x00,
  0xc0, 0x4a, 0x01, 0x00, 0xfc,
  // operator
  0x09, 0x70, 0x9d, 0x2d, 0x00, 0x61, 0x91, 0x9e,
  0x2c, 0xe5, 0xca, 0x14, 0xab, 0x72, 0x92, 0xd4,
  0xa3, 0x8c, 0x2b, 0xec, 0x89, 0xd3, 0xf2, 0x52,
  0x2b, 0x73, 0x2b, 0x8a, 0xcf, 0x2c, 0x3c, 0xc2,
  0xac, 0x38, 0x3e, 0xe7, 0x2c, 0x8b, 0xd2, 0xe2,
  0xb0, 0x2c, 0xcd, 0x2a, 0xac, 0xc9, 0x42, 0xa3,
  0x94, 0x08, 0x29, 0x24, 0x53, 0x6e, 0x42, 0x59,
  0x9d, 0x32, 0xa0, 0x28, 0x55, 0x06, 0x64, 0xad,
  0xca, 0x00, 0x6f, 0xc4, 0x5a, 0x15, 0x9b, 0x99,
  0xb8, 0xdb, 0x2e, 0xa5, 0x1d, 0xec, 0x51, 0xee,
  0xa4, 0xb5, 0x61, 0x93, 0x95, 0xbb, 0xdd, 0xd2,
  0xba, 0x89, 0xde, 0xe9, 0x71, 0x52, 0xab, 0x3a,
  0x65, 0xa5, 0xa5, 0x5e, 0x6d, 0xac, 0x6c, 0x59,
  0x9a, 0xa6, 0x74, 0x2e, 0xf3, 0x86, 0x5b, 0x91,
  0xd1, 0xfb, 0xe0, 0xd1, 0x45, 0x95, 0x47, 0x1f,
  0x83, 0xe8, 0x0c, 0x97, 0x39, 0x7d, 0x8d, 0x18,
  0x5a, 0x55, 0x7b, 0xf5, 0x35, 0x60, 0x58, 0x75,
  0xe5, 0xd1, 0x47, 0xc7, 0x55, 0x1d, 0xb6, 0xc6,
  0x90, 0x2c, 0x55, 0x5c, 0x58, 0x6c, 0x7d, 0xab,
  0xec, 0x64, 0xde, 0x78, 0xf5, 0xc5, 0xb1, 0xd9,
  0x44, 0xad, 0x31, 0x44, 0xc3, 0x59, 0x27, 0xa1,
  0xc6, 0x90, 0x02, 0x79, 0x8e, 0xcf, 0x1c, 0x63,
  0x8a, 0x98, 0x39, 0x36, 0xab, 0x8d, 0x31, 0x62,
  0x57, 0xf9, 0xa4, 0x36, 0xc6, 0x88, 0xd9, 0x6d,
  0x33, 0xdb, 0x54, 0x26, 0x36, 0x65, 0x05, 0x6b,
  0x53, 0x59, 0x58, 0x62, 0x31, 0xb4, 0x4d, 0x65,
  0x60, 0xa9, 0x45, 0xe9, 0x34, 0x95, 0x81, 0x29,
  0x16, 0xc5, 0xcc, 0x9c, 0x33, 0xba, 0x99, 0x0d,
  0x25, 0x00, 0xf0, 0x34, 0x00, 0x00, 0xff,
  // oscillator
  0x27, 0x4d, 0xa5, 0x23, 0x3d, 0x6b, 0x9f, 0x34,
  0xad, 0xb4, 0x8c, 0x8a, 0x72, 0xd2, 0x34, 0x2a,
  0xc2, 0x2a, 0xca, 0x49, 0xd3, 0x8c, 0x34, 0xef,
  0x28, 0x27, 0x8e, 0x3b, 0x34, 0xa2, 0xcd, 0x9c,
  0x38, 0x4e, 0x0f, 0x8b, 0x96, 0x7a, 0xa2, 0x94,
  0x7d, 0x28, 0x5b, 0x8a, 0x00, 0x98, 0x6c, 0x13,
  0x40, 0x27, 0x69, 0x02, 0xd8, 0x22, 0x5c, 0x01,
  0x5b, 0x84, 0x2b, 0xe0, 0x48, 0x0f, 0x03, 0x0c,
  0xda, 0xe6, 0x80, 0x28, 0x3c, 0x4f, 0x1b, 0x5c,
  0xbb, 0x6a, 0x54, 0x1e, 0xad, 0xf3, 0x23, 0x6e,
  0x51, 0x77, 0xb5, 0x51, 0x76, 0x18, 0xc6, 0x9c,
  0xd5, 0x26, 0x59, 0x65, 0x18, 0x73, 0x4e, 0x5b,
  0x44, 0x85, 0xb3, 0xd7, 0x3d, 0x6d, 0x51, 0xe5,
  0x2e, 0x51, 0xf7, 0xb4, 0xd5, 0xb9, 0x19, 0x77,
  0x9d, 0xd3, 0x36, 0x6f, 0xe6, 0xdc, 0x55, 0x4f,
  0xdf, 0xa3, 0x72, 0x68, 0x4d, 0x39, 0x7d, 0x0f,
  0x46, 0xe1, 0x39, 0xe5, 0xf4, 0x2d, 0x89, 0xa4,
  0xd5, 0x98, 0xd3, 0xf7, 0xa8, 0x9c, 0x96, 0x67,
  0x56, 0x5f, 0x03, 0x9b, 0x59, 0x54, 0x3e, 0x7d,
  0x4b, 0x6c, 0x5a, 0x36, 0xfb, 0xf4, 0xb5, 0xb0,
  0x5a, 0xd9, 0xa2, 0xd3, 0xd7, 0x46, 0xee, 0xe9,
  0xb3, 0x4f, 0x5f, 0x3a, 0x5a, 0x86, 0xce, 0x1e,
  0x7d, 0xe9, 0x68, 0x99, 0x72, 0x79, 0xf5, 0xa5,
  0xa3, 0x57, 0xc8, 0xa5, 0xd1, 0x97, 0x81, 0x11,
  0x6a, 0x63, 0xda, 0x50, 0x16, 0x36, 0x45, 0x15,
  0x6b, 0x43, 0x99, 0x58, 0x62, 0x31, 0xb4, 0x0c,
  0x65, 0x40, 0x89, 0x47, 0xb1, 0x34, 0x94, 0x8e,
  0x29, 0x16, 0xc5, 0xcc, 0x98, 0x33, 0x9a, 0x99,
  0x0d, 0x05, 0x00, 0x80, 0xff,
  // patch
  0xc8, 0x2b, 0x2a, 0x3c, 0xcd, 0x12, 0x23, 0x2f,
  0xba, 0xca, 0xf4, 0xb0, 0xa3, 0xbc, 0xa1, 0xdc,
  0xc3, 0xd3, 0x8a, 0x01, 0x82, 0x09, 0x0f, 0x40,
  0xf4, 0xee, 0xa7, 0xae, 0x51, 0xd2, 0xcd, 0x25,
  0x9d, 0xa6, 0x46, 0x2d, 0x8f, 0x90, 0x7c, 0x9a,
  0x9a, 0xb4, 0x2c, 0x42, 0xca, 0x69, 0x4a, 0xd6,
  0xb6, 0x0c, 0xcb, 0xa7, 0x2b, 0xd5, 0xca, 0xa3,
  0xec, 0x9c, 0xbe, 0x54, 0x6b, 0xad, 0x92, 0x73,
  0xfa, 0x52, 0xad, 0xb5, 0x4a, 0xf1, 0x19, 0x4b,
  0xb5, 0x96, 0x4e, 0xc5, 0x67, 0x2e, 0x4d, 0x5b,
  0x26, 0x55, 0x9f, 0x25, 0x37, 0x1d, 0x59, 0x57,
  0x75, 0xd6, 0x52, 0xb4, 0x65, 0x42, 0xf1, 0x39,
  0x6b, 0xd4, 0x72, 0x6f, 0x3b, 0xe7, 0xaa, 0x41,
  0x53, 0xb3, 0x2c, 0x9f, 0xab, 0x1a, 0x49, 0x8d,
  0x8a, 0x92, 0xd6, 0xac, 0xdd, 0x2c, 0xc3, 0x8a,
  0xe9, 0xaa, 0xac, 0x31, 0xf3, 0x38, 0x25, 0xdd,
  0x25, 0xcb, 0x32, 0xe2, 0x38, 0x60, 0x79, 0xb1,
  0x00, 0xec, 0xde, 0xe6, 0x80, 0xbd, 0xc7, 0x1d,
  0xb0, 0x7b, 0x87, 0x01, 0x56, 0x16, 0x04, 0x40,
  0x74, 0x57, 0x61, 0x6e, 0x66, 0x1b, 0xfe,
  // sequencer
  0x41, 0xba, 0xbe, 0xdd, 0xdd, 0x93, 0x28, 0x60,
  0x09, 0x35, 0x05, 0x4c, 0x69, 0xa2, 0x80, 0xa5,
  0x8c, 0x0d, 0x30, 0x85, 0x8b, 0x03, 0x96, 0x73,
  0x09, 0xc0, 0xb4, 0xc2, 0x27, 0xa8, 0x92, 0x35,
  0xa3, 0xad, 0xac, 0xa0, 0x28, 0x8c, 0xb8, 0x60,
  0x7c, 0x82, 0xa6, 0xc8, 0x7c, 0x4b, 0xd6, 0x09,
  0x9a, 0x24, 0x8b, 0x2b, 0x59, 0x2b, 0x6a, 0x8c,
  0x35, 0x37, 0xad, 0xac, 0xb4, 0x7b, 0xe4, 0xe8,
  0x8a, 0x32, 0xb2, 0x1e, 0x50, 0xbc, 0x2b, 0x8a,
  0x00, 0xb8, 0xd2, 0x14, 0x40, 0x94, 0xcc, 0x0c,
  0xc8, 0xdc, 0x90, 0x00, 0xbe, 0x2a, 0xa7, 0xde,
  0x16, 0xd6, 0x4c, 0x6f, 0x5c, 0x46, 0x55, 0xa4,
  0x39, 0x36, 0x6c, 0x19, 0x65, 0xb2, 0x71, 0xe9,
  0xc2, 0x67, 0x4c, 0x56, 0xbd, 0x4c, 0x67, 0x9f,
  0xb9, 0x05, 0x65, 0x8f, 0x28, 0x73, 0xe6, 0x62,
  0x59, 0x3d, 0xaa, 0xf4, 0x9a, 0xb3, 0x42, 0xeb,
  0xa8, 0xda, 0x6d, 0x76, 0x52, 0x6a, 0x3c, 0xcd,
  0xb4, 0xd9, 0x09, 0xcd, 0xb1, 0x0a, 0x2d, 0x00,
  0x8e, 0xa6, 0x15, 0xf0, 0x25, 0xa9, 0x03, 0x9e,
  0x55, 0x3f, 0xe3, 0xd2, 0xa2, 0x5a, 0x96, 0xfa,
  0x8c, 0xd9, 0xaa, 0x5b, 0x79, 0xa2, 0x31, 0x9b,
  0x14, 0x51, 0x29, 0x96, 0xc6, 0xec, 0xa3, 0x56,
  0x15, 0xd9, 0x6e, 0x73, 0x28, 0x34, 0x99, 0x1a,
  0x6a, 0xcc, 0x29, 0x51, 0x67, 0xf2, 0x90, 0x36,
  0xa7, 0x44, 0x9d, 0xc9, 0x43, 0xdb, 0x1c, 0x13,
  0xad, 0xba, 0x87, 0x19, 0x6b, 0xce, 0x38, 0xee,
  0x16, 0xaa, 0xad, 0xa9, 0xe2, 0x68, 0x58, 0xd0,
  0xb2, 0x96, 0x86, 0x83, 0xe5, 0x54, 0xc2, 0x5c,
  0x2a, 0x24, 0x59, 0xdb, 0x21, 0x00, 0x88, 0xb4,
  0x00, 0x08, 0xed, 0x32, 0xcc, 0xcd, 0x6d, 0xc3,
  0xff,
  // synthesizer
  0x0c, 0xe8, 0x22, 0x54, 0x01, 0x93, 0x87, 0x2a,
  0x60, 0x0b, 0x57, 0x01, 0x1c, 0x1b, 0x2e, 0x80,
  0x2b, 0x3c, 0x46, 0xf8, 0x5c, 0x5a, 0xb8, 0xc6,
  0x1e, 0xd6, 0x15, 0x6e, 0xa6, 0x56, 0xfb, 0x44,
  0xc9, 0x49, 0x68, 0xa7, 0xa2, 0x13, 0xa5, 0xc0,
  0x91, 0xd9, 0xac, 0x4f, 0x94, 0x22, 0x7b, 0x66,
  0x33, 0x49, 0xb1, 0xb3, 0x5c, 0xb2, 0xe9, 0xca,
  0xc5, 0x34, 0x7a, 0x9b, 0xa7, 0x6a, 0x00, 0x05,
  0x04, 0x6b, 0xb1, 0xca, 0xe4, 0x24, 0x34, 0x47,
  0xce, 0xa9, 0xb2, 0x91, 0x70, 0x5b, 0x3b, 0xa7,
  0x4a, 0x56, 0xdc, 0xfc, 0xec, 0x8c, 0x3a, 0x59,
  0x35, 0x8f, 0x29, 0xab, 0x00, 0xc9, 0xca, 0x15,
  0xd0, 0x80, 0xbb, 0x00, 0x36, 0x73, 0x55, 0xc0,
  0x96, 0xe5, 0x06, 0xd8, 0xb2, 0xdc, 0x01, 0x81,
  0x97, 0x9d, 0xa6, 0x78, 0x4b, 0xb7, 0x8c, 0x72,
  0x9a, 0xec, 0x3d, 0x5d, 0x2b, 0xca, 0xe9, 0x52,
  0xcc, 0x08, 0xad, 0xca, 0xa7, 0x4b, 0xb9, 0x22,
  0x34, 0x2b, 0xaf, 0x3e, 0xb6, 0x68, 0x89, 0xb6,
  0x7a, 0xfa, 0x14, 0x23, 0x8b, 0x33, 0xca, 0xea,
  0x63, 0x2c, 0x6b, 0x77, 0x2b, 0xa7, 0xcf, 0xc1,
  0xb5, 0x2c, 0x43, 0x9f, 0xa1, 0x78, 0xf5, 0xf2,
  0x32, 0x72, 0x86, 0x12, 0xc4, 0x3c, 0x2a, 0xcc,
  0x1a, 0xb2, 0x31, 0x4d, 0x9d, 0x30, 0x6d, 0xc9,
  0x3c, 0x28, 0x2b, 0x46, 0x19, 0x20, 0x82, 0x4e,
  0x03, 0x2c, 0xc0, 0x66, 0x80, 0x2f, 0xc9, 0x03,
  0x50, 0x80, 0xf5, 0x19, 0xaa, 0x72, 0xd3, 0xb0,
  0xc4, 0x6b, 0xc8, 0x81, 0x22, 0x3c, 0x1b, 0x8d,
  0x21, 0x79, 0x4a, 0x4f, 0x8f, 0x35, 0x86, 0x9c,
  0x30, 0x23, 0xad, 0xd6, 0x18, 0x4a, 0xc1, 0xf4,
  0xb0, 0xca, 0x6d, 0xc8, 0x19, 0xcb, 0xd3, 0x2a,
  0x95, 0x31, 0x25, 0x2c, 0x77, 0x8f, 0x5c, 0xc6,
  0x52, 0x31, 0xcd, 0xad, 0x52, 0x19, 0x6b, 0x47,
  0x57, 0x97, 0x49, 0x61, 0x2c, 0x8d, 0x54, 0x5d,
  0x63, 0xb8, 0xb1, 0x24, 0x52, 0x73, 0xb3, 0xe1,
  0xe6, 0x5a, 0xd8, 0xc9, 0x24, 0x91, 0x1b, 0x6a,
  0x70, 0x65, 0x51, 0x3b, 0x00, 0x00, 0xff,
  // vca
  0x69, 0x10, 0x36, 0xb2, 0x5c, 0x23, 0xa6, 0xc1,
  0xab, 0x70, 0x75, 0x8b, 0x93, 0xfa, 0xa0, 0xcc,
  0x54, 0xd5, 0xcd, 0x6a, 0x5b, 0x0e, 0x55, 0x15,
  0xdb, 0x2b, 0xef, 0xb1, 0x55, 0x99, 0xec, 0x9c,
  0xac, 0x5a, 0x66, 0x2b, 0xaf, 0x72, 0xb2, 0xac,
  0xd8, 0x72, 0x32, 0xcc, 0xca, 0x92, 0x10, 0xef,
  0xf5, 0x30, 0x2b, 0x2f, 0x1a, 0x3d, 0xa6, 0xcc,
  0x8c, 0xb2, 0x70, 0xcc, 0x9e, 0x92, 0xbc, 0xea,
  0xca, 0xc9, 0xba, 0x5b, 0xca, 0x6a, 0x86, 0x21,
  0xf6, 0x1a, 0xcb, 0xab, 0xde, 0x26, 0x48, 0x34,
  0x62, 0x07, 0x60, 0x72, 0x23, 0x03, 0x6c, 0xe5,
  0xe2, 0x80, 0xa5, 0x5d, 0x1c, 0x30, 0x5c, 0x52,
  0x00, 0x88, 0x89, 0x59, 0x7d, 0x92, 0x94, 0x3d,
  0x45, 0x7b, 0x74, 0x81, 0x79, 0x5e, 0x39, 0xdd,
  0xd1, 0x45, 0xae, 0xb1, 0x93, 0x74, 0x56, 0x9b,
  0x88, 0xe6, 0x74, 0x49, 0x3d, 0x6d, 0x61, 0xac,
  0xb5, 0x2d, 0xfb, 0x34, 0x9d, 0xb3, 0xe4, 0xae,
  0x95, 0xd3, 0x34, 0xc5, 0x9c, 0xd3, 0x76, 0x4e,
  0xdd, 0x03, 0xb3, 0x57, 0x5b, 0x39, 0x45, 0x4f,
  0xc2, 0x99, 0x61, 0xf9, 0x14, 0x3d, 0x92, 0x45,
  0x85, 0x9d, 0x93, 0xf7, 0x40, 0x96, 0x99, 0x76,
  0x4f, 0xde, 0x23, 0x59, 0x56, 0xda, 0x39, 0x55,
  0x4f, 0xac, 0x9e, 0x65, 0xe5, 0x34, 0xdd, 0xb1,
  0x44, 0x76, 0xa4, 0xd3, 0x8d, 0x20, 0x6c, 0x59,
  0x95, 0xce, 0x30, 0x02, 0x93, 0x57, 0x55, 0x3a,
  0x53, 0xf7, 0x24, 0x9e, 0x5d, 0xe9, 0xac, 0xcd,
  0xa2, 0x65, 0x4d, 0xe4, 0xb3, 0x35, 0x8b, 0x56,
  0xd5, 0x91, 0xcf, 0x31, 0x12, 0x8a, 0x77, 0xd7,
  0x4a, 0x7d, 0x33, 0x98, 0x95, 0x61, 0x15, 0x00,
  0xe0, 0xff,
  // voltage
  0xae, 0x75, 0x45, 0x13, 0x86, 0xdd, 0xa4, 0xd6,
  0xe7, 0x70, 0x72, 0x1b, 0x9f, 0x9a, 0xe0, 0x32,
  0x98, 0xa5, 0xf2, 0xa8, 0x86, 0x09, 0x57, 0x17,
  0xc5, 0xa7, 0x48, 0x3e, 0xc3, 0x4d, 0xa3, 0x9c,
  0x32, 0xc6, 0x31, 0x09, 0x49, 0x72, 0xca, 0x68,
  0x27, 0xd5, 0x64, 0xd6, 0x28, 0x7d, 0x9c, 0x12,
  0xf1, 0x4b, 0xa3, 0x74, 0x79, 0x53, 0xc4, 0x2e,
  0x95, 0xd2, 0x8c, 0x49, 0x94, 0x1c, 0x5d, 0x0a,
  0xdd, 0xce, 0x48, 0x72, 0x54, 0x29, 0x55, 0x5f,
  0x67, 0xca, 0xda, 0xad, 0xf4, 0x66, 0xc3, 0x28,
  0xa2, 0x96, 0xaa, 0xe0, 0xcc, 0x50, 0x49, 0x02,
  0xe0, 0x80, 0xca, 0x52, 0x1c, 0x70, 0x98, 0x59,
  0x02, 0x02, 0x76, 0x3b, 0x7d, 0xf7, 0xaa, 0xae,
  0x3e, 0xfb, 0xf4, 0xdd, 0xaa, 0x58, 0xf8, 0xec,
  0xd3, 0x77, 0xa7, 0x62, 0xe1, 0x53, 0x4e, 0xd7,
  0x83, 0x88, 0x79, 0xcc, 0x3e, 0x7d, 0x77, 0xaa,
  0xea, 0xb1, 0x68, 0x0d, 0x23, 0x91, 0x8a, 0xfa,
  0xaa, 0x31, 0x8c, 0x80, 0x46, 0x96, 0x8d, 0xc3,
  0xd8, 0x34, 0xa4, 0xe6, 0x54, 0x5c, 0xcb, 0x74,
  0xec, 0x1a, 0x2a, 0xc7, 0x01, 0xd3, 0x10, 0x05,
  0x60, 0x4e, 0xa7, 0x00, 0xcc, 0x99, 0x1a, 0x80,
  0x35, 0x3a, 0x02, 0x30, 0x47, 0x6a, 0x00, 0x66,
  0x4b, 0x75, 0xc0, 0x1c, 0xc6, 0x0e, 0x18, 0x51,
  0x58, 0x00, 0x23, 0x8b, 0x00, 0xc0, 0xff,
  // waveform
  0xa9, 0x65, 0xd3, 0xc3, 0xc2, 0x22, 0xbb, 0x96,
  0x3e, 0x53, 0x8d, 0xb0, 0x12, 0x6a, 0x7e, 0x59,
  0x2d, 0xd2, 0x4a, 0xaa, 0xd8, 0x34, 0x33, 0x4d,
  0xdb, 0xad, 0x10, 0xcd, 0x43, 0xcd, 0xed, 0x8e,
  0xdc, 0x74, 0xa3, 0x9a, 0x8c, 0x3d, 0x32, 0x5b,
  0xc5, 0xab, 0x22, 0xec, 0x8a, 0xbd, 0xf1, 0xce,
  0xf0, 0x32, 0x27, 0x0e, 0x5a, 0xb3, 0x22, 0xca,
  0x9e, 0x38, 0x29, 0xee, 0x69, 0xb7, 0x73, 0x82,
  0x9e, 0x48, 0xbc, 0x3b, 0xf6, 0x09, 0x7a, 0x44,
  0xc9, 0x9a, 0xd8, 0x27, 0x6a, 0x8e, 0x34, 0xa7,
  0x63, 0x9f, 0xa4, 0x79, 0x94, 0xaa, 0x89, 0x73,
  0xf2, 0x16, 0x50, 0xaa, 0xa6, 0x4a, 0x2b, 0xb2,
  0x41, 0xcb, 0xa8, 0xaa, 0xa5, 0x0d, 0x5a, 0xb5,
  0xd2, 0xaa, 0xa4, 0x21, 0x0a, 0xd1, 0x6e, 0x2d,
  0xd3, 0x86, 0xa1, 0x55, 0xc4, 0x2c, 0xb6, 0x00,
  0x02, 0x13, 0x15, 0x40, 0x15, 0x26, 0x02, 0xe8,
  0xc6, 0xb5, 0x54, 0xc3, 0xb6, 0xb9, 0x7b, 0xdc,
  0x56, 0x65, 0x6e, 0x11, 0xe9, 0x51, 0x56, 0xef,
  0x43, 0x97, 0x9a, 0x26, 0x6e, 0x83, 0x8b, 0xd3,
  0x2c, 0xd6, 0xba, 0x0c, 0xb6, 0x6c, 0x91, 0x78,
  0x9b, 0x32, 0x9a, 0x3a, 0x45, 0xea, 0x69, 0xda,
  0xe8, 0x73, 0x8e, 0xb0, 0xb6, 0x6e, 0x63, 0xc8,
  0xbe, 0x24, 0xda, 0x78, 0x8c, 0x61, 0xba, 0x9b,
  0x78, 0xa3, 0x31, 0xc5, 0xee, 0x9e, 0xaa, 0x0d,
  0xc7, 0x14, 0xbb, 0x85, 0x9b, 0x54, 0x1a, 0x4b,
  0x8a, 0x12, 0xe9, 0x94, 0x6a, 0x2c, 0xd1, 0x8a,
  0x46, 0x88, 0xe7, 0xb6, 0x44, 0xc7, 0xe6, 0xc1,
  0xa9, 0xca, 0xec, 0x2d, 0x65, 0xba, 0x36, 0x2e,
  0x4b, 0x32, 0x18, 0x11, 0x56, 0xbb, 0x2c, 0xd9,
  0xa2, 0x45, 0x59, 0xcd, 0x50, 0x07, 0x45, 0xd5,
  0xa5, 0x0d, 0xcc, 0x62, 0xb4, 0x65, 0x8c, 0x1e,
  0x54, 0x4b, 0x94, 0xe2, 0x3e, 0x3a, 0x1a, 0x00,
  0xe0, 0xff
};

/* extern */
LPCSpeechSynthWordBankData word_banks_[] = {
  { bank_0, 1233 },
  { bank_1, 900 },
  { bank_2, 1552 },
  { bank_3, 2524 },
  { bank_4, 4802 },
};

}  // namespace plaits