/* app-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from app-window.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>,
 *         Eduard Gotwig <g@ox.io>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>

#define DEFAULT_TEXT_DPI 150
#define DEFAULT_PHOTO_DPI 300
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
typedef struct _AppWindowPrivate AppWindowPrivate;

#define TYPE_CROP_ACTIONS (crop_actions_get_type ())
#define CROP_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CROP_ACTIONS, CropActions))
#define CROP_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CROP_ACTIONS, CropActionsClass))
#define IS_CROP_ACTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CROP_ACTIONS))
#define IS_CROP_ACTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CROP_ACTIONS))
#define CROP_ACTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CROP_ACTIONS, CropActionsClass))

typedef struct _CropActions CropActions;
typedef struct _CropActionsClass CropActionsClass;
typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF,
	SCAN_TYPE_BATCH
} ScanType;

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;

#define TYPE_AUTOSAVE_MANAGER (autosave_manager_get_type ())
#define AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManager))
#define AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))
#define IS_AUTOSAVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTOSAVE_MANAGER))
#define IS_AUTOSAVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTOSAVE_MANAGER))
#define AUTOSAVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTOSAVE_MANAGER, AutosaveManagerClass))

typedef struct _AutosaveManager AutosaveManager;
typedef struct _AutosaveManagerClass AutosaveManagerClass;

#define TYPE_BOOK_VIEW (book_view_get_type ())
#define BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK_VIEW, BookView))
#define BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK_VIEW, BookViewClass))
#define IS_BOOK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK_VIEW))
#define IS_BOOK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK_VIEW))
#define BOOK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK_VIEW, BookViewClass))

typedef struct _BookView BookView;
typedef struct _BookViewClass BookViewClass;
enum  {
	APP_WINDOW_0_PROPERTY,
	APP_WINDOW_BOOK_PROPERTY,
	APP_WINDOW_SELECTED_PAGE_PROPERTY,
	APP_WINDOW_SCANNING_PROPERTY,
	APP_WINDOW_BRIGHTNESS_PROPERTY,
	APP_WINDOW_CONTRAST_PROPERTY,
	APP_WINDOW_PAGE_DELAY_PROPERTY,
	APP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* app_window_properties[APP_WINDOW_NUM_PROPERTIES];

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _crop_actions_unref0(var) ((var == NULL) ? NULL : (var = (crop_actions_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _autosave_manager_unref0(var) ((var == NULL) ? NULL : (var = (autosave_manager_unref (var), NULL)))

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))

#define TYPE_AUTHORIZE_DIALOG_RESPONSE (authorize_dialog_response_get_type ())
typedef struct _AuthorizeDialogResponse AuthorizeDialogResponse;

#define TYPE_AUTHORIZE_DIALOG (authorize_dialog_get_type ())
#define AUTHORIZE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUTHORIZE_DIALOG, AuthorizeDialog))
#define AUTHORIZE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUTHORIZE_DIALOG, AuthorizeDialogClass))
#define IS_AUTHORIZE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUTHORIZE_DIALOG))
#define IS_AUTHORIZE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUTHORIZE_DIALOG))
#define AUTHORIZE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUTHORIZE_DIALOG, AuthorizeDialogClass))

typedef struct _AuthorizeDialog AuthorizeDialog;
typedef struct _AuthorizeDialogClass AuthorizeDialogClass;
typedef struct _AppWindowAuthorizeData AppWindowAuthorizeData;
typedef struct _Block1Data Block1Data;
typedef struct _AppWindowPromptToLoadAutosavedBookData AppWindowPromptToLoadAutosavedBookData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AppWindowChooseFileLocationData AppWindowChooseFileLocationData;
typedef struct _Block2Data Block2Data;
typedef struct _AppWindowCheckOverwriteData AppWindowCheckOverwriteData;

#define TYPE_CANCELLABLE_PROGRESS_BAR (cancellable_progress_bar_get_type ())
#define CANCELLABLE_PROGRESS_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANCELLABLE_PROGRESS_BAR, CancellableProgressBar))
#define CANCELLABLE_PROGRESS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANCELLABLE_PROGRESS_BAR, CancellableProgressBarClass))
#define IS_CANCELLABLE_PROGRESS_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANCELLABLE_PROGRESS_BAR))
#define IS_CANCELLABLE_PROGRESS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANCELLABLE_PROGRESS_BAR))
#define CANCELLABLE_PROGRESS_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANCELLABLE_PROGRESS_BAR, CancellableProgressBarClass))

typedef struct _CancellableProgressBar CancellableProgressBar;
typedef struct _CancellableProgressBarClass CancellableProgressBarClass;
typedef struct _Block3Data Block3Data;
typedef void (*ProgressionCallback) (gdouble fraction, gpointer user_data);
typedef struct _AppWindowSaveDocumentAsyncData AppWindowSaveDocumentAsyncData;
typedef struct _Block4Data Block4Data;
typedef struct _AppWindowPromptToSaveAsyncData AppWindowPromptToSaveAsyncData;

#define TYPE_DRIVERS_DIALOG (drivers_dialog_get_type ())
#define DRIVERS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRIVERS_DIALOG, DriversDialog))
#define DRIVERS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRIVERS_DIALOG, DriversDialogClass))
#define IS_DRIVERS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRIVERS_DIALOG))
#define IS_DRIVERS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRIVERS_DIALOG))
#define DRIVERS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRIVERS_DIALOG, DriversDialogClass))

typedef struct _DriversDialog DriversDialog;
typedef struct _DriversDialogClass DriversDialogClass;

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

#define TYPE_SCAN_MODE (scan_mode_get_type ())
typedef enum  {
	SCAN_SIDE_FRONT,
	SCAN_SIDE_BACK,
	SCAN_SIDE_BOTH
} ScanSide;

#define TYPE_SCAN_SIDE (scan_side_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_REORDER_PAGES_DIALOG (reorder_pages_dialog_get_type ())
#define REORDER_PAGES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REORDER_PAGES_DIALOG, ReorderPagesDialog))
#define REORDER_PAGES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REORDER_PAGES_DIALOG, ReorderPagesDialogClass))
#define IS_REORDER_PAGES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REORDER_PAGES_DIALOG))
#define IS_REORDER_PAGES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REORDER_PAGES_DIALOG))
#define REORDER_PAGES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REORDER_PAGES_DIALOG, ReorderPagesDialogClass))

typedef struct _ReorderPagesDialog ReorderPagesDialog;
typedef struct _ReorderPagesDialogClass ReorderPagesDialogClass;
typedef struct _Block5Data Block5Data;
typedef struct _ReorderPagesDialogPrivate ReorderPagesDialogPrivate;

#define TYPE_REORDER_PAGES_ITEM (reorder_pages_item_get_type ())
#define REORDER_PAGES_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REORDER_PAGES_ITEM, ReorderPagesItem))
#define REORDER_PAGES_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REORDER_PAGES_ITEM, ReorderPagesItemClass))
#define IS_REORDER_PAGES_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REORDER_PAGES_ITEM))
#define IS_REORDER_PAGES_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REORDER_PAGES_ITEM))
#define REORDER_PAGES_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REORDER_PAGES_ITEM, ReorderPagesItemClass))

typedef struct _ReorderPagesItem ReorderPagesItem;
typedef struct _ReorderPagesItemClass ReorderPagesItemClass;
typedef enum  {
	FLIP_EVERY_SECOND_Even = 1,
	FLIP_EVERY_SECOND_Odd = 0
} FlipEverySecond;

#define TYPE_FLIP_EVERY_SECOND (flip_every_second_get_type ())
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _AppWindowEmailDocumentAsyncData AppWindowEmailDocumentAsyncData;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
enum  {
	APP_WINDOW_START_SCAN_SIGNAL,
	APP_WINDOW_STOP_SCAN_SIGNAL,
	APP_WINDOW_REDETECT_SIGNAL,
	APP_WINDOW_NUM_SIGNALS
};
static guint app_window_signals[APP_WINDOW_NUM_SIGNALS] = {0};
typedef struct _CancellableProgressBarPrivate CancellableProgressBarPrivate;
enum  {
	CANCELLABLE_PROGRESS_BAR_0_PROPERTY,
	CANCELLABLE_PROGRESS_BAR_NUM_PROPERTIES
};
static GParamSpec* cancellable_progress_bar_properties[CANCELLABLE_PROGRESS_BAR_NUM_PROPERTIES];
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _CropActionsPrivate CropActionsPrivate;
typedef struct _ParamSpecCropActions ParamSpecCropActions;

struct _AppWindow {
	AdwApplicationWindow parent_instance;
	AppWindowPrivate * priv;
};

struct _AppWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _AppWindowPrivate {
	GSimpleAction* scan_type_action;
	GSimpleAction* document_hint_action;
	GSimpleAction* delete_page_action;
	GSimpleAction* page_move_left_action;
	GSimpleAction* page_move_right_action;
	GSimpleAction* copy_to_clipboard_action;
	CropActions* crop_actions;
	GSettings* settings;
	ScanType scan_type;
	PreferencesDialog* preferences_dialog;
	gboolean setting_devices;
	gboolean user_selected_device;
	GtkPopoverMenu* page_menu;
	GtkStack* stack;
	AdwStatusPage* status_page;
	GtkLabel* status_secondary_label;
	GListStore* device_model;
	GtkBox* device_buttons_box;
	GtkDropDown* device_drop_down;
	GtkBox* main_vbox;
	GtkButton* save_button;
	GtkButton* stop_button;
	GtkButton* scan_button;
	GtkActionBar* action_bar;
	GtkToggleButton* crop_button;
	AdwButtonContent* scan_button_content;
	GtkMenuButton* menu_button;
	gboolean have_devices;
	gchar* missing_driver;
	Book* _book;
	gboolean book_needs_saving;
	gchar* book_uri;
	AutosaveManager* autosave_manager;
	BookView* book_view;
	gboolean updating_page_menu;
	gchar* document_hint;
	gboolean scanning_;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_fullscreen;
	guint save_state_timeout;
};

struct _ScanDevice {
	GObject parent_instance;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GObjectClass parent_class;
};

struct _AuthorizeDialogResponse {
	gchar* username;
	gchar* password;
	gboolean success;
};

struct _AppWindowAuthorizeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	gchar* resource;
	AuthorizeDialogResponse result;
	gchar* description;
	gchar* _tmp0_;
	AuthorizeDialog* authorize_dialog;
	AuthorizeDialog* _tmp1_;
	AuthorizeDialogResponse _tmp2_;
};

struct _Block1Data {
	int _ref_count_;
	AppWindow* self;
	gchar* response;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _AppWindowPromptToLoadAutosavedBookData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	gboolean result;
	Block1Data* _data1_;
	AdwAlertDialog* dialog;
	AdwAlertDialog* _tmp0_;
	gchar* _tmp1_;
};

struct _AppWindowChooseFileLocationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	gchar* result;
	gchar* directory;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkFileDialog* save_dialog;
	GtkFileDialog* _tmp9_;
	GtkFileDialog* _tmp10_;
	GtkFileDialog* _tmp11_;
	GtkFileDialog* _tmp12_;
	gchar* save_format;
	GSettings* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	GtkFileDialog* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GtkFileDialog* _tmp20_;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	GtkFileDialog* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GListStore* filters;
	GListStore* _tmp32_;
	GtkFileFilter* pdf_filter;
	GtkFileFilter* _tmp33_;
	GtkFileFilter* _tmp34_;
	GtkFileFilter* _tmp35_;
	GtkFileFilter* _tmp36_;
	GListStore* _tmp37_;
	GtkFileFilter* _tmp38_;
	GtkFileFilter* jpeg_filter;
	GtkFileFilter* _tmp39_;
	GtkFileFilter* _tmp40_;
	GtkFileFilter* _tmp41_;
	GtkFileFilter* _tmp42_;
	GtkFileFilter* _tmp43_;
	GListStore* _tmp44_;
	GtkFileFilter* _tmp45_;
	GtkFileFilter* png_filter;
	GtkFileFilter* _tmp46_;
	GtkFileFilter* _tmp47_;
	GtkFileFilter* _tmp48_;
	GtkFileFilter* _tmp49_;
	GListStore* _tmp50_;
	GtkFileFilter* _tmp51_;
	GtkFileFilter* webp_filter;
	GtkFileFilter* _tmp52_;
	GtkFileFilter* _tmp53_;
	GtkFileFilter* _tmp54_;
	GtkFileFilter* _tmp55_;
	GListStore* _tmp56_;
	GtkFileFilter* _tmp57_;
	GtkFileFilter* all_filter;
	GtkFileFilter* _tmp58_;
	GtkFileFilter* _tmp59_;
	GtkFileFilter* _tmp60_;
	GListStore* _tmp61_;
	GtkFileFilter* _tmp62_;
	GtkFileDialog* _tmp63_;
	GListStore* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	GQuark _tmp68_;
	GtkFileDialog* _tmp69_;
	GtkFileFilter* _tmp70_;
	GtkFileDialog* _tmp71_;
	GtkFileFilter* _tmp72_;
	GtkFileDialog* _tmp73_;
	GtkFileFilter* _tmp74_;
	GtkFileDialog* _tmp75_;
	GtkFileFilter* _tmp76_;
	GtkBox* box;
	GtkBox* _tmp77_;
	GtkBox* _tmp78_;
	GtkBox* _tmp79_;
	GtkBox* _tmp80_;
	GFile* file;
	GFile* _tmp81_;
	GtkFileDialog* _tmp82_;
	GFile* _tmp83_;
	GFile* _tmp84_;
	GError* e;
	GError* _tmp85_;
	const gchar* _tmp86_;
	GFile* _tmp87_;
	gchar* uri;
	GFile* _tmp88_;
	gchar* _tmp89_;
	gchar* extension;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* mime_type;
	const gchar* _tmp92_;
	gchar* _tmp93_;
	const gchar* _tmp94_;
	const gchar* _tmp95_;
	const gchar* _tmp96_;
	gchar* _tmp97_;
	GSettings* _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	const gchar* _tmp101_;
	const gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	GList* files;
	gboolean _tmp108_;
	gboolean _tmp109_;
	const gchar* _tmp110_;
	const gchar* _tmp111_;
	const gchar* _tmp112_;
	gint j;
	gboolean _tmp113_;
	gint _tmp114_;
	Book* _tmp115_;
	guint _tmp116_;
	guint _tmp117_;
	const gchar* _tmp118_;
	Book* _tmp119_;
	guint _tmp120_;
	guint _tmp121_;
	GFile* _tmp122_;
	const gchar* _tmp123_;
	GFile* _tmp124_;
	gboolean overwrite_check;
	gboolean _tmp125_;
	GList* _tmp126_;
	GFile* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	const gchar* _tmp130_;
	GList* _tmp131_;
	gchar* directory_uri;
	const gchar* _tmp132_;
	const gchar* _tmp133_;
	gchar* _tmp134_;
	GSettings* _tmp135_;
	const gchar* _tmp136_;
	GError* _inner_error0_;
};

struct _Block2Data {
	int _ref_count_;
	AppWindow* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gchar* response;
};

struct _AppWindowCheckOverwriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	GtkWindow* parent;
	GList* files;
	gboolean result;
	GList* file_collection;
	GList* file_it;
	GFile* _tmp0_;
	GFile* file;
	Block2Data* _data2_;
	GFile* _tmp1_;
	gchar* title;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	AdwAlertDialog* dialog;
	const gchar* _tmp7_;
	AdwAlertDialog* _tmp8_;
	AdwAlertDialog* _tmp9_;
	AdwAlertDialog* _tmp10_;
	AdwAlertDialog* _tmp11_;
	gchar* _tmp12_;
	AdwAlertDialog* _tmp13_;
	AdwAlertDialog* _tmp14_;
	const gchar* _tmp15_;
};

struct _Block3Data {
	int _ref_count_;
	AppWindow* self;
	CancellableProgressBar* progress_bar;
	gpointer _async_data_;
};

struct _AppWindowSaveDocumentAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	gboolean result;
	Block3Data* _data3_;
	gchar* uri;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* file;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp4_;
	gchar* mime_type;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GCancellable* cancellable;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	CancellableProgressBar* _tmp9_;
	GtkActionBar* _tmp10_;
	CancellableProgressBar* _tmp11_;
	CancellableProgressBar* _tmp12_;
	GtkButton* _tmp13_;
	Book* _tmp14_;
	const gchar* _tmp15_;
	GSettings* _tmp16_;
	GFile* _tmp17_;
	GCancellable* _tmp18_;
	GError* e;
	GtkButton* _tmp19_;
	CancellableProgressBar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	const gchar* _tmp24_;
	GtkButton* _tmp25_;
	CancellableProgressBar* _tmp26_;
	GtkActionBar* _tmp27_;
	Book* _tmp28_;
	const gchar* _tmp29_;
	GFile* _tmp30_;
	GSettings* _tmp31_;
	GSettings* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GSettings* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GSettings* _tmp38_;
	GError* _vala1_e;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	AppWindow* self;
	gchar* response;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	gpointer _async_data_;
};

struct _AppWindowPromptToSaveAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	gchar* title;
	gchar* discard_label;
	gboolean result;
	Block4Data* _data4_;
	gboolean _tmp0_;
	Book* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	AdwAlertDialog* dialog;
	AdwAlertDialog* _tmp4_;
	AdwAlertDialog* _tmp5_;
	AdwAlertDialog* _tmp6_;
	AdwAlertDialog* _tmp7_;
	AdwAlertDialog* _tmp8_;
	AdwAlertDialog* _tmp9_;
	AdwAlertDialog* _tmp10_;
	gchar* _tmp11_;
	AdwAlertDialog* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GQuark _tmp16_;
};

struct _ScanOptions {
	GObject parent_instance;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	ScanSide side;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
	gint page_delay;
};

struct _ScanOptionsClass {
	GObjectClass parent_class;
};

struct _Block5Data {
	int _ref_count_;
	AppWindow* self;
	ReorderPagesDialog* dialog;
};

struct _ReorderPagesDialog {
	GtkWindow parent_instance;
	ReorderPagesDialogPrivate * priv;
	ReorderPagesItem* combine_sides;
	ReorderPagesItem* combine_sides_rev;
	ReorderPagesItem* flip_odd;
	ReorderPagesItem* flip_even;
	ReorderPagesItem* reverse;
};

struct _ReorderPagesDialogClass {
	GtkWindowClass parent_class;
};

struct _AppWindowEmailDocumentAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AppWindow* self;
	gchar* dir;
	gchar* _tmp0_;
	gchar* mime_type;
	gchar* filename;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* file;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	Book* _tmp12_;
	const gchar* _tmp13_;
	GSettings* _tmp14_;
	GFile* _tmp15_;
	Book* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GSettings* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GSettings* _tmp26_;
	gchar* command_line;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gint i;
	gboolean _tmp36_;
	gint _tmp37_;
	Book* _tmp38_;
	guint _tmp39_;
	guint _tmp40_;
	GFile* indexed_file;
	GFile* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	Book* _tmp44_;
	guint _tmp45_;
	guint _tmp46_;
	GFile* _tmp47_;
	GFile* _tmp48_;
	const gchar* _tmp49_;
	GFile* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	const gchar* _tmp56_;
	GError* e;
	GError* _tmp57_;
	const gchar* _tmp58_;
	GError* _inner_error0_;
};

struct _CancellableProgressBar {
	GtkBox parent_instance;
	CancellableProgressBarPrivate * priv;
};

struct _CancellableProgressBarClass {
	GtkBoxClass parent_class;
};

struct _CancellableProgressBarPrivate {
	GtkProgressBar* bar;
	GtkButton* button;
};

struct _Block6Data {
	int _ref_count_;
	CancellableProgressBar* self;
	GCancellable* cancellable;
};

struct _Block7Data {
	int _ref_count_;
	CancellableProgressBar* self;
	GtkActionBar* parent;
};

struct _CropActions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CropActionsPrivate * priv;
};

struct _CropActionsClass {
	GTypeClass parent_class;
	void (*finalize) (CropActions *self);
};

struct _CropActionsPrivate {
	GSimpleActionGroup* group;
	GSimpleAction* crop_set;
	GSimpleAction* crop_rotate;
	GActionEntry* crop_entries;
	gint crop_entries_length1;
	gint _crop_entries_size_;
};

struct _ParamSpecCropActions {
	GParamSpec parent_instance;
};

static gint AppWindow_private_offset;
static gpointer app_window_parent_class = NULL;
static gchar* app_window_STATE_DIR;
static gchar* app_window_STATE_DIR = NULL;
static gint CancellableProgressBar_private_offset;
static gpointer cancellable_progress_bar_parent_class = NULL;
static gint CropActions_private_offset;
static gpointer crop_actions_parent_class = NULL;

VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN gpointer crop_actions_ref (gpointer instance);
VALA_EXTERN void crop_actions_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_crop_actions (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_crop_actions (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_crop_actions (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_crop_actions (const GValue* value);
VALA_EXTERN GType crop_actions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CropActions, crop_actions_unref)
VALA_EXTERN GType scan_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesDialog, g_object_unref)
VALA_EXTERN GType book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Book, g_object_unref)
VALA_EXTERN gpointer autosave_manager_ref (gpointer instance);
VALA_EXTERN void autosave_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_autosave_manager (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_autosave_manager (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_autosave_manager (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_autosave_manager (const GValue* value);
VALA_EXTERN GType autosave_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AutosaveManager, autosave_manager_unref)
VALA_EXTERN GType book_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookView, g_object_unref)
VALA_EXTERN Book* app_window_get_book (AppWindow* self);
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
static void app_window_page_added_cb (AppWindow* self,
                               Book* book,
                               Page* page);
static void _app_window_page_added_cb_book_page_added (Book* _sender,
                                                Page* page,
                                                gpointer self);
static void app_window_reordered_cb (AppWindow* self,
                              Book* book);
static void _app_window_reordered_cb_book_reordered (Book* _sender,
                                              gpointer self);
static void app_window_page_removed_cb (AppWindow* self,
                                 Book* book,
                                 Page* page);
static void _app_window_page_removed_cb_book_page_removed (Book* _sender,
                                                    Page* page,
                                                    gpointer self);
static void app_window_new_document_cb (AppWindow* self);
static void _app_window_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void app_window_scan_type_action_cb (AppWindow* self,
                                     GSimpleAction* action,
                                     GVariant* value);
static void _app_window_scan_type_action_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void app_window_document_hint_action_cb (AppWindow* self,
                                         GSimpleAction* action,
                                         GVariant* value);
static void _app_window_document_hint_action_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void app_window_scan_single_cb (AppWindow* self);
static void _app_window_scan_single_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void app_window_scan_adf_cb (AppWindow* self);
static void _app_window_scan_adf_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void app_window_scan_batch_cb (AppWindow* self);
static void _app_window_scan_batch_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void app_window_scan_stop_cb (AppWindow* self);
static void _app_window_scan_stop_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void app_window_rotate_left_cb (AppWindow* self);
static void _app_window_rotate_left_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void app_window_rotate_right_cb (AppWindow* self);
static void _app_window_rotate_right_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void app_window_move_left_cb (AppWindow* self);
static void _app_window_move_left_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void app_window_move_right_cb (AppWindow* self);
static void _app_window_move_right_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void app_window_copy_page_cb (AppWindow* self);
static void _app_window_copy_page_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void app_window_delete_page_cb (AppWindow* self);
static void _app_window_delete_page_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void app_window_reorder_document_cb (AppWindow* self);
static void _app_window_reorder_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
VALA_EXTERN void app_window_save_document_cb (AppWindow* self);
static void _app_window_save_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void app_window_email_document_cb (AppWindow* self);
static void _app_window_email_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void app_window_print_document_cb (AppWindow* self);
static void _app_window_print_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void app_window_preferences_cb (AppWindow* self);
static void _app_window_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void app_window_help_cb (AppWindow* self);
static void _app_window_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void app_window_about_cb (AppWindow* self);
static void _app_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void app_window_quit_cb (AppWindow* self);
static void _app_window_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN GType scan_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanDevice, g_object_unref)
static gchar* app_window_get_device_label (ScanDevice* device);
VALA_EXTERN AppWindow* app_window_new (void);
VALA_EXTERN AppWindow* app_window_construct (GType object_type);
VALA_EXTERN Book* book_new (void);
VALA_EXTERN Book* book_construct (GType object_type);
static void app_window_set_book (AppWindow* self,
                          Book* value);
static void app_window_book_changed_cb (AppWindow* self,
                                 Book* book);
static void _app_window_book_changed_cb_book_changed (Book* _sender,
                                               gpointer self);
static void app_window_load (AppWindow* self);
static void app_window_clear_document (AppWindow* self);
VALA_EXTERN void app_window_show_error_dialog (AppWindow* self,
                                   const gchar* error_title,
                                   const gchar* error_text);
static void app_window_authorize_data_free (gpointer _data);
VALA_EXTERN GType authorize_dialog_response_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AuthorizeDialogResponse* authorize_dialog_response_dup (const AuthorizeDialogResponse* self);
VALA_EXTERN void authorize_dialog_response_free (AuthorizeDialogResponse* self);
VALA_EXTERN void authorize_dialog_response_copy (const AuthorizeDialogResponse* self,
                                     AuthorizeDialogResponse* dest);
VALA_EXTERN void authorize_dialog_response_destroy (AuthorizeDialogResponse* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (AuthorizeDialogResponse, authorize_dialog_response_destroy)
VALA_EXTERN void app_window_authorize (AppWindow* self,
                           const gchar* resource,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
VALA_EXTERN void app_window_authorize_finish (AppWindow* self,
                                  GAsyncResult* _res_,
                                  AuthorizeDialogResponse* result);
static gboolean app_window_authorize_co (AppWindowAuthorizeData* _data_);
VALA_EXTERN GType authorize_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AuthorizeDialog, g_object_unref)
VALA_EXTERN AuthorizeDialog* authorize_dialog_new (GtkWindow* parent,
                                       const gchar* title);
VALA_EXTERN AuthorizeDialog* authorize_dialog_construct (GType object_type,
                                             GtkWindow* parent,
                                             const gchar* title);
VALA_EXTERN void authorize_dialog_open (AuthorizeDialog* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_);
VALA_EXTERN void authorize_dialog_open_finish (AuthorizeDialog* self,
                                   GAsyncResult* _res_,
                                   AuthorizeDialogResponse* result);
static void app_window_authorize_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_);
static void app_window_update_scan_status (AppWindow* self);
static gchar* app_window_get_selected_device (AppWindow* self);
static gchar* app_window_get_selected_device_label (AppWindow* self);
VALA_EXTERN void app_window_set_scan_devices (AppWindow* self,
                                  GList* devices,
                                  const gchar* missing_driver);
static ScanDevice* app_window_find_device_by_name (AppWindow* self,
                                            const gchar* name,
                                            guint* position);
static void app_window_prompt_to_load_autosaved_book_data_free (gpointer _data);
static void app_window_prompt_to_load_autosaved_book (AppWindow* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean app_window_prompt_to_load_autosaved_book_finish (AppWindow* self,
                                                          GAsyncResult* _res_);
static gboolean app_window_prompt_to_load_autosaved_book_co (AppWindowPromptToLoadAutosavedBookData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _app_window_prompt_to_load_autosaved_book_co_gsource_func (gpointer self);
static void __lambda43_ (Block1Data* _data1_,
                  const gchar* res);
static void ___lambda43__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
VALA_EXTERN void app_window_set_selected_device (AppWindow* self,
                                     const gchar* device);
static void app_window_choose_file_location_data_free (gpointer _data);
static void app_window_choose_file_location (AppWindow* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gchar* app_window_choose_file_location_finish (AppWindow* self,
                                               GAsyncResult* _res_);
static gboolean app_window_choose_file_location_co (AppWindowChooseFileLocationData* _data_);
static gchar* app_window_mime_type_to_extension (AppWindow* self,
                                          const gchar* mime_type);
static void app_window_choose_file_location_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gchar* app_window_uri_extension (AppWindow* self,
                                 const gchar* uri);
static gchar* app_window_extension_to_mime_type (AppWindow* self,
                                          const gchar* extension);
VALA_EXTERN guint book_get_n_pages (Book* self);
VALA_EXTERN GFile* make_indexed_file (const gchar* uri,
                          guint i,
                          guint n_pages);
static void app_window_check_overwrite (AppWindow* self,
                                 GtkWindow* parent,
                                 GList* files,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static gboolean app_window_check_overwrite_finish (AppWindow* self,
                                            GAsyncResult* _res_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void app_window_check_overwrite_data_free (gpointer _data);
static gboolean app_window_check_overwrite_co (AppWindowCheckOverwriteData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _app_window_check_overwrite_co_gsource_func (gpointer self);
static void ____lambda30_ (Block2Data* _data2_,
                    const gchar* res);
static void _____lambda30__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                               const gchar* response,
                                               gpointer self);
static gchar* app_window_uri_to_mime_type (AppWindow* self,
                                    const gchar* uri);
static void app_window_save_document_async_data_free (gpointer _data);
static void app_window_save_document_async (AppWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean app_window_save_document_finish (AppWindow* self,
                                          GAsyncResult* _res_);
static gboolean app_window_save_document_async_co (AppWindowSaveDocumentAsyncData* _data_);
VALA_EXTERN GType cancellable_progress_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CancellableProgressBar, g_object_unref)
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void app_window_save_document_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN CancellableProgressBar* cancellable_progress_bar_new (const gchar* text,
                                                      GCancellable* cancellable);
VALA_EXTERN CancellableProgressBar* cancellable_progress_bar_construct (GType object_type,
                                                            const gchar* text,
                                                            GCancellable* cancellable);
VALA_EXTERN void book_save_async (Book* self,
                      const gchar* mime_type,
                      gint quality,
                      GFile* file,
                      ProgressionCallback progress_cb,
                      gpointer progress_cb_target,
                      GCancellable* cancellable,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_);
VALA_EXTERN void book_save_finish (Book* self,
                       GAsyncResult* _res_,
                       GError** error);
static void ___lambda33_ (Block3Data* _data3_,
                   gdouble fraction);
VALA_EXTERN void cancellable_progress_bar_set_fraction (CancellableProgressBar* self,
                                            gdouble fraction);
static void ____lambda33__progression_callback (gdouble fraction,
                                         gpointer self);
VALA_EXTERN void cancellable_progress_bar_remove_with_delay (CancellableProgressBar* self,
                                                 guint delay,
                                                 GtkActionBar* parent);
VALA_EXTERN void book_postprocess_async (Book* self,
                             const gchar* mime_type,
                             GFile* file,
                             gboolean postproc_enabled,
                             const gchar* postproc_script,
                             const gchar* postproc_arguments,
                             gboolean postproc_keep_original,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void book_postprocess_finish (Book* self,
                              GAsyncResult* _res_,
                              GError** error);
static void app_window_prompt_to_save_async_data_free (gpointer _data);
static void app_window_prompt_to_save_async (AppWindow* self,
                                      const gchar* title,
                                      const gchar* discard_label,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean app_window_prompt_to_save_finish (AppWindow* self,
                                           GAsyncResult* _res_);
static gboolean app_window_prompt_to_save_async_co (AppWindowPromptToSaveAsyncData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean _app_window_prompt_to_save_async_co_gsource_func (gpointer self);
static void __lambda29_ (Block4Data* _data4_,
                  const gchar* res);
static void ___lambda29__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static void app_window_prompt_to_save_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
VALA_EXTERN void book_clear (Book* self);
static void app_window_new_document (AppWindow* self);
static void __lambda34_ (AppWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN gboolean app_window_get_scanning (AppWindow* self);
VALA_EXTERN void autosave_manager_cleanup (AutosaveManager* self);
static void ___lambda34__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean app_window_status_label_activate_link_cb (AppWindow* self,
                                                   GtkLabel* label,
                                                   const gchar* uri);
VALA_EXTERN GType drivers_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DriversDialog, g_object_unref)
VALA_EXTERN DriversDialog* drivers_dialog_new (GtkWindow* parent,
                                   const gchar* missing_driver);
VALA_EXTERN DriversDialog* drivers_dialog_construct (GType object_type,
                                         GtkWindow* parent,
                                         const gchar* missing_driver);
VALA_EXTERN void drivers_dialog_open (DriversDialog* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void drivers_dialog_open_finish (DriversDialog* self,
                                 GAsyncResult* _res_);
static void ___lambda45_ (AppWindow* self);
static void ____lambda45__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean _app_window_status_label_activate_link_cb_gtk_label_activate_link (GtkLabel* _sender,
                                                                            const gchar* uri,
                                                                            gpointer self);
static void _app_window_new_document_cb_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void app_window_crop_toggle_cb (AppWindow* self,
                                GtkToggleButton* btn);
VALA_EXTERN Page* book_view_get_selected_page (BookView* self);
VALA_EXTERN gboolean page_get_has_crop (Page* self);
static void app_window_set_crop (AppWindow* self,
                          const gchar* crop_name);
static void _app_window_crop_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                           gpointer self);
static void app_window_redetect_button_clicked_cb (AppWindow* self,
                                            GtkButton* button);
static void _app_window_redetect_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
VALA_EXTERN GType scan_options_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanOptions, g_object_unref)
static void app_window_scan (AppWindow* self,
                      ScanOptions* options);
static void app_window_set_scan_type (AppWindow* self,
                               ScanType scan_type);
static void app_window_set_document_hint (AppWindow* self,
                                   const gchar* document_hint,
                                   gboolean save);
static ScanOptions* app_window_make_scan_options (AppWindow* self);
VALA_EXTERN GType scan_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scan_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void page_rotate_left (Page* self);
VALA_EXTERN void page_rotate_right (Page* self);
VALA_EXTERN guint book_get_page_index (Book* self,
                           Page* page);
VALA_EXTERN void book_move_page (Book* self,
                     Page* page,
                     guint location);
VALA_EXTERN void page_copy_to_clipboard (Page* self,
                             GtkWindow* window);
VALA_EXTERN Book* book_view_get_book (BookView* self);
VALA_EXTERN void book_delete_page (Book* self,
                       Page* page);
static GVariant* _variant_new1 (const gchar* value);
static GVariant* _variant_new2 (const gchar* value);
static GVariant* _variant_new3 (const gchar* value);
static GVariant* _variant_new4 (const gchar* value);
VALA_EXTERN ScanOptions* scan_options_new (void);
VALA_EXTERN ScanOptions* scan_options_construct (GType object_type);
VALA_EXTERN gint preferences_dialog_get_text_dpi (PreferencesDialog* self);
VALA_EXTERN gint preferences_dialog_get_photo_dpi (PreferencesDialog* self);
VALA_EXTERN gboolean preferences_dialog_get_paper_size (PreferencesDialog* self,
                                            gint* width,
                                            gint* height);
VALA_EXTERN gint app_window_get_brightness (AppWindow* self);
VALA_EXTERN gint app_window_get_contrast (AppWindow* self);
VALA_EXTERN gint app_window_get_page_delay (AppWindow* self);
VALA_EXTERN ScanSide preferences_dialog_get_page_side (PreferencesDialog* self);
static void app_window_device_drop_down_changed_cb (AppWindow* self,
                                             GObject* widget,
                                             GParamSpec* spec);
static void _app_window_device_drop_down_changed_cb_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void app_window_scan_button_clicked_cb (AppWindow* self,
                                        GtkWidget* widget);
static void _app_window_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void app_window_stop_scan_button_clicked_cb (AppWindow* self,
                                             GtkWidget* widget);
static void _app_window_stop_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void app_window_update_page_menu (AppWindow* self);
static void app_window_page_selected_cb (AppWindow* self,
                                  BookView* view,
                                  Page* page);
VALA_EXTERN void crop_actions_update_current_crop (CropActions* self,
                                       const gchar* crop_name);
VALA_EXTERN const gchar* page_get_crop_name (Page* self);
static void app_window_show_page_cb (AppWindow* self,
                              BookView* view,
                              Page* page);
VALA_EXTERN void page_save_png (Page* self,
                    GFile* file,
                    GError** error);
static void app_window_show_page_menu_cb (AppWindow* self,
                                   BookView* view,
                                   GtkWidget* from,
                                   gdouble x,
                                   gdouble y);
VALA_EXTERN void page_set_no_crop (Page* self);
VALA_EXTERN gint page_get_width (Page* self);
VALA_EXTERN gint page_get_height (Page* self);
VALA_EXTERN void page_set_custom_crop (Page* self,
                           gint width,
                           gint height);
VALA_EXTERN void page_move_crop (Page* self,
                     gint x,
                     gint y);
VALA_EXTERN void page_set_named_crop (Page* self,
                          const gchar* name);
VALA_EXTERN void app_window_crop_set_action_cb (AppWindow* self,
                                    GSimpleAction* action,
                                    GVariant* value);
VALA_EXTERN void app_window_crop_rotate_action_cb (AppWindow* self);
VALA_EXTERN void page_rotate_crop (Page* self);
VALA_EXTERN GType reorder_pages_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ReorderPagesDialog, g_object_unref)
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN ReorderPagesDialog* reorder_pages_dialog_new (void);
VALA_EXTERN ReorderPagesDialog* reorder_pages_dialog_construct (GType object_type);
VALA_EXTERN GType reorder_pages_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ReorderPagesItem, g_object_unref)
static void __lambda35_ (Block5Data* _data5_);
VALA_EXTERN void book_combine_sides (Book* self);
static void ___lambda35__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda36_ (Block5Data* _data5_);
VALA_EXTERN void book_combine_sides_reverse (Book* self);
static void ___lambda36__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda37_ (Block5Data* _data5_);
VALA_EXTERN void book_reverse (Book* self);
static void ___lambda37__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda38_ (Block5Data* _data5_);
VALA_EXTERN GType flip_every_second_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void book_flip_every_second (Book* self,
                             FlipEverySecond flip);
static void ___lambda38__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda39_ (Block5Data* _data5_);
static void ___lambda39__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void app_window_draw_page (AppWindow* self,
                           GtkPrintOperation* operation,
                           GtkPrintContext* print_context,
                           gint page_number);
VALA_EXTERN Page* book_get_page (Book* self,
                     gint page_number);
VALA_EXTERN gboolean page_get_is_landscape (Page* self);
VALA_EXTERN gint page_get_dpi (Page* self);
VALA_EXTERN GdkPixbuf* page_get_image (Page* self,
                           gboolean apply_crop);
static void app_window_email_document_async (AppWindow* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void app_window_email_document_finish (AppWindow* self,
                                       GAsyncResult* _res_);
static void app_window_email_document_async_data_free (gpointer _data);
static gboolean app_window_email_document_async_co (AppWindowEmailDocumentAsyncData* _data_);
static void app_window_email_document_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void app_window_print_document (AppWindow* self);
static void _app_window_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                          GtkPrintContext* context,
                                                          gint page_nr,
                                                          gpointer self);
static void app_window_launch_help (AppWindow* self);
static void app_window_show_about (AppWindow* self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void app_window_on_quit (AppWindow* self);
static void __lambda40_ (AppWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void app_window_save_state (AppWindow* self,
                            gboolean force);
static void ___lambda40__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void app_window_real_size_allocate (GtkWidget* base,
                                    gint width,
                                    gint height,
                                    gint baseline);
static void app_window_real_unmap (GtkWidget* base);
static gboolean app_window_window_close_request_cb (AppWindow* self,
                                             GtkWindow* window);
static gboolean _app_window_window_close_request_cb_gtk_window_close_request (GtkWindow* _sender,
                                                                       gpointer self);
VALA_EXTERN PreferencesDialog* preferences_dialog_new (GSettings* settings);
VALA_EXTERN PreferencesDialog* preferences_dialog_construct (GType object_type,
                                                 GSettings* settings);
VALA_EXTERN CropActions* crop_actions_new (AppWindow* window);
VALA_EXTERN CropActions* crop_actions_construct (GType object_type,
                                     AppWindow* window);
VALA_EXTERN BookView* book_view_new (Book* book);
VALA_EXTERN BookView* book_view_construct (GType object_type,
                               Book* book);
static void _app_window_page_selected_cb_book_view_page_selected (BookView* _sender,
                                                           Page* page,
                                                           gpointer self);
static void _app_window_show_page_cb_book_view_show_page (BookView* _sender,
                                                   Page* page,
                                                   gpointer self);
static void _app_window_show_page_menu_cb_book_view_show_menu (BookView* _sender,
                                                        GtkWidget* from,
                                                        gdouble x,
                                                        gdouble y,
                                                        gpointer self);
static void app_window_load_state (AppWindow* self);
static gchar* app_window_get_state_filename (AppWindow* self);
static gint app_window_state_get_integer (AppWindow* self,
                                   GKeyFile* f,
                                   const gchar* group_name,
                                   const gchar* key,
                                   gint _default_);
static gboolean app_window_state_get_boolean (AppWindow* self,
                                       GKeyFile* f,
                                       const gchar* group_name,
                                       const gchar* key,
                                       gboolean _default_);
VALA_EXTERN ScanType scanner_type_from_string (const gchar* type);
static gchar* app_window_state_get_string (AppWindow* self,
                                    GKeyFile* f,
                                    const gchar* group_name,
                                    const gchar* key,
                                    const gchar* _default_);
static gboolean ___lambda41_ (AppWindow* self);
static gboolean ____lambda41__gsource_func (gpointer self);
VALA_EXTERN gchar* scanner_type_to_string (ScanType type);
VALA_EXTERN void app_window_start (AppWindow* self);
VALA_EXTERN AutosaveManager* autosave_manager_new (void);
VALA_EXTERN AutosaveManager* autosave_manager_construct (GType object_type);
VALA_EXTERN void autosave_manager_set_book (AutosaveManager* self,
                                Book* value);
VALA_EXTERN gboolean autosave_manager_exists (AutosaveManager* self);
static void ___lambda46_ (AppWindow* self,
                   GObject* obj,
                   GAsyncResult* res);
VALA_EXTERN void autosave_manager_load (AutosaveManager* self);
VALA_EXTERN void book_view_set_selected_page (BookView* self,
                                  Page* value);
static void ____lambda46__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN Page* app_window_get_selected_page (AppWindow* self);
VALA_EXTERN void app_window_set_selected_page (AppWindow* self,
                                   Page* value);
VALA_EXTERN void app_window_set_scanning (AppWindow* self,
                              gboolean value);
VALA_EXTERN gint preferences_dialog_get_brightness (PreferencesDialog* self);
VALA_EXTERN void app_window_set_brightness (AppWindow* self,
                                gint value);
VALA_EXTERN void preferences_dialog_set_brightness (PreferencesDialog* self,
                                        gint brightness);
VALA_EXTERN gint preferences_dialog_get_contrast (PreferencesDialog* self);
VALA_EXTERN void app_window_set_contrast (AppWindow* self,
                              gint value);
VALA_EXTERN void preferences_dialog_set_contrast (PreferencesDialog* self,
                                      gint contrast);
VALA_EXTERN gint preferences_dialog_get_page_delay (PreferencesDialog* self);
VALA_EXTERN void app_window_set_page_delay (AppWindow* self,
                                gint value);
VALA_EXTERN void preferences_dialog_set_page_delay (PreferencesDialog* self,
                                        gint page_delay);
static void g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void app_window_finalize (GObject * obj);
static GType app_window_get_type_once (void);
static void _vala_app_window_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_app_window_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda31_ (Block6Data* _data6_);
static void ____lambda31__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda32_ (Block7Data* _data7_);
static gboolean ___lambda32__gsource_func (gpointer self);
static void cancellable_progress_bar_finalize (GObject * obj);
static GType cancellable_progress_bar_get_type_once (void);
static void _app_window_crop_set_action_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void _app_window_crop_rotate_action_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static GVariant* _variant_new5 (const gchar* value);
static GVariant* _variant_new6 (const gchar* value);
static void crop_actions_finalize (CropActions * obj);
static GType crop_actions_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry APP_WINDOW_action_entries[21] = {{"new_document", _app_window_new_document_cb_gsimple_action_activate_callback}, {"scan_type", _app_window_scan_type_action_cb_gsimple_action_activate_callback, "s", "'single'"}, {"document_hint", _app_window_document_hint_action_cb_gsimple_action_activate_callback, "s", "'text'"}, {"scan_single", _app_window_scan_single_cb_gsimple_action_activate_callback}, {"scan_adf", _app_window_scan_adf_cb_gsimple_action_activate_callback}, {"scan_batch", _app_window_scan_batch_cb_gsimple_action_activate_callback}, {"scan_stop", _app_window_scan_stop_cb_gsimple_action_activate_callback}, {"rotate_left", _app_window_rotate_left_cb_gsimple_action_activate_callback}, {"rotate_right", _app_window_rotate_right_cb_gsimple_action_activate_callback}, {"move_left", _app_window_move_left_cb_gsimple_action_activate_callback}, {"move_right", _app_window_move_right_cb_gsimple_action_activate_callback}, {"copy_page", _app_window_copy_page_cb_gsimple_action_activate_callback}, {"delete_page", _app_window_delete_page_cb_gsimple_action_activate_callback}, {"reorder", _app_window_reorder_document_cb_gsimple_action_activate_callback}, {"save", _app_window_save_document_cb_gsimple_action_activate_callback}, {"email", _app_window_email_document_cb_gsimple_action_activate_callback}, {"print", _app_window_print_document_cb_gsimple_action_activate_callback}, {"preferences", _app_window_preferences_cb_gsimple_action_activate_callback}, {"help", _app_window_help_cb_gsimple_action_activate_callback}, {"about", _app_window_about_cb_gsimple_action_activate_callback}, {"quit", _app_window_quit_cb_gsimple_action_activate_callback}};

static inline gpointer
app_window_get_instance_private (AppWindow* self)
{
	return G_STRUCT_MEMBER_P (self, AppWindow_private_offset);
}

static void
_app_window_page_added_cb_book_page_added (Book* _sender,
                                           Page* page,
                                           gpointer self)
{
	app_window_page_added_cb ((AppWindow*) self, _sender, page);
}

static void
_app_window_reordered_cb_book_reordered (Book* _sender,
                                         gpointer self)
{
	app_window_reordered_cb ((AppWindow*) self, _sender);
}

static void
_app_window_page_removed_cb_book_page_removed (Book* _sender,
                                               Page* page,
                                               gpointer self)
{
	app_window_page_removed_cb ((AppWindow*) self, _sender, page);
}

static void
_app_window_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	app_window_new_document_cb ((AppWindow*) self);
}

static void
_app_window_scan_type_action_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	app_window_scan_type_action_cb ((AppWindow*) self, action, parameter);
}

static void
_app_window_document_hint_action_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	app_window_document_hint_action_cb ((AppWindow*) self, action, parameter);
}

static void
_app_window_scan_single_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_scan_single_cb ((AppWindow*) self);
}

static void
_app_window_scan_adf_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	app_window_scan_adf_cb ((AppWindow*) self);
}

static void
_app_window_scan_batch_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	app_window_scan_batch_cb ((AppWindow*) self);
}

static void
_app_window_scan_stop_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	app_window_scan_stop_cb ((AppWindow*) self);
}

static void
_app_window_rotate_left_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_rotate_left_cb ((AppWindow*) self);
}

static void
_app_window_rotate_right_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	app_window_rotate_right_cb ((AppWindow*) self);
}

static void
_app_window_move_left_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	app_window_move_left_cb ((AppWindow*) self);
}

static void
_app_window_move_right_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	app_window_move_right_cb ((AppWindow*) self);
}

static void
_app_window_copy_page_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	app_window_copy_page_cb ((AppWindow*) self);
}

static void
_app_window_delete_page_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_delete_page_cb ((AppWindow*) self);
}

static void
_app_window_reorder_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	app_window_reorder_document_cb ((AppWindow*) self);
}

static void
_app_window_save_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	app_window_save_document_cb ((AppWindow*) self);
}

static void
_app_window_email_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	app_window_email_document_cb ((AppWindow*) self);
}

static void
_app_window_print_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	app_window_print_document_cb ((AppWindow*) self);
}

static void
_app_window_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	app_window_preferences_cb ((AppWindow*) self);
}

static void
_app_window_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_help_cb ((AppWindow*) self);
}

static void
_app_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	app_window_about_cb ((AppWindow*) self);
}

static void
_app_window_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	app_window_quit_cb ((AppWindow*) self);
}

static gchar*
app_window_get_device_label (ScanDevice* device)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = device->label;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
_app_window_book_changed_cb_book_changed (Book* _sender,
                                          gpointer self)
{
	app_window_book_changed_cb ((AppWindow*) self, _sender);
}

AppWindow*
app_window_construct (GType object_type)
{
	AppWindow * self = NULL;
	GSettings* _tmp0_;
	GListStore* _tmp1_;
	GtkDropDown* _tmp2_;
	GListStore* _tmp3_;
	GtkDropDown* _tmp4_;
	GtkExpression** _tmp5_;
	GtkCClosureExpression* _tmp6_;
	GtkCClosureExpression* _tmp7_;
	Book* _tmp8_;
	Book* _tmp9_;
	Book* _tmp10_;
	Book* _tmp11_;
	Book* _tmp12_;
	Book* _tmp13_;
	self = (AppWindow*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.SimpleScan");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_list_store_new (TYPE_SCAN_DEVICE);
	_g_object_unref0 (self->priv->device_model);
	self->priv->device_model = _tmp1_;
	_tmp2_ = self->priv->device_drop_down;
	_tmp3_ = self->priv->device_model;
	gtk_drop_down_set_model (_tmp2_, (GListModel*) _tmp3_);
	_tmp4_ = self->priv->device_drop_down;
	_tmp5_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp6_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp5_, (GCallback) app_window_get_device_label, NULL, NULL);
	_tmp7_ = _tmp6_;
	gtk_drop_down_set_expression (_tmp4_, (GtkExpression*) _tmp7_);
	_gtk_expression_unref0 (_tmp7_);
	_tmp8_ = book_new ();
	_tmp9_ = _tmp8_;
	app_window_set_book (self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->_book;
	g_signal_connect_object (_tmp10_, "page-added", (GCallback) _app_window_page_added_cb_book_page_added, self, 0);
	_tmp11_ = self->priv->_book;
	g_signal_connect_object (_tmp11_, "reordered", (GCallback) _app_window_reordered_cb_book_reordered, self, 0);
	_tmp12_ = self->priv->_book;
	g_signal_connect_object (_tmp12_, "page-removed", (GCallback) _app_window_page_removed_cb_book_page_removed, self, 0);
	_tmp13_ = self->priv->_book;
	g_signal_connect_object (_tmp13_, "changed", (GCallback) _app_window_book_changed_cb_book_changed, self, 0);
	app_window_load (self);
	app_window_clear_document (self);
	return self;
}

AppWindow*
app_window_new (void)
{
	return app_window_construct (TYPE_APP_WINDOW);
}

void
app_window_show_error_dialog (AppWindow* self,
                              const gchar* error_title,
                              const gchar* error_text)
{
	AdwAlertDialog* dialog = NULL;
	AdwAlertDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_title != NULL);
	g_return_if_fail (error_text != NULL);
	_tmp0_ = (AdwAlertDialog*) adw_alert_dialog_new (error_title, error_text);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	adw_alert_dialog_add_response (dialog, "close", _ ("_Close"));
	adw_alert_dialog_set_response_appearance (dialog, "close", ADW_RESPONSE_SUGGESTED);
	adw_dialog_present ((AdwDialog*) dialog, (GtkWidget*) self);
	_g_object_unref0 (dialog);
}

static void
app_window_authorize_data_free (gpointer _data)
{
	AppWindowAuthorizeData* _data_;
	_data_ = _data;
	_g_free0 (_data_->resource);
	authorize_dialog_response_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowAuthorizeData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
app_window_authorize (AppWindow* self,
                      const gchar* resource,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	AppWindowAuthorizeData* _data_;
	AppWindow* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource != NULL);
	_data_ = g_slice_new0 (AppWindowAuthorizeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_authorize_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (resource);
	_g_free0 (_data_->resource);
	_data_->resource = _tmp1_;
	app_window_authorize_co (_data_);
}

void
app_window_authorize_finish (AppWindow* self,
                             GAsyncResult* _res_,
                             AuthorizeDialogResponse* result)
{
	AppWindowAuthorizeData* _data_;
	AuthorizeDialogResponse _tmp0_;
	AuthorizeDialogResponse _tmp1_ = {0};
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	_tmp0_ = _data_->result;
	authorize_dialog_response_copy (&_tmp0_, &_tmp1_);
	*result = _tmp1_;
}

static void
app_window_authorize_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_)
{
	AppWindowAuthorizeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	app_window_authorize_co (_data_);
}

static gboolean
app_window_authorize_co (AppWindowAuthorizeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup_printf (_ ("Username and password required to access “%s”"), _data_->resource);
	_data_->description = _data_->_tmp0_;
	_data_->_tmp1_ = authorize_dialog_new ((GtkWindow*) _data_->self, _data_->description);
	g_object_ref_sink (_data_->_tmp1_);
	_data_->authorize_dialog = _data_->_tmp1_;
	gtk_window_set_transient_for ((GtkWindow*) _data_->authorize_dialog, (GtkWindow*) _data_->self);
	memset (&_data_->_tmp2_, 0, sizeof (AuthorizeDialogResponse));
	_data_->_state_ = 1;
	authorize_dialog_open (_data_->authorize_dialog, app_window_authorize_ready, _data_);
	return FALSE;
	_state_1:
	authorize_dialog_open_finish (_data_->authorize_dialog, _data_->_res_, &_data_->_tmp2_);
	_data_->result = _data_->_tmp2_;
	_g_object_unref0 (_data_->authorize_dialog);
	_g_free0 (_data_->description);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
app_window_update_scan_status (AppWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scan_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	if (!self->priv->have_devices) {
		AdwStatusPage* _tmp1_;
		GtkLabel* _tmp2_;
		GtkBox* _tmp3_;
		_tmp1_ = self->priv->status_page;
		adw_status_page_set_title (_tmp1_, _ ("Searching for Scanners…"));
		_tmp2_ = self->priv->status_secondary_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = self->priv->device_buttons_box;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = app_window_get_selected_device (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_ != NULL;
		_g_free0 (_tmp5_);
		if (_tmp6_) {
			GtkButton* _tmp7_;
			AdwStatusPage* _tmp8_;
			GtkLabel* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GtkLabel* _tmp12_;
			GtkBox* _tmp13_;
			GtkBox* _tmp14_;
			GtkDropDown* _tmp15_;
			_tmp7_ = self->priv->scan_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
			_tmp8_ = self->priv->status_page;
			adw_status_page_set_title (_tmp8_, _ ("Ready to Scan"));
			_tmp9_ = self->priv->status_secondary_label;
			_tmp10_ = app_window_get_selected_device_label (self);
			_tmp11_ = _tmp10_;
			gtk_label_set_text (_tmp9_, _tmp11_);
			_g_free0 (_tmp11_);
			_tmp12_ = self->priv->status_secondary_label;
			gtk_widget_set_visible ((GtkWidget*) _tmp12_, FALSE);
			_tmp13_ = self->priv->device_buttons_box;
			gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
			_tmp14_ = self->priv->device_buttons_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
			_tmp15_ = self->priv->device_drop_down;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, TRUE);
		} else {
			const gchar* _tmp16_;
			_tmp16_ = self->priv->missing_driver;
			if (_tmp16_ != NULL) {
				AdwStatusPage* _tmp17_;
				GtkLabel* _tmp18_;
				GtkLabel* _tmp19_;
				GtkBox* _tmp20_;
				_tmp17_ = self->priv->status_page;
				adw_status_page_set_title (_tmp17_, _ ("Additional Software Needed"));
				_tmp18_ = self->priv->status_secondary_label;
				gtk_label_set_markup (_tmp18_, _ ("You need to <a href=\"install-firmware\">install driver software</a> f" \
"or your scanner"));
				_tmp19_ = self->priv->status_secondary_label;
				gtk_widget_set_visible ((GtkWidget*) _tmp19_, TRUE);
				_tmp20_ = self->priv->device_buttons_box;
				gtk_widget_set_visible ((GtkWidget*) _tmp20_, FALSE);
			} else {
				AdwStatusPage* _tmp21_;
				GtkLabel* _tmp22_;
				GtkLabel* _tmp23_;
				GtkBox* _tmp24_;
				GtkBox* _tmp25_;
				GtkDropDown* _tmp26_;
				_tmp21_ = self->priv->status_page;
				adw_status_page_set_title (_tmp21_, _ ("No Scanners Detected"));
				_tmp22_ = self->priv->status_secondary_label;
				gtk_label_set_text (_tmp22_, _ ("Please check your scanner is connected and powered on"));
				_tmp23_ = self->priv->status_secondary_label;
				gtk_widget_set_visible ((GtkWidget*) _tmp23_, TRUE);
				_tmp24_ = self->priv->device_buttons_box;
				gtk_widget_set_visible ((GtkWidget*) _tmp24_, TRUE);
				_tmp25_ = self->priv->device_buttons_box;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, TRUE);
				_tmp26_ = self->priv->device_drop_down;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, FALSE);
			}
		}
	}
}

void
app_window_set_scan_devices (AppWindow* self,
                             GList* devices,
                             const gchar* missing_driver)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->have_devices = TRUE;
	_tmp0_ = g_strdup (missing_driver);
	_g_free0 (self->priv->missing_driver);
	self->priv->missing_driver = _tmp0_;
	self->priv->setting_devices = TRUE;
	{
		GListStore* _tmp1_;
		gchar* device_name = NULL;
		GSettings* _tmp5_;
		gchar* _tmp6_;
		guint position = 0U;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		_tmp1_ = self->priv->device_model;
		g_list_store_remove_all (_tmp1_);
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
			device_collection = devices;
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
				ScanDevice* _tmp2_;
				ScanDevice* device = NULL;
				_tmp2_ = _g_object_ref0 ((ScanDevice*) device_it->data);
				device = _tmp2_;
				{
					GListStore* _tmp3_;
					ScanDevice* _tmp4_;
					_tmp3_ = self->priv->device_model;
					_tmp4_ = device;
					g_list_store_append (_tmp3_, (GObject*) _tmp4_);
					_g_object_unref0 (device);
				}
			}
		}
		_tmp5_ = self->priv->settings;
		_tmp6_ = g_settings_get_string (_tmp5_, "selected-device");
		device_name = _tmp6_;
		position = (guint) 0;
		_tmp8_ = device_name;
		if (_tmp8_ != NULL) {
			const gchar* _tmp9_;
			guint _tmp10_ = 0U;
			ScanDevice* _tmp11_;
			ScanDevice* _tmp12_;
			_tmp9_ = device_name;
			_tmp11_ = app_window_find_device_by_name (self, _tmp9_, &_tmp10_);
			position = _tmp10_;
			_tmp12_ = _tmp11_;
			_tmp7_ = _tmp12_ != NULL;
			_g_object_unref0 (_tmp12_);
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			GtkDropDown* _tmp13_;
			_tmp13_ = self->priv->device_drop_down;
			gtk_drop_down_set_selected (_tmp13_, position);
		} else {
			GtkDropDown* _tmp14_;
			_tmp14_ = self->priv->device_drop_down;
			gtk_drop_down_set_selected (_tmp14_, (guint) 0);
		}
		_g_free0 (device_name);
	}
	self->priv->setting_devices = FALSE;
	app_window_update_scan_status (self);
}

static void
app_window_prompt_to_load_autosaved_book_data_free (gpointer _data)
{
	AppWindowPromptToLoadAutosavedBookData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowPromptToLoadAutosavedBookData, _data_);
}

static void
app_window_prompt_to_load_autosaved_book (AppWindow* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	AppWindowPromptToLoadAutosavedBookData* _data_;
	AppWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AppWindowPromptToLoadAutosavedBookData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_prompt_to_load_autosaved_book_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	app_window_prompt_to_load_autosaved_book_co (_data_);
}

static gboolean
app_window_prompt_to_load_autosaved_book_finish (AppWindow* self,
                                                 GAsyncResult* _res_)
{
	gboolean result;
	AppWindowPromptToLoadAutosavedBookData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		AppWindow* self;
		self = _data1_->self;
		(_data1_->callback_target_destroy_notify == NULL) ? NULL : (_data1_->callback_target_destroy_notify (_data1_->callback_target), NULL);
		_data1_->callback = NULL;
		_data1_->callback_target = NULL;
		_data1_->callback_target_destroy_notify = NULL;
		_g_free0 (_data1_->response);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
_app_window_prompt_to_load_autosaved_book_co_gsource_func (gpointer self)
{
	gboolean result;
	result = app_window_prompt_to_load_autosaved_book_co (self);
	return result;
}

static void
__lambda43_ (Block1Data* _data1_,
             const gchar* res)
{
	AppWindow* self;
	gchar* _tmp0_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = g_strdup (res);
	_g_free0 (_data1_->response);
	_data1_->response = _tmp0_;
	_data1_->callback (_data1_->callback_target);
}

static void
___lambda43__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda43_ (self, response);
}

static gboolean
app_window_prompt_to_load_autosaved_book_co (AppWindowPromptToLoadAutosavedBookData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = (AdwAlertDialog*) adw_alert_dialog_new ("", _ ("An autosaved book exists. Do you want to open it?"));
	g_object_ref_sink (_data_->_tmp0_);
	_data_->dialog = _data_->_tmp0_;
	adw_alert_dialog_add_response (_data_->dialog, "no", _ ("_No"));
	adw_alert_dialog_add_response (_data_->dialog, "yes", _ ("_Yes"));
	adw_alert_dialog_set_response_appearance (_data_->dialog, "no", ADW_RESPONSE_DESTRUCTIVE);
	adw_alert_dialog_set_response_appearance (_data_->dialog, "yes", ADW_RESPONSE_SUGGESTED);
	adw_alert_dialog_set_default_response (_data_->dialog, "yes");
	adw_dialog_present ((AdwDialog*) _data_->dialog, (GtkWidget*) _data_->self);
	_data_->_tmp1_ = g_strdup ("yes");
	_data_->_data1_->response = _data_->_tmp1_;
	_data_->_data1_->callback = _app_window_prompt_to_load_autosaved_book_co_gsource_func;
	_data_->_data1_->callback_target = _data_;
	_data_->_data1_->callback_target_destroy_notify = NULL;
	g_signal_connect_data (_data_->dialog, "response", (GCallback) ___lambda43__adw_alert_dialog_response, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->result = g_strcmp0 (_data_->_data1_->response, "yes") == 0;
	_g_object_unref0 (_data_->dialog);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
app_window_get_selected_device (AppWindow* self)
{
	GtkDropDown* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->device_drop_down;
	_tmp1_ = gtk_drop_down_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != GTK_INVALID_LIST_POSITION) {
		GListStore* _tmp3_;
		GtkDropDown* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		GObject* _tmp7_;
		ScanDevice* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp3_ = self->priv->device_model;
		_tmp4_ = self->priv->device_drop_down;
		_tmp5_ = gtk_drop_down_get_selected (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_list_model_get_item ((GListModel*) _tmp3_, _tmp6_);
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_SCAN_DEVICE, ScanDevice);
		_tmp9_ = _tmp8_->name;
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp8_);
		result = _tmp11_;
		return result;
	}
	result = NULL;
	return result;
}

static gchar*
app_window_get_selected_device_label (AppWindow* self)
{
	GtkDropDown* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->device_drop_down;
	_tmp1_ = gtk_drop_down_get_selected (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != GTK_INVALID_LIST_POSITION) {
		GListStore* _tmp3_;
		GtkDropDown* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		GObject* _tmp7_;
		ScanDevice* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp3_ = self->priv->device_model;
		_tmp4_ = self->priv->device_drop_down;
		_tmp5_ = gtk_drop_down_get_selected (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_list_model_get_item ((GListModel*) _tmp3_, _tmp6_);
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_SCAN_DEVICE, ScanDevice);
		_tmp9_ = _tmp8_->label;
		_tmp10_ = g_strdup (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp8_);
		result = _tmp11_;
		return result;
	}
	result = NULL;
	return result;
}

void
app_window_set_selected_device (AppWindow* self,
                                const gchar* device)
{
	guint position = 0U;
	guint _tmp0_ = 0U;
	ScanDevice* _tmp1_;
	ScanDevice* _tmp2_;
	GtkDropDown* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	self->priv->user_selected_device = TRUE;
	_tmp1_ = app_window_find_device_by_name (self, device, &_tmp0_);
	position = _tmp0_;
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	if (position != GTK_INVALID_LIST_POSITION) {
		return;
	}
	_tmp3_ = self->priv->device_drop_down;
	gtk_drop_down_set_selected (_tmp3_, position);
}

static ScanDevice*
app_window_find_device_by_name (AppWindow* self,
                                const gchar* name,
                                guint* position)
{
	guint _vala_position = 0U;
	ScanDevice* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				ScanDevice* item = NULL;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				ScanDevice* _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->device_model;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->device_model;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SCAN_DEVICE, ScanDevice);
				_tmp5_ = item;
				_tmp6_ = _tmp5_->name;
				if (g_strcmp0 (_tmp6_, name) == 0) {
					_vala_position = i;
					result = item;
					if (position) {
						*position = _vala_position;
					}
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	_vala_position = GTK_INVALID_LIST_POSITION;
	result = NULL;
	if (position) {
		*position = _vala_position;
	}
	return result;
}

static void
app_window_choose_file_location_data_free (gpointer _data)
{
	AppWindowChooseFileLocationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowChooseFileLocationData, _data_);
}

static void
app_window_choose_file_location (AppWindow* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AppWindowChooseFileLocationData* _data_;
	AppWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AppWindowChooseFileLocationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_choose_file_location_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	app_window_choose_file_location_co (_data_);
}

static gchar*
app_window_choose_file_location_finish (AppWindow* self,
                                        GAsyncResult* _res_)
{
	gchar* result;
	AppWindowChooseFileLocationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
app_window_choose_file_location_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AppWindowChooseFileLocationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	app_window_choose_file_location_co (_data_);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
app_window_choose_file_location_co (AppWindowChooseFileLocationData* _data_)
{
	static GQuark _tmp67_label0 = 0;
	static GQuark _tmp67_label1 = 0;
	static GQuark _tmp67_label2 = 0;
	static GQuark _tmp67_label3 = 0;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->directory = NULL;
	_data_->_tmp0_ = _data_->self->priv->settings;
	_data_->_tmp1_ = g_settings_get_string (_data_->_tmp0_, "save-directory");
	_g_free0 (_data_->directory);
	_data_->directory = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->directory;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->directory;
		_data_->_tmp2_ = g_strcmp0 (_data_->_tmp4_, "") == 0;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp6_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
		_data_->_tmp7_ = g_filename_to_uri (_data_->_tmp6_, NULL, &_data_->_inner_error0_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->directory);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		_g_free0 (_data_->directory);
		_data_->directory = _data_->_tmp8_;
		_g_free0 (_data_->_tmp5_);
	}
	_data_->_tmp9_ = gtk_file_dialog_new ();
	_data_->save_dialog = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->save_dialog;
	gtk_file_dialog_set_title (_data_->_tmp10_, _ ("Save As…"));
	_data_->_tmp11_ = _data_->save_dialog;
	gtk_file_dialog_set_modal (_data_->_tmp11_, TRUE);
	_data_->_tmp12_ = _data_->save_dialog;
	gtk_file_dialog_set_accept_label (_data_->_tmp12_, _ ("_Save"));
	_data_->_tmp13_ = _data_->self->priv->settings;
	_data_->_tmp14_ = g_settings_get_string (_data_->_tmp13_, "save-format");
	_data_->save_format = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->self->priv->book_uri;
	if (_data_->_tmp15_ != NULL) {
		_data_->_tmp16_ = _data_->save_dialog;
		_data_->_tmp17_ = _data_->self->priv->book_uri;
		_data_->_tmp18_ = g_file_new_for_uri (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		gtk_file_dialog_set_initial_file (_data_->_tmp16_, _data_->_tmp19_);
		_g_object_unref0 (_data_->_tmp19_);
	} else {
		_data_->_tmp20_ = _data_->save_dialog;
		_data_->_tmp21_ = _data_->directory;
		_data_->_tmp22_ = g_file_new_for_uri (_data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		gtk_file_dialog_set_initial_folder (_data_->_tmp20_, _data_->_tmp23_);
		_g_object_unref0 (_data_->_tmp23_);
		_data_->_tmp24_ = _data_->save_dialog;
		_data_->_tmp25_ = g_strconcat (_ ("Scanned Document"), ".", NULL);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->save_format;
		_data_->_tmp28_ = app_window_mime_type_to_extension (_data_->self, _data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = g_strconcat (_data_->_tmp26_, _data_->_tmp29_, NULL);
		_data_->_tmp31_ = _data_->_tmp30_;
		gtk_file_dialog_set_initial_name (_data_->_tmp24_, _data_->_tmp31_);
		_g_free0 (_data_->_tmp31_);
		_g_free0 (_data_->_tmp29_);
		_g_free0 (_data_->_tmp26_);
	}
	_data_->_tmp32_ = g_list_store_new (gtk_file_filter_get_type ());
	_data_->filters = _data_->_tmp32_;
	_data_->_tmp33_ = gtk_file_filter_new ();
	_data_->pdf_filter = _data_->_tmp33_;
	_data_->_tmp34_ = _data_->pdf_filter;
	gtk_file_filter_set_name (_data_->_tmp34_, _ ("PDF (multi-page document)"));
	_data_->_tmp35_ = _data_->pdf_filter;
	gtk_file_filter_add_pattern (_data_->_tmp35_, "*.pdf");
	_data_->_tmp36_ = _data_->pdf_filter;
	gtk_file_filter_add_mime_type (_data_->_tmp36_, "application/pdf");
	_data_->_tmp37_ = _data_->filters;
	_data_->_tmp38_ = _data_->pdf_filter;
	g_list_store_append (_data_->_tmp37_, (GObject*) _data_->_tmp38_);
	_data_->_tmp39_ = gtk_file_filter_new ();
	_data_->jpeg_filter = _data_->_tmp39_;
	_data_->_tmp40_ = _data_->jpeg_filter;
	gtk_file_filter_set_name (_data_->_tmp40_, _ ("JPEG (compressed)"));
	_data_->_tmp41_ = _data_->jpeg_filter;
	gtk_file_filter_add_pattern (_data_->_tmp41_, "*.jpg");
	_data_->_tmp42_ = _data_->jpeg_filter;
	gtk_file_filter_add_pattern (_data_->_tmp42_, "*.jpeg");
	_data_->_tmp43_ = _data_->jpeg_filter;
	gtk_file_filter_add_mime_type (_data_->_tmp43_, "image/jpeg");
	_data_->_tmp44_ = _data_->filters;
	_data_->_tmp45_ = _data_->jpeg_filter;
	g_list_store_append (_data_->_tmp44_, (GObject*) _data_->_tmp45_);
	_data_->_tmp46_ = gtk_file_filter_new ();
	_data_->png_filter = _data_->_tmp46_;
	_data_->_tmp47_ = _data_->png_filter;
	gtk_file_filter_set_name (_data_->_tmp47_, _ ("PNG (lossless)"));
	_data_->_tmp48_ = _data_->png_filter;
	gtk_file_filter_add_pattern (_data_->_tmp48_, "*.png");
	_data_->_tmp49_ = _data_->png_filter;
	gtk_file_filter_add_mime_type (_data_->_tmp49_, "image/png");
	_data_->_tmp50_ = _data_->filters;
	_data_->_tmp51_ = _data_->png_filter;
	g_list_store_append (_data_->_tmp50_, (GObject*) _data_->_tmp51_);
	_data_->_tmp52_ = gtk_file_filter_new ();
	_data_->webp_filter = _data_->_tmp52_;
	_data_->_tmp53_ = _data_->webp_filter;
	gtk_file_filter_set_name (_data_->_tmp53_, _ ("WebP (compressed)"));
	_data_->_tmp54_ = _data_->webp_filter;
	gtk_file_filter_add_pattern (_data_->_tmp54_, "*.webp");
	_data_->_tmp55_ = _data_->webp_filter;
	gtk_file_filter_add_mime_type (_data_->_tmp55_, "image/webp");
	_data_->_tmp56_ = _data_->filters;
	_data_->_tmp57_ = _data_->webp_filter;
	g_list_store_append (_data_->_tmp56_, (GObject*) _data_->_tmp57_);
	_data_->_tmp58_ = gtk_file_filter_new ();
	_data_->all_filter = _data_->_tmp58_;
	_data_->_tmp59_ = _data_->all_filter;
	gtk_file_filter_set_name (_data_->_tmp59_, _ ("All Files"));
	_data_->_tmp60_ = _data_->all_filter;
	gtk_file_filter_add_pattern (_data_->_tmp60_, "*");
	_data_->_tmp61_ = _data_->filters;
	_data_->_tmp62_ = _data_->all_filter;
	g_list_store_append (_data_->_tmp61_, (GObject*) _data_->_tmp62_);
	_data_->_tmp63_ = _data_->save_dialog;
	_data_->_tmp64_ = _data_->filters;
	gtk_file_dialog_set_filters (_data_->_tmp63_, (GListModel*) _data_->_tmp64_);
	_data_->_tmp65_ = _data_->save_format;
	_data_->_tmp68_ = 0U;
	_data_->_tmp66_ = _data_->_tmp65_;
	_data_->_tmp68_ = (NULL == _data_->_tmp66_) ? 0 : g_quark_from_string (_data_->_tmp66_);
	if (_data_->_tmp68_ == ((0 != _tmp67_label0) ? _tmp67_label0 : (_tmp67_label0 = g_quark_from_static_string ("application/pdf")))) {
		switch (0) {
			default:
			{
				_data_->_tmp69_ = _data_->save_dialog;
				_data_->_tmp70_ = _data_->pdf_filter;
				gtk_file_dialog_set_default_filter (_data_->_tmp69_, _data_->_tmp70_);
				break;
			}
		}
	} else if (_data_->_tmp68_ == ((0 != _tmp67_label1) ? _tmp67_label1 : (_tmp67_label1 = g_quark_from_static_string ("image/jpeg")))) {
		switch (0) {
			default:
			{
				_data_->_tmp71_ = _data_->save_dialog;
				_data_->_tmp72_ = _data_->jpeg_filter;
				gtk_file_dialog_set_default_filter (_data_->_tmp71_, _data_->_tmp72_);
				break;
			}
		}
	} else if (_data_->_tmp68_ == ((0 != _tmp67_label2) ? _tmp67_label2 : (_tmp67_label2 = g_quark_from_static_string ("image/png")))) {
		switch (0) {
			default:
			{
				_data_->_tmp73_ = _data_->save_dialog;
				_data_->_tmp74_ = _data_->png_filter;
				gtk_file_dialog_set_default_filter (_data_->_tmp73_, _data_->_tmp74_);
				break;
			}
		}
	} else if (_data_->_tmp68_ == ((0 != _tmp67_label3) ? _tmp67_label3 : (_tmp67_label3 = g_quark_from_static_string ("image/webp")))) {
		switch (0) {
			default:
			{
				_data_->_tmp75_ = _data_->save_dialog;
				_data_->_tmp76_ = _data_->webp_filter;
				gtk_file_dialog_set_default_filter (_data_->_tmp75_, _data_->_tmp76_);
				break;
			}
		}
	}
	_data_->_tmp77_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_data_->_tmp77_);
	_data_->box = _data_->_tmp77_;
	_data_->_tmp78_ = _data_->box;
	gtk_widget_set_visible ((GtkWidget*) _data_->_tmp78_, TRUE);
	_data_->_tmp79_ = _data_->box;
	gtk_box_set_spacing (_data_->_tmp79_, 10);
	_data_->_tmp80_ = _data_->box;
	gtk_widget_set_halign ((GtkWidget*) _data_->_tmp80_, GTK_ALIGN_CENTER);
	while (TRUE) {
		_data_->file = NULL;
		{
			_data_->_tmp82_ = _data_->save_dialog;
			_data_->_state_ = 1;
			gtk_file_dialog_save (_data_->_tmp82_, (GtkWindow*) _data_->self, NULL, app_window_choose_file_location_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp83_ = gtk_file_dialog_save_finish (_data_->_tmp82_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp81_ = _data_->_tmp83_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp84_ = _data_->_tmp81_;
			_data_->_tmp81_ = NULL;
			_g_object_unref0 (_data_->file);
			_data_->file = _data_->_tmp84_;
			_g_object_unref0 (_data_->_tmp81_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp85_ = _data_->e;
			_data_->_tmp86_ = _data_->_tmp85_->message;
			g_warning ("app-window.vala:470: Failed to open save dialog: %s", _data_->_tmp86_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->box);
			_g_object_unref0 (_data_->all_filter);
			_g_object_unref0 (_data_->webp_filter);
			_g_object_unref0 (_data_->png_filter);
			_g_object_unref0 (_data_->jpeg_filter);
			_g_object_unref0 (_data_->pdf_filter);
			_g_object_unref0 (_data_->filters);
			_g_free0 (_data_->save_format);
			_g_object_unref0 (_data_->save_dialog);
			_g_free0 (_data_->directory);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp87_ = _data_->file;
		if (_data_->_tmp87_ == NULL) {
			_data_->result = NULL;
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->box);
			_g_object_unref0 (_data_->all_filter);
			_g_object_unref0 (_data_->webp_filter);
			_g_object_unref0 (_data_->png_filter);
			_g_object_unref0 (_data_->jpeg_filter);
			_g_object_unref0 (_data_->pdf_filter);
			_g_object_unref0 (_data_->filters);
			_g_free0 (_data_->save_format);
			_g_object_unref0 (_data_->save_dialog);
			_g_free0 (_data_->directory);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp88_ = _data_->file;
		_data_->_tmp89_ = g_file_get_uri (_data_->_tmp88_);
		_data_->uri = _data_->_tmp89_;
		_data_->_tmp90_ = _data_->uri;
		_data_->_tmp91_ = app_window_uri_extension (_data_->self, _data_->_tmp90_);
		_data_->extension = _data_->_tmp91_;
		_data_->_tmp92_ = _data_->extension;
		_data_->_tmp93_ = app_window_extension_to_mime_type (_data_->self, _data_->_tmp92_);
		_data_->mime_type = _data_->_tmp93_;
		_data_->_tmp95_ = _data_->mime_type;
		if (_data_->_tmp95_ != NULL) {
			_data_->_tmp96_ = _data_->mime_type;
			_data_->_tmp94_ = _data_->_tmp96_;
		} else {
			_data_->_tmp94_ = "application/pdf";
		}
		_data_->_tmp97_ = g_strdup (_data_->_tmp94_);
		_g_free0 (_data_->mime_type);
		_data_->mime_type = _data_->_tmp97_;
		_data_->_tmp98_ = _data_->self->priv->settings;
		_data_->_tmp99_ = _data_->mime_type;
		g_settings_set_string (_data_->_tmp98_, "save-format", _data_->_tmp99_);
		_data_->_tmp100_ = _data_->extension;
		if (_data_->_tmp100_ == NULL) {
			_data_->_tmp101_ = _data_->uri;
			_data_->_tmp102_ = _data_->mime_type;
			_data_->_tmp103_ = app_window_mime_type_to_extension (_data_->self, _data_->_tmp102_);
			_data_->_tmp104_ = _data_->_tmp103_;
			_data_->_tmp105_ = g_strconcat (".", _data_->_tmp104_, NULL);
			_data_->_tmp106_ = _data_->_tmp105_;
			_data_->_tmp107_ = g_strconcat (_data_->_tmp101_, _data_->_tmp106_, NULL);
			_g_free0 (_data_->uri);
			_data_->uri = _data_->_tmp107_;
			_g_free0 (_data_->_tmp106_);
			_g_free0 (_data_->_tmp104_);
		}
		_data_->files = NULL;
		_data_->_tmp110_ = _data_->mime_type;
		if (g_strcmp0 (_data_->_tmp110_, "image/jpeg") == 0) {
			_data_->_tmp109_ = TRUE;
		} else {
			_data_->_tmp111_ = _data_->mime_type;
			_data_->_tmp109_ = g_strcmp0 (_data_->_tmp111_, "image/png") == 0;
		}
		if (_data_->_tmp109_) {
			_data_->_tmp108_ = TRUE;
		} else {
			_data_->_tmp112_ = _data_->mime_type;
			_data_->_tmp108_ = g_strcmp0 (_data_->_tmp112_, "image/webp") == 0;
		}
		if (_data_->_tmp108_) {
			{
				_data_->j = 0;
				{
					_data_->_tmp113_ = TRUE;
					while (TRUE) {
						if (!_data_->_tmp113_) {
							_data_->_tmp114_ = _data_->j;
							_data_->j = _data_->_tmp114_ + 1;
						}
						_data_->_tmp113_ = FALSE;
						_data_->_tmp115_ = _data_->self->priv->_book;
						_data_->_tmp116_ = book_get_n_pages (_data_->_tmp115_);
						_data_->_tmp117_ = _data_->_tmp116_;
						if (!(((guint) _data_->j) < _data_->_tmp117_)) {
							break;
						}
						_data_->_tmp118_ = _data_->uri;
						_data_->_tmp119_ = _data_->self->priv->_book;
						_data_->_tmp120_ = book_get_n_pages (_data_->_tmp119_);
						_data_->_tmp121_ = _data_->_tmp120_;
						_data_->_tmp122_ = make_indexed_file (_data_->_tmp118_, (guint) _data_->j, _data_->_tmp121_);
						_data_->files = g_list_append (_data_->files, _data_->_tmp122_);
					}
				}
			}
		} else {
			_data_->_tmp123_ = _data_->uri;
			_data_->_tmp124_ = g_file_new_for_uri (_data_->_tmp123_);
			_data_->files = g_list_append (_data_->files, _data_->_tmp124_);
		}
		_data_->overwrite_check = TRUE;
		_data_->_tmp126_ = _data_->files;
		if (g_list_length (_data_->_tmp126_) > ((guint) 1)) {
			_data_->_tmp125_ = TRUE;
		} else {
			_data_->_tmp127_ = _data_->file;
			_data_->_tmp128_ = g_file_get_uri (_data_->_tmp127_);
			_data_->_tmp129_ = _data_->_tmp128_;
			_data_->_tmp130_ = _data_->uri;
			_data_->_tmp125_ = g_strcmp0 (_data_->_tmp129_, _data_->_tmp130_) != 0;
			_g_free0 (_data_->_tmp129_);
		}
		if (_data_->_tmp125_) {
			_data_->_tmp131_ = _data_->files;
			_data_->_state_ = 2;
			app_window_check_overwrite (_data_->self, (GtkWindow*) _data_->self, _data_->_tmp131_, app_window_choose_file_location_ready, _data_);
			return FALSE;
			_state_2:
			_data_->overwrite_check = app_window_check_overwrite_finish (_data_->self, _data_->_res_);
		}
		if (_data_->overwrite_check) {
			_data_->_tmp132_ = _data_->uri;
			_data_->_tmp133_ = _data_->uri;
			_data_->_tmp134_ = string_substring (_data_->_tmp132_, (glong) 0, (glong) (string_last_index_of (_data_->_tmp133_, "/", 0) + 1));
			_data_->directory_uri = _data_->_tmp134_;
			_data_->_tmp135_ = _data_->self->priv->settings;
			_data_->_tmp136_ = _data_->directory_uri;
			g_settings_set_string (_data_->_tmp135_, "save-directory", _data_->_tmp136_);
			_data_->result = _data_->uri;
			_g_free0 (_data_->directory_uri);
			(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
			_g_free0 (_data_->mime_type);
			_g_free0 (_data_->extension);
			_g_object_unref0 (_data_->file);
			_g_object_unref0 (_data_->box);
			_g_object_unref0 (_data_->all_filter);
			_g_object_unref0 (_data_->webp_filter);
			_g_object_unref0 (_data_->png_filter);
			_g_object_unref0 (_data_->jpeg_filter);
			_g_object_unref0 (_data_->pdf_filter);
			_g_object_unref0 (_data_->filters);
			_g_free0 (_data_->save_format);
			_g_object_unref0 (_data_->save_dialog);
			_g_free0 (_data_->directory);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
		_g_free0 (_data_->mime_type);
		_g_free0 (_data_->extension);
		_g_free0 (_data_->uri);
		_g_object_unref0 (_data_->file);
	}
}

static void
app_window_check_overwrite_data_free (gpointer _data)
{
	AppWindowCheckOverwriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->parent);
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowCheckOverwriteData, _data_);
}

static void
app_window_check_overwrite (AppWindow* self,
                            GtkWindow* parent,
                            GList* files,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	AppWindowCheckOverwriteData* _data_;
	AppWindow* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_data_ = g_slice_new0 (AppWindowCheckOverwriteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_check_overwrite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data_->parent);
	_data_->parent = _tmp1_;
	_data_->files = files;
	app_window_check_overwrite_co (_data_);
}

static gboolean
app_window_check_overwrite_finish (AppWindow* self,
                                   GAsyncResult* _res_)
{
	gboolean result;
	AppWindowCheckOverwriteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		AppWindow* self;
		self = _data2_->self;
		_g_free0 (_data2_->response);
		(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
		_data2_->callback = NULL;
		_data2_->callback_target = NULL;
		_data2_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
_app_window_check_overwrite_co_gsource_func (gpointer self)
{
	gboolean result;
	result = app_window_check_overwrite_co (self);
	return result;
}

static void
____lambda30_ (Block2Data* _data2_,
               const gchar* res)
{
	AppWindow* self;
	gchar* _tmp0_;
	GSourceFunc _tmp1_;
	gpointer _tmp1__target;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = g_strdup (res);
	_g_free0 (_data2_->response);
	_data2_->response = _tmp0_;
	_tmp1_ = _data2_->callback;
	_tmp1__target = _data2_->callback_target;
	_tmp1_ (_tmp1__target);
}

static void
_____lambda30__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                          const gchar* response,
                                          gpointer self)
{
	____lambda30_ (self, response);
}

static gboolean
app_window_check_overwrite_co (AppWindowCheckOverwriteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->file_collection = _data_->files;
		for (_data_->file_it = _data_->file_collection; _data_->file_it != NULL; _data_->file_it = _data_->file_it->next) {
			_data_->_tmp0_ = _g_object_ref0 ((GFile*) _data_->file_it->data);
			_data_->file = _data_->_tmp0_;
			{
				_data_->_data2_ = g_slice_new0 (Block2Data);
				_data_->_data2_->_ref_count_ = 1;
				_data_->_data2_->self = g_object_ref (_data_->self);
				_data_->_tmp1_ = _data_->file;
				if (!g_file_query_exists (_data_->_tmp1_, NULL)) {
					_g_object_unref0 (_data_->file);
					block2_data_unref (_data_->_data2_);
					_data_->_data2_ = NULL;
					continue;
				}
				_data_->_tmp2_ = _data_->file;
				_data_->_tmp3_ = g_file_get_basename (_data_->_tmp2_);
				_data_->_tmp4_ = _data_->_tmp3_;
				_data_->_tmp5_ = g_strdup_printf (_ ("A file named “%s” already exists.  Do you want to replace it?"), _data_->_tmp4_);
				_data_->_tmp6_ = _data_->_tmp5_;
				_g_free0 (_data_->_tmp4_);
				_data_->title = _data_->_tmp6_;
				_data_->_tmp7_ = _data_->title;
				_data_->_tmp8_ = (AdwAlertDialog*) adw_alert_dialog_new (_data_->_tmp7_, NULL);
				g_object_ref_sink (_data_->_tmp8_);
				_data_->dialog = _data_->_tmp8_;
				_data_->_tmp9_ = _data_->dialog;
				adw_alert_dialog_add_response (_data_->_tmp9_, "cancel", _ ("_Cancel"));
				_data_->_tmp10_ = _data_->dialog;
				adw_alert_dialog_add_response (_data_->_tmp10_, "replace", _ ("_Replace"));
				_data_->_tmp11_ = _data_->dialog;
				adw_alert_dialog_set_response_appearance (_data_->_tmp11_, "replace", ADW_RESPONSE_DESTRUCTIVE);
				_data_->_data2_->callback = _app_window_check_overwrite_co_gsource_func;
				_data_->_data2_->callback_target = _data_;
				_data_->_data2_->callback_target_destroy_notify = NULL;
				_data_->_tmp12_ = g_strdup ("cancel");
				_data_->_data2_->response = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->dialog;
				g_signal_connect_data (_data_->_tmp13_, "response", (GCallback) _____lambda30__adw_alert_dialog_response, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
				_data_->_tmp14_ = _data_->dialog;
				adw_dialog_present ((AdwDialog*) _data_->_tmp14_, (GtkWidget*) _data_->parent);
				_data_->_state_ = 1;
				return FALSE;
				_state_1:
				;
				_data_->_tmp15_ = _data_->_data2_->response;
				if (g_strcmp0 (_data_->_tmp15_, "replace") != 0) {
					_data_->result = FALSE;
					_g_object_unref0 (_data_->dialog);
					_g_free0 (_data_->title);
					_g_object_unref0 (_data_->file);
					block2_data_unref (_data_->_data2_);
					_data_->_data2_ = NULL;
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->dialog);
				_g_free0 (_data_->title);
				_g_object_unref0 (_data_->file);
				block2_data_unref (_data_->_data2_);
				_data_->_data2_ = NULL;
			}
		}
	}
	_data_->result = TRUE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
app_window_mime_type_to_extension (AppWindow* self,
                                   const gchar* mime_type)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	if (g_strcmp0 (mime_type, "application/pdf") == 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("pdf");
		result = _tmp0_;
		return result;
	} else {
		if (g_strcmp0 (mime_type, "image/jpeg") == 0) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("jpg");
			result = _tmp1_;
			return result;
		} else {
			if (g_strcmp0 (mime_type, "image/png") == 0) {
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("png");
				result = _tmp2_;
				return result;
			} else {
				if (g_strcmp0 (mime_type, "image/webp") == 0) {
					gchar* _tmp3_;
					_tmp3_ = g_strdup ("webp");
					result = _tmp3_;
					return result;
				} else {
					result = NULL;
					return result;
				}
			}
		}
	}
}

static gchar*
app_window_extension_to_mime_type (AppWindow* self,
                                   const gchar* extension)
{
	gchar* extension_lower = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = g_utf8_strdown (extension, (gssize) -1);
	extension_lower = _tmp0_;
	_tmp1_ = extension_lower;
	if (g_strcmp0 (_tmp1_, "pdf") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("application/pdf");
		result = _tmp2_;
		_g_free0 (extension_lower);
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		_tmp4_ = extension_lower;
		if (g_strcmp0 (_tmp4_, "jpg") == 0) {
			_tmp3_ = TRUE;
		} else {
			const gchar* _tmp5_;
			_tmp5_ = extension_lower;
			_tmp3_ = g_strcmp0 (_tmp5_, "jpeg") == 0;
		}
		if (_tmp3_) {
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("image/jpeg");
			result = _tmp6_;
			_g_free0 (extension_lower);
			return result;
		} else {
			const gchar* _tmp7_;
			_tmp7_ = extension_lower;
			if (g_strcmp0 (_tmp7_, "png") == 0) {
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("image/png");
				result = _tmp8_;
				_g_free0 (extension_lower);
				return result;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = extension_lower;
				if (g_strcmp0 (_tmp9_, "webp") == 0) {
					gchar* _tmp10_;
					_tmp10_ = g_strdup ("image/webp");
					result = _tmp10_;
					_g_free0 (extension_lower);
					return result;
				} else {
					result = NULL;
					_g_free0 (extension_lower);
					return result;
				}
			}
		}
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
app_window_uri_extension (AppWindow* self,
                          const gchar* uri)
{
	gint extension_index = 0;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	extension_index = string_last_index_of_char (uri, (gunichar) '.', 0);
	if (extension_index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = string_substring (uri, (glong) (extension_index + 1), (glong) -1);
	result = _tmp0_;
	return result;
}

static gchar*
app_window_uri_to_mime_type (AppWindow* self,
                             const gchar* uri)
{
	gchar* extension = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* mime_type = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = app_window_uri_extension (self, uri);
	extension = _tmp0_;
	_tmp1_ = extension;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("image/jpeg");
		result = _tmp2_;
		_g_free0 (extension);
		return result;
	}
	_tmp3_ = extension;
	_tmp4_ = app_window_extension_to_mime_type (self, _tmp3_);
	mime_type = _tmp4_;
	_tmp5_ = mime_type;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("image/jpeg");
		result = _tmp6_;
		_g_free0 (mime_type);
		_g_free0 (extension);
		return result;
	}
	result = mime_type;
	_g_free0 (extension);
	return result;
}

static void
app_window_save_document_async_data_free (gpointer _data)
{
	AppWindowSaveDocumentAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowSaveDocumentAsyncData, _data_);
}

static void
app_window_save_document_async (AppWindow* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	AppWindowSaveDocumentAsyncData* _data_;
	AppWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AppWindowSaveDocumentAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_save_document_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	app_window_save_document_async_co (_data_);
}

static gboolean
app_window_save_document_finish (AppWindow* self,
                                 GAsyncResult* _res_)
{
	gboolean result;
	AppWindowSaveDocumentAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		AppWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->progress_bar);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
app_window_save_document_async_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	AppWindowSaveDocumentAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	app_window_save_document_async_co (_data_);
}

static void
___lambda33_ (Block3Data* _data3_,
              gdouble fraction)
{
	AppWindow* self;
	CancellableProgressBar* _tmp0_;
	self = _data3_->self;
	_tmp0_ = _data3_->progress_bar;
	cancellable_progress_bar_set_fraction (_tmp0_, fraction);
}

static void
____lambda33__progression_callback (gdouble fraction,
                                    gpointer self)
{
	___lambda33_ (self, fraction);
}

static gboolean
app_window_save_document_async_co (AppWindowSaveDocumentAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_state_ = 1;
	app_window_choose_file_location (_data_->self, app_window_save_document_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = app_window_choose_file_location_finish (_data_->self, _data_->_res_);
	_data_->uri = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->uri;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = FALSE;
		_g_free0 (_data_->uri);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->uri;
	_data_->_tmp3_ = g_file_new_for_uri (_data_->_tmp2_);
	_data_->file = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->uri;
	g_debug ("app-window.vala:615: Saving to '%s'", _data_->_tmp4_);
	_data_->_tmp5_ = _data_->uri;
	_data_->_tmp6_ = app_window_uri_to_mime_type (_data_->self, _data_->_tmp5_);
	_data_->mime_type = _data_->_tmp6_;
	_data_->_tmp7_ = g_cancellable_new ();
	_data_->cancellable = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->cancellable;
	_data_->_tmp9_ = cancellable_progress_bar_new (_ ("Saving"), _data_->_tmp8_);
	g_object_ref_sink (_data_->_tmp9_);
	_data_->_data3_->progress_bar = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->self->priv->action_bar;
	_data_->_tmp11_ = _data_->_data3_->progress_bar;
	gtk_action_bar_pack_end (_data_->_tmp10_, (GtkWidget*) _data_->_tmp11_);
	_data_->_tmp12_ = _data_->_data3_->progress_bar;
	gtk_widget_set_visible ((GtkWidget*) _data_->_tmp12_, TRUE);
	_data_->_tmp13_ = _data_->self->priv->save_button;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp13_, FALSE);
	{
		_data_->_tmp14_ = _data_->self->priv->_book;
		_data_->_tmp15_ = _data_->mime_type;
		_data_->_tmp16_ = _data_->self->priv->settings;
		_data_->_tmp17_ = _data_->file;
		_data_->_tmp18_ = _data_->cancellable;
		_data_->_state_ = 2;
		book_save_async (_data_->_tmp14_, _data_->_tmp15_, g_settings_get_int (_data_->_tmp16_, "jpeg-quality"), _data_->_tmp17_, ____lambda33__progression_callback, _data_->_data3_, _data_->_tmp18_, app_window_save_document_async_ready, _data_);
		return FALSE;
		_state_2:
		book_save_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = _data_->self->priv->save_button;
		gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp19_, TRUE);
		_data_->_tmp20_ = _data_->_data3_->progress_bar;
		g_signal_emit_by_name ((GtkWidget*) _data_->_tmp20_, "destroy");
		_data_->_tmp21_ = _data_->e;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning ("app-window.vala:636: Error saving file: %s", _data_->_tmp22_);
		_data_->_tmp23_ = _data_->e;
		_data_->_tmp24_ = _data_->_tmp23_->message;
		app_window_show_error_dialog (_data_->self, _ ("Failed to save file"), _data_->_tmp24_);
		_data_->result = FALSE;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->cancellable);
		_g_free0 (_data_->mime_type);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->uri);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->cancellable);
		_g_free0 (_data_->mime_type);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->uri);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp25_ = _data_->self->priv->save_button;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp25_, TRUE);
	_data_->_tmp26_ = _data_->_data3_->progress_bar;
	_data_->_tmp27_ = _data_->self->priv->action_bar;
	cancellable_progress_bar_remove_with_delay (_data_->_tmp26_, (guint) 500, _data_->_tmp27_);
	{
		_data_->_tmp28_ = _data_->self->priv->_book;
		_data_->_tmp29_ = _data_->mime_type;
		_data_->_tmp30_ = _data_->file;
		_data_->_tmp31_ = _data_->self->priv->settings;
		_data_->_tmp32_ = _data_->self->priv->settings;
		_data_->_tmp33_ = g_settings_get_string (_data_->_tmp32_, "postproc-script");
		_data_->_tmp34_ = _data_->_tmp33_;
		_data_->_tmp35_ = _data_->self->priv->settings;
		_data_->_tmp36_ = g_settings_get_string (_data_->_tmp35_, "postproc-arguments");
		_data_->_tmp37_ = _data_->_tmp36_;
		_data_->_tmp38_ = _data_->self->priv->settings;
		_data_->_state_ = 3;
		book_postprocess_async (_data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, g_settings_get_boolean (_data_->_tmp31_, "postproc-enabled"), _data_->_tmp34_, _data_->_tmp37_, g_settings_get_boolean (_data_->_tmp38_, "postproc-keep-original"), app_window_save_document_async_ready, _data_);
		return FALSE;
		_state_3:
		book_postprocess_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp37_);
		_g_free0 (_data_->_tmp34_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp39_ = _data_->_vala1_e;
		_data_->_tmp40_ = _data_->_tmp39_->message;
		g_warning ("app-window.vala:653: Error running postprocessing: %s", _data_->_tmp40_);
		_data_->_tmp41_ = _data_->_vala1_e;
		_data_->_tmp42_ = _data_->_tmp41_->message;
		app_window_show_error_dialog (_data_->self, _ ("Failed to run postprocessing"), _data_->_tmp42_);
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->cancellable);
		_g_free0 (_data_->mime_type);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->uri);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->book_needs_saving = FALSE;
	_data_->_tmp43_ = _data_->uri;
	_data_->_tmp44_ = g_strdup (_data_->_tmp43_);
	_g_free0 (_data_->self->priv->book_uri);
	_data_->self->priv->book_uri = _data_->_tmp44_;
	_data_->result = TRUE;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->mime_type);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->uri);
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
app_window_prompt_to_save_async_data_free (gpointer _data)
{
	AppWindowPromptToSaveAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->title);
	_g_free0 (_data_->discard_label);
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowPromptToSaveAsyncData, _data_);
}

static void
app_window_prompt_to_save_async (AppWindow* self,
                                 const gchar* title,
                                 const gchar* discard_label,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AppWindowPromptToSaveAsyncData* _data_;
	AppWindow* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (discard_label != NULL);
	_data_ = g_slice_new0 (AppWindowPromptToSaveAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_prompt_to_save_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (title);
	_g_free0 (_data_->title);
	_data_->title = _tmp1_;
	_tmp2_ = g_strdup (discard_label);
	_g_free0 (_data_->discard_label);
	_data_->discard_label = _tmp2_;
	app_window_prompt_to_save_async_co (_data_);
}

static gboolean
app_window_prompt_to_save_finish (AppWindow* self,
                                  GAsyncResult* _res_)
{
	gboolean result;
	AppWindowPromptToSaveAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		AppWindow* self;
		self = _data4_->self;
		(_data4_->callback_target_destroy_notify == NULL) ? NULL : (_data4_->callback_target_destroy_notify (_data4_->callback_target), NULL);
		_data4_->callback = NULL;
		_data4_->callback_target = NULL;
		_data4_->callback_target_destroy_notify = NULL;
		_g_free0 (_data4_->response);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
_app_window_prompt_to_save_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = app_window_prompt_to_save_async_co (self);
	return result;
}

static void
__lambda29_ (Block4Data* _data4_,
             const gchar* res)
{
	AppWindow* self;
	gchar* _tmp0_;
	GSourceFunc _tmp1_;
	gpointer _tmp1__target;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = g_strdup (res);
	_g_free0 (_data4_->response);
	_data4_->response = _tmp0_;
	_tmp1_ = _data4_->callback;
	_tmp1__target = _data4_->callback_target;
	_tmp1_ (_tmp1__target);
}

static void
___lambda29__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda29_ (self, response);
}

static void
app_window_prompt_to_save_async_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AppWindowPromptToSaveAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	app_window_prompt_to_save_async_co (_data_);
}

static gboolean
app_window_prompt_to_save_async_co (AppWindowPromptToSaveAsyncData* _data_)
{
	static GQuark _tmp15_label0 = 0;
	static GQuark _tmp15_label1 = 0;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	if (!_data_->self->priv->book_needs_saving) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp1_ = _data_->self->priv->_book;
		_data_->_tmp2_ = book_get_n_pages (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp0_ = _data_->_tmp3_ == ((guint) 0);
	}
	if (_data_->_tmp0_) {
		_data_->result = TRUE;
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = (AdwAlertDialog*) adw_alert_dialog_new (_data_->title, _ ("If you don’t save, changes will be permanently lost."));
	g_object_ref_sink (_data_->_tmp4_);
	_data_->dialog = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->dialog;
	adw_alert_dialog_add_response (_data_->_tmp5_, "discard", _data_->discard_label);
	_data_->_tmp6_ = _data_->dialog;
	adw_alert_dialog_add_response (_data_->_tmp6_, "cancel", _ ("_Cancel"));
	_data_->_tmp7_ = _data_->dialog;
	adw_alert_dialog_add_response (_data_->_tmp7_, "save", _ ("_Save"));
	_data_->_tmp8_ = _data_->dialog;
	adw_alert_dialog_set_response_appearance (_data_->_tmp8_, "discard", ADW_RESPONSE_DESTRUCTIVE);
	_data_->_tmp9_ = _data_->dialog;
	adw_alert_dialog_set_response_appearance (_data_->_tmp9_, "save", ADW_RESPONSE_SUGGESTED);
	_data_->_tmp10_ = _data_->dialog;
	adw_dialog_present ((AdwDialog*) _data_->_tmp10_, (GtkWidget*) _data_->self);
	_data_->_tmp11_ = g_strdup ("cancel");
	_data_->_data4_->response = _data_->_tmp11_;
	_data_->_data4_->callback = _app_window_prompt_to_save_async_co_gsource_func;
	_data_->_data4_->callback_target = _data_;
	_data_->_data4_->callback_target_destroy_notify = NULL;
	_data_->_tmp12_ = _data_->dialog;
	g_signal_connect_data (_data_->_tmp12_, "response", (GCallback) ___lambda29__adw_alert_dialog_response, block4_data_ref (_data_->_data4_), (GClosureNotify) block4_data_unref, 0);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp13_ = _data_->_data4_->response;
	_data_->_tmp16_ = 0U;
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp16_ = (NULL == _data_->_tmp14_) ? 0 : g_quark_from_string (_data_->_tmp14_);
	if (_data_->_tmp16_ == ((0 != _tmp15_label0) ? _tmp15_label0 : (_tmp15_label0 = g_quark_from_static_string ("save")))) {
		switch (0) {
			default:
			{
				_data_->_state_ = 2;
				app_window_save_document_async (_data_->self, app_window_prompt_to_save_async_ready, _data_);
				return FALSE;
				_state_2:
				if (app_window_save_document_finish (_data_->self, _data_->_res_)) {
					_data_->result = TRUE;
					_g_object_unref0 (_data_->dialog);
					block4_data_unref (_data_->_data4_);
					_data_->_data4_ = NULL;
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					_data_->result = FALSE;
					_g_object_unref0 (_data_->dialog);
					block4_data_unref (_data_->_data4_);
					_data_->_data4_ = NULL;
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
	} else if (_data_->_tmp16_ == ((0 != _tmp15_label1) ? _tmp15_label1 : (_tmp15_label1 = g_quark_from_static_string ("discard")))) {
		switch (0) {
			default:
			{
				_data_->result = TRUE;
				_g_object_unref0 (_data_->dialog);
				block4_data_unref (_data_->_data4_);
				_data_->_data4_ = NULL;
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_data_->result = FALSE;
				_g_object_unref0 (_data_->dialog);
				block4_data_unref (_data_->_data4_);
				_data_->_data4_ = NULL;
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
}

static void
app_window_clear_document (AppWindow* self)
{
	Book* _tmp0_;
	GtkButton* _tmp1_;
	GSimpleAction* _tmp2_;
	GtkStack* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_book;
	book_clear (_tmp0_);
	self->priv->book_needs_saving = FALSE;
	_g_free0 (self->priv->book_uri);
	self->priv->book_uri = NULL;
	_tmp1_ = self->priv->save_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->copy_to_clipboard_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	app_window_update_scan_status (self);
	_tmp3_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp3_, "startup");
}

static void
__lambda34_ (AppWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	AutosaveManager* _tmp2_;
	g_return_if_fail (res != NULL);
	if (!app_window_prompt_to_save_finish (self, res)) {
		return;
	}
	_tmp0_ = app_window_get_scanning (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		g_signal_emit (self, app_window_signals[APP_WINDOW_STOP_SCAN_SIGNAL], 0);
	}
	app_window_clear_document (self);
	_tmp2_ = self->priv->autosave_manager;
	autosave_manager_cleanup (_tmp2_);
}

static void
___lambda34__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda34_ ((AppWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
app_window_new_document (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_prompt_to_save_async (self, _ ("Save current document?"), _ ("_Discard Changes"), ___lambda34__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda45_ (AppWindow* self)
{
}

static void
____lambda45__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda45_ ((AppWindow*) self);
	g_object_unref (self);
}

static gboolean
app_window_status_label_activate_link_cb (AppWindow* self,
                                          GtkLabel* label,
                                          const gchar* uri)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (label != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	if (g_strcmp0 (uri, "install-firmware") == 0) {
		DriversDialog* dialog = NULL;
		const gchar* _tmp0_;
		DriversDialog* _tmp1_;
		DriversDialog* _tmp2_;
		_tmp0_ = self->priv->missing_driver;
		_tmp1_ = drivers_dialog_new ((GtkWindow*) self, _tmp0_);
		g_object_ref_sink (_tmp1_);
		dialog = _tmp1_;
		_tmp2_ = dialog;
		drivers_dialog_open (_tmp2_, ____lambda45__gasync_ready_callback, g_object_ref (self));
		result = TRUE;
		_g_object_unref0 (dialog);
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
_app_window_status_label_activate_link_cb_gtk_label_activate_link (GtkLabel* _sender,
                                                                   const gchar* uri,
                                                                   gpointer self)
{
	gboolean result;
	result = app_window_status_label_activate_link_cb ((AppWindow*) self, _sender, uri);
	return result;
}

static void
app_window_new_document_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_new_document (self);
}

static void
_app_window_new_document_cb_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	app_window_new_document_cb ((AppWindow*) self);
}

static void
app_window_crop_toggle_cb (AppWindow* self,
                           GtkToggleButton* btn)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (btn != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		g_warning ("app-window.vala:761: Trying to set crop but no selected page");
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = gtk_toggle_button_get_active (btn);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		Page* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = page;
		_tmp8_ = page_get_has_crop (_tmp7_);
		_tmp9_ = _tmp8_;
		if (!_tmp9_) {
			app_window_set_crop (self, "custom");
		}
	} else {
		app_window_set_crop (self, NULL);
	}
	_g_object_unref0 (page);
}

static void
_app_window_crop_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                      gpointer self)
{
	app_window_crop_toggle_cb ((AppWindow*) self, _sender);
}

static void
app_window_redetect_button_clicked_cb (AppWindow* self,
                                       GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	self->priv->have_devices = FALSE;
	app_window_update_scan_status (self);
	g_signal_emit (self, app_window_signals[APP_WINDOW_REDETECT_SIGNAL], 0);
}

static void
_app_window_redetect_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	app_window_redetect_button_clicked_cb ((AppWindow*) self, _sender);
}

static void
app_window_scan (AppWindow* self,
                 ScanOptions* options)
{
	AdwStatusPage* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (options != NULL);
	_tmp0_ = self->priv->status_page;
	adw_status_page_set_title (_tmp0_, _ ("Contacting Scanner…"));
	_tmp1_ = self->priv->device_buttons_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->device_buttons_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	_tmp3_ = app_window_get_selected_device (self);
	_tmp4_ = _tmp3_;
	g_signal_emit (self, app_window_signals[APP_WINDOW_START_SCAN_SIGNAL], 0, _tmp4_, options);
	_g_free0 (_tmp4_);
}

static void
app_window_scan_type_action_cb (AppWindow* self,
                                GSimpleAction* action,
                                GVariant* value)
{
	gchar* type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (value, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	type = _tmp1_;
	_tmp2_ = type;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("single")))) {
		switch (0) {
			default:
			{
				app_window_set_scan_type (self, SCAN_TYPE_SINGLE);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("adf")))) {
		switch (0) {
			default:
			{
				app_window_set_scan_type (self, SCAN_TYPE_ADF);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("batch")))) {
		switch (0) {
			default:
			{
				app_window_set_scan_type (self, SCAN_TYPE_BATCH);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_g_free0 (type);
				return;
			}
		}
	}
	_g_free0 (type);
}

static void
app_window_document_hint_action_cb (AppWindow* self,
                                    GSimpleAction* action,
                                    GVariant* value)
{
	gchar* hint = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (value, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	hint = _tmp1_;
	app_window_set_document_hint (self, hint, TRUE);
	_g_free0 (hint);
}

static void
app_window_scan_single_cb (AppWindow* self)
{
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_make_scan_options (self);
	options = _tmp0_;
	options->type = SCAN_TYPE_SINGLE;
	app_window_scan (self, options);
	_g_object_unref0 (options);
}

static void
app_window_scan_adf_cb (AppWindow* self)
{
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_make_scan_options (self);
	options = _tmp0_;
	options->type = SCAN_TYPE_ADF;
	app_window_scan (self, options);
	_g_object_unref0 (options);
}

static void
app_window_scan_batch_cb (AppWindow* self)
{
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_make_scan_options (self);
	options = _tmp0_;
	options->type = SCAN_TYPE_BATCH;
	app_window_scan (self, options);
	_g_object_unref0 (options);
}

static void
app_window_scan_stop_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, app_window_signals[APP_WINDOW_STOP_SCAN_SIGNAL], 0);
}

static void
app_window_rotate_left_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ != NULL) {
		Page* _tmp5_;
		_tmp5_ = page;
		page_rotate_left (_tmp5_);
	}
	_g_object_unref0 (page);
}

static void
app_window_rotate_right_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ != NULL) {
		Page* _tmp5_;
		_tmp5_ = page;
		page_rotate_right (_tmp5_);
	}
	_g_object_unref0 (page);
}

static void
app_window_move_left_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	guint index = 0U;
	Book* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = self->priv->_book;
	_tmp5_ = page;
	index = book_get_page_index (_tmp4_, _tmp5_);
	if (index > ((guint) 0)) {
		Book* _tmp6_;
		Page* _tmp7_;
		_tmp6_ = self->priv->_book;
		_tmp7_ = page;
		book_move_page (_tmp6_, _tmp7_, index - 1);
	}
	_g_object_unref0 (page);
}

static void
app_window_move_right_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	guint index = 0U;
	Book* _tmp4_;
	Page* _tmp5_;
	Book* _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = self->priv->_book;
	_tmp5_ = page;
	index = book_get_page_index (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->_book;
	_tmp7_ = book_get_n_pages (_tmp6_);
	_tmp8_ = _tmp7_;
	if (index < (_tmp8_ - 1)) {
		Book* _tmp9_;
		Page* _tmp10_;
		Book* _tmp11_;
		Page* _tmp12_;
		_tmp9_ = self->priv->_book;
		_tmp10_ = page;
		_tmp11_ = self->priv->_book;
		_tmp12_ = page;
		book_move_page (_tmp9_, _tmp10_, book_get_page_index (_tmp11_, _tmp12_) + 1);
	}
	_g_object_unref0 (page);
}

static void
app_window_copy_page_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ != NULL) {
		Page* _tmp5_;
		_tmp5_ = page;
		page_copy_to_clipboard (_tmp5_, (GtkWindow*) self);
	}
	_g_object_unref0 (page);
}

static void
app_window_delete_page_cb (AppWindow* self)
{
	BookView* _tmp0_;
	Book* _tmp1_;
	Book* _tmp2_;
	BookView* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_book (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->book_view;
	_tmp4_ = book_view_get_selected_page (_tmp3_);
	_tmp5_ = _tmp4_;
	book_delete_page (_tmp2_, _tmp5_);
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new2 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new3 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
app_window_set_scan_type (AppWindow* self,
                          ScanType scan_type)
{
	g_return_if_fail (self != NULL);
	self->priv->scan_type = scan_type;
	switch (scan_type) {
		case SCAN_TYPE_SINGLE:
		{
			GSimpleAction* _tmp0_;
			GVariant* _tmp1_;
			AdwButtonContent* _tmp2_;
			GtkButton* _tmp3_;
			_tmp0_ = self->priv->scan_type_action;
			_tmp1_ = _variant_new1 ("single");
			g_simple_action_set_state (_tmp0_, _tmp1_);
			_g_variant_unref0 (_tmp1_);
			_tmp2_ = self->priv->scan_button_content;
			adw_button_content_set_icon_name (_tmp2_, "scanner-symbolic");
			_tmp3_ = self->priv->scan_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, _ ("Scan a Single Page"));
			break;
		}
		case SCAN_TYPE_ADF:
		{
			GSimpleAction* _tmp4_;
			GVariant* _tmp5_;
			AdwButtonContent* _tmp6_;
			GtkButton* _tmp7_;
			_tmp4_ = self->priv->scan_type_action;
			_tmp5_ = _variant_new2 ("adf");
			g_simple_action_set_state (_tmp4_, _tmp5_);
			_g_variant_unref0 (_tmp5_);
			_tmp6_ = self->priv->scan_button_content;
			adw_button_content_set_icon_name (_tmp6_, "scan-type-adf-symbolic");
			_tmp7_ = self->priv->scan_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _ ("Scan Multiple Pages"));
			break;
		}
		case SCAN_TYPE_BATCH:
		{
			GSimpleAction* _tmp8_;
			GVariant* _tmp9_;
			AdwButtonContent* _tmp10_;
			GtkButton* _tmp11_;
			_tmp8_ = self->priv->scan_type_action;
			_tmp9_ = _variant_new3 ("batch");
			g_simple_action_set_state (_tmp8_, _tmp9_);
			_g_variant_unref0 (_tmp9_);
			_tmp10_ = self->priv->scan_button_content;
			adw_button_content_set_icon_name (_tmp10_, "scan-type-batch-symbolic");
			_tmp11_ = self->priv->scan_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp11_, _ ("Scan Multiple Pages"));
			break;
		}
		default:
		break;
	}
}

static GVariant*
_variant_new4 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
app_window_set_document_hint (AppWindow* self,
                              const gchar* document_hint,
                              gboolean save)
{
	gchar* _tmp0_;
	GSimpleAction* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (document_hint != NULL);
	_tmp0_ = g_strdup (document_hint);
	_g_free0 (self->priv->document_hint);
	self->priv->document_hint = _tmp0_;
	_tmp1_ = self->priv->document_hint_action;
	_tmp2_ = _variant_new4 (document_hint);
	g_simple_action_set_state (_tmp1_, _tmp2_);
	_g_variant_unref0 (_tmp2_);
	if (save) {
		GSettings* _tmp3_;
		_tmp3_ = self->priv->settings;
		g_settings_set_string (_tmp3_, "document-type", document_hint);
	}
}

static ScanOptions*
app_window_make_scan_options (AppWindow* self)
{
	ScanOptions* options = NULL;
	ScanOptions* _tmp0_;
	const gchar* _tmp1_;
	PreferencesDialog* _tmp10_;
	ScanOptions* _tmp11_;
	ScanOptions* _tmp12_;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	ScanOptions* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	ScanOptions* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	ScanOptions* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	ScanOptions* _tmp24_;
	PreferencesDialog* _tmp25_;
	ScanOptions* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = scan_options_new ();
	options = _tmp0_;
	_tmp1_ = self->priv->document_hint;
	if (g_strcmp0 (_tmp1_, "text") == 0) {
		ScanOptions* _tmp2_;
		ScanOptions* _tmp3_;
		PreferencesDialog* _tmp4_;
		ScanOptions* _tmp5_;
		_tmp2_ = options;
		_tmp2_->scan_mode = SCAN_MODE_GRAY;
		_tmp3_ = options;
		_tmp4_ = self->priv->preferences_dialog;
		_tmp3_->dpi = preferences_dialog_get_text_dpi (_tmp4_);
		_tmp5_ = options;
		_tmp5_->depth = 2;
	} else {
		ScanOptions* _tmp6_;
		ScanOptions* _tmp7_;
		PreferencesDialog* _tmp8_;
		ScanOptions* _tmp9_;
		_tmp6_ = options;
		_tmp6_->scan_mode = SCAN_MODE_COLOR;
		_tmp7_ = options;
		_tmp8_ = self->priv->preferences_dialog;
		_tmp7_->dpi = preferences_dialog_get_photo_dpi (_tmp8_);
		_tmp9_ = options;
		_tmp9_->depth = 8;
	}
	_tmp10_ = self->priv->preferences_dialog;
	_tmp11_ = options;
	_tmp12_ = options;
	preferences_dialog_get_paper_size (_tmp10_, &_tmp13_, &_tmp14_);
	_tmp11_->paper_width = _tmp13_;
	_tmp12_->paper_height = _tmp14_;
	_tmp15_ = options;
	_tmp16_ = app_window_get_brightness (self);
	_tmp17_ = _tmp16_;
	_tmp15_->brightness = _tmp17_;
	_tmp18_ = options;
	_tmp19_ = app_window_get_contrast (self);
	_tmp20_ = _tmp19_;
	_tmp18_->contrast = _tmp20_;
	_tmp21_ = options;
	_tmp22_ = app_window_get_page_delay (self);
	_tmp23_ = _tmp22_;
	_tmp21_->page_delay = _tmp23_;
	_tmp24_ = options;
	_tmp25_ = self->priv->preferences_dialog;
	_tmp24_->side = preferences_dialog_get_page_side (_tmp25_);
	result = options;
	return result;
}

static void
app_window_device_drop_down_changed_cb (AppWindow* self,
                                        GObject* widget,
                                        GParamSpec* spec)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (spec != NULL);
	if (self->priv->setting_devices) {
		return;
	}
	self->priv->user_selected_device = TRUE;
	_tmp0_ = app_window_get_selected_device (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		GSettings* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->settings;
		_tmp4_ = app_window_get_selected_device (self);
		_tmp5_ = _tmp4_;
		g_settings_set_string (_tmp3_, "selected-device", _tmp5_);
		_g_free0 (_tmp5_);
	}
}

static void
_app_window_device_drop_down_changed_cb_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	app_window_device_drop_down_changed_cb ((AppWindow*) self, _sender, pspec);
}

static void
app_window_scan_button_clicked_cb (AppWindow* self,
                                   GtkWidget* widget)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	ScanOptions* options = NULL;
	ScanOptions* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scan_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->stop_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = app_window_make_scan_options (self);
	options = _tmp2_;
	options->type = self->priv->scan_type;
	app_window_scan (self, options);
	_g_object_unref0 (options);
}

static void
_app_window_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
	app_window_scan_button_clicked_cb ((AppWindow*) self, _sender);
}

static void
app_window_stop_scan_button_clicked_cb (AppWindow* self,
                                        GtkWidget* widget)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->scan_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->stop_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	g_signal_emit (self, app_window_signals[APP_WINDOW_STOP_SCAN_SIGNAL], 0);
}

static void
_app_window_stop_scan_button_clicked_cb_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	app_window_stop_scan_button_clicked_cb ((AppWindow*) self, _sender);
}

static void
app_window_preferences_cb (AppWindow* self)
{
	PreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	adw_dialog_present ((AdwDialog*) _tmp0_, (GtkWidget*) self);
}

static void
app_window_update_page_menu (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		GSimpleAction* _tmp5_;
		GSimpleAction* _tmp6_;
		_tmp5_ = self->priv->page_move_left_action;
		g_simple_action_set_enabled (_tmp5_, FALSE);
		_tmp6_ = self->priv->page_move_right_action;
		g_simple_action_set_enabled (_tmp6_, FALSE);
	} else {
		guint index = 0U;
		Book* _tmp7_;
		Page* _tmp8_;
		GSimpleAction* _tmp9_;
		GSimpleAction* _tmp10_;
		Book* _tmp11_;
		guint _tmp12_;
		guint _tmp13_;
		_tmp7_ = self->priv->_book;
		_tmp8_ = page;
		index = book_get_page_index (_tmp7_, _tmp8_);
		_tmp9_ = self->priv->page_move_left_action;
		g_simple_action_set_enabled (_tmp9_, index > ((guint) 0));
		_tmp10_ = self->priv->page_move_right_action;
		_tmp11_ = self->priv->_book;
		_tmp12_ = book_get_n_pages (_tmp11_);
		_tmp13_ = _tmp12_;
		g_simple_action_set_enabled (_tmp10_, index < (_tmp13_ - 1));
	}
	_g_object_unref0 (page);
}

static void
app_window_page_selected_cb (AppWindow* self,
                             BookView* view,
                             Page* page)
{
	CropActions* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkToggleButton* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	if (page == NULL) {
		return;
	}
	self->priv->updating_page_menu = TRUE;
	app_window_update_page_menu (self);
	_tmp0_ = self->priv->crop_actions;
	_tmp1_ = page_get_crop_name (page);
	_tmp2_ = _tmp1_;
	crop_actions_update_current_crop (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->crop_button;
	_tmp4_ = page_get_has_crop (page);
	_tmp5_ = _tmp4_;
	gtk_toggle_button_set_active (_tmp3_, _tmp5_);
	self->priv->updating_page_menu = FALSE;
}

static void
app_window_show_page_cb (AppWindow* self,
                         BookView* view,
                         Page* page)
{
	GFile* file = NULL;
	GtkFileLauncher* launcher = NULL;
	GFile* _tmp8_;
	GtkFileLauncher* _tmp9_;
	GtkFileLauncher* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (page != NULL);
	{
		gchar* dir = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp0_ = g_dir_make_tmp ("simple-scan-XXXXXX", &_inner_error0_);
		dir = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = dir;
		_tmp2_ = g_build_filename (_tmp1_, "scan.png", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_g_object_unref0 (file);
		file = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp5_ = file;
		page_save_png (page, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (dir);
			goto __catch0_g_error;
		}
		_g_free0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		app_window_show_error_dialog (self, _ ("Unable to save image for preview"), _tmp7_);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp8_ = file;
	_tmp9_ = gtk_file_launcher_new (_tmp8_);
	launcher = _tmp9_;
	_tmp10_ = launcher;
	gtk_file_launcher_launch (_tmp10_, (GtkWindow*) self, NULL, NULL, NULL);
	_g_object_unref0 (launcher);
	_g_object_unref0 (file);
}

static void
app_window_show_page_menu_cb (AppWindow* self,
                              BookView* view,
                              GtkWidget* from,
                              gdouble x,
                              gdouble y)
{
	gdouble tx = 0.0;
	gdouble ty = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	GdkRectangle rect = {0};
	GdkRectangle _tmp2_ = {0};
	GtkPopoverMenu* _tmp3_;
	GdkRectangle _tmp4_;
	GtkPopoverMenu* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (from != NULL);
	gtk_widget_translate_coordinates (from, (GtkWidget*) self, x, y, &_tmp0_, &_tmp1_);
	tx = _tmp0_;
	ty = _tmp1_;
	_tmp2_.x = (gint) tx;
	_tmp2_.y = (gint) ty;
	_tmp2_.width = 1;
	_tmp2_.height = 1;
	rect = _tmp2_;
	_tmp3_ = self->priv->page_menu;
	_tmp4_ = rect;
	gtk_popover_set_pointing_to ((GtkPopover*) _tmp3_, &_tmp4_);
	_tmp5_ = self->priv->page_menu;
	gtk_popover_popup ((GtkPopover*) _tmp5_);
}

static void
app_window_set_crop (AppWindow* self,
                     const gchar* crop_name)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	CropActions* _tmp15_;
	GtkToggleButton* _tmp16_;
	Page* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	if (self->priv->updating_page_menu) {
		return;
	}
	if (g_strcmp0 (crop_name, "none") == 0) {
		crop_name = NULL;
	}
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		g_warning ("app-window.vala:1056: Trying to set crop but no selected page");
		_g_object_unref0 (page);
		return;
	}
	if (crop_name == NULL) {
		Page* _tmp5_;
		_tmp5_ = page;
		page_set_no_crop (_tmp5_);
	} else {
		if (g_strcmp0 (crop_name, "custom") == 0) {
			gint width = 0;
			Page* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint height = 0;
			Page* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint crop_width = 0;
			gint crop_height = 0;
			Page* _tmp12_;
			Page* _tmp13_;
			_tmp6_ = page;
			_tmp7_ = page_get_width (_tmp6_);
			_tmp8_ = _tmp7_;
			width = _tmp8_;
			_tmp9_ = page;
			_tmp10_ = page_get_height (_tmp9_);
			_tmp11_ = _tmp10_;
			height = _tmp11_;
			crop_width = (gint) ((width * 0.8) + 0.5);
			crop_height = (gint) ((height * 0.8) + 0.5);
			_tmp12_ = page;
			page_set_custom_crop (_tmp12_, crop_width, crop_height);
			_tmp13_ = page;
			page_move_crop (_tmp13_, (width - crop_width) / 2, (height - crop_height) / 2);
		} else {
			Page* _tmp14_;
			_tmp14_ = page;
			page_set_named_crop (_tmp14_, crop_name);
		}
	}
	_tmp15_ = self->priv->crop_actions;
	crop_actions_update_current_crop (_tmp15_, crop_name);
	_tmp16_ = self->priv->crop_button;
	_tmp17_ = page;
	_tmp18_ = page_get_has_crop (_tmp17_);
	_tmp19_ = _tmp18_;
	gtk_toggle_button_set_active (_tmp16_, _tmp19_);
	_g_object_unref0 (page);
}

void
app_window_crop_set_action_cb (AppWindow* self,
                               GSimpleAction* action,
                               GVariant* value)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (value, NULL);
	app_window_set_crop (self, _tmp0_);
}

void
app_window_crop_rotate_action_cb (AppWindow* self)
{
	Page* page = NULL;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	page = _tmp3_;
	_tmp4_ = page;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (page);
		return;
	}
	_tmp5_ = page;
	page_rotate_crop (_tmp5_);
	_g_object_unref0 (page);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		AppWindow* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda35_ (Block5Data* _data5_)
{
	AppWindow* self;
	Book* _tmp0_;
	self = _data5_->self;
	_tmp0_ = self->priv->_book;
	book_combine_sides (_tmp0_);
	gtk_window_close ((GtkWindow*) _data5_->dialog);
}

static void
___lambda35__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda35_ (self);
}

static void
__lambda36_ (Block5Data* _data5_)
{
	AppWindow* self;
	Book* _tmp0_;
	self = _data5_->self;
	_tmp0_ = self->priv->_book;
	book_combine_sides_reverse (_tmp0_);
	gtk_window_close ((GtkWindow*) _data5_->dialog);
}

static void
___lambda36__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda36_ (self);
}

static void
__lambda37_ (Block5Data* _data5_)
{
	AppWindow* self;
	Book* _tmp0_;
	self = _data5_->self;
	_tmp0_ = self->priv->_book;
	book_reverse (_tmp0_);
	gtk_window_close ((GtkWindow*) _data5_->dialog);
}

static void
___lambda37__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda37_ (self);
}

static void
__lambda38_ (Block5Data* _data5_)
{
	AppWindow* self;
	Book* _tmp0_;
	self = _data5_->self;
	_tmp0_ = self->priv->_book;
	book_flip_every_second (_tmp0_, FLIP_EVERY_SECOND_Odd);
	gtk_window_close ((GtkWindow*) _data5_->dialog);
}

static void
___lambda38__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda38_ (self);
}

static void
__lambda39_ (Block5Data* _data5_)
{
	AppWindow* self;
	Book* _tmp0_;
	self = _data5_->self;
	gtk_window_close ((GtkWindow*) _data5_->dialog);
	_tmp0_ = self->priv->_book;
	book_flip_every_second (_tmp0_, FLIP_EVERY_SECOND_Even);
}

static void
___lambda39__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda39_ (self);
}

static void
app_window_reorder_document_cb (AppWindow* self)
{
	Block5Data* _data5_;
	ReorderPagesDialog* _tmp0_;
	ReorderPagesItem* _tmp1_;
	ReorderPagesItem* _tmp2_;
	ReorderPagesItem* _tmp3_;
	ReorderPagesItem* _tmp4_;
	ReorderPagesItem* _tmp5_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = reorder_pages_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_data5_->dialog = _tmp0_;
	gtk_window_set_transient_for ((GtkWindow*) _data5_->dialog, (GtkWindow*) self);
	_tmp1_ = _data5_->dialog->combine_sides;
	g_signal_connect_data ((GtkButton*) _tmp1_, "clicked", (GCallback) ___lambda35__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp2_ = _data5_->dialog->combine_sides_rev;
	g_signal_connect_data ((GtkButton*) _tmp2_, "clicked", (GCallback) ___lambda36__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp3_ = _data5_->dialog->reverse;
	g_signal_connect_data ((GtkButton*) _tmp3_, "clicked", (GCallback) ___lambda37__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp4_ = _data5_->dialog->flip_odd;
	g_signal_connect_data ((GtkButton*) _tmp4_, "clicked", (GCallback) ___lambda38__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp5_ = _data5_->dialog->flip_even;
	g_signal_connect_data ((GtkButton*) _tmp5_, "clicked", (GCallback) ___lambda39__gtk_button_clicked, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data5_->dialog);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

void
app_window_save_document_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_save_document_async (self, NULL, NULL);
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static void
app_window_draw_page (AppWindow* self,
                      GtkPrintOperation* operation,
                      GtkPrintContext* print_context,
                      gint page_number)
{
	cairo_t* context = NULL;
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	Page* page = NULL;
	Book* _tmp2_;
	Page* _tmp3_;
	gboolean is_landscape = FALSE;
	Page* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	cairo_t* _tmp9_;
	Page* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	Page* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GdkPixbuf* image = NULL;
	Page* _tmp16_;
	GdkPixbuf* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (print_context != NULL);
	_tmp0_ = gtk_print_context_get_cairo_context (print_context);
	_tmp1_ = _cairo_reference0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = self->priv->_book;
	_tmp3_ = book_get_page (_tmp2_, page_number);
	page = _tmp3_;
	is_landscape = FALSE;
	if (gtk_print_context_get_width (print_context) > gtk_print_context_get_height (print_context)) {
		is_landscape = TRUE;
	}
	_tmp4_ = page;
	_tmp5_ = page_get_is_landscape (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != is_landscape) {
		cairo_t* _tmp7_;
		cairo_t* _tmp8_;
		_tmp7_ = context;
		cairo_translate (_tmp7_, gtk_print_context_get_width (print_context), (gdouble) 0);
		_tmp8_ = context;
		cairo_rotate (_tmp8_, G_PI_2);
	}
	_tmp9_ = context;
	_tmp10_ = page;
	_tmp11_ = page_get_dpi (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = page;
	_tmp14_ = page_get_dpi (_tmp13_);
	_tmp15_ = _tmp14_;
	cairo_scale (_tmp9_, gtk_print_context_get_dpi_x (print_context) / _tmp12_, gtk_print_context_get_dpi_y (print_context) / _tmp15_);
	_tmp16_ = page;
	_tmp17_ = page_get_image (_tmp16_, TRUE);
	image = _tmp17_;
	_tmp18_ = context;
	gdk_cairo_set_source_pixbuf (_tmp18_, image, (gdouble) 0, (gdouble) 0);
	_tmp19_ = context;
	cairo_paint (_tmp19_);
	_g_object_unref0 (image);
	_g_object_unref0 (page);
	_cairo_destroy0 (context);
}

static void
app_window_email_document_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_email_document_async (self, NULL, NULL);
}

static void
app_window_email_document_async_data_free (gpointer _data)
{
	AppWindowEmailDocumentAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AppWindowEmailDocumentAsyncData, _data_);
}

static void
app_window_email_document_async (AppWindow* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AppWindowEmailDocumentAsyncData* _data_;
	AppWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AppWindowEmailDocumentAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, app_window_email_document_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	app_window_email_document_async_co (_data_);
}

static void
app_window_email_document_finish (AppWindow* self,
                                  GAsyncResult* _res_)
{
	AppWindowEmailDocumentAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
app_window_email_document_async_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AppWindowEmailDocumentAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	app_window_email_document_async_co (_data_);
}

static gboolean
app_window_email_document_async_co (AppWindowEmailDocumentAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = g_dir_make_tmp ("simple-scan-XXXXXX", &_data_->_inner_error0_);
		_data_->dir = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->self->priv->document_hint;
		if (g_strcmp0 (_data_->_tmp1_, "text") == 0) {
			_data_->_tmp2_ = g_strdup ("application/pdf");
			_g_free0 (_data_->mime_type);
			_data_->mime_type = _data_->_tmp2_;
			_data_->_tmp3_ = g_strdup ("scan.pdf");
			_g_free0 (_data_->filename);
			_data_->filename = _data_->_tmp3_;
		} else {
			_data_->_tmp4_ = g_strdup ("image/jpeg");
			_g_free0 (_data_->mime_type);
			_data_->mime_type = _data_->_tmp4_;
			_data_->_tmp5_ = g_strdup ("scan.jpg");
			_g_free0 (_data_->filename);
			_data_->filename = _data_->_tmp5_;
		}
		_data_->_tmp6_ = _data_->dir;
		_data_->_tmp7_ = _data_->filename;
		_data_->_tmp8_ = g_build_filename (_data_->_tmp6_, _data_->_tmp7_, NULL);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_file_new_for_path (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_free0 (_data_->_tmp9_);
		_data_->file = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->self->priv->_book;
		_data_->_tmp13_ = _data_->mime_type;
		_data_->_tmp14_ = _data_->self->priv->settings;
		_data_->_tmp15_ = _data_->file;
		_data_->_state_ = 1;
		book_save_async (_data_->_tmp12_, _data_->_tmp13_, g_settings_get_int (_data_->_tmp14_, "jpeg-quality"), _data_->_tmp15_, NULL, NULL, NULL, app_window_email_document_async_ready, _data_);
		return FALSE;
		_state_1:
		book_save_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			_g_free0 (_data_->mime_type);
			_g_free0 (_data_->dir);
			goto __catch0_g_error;
		}
		_data_->_tmp16_ = _data_->self->priv->_book;
		_data_->_tmp17_ = _data_->mime_type;
		_data_->_tmp18_ = _data_->file;
		_data_->_tmp19_ = _data_->self->priv->settings;
		_data_->_tmp20_ = _data_->self->priv->settings;
		_data_->_tmp21_ = g_settings_get_string (_data_->_tmp20_, "postproc-script");
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = _data_->self->priv->settings;
		_data_->_tmp24_ = g_settings_get_string (_data_->_tmp23_, "postproc-arguments");
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _data_->self->priv->settings;
		_data_->_state_ = 2;
		book_postprocess_async (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_, g_settings_get_boolean (_data_->_tmp19_, "postproc-enabled"), _data_->_tmp22_, _data_->_tmp25_, g_settings_get_boolean (_data_->_tmp26_, "postproc-keep-original"), app_window_email_document_async_ready, _data_);
		return FALSE;
		_state_2:
		book_postprocess_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp25_);
		_g_free0 (_data_->_tmp22_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			_g_free0 (_data_->mime_type);
			_g_free0 (_data_->dir);
			goto __catch0_g_error;
		}
		_data_->_tmp27_ = g_strdup ("xdg-email");
		_data_->command_line = _data_->_tmp27_;
		_data_->_tmp28_ = _data_->mime_type;
		if (g_strcmp0 (_data_->_tmp28_, "application/pdf") == 0) {
			_data_->_tmp29_ = _data_->command_line;
			_data_->_tmp30_ = _data_->file;
			_data_->_tmp31_ = g_file_get_path (_data_->_tmp30_);
			_data_->_tmp32_ = _data_->_tmp31_;
			_data_->_tmp33_ = g_strdup_printf (" --attach %s", _data_->_tmp32_);
			_data_->_tmp34_ = _data_->_tmp33_;
			_data_->_tmp35_ = g_strconcat (_data_->_tmp29_, _data_->_tmp34_, NULL);
			_g_free0 (_data_->command_line);
			_data_->command_line = _data_->_tmp35_;
			_g_free0 (_data_->_tmp34_);
			_g_free0 (_data_->_tmp32_);
		} else {
			{
				_data_->i = 0;
				{
					_data_->_tmp36_ = TRUE;
					while (TRUE) {
						if (!_data_->_tmp36_) {
							_data_->_tmp37_ = _data_->i;
							_data_->i = _data_->_tmp37_ + 1;
						}
						_data_->_tmp36_ = FALSE;
						_data_->_tmp38_ = _data_->self->priv->_book;
						_data_->_tmp39_ = book_get_n_pages (_data_->_tmp38_);
						_data_->_tmp40_ = _data_->_tmp39_;
						if (!(((guint) _data_->i) < _data_->_tmp40_)) {
							break;
						}
						_data_->_tmp41_ = _data_->file;
						_data_->_tmp42_ = g_file_get_uri (_data_->_tmp41_);
						_data_->_tmp43_ = _data_->_tmp42_;
						_data_->_tmp44_ = _data_->self->priv->_book;
						_data_->_tmp45_ = book_get_n_pages (_data_->_tmp44_);
						_data_->_tmp46_ = _data_->_tmp45_;
						_data_->_tmp47_ = make_indexed_file (_data_->_tmp43_, (guint) _data_->i, _data_->_tmp46_);
						_data_->_tmp48_ = _data_->_tmp47_;
						_g_free0 (_data_->_tmp43_);
						_data_->indexed_file = _data_->_tmp48_;
						_data_->_tmp49_ = _data_->command_line;
						_data_->_tmp50_ = _data_->indexed_file;
						_data_->_tmp51_ = g_file_get_path (_data_->_tmp50_);
						_data_->_tmp52_ = _data_->_tmp51_;
						_data_->_tmp53_ = g_strdup_printf (" --attach %s", _data_->_tmp52_);
						_data_->_tmp54_ = _data_->_tmp53_;
						_data_->_tmp55_ = g_strconcat (_data_->_tmp49_, _data_->_tmp54_, NULL);
						_g_free0 (_data_->command_line);
						_data_->command_line = _data_->_tmp55_;
						_g_free0 (_data_->_tmp54_);
						_g_free0 (_data_->_tmp52_);
						_g_object_unref0 (_data_->indexed_file);
					}
				}
			}
		}
		_data_->_tmp56_ = _data_->command_line;
		g_spawn_command_line_async (_data_->_tmp56_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->command_line);
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
			_g_free0 (_data_->mime_type);
			_g_free0 (_data_->dir);
			goto __catch0_g_error;
		}
		_g_free0 (_data_->command_line);
		_g_object_unref0 (_data_->file);
		_g_free0 (_data_->filename);
		_g_free0 (_data_->mime_type);
		_g_free0 (_data_->dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp57_ = _data_->e;
		_data_->_tmp58_ = _data_->_tmp57_->message;
		g_warning ("app-window.vala:1205: Unable to email document: %s", _data_->_tmp58_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_app_window_draw_page_gtk_print_operation_draw_page (GtkPrintOperation* _sender,
                                                     GtkPrintContext* context,
                                                     gint page_nr,
                                                     gpointer self)
{
	app_window_draw_page ((AppWindow*) self, _sender, context, page_nr);
}

static void
app_window_print_document (AppWindow* self)
{
	GtkPrintOperation* print = NULL;
	GtkPrintOperation* _tmp0_;
	Book* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_print_operation_new ();
	print = _tmp0_;
	_tmp1_ = self->priv->_book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (print, "n-pages", (gint) _tmp3_, NULL);
	g_signal_connect_object (print, "draw-page", (GCallback) _app_window_draw_page_gtk_print_operation_draw_page, self, 0);
	{
		gtk_print_operation_run (print, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, (GtkWindow*) self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("app-window.vala:1221: Error printing: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (print);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_parse_name ("draw-page", gtk_print_operation_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (print, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _app_window_draw_page_gtk_print_operation_draw_page, self);
	_g_object_unref0 (print);
}

static void
app_window_print_document_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_print_document (self);
}

static void
app_window_launch_help (AppWindow* self)
{
	GtkUriLauncher* launcher = NULL;
	GtkUriLauncher* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_uri_launcher_new ("help:simple-scan");
	launcher = _tmp0_;
	gtk_uri_launcher_launch (launcher, (GtkWindow*) self, NULL, NULL, NULL);
	_g_object_unref0 (launcher);
}

static void
app_window_help_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_launch_help (self);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
app_window_show_about (AppWindow* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint authors_length1;
	gint _authors_size_;
	AdwAboutDialog* about = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	AdwAboutDialog* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Robert Ancell <robert.ancell@canonical.com>");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	authors = _tmp1_;
	authors_length1 = 1;
	_authors_size_ = authors_length1;
	_tmp2_ = (authors != NULL) ? _vala_array_dup1 (authors, authors_length1) : authors;
	_tmp2__length1 = authors_length1;
	_tmp3_ = g_strdup (_ ("translator-credits"));
	_tmp4_ = g_strdup ("Copyright © 2009-2018 Canonical Ltd.");
	_tmp5_ = g_strdup (_ ("Document Scanner"));
	_tmp6_ = g_strdup ("org.gnome.SimpleScan");
	_tmp7_ = g_strdup (VERSION);
	_tmp8_ = g_strdup ("https://gitlab.gnome.org/GNOME/simple-scan");
	_tmp9_ = g_strdup ("https://gitlab.gnome.org/GNOME/simple-scan/-/issues/");
	_tmp10_ = (AdwAboutDialog*) adw_about_dialog_new ();
	adw_about_dialog_set_developers (_tmp10_, _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	adw_about_dialog_set_translator_credits (_tmp10_, _tmp3_);
	_g_free0 (_tmp3_);
	adw_about_dialog_set_copyright (_tmp10_, _tmp4_);
	_g_free0 (_tmp4_);
	adw_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_3_0);
	adw_about_dialog_set_application_name (_tmp10_, _tmp5_);
	_g_free0 (_tmp5_);
	adw_about_dialog_set_application_icon (_tmp10_, _tmp6_);
	_g_free0 (_tmp6_);
	adw_about_dialog_set_version (_tmp10_, _tmp7_);
	_g_free0 (_tmp7_);
	adw_about_dialog_set_website (_tmp10_, _tmp8_);
	_g_free0 (_tmp8_);
	adw_about_dialog_set_issue_url (_tmp10_, _tmp9_);
	_g_free0 (_tmp9_);
	g_object_ref_sink (_tmp10_);
	about = _tmp10_;
	adw_dialog_present ((AdwDialog*) about, (GtkWidget*) self);
	_g_object_unref0 (about);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static void
app_window_about_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_show_about (self);
}

static void
__lambda40_ (AppWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	AutosaveManager* _tmp0_;
	g_return_if_fail (res != NULL);
	if (!app_window_prompt_to_save_finish (self, res)) {
		return;
	}
	gtk_window_destroy ((GtkWindow*) self);
	if (self->priv->save_state_timeout != ((guint) 0)) {
		app_window_save_state (self, TRUE);
	}
	_tmp0_ = self->priv->autosave_manager;
	autosave_manager_cleanup (_tmp0_);
}

static void
___lambda40__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda40_ ((AppWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
app_window_on_quit (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_prompt_to_save_async (self, _ ("Save document before quitting?"), _ ("_Quit without Saving"), ___lambda40__gasync_ready_callback, g_object_ref (self));
}

static void
app_window_quit_cb (AppWindow* self)
{
	g_return_if_fail (self != NULL);
	app_window_on_quit (self);
}

static void
app_window_real_size_allocate (GtkWidget* base,
                               gint width,
                               gint height,
                               gint baseline)
{
	AppWindow * self;
	gboolean _tmp0_ = FALSE;
	self = (AppWindow*) base;
	GTK_WIDGET_CLASS (app_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow), width, height, baseline);
	if (!self->priv->window_is_maximized) {
		_tmp0_ = !self->priv->window_is_fullscreen;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->window_width = gtk_widget_get_width ((GtkWidget*) self);
		self->priv->window_height = gtk_widget_get_height ((GtkWidget*) self);
		app_window_save_state (self, FALSE);
	}
}

static void
app_window_real_unmap (GtkWidget* base)
{
	AppWindow * self;
	self = (AppWindow*) base;
	self->priv->window_is_maximized = gtk_window_is_maximized ((GtkWindow*) self);
	self->priv->window_is_fullscreen = gtk_window_is_fullscreen ((GtkWindow*) self);
	app_window_save_state (self, FALSE);
	GTK_WIDGET_CLASS (app_window_parent_class)->unmap ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow));
}

static gboolean
app_window_window_close_request_cb (AppWindow* self,
                                    GtkWindow* window)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	app_window_on_quit (self);
	result = TRUE;
	return result;
}

static gboolean
_app_window_window_close_request_cb_gtk_window_close_request (GtkWindow* _sender,
                                                              gpointer self)
{
	gboolean result;
	result = app_window_window_close_request_cb ((AppWindow*) self, _sender);
	return result;
}

static void
app_window_page_added_cb (AppWindow* self,
                          Book* book,
                          Page* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	app_window_update_page_menu (self);
}

static void
app_window_reordered_cb (AppWindow* self,
                         Book* book)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	app_window_update_page_menu (self);
}

static void
app_window_page_removed_cb (AppWindow* self,
                            Book* book,
                            Page* page)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	g_return_if_fail (page != NULL);
	app_window_update_page_menu (self);
}

static void
app_window_book_changed_cb (AppWindow* self,
                            Book* book)
{
	GtkButton* _tmp0_;
	GSimpleAction* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (book != NULL);
	_tmp0_ = self->priv->save_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	self->priv->book_needs_saving = TRUE;
	_tmp1_ = self->priv->copy_to_clipboard_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
}

static void
_app_window_page_selected_cb_book_view_page_selected (BookView* _sender,
                                                      Page* page,
                                                      gpointer self)
{
	app_window_page_selected_cb ((AppWindow*) self, _sender, page);
}

static void
_app_window_show_page_cb_book_view_show_page (BookView* _sender,
                                              Page* page,
                                              gpointer self)
{
	app_window_show_page_cb ((AppWindow*) self, _sender, page);
}

static void
_app_window_show_page_menu_cb_book_view_show_menu (BookView* _sender,
                                                   GtkWidget* from,
                                                   gdouble x,
                                                   gdouble y,
                                                   gpointer self)
{
	app_window_show_page_menu_cb ((AppWindow*) self, _sender, from, x, y);
}

static void
app_window_load (AppWindow* self)
{
	GSettings* _tmp0_;
	PreferencesDialog* _tmp1_;
	GtkApplication* app = NULL;
	GApplication* _tmp2_;
	GtkApplication* _tmp3_;
	CropActions* _tmp4_;
	GtkApplication* _tmp5_;
	GtkApplication* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GtkApplication* _tmp9_;
	GAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GtkApplication* _tmp12_;
	GAction* _tmp13_;
	GSimpleAction* _tmp14_;
	GtkApplication* _tmp15_;
	GAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GtkApplication* _tmp18_;
	GAction* _tmp19_;
	GSimpleAction* _tmp20_;
	GtkApplication* _tmp21_;
	GAction* _tmp22_;
	GSimpleAction* _tmp23_;
	GtkApplication* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	GtkApplication* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	GtkApplication* _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	GtkApplication* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	GtkApplication* _tmp40_;
	gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	GtkApplication* _tmp44_;
	gchar* _tmp45_;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	GtkApplication* _tmp48_;
	gchar* _tmp49_;
	gchar** _tmp50_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	GtkApplication* _tmp52_;
	gchar* _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	GtkApplication* _tmp56_;
	gchar* _tmp57_;
	gchar** _tmp58_;
	gchar** _tmp59_;
	gint _tmp59__length1;
	GtkApplication* _tmp60_;
	gchar* _tmp61_;
	gchar** _tmp62_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	GtkApplication* _tmp64_;
	gchar* _tmp65_;
	gchar** _tmp66_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	GtkApplication* _tmp68_;
	gchar* _tmp69_;
	gchar** _tmp70_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	GtkApplication* _tmp72_;
	gchar* _tmp73_;
	gchar** _tmp74_;
	gchar** _tmp75_;
	gint _tmp75__length1;
	GtkApplication* _tmp76_;
	gchar* _tmp77_;
	gchar** _tmp78_;
	gchar** _tmp79_;
	gint _tmp79__length1;
	GtkApplication* _tmp80_;
	gchar* _tmp81_;
	gchar** _tmp82_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	GtkApplication* _tmp84_;
	gchar* _tmp85_;
	gchar** _tmp86_;
	gchar** _tmp87_;
	gint _tmp87__length1;
	GtkApplication* _tmp88_;
	gchar* _tmp89_;
	gchar** _tmp90_;
	gchar** _tmp91_;
	gint _tmp91__length1;
	GtkApplication* _tmp92_;
	gchar* _tmp93_;
	gchar** _tmp94_;
	gchar** _tmp95_;
	gint _tmp95__length1;
	GMenu* gear_menu = NULL;
	GMenu* _tmp96_;
	GMenu* section = NULL;
	GMenu* _tmp97_;
	GMenu* _tmp98_;
	GMenu* _tmp99_;
	GMenu* _tmp100_;
	GMenu* _tmp101_;
	GMenu* _tmp102_;
	GMenu* _tmp103_;
	GMenu* _tmp104_;
	GMenu* _tmp105_;
	GMenu* _tmp106_;
	GMenu* _tmp107_;
	GMenu* _tmp108_;
	GMenu* _tmp109_;
	GtkMenuButton* _tmp110_;
	GMenu* _tmp111_;
	GtkApplication* _tmp112_;
	gchar* document_type = NULL;
	GSettings* _tmp113_;
	gchar* _tmp114_;
	const gchar* _tmp115_;
	Book* _tmp117_;
	BookView* _tmp118_;
	BookView* _tmp119_;
	GtkBox* _tmp120_;
	BookView* _tmp121_;
	BookView* _tmp122_;
	BookView* _tmp123_;
	BookView* _tmp124_;
	BookView* _tmp125_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = preferences_dialog_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->preferences_dialog);
	self->priv->preferences_dialog = _tmp1_;
	gtk_window_set_default_icon_name ("org.gnome.SimpleScan");
	_tmp2_ = g_application_get_default ();
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_application_get_type ()) ? ((GtkApplication*) _tmp2_) : NULL);
	app = _tmp3_;
	_tmp4_ = crop_actions_new (self);
	_crop_actions_unref0 (self->priv->crop_actions);
	self->priv->crop_actions = _tmp4_;
	_tmp5_ = app;
	g_action_map_add_action_entries ((GActionMap*) _tmp5_, APP_WINDOW_action_entries, (gint) G_N_ELEMENTS (APP_WINDOW_action_entries), self);
	_tmp6_ = app;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) _tmp6_, "scan_type");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->scan_type_action);
	self->priv->scan_type_action = _tmp8_;
	_tmp9_ = app;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) _tmp9_, "document_hint");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->document_hint_action);
	self->priv->document_hint_action = _tmp11_;
	_tmp12_ = app;
	_tmp13_ = g_action_map_lookup_action ((GActionMap*) _tmp12_, "delete_page");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->delete_page_action);
	self->priv->delete_page_action = _tmp14_;
	_tmp15_ = app;
	_tmp16_ = g_action_map_lookup_action ((GActionMap*) _tmp15_, "move_left");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->page_move_left_action);
	self->priv->page_move_left_action = _tmp17_;
	_tmp18_ = app;
	_tmp19_ = g_action_map_lookup_action ((GActionMap*) _tmp18_, "move_right");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->page_move_right_action);
	self->priv->page_move_right_action = _tmp20_;
	_tmp21_ = app;
	_tmp22_ = g_action_map_lookup_action ((GActionMap*) _tmp21_, "copy_page");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->copy_to_clipboard_action);
	self->priv->copy_to_clipboard_action = _tmp23_;
	_tmp24_ = app;
	_tmp25_ = g_strdup ("<Ctrl>N");
	_tmp26_ = g_new0 (gchar*, 1 + 1);
	_tmp26_[0] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 1;
	gtk_application_set_accels_for_action (_tmp24_, "app.new_document", _tmp27_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp28_ = app;
	_tmp29_ = g_strdup ("<Ctrl>1");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	gtk_application_set_accels_for_action (_tmp28_, "app.scan_single", _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = app;
	_tmp33_ = g_strdup ("<Ctrl>F");
	_tmp34_ = g_new0 (gchar*, 1 + 1);
	_tmp34_[0] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 1;
	gtk_application_set_accels_for_action (_tmp32_, "app.scan_adf", _tmp35_);
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	_tmp36_ = app;
	_tmp37_ = g_strdup ("<Ctrl>M");
	_tmp38_ = g_new0 (gchar*, 1 + 1);
	_tmp38_[0] = _tmp37_;
	_tmp39_ = _tmp38_;
	_tmp39__length1 = 1;
	gtk_application_set_accels_for_action (_tmp36_, "app.scan_batch", _tmp39_);
	_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
	_tmp40_ = app;
	_tmp41_ = g_strdup ("Escape");
	_tmp42_ = g_new0 (gchar*, 1 + 1);
	_tmp42_[0] = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp43__length1 = 1;
	gtk_application_set_accels_for_action (_tmp40_, "app.scan_stop", _tmp43_);
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	_tmp44_ = app;
	_tmp45_ = g_strdup ("bracketleft");
	_tmp46_ = g_new0 (gchar*, 1 + 1);
	_tmp46_[0] = _tmp45_;
	_tmp47_ = _tmp46_;
	_tmp47__length1 = 1;
	gtk_application_set_accels_for_action (_tmp44_, "app.rotate_left", _tmp47_);
	_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
	_tmp48_ = app;
	_tmp49_ = g_strdup ("bracketright");
	_tmp50_ = g_new0 (gchar*, 1 + 1);
	_tmp50_[0] = _tmp49_;
	_tmp51_ = _tmp50_;
	_tmp51__length1 = 1;
	gtk_application_set_accels_for_action (_tmp48_, "app.rotate_right", _tmp51_);
	_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
	_tmp52_ = app;
	_tmp53_ = g_strdup ("less");
	_tmp54_ = g_new0 (gchar*, 1 + 1);
	_tmp54_[0] = _tmp53_;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = 1;
	gtk_application_set_accels_for_action (_tmp52_, "app.move_left", _tmp55_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	_tmp56_ = app;
	_tmp57_ = g_strdup ("greater");
	_tmp58_ = g_new0 (gchar*, 1 + 1);
	_tmp58_[0] = _tmp57_;
	_tmp59_ = _tmp58_;
	_tmp59__length1 = 1;
	gtk_application_set_accels_for_action (_tmp56_, "app.move_right", _tmp59_);
	_tmp59_ = (_vala_array_free (_tmp59_, _tmp59__length1, (GDestroyNotify) g_free), NULL);
	_tmp60_ = app;
	_tmp61_ = g_strdup ("<Ctrl>C");
	_tmp62_ = g_new0 (gchar*, 1 + 1);
	_tmp62_[0] = _tmp61_;
	_tmp63_ = _tmp62_;
	_tmp63__length1 = 1;
	gtk_application_set_accels_for_action (_tmp60_, "app.copy_page", _tmp63_);
	_tmp63_ = (_vala_array_free (_tmp63_, _tmp63__length1, (GDestroyNotify) g_free), NULL);
	_tmp64_ = app;
	_tmp65_ = g_strdup ("Delete");
	_tmp66_ = g_new0 (gchar*, 1 + 1);
	_tmp66_[0] = _tmp65_;
	_tmp67_ = _tmp66_;
	_tmp67__length1 = 1;
	gtk_application_set_accels_for_action (_tmp64_, "app.delete_page", _tmp67_);
	_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
	_tmp68_ = app;
	_tmp69_ = g_strdup ("<Ctrl>S");
	_tmp70_ = g_new0 (gchar*, 1 + 1);
	_tmp70_[0] = _tmp69_;
	_tmp71_ = _tmp70_;
	_tmp71__length1 = 1;
	gtk_application_set_accels_for_action (_tmp68_, "app.save", _tmp71_);
	_tmp71_ = (_vala_array_free (_tmp71_, _tmp71__length1, (GDestroyNotify) g_free), NULL);
	_tmp72_ = app;
	_tmp73_ = g_strdup ("<Ctrl>E");
	_tmp74_ = g_new0 (gchar*, 1 + 1);
	_tmp74_[0] = _tmp73_;
	_tmp75_ = _tmp74_;
	_tmp75__length1 = 1;
	gtk_application_set_accels_for_action (_tmp72_, "app.email", _tmp75_);
	_tmp75_ = (_vala_array_free (_tmp75_, _tmp75__length1, (GDestroyNotify) g_free), NULL);
	_tmp76_ = app;
	_tmp77_ = g_strdup ("<Ctrl>P");
	_tmp78_ = g_new0 (gchar*, 1 + 1);
	_tmp78_[0] = _tmp77_;
	_tmp79_ = _tmp78_;
	_tmp79__length1 = 1;
	gtk_application_set_accels_for_action (_tmp76_, "app.print", _tmp79_);
	_tmp79_ = (_vala_array_free (_tmp79_, _tmp79__length1, (GDestroyNotify) g_free), NULL);
	_tmp80_ = app;
	_tmp81_ = g_strdup ("F1");
	_tmp82_ = g_new0 (gchar*, 1 + 1);
	_tmp82_[0] = _tmp81_;
	_tmp83_ = _tmp82_;
	_tmp83__length1 = 1;
	gtk_application_set_accels_for_action (_tmp80_, "app.help", _tmp83_);
	_tmp83_ = (_vala_array_free (_tmp83_, _tmp83__length1, (GDestroyNotify) g_free), NULL);
	_tmp84_ = app;
	_tmp85_ = g_strdup ("<Ctrl>Q");
	_tmp86_ = g_new0 (gchar*, 1 + 1);
	_tmp86_[0] = _tmp85_;
	_tmp87_ = _tmp86_;
	_tmp87__length1 = 1;
	gtk_application_set_accels_for_action (_tmp84_, "app.quit", _tmp87_);
	_tmp87_ = (_vala_array_free (_tmp87_, _tmp87__length1, (GDestroyNotify) g_free), NULL);
	_tmp88_ = app;
	_tmp89_ = g_strdup ("<Ctrl>comma");
	_tmp90_ = g_new0 (gchar*, 1 + 1);
	_tmp90_[0] = _tmp89_;
	_tmp91_ = _tmp90_;
	_tmp91__length1 = 1;
	gtk_application_set_accels_for_action (_tmp88_, "app.preferences", _tmp91_);
	_tmp91_ = (_vala_array_free (_tmp91_, _tmp91__length1, (GDestroyNotify) g_free), NULL);
	_tmp92_ = app;
	_tmp93_ = g_strdup ("<Ctrl>question");
	_tmp94_ = g_new0 (gchar*, 1 + 1);
	_tmp94_[0] = _tmp93_;
	_tmp95_ = _tmp94_;
	_tmp95__length1 = 1;
	gtk_application_set_accels_for_action (_tmp92_, "win.show-help-overlay", _tmp95_);
	_tmp95_ = (_vala_array_free (_tmp95_, _tmp95__length1, (GDestroyNotify) g_free), NULL);
	_tmp96_ = g_menu_new ();
	gear_menu = _tmp96_;
	_tmp97_ = g_menu_new ();
	section = _tmp97_;
	_tmp98_ = gear_menu;
	_tmp99_ = section;
	g_menu_append_section (_tmp98_, NULL, (GMenuModel*) _tmp99_);
	_tmp100_ = section;
	g_menu_append (_tmp100_, _ ("_Email…"), "app.email");
	_tmp101_ = section;
	g_menu_append (_tmp101_, _ ("Pri_nt…"), "app.print");
	_tmp102_ = section;
	g_menu_append (_tmp102_, C_ ("menu", "_Reorder Pages…"), "app.reorder");
	_tmp103_ = g_menu_new ();
	_g_object_unref0 (section);
	section = _tmp103_;
	_tmp104_ = gear_menu;
	_tmp105_ = section;
	g_menu_append_section (_tmp104_, NULL, (GMenuModel*) _tmp105_);
	_tmp106_ = section;
	g_menu_append (_tmp106_, _ ("_Preferences"), "app.preferences");
	_tmp107_ = section;
	g_menu_append (_tmp107_, _ ("_Keyboard Shortcuts"), "win.show-help-overlay");
	_tmp108_ = section;
	g_menu_append (_tmp108_, _ ("_Help"), "app.help");
	_tmp109_ = section;
	g_menu_append (_tmp109_, _ ("_About Document Scanner"), "app.about");
	_tmp110_ = self->priv->menu_button;
	_tmp111_ = gear_menu;
	gtk_menu_button_set_menu_model (_tmp110_, (GMenuModel*) _tmp111_);
	_tmp112_ = app;
	gtk_application_add_window (_tmp112_, (GtkWindow*) self);
	_tmp113_ = self->priv->settings;
	_tmp114_ = g_settings_get_string (_tmp113_, "document-type");
	document_type = _tmp114_;
	_tmp115_ = document_type;
	if (_tmp115_ != NULL) {
		const gchar* _tmp116_;
		_tmp116_ = document_type;
		app_window_set_document_hint (self, _tmp116_, FALSE);
	}
	_tmp117_ = self->priv->_book;
	_tmp118_ = book_view_new (_tmp117_);
	g_object_ref_sink (_tmp118_);
	_g_object_unref0 (self->priv->book_view);
	self->priv->book_view = _tmp118_;
	_tmp119_ = self->priv->book_view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp119_, TRUE);
	_tmp120_ = self->priv->main_vbox;
	_tmp121_ = self->priv->book_view;
	gtk_box_prepend (_tmp120_, (GtkWidget*) _tmp121_);
	_tmp122_ = self->priv->book_view;
	g_signal_connect_object (_tmp122_, "page-selected", (GCallback) _app_window_page_selected_cb_book_view_page_selected, self, 0);
	_tmp123_ = self->priv->book_view;
	g_signal_connect_object (_tmp123_, "show-page", (GCallback) _app_window_show_page_cb_book_view_show_page, self, 0);
	_tmp124_ = self->priv->book_view;
	g_signal_connect_object (_tmp124_, "show-menu", (GCallback) _app_window_show_page_menu_cb_book_view_show_menu, self, 0);
	_tmp125_ = self->priv->book_view;
	gtk_widget_set_visible ((GtkWidget*) _tmp125_, TRUE);
	app_window_load_state (self);
	g_debug ("app-window.vala:1415: Restoring window to %dx%d pixels", self->priv->window_width, self->priv->window_height);
	gtk_window_set_default_size ((GtkWindow*) self, self->priv->window_width, self->priv->window_height);
	if (self->priv->window_is_maximized) {
		g_debug ("app-window.vala:1419: Restoring window to maximized");
		gtk_window_maximize ((GtkWindow*) self);
	}
	if (self->priv->window_is_fullscreen) {
		g_debug ("app-window.vala:1424: Restoring window to fullscreen");
		gtk_window_fullscreen ((GtkWindow*) self);
	}
	_g_free0 (document_type);
	_g_object_unref0 (section);
	_g_object_unref0 (gear_menu);
	_g_object_unref0 (app);
}

static void
app_window_load_state (AppWindow* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GKeyFile* f = NULL;
	GKeyFile* _tmp3_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = app_window_get_state_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_debug ("app-window.vala:1436: Loading state from %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_key_file_new ();
	f = _tmp3_;
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = app_window_get_state_filename (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		g_key_file_load_from_file (f, _tmp6_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		if (!g_error_matches (_tmp7_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp8_;
			const gchar* _tmp9_;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("app-window.vala:1446: Failed to load state: %s", _tmp9_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->priv->window_width = app_window_state_get_integer (self, f, "window", "width", 600);
	if (self->priv->window_width <= 0) {
		self->priv->window_width = 600;
	}
	self->priv->window_height = app_window_state_get_integer (self, f, "window", "height", 400);
	if (self->priv->window_height <= 0) {
		self->priv->window_height = 400;
	}
	self->priv->window_is_maximized = app_window_state_get_boolean (self, f, "window", "is-maximized", FALSE);
	self->priv->window_is_fullscreen = app_window_state_get_boolean (self, f, "window", "is-fullscreen", FALSE);
	_tmp10_ = app_window_state_get_string (self, f, "scanner", "scan-type", "");
	_tmp11_ = _tmp10_;
	self->priv->scan_type = scanner_type_from_string (_tmp11_);
	_g_free0 (_tmp11_);
	app_window_set_scan_type (self, self->priv->scan_type);
	_g_key_file_unref0 (f);
}

static gchar*
app_window_state_get_string (AppWindow* self,
                             GKeyFile* f,
                             const gchar* group_name,
                             const gchar* key,
                             const gchar* _default_)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	g_return_val_if_fail (group_name != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (_default_ != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_key_file_get_string (f, group_name, key, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp3_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = g_strdup (_default_);
		result = _tmp3_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
app_window_state_get_integer (AppWindow* self,
                              GKeyFile* f,
                              const gchar* group_name,
                              const gchar* key,
                              gint _default_)
{
	gint _tmp1_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (f != NULL, 0);
	g_return_val_if_fail (group_name != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	{
		gint _tmp0_ = 0;
		_tmp0_ = g_key_file_get_integer (f, group_name, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = _default_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp1_;
}

static gboolean
app_window_state_get_boolean (AppWindow* self,
                              GKeyFile* f,
                              const gchar* group_name,
                              const gchar* key,
                              gboolean _default_)
{
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (f != NULL, FALSE);
	g_return_val_if_fail (group_name != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_key_file_get_boolean (f, group_name, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = _default_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp1_;
}

static gboolean
___lambda41_ (AppWindow* self)
{
	gboolean result;
	app_window_save_state (self, TRUE);
	self->priv->save_state_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda41__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda41_ ((AppWindow*) self);
	return result;
}

static void
app_window_save_state (AppWindow* self,
                       gboolean force)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GKeyFile* f = NULL;
	GKeyFile* _tmp3_;
	GKeyFile* _tmp4_;
	GKeyFile* _tmp5_;
	GKeyFile* _tmp6_;
	GKeyFile* _tmp7_;
	GKeyFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!force) {
		if (self->priv->save_state_timeout != ((guint) 0)) {
			g_source_remove (self->priv->save_state_timeout);
		}
		self->priv->save_state_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda41__gsource_func, g_object_ref (self), g_object_unref);
		return;
	}
	_tmp0_ = app_window_get_state_filename (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_debug ("app-window.vala:1512: Saving state to %s", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_key_file_new ();
	f = _tmp3_;
	_tmp4_ = f;
	g_key_file_set_integer (_tmp4_, "window", "width", self->priv->window_width);
	_tmp5_ = f;
	g_key_file_set_integer (_tmp5_, "window", "height", self->priv->window_height);
	_tmp6_ = f;
	g_key_file_set_boolean (_tmp6_, "window", "is-maximized", self->priv->window_is_maximized);
	_tmp7_ = f;
	g_key_file_set_boolean (_tmp7_, "window", "is-fullscreen", self->priv->window_is_fullscreen);
	_tmp8_ = f;
	_tmp9_ = scanner_type_to_string (self->priv->scan_type);
	_tmp10_ = _tmp9_;
	g_key_file_set_string (_tmp8_, "scanner", "scan-type", _tmp10_);
	_g_free0 (_tmp10_);
	{
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GKeyFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp11_ = app_window_STATE_DIR;
		g_mkdir_with_parents (_tmp11_, 0700);
		_tmp12_ = app_window_get_state_filename (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = f;
		_tmp16_ = g_key_file_to_data (_tmp15_, NULL, NULL);
		_tmp17_ = _tmp16_;
		g_file_set_contents (_tmp14_, _tmp17_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("app-window.vala:1527: Failed to write state: %s", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (f);
}

static void
___lambda46_ (AppWindow* self,
              GObject* obj,
              GAsyncResult* res)
{
	gboolean restore = FALSE;
	Book* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (res != NULL);
	restore = app_window_prompt_to_load_autosaved_book_finish (self, res);
	if (restore) {
		AutosaveManager* _tmp0_;
		_tmp0_ = self->priv->autosave_manager;
		autosave_manager_load (_tmp0_);
	}
	_tmp1_ = self->priv->_book;
	_tmp2_ = book_get_n_pages (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == ((guint) 0)) {
		self->priv->book_needs_saving = FALSE;
	} else {
		GtkStack* _tmp4_;
		BookView* _tmp5_;
		Book* _tmp6_;
		Page* _tmp7_;
		Page* _tmp8_;
		Book* _tmp9_;
		_tmp4_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp4_, "document");
		_tmp5_ = self->priv->book_view;
		_tmp6_ = self->priv->_book;
		_tmp7_ = book_get_page (_tmp6_, 0);
		_tmp8_ = _tmp7_;
		book_view_set_selected_page (_tmp5_, _tmp8_);
		_g_object_unref0 (_tmp8_);
		self->priv->book_needs_saving = TRUE;
		_tmp9_ = self->priv->_book;
		app_window_book_changed_cb (self, _tmp9_);
	}
}

static void
____lambda46__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda46_ ((AppWindow*) self, source_object, res);
	g_object_unref (self);
}

void
app_window_start (AppWindow* self)
{
	AutosaveManager* _tmp0_;
	AutosaveManager* _tmp1_;
	Book* _tmp2_;
	AutosaveManager* _tmp3_;
	g_return_if_fail (self != NULL);
	gtk_widget_set_visible ((GtkWidget*) self, TRUE);
	_tmp0_ = autosave_manager_new ();
	_autosave_manager_unref0 (self->priv->autosave_manager);
	self->priv->autosave_manager = _tmp0_;
	_tmp1_ = self->priv->autosave_manager;
	_tmp2_ = self->priv->_book;
	autosave_manager_set_book (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->autosave_manager;
	if (autosave_manager_exists (_tmp3_)) {
		app_window_prompt_to_load_autosaved_book (self, ____lambda46__gasync_ready_callback, g_object_ref (self));
	}
}

Book*
app_window_get_book (AppWindow* self)
{
	Book* result;
	Book* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_book;
	result = _tmp0_;
	return result;
}

static void
app_window_set_book (AppWindow* self,
                     Book* value)
{
	Book* old_value;
	g_return_if_fail (self != NULL);
	old_value = app_window_get_book (self);
	if (old_value != value) {
		Book* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_book);
		self->priv->_book = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_BOOK_PROPERTY]);
	}
}

Page*
app_window_get_selected_page (AppWindow* self)
{
	Page* result;
	BookView* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->book_view;
	_tmp1_ = book_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
app_window_set_selected_page (AppWindow* self,
                              Page* value)
{
	BookView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->book_view;
	book_view_set_selected_page (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_SELECTED_PAGE_PROPERTY]);
}

gboolean
app_window_get_scanning (AppWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->scanning_;
	return result;
}

void
app_window_set_scanning (AppWindow* self,
                         gboolean value)
{
	GtkStack* _tmp0_;
	GSimpleAction* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->scanning_ = value;
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "document");
	_tmp1_ = self->priv->delete_page_action;
	g_simple_action_set_enabled (_tmp1_, !value);
	_tmp2_ = self->priv->scan_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, !value);
	_tmp3_ = self->priv->stop_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_SCANNING_PROPERTY]);
}

gint
app_window_get_brightness (AppWindow* self)
{
	gint result;
	PreferencesDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->preferences_dialog;
	result = preferences_dialog_get_brightness (_tmp0_);
	return result;
}

void
app_window_set_brightness (AppWindow* self,
                           gint value)
{
	PreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	preferences_dialog_set_brightness (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_BRIGHTNESS_PROPERTY]);
}

gint
app_window_get_contrast (AppWindow* self)
{
	gint result;
	PreferencesDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->preferences_dialog;
	result = preferences_dialog_get_contrast (_tmp0_);
	return result;
}

void
app_window_set_contrast (AppWindow* self,
                         gint value)
{
	PreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	preferences_dialog_set_contrast (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_CONTRAST_PROPERTY]);
}

gint
app_window_get_page_delay (AppWindow* self)
{
	gint result;
	PreferencesDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->preferences_dialog;
	result = preferences_dialog_get_page_delay (_tmp0_);
	return result;
}

void
app_window_set_page_delay (AppWindow* self,
                           gint value)
{
	PreferencesDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	preferences_dialog_set_page_delay (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, app_window_properties[APP_WINDOW_PAGE_DELAY_PROPERTY]);
}

static gchar*
app_window_get_state_filename (AppWindow* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", "state", NULL);
	result = _tmp1_;
	return result;
}

static void
g_cclosure_user_marshal_VOID__STRING_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_OBJECT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
app_window_class_init (AppWindowClass * klass,
                       gpointer klass_data)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	app_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AppWindow_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) app_window_real_size_allocate;
	((GtkWidgetClass *) klass)->unmap = (void (*) (GtkWidget*)) app_window_real_unmap;
	G_OBJECT_CLASS (klass)->get_property = _vala_app_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_app_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = app_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_BOOK_PROPERTY, app_window_properties[APP_WINDOW_BOOK_PROPERTY] = g_param_spec_object ("book", "book", "book", TYPE_BOOK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_SELECTED_PAGE_PROPERTY, app_window_properties[APP_WINDOW_SELECTED_PAGE_PROPERTY] = g_param_spec_object ("selected-page", "selected-page", "selected-page", TYPE_PAGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_SCANNING_PROPERTY, app_window_properties[APP_WINDOW_SCANNING_PROPERTY] = g_param_spec_boolean ("scanning", "scanning", "scanning", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_BRIGHTNESS_PROPERTY, app_window_properties[APP_WINDOW_BRIGHTNESS_PROPERTY] = g_param_spec_int ("brightness", "brightness", "brightness", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_CONTRAST_PROPERTY, app_window_properties[APP_WINDOW_CONTRAST_PROPERTY] = g_param_spec_int ("contrast", "contrast", "contrast", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), APP_WINDOW_PAGE_DELAY_PROPERTY, app_window_properties[APP_WINDOW_PAGE_DELAY_PROPERTY] = g_param_spec_int ("page-delay", "page-delay", "page-delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SimpleScan/ui/app-window.ui");
	app_window_signals[APP_WINDOW_START_SCAN_SIGNAL] = g_signal_new ("start-scan", TYPE_APP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_OBJECT, G_TYPE_NONE, 2, G_TYPE_STRING, TYPE_SCAN_OPTIONS);
	app_window_signals[APP_WINDOW_STOP_SCAN_SIGNAL] = g_signal_new ("stop-scan", TYPE_APP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	app_window_signals[APP_WINDOW_REDETECT_SIGNAL] = g_signal_new ("redetect", TYPE_APP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_menu", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, page_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "status_page", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, status_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "status_secondary_label", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, status_secondary_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "device_buttons_box", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, device_buttons_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "device_drop_down", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, device_drop_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_vbox", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, main_vbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, save_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stop_button", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, stop_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scan_button", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, scan_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_bar", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, action_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "crop_button", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, crop_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scan_button_content", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, scan_button_content));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, AppWindow_private_offset + G_STRUCT_OFFSET (AppWindowPrivate, menu_button));
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "simple-scan", NULL, NULL);
	app_window_STATE_DIR = _tmp1_;
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "status_label_activate_link_cb", G_CALLBACK(_app_window_status_label_activate_link_cb_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "new_document_cb", G_CALLBACK(_app_window_new_document_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "crop_toggle_cb", G_CALLBACK(_app_window_crop_toggle_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "redetect_button_clicked_cb", G_CALLBACK(_app_window_redetect_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "device_drop_down_changed_cb", G_CALLBACK(_app_window_device_drop_down_changed_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scan_button_clicked_cb", G_CALLBACK(_app_window_scan_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "stop_scan_button_clicked_cb", G_CALLBACK(_app_window_stop_scan_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "window_close_request_cb", G_CALLBACK(_app_window_window_close_request_cb_gtk_window_close_request));
}

static void
app_window_instance_init (AppWindow * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = app_window_get_instance_private (self);
	self->priv->scan_type = SCAN_TYPE_SINGLE;
	self->priv->have_devices = FALSE;
	self->priv->missing_driver = NULL;
	self->priv->book_uri = NULL;
	_tmp0_ = g_strdup ("photo");
	self->priv->document_hint = _tmp0_;
	self->priv->scanning_ = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
app_window_finalize (GObject * obj)
{
	AppWindow * self;
	Book* _tmp0_;
	guint _tmp1_;
	Book* _tmp2_;
	guint _tmp3_;
	Book* _tmp4_;
	guint _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APP_WINDOW, AppWindow);
	_tmp0_ = self->priv->_book;
	g_signal_parse_name ("page-added", TYPE_BOOK, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _app_window_page_added_cb_book_page_added, self);
	_tmp2_ = self->priv->_book;
	g_signal_parse_name ("reordered", TYPE_BOOK, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _app_window_reordered_cb_book_reordered, self);
	_tmp4_ = self->priv->_book;
	g_signal_parse_name ("page-removed", TYPE_BOOK, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _app_window_page_removed_cb_book_page_removed, self);
	_g_object_unref0 (self->priv->scan_type_action);
	_g_object_unref0 (self->priv->document_hint_action);
	_g_object_unref0 (self->priv->delete_page_action);
	_g_object_unref0 (self->priv->page_move_left_action);
	_g_object_unref0 (self->priv->page_move_right_action);
	_g_object_unref0 (self->priv->copy_to_clipboard_action);
	_crop_actions_unref0 (self->priv->crop_actions);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->device_model);
	_g_free0 (self->priv->missing_driver);
	_g_object_unref0 (self->priv->_book);
	_g_free0 (self->priv->book_uri);
	_autosave_manager_unref0 (self->priv->autosave_manager);
	_g_object_unref0 (self->priv->book_view);
	_g_free0 (self->priv->document_hint);
	G_OBJECT_CLASS (app_window_parent_class)->finalize (obj);
}

static GType
app_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AppWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) app_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AppWindow), 0, (GInstanceInitFunc) app_window_instance_init, NULL };
	GType app_window_type_id;
	app_window_type_id = g_type_register_static (adw_application_window_get_type (), "AppWindow", &g_define_type_info, 0);
	AppWindow_private_offset = g_type_add_instance_private (app_window_type_id, sizeof (AppWindowPrivate));
	return app_window_type_id;
}

GType
app_window_get_type (void)
{
	static volatile gsize app_window_type_id__once = 0;
	if (g_once_init_enter (&app_window_type_id__once)) {
		GType app_window_type_id;
		app_window_type_id = app_window_get_type_once ();
		g_once_init_leave (&app_window_type_id__once, app_window_type_id);
	}
	return app_window_type_id__once;
}

static void
_vala_app_window_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	AppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_WINDOW, AppWindow);
	switch (property_id) {
		case APP_WINDOW_BOOK_PROPERTY:
		g_value_set_object (value, app_window_get_book (self));
		break;
		case APP_WINDOW_SELECTED_PAGE_PROPERTY:
		g_value_set_object (value, app_window_get_selected_page (self));
		break;
		case APP_WINDOW_SCANNING_PROPERTY:
		g_value_set_boolean (value, app_window_get_scanning (self));
		break;
		case APP_WINDOW_BRIGHTNESS_PROPERTY:
		g_value_set_int (value, app_window_get_brightness (self));
		break;
		case APP_WINDOW_CONTRAST_PROPERTY:
		g_value_set_int (value, app_window_get_contrast (self));
		break;
		case APP_WINDOW_PAGE_DELAY_PROPERTY:
		g_value_set_int (value, app_window_get_page_delay (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_app_window_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	AppWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_APP_WINDOW, AppWindow);
	switch (property_id) {
		case APP_WINDOW_BOOK_PROPERTY:
		app_window_set_book (self, g_value_get_object (value));
		break;
		case APP_WINDOW_SELECTED_PAGE_PROPERTY:
		app_window_set_selected_page (self, g_value_get_object (value));
		break;
		case APP_WINDOW_SCANNING_PROPERTY:
		app_window_set_scanning (self, g_value_get_boolean (value));
		break;
		case APP_WINDOW_BRIGHTNESS_PROPERTY:
		app_window_set_brightness (self, g_value_get_int (value));
		break;
		case APP_WINDOW_CONTRAST_PROPERTY:
		app_window_set_contrast (self, g_value_get_int (value));
		break;
		case APP_WINDOW_PAGE_DELAY_PROPERTY:
		app_window_set_page_delay (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
cancellable_progress_bar_get_instance_private (CancellableProgressBar* self)
{
	return G_STRUCT_MEMBER_P (self, CancellableProgressBar_private_offset);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		CancellableProgressBar* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda31_ (Block6Data* _data6_)
{
	CancellableProgressBar* self;
	self = _data6_->self;
	gtk_widget_set_visible ((GtkWidget*) self, FALSE);
	g_cancellable_cancel (_data6_->cancellable);
}

static void
____lambda31__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	___lambda31_ (self);
}

CancellableProgressBar*
cancellable_progress_bar_construct (GType object_type,
                                    const gchar* text,
                                    GCancellable* cancellable)
{
	CancellableProgressBar * self = NULL;
	Block6Data* _data6_;
	GCancellable* _tmp0_;
	GtkProgressBar* _tmp1_;
	GtkProgressBar* _tmp2_;
	GtkProgressBar* _tmp3_;
	GtkProgressBar* _tmp4_;
	GtkProgressBar* _tmp5_;
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data6_->cancellable);
	_data6_->cancellable = _tmp0_;
	self = (CancellableProgressBar*) g_object_new (object_type, NULL);
	_data6_->self = g_object_ref (self);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	_tmp1_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->bar);
	self->priv->bar = _tmp1_;
	_tmp2_ = self->priv->bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->bar;
	gtk_progress_bar_set_text (_tmp3_, text);
	_tmp4_ = self->priv->bar;
	gtk_progress_bar_set_show_text (_tmp4_, TRUE);
	_tmp5_ = self->priv->bar;
	gtk_box_prepend ((GtkBox*) self, (GtkWidget*) _tmp5_);
	if (_data6_->cancellable != NULL) {
		GtkButton* _tmp6_;
		GtkButton* _tmp7_;
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		_tmp6_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->button);
		self->priv->button = _tmp6_;
		_tmp7_ = self->priv->button;
		gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
		_tmp8_ = self->priv->button;
		g_signal_connect_data (_tmp8_, "clicked", (GCallback) ____lambda31__gtk_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_tmp9_ = self->priv->button;
		gtk_box_prepend ((GtkBox*) self, (GtkWidget*) _tmp9_);
	}
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return self;
}

CancellableProgressBar*
cancellable_progress_bar_new (const gchar* text,
                              GCancellable* cancellable)
{
	return cancellable_progress_bar_construct (TYPE_CANCELLABLE_PROGRESS_BAR, text, cancellable);
}

void
cancellable_progress_bar_set_fraction (CancellableProgressBar* self,
                                       gdouble fraction)
{
	GtkProgressBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bar;
	gtk_progress_bar_set_fraction (_tmp0_, fraction);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		CancellableProgressBar* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
__lambda32_ (Block7Data* _data7_)
{
	CancellableProgressBar* self;
	gboolean result;
	self = _data7_->self;
	gtk_action_bar_remove (_data7_->parent, (GtkWidget*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda32__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda32_ (self);
	return result;
}

void
cancellable_progress_bar_remove_with_delay (CancellableProgressBar* self,
                                            guint delay,
                                            GtkActionBar* parent)
{
	Block7Data* _data7_;
	GtkActionBar* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (_data7_->parent);
	_data7_->parent = _tmp0_;
	_tmp1_ = self->priv->button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	g_timeout_add_full (G_PRIORITY_DEFAULT, delay, ___lambda32__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
cancellable_progress_bar_class_init (CancellableProgressBarClass * klass,
                                     gpointer klass_data)
{
	cancellable_progress_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CancellableProgressBar_private_offset);
	G_OBJECT_CLASS (klass)->finalize = cancellable_progress_bar_finalize;
}

static void
cancellable_progress_bar_instance_init (CancellableProgressBar * self,
                                        gpointer klass)
{
	self->priv = cancellable_progress_bar_get_instance_private (self);
}

static void
cancellable_progress_bar_finalize (GObject * obj)
{
	CancellableProgressBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANCELLABLE_PROGRESS_BAR, CancellableProgressBar);
	_g_object_unref0 (self->priv->bar);
	_g_object_unref0 (self->priv->button);
	G_OBJECT_CLASS (cancellable_progress_bar_parent_class)->finalize (obj);
}

static GType
cancellable_progress_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CancellableProgressBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cancellable_progress_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CancellableProgressBar), 0, (GInstanceInitFunc) cancellable_progress_bar_instance_init, NULL };
	GType cancellable_progress_bar_type_id;
	cancellable_progress_bar_type_id = g_type_register_static (gtk_box_get_type (), "CancellableProgressBar", &g_define_type_info, 0);
	CancellableProgressBar_private_offset = g_type_add_instance_private (cancellable_progress_bar_type_id, sizeof (CancellableProgressBarPrivate));
	return cancellable_progress_bar_type_id;
}

GType
cancellable_progress_bar_get_type (void)
{
	static volatile gsize cancellable_progress_bar_type_id__once = 0;
	if (g_once_init_enter (&cancellable_progress_bar_type_id__once)) {
		GType cancellable_progress_bar_type_id;
		cancellable_progress_bar_type_id = cancellable_progress_bar_get_type_once ();
		g_once_init_leave (&cancellable_progress_bar_type_id__once, cancellable_progress_bar_type_id);
	}
	return cancellable_progress_bar_type_id__once;
}

static inline gpointer
crop_actions_get_instance_private (CropActions* self)
{
	return G_STRUCT_MEMBER_P (self, CropActions_private_offset);
}

static void
_app_window_crop_set_action_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	app_window_crop_set_action_cb ((AppWindow*) self, action, parameter);
}

static void
_app_window_crop_rotate_action_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	app_window_crop_rotate_action_cb ((AppWindow*) self);
}

CropActions*
crop_actions_construct (GType object_type,
                        AppWindow* window)
{
	CropActions* self = NULL;
	GSimpleActionGroup* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	GActionEntry* _tmp2_;
	gint _tmp2__length1;
	GSimpleActionGroup* _tmp3_;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleActionGroup* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleActionGroup* _tmp9_;
	g_return_val_if_fail (window != NULL, NULL);
	self = (CropActions*) g_type_create_instance (object_type);
	_tmp0_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->group);
	self->priv->group = _tmp0_;
	_tmp1_ = self->priv->group;
	_tmp2_ = self->priv->crop_entries;
	_tmp2__length1 = self->priv->crop_entries_length1;
	g_action_map_add_action_entries ((GActionMap*) _tmp1_, _tmp2_, (gint) _tmp2__length1, window);
	_tmp3_ = self->priv->group;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) _tmp3_, "set");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->crop_set);
	self->priv->crop_set = _tmp5_;
	_tmp6_ = self->priv->group;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) _tmp6_, "rotate");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->crop_rotate);
	self->priv->crop_rotate = _tmp8_;
	_tmp9_ = self->priv->group;
	gtk_widget_insert_action_group ((GtkWidget*) window, "crop", (GActionGroup*) _tmp9_);
	return self;
}

CropActions*
crop_actions_new (AppWindow* window)
{
	return crop_actions_construct (TYPE_CROP_ACTIONS, window);
}

static GVariant*
_variant_new5 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new6 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

void
crop_actions_update_current_crop (CropActions* self,
                                  const gchar* crop_name)
{
	GSimpleAction* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->crop_rotate;
	g_simple_action_set_enabled (_tmp0_, crop_name != NULL);
	if (crop_name == NULL) {
		GSimpleAction* _tmp1_;
		GVariant* _tmp2_;
		_tmp1_ = self->priv->crop_set;
		_tmp2_ = _variant_new5 ("none");
		g_simple_action_set_state (_tmp1_, _tmp2_);
		_g_variant_unref0 (_tmp2_);
	} else {
		GSimpleAction* _tmp3_;
		GVariant* _tmp4_;
		_tmp3_ = self->priv->crop_set;
		_tmp4_ = _variant_new6 (crop_name);
		g_simple_action_set_state (_tmp3_, _tmp4_);
		_g_variant_unref0 (_tmp4_);
	}
}

static void
value_crop_actions_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_crop_actions_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		crop_actions_unref (value->data[0].v_pointer);
	}
}

static void
value_crop_actions_copy_value (const GValue* src_value,
                               GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = crop_actions_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_crop_actions_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_crop_actions_collect_value (GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CropActions * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = crop_actions_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_crop_actions_lcopy_value (const GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	CropActions ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = crop_actions_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_crop_actions (const gchar* name,
                         const gchar* nick,
                         const gchar* blurb,
                         GType object_type,
                         GParamFlags flags)
{
	ParamSpecCropActions* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CROP_ACTIONS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_crop_actions (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CROP_ACTIONS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_crop_actions (GValue* value,
                        gpointer v_object)
{
	CropActions * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CROP_ACTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CROP_ACTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		crop_actions_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		crop_actions_unref (old);
	}
}

void
value_take_crop_actions (GValue* value,
                         gpointer v_object)
{
	CropActions * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CROP_ACTIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CROP_ACTIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		crop_actions_unref (old);
	}
}

static void
crop_actions_class_init (CropActionsClass * klass,
                         gpointer klass_data)
{
	crop_actions_parent_class = g_type_class_peek_parent (klass);
	((CropActionsClass *) klass)->finalize = crop_actions_finalize;
	g_type_class_adjust_private_offset (klass, &CropActions_private_offset);
}

static void
crop_actions_instance_init (CropActions * self,
                            gpointer klass)
{
	GActionEntry _tmp0_ = {0};
	GActionEntry _tmp1_ = {0};
	GActionEntry* _tmp2_;
	self->priv = crop_actions_get_instance_private (self);
	memset (&_tmp0_, 0, sizeof (GActionEntry));
	_tmp0_.name = "set";
	_tmp0_.activate = _app_window_crop_set_action_cb_gsimple_action_activate_callback;
	_tmp0_.parameter_type = "s";
	_tmp0_.state = "'none'";
	memset (&_tmp1_, 0, sizeof (GActionEntry));
	_tmp1_.name = "rotate";
	_tmp1_.activate = _app_window_crop_rotate_action_cb_gsimple_action_activate_callback;
	_tmp2_ = g_new0 (GActionEntry, 2);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	self->priv->crop_entries = _tmp2_;
	self->priv->crop_entries_length1 = 2;
	self->priv->_crop_entries_size_ = self->priv->crop_entries_length1;
	self->ref_count = 1;
}

static void
crop_actions_finalize (CropActions * obj)
{
	CropActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CROP_ACTIONS, CropActions);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->group);
	_g_object_unref0 (self->priv->crop_set);
	_g_object_unref0 (self->priv->crop_rotate);
	self->priv->crop_entries = (g_free (self->priv->crop_entries), NULL);
}

static GType
crop_actions_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_crop_actions_init, value_crop_actions_free_value, value_crop_actions_copy_value, value_crop_actions_peek_pointer, "p", value_crop_actions_collect_value, "p", value_crop_actions_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CropActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crop_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CropActions), 0, (GInstanceInitFunc) crop_actions_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType crop_actions_type_id;
	crop_actions_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CropActions", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CropActions_private_offset = g_type_add_instance_private (crop_actions_type_id, sizeof (CropActionsPrivate));
	return crop_actions_type_id;
}

GType
crop_actions_get_type (void)
{
	static volatile gsize crop_actions_type_id__once = 0;
	if (g_once_init_enter (&crop_actions_type_id__once)) {
		GType crop_actions_type_id;
		crop_actions_type_id = crop_actions_get_type_once ();
		g_once_init_leave (&crop_actions_type_id__once, crop_actions_type_id);
	}
	return crop_actions_type_id__once;
}

gpointer
crop_actions_ref (gpointer instance)
{
	CropActions * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
crop_actions_unref (gpointer instance)
{
	CropActions * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CROP_ACTIONS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

