/* CheckerboardItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CheckerboardItem.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <pango/pango.h>
#include <gee.h>
#include <gtk/gtk.h>

#define CHECKERBOARD_ITEM_PROP_SHOW_TITLES "show-titles"
#define CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS "show-comments"
#define CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES "show-subtitles"
#define CHECKERBOARD_ITEM_FRAME_WIDTH 8
#define CHECKERBOARD_ITEM_LABEL_PADDING 4
#define CHECKERBOARD_ITEM_BORDER_WIDTH 1
#define CHECKERBOARD_ITEM_SHADOW_RADIUS 4
#define CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA 0.5f
#define CHECKERBOARD_ITEM_TRINKET_SCALE 12
#define CHECKERBOARD_ITEM_TRINKET_PADDING 1
#define CHECKERBOARD_ITEM_BRIGHTEN_SHIFT 0x18
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;
typedef struct _DataViewPrivate DataViewPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_VIEW (thumbnail_view_get_type ())
#define THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailView))
#define THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))
#define IS_THUMBNAIL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_VIEW))
#define IS_THUMBNAIL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_VIEW))
#define THUMBNAIL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_VIEW, ThumbnailViewClass))

typedef struct _ThumbnailView ThumbnailView;
typedef struct _ThumbnailViewClass ThumbnailViewClass;
typedef struct _ThumbnailViewPrivate ThumbnailViewPrivate;

#define TYPE_CHECKERBOARD_ITEM (checkerboard_item_get_type ())
#define CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItem))
#define CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))
#define IS_CHECKERBOARD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM))
#define IS_CHECKERBOARD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM))
#define CHECKERBOARD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM, CheckerboardItemClass))

typedef struct _CheckerboardItem CheckerboardItem;
typedef struct _CheckerboardItemClass CheckerboardItemClass;
typedef struct _CheckerboardItemPrivate CheckerboardItemPrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_CHECKERBOARD_ITEM_TEXT (checkerboard_item_text_get_type ())
#define CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemText))
#define CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))
#define IS_CHECKERBOARD_ITEM_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHECKERBOARD_ITEM_TEXT))
#define IS_CHECKERBOARD_ITEM_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHECKERBOARD_ITEM_TEXT))
#define CHECKERBOARD_ITEM_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHECKERBOARD_ITEM_TEXT, CheckerboardItemTextClass))

typedef struct _CheckerboardItemText CheckerboardItemText;
typedef struct _CheckerboardItemTextClass CheckerboardItemTextClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;
enum  {
	CHECKERBOARD_ITEM_0_PROPERTY,
	CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY,
	CHECKERBOARD_ITEM_NUM_PROPERTIES
};
static GParamSpec* checkerboard_item_properties[CHECKERBOARD_ITEM_NUM_PROPERTIES];
#define _checkerboard_item_text_unref0(var) ((var == NULL) ? NULL : (var = (checkerboard_item_text_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _CheckerboardItemTextPrivate CheckerboardItemTextPrivate;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataView {
	DataObject parent_instance;
	DataViewPrivate * priv;
};

struct _DataViewClass {
	DataObjectClass parent_class;
	void (*notify_view_altered) (DataView* self);
	void (*notify_geometry_altered) (DataView* self);
	void (*notify_unsubscribed) (DataView* self, DataSource* source);
	void (*state_changed) (DataView* self, gboolean selected);
	void (*visibility_changed) (DataView* self, gboolean visible);
	void (*view_altered) (DataView* self);
	void (*geometry_altered) (DataView* self);
	void (*unsubscribed) (DataView* self, DataSource* source);
};

struct _ThumbnailView {
	DataView parent_instance;
	ThumbnailViewPrivate * priv;
};

struct _ThumbnailViewClass {
	DataViewClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailView* self);
	void (*thumbnail_altered) (ThumbnailView* self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _CheckerboardItem {
	ThumbnailView parent_instance;
	CheckerboardItemPrivate * priv;
	Dimensions requisition;
	GdkRectangle allocation;
};

struct _CheckerboardItemClass {
	ThumbnailViewClass parent_class;
	void (*handle_mouse_motion) (CheckerboardItem* self, gint x, gint y, gint height, gint width);
	void (*handle_mouse_leave) (CheckerboardItem* self);
	void (*handle_mouse_enter) (CheckerboardItem* self);
	void (*exposed) (CheckerboardItem* self);
	void (*unexposed) (CheckerboardItem* self);
	gboolean (*is_exposed) (CheckerboardItem* self);
	void (*paint_shadow) (CheckerboardItem* self, cairo_t* ctx, Dimensions* dimensions, GdkPoint* origin, gint radius, gfloat initial_alpha);
	void (*paint_border) (CheckerboardItem* self, cairo_t* ctx, Dimensions* object_dimensions, GdkPoint* object_origin, gint border_width);
	void (*paint_image) (CheckerboardItem* self, cairo_t* ctx, GdkPixbuf* pixbuf, GdkPoint* origin);
	GdkPixbuf* (*get_top_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_top_right_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_left_trinket) (CheckerboardItem* self, gint scale);
	GdkPixbuf* (*get_bottom_right_trinket) (CheckerboardItem* self, gint scale);
};

struct _CheckerboardItemPrivate {
	gboolean exposure;
	CheckerboardItemText* title;
	gboolean title_visible;
	CheckerboardItemText* comment;
	gboolean comment_visible;
	CheckerboardItemText* subtitle;
	gboolean subtitle_visible;
	gboolean is_cursor;
	PangoAlignment tag_alignment;
	GeeList* user_visible_tag_list;
	GeeCollection* tags;
	GdkPixbuf* pixbuf;
	GdkPixbuf* display_pixbuf;
	GdkPixbuf* brightened;
	Dimensions pixbuf_dim;
	gint col;
	gint row;
	gint horizontal_trinket_offset;
	gboolean _has_tags;
};

struct _CheckerboardItemText {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CheckerboardItemTextPrivate * priv;
	GdkRectangle allocation;
};

struct _CheckerboardItemTextClass {
	GTypeClass parent_class;
	void (*finalize) (CheckerboardItemText *self);
};

static gint CheckerboardItem_private_offset;
static gpointer checkerboard_item_parent_class = NULL;

VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailView, g_object_unref)
VALA_EXTERN GType checkerboard_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardItem, g_object_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN gpointer checkerboard_item_text_ref (gpointer instance);
VALA_EXTERN void checkerboard_item_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_checkerboard_item_text (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_checkerboard_item_text (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_checkerboard_item_text (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_checkerboard_item_text (const GValue* value);
VALA_EXTERN GType checkerboard_item_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CheckerboardItemText, checkerboard_item_text_unref)
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
VALA_EXTERN void checkerboard_item_handle_mouse_motion (CheckerboardItem* self,
                                            gint x,
                                            gint y,
                                            gint height,
                                            gint width);
VALA_EXTERN void checkerboard_item_handle_mouse_leave (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_handle_mouse_enter (CheckerboardItem* self);
VALA_EXTERN void data_object_notify_membership_changed (DataObject* self,
                                            DataCollection* collection);
VALA_EXTERN void data_object_notify_collection_property_set (DataObject* self,
                                                 const gchar* name,
                                                 GValue* old,
                                                 GValue* val);
VALA_EXTERN void checkerboard_item_exposed (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_unexposed (CheckerboardItem* self);
VALA_EXTERN gboolean checkerboard_item_is_exposed (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_paint_shadow (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* dimensions,
                                     GdkPoint* origin,
                                     gint radius,
                                     gfloat initial_alpha);
VALA_EXTERN void checkerboard_item_paint_border (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* object_dimensions,
                                     GdkPoint* object_origin,
                                     gint border_width);
VALA_EXTERN void checkerboard_item_paint_image (CheckerboardItem* self,
                                    cairo_t* ctx,
                                    GdkPixbuf* pixbuf,
                                    GdkPoint* origin);
VALA_EXTERN GdkPixbuf* checkerboard_item_get_top_left_trinket (CheckerboardItem* self,
                                                   gint scale);
VALA_EXTERN GdkPixbuf* checkerboard_item_get_top_right_trinket (CheckerboardItem* self,
                                                    gint scale);
VALA_EXTERN GdkPixbuf* checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self,
                                                      gint scale);
VALA_EXTERN GdkPixbuf* checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self,
                                                       gint scale);
VALA_EXTERN void data_view_visibility_changed (DataView* self,
                                   gboolean visible);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN CheckerboardItem* checkerboard_item_construct (GType object_type,
                                               ThumbnailSource* source,
                                               Dimensions* initial_pixbuf_dim,
                                               const gchar* title,
                                               const gchar* comment,
                                               gboolean marked_up,
                                               PangoAlignment alignment);
VALA_EXTERN ThumbnailView* thumbnail_view_new (ThumbnailSource* source);
VALA_EXTERN ThumbnailView* thumbnail_view_construct (GType object_type,
                                         ThumbnailSource* source);
VALA_EXTERN CheckerboardItemText* checkerboard_item_text_new (const gchar* text,
                                                  PangoAlignment alignment,
                                                  gboolean marked_up);
VALA_EXTERN CheckerboardItemText* checkerboard_item_text_construct (GType object_type,
                                                        const gchar* text,
                                                        PangoAlignment alignment,
                                                        gboolean marked_up);
static gchar* checkerboard_item_real_get_name (DataObject* base);
VALA_EXTERN gchar* checkerboard_item_text_get_text (CheckerboardItemText* self);
VALA_EXTERN gchar* checkerboard_item_get_title (CheckerboardItem* self);
VALA_EXTERN gchar* checkerboard_item_get_comment (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_title (CheckerboardItem* self,
                                  const gchar* text,
                                  gboolean marked_up,
                                  PangoAlignment alignment);
VALA_EXTERN gboolean checkerboard_item_text_is_set_to (CheckerboardItemText* self,
                                           const gchar* text,
                                           gboolean marked_up,
                                           PangoAlignment alignment);
static void checkerboard_item_recalc_size (CheckerboardItem* self,
                                    const gchar* reason);
VALA_EXTERN void data_view_notify_view_altered (DataView* self);
VALA_EXTERN void checkerboard_item_translate_coordinates (CheckerboardItem* self,
                                              gint* x,
                                              gint* y);
VALA_EXTERN void checkerboard_item_clear_title (CheckerboardItem* self);
static void checkerboard_item_set_title_visible (CheckerboardItem* self,
                                          gboolean visible);
VALA_EXTERN void checkerboard_item_set_comment (CheckerboardItem* self,
                                    const gchar* text,
                                    gboolean marked_up,
                                    PangoAlignment alignment);
VALA_EXTERN void checkerboard_item_clear_comment (CheckerboardItem* self);
static void checkerboard_item_set_comment_visible (CheckerboardItem* self,
                                            gboolean visible);
VALA_EXTERN void checkerboard_item_set_tags (CheckerboardItem* self,
                                 GeeCollection* tags,
                                 PangoAlignment alignment);
static void checkerboard_item_set_has_tags (CheckerboardItem* self,
                                     gboolean value);
VALA_EXTERN gboolean checkerboard_item_get_has_tags (CheckerboardItem* self);
VALA_EXTERN GeeList* tag_make_user_visible_tag_list (GeeCollection* tags);
VALA_EXTERN gchar* tag_make_tag_markup_string (GeeList* tags,
                                   gint highlight_index);
VALA_EXTERN void checkerboard_item_clear_tags (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_clear_subtitle (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_highlight_user_visible_tag (CheckerboardItem* self,
                                                   gint index);
VALA_EXTERN Tag* checkerboard_item_get_user_visible_tag (CheckerboardItem* self,
                                             gint index);
VALA_EXTERN PangoLayout* checkerboard_item_get_tag_list_layout (CheckerboardItem* self);
VALA_EXTERN PangoLayout* checkerboard_item_text_get_pango_layout (CheckerboardItemText* self,
                                                      gint max_width);
VALA_EXTERN void checkerboard_item_get_subtitle_allocation (CheckerboardItem* self,
                                                GdkRectangle* result);
VALA_EXTERN gchar* checkerboard_item_get_subtitle (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_subtitle (CheckerboardItem* self,
                                     const gchar* text,
                                     gboolean marked_up,
                                     PangoAlignment alignment);
static void checkerboard_item_set_subtitle_visible (CheckerboardItem* self,
                                             gboolean visible);
VALA_EXTERN void checkerboard_item_set_is_cursor (CheckerboardItem* self,
                                      gboolean is_cursor);
VALA_EXTERN gboolean checkerboard_item_get_is_cursor (CheckerboardItem* self);
static void checkerboard_item_real_handle_mouse_motion (CheckerboardItem* self,
                                                 gint x,
                                                 gint y,
                                                 gint height,
                                                 gint width);
static void checkerboard_item_real_handle_mouse_leave (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_unbrighten (CheckerboardItem* self);
static void checkerboard_item_real_handle_mouse_enter (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_brighten (CheckerboardItem* self);
static void checkerboard_item_real_notify_membership_changed (DataObject* base,
                                                       DataCollection* collection);
VALA_EXTERN void data_object_get_collection_property (DataObject* self,
                                          const gchar* name,
                                          GValue* def,
                                          GValue* result);
static void _vala_GValue_free (GValue* self);
VALA_EXTERN gboolean dimensions_has_area (Dimensions *self);
static void checkerboard_item_real_notify_collection_property_set (DataObject* base,
                                                            const gchar* name,
                                                            GValue* old,
                                                            GValue* val);
VALA_EXTERN gint checkerboard_item_get_alignment_point (CheckerboardItem* self);
static void checkerboard_item_real_exposed (CheckerboardItem* self);
static void checkerboard_item_real_unexposed (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_text_clear_pango_layout (CheckerboardItemText* self);
static gboolean checkerboard_item_real_is_exposed (CheckerboardItem* self);
VALA_EXTERN gboolean checkerboard_item_has_image (CheckerboardItem* self);
VALA_EXTERN GdkPixbuf* checkerboard_item_get_image (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_image (CheckerboardItem* self,
                                  GdkPixbuf* pixbuf);
VALA_EXTERN void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
VALA_EXTERN void checkerboard_item_clear_image (CheckerboardItem* self,
                                    Dimensions* dim);
VALA_EXTERN gint checkerboard_item_get_max_width (gint scale);
VALA_EXTERN gint checkerboard_item_text_get_height (CheckerboardItemText* self);
VALA_EXTERN gboolean dimensions_approx_equals (Dimensions *self,
                                   Dimensions* dim,
                                   gint fudge);
VALA_EXTERN void data_view_notify_geometry_altered (DataView* self);
VALA_EXTERN void checkerboard_item_get_border_dimensions (Dimensions* object_dim,
                                              gint border_width,
                                              Dimensions* result);
VALA_EXTERN void checkerboard_item_get_border_origin (GdkPoint* object_origin,
                                          gint border_width,
                                          GdkPoint* result);
static void checkerboard_item_real_paint_shadow (CheckerboardItem* self,
                                          cairo_t* ctx,
                                          Dimensions* dimensions,
                                          GdkPoint* origin,
                                          gint radius,
                                          gfloat initial_alpha);
VALA_EXTERN void checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self,
                                               cairo_t* ctx,
                                               gint x,
                                               gint y,
                                               gdouble rgb_all,
                                               gfloat radius,
                                               gfloat initial_alpha,
                                               gdouble arc1,
                                               gdouble arc2);
static void checkerboard_item_real_paint_border (CheckerboardItem* self,
                                          cairo_t* ctx,
                                          Dimensions* object_dimensions,
                                          GdkPoint* object_origin,
                                          gint border_width);
VALA_EXTERN void draw_rounded_corners_filled (cairo_t* ctx,
                                  Dimensions* dim,
                                  GdkPoint* origin,
                                  gdouble radius_proportion);
static void checkerboard_item_real_paint_image (CheckerboardItem* self,
                                         cairo_t* ctx,
                                         GdkPixbuf* pixbuf,
                                         GdkPoint* origin);
VALA_EXTERN void paint_pixmap_with_background (cairo_t* ctx,
                                   GdkPixbuf* pixbuf,
                                   gint x,
                                   gint y);
static gint checkerboard_item_get_selection_border_width (CheckerboardItem* self,
                                                   gint scale);
VALA_EXTERN gint thumbnail_get_MIN_SCALE (void);
VALA_EXTERN gint thumbnail_get_MAX_SCALE (void);
static GdkPixbuf* checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self,
                                                        gint scale);
static GdkPixbuf* checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self,
                                                         gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self,
                                                           gint scale);
static GdkPixbuf* checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self,
                                                            gint scale);
VALA_EXTERN void checkerboard_item_paint (CheckerboardItem* self,
                              GtkStyleContext* style_context,
                              cairo_t* ctx,
                              GdkRGBA* bg_color,
                              GdkRGBA* selected_color,
                              GdkRGBA* border_color,
                              GdkRGBA* focus_color);
VALA_EXTERN gboolean data_view_is_selected (DataView* self);
VALA_EXTERN gint checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self);
VALA_EXTERN void checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self,
                                                      gint horizontal_trinket_offset);
VALA_EXTERN void checkerboard_item_set_grid_coordinates (CheckerboardItem* self,
                                             gint col,
                                             gint row);
VALA_EXTERN gint checkerboard_item_get_column (CheckerboardItem* self);
VALA_EXTERN gint checkerboard_item_get_row (CheckerboardItem* self);
VALA_EXTERN void shift_colors (GdkPixbuf* pixbuf,
                   gint red,
                   gint green,
                   gint blue,
                   gint alpha);
static void checkerboard_item_real_visibility_changed (DataView* base,
                                                gboolean visible);
static gboolean checkerboard_item_query_tooltip_on_text (CheckerboardItem* self,
                                                  CheckerboardItemText* text,
                                                  GtkTooltip* tooltip);
VALA_EXTERN gboolean checkerboard_item_text_is_marked_up (CheckerboardItemText* self);
VALA_EXTERN gboolean checkerboard_item_query_tooltip (CheckerboardItem* self,
                                          gint x,
                                          gint y,
                                          GtkTooltip* tooltip);
VALA_EXTERN gboolean coord_in_rectangle (gint x,
                             gint y,
                             GdkRectangle* rect);
static void checkerboard_item_finalize (GObject * obj);
static GType checkerboard_item_get_type_once (void);
static void _vala_checkerboard_item_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_checkerboard_item_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
checkerboard_item_get_instance_private (CheckerboardItem* self)
{
	return G_STRUCT_MEMBER_P (self, CheckerboardItem_private_offset);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

CheckerboardItem*
checkerboard_item_construct (GType object_type,
                             ThumbnailSource* source,
                             Dimensions* initial_pixbuf_dim,
                             const gchar* title,
                             const gchar* comment,
                             gboolean marked_up,
                             PangoAlignment alignment)
{
	CheckerboardItem * self = NULL;
	Dimensions _tmp0_;
	CheckerboardItemText* _tmp1_;
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
	g_return_val_if_fail (initial_pixbuf_dim != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (CheckerboardItem*) thumbnail_view_construct (object_type, source);
	_tmp0_ = *initial_pixbuf_dim;
	self->priv->pixbuf_dim = _tmp0_;
	_tmp1_ = checkerboard_item_text_new (title, alignment, marked_up);
	_checkerboard_item_text_unref0 (self->priv->title);
	self->priv->title = _tmp1_;
	if (comment != NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		CheckerboardItemText* _tmp4_;
		_tmp2_ = string_replace (comment, "\n", " ");
		_tmp3_ = _tmp2_;
		_tmp4_ = checkerboard_item_text_new (_tmp3_, alignment, marked_up);
		_checkerboard_item_text_unref0 (self->priv->comment);
		self->priv->comment = _tmp4_;
		_g_free0 (_tmp3_);
	}
	return self;
}

static gchar*
checkerboard_item_real_get_name (DataObject* base)
{
	CheckerboardItem * self;
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	_tmp1_ = self->priv->title;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->title;
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = DATA_OBJECT_CLASS (checkerboard_item_parent_class)->get_name (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

gchar*
checkerboard_item_get_title (CheckerboardItem* self)
{
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_tmp1_ = self->priv->title;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->title;
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

gchar*
checkerboard_item_get_comment (CheckerboardItem* self)
{
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_tmp1_ = self->priv->comment;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->comment;
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

void
checkerboard_item_set_title (CheckerboardItem* self,
                             const gchar* text,
                             gboolean marked_up,
                             PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	CheckerboardItemText* _tmp3_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	g_return_if_fail (text != NULL);
	_tmp1_ = self->priv->title;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		_tmp2_ = self->priv->title;
		_tmp0_ = checkerboard_item_text_is_set_to (_tmp2_, text, marked_up, alignment);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = checkerboard_item_text_new (text, alignment, marked_up);
	_checkerboard_item_text_unref0 (self->priv->title);
	self->priv->title = _tmp3_;
	if (self->priv->title_visible) {
		checkerboard_item_recalc_size (self, "set_title");
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
}

void
checkerboard_item_translate_coordinates (CheckerboardItem* self,
                                         gint* x,
                                         gint* y)
{
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_tmp0_ = self->allocation;
	*x = (*x) - (_tmp0_.x + CHECKERBOARD_ITEM_FRAME_WIDTH);
	_tmp1_ = self->allocation;
	*y = (*y) - (_tmp1_.y + CHECKERBOARD_ITEM_FRAME_WIDTH);
}

void
checkerboard_item_clear_title (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_tmp0_ = self->priv->title;
	if (_tmp0_ == NULL) {
		return;
	}
	_checkerboard_item_text_unref0 (self->priv->title);
	self->priv->title = NULL;
	if (self->priv->title_visible) {
		checkerboard_item_recalc_size (self, "clear_title");
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
}

static void
checkerboard_item_set_title_visible (CheckerboardItem* self,
                                     gboolean visible)
{
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	if (self->priv->title_visible == visible) {
		return;
	}
	self->priv->title_visible = visible;
	checkerboard_item_recalc_size (self, "set_title_visible");
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
}

void
checkerboard_item_set_comment (CheckerboardItem* self,
                               const gchar* text,
                               gboolean marked_up,
                               PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	CheckerboardItemText* _tmp5_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	g_return_if_fail (text != NULL);
	_tmp1_ = self->priv->comment;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		_tmp2_ = self->priv->comment;
		_tmp0_ = checkerboard_item_text_is_set_to (_tmp2_, text, marked_up, alignment);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = string_replace (text, "\n", " ");
	_tmp4_ = _tmp3_;
	_tmp5_ = checkerboard_item_text_new (_tmp4_, alignment, marked_up);
	_checkerboard_item_text_unref0 (self->priv->comment);
	self->priv->comment = _tmp5_;
	_g_free0 (_tmp4_);
	if (self->priv->comment_visible) {
		checkerboard_item_recalc_size (self, "set_comment");
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
}

void
checkerboard_item_clear_comment (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_tmp0_ = self->priv->comment;
	if (_tmp0_ == NULL) {
		return;
	}
	_checkerboard_item_text_unref0 (self->priv->comment);
	self->priv->comment = NULL;
	if (self->priv->comment_visible) {
		checkerboard_item_recalc_size (self, "clear_comment");
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
}

static void
checkerboard_item_set_comment_visible (CheckerboardItem* self,
                                       gboolean visible)
{
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	if (self->priv->comment_visible == visible) {
		return;
	}
	self->priv->comment_visible = visible;
	checkerboard_item_recalc_size (self, "set_comment_visible");
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
checkerboard_item_set_tags (CheckerboardItem* self,
                            GeeCollection* tags,
                            PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	gchar* text = NULL;
	gboolean _tmp3_;
	gboolean _tmp9_ = FALSE;
	CheckerboardItemText* _tmp10_;
	const gchar* _tmp13_;
	CheckerboardItemText* _tmp14_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	g_return_if_fail ((tags == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (tags, GEE_TYPE_COLLECTION));
	if (tags != NULL) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = gee_collection_get_size (tags);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	checkerboard_item_set_has_tags (self, _tmp0_);
	self->priv->tag_alignment = alignment;
	_tmp3_ = self->priv->_has_tags;
	if (_tmp3_) {
		GeeCollection* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = _g_object_ref0 (tags);
		_g_object_unref0 (self->priv->tags);
		self->priv->tags = _tmp4_;
		_tmp5_ = tag_make_user_visible_tag_list (tags);
		_g_object_unref0 (self->priv->user_visible_tag_list);
		self->priv->user_visible_tag_list = _tmp5_;
		_tmp6_ = self->priv->user_visible_tag_list;
		_tmp7_ = tag_make_tag_markup_string (_tmp6_, -1);
		_g_free0 (text);
		text = _tmp7_;
	} else {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("<small>.</small>");
		_g_free0 (text);
		text = _tmp8_;
	}
	_tmp10_ = self->priv->subtitle;
	if (_tmp10_ != NULL) {
		CheckerboardItemText* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = self->priv->subtitle;
		_tmp12_ = text;
		_tmp9_ = checkerboard_item_text_is_set_to (_tmp11_, _tmp12_, TRUE, alignment);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_g_free0 (text);
		return;
	}
	_tmp13_ = text;
	_tmp14_ = checkerboard_item_text_new (_tmp13_, alignment, TRUE);
	_checkerboard_item_text_unref0 (self->priv->subtitle);
	self->priv->subtitle = _tmp14_;
	if (self->priv->subtitle_visible) {
		checkerboard_item_recalc_size (self, "set_subtitle");
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
	_g_free0 (text);
}

void
checkerboard_item_clear_tags (CheckerboardItem* self)
{
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	checkerboard_item_clear_subtitle (self);
	checkerboard_item_set_has_tags (self, FALSE);
	_g_object_unref0 (self->priv->user_visible_tag_list);
	self->priv->user_visible_tag_list = NULL;
}

void
checkerboard_item_highlight_user_visible_tag (CheckerboardItem* self,
                                              gint index)
{
	GeeList* _tmp0_;
	gchar* text = NULL;
	GeeList* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	CheckerboardItemText* _tmp4_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_tmp0_ = self->priv->user_visible_tag_list;
	_vala_return_if_fail (_tmp0_ != NULL, "user_visible_tag_list != null");
	_tmp1_ = self->priv->user_visible_tag_list;
	_tmp2_ = tag_make_tag_markup_string (_tmp1_, index);
	text = _tmp2_;
	_tmp3_ = text;
	_tmp4_ = checkerboard_item_text_new (_tmp3_, self->priv->tag_alignment, TRUE);
	_checkerboard_item_text_unref0 (self->priv->subtitle);
	self->priv->subtitle = _tmp4_;
	if (self->priv->subtitle_visible) {
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
	_g_free0 (text);
}

Tag*
checkerboard_item_get_user_visible_tag (CheckerboardItem* self,
                                        gint index)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp3_;
	gpointer _tmp4_;
	Tag* result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_tmp0_ = self->priv->user_visible_tag_list;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	_vala_return_val_if_fail ((index >= 0) && (index < _tmp2_), "index >= 0 && index < user_visible_tag_list.size", NULL);
	_tmp3_ = self->priv->user_visible_tag_list;
	_tmp4_ = gee_list_get (_tmp3_, index);
	result = (Tag*) _tmp4_;
	return result;
}

PangoLayout*
checkerboard_item_get_tag_list_layout (CheckerboardItem* self)
{
	PangoLayout* _tmp0_ = NULL;
	gboolean _tmp1_;
	PangoLayout* result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_tmp1_ = self->priv->_has_tags;
	if (_tmp1_) {
		CheckerboardItemText* _tmp2_;
		PangoLayout* _tmp3_;
		_tmp2_ = self->priv->subtitle;
		_tmp3_ = checkerboard_item_text_get_pango_layout (_tmp2_, 0);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

void
checkerboard_item_get_subtitle_allocation (CheckerboardItem* self,
                                           GdkRectangle* result)
{
	CheckerboardItemText* _tmp0_;
	GdkRectangle _tmp1_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_tmp0_ = self->priv->subtitle;
	_tmp1_ = _tmp0_->allocation;
	*result = _tmp1_;
	return;
}

gchar*
checkerboard_item_get_subtitle (CheckerboardItem* self)
{
	gchar* _tmp0_ = NULL;
	CheckerboardItemText* _tmp1_;
	gchar* result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_tmp1_ = self->priv->subtitle;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->subtitle;
		_tmp3_ = checkerboard_item_text_get_text (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

void
checkerboard_item_set_subtitle (CheckerboardItem* self,
                                const gchar* text,
                                gboolean marked_up,
                                PangoAlignment alignment)
{
	gboolean _tmp0_ = FALSE;
	CheckerboardItemText* _tmp1_;
	CheckerboardItemText* _tmp3_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	g_return_if_fail (text != NULL);
	_tmp1_ = self->priv->subtitle;
	if (_tmp1_ != NULL) {
		CheckerboardItemText* _tmp2_;
		_tmp2_ = self->priv->subtitle;
		_tmp0_ = checkerboard_item_text_is_set_to (_tmp2_, text, marked_up, alignment);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = checkerboard_item_text_new (text, alignment, marked_up);
	_checkerboard_item_text_unref0 (self->priv->subtitle);
	self->priv->subtitle = _tmp3_;
	if (self->priv->subtitle_visible) {
		checkerboard_item_recalc_size (self, "set_subtitle");
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
}

void
checkerboard_item_clear_subtitle (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_tmp0_ = self->priv->subtitle;
	if (_tmp0_ == NULL) {
		return;
	}
	_checkerboard_item_text_unref0 (self->priv->subtitle);
	self->priv->subtitle = NULL;
	if (self->priv->subtitle_visible) {
		checkerboard_item_recalc_size (self, "clear_subtitle");
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
}

static void
checkerboard_item_set_subtitle_visible (CheckerboardItem* self,
                                        gboolean visible)
{
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	if (self->priv->subtitle_visible == visible) {
		return;
	}
	self->priv->subtitle_visible = visible;
	checkerboard_item_recalc_size (self, "set_subtitle_visible");
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
}

void
checkerboard_item_set_is_cursor (CheckerboardItem* self,
                                 gboolean is_cursor)
{
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	self->priv->is_cursor = is_cursor;
}

gboolean
checkerboard_item_get_is_cursor (CheckerboardItem* self)
{
	gboolean result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
	result = self->priv->is_cursor;
	return result;
}

static void
checkerboard_item_real_handle_mouse_motion (CheckerboardItem* self,
                                            gint x,
                                            gint y,
                                            gint height,
                                            gint width)
{
}

void
checkerboard_item_handle_mouse_motion (CheckerboardItem* self,
                                       gint x,
                                       gint y,
                                       gint height,
                                       gint width)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->handle_mouse_motion) {
		_klass_->handle_mouse_motion (self, x, y, height, width);
	}
}

static void
checkerboard_item_real_handle_mouse_leave (CheckerboardItem* self)
{
	checkerboard_item_unbrighten (self);
}

void
checkerboard_item_handle_mouse_leave (CheckerboardItem* self)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->handle_mouse_leave) {
		_klass_->handle_mouse_leave (self);
	}
}

static void
checkerboard_item_real_handle_mouse_enter (CheckerboardItem* self)
{
	checkerboard_item_brighten (self);
}

void
checkerboard_item_handle_mouse_enter (CheckerboardItem* self)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->handle_mouse_enter) {
		_klass_->handle_mouse_enter (self);
	}
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
checkerboard_item_real_notify_membership_changed (DataObject* base,
                                                  DataCollection* collection)
{
	CheckerboardItem * self;
	gboolean title_visible = FALSE;
	GValue* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue _tmp2_;
	gboolean _tmp3_;
	gboolean comment_visible = FALSE;
	GValue* _tmp4_ = NULL;
	GValue _tmp5_ = {0};
	GValue _tmp6_;
	gboolean _tmp7_;
	gboolean subtitle_visible = FALSE;
	GValue* _tmp8_ = NULL;
	GValue _tmp9_ = {0};
	GValue _tmp10_;
	gboolean _tmp11_;
	gboolean altered = FALSE;
	gboolean _tmp12_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	g_return_if_fail ((collection == NULL) || IS_DATA_COLLECTION (collection));
	_tmp0_ = g_new0 (GValue, 1);
	g_value_init (_tmp0_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp0_, TRUE);
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_TITLES, _tmp0_, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_value_get_boolean (&_tmp1_);
	G_IS_VALUE (&_tmp2_) ? (g_value_unset (&_tmp2_), NULL) : NULL;
	__vala_GValue_free0 (_tmp0_);
	title_visible = _tmp3_;
	_tmp4_ = g_new0 (GValue, 1);
	g_value_init (_tmp4_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp4_, TRUE);
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS, _tmp4_, &_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_value_get_boolean (&_tmp5_);
	G_IS_VALUE (&_tmp6_) ? (g_value_unset (&_tmp6_), NULL) : NULL;
	__vala_GValue_free0 (_tmp4_);
	comment_visible = _tmp7_;
	_tmp8_ = g_new0 (GValue, 1);
	g_value_init (_tmp8_, G_TYPE_BOOLEAN);
	g_value_set_boolean (_tmp8_, FALSE);
	data_object_get_collection_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES, _tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_value_get_boolean (&_tmp9_);
	G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
	__vala_GValue_free0 (_tmp8_);
	subtitle_visible = _tmp11_;
	altered = FALSE;
	if (self->priv->title_visible != title_visible) {
		self->priv->title_visible = title_visible;
		altered = TRUE;
	}
	if (self->priv->comment_visible != comment_visible) {
		self->priv->comment_visible = comment_visible;
		altered = TRUE;
	}
	if (self->priv->subtitle_visible != subtitle_visible) {
		self->priv->subtitle_visible = subtitle_visible;
		altered = TRUE;
	}
	if (altered) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = !dimensions_has_area (&self->requisition);
	}
	if (_tmp12_) {
		checkerboard_item_recalc_size (self, "notify_membership_changed");
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_membership_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), collection);
}

static void
checkerboard_item_real_notify_collection_property_set (DataObject* base,
                                                       const gchar* name,
                                                       GValue* old,
                                                       GValue* val)
{
	CheckerboardItem * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	GValue _tmp6_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (CHECKERBOARD_ITEM_PROP_SHOW_TITLES)))) {
		switch (0) {
			default:
			{
				GValue _tmp3_;
				_tmp3_ = *val;
				checkerboard_item_set_title_visible (self, g_value_get_boolean (&_tmp3_));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (CHECKERBOARD_ITEM_PROP_SHOW_COMMENTS)))) {
		switch (0) {
			default:
			{
				GValue _tmp4_;
				_tmp4_ = *val;
				checkerboard_item_set_comment_visible (self, g_value_get_boolean (&_tmp4_));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (CHECKERBOARD_ITEM_PROP_SHOW_SUBTITLES)))) {
		switch (0) {
			default:
			{
				GValue _tmp5_;
				_tmp5_ = *val;
				checkerboard_item_set_subtitle_visible (self, g_value_get_boolean (&_tmp5_));
				break;
			}
		}
	}
	_tmp6_ = *val;
	DATA_OBJECT_CLASS (checkerboard_item_parent_class)->notify_collection_property_set (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_OBJECT, DataObject), name, old, &_tmp6_);
}

gint
checkerboard_item_get_alignment_point (CheckerboardItem* self)
{
	Dimensions _tmp0_;
	gint result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
	_tmp0_ = self->priv->pixbuf_dim;
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH + CHECKERBOARD_ITEM_BORDER_WIDTH) + _tmp0_.height;
	return result;
}

static void
checkerboard_item_real_exposed (CheckerboardItem* self)
{
	self->priv->exposure = TRUE;
}

void
checkerboard_item_exposed (CheckerboardItem* self)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->exposed) {
		_klass_->exposed (self);
	}
}

static void
checkerboard_item_real_unexposed (CheckerboardItem* self)
{
	CheckerboardItemText* _tmp0_;
	CheckerboardItemText* _tmp2_;
	CheckerboardItemText* _tmp4_;
	self->priv->exposure = FALSE;
	_tmp0_ = self->priv->title;
	if (_tmp0_ != NULL) {
		CheckerboardItemText* _tmp1_;
		_tmp1_ = self->priv->title;
		checkerboard_item_text_clear_pango_layout (_tmp1_);
	}
	_tmp2_ = self->priv->comment;
	if (_tmp2_ != NULL) {
		CheckerboardItemText* _tmp3_;
		_tmp3_ = self->priv->comment;
		checkerboard_item_text_clear_pango_layout (_tmp3_);
	}
	_tmp4_ = self->priv->subtitle;
	if (_tmp4_ != NULL) {
		CheckerboardItemText* _tmp5_;
		_tmp5_ = self->priv->subtitle;
		checkerboard_item_text_clear_pango_layout (_tmp5_);
	}
}

void
checkerboard_item_unexposed (CheckerboardItem* self)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->unexposed) {
		_klass_->unexposed (self);
	}
}

static gboolean
checkerboard_item_real_is_exposed (CheckerboardItem* self)
{
	gboolean result;
	result = self->priv->exposure;
	return result;
}

gboolean
checkerboard_item_is_exposed (CheckerboardItem* self)
{
	CheckerboardItemClass* _klass_;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->is_exposed) {
		return _klass_->is_exposed (self);
	}
	return FALSE;
}

gboolean
checkerboard_item_has_image (CheckerboardItem* self)
{
	GdkPixbuf* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
	_tmp0_ = self->priv->pixbuf;
	result = _tmp0_ != NULL;
	return result;
}

GdkPixbuf*
checkerboard_item_get_image (CheckerboardItem* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_tmp0_ = self->priv->pixbuf;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
checkerboard_item_set_image (CheckerboardItem* self,
                             GdkPixbuf* pixbuf)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	Dimensions _tmp2_ = {0};
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()));
	_tmp0_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->priv->pixbuf);
	self->priv->pixbuf = _tmp0_;
	_tmp1_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->priv->display_pixbuf);
	self->priv->display_pixbuf = _tmp1_;
	dimensions_for_pixbuf (pixbuf, &_tmp2_);
	self->priv->pixbuf_dim = _tmp2_;
	checkerboard_item_recalc_size (self, "set_image");
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
}

void
checkerboard_item_clear_image (CheckerboardItem* self,
                               Dimensions* dim)
{
	gboolean had_image = FALSE;
	GdkPixbuf* _tmp0_;
	Dimensions _tmp1_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	g_return_if_fail (dim != NULL);
	_tmp0_ = self->priv->pixbuf;
	had_image = _tmp0_ != NULL;
	_g_object_unref0 (self->priv->pixbuf);
	self->priv->pixbuf = NULL;
	_g_object_unref0 (self->priv->display_pixbuf);
	self->priv->display_pixbuf = NULL;
	_tmp1_ = *dim;
	self->priv->pixbuf_dim = _tmp1_;
	checkerboard_item_recalc_size (self, "clear_image");
	if (had_image) {
		data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
}

gint
checkerboard_item_get_max_width (gint scale)
{
	gint result;
	result = (CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + scale;
	return result;
}

static void
checkerboard_item_recalc_size (CheckerboardItem* self,
                               const gchar* reason)
{
	Dimensions old_requisition = {0};
	Dimensions _tmp0_;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	CheckerboardItemText* _tmp3_;
	gint title_height = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	CheckerboardItemText* _tmp7_;
	gint comment_height = 0;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	CheckerboardItemText* _tmp11_;
	gint subtitle_height = 0;
	Dimensions _tmp13_;
	Dimensions _tmp14_;
	Dimensions _tmp15_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	g_return_if_fail (reason != NULL);
	_tmp0_ = self->requisition;
	old_requisition = _tmp0_;
	_tmp3_ = self->priv->title;
	if (_tmp3_ != NULL) {
		_tmp2_ = self->priv->title_visible;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		CheckerboardItemText* _tmp4_;
		_tmp4_ = self->priv->title;
		_tmp1_ = checkerboard_item_text_get_height (_tmp4_) + CHECKERBOARD_ITEM_LABEL_PADDING;
	} else {
		_tmp1_ = 0;
	}
	title_height = _tmp1_;
	_tmp7_ = self->priv->comment;
	if (_tmp7_ != NULL) {
		_tmp6_ = self->priv->comment_visible;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		CheckerboardItemText* _tmp8_;
		_tmp8_ = self->priv->comment;
		_tmp5_ = checkerboard_item_text_get_height (_tmp8_) + CHECKERBOARD_ITEM_LABEL_PADDING;
	} else {
		_tmp5_ = 0;
	}
	comment_height = _tmp5_;
	_tmp11_ = self->priv->subtitle;
	if (_tmp11_ != NULL) {
		_tmp10_ = self->priv->subtitle_visible;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		CheckerboardItemText* _tmp12_;
		_tmp12_ = self->priv->subtitle;
		_tmp9_ = checkerboard_item_text_get_height (_tmp12_) + CHECKERBOARD_ITEM_LABEL_PADDING;
	} else {
		_tmp9_ = 0;
	}
	subtitle_height = _tmp9_;
	_tmp13_ = self->priv->pixbuf_dim;
	self->requisition.width = ((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp13_.width;
	_tmp14_ = self->priv->pixbuf_dim;
	self->requisition.height = (((((CHECKERBOARD_ITEM_FRAME_WIDTH * 2) + (CHECKERBOARD_ITEM_BORDER_WIDTH * 2)) + _tmp14_.height) + title_height) + comment_height) + subtitle_height;
	_tmp15_ = old_requisition;
	if (!dimensions_approx_equals (&self->requisition, &_tmp15_, 1)) {
		data_view_notify_geometry_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
	}
}

void
checkerboard_item_get_border_dimensions (Dimensions* object_dim,
                                         gint border_width,
                                         Dimensions* result)
{
	Dimensions dimensions = {0};
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	g_return_if_fail (object_dim != NULL);
	dimensions_init (&dimensions, 0, 0);
	_tmp0_ = *object_dim;
	dimensions.width = _tmp0_.width + (border_width * 2);
	_tmp1_ = *object_dim;
	dimensions.height = _tmp1_.height + (border_width * 2);
	*result = dimensions;
	return;
}

void
checkerboard_item_get_border_origin (GdkPoint* object_origin,
                                     gint border_width,
                                     GdkPoint* result)
{
	GdkPoint origin = {0};
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	g_return_if_fail (object_origin != NULL);
	memset (&origin, 0, sizeof (GdkPoint));
	_tmp0_ = *object_origin;
	origin.x = _tmp0_.x - border_width;
	_tmp1_ = *object_origin;
	origin.y = _tmp1_.y - border_width;
	*result = origin;
	return;
}

static void
checkerboard_item_real_paint_shadow (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* dimensions,
                                     GdkPoint* origin,
                                     gint radius,
                                     gfloat initial_alpha)
{
	gdouble rgb_all = 0.0;
	GdkPoint _tmp0_;
	Dimensions _tmp1_;
	GdkPoint _tmp2_;
	GdkPoint _tmp3_;
	Dimensions _tmp4_;
	GdkPoint _tmp5_;
	Dimensions _tmp6_;
	GdkPoint _tmp7_;
	GdkPoint _tmp8_;
	Dimensions _tmp9_;
	cairo_pattern_t* lr = NULL;
	GdkPoint _tmp10_;
	Dimensions _tmp11_;
	GdkPoint _tmp12_;
	Dimensions _tmp13_;
	cairo_pattern_t* _tmp14_;
	GdkPoint _tmp15_;
	GdkPoint _tmp16_;
	Dimensions _tmp17_;
	Dimensions _tmp18_;
	cairo_pattern_t* td = NULL;
	GdkPoint _tmp19_;
	Dimensions _tmp20_;
	GdkPoint _tmp21_;
	Dimensions _tmp22_;
	cairo_pattern_t* _tmp23_;
	GdkPoint _tmp24_;
	Dimensions _tmp25_;
	GdkPoint _tmp26_;
	Dimensions _tmp27_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (dimensions != NULL);
	g_return_if_fail (origin != NULL);
	rgb_all = 0.0;
	_tmp0_ = *origin;
	_tmp1_ = *dimensions;
	_tmp2_ = *origin;
	checkerboard_item_paint_shadow_in_corner (self, ctx, _tmp0_.x + _tmp1_.width, _tmp2_.y + radius, rgb_all, (gfloat) radius, initial_alpha, (-0.5) * G_PI, (gdouble) 0);
	_tmp3_ = *origin;
	_tmp4_ = *dimensions;
	_tmp5_ = *origin;
	_tmp6_ = *dimensions;
	checkerboard_item_paint_shadow_in_corner (self, ctx, _tmp3_.x + _tmp4_.width, _tmp5_.y + _tmp6_.height, rgb_all, (gfloat) radius, initial_alpha, (gdouble) 0, 0.5 * G_PI);
	_tmp7_ = *origin;
	_tmp8_ = *origin;
	_tmp9_ = *dimensions;
	checkerboard_item_paint_shadow_in_corner (self, ctx, _tmp7_.x + radius, _tmp8_.y + _tmp9_.height, rgb_all, (gfloat) radius, initial_alpha, 0.5 * G_PI, G_PI);
	_tmp10_ = *origin;
	_tmp11_ = *dimensions;
	_tmp12_ = *origin;
	_tmp13_ = *dimensions;
	_tmp14_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) (_tmp10_.y + _tmp11_.height), (gdouble) 0, (gdouble) ((_tmp12_.y + _tmp13_.height) + radius));
	lr = _tmp14_;
	cairo_pattern_add_color_stop_rgba (lr, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) initial_alpha);
	cairo_pattern_add_color_stop_rgba (lr, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
	cairo_set_source (ctx, lr);
	_tmp15_ = *origin;
	_tmp16_ = *origin;
	_tmp17_ = *dimensions;
	_tmp18_ = *dimensions;
	cairo_rectangle (ctx, (gdouble) (_tmp15_.x + radius), (gdouble) (_tmp16_.y + _tmp17_.height), (gdouble) (_tmp18_.width - radius), (gdouble) radius);
	cairo_fill (ctx);
	_tmp19_ = *origin;
	_tmp20_ = *dimensions;
	_tmp21_ = *origin;
	_tmp22_ = *dimensions;
	_tmp23_ = cairo_pattern_create_linear ((gdouble) (_tmp19_.x + _tmp20_.width), (gdouble) 0, (gdouble) ((_tmp21_.x + _tmp22_.width) + radius), (gdouble) 0);
	td = _tmp23_;
	cairo_pattern_add_color_stop_rgba (td, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) initial_alpha);
	cairo_pattern_add_color_stop_rgba (td, 1.0, rgb_all, rgb_all, rgb_all, 0.0);
	cairo_set_source (ctx, td);
	_tmp24_ = *origin;
	_tmp25_ = *dimensions;
	_tmp26_ = *origin;
	_tmp27_ = *dimensions;
	cairo_rectangle (ctx, (gdouble) (_tmp24_.x + _tmp25_.width), (gdouble) (_tmp26_.y + radius), (gdouble) radius, (gdouble) (_tmp27_.height - radius));
	cairo_fill (ctx);
	_cairo_pattern_destroy0 (td);
	_cairo_pattern_destroy0 (lr);
}

void
checkerboard_item_paint_shadow (CheckerboardItem* self,
                                cairo_t* ctx,
                                Dimensions* dimensions,
                                GdkPoint* origin,
                                gint radius,
                                gfloat initial_alpha)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->paint_shadow) {
		_klass_->paint_shadow (self, ctx, dimensions, origin, radius, initial_alpha);
	}
}

void
checkerboard_item_paint_shadow_in_corner (CheckerboardItem* self,
                                          cairo_t* ctx,
                                          gint x,
                                          gint y,
                                          gdouble rgb_all,
                                          gfloat radius,
                                          gfloat initial_alpha,
                                          gdouble arc1,
                                          gdouble arc2)
{
	cairo_pattern_t* p = NULL;
	cairo_pattern_t* _tmp0_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	g_return_if_fail (ctx != NULL);
	_tmp0_ = cairo_pattern_create_radial ((gdouble) x, (gdouble) y, (gdouble) 0, (gdouble) x, (gdouble) y, (gdouble) radius);
	p = _tmp0_;
	cairo_pattern_add_color_stop_rgba (p, 0.0, rgb_all, rgb_all, rgb_all, (gdouble) initial_alpha);
	cairo_pattern_add_color_stop_rgba (p, 1.0, rgb_all, rgb_all, rgb_all, (gdouble) 0);
	cairo_set_source (ctx, p);
	cairo_move_to (ctx, (gdouble) x, (gdouble) y);
	cairo_arc (ctx, (gdouble) x, (gdouble) y, (gdouble) radius, arc1, arc2);
	cairo_close_path (ctx);
	cairo_fill (ctx);
	_cairo_pattern_destroy0 (p);
}

static void
checkerboard_item_real_paint_border (CheckerboardItem* self,
                                     cairo_t* ctx,
                                     Dimensions* object_dimensions,
                                     GdkPoint* object_origin,
                                     gint border_width)
{
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (object_dimensions != NULL);
	g_return_if_fail (object_origin != NULL);
	if (border_width == 1) {
		GdkPoint _tmp0_;
		GdkPoint _tmp1_;
		Dimensions _tmp2_;
		Dimensions _tmp3_;
		_tmp0_ = *object_origin;
		_tmp1_ = *object_origin;
		_tmp2_ = *object_dimensions;
		_tmp3_ = *object_dimensions;
		cairo_rectangle (ctx, (gdouble) (_tmp0_.x - border_width), (gdouble) (_tmp1_.y - border_width), (gdouble) (_tmp2_.width + (border_width * 2)), (gdouble) (_tmp3_.height + (border_width * 2)));
		cairo_fill (ctx);
	} else {
		Dimensions dimensions = {0};
		Dimensions _tmp4_;
		Dimensions _tmp5_ = {0};
		GdkPoint origin = {0};
		GdkPoint _tmp6_;
		GdkPoint _tmp7_ = {0};
		gdouble scale = 0.0;
		Dimensions _tmp8_;
		Dimensions _tmp9_;
		Dimensions _tmp10_;
		GdkPoint _tmp11_;
		_tmp4_ = *object_dimensions;
		checkerboard_item_get_border_dimensions (&_tmp4_, border_width, &_tmp5_);
		dimensions = _tmp5_;
		_tmp6_ = *object_origin;
		checkerboard_item_get_border_origin (&_tmp6_, border_width, &_tmp7_);
		origin = _tmp7_;
		_tmp8_ = *object_dimensions;
		_tmp9_ = *object_dimensions;
		scale = (gdouble) MAX (_tmp8_.width, _tmp9_.height);
		_tmp10_ = dimensions;
		_tmp11_ = origin;
		draw_rounded_corners_filled (ctx, &_tmp10_, &_tmp11_, 0.25 * scale);
	}
}

void
checkerboard_item_paint_border (CheckerboardItem* self,
                                cairo_t* ctx,
                                Dimensions* object_dimensions,
                                GdkPoint* object_origin,
                                gint border_width)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->paint_border) {
		_klass_->paint_border (self, ctx, object_dimensions, object_origin, border_width);
	}
}

static void
checkerboard_item_real_paint_image (CheckerboardItem* self,
                                    cairo_t* ctx,
                                    GdkPixbuf* pixbuf,
                                    GdkPoint* origin)
{
	GdkPoint _tmp0_;
	GdkPoint _tmp1_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()));
	g_return_if_fail (origin != NULL);
	_tmp0_ = *origin;
	_tmp1_ = *origin;
	paint_pixmap_with_background (ctx, pixbuf, _tmp0_.x, _tmp1_.y);
}

void
checkerboard_item_paint_image (CheckerboardItem* self,
                               cairo_t* ctx,
                               GdkPixbuf* pixbuf,
                               GdkPoint* origin)
{
	CheckerboardItemClass* _klass_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->paint_image) {
		_klass_->paint_image (self, ctx, pixbuf, origin);
	}
}

static gint
checkerboard_item_get_selection_border_width (CheckerboardItem* self,
                                              gint scale)
{
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
	_tmp1_ = thumbnail_get_MIN_SCALE ();
	_tmp2_ = _tmp1_;
	_tmp3_ = thumbnail_get_MAX_SCALE ();
	_tmp4_ = _tmp3_;
	if (scale <= ((_tmp2_ + _tmp4_) / 3)) {
		_tmp0_ = 5;
	} else {
		_tmp0_ = 4;
	}
	result = _tmp0_ + CHECKERBOARD_ITEM_BORDER_WIDTH;
	return result;
}

static GdkPixbuf*
checkerboard_item_real_get_top_left_trinket (CheckerboardItem* self,
                                             gint scale)
{
	GdkPixbuf* result;
	result = NULL;
	return result;
}

GdkPixbuf*
checkerboard_item_get_top_left_trinket (CheckerboardItem* self,
                                        gint scale)
{
	CheckerboardItemClass* _klass_;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->get_top_left_trinket) {
		return _klass_->get_top_left_trinket (self, scale);
	}
	return NULL;
}

static GdkPixbuf*
checkerboard_item_real_get_top_right_trinket (CheckerboardItem* self,
                                              gint scale)
{
	GdkPixbuf* result;
	result = NULL;
	return result;
}

GdkPixbuf*
checkerboard_item_get_top_right_trinket (CheckerboardItem* self,
                                         gint scale)
{
	CheckerboardItemClass* _klass_;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->get_top_right_trinket) {
		return _klass_->get_top_right_trinket (self, scale);
	}
	return NULL;
}

static GdkPixbuf*
checkerboard_item_real_get_bottom_left_trinket (CheckerboardItem* self,
                                                gint scale)
{
	GdkPixbuf* result;
	result = NULL;
	return result;
}

GdkPixbuf*
checkerboard_item_get_bottom_left_trinket (CheckerboardItem* self,
                                           gint scale)
{
	CheckerboardItemClass* _klass_;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->get_bottom_left_trinket) {
		return _klass_->get_bottom_left_trinket (self, scale);
	}
	return NULL;
}

static GdkPixbuf*
checkerboard_item_real_get_bottom_right_trinket (CheckerboardItem* self,
                                                 gint scale)
{
	GdkPixbuf* result;
	result = NULL;
	return result;
}

GdkPixbuf*
checkerboard_item_get_bottom_right_trinket (CheckerboardItem* self,
                                            gint scale)
{
	CheckerboardItemClass* _klass_;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), NULL);
	_klass_ = CHECKERBOARD_ITEM_GET_CLASS (self);
	if (_klass_->get_bottom_right_trinket) {
		return _klass_->get_bottom_right_trinket (self, scale);
	}
	return NULL;
}

void
checkerboard_item_paint (CheckerboardItem* self,
                         GtkStyleContext* style_context,
                         cairo_t* ctx,
                         GdkRGBA* bg_color,
                         GdkRGBA* selected_color,
                         GdkRGBA* border_color,
                         GdkRGBA* focus_color)
{
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkPoint pixbuf_origin = {0};
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkPixbuf* _tmp18_;
	gint text_y = 0;
	Dimensions _tmp25_;
	gboolean _tmp26_ = FALSE;
	CheckerboardItemText* _tmp27_;
	gboolean _tmp43_ = FALSE;
	CheckerboardItemText* _tmp44_;
	gboolean _tmp60_ = FALSE;
	CheckerboardItemText* _tmp61_;
	GdkRGBA _tmp76_;
	GdkRGBA _tmp77_;
	GdkRGBA _tmp78_;
	GdkRGBA _tmp79_;
	GdkPixbuf* trinket = NULL;
	GdkPixbuf* _tmp80_;
	GdkPixbuf* _tmp81_;
	GdkPixbuf* _tmp89_;
	GdkPixbuf* _tmp90_;
	GdkPixbuf* _tmp96_;
	GdkPixbuf* _tmp97_;
	GdkPixbuf* _tmp107_;
	GdkPixbuf* _tmp108_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (style_context, gtk_style_context_get_type ()));
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (bg_color != NULL);
	g_return_if_fail (selected_color != NULL);
	cairo_save (ctx);
	_tmp0_ = self->allocation;
	_tmp1_ = self->allocation;
	cairo_translate (ctx, (gdouble) (_tmp0_.x + CHECKERBOARD_ITEM_FRAME_WIDTH), (gdouble) (_tmp1_.y + CHECKERBOARD_ITEM_FRAME_WIDTH));
	memset (&pixbuf_origin, 0, sizeof (GdkPoint));
	pixbuf_origin.x = CHECKERBOARD_ITEM_BORDER_WIDTH;
	pixbuf_origin.y = CHECKERBOARD_ITEM_BORDER_WIDTH;
	cairo_set_line_width (ctx, (gdouble) CHECKERBOARD_ITEM_FRAME_WIDTH);
	_tmp2_ = *selected_color;
	_tmp3_ = *selected_color;
	_tmp4_ = *selected_color;
	_tmp5_ = *selected_color;
	cairo_set_source_rgba (ctx, _tmp2_.red, _tmp3_.green, _tmp4_.blue, _tmp5_.alpha);
	if (border_color != NULL) {
		Dimensions shadow_dim = {0};
		Dimensions _tmp6_;
		Dimensions _tmp7_;
		Dimensions _tmp8_;
		GdkPoint _tmp9_;
		cairo_save (ctx);
		dimensions_init (&shadow_dim, 0, 0);
		_tmp6_ = self->priv->pixbuf_dim;
		shadow_dim.width = _tmp6_.width + CHECKERBOARD_ITEM_BORDER_WIDTH;
		_tmp7_ = self->priv->pixbuf_dim;
		shadow_dim.height = _tmp7_.height + CHECKERBOARD_ITEM_BORDER_WIDTH;
		_tmp8_ = shadow_dim;
		_tmp9_ = pixbuf_origin;
		checkerboard_item_paint_shadow (self, ctx, &_tmp8_, &_tmp9_, CHECKERBOARD_ITEM_SHADOW_RADIUS, CHECKERBOARD_ITEM_SHADOW_INITIAL_ALPHA);
		cairo_restore (ctx);
	}
	if (self->priv->is_cursor) {
		Dimensions _tmp10_;
		GdkPoint _tmp11_;
		Dimensions _tmp12_;
		Dimensions _tmp13_;
		cairo_save (ctx);
		cairo_set_source_rgba (ctx, (*focus_color).red, (*focus_color).green, (*focus_color).blue, (*focus_color).alpha);
		_tmp10_ = self->priv->pixbuf_dim;
		_tmp11_ = pixbuf_origin;
		_tmp12_ = self->priv->pixbuf_dim;
		_tmp13_ = self->priv->pixbuf_dim;
		checkerboard_item_paint_border (self, ctx, &_tmp10_, &_tmp11_, checkerboard_item_get_selection_border_width (self, MAX (_tmp12_.width, _tmp13_.height)));
		cairo_restore (ctx);
	}
	if (data_view_is_selected (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView))) {
		Dimensions _tmp14_;
		GdkPoint _tmp15_;
		Dimensions _tmp16_;
		Dimensions _tmp17_;
		cairo_save (ctx);
		_tmp14_ = self->priv->pixbuf_dim;
		_tmp15_ = pixbuf_origin;
		_tmp16_ = self->priv->pixbuf_dim;
		_tmp17_ = self->priv->pixbuf_dim;
		checkerboard_item_paint_border (self, ctx, &_tmp14_, &_tmp15_, checkerboard_item_get_selection_border_width (self, MAX (_tmp16_.width, _tmp17_.height)));
		cairo_restore (ctx);
	}
	_tmp18_ = self->priv->display_pixbuf;
	if (_tmp18_ != NULL) {
		GdkRGBA _tmp19_;
		GdkRGBA _tmp20_;
		GdkRGBA _tmp21_;
		GdkRGBA _tmp22_;
		GdkPixbuf* _tmp23_;
		GdkPoint _tmp24_;
		cairo_save (ctx);
		_tmp19_ = *bg_color;
		_tmp20_ = *bg_color;
		_tmp21_ = *bg_color;
		_tmp22_ = *bg_color;
		cairo_set_source_rgba (ctx, _tmp19_.red, _tmp20_.green, _tmp21_.blue, _tmp22_.alpha);
		_tmp23_ = self->priv->display_pixbuf;
		_tmp24_ = pixbuf_origin;
		checkerboard_item_paint_image (self, ctx, _tmp23_, &_tmp24_);
		cairo_restore (ctx);
	}
	_tmp25_ = self->priv->pixbuf_dim;
	text_y = (_tmp25_.height + CHECKERBOARD_ITEM_FRAME_WIDTH) + CHECKERBOARD_ITEM_LABEL_PADDING;
	_tmp27_ = self->priv->title;
	if (_tmp27_ != NULL) {
		_tmp26_ = self->priv->title_visible;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		CheckerboardItemText* _tmp28_;
		CheckerboardItemText* _tmp29_;
		CheckerboardItemText* _tmp30_;
		Dimensions _tmp31_;
		CheckerboardItemText* _tmp32_;
		CheckerboardItemText* _tmp33_;
		CheckerboardItemText* _tmp34_;
		GdkRectangle _tmp35_;
		CheckerboardItemText* _tmp36_;
		GdkRectangle _tmp37_;
		CheckerboardItemText* _tmp38_;
		Dimensions _tmp39_;
		PangoLayout* _tmp40_;
		PangoLayout* _tmp41_;
		CheckerboardItemText* _tmp42_;
		_tmp28_ = self->priv->title;
		_tmp28_->allocation.x = 0;
		_tmp29_ = self->priv->title;
		_tmp29_->allocation.y = text_y;
		_tmp30_ = self->priv->title;
		_tmp31_ = self->priv->pixbuf_dim;
		_tmp30_->allocation.width = _tmp31_.width;
		_tmp32_ = self->priv->title;
		_tmp33_ = self->priv->title;
		_tmp32_->allocation.height = checkerboard_item_text_get_height (_tmp33_);
		_tmp34_ = self->priv->title;
		_tmp35_ = _tmp34_->allocation;
		_tmp36_ = self->priv->title;
		_tmp37_ = _tmp36_->allocation;
		_tmp38_ = self->priv->title;
		_tmp39_ = self->priv->pixbuf_dim;
		_tmp40_ = checkerboard_item_text_get_pango_layout (_tmp38_, _tmp39_.width);
		_tmp41_ = _tmp40_;
		gtk_render_layout (style_context, ctx, (gdouble) _tmp35_.x, (gdouble) _tmp37_.y, _tmp41_);
		_g_object_unref0 (_tmp41_);
		_tmp42_ = self->priv->title;
		text_y += checkerboard_item_text_get_height (_tmp42_) + CHECKERBOARD_ITEM_LABEL_PADDING;
	}
	_tmp44_ = self->priv->comment;
	if (_tmp44_ != NULL) {
		_tmp43_ = self->priv->comment_visible;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		CheckerboardItemText* _tmp45_;
		CheckerboardItemText* _tmp46_;
		CheckerboardItemText* _tmp47_;
		Dimensions _tmp48_;
		CheckerboardItemText* _tmp49_;
		CheckerboardItemText* _tmp50_;
		CheckerboardItemText* _tmp51_;
		GdkRectangle _tmp52_;
		CheckerboardItemText* _tmp53_;
		GdkRectangle _tmp54_;
		CheckerboardItemText* _tmp55_;
		Dimensions _tmp56_;
		PangoLayout* _tmp57_;
		PangoLayout* _tmp58_;
		CheckerboardItemText* _tmp59_;
		_tmp45_ = self->priv->comment;
		_tmp45_->allocation.x = 0;
		_tmp46_ = self->priv->comment;
		_tmp46_->allocation.y = text_y;
		_tmp47_ = self->priv->comment;
		_tmp48_ = self->priv->pixbuf_dim;
		_tmp47_->allocation.width = _tmp48_.width;
		_tmp49_ = self->priv->comment;
		_tmp50_ = self->priv->comment;
		_tmp49_->allocation.height = checkerboard_item_text_get_height (_tmp50_);
		_tmp51_ = self->priv->comment;
		_tmp52_ = _tmp51_->allocation;
		_tmp53_ = self->priv->comment;
		_tmp54_ = _tmp53_->allocation;
		_tmp55_ = self->priv->comment;
		_tmp56_ = self->priv->pixbuf_dim;
		_tmp57_ = checkerboard_item_text_get_pango_layout (_tmp55_, _tmp56_.width);
		_tmp58_ = _tmp57_;
		gtk_render_layout (style_context, ctx, (gdouble) _tmp52_.x, (gdouble) _tmp54_.y, _tmp58_);
		_g_object_unref0 (_tmp58_);
		_tmp59_ = self->priv->comment;
		text_y += checkerboard_item_text_get_height (_tmp59_) + CHECKERBOARD_ITEM_LABEL_PADDING;
	}
	_tmp61_ = self->priv->subtitle;
	if (_tmp61_ != NULL) {
		_tmp60_ = self->priv->subtitle_visible;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		CheckerboardItemText* _tmp62_;
		CheckerboardItemText* _tmp63_;
		CheckerboardItemText* _tmp64_;
		Dimensions _tmp65_;
		CheckerboardItemText* _tmp66_;
		CheckerboardItemText* _tmp67_;
		CheckerboardItemText* _tmp68_;
		GdkRectangle _tmp69_;
		CheckerboardItemText* _tmp70_;
		GdkRectangle _tmp71_;
		CheckerboardItemText* _tmp72_;
		Dimensions _tmp73_;
		PangoLayout* _tmp74_;
		PangoLayout* _tmp75_;
		_tmp62_ = self->priv->subtitle;
		_tmp62_->allocation.x = 0;
		_tmp63_ = self->priv->subtitle;
		_tmp63_->allocation.y = text_y;
		_tmp64_ = self->priv->subtitle;
		_tmp65_ = self->priv->pixbuf_dim;
		_tmp64_->allocation.width = _tmp65_.width;
		_tmp66_ = self->priv->subtitle;
		_tmp67_ = self->priv->subtitle;
		_tmp66_->allocation.height = checkerboard_item_text_get_height (_tmp67_);
		_tmp68_ = self->priv->subtitle;
		_tmp69_ = _tmp68_->allocation;
		_tmp70_ = self->priv->subtitle;
		_tmp71_ = _tmp70_->allocation;
		_tmp72_ = self->priv->subtitle;
		_tmp73_ = self->priv->pixbuf_dim;
		_tmp74_ = checkerboard_item_text_get_pango_layout (_tmp72_, _tmp73_.width);
		_tmp75_ = _tmp74_;
		gtk_render_layout (style_context, ctx, (gdouble) _tmp69_.x, (gdouble) _tmp71_.y, _tmp75_);
		_g_object_unref0 (_tmp75_);
	}
	_tmp76_ = *selected_color;
	_tmp77_ = *selected_color;
	_tmp78_ = *selected_color;
	_tmp79_ = *selected_color;
	cairo_set_source_rgba (ctx, _tmp76_.red, _tmp77_.green, _tmp78_.blue, _tmp79_.alpha);
	_tmp80_ = checkerboard_item_get_bottom_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
	trinket = _tmp80_;
	_tmp81_ = trinket;
	if (_tmp81_ != NULL) {
		gint x = 0;
		GdkPoint _tmp82_;
		gint y = 0;
		GdkPoint _tmp83_;
		Dimensions _tmp84_;
		GdkPixbuf* _tmp85_;
		GdkPixbuf* _tmp86_;
		GdkPixbuf* _tmp87_;
		GdkPixbuf* _tmp88_;
		_tmp82_ = pixbuf_origin;
		x = (_tmp82_.x + CHECKERBOARD_ITEM_TRINKET_PADDING) + checkerboard_item_get_horizontal_trinket_offset (self);
		_tmp83_ = pixbuf_origin;
		_tmp84_ = self->priv->pixbuf_dim;
		_tmp85_ = trinket;
		y = ((_tmp83_.y + _tmp84_.height) - gdk_pixbuf_get_height (_tmp85_)) - CHECKERBOARD_ITEM_TRINKET_PADDING;
		_tmp86_ = trinket;
		gdk_cairo_set_source_pixbuf (ctx, _tmp86_, (gdouble) x, (gdouble) y);
		_tmp87_ = trinket;
		_tmp88_ = trinket;
		cairo_rectangle (ctx, (gdouble) x, (gdouble) y, (gdouble) gdk_pixbuf_get_width (_tmp87_), (gdouble) gdk_pixbuf_get_height (_tmp88_));
		cairo_fill (ctx);
	}
	_tmp89_ = checkerboard_item_get_top_left_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
	_g_object_unref0 (trinket);
	trinket = _tmp89_;
	_tmp90_ = trinket;
	if (_tmp90_ != NULL) {
		gint x = 0;
		GdkPoint _tmp91_;
		gint y = 0;
		GdkPoint _tmp92_;
		GdkPixbuf* _tmp93_;
		GdkPixbuf* _tmp94_;
		GdkPixbuf* _tmp95_;
		_tmp91_ = pixbuf_origin;
		x = (_tmp91_.x + CHECKERBOARD_ITEM_TRINKET_PADDING) + checkerboard_item_get_horizontal_trinket_offset (self);
		_tmp92_ = pixbuf_origin;
		y = _tmp92_.y + CHECKERBOARD_ITEM_TRINKET_PADDING;
		_tmp93_ = trinket;
		gdk_cairo_set_source_pixbuf (ctx, _tmp93_, (gdouble) x, (gdouble) y);
		_tmp94_ = trinket;
		_tmp95_ = trinket;
		cairo_rectangle (ctx, (gdouble) x, (gdouble) y, (gdouble) gdk_pixbuf_get_width (_tmp94_), (gdouble) gdk_pixbuf_get_height (_tmp95_));
		cairo_fill (ctx);
	}
	_tmp96_ = checkerboard_item_get_top_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
	_g_object_unref0 (trinket);
	trinket = _tmp96_;
	_tmp97_ = trinket;
	if (_tmp97_ != NULL) {
		gint x = 0;
		GdkPoint _tmp98_;
		Dimensions _tmp99_;
		GdkPixbuf* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gint y = 0;
		GdkPoint _tmp103_;
		GdkPixbuf* _tmp104_;
		GdkPixbuf* _tmp105_;
		GdkPixbuf* _tmp106_;
		_tmp98_ = pixbuf_origin;
		_tmp99_ = self->priv->pixbuf_dim;
		_tmp100_ = trinket;
		_tmp101_ = gdk_pixbuf_get_width (_tmp100_);
		_tmp102_ = _tmp101_;
		x = (((_tmp98_.x + _tmp99_.width) - _tmp102_) - checkerboard_item_get_horizontal_trinket_offset (self)) - CHECKERBOARD_ITEM_TRINKET_PADDING;
		_tmp103_ = pixbuf_origin;
		y = _tmp103_.y + CHECKERBOARD_ITEM_TRINKET_PADDING;
		_tmp104_ = trinket;
		gdk_cairo_set_source_pixbuf (ctx, _tmp104_, (gdouble) x, (gdouble) y);
		_tmp105_ = trinket;
		_tmp106_ = trinket;
		cairo_rectangle (ctx, (gdouble) x, (gdouble) y, (gdouble) gdk_pixbuf_get_width (_tmp105_), (gdouble) gdk_pixbuf_get_height (_tmp106_));
		cairo_fill (ctx);
	}
	_tmp107_ = checkerboard_item_get_bottom_right_trinket (self, CHECKERBOARD_ITEM_TRINKET_SCALE);
	_g_object_unref0 (trinket);
	trinket = _tmp107_;
	_tmp108_ = trinket;
	if (_tmp108_ != NULL) {
		gint x = 0;
		GdkPoint _tmp109_;
		Dimensions _tmp110_;
		GdkPixbuf* _tmp111_;
		gint _tmp112_;
		gint _tmp113_;
		gint y = 0;
		GdkPoint _tmp114_;
		Dimensions _tmp115_;
		GdkPixbuf* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		GdkPixbuf* _tmp119_;
		GdkPixbuf* _tmp120_;
		GdkPixbuf* _tmp121_;
		_tmp109_ = pixbuf_origin;
		_tmp110_ = self->priv->pixbuf_dim;
		_tmp111_ = trinket;
		_tmp112_ = gdk_pixbuf_get_width (_tmp111_);
		_tmp113_ = _tmp112_;
		x = (((_tmp109_.x + _tmp110_.width) - _tmp113_) - checkerboard_item_get_horizontal_trinket_offset (self)) - CHECKERBOARD_ITEM_TRINKET_PADDING;
		_tmp114_ = pixbuf_origin;
		_tmp115_ = self->priv->pixbuf_dim;
		_tmp116_ = trinket;
		_tmp117_ = gdk_pixbuf_get_height (_tmp116_);
		_tmp118_ = _tmp117_;
		y = ((_tmp114_.y + _tmp115_.height) - _tmp118_) - CHECKERBOARD_ITEM_TRINKET_PADDING;
		_tmp119_ = trinket;
		gdk_cairo_set_source_pixbuf (ctx, _tmp119_, (gdouble) x, (gdouble) y);
		_tmp120_ = trinket;
		_tmp121_ = trinket;
		cairo_rectangle (ctx, (gdouble) x, (gdouble) y, (gdouble) gdk_pixbuf_get_width (_tmp120_), (gdouble) gdk_pixbuf_get_height (_tmp121_));
		cairo_fill (ctx);
	}
	cairo_restore (ctx);
	_g_object_unref0 (trinket);
}

void
checkerboard_item_set_horizontal_trinket_offset (CheckerboardItem* self,
                                                 gint horizontal_trinket_offset)
{
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_vala_assert (horizontal_trinket_offset >= 0, "horizontal_trinket_offset >= 0");
	self->priv->horizontal_trinket_offset = horizontal_trinket_offset;
}

gint
checkerboard_item_get_horizontal_trinket_offset (CheckerboardItem* self)
{
	gint result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
	result = self->priv->horizontal_trinket_offset;
	return result;
}

void
checkerboard_item_set_grid_coordinates (CheckerboardItem* self,
                                        gint col,
                                        gint row)
{
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	self->priv->col = col;
	self->priv->row = row;
}

gint
checkerboard_item_get_column (CheckerboardItem* self)
{
	gint result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
	result = self->priv->col;
	return result;
}

gint
checkerboard_item_get_row (CheckerboardItem* self)
{
	gint result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), 0);
	result = self->priv->row;
	return result;
}

void
checkerboard_item_brighten (CheckerboardItem* self)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_tmp1_ = self->priv->brightened;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GdkPixbuf* _tmp2_;
		_tmp2_ = self->priv->pixbuf;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->pixbuf;
	_tmp4_ = gdk_pixbuf_copy (_tmp3_);
	_g_object_unref0 (self->priv->brightened);
	self->priv->brightened = _tmp4_;
	_tmp5_ = self->priv->brightened;
	shift_colors (_tmp5_, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, CHECKERBOARD_ITEM_BRIGHTEN_SHIFT, 0);
	_tmp6_ = self->priv->brightened;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->display_pixbuf);
	self->priv->display_pixbuf = _tmp7_;
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
}

void
checkerboard_item_unbrighten (CheckerboardItem* self)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	_tmp1_ = self->priv->brightened;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GdkPixbuf* _tmp2_;
		_tmp2_ = self->priv->pixbuf;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_g_object_unref0 (self->priv->brightened);
	self->priv->brightened = NULL;
	_tmp3_ = self->priv->pixbuf;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->display_pixbuf);
	self->priv->display_pixbuf = _tmp4_;
	data_view_notify_view_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_VIEW, DataView));
}

static void
checkerboard_item_real_visibility_changed (DataView* base,
                                           gboolean visible)
{
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	if (!visible) {
		checkerboard_item_unbrighten (self);
	}
	DATA_VIEW_CLASS (checkerboard_item_parent_class)->visibility_changed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_VIEW, ThumbnailView), TYPE_DATA_VIEW, DataView), visible);
}

static gboolean
checkerboard_item_query_tooltip_on_text (CheckerboardItem* self,
                                         CheckerboardItemText* text,
                                         GtkTooltip* tooltip)
{
	PangoLayout* _tmp0_;
	PangoLayout* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM_TEXT (text), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (tooltip, gtk_tooltip_get_type ()), FALSE);
	_tmp0_ = checkerboard_item_text_get_pango_layout (text, 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = !pango_layout_is_ellipsized (_tmp1_);
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	if (checkerboard_item_text_is_marked_up (text)) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = checkerboard_item_text_get_text (text);
		_tmp4_ = _tmp3_;
		gtk_tooltip_set_markup (tooltip, _tmp4_);
		_g_free0 (_tmp4_);
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = checkerboard_item_text_get_text (text);
		_tmp6_ = _tmp5_;
		gtk_tooltip_set_text (tooltip, _tmp6_);
		_g_free0 (_tmp6_);
	}
	result = TRUE;
	return result;
}

gboolean
checkerboard_item_query_tooltip (CheckerboardItem* self,
                                 gint x,
                                 gint y,
                                 GtkTooltip* tooltip)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	CheckerboardItemText* _tmp2_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	CheckerboardItemText* _tmp8_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	CheckerboardItemText* _tmp14_;
	gboolean result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (tooltip, gtk_tooltip_get_type ()), FALSE);
	_tmp2_ = self->priv->title;
	if (_tmp2_ != NULL) {
		_tmp1_ = self->priv->title_visible;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		CheckerboardItemText* _tmp3_;
		GdkRectangle _tmp4_;
		_tmp3_ = self->priv->title;
		_tmp4_ = _tmp3_->allocation;
		_tmp0_ = coord_in_rectangle (x, y, &_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		CheckerboardItemText* _tmp5_;
		_tmp5_ = self->priv->title;
		result = checkerboard_item_query_tooltip_on_text (self, _tmp5_, tooltip);
		return result;
	}
	_tmp8_ = self->priv->comment;
	if (_tmp8_ != NULL) {
		_tmp7_ = self->priv->comment_visible;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		CheckerboardItemText* _tmp9_;
		GdkRectangle _tmp10_;
		_tmp9_ = self->priv->comment;
		_tmp10_ = _tmp9_->allocation;
		_tmp6_ = coord_in_rectangle (x, y, &_tmp10_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		CheckerboardItemText* _tmp11_;
		_tmp11_ = self->priv->comment;
		result = checkerboard_item_query_tooltip_on_text (self, _tmp11_, tooltip);
		return result;
	}
	_tmp14_ = self->priv->subtitle;
	if (_tmp14_ != NULL) {
		_tmp13_ = self->priv->subtitle_visible;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		CheckerboardItemText* _tmp15_;
		GdkRectangle _tmp16_;
		_tmp15_ = self->priv->subtitle;
		_tmp16_ = _tmp15_->allocation;
		_tmp12_ = coord_in_rectangle (x, y, &_tmp16_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		CheckerboardItemText* _tmp17_;
		_tmp17_ = self->priv->subtitle;
		result = checkerboard_item_query_tooltip_on_text (self, _tmp17_, tooltip);
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
checkerboard_item_get_has_tags (CheckerboardItem* self)
{
	gboolean result;
	g_return_val_if_fail (IS_CHECKERBOARD_ITEM (self), FALSE);
	result = self->priv->_has_tags;
	return result;
}

static void
checkerboard_item_set_has_tags (CheckerboardItem* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (IS_CHECKERBOARD_ITEM (self));
	old_value = checkerboard_item_get_has_tags (self);
	if (old_value != value) {
		self->priv->_has_tags = value;
		g_object_notify_by_pspec ((GObject *) self, checkerboard_item_properties[CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY]);
	}
}

static void
checkerboard_item_class_init (CheckerboardItemClass * klass,
                              gpointer klass_data)
{
	checkerboard_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CheckerboardItem_private_offset);
	((DataObjectClass *) klass)->get_name = (gchar* (*) (DataObject*)) checkerboard_item_real_get_name;
	((CheckerboardItemClass *) klass)->handle_mouse_motion = (void (*) (CheckerboardItem*, gint, gint, gint, gint)) checkerboard_item_real_handle_mouse_motion;
	((CheckerboardItemClass *) klass)->handle_mouse_leave = (void (*) (CheckerboardItem*)) checkerboard_item_real_handle_mouse_leave;
	((CheckerboardItemClass *) klass)->handle_mouse_enter = (void (*) (CheckerboardItem*)) checkerboard_item_real_handle_mouse_enter;
	((DataObjectClass *) klass)->notify_membership_changed = (void (*) (DataObject*, DataCollection*)) checkerboard_item_real_notify_membership_changed;
	((DataObjectClass *) klass)->notify_collection_property_set = (void (*) (DataObject*, const gchar*, GValue*, GValue*)) checkerboard_item_real_notify_collection_property_set;
	((CheckerboardItemClass *) klass)->exposed = (void (*) (CheckerboardItem*)) checkerboard_item_real_exposed;
	((CheckerboardItemClass *) klass)->unexposed = (void (*) (CheckerboardItem*)) checkerboard_item_real_unexposed;
	((CheckerboardItemClass *) klass)->is_exposed = (gboolean (*) (CheckerboardItem*)) checkerboard_item_real_is_exposed;
	((CheckerboardItemClass *) klass)->paint_shadow = (void (*) (CheckerboardItem*, cairo_t*, Dimensions*, GdkPoint*, gint, gfloat)) checkerboard_item_real_paint_shadow;
	((CheckerboardItemClass *) klass)->paint_border = (void (*) (CheckerboardItem*, cairo_t*, Dimensions*, GdkPoint*, gint)) checkerboard_item_real_paint_border;
	((CheckerboardItemClass *) klass)->paint_image = (void (*) (CheckerboardItem*, cairo_t*, GdkPixbuf*, GdkPoint*)) checkerboard_item_real_paint_image;
	((CheckerboardItemClass *) klass)->get_top_left_trinket = (GdkPixbuf* (*) (CheckerboardItem*, gint)) checkerboard_item_real_get_top_left_trinket;
	((CheckerboardItemClass *) klass)->get_top_right_trinket = (GdkPixbuf* (*) (CheckerboardItem*, gint)) checkerboard_item_real_get_top_right_trinket;
	((CheckerboardItemClass *) klass)->get_bottom_left_trinket = (GdkPixbuf* (*) (CheckerboardItem*, gint)) checkerboard_item_real_get_bottom_left_trinket;
	((CheckerboardItemClass *) klass)->get_bottom_right_trinket = (GdkPixbuf* (*) (CheckerboardItem*, gint)) checkerboard_item_real_get_bottom_right_trinket;
	((DataViewClass *) klass)->visibility_changed = (void (*) (DataView*, gboolean)) checkerboard_item_real_visibility_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_checkerboard_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_checkerboard_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = checkerboard_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY, checkerboard_item_properties[CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY] = g_param_spec_boolean ("has-tags", "has-tags", "has-tags", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
checkerboard_item_instance_init (CheckerboardItem * self,
                                 gpointer klass)
{
	self->priv = checkerboard_item_get_instance_private (self);
	dimensions_init (&self->requisition, 0, 0);
	memset (&self->allocation, 0, sizeof (GdkRectangle));
	self->priv->exposure = FALSE;
	self->priv->title = NULL;
	self->priv->title_visible = TRUE;
	self->priv->comment = NULL;
	self->priv->comment_visible = TRUE;
	self->priv->subtitle = NULL;
	self->priv->subtitle_visible = FALSE;
	self->priv->is_cursor = FALSE;
	self->priv->tag_alignment = PANGO_ALIGN_LEFT;
	self->priv->user_visible_tag_list = NULL;
	self->priv->pixbuf = NULL;
	self->priv->display_pixbuf = NULL;
	self->priv->brightened = NULL;
	dimensions_init (&self->priv->pixbuf_dim, 0, 0);
	self->priv->col = -1;
	self->priv->row = -1;
	self->priv->horizontal_trinket_offset = 0;
}

static void
checkerboard_item_finalize (GObject * obj)
{
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	_checkerboard_item_text_unref0 (self->priv->title);
	_checkerboard_item_text_unref0 (self->priv->comment);
	_checkerboard_item_text_unref0 (self->priv->subtitle);
	_g_object_unref0 (self->priv->user_visible_tag_list);
	_g_object_unref0 (self->priv->tags);
	_g_object_unref0 (self->priv->pixbuf);
	_g_object_unref0 (self->priv->display_pixbuf);
	_g_object_unref0 (self->priv->brightened);
	G_OBJECT_CLASS (checkerboard_item_parent_class)->finalize (obj);
}

static GType
checkerboard_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CheckerboardItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) checkerboard_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckerboardItem), 0, (GInstanceInitFunc) checkerboard_item_instance_init, NULL };
	GType checkerboard_item_type_id;
	checkerboard_item_type_id = g_type_register_static (TYPE_THUMBNAIL_VIEW, "CheckerboardItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	CheckerboardItem_private_offset = g_type_add_instance_private (checkerboard_item_type_id, sizeof (CheckerboardItemPrivate));
	return checkerboard_item_type_id;
}

GType
checkerboard_item_get_type (void)
{
	static volatile gsize checkerboard_item_type_id__once = 0;
	if (g_once_init_enter (&checkerboard_item_type_id__once)) {
		GType checkerboard_item_type_id;
		checkerboard_item_type_id = checkerboard_item_get_type_once ();
		g_once_init_leave (&checkerboard_item_type_id__once, checkerboard_item_type_id);
	}
	return checkerboard_item_type_id__once;
}

static void
_vala_checkerboard_item_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	switch (property_id) {
		case CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY:
		g_value_set_boolean (value, checkerboard_item_get_has_tags (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_checkerboard_item_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	CheckerboardItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHECKERBOARD_ITEM, CheckerboardItem);
	switch (property_id) {
		case CHECKERBOARD_ITEM_HAS_TAGS_PROPERTY:
		checkerboard_item_set_has_tags (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

