/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_svcctl.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
static enum ndr_err_code ndr_push_SERVICE_LOCK_STATUS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_LOCK_STATUS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->is_locked));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lock_owner));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->lock_duration));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lock_owner) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lock_owner, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lock_owner, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lock_owner, ndr_charset_length(r->lock_owner, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_LOCK_STATUS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_LOCK_STATUS *r)
{
	uint32_t _ptr_lock_owner;
	uint32_t size_lock_owner_1 = 0;
	uint32_t length_lock_owner_1 = 0;
	TALLOC_CTX *_mem_save_lock_owner_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->is_locked));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lock_owner));
		if (_ptr_lock_owner) {
			NDR_PULL_ALLOC(ndr, r->lock_owner);
		} else {
			r->lock_owner = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->lock_duration));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lock_owner) {
			_mem_save_lock_owner_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lock_owner, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lock_owner));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lock_owner));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lock_owner, &size_lock_owner_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lock_owner, &length_lock_owner_1));
			if (length_lock_owner_1 > size_lock_owner_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lock_owner_1, length_lock_owner_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lock_owner_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lock_owner, length_lock_owner_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_owner_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_LOCK_STATUS(struct ndr_print *ndr, const char *name, const struct SERVICE_LOCK_STATUS *r)
{
	ndr_print_struct(ndr, name, "SERVICE_LOCK_STATUS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "is_locked", r->is_locked);
	ndr_print_ptr(ndr, "lock_owner", r->lock_owner);
	ndr->depth++;
	if (r->lock_owner) {
		ndr_print_string(ndr, "lock_owner", r->lock_owner);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "lock_duration", r->lock_duration);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ServiceStatus(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum svcctl_ServiceStatus r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ServiceStatus(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum svcctl_ServiceStatus *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ServiceStatus(struct ndr_print *ndr, const char *name, enum svcctl_ServiceStatus r)
{
	const char *val = NULL;

	switch (r) {
		case SVCCTL_STATE_UNKNOWN: val = "SVCCTL_STATE_UNKNOWN"; break;
		case SVCCTL_STOPPED: val = "SVCCTL_STOPPED"; break;
		case SVCCTL_START_PENDING: val = "SVCCTL_START_PENDING"; break;
		case SVCCTL_STOP_PENDING: val = "SVCCTL_STOP_PENDING"; break;
		case SVCCTL_RUNNING: val = "SVCCTL_RUNNING"; break;
		case SVCCTL_CONTINUE_PENDING: val = "SVCCTL_CONTINUE_PENDING"; break;
		case SVCCTL_PAUSE_PENDING: val = "SVCCTL_PAUSE_PENDING"; break;
		case SVCCTL_PAUSED: val = "SVCCTL_PAUSED"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_svcctl_ControlsAccepted(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ControlsAccepted(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ControlsAccepted(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SVCCTL_ACCEPT_STOP", SVCCTL_ACCEPT_STOP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SVCCTL_ACCEPT_PAUSE_CONTINUE", SVCCTL_ACCEPT_PAUSE_CONTINUE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SVCCTL_ACCEPT_SHUTDOWN", SVCCTL_ACCEPT_SHUTDOWN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SVCCTL_ACCEPT_PARAMCHANGE", SVCCTL_ACCEPT_PARAMCHANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SVCCTL_ACCEPT_NETBINDCHANGE", SVCCTL_ACCEPT_NETBINDCHANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SVCCTL_ACCEPT_HARDWAREPROFILECHANGE", SVCCTL_ACCEPT_HARDWAREPROFILECHANGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SVCCTL_ACCEPT_POWEREVENT", SVCCTL_ACCEPT_POWEREVENT, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_STATUS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_STATUS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_svcctl_ServiceStatus(ndr, NDR_SCALARS, r->state));
		NDR_CHECK(ndr_push_svcctl_ControlsAccepted(ndr, NDR_SCALARS, r->controls_accepted));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->win32_exit_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->service_exit_code));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->check_point));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->wait_hint));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_STATUS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_STATUS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_svcctl_ServiceStatus(ndr, NDR_SCALARS, &r->state));
		NDR_CHECK(ndr_pull_svcctl_ControlsAccepted(ndr, NDR_SCALARS, &r->controls_accepted));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->win32_exit_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->service_exit_code));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->check_point));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->wait_hint));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_STATUS(struct ndr_print *ndr, const char *name, const struct SERVICE_STATUS *r)
{
	ndr_print_struct(ndr, name, "SERVICE_STATUS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "type", r->type);
	ndr_print_svcctl_ServiceStatus(ndr, "state", r->state);
	ndr_print_svcctl_ControlsAccepted(ndr, "controls_accepted", r->controls_accepted);
	ndr_print_WERROR(ndr, "win32_exit_code", r->win32_exit_code);
	ndr_print_uint32(ndr, "service_exit_code", r->service_exit_code);
	ndr_print_uint32(ndr, "check_point", r->check_point);
	ndr_print_uint32(ndr, "wait_hint", r->wait_hint);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVICE_STATUS_PROCESS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_STATUS_PROCESS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_SERVICE_STATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->process_id));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->service_flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVICE_STATUS_PROCESS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_STATUS_PROCESS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_SERVICE_STATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->process_id));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->service_flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_SERVICE_STATUS_PROCESS(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct SERVICE_STATUS_PROCESS *r)
{
	ndr_print_SERVICE_STATUS_PROCESS(ndr, name, r);
}

_PUBLIC_ void ndr_print_SERVICE_STATUS_PROCESS(struct ndr_print *ndr, const char *name, const struct SERVICE_STATUS_PROCESS *r)
{
	ndr_print_struct(ndr, name, "SERVICE_STATUS_PROCESS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_SERVICE_STATUS(ndr, "status", &r->status);
	ndr_print_uint32(ndr, "process_id", r->process_id);
	ndr_print_uint32(ndr, "service_flags", r->service_flags);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_ENUM_SERVICE_STATUSW(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ENUM_SERVICE_STATUSW *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->service_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->display_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_SERVICE_STATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->service_name) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->service_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->service_name));
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->service_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->display_name) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->display_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->display_name));
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->display_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ENUM_SERVICE_STATUSW(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ENUM_SERVICE_STATUSW *r)
{
	uint32_t _ptr_service_name;
	TALLOC_CTX *_mem_save_service_name_0 = NULL;
	uint32_t _ptr_display_name;
	TALLOC_CTX *_mem_save_display_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
			if (_ptr_service_name) {
				NDR_PULL_ALLOC(ndr, r->service_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->service_name, _ptr_service_name));
			} else {
				r->service_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
			if (_ptr_display_name) {
				NDR_PULL_ALLOC(ndr, r->display_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->display_name, _ptr_display_name));
			} else {
				r->display_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_SERVICE_STATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->service_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->service_name));
				_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->service_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->service_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->display_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->display_name));
				_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->display_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->display_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ENUM_SERVICE_STATUSW(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ENUM_SERVICE_STATUSW *r)
{
	ndr_print_ENUM_SERVICE_STATUSW(ndr, name, r);
}

_PUBLIC_ void ndr_print_ENUM_SERVICE_STATUSW(struct ndr_print *ndr, const char *name, const struct ENUM_SERVICE_STATUSW *r)
{
	ndr_print_struct(ndr, name, "ENUM_SERVICE_STATUSW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "service_name", r->service_name);
		ndr->depth++;
		if (r->service_name) {
			ndr_print_string(ndr, "service_name", r->service_name);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "display_name", r->display_name);
		ndr->depth++;
		if (r->display_name) {
			ndr_print_string(ndr, "display_name", r->display_name);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr_print_SERVICE_STATUS(ndr, "status", &r->status);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_ENUM_SERVICE_STATUSW(const struct ENUM_SERVICE_STATUSW *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_ENUM_SERVICE_STATUSW);
}

_PUBLIC_ enum ndr_err_code ndr_push_ENUM_SERVICE_STATUSA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ENUM_SERVICE_STATUSA *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->service_name));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->display_name));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_SERVICE_STATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->service_name) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->service_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->service_name));
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->service_name));
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->display_name) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->display_name));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->display_name));
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->display_name));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ENUM_SERVICE_STATUSA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ENUM_SERVICE_STATUSA *r)
{
	uint32_t _ptr_service_name;
	TALLOC_CTX *_mem_save_service_name_0 = NULL;
	uint32_t _ptr_display_name;
	TALLOC_CTX *_mem_save_display_name_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
			if (_ptr_service_name) {
				NDR_PULL_ALLOC(ndr, r->service_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->service_name, _ptr_service_name));
			} else {
				r->service_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
			if (_ptr_display_name) {
				NDR_PULL_ALLOC(ndr, r->display_name);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->display_name, _ptr_display_name));
			} else {
				r->display_name = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_SERVICE_STATUS(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->service_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->service_name));
				_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->service_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->service_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			if (r->display_name) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->display_name));
				_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->display_name, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->display_name));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ENUM_SERVICE_STATUSA(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ENUM_SERVICE_STATUSA *r)
{
	ndr_print_ENUM_SERVICE_STATUSA(ndr, name, r);
}

_PUBLIC_ void ndr_print_ENUM_SERVICE_STATUSA(struct ndr_print *ndr, const char *name, const struct ENUM_SERVICE_STATUSA *r)
{
	ndr_print_struct(ndr, name, "ENUM_SERVICE_STATUSA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_ptr(ndr, "service_name", r->service_name);
		ndr->depth++;
		if (r->service_name) {
			ndr_print_string(ndr, "service_name", r->service_name);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
		ndr_print_ptr(ndr, "display_name", r->display_name);
		ndr->depth++;
		if (r->display_name) {
			ndr_print_string(ndr, "display_name", r->display_name);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr_print_SERVICE_STATUS(ndr, "status", &r->status);
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_ENUM_SERVICE_STATUSA(const struct ENUM_SERVICE_STATUSA *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_ENUM_SERVICE_STATUSA);
}

static enum ndr_err_code ndr_push_SERVICE_CONTROL(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum SERVICE_CONTROL r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_CONTROL(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum SERVICE_CONTROL *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_CONTROL(struct ndr_print *ndr, const char *name, enum SERVICE_CONTROL r)
{
	const char *val = NULL;

	switch (r) {
		case SVCCTL_CONTROL_STOP: val = "SVCCTL_CONTROL_STOP"; break;
		case SVCCTL_CONTROL_PAUSE: val = "SVCCTL_CONTROL_PAUSE"; break;
		case SVCCTL_CONTROL_CONTINUE: val = "SVCCTL_CONTROL_CONTINUE"; break;
		case SVCCTL_CONTROL_INTERROGATE: val = "SVCCTL_CONTROL_INTERROGATE"; break;
		case SVCCTL_CONTROL_SHUTDOWN: val = "SVCCTL_CONTROL_SHUTDOWN"; break;
		case SVCCTL_CONTROL_PARAMCHANGE: val = "SVCCTL_CONTROL_PARAMCHANGE"; break;
		case SVCCTL_CONTROL_NETBINDADD: val = "SVCCTL_CONTROL_NETBINDADD"; break;
		case SVCCTL_CONTROL_NETBINDREMOVE: val = "SVCCTL_CONTROL_NETBINDREMOVE"; break;
		case SVCCTL_CONTROL_NETBINDENABLE: val = "SVCCTL_CONTROL_NETBINDENABLE"; break;
		case SVCCTL_CONTROL_NETBINDDISABLE: val = "SVCCTL_CONTROL_NETBINDDISABLE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_svcctl_ErrorControl(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum svcctl_ErrorControl r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ErrorControl(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum svcctl_ErrorControl *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ErrorControl(struct ndr_print *ndr, const char *name, enum svcctl_ErrorControl r)
{
	const char *val = NULL;

	switch (r) {
		case SVCCTL_SVC_ERROR_IGNORE: val = "SVCCTL_SVC_ERROR_IGNORE"; break;
		case SVCCTL_SVC_ERROR_NORMAL: val = "SVCCTL_SVC_ERROR_NORMAL"; break;
		case SVCCTL_SVC_ERROR_CRITICAL: val = "SVCCTL_SVC_ERROR_CRITICAL"; break;
		case SVCCTL_SVC_ERROR_SEVERE: val = "SVCCTL_SVC_ERROR_SEVERE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_svcctl_StartType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum svcctl_StartType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_StartType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum svcctl_StartType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_StartType(struct ndr_print *ndr, const char *name, enum svcctl_StartType r)
{
	const char *val = NULL;

	switch (r) {
		case SVCCTL_BOOT_START: val = "SVCCTL_BOOT_START"; break;
		case SVCCTL_SYSTEM_START: val = "SVCCTL_SYSTEM_START"; break;
		case SVCCTL_AUTO_START: val = "SVCCTL_AUTO_START"; break;
		case SVCCTL_DEMAND_START: val = "SVCCTL_DEMAND_START"; break;
		case SVCCTL_DISABLED: val = "SVCCTL_DISABLED"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_svcctl_ServiceState(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum svcctl_ServiceState r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ServiceState(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum svcctl_ServiceState *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ServiceState(struct ndr_print *ndr, const char *name, enum svcctl_ServiceState r)
{
	const char *val = NULL;

	switch (r) {
		case SERVICE_STATE_ACTIVE: val = "SERVICE_STATE_ACTIVE"; break;
		case SERVICE_STATE_INACTIVE: val = "SERVICE_STATE_INACTIVE"; break;
		case SERVICE_STATE_ALL: val = "SERVICE_STATE_ALL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_svcctl_MgrAccessMask(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_MgrAccessMask(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_MgrAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_CONNECT", SC_RIGHT_MGR_CONNECT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_CREATE_SERVICE", SC_RIGHT_MGR_CREATE_SERVICE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_ENUMERATE_SERVICE", SC_RIGHT_MGR_ENUMERATE_SERVICE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_LOCK", SC_RIGHT_MGR_LOCK, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_QUERY_LOCK_STATUS", SC_RIGHT_MGR_QUERY_LOCK_STATUS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_MGR_MODIFY_BOOT_CONFIG", SC_RIGHT_MGR_MODIFY_BOOT_CONFIG, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ServiceAccessMask(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ServiceAccessMask(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ServiceAccessMask(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_QUERY_CONFIG", SC_RIGHT_SVC_QUERY_CONFIG, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_CHANGE_CONFIG", SC_RIGHT_SVC_CHANGE_CONFIG, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_QUERY_STATUS", SC_RIGHT_SVC_QUERY_STATUS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_ENUMERATE_DEPENDENTS", SC_RIGHT_SVC_ENUMERATE_DEPENDENTS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_START", SC_RIGHT_SVC_START, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_STOP", SC_RIGHT_SVC_STOP, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_PAUSE_CONTINUE", SC_RIGHT_SVC_PAUSE_CONTINUE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_INTERROGATE", SC_RIGHT_SVC_INTERROGATE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "SC_RIGHT_SVC_USER_DEFINED_CONTROL", SC_RIGHT_SVC_USER_DEFINED_CONTROL, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_QUERY_SERVICE_CONFIG(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct QUERY_SERVICE_CONFIG *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->service_type));
		NDR_CHECK(ndr_push_svcctl_StartType(ndr, NDR_SCALARS, r->start_type));
		NDR_CHECK(ndr_push_svcctl_ErrorControl(ndr, NDR_SCALARS, r->error_control));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->executablepath));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->loadordergroup));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->tag_id));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->dependencies));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->startname));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->displayname));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->executablepath) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->executablepath, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->executablepath, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->executablepath, ndr_charset_length(r->executablepath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->loadordergroup) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->loadordergroup, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->loadordergroup, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->loadordergroup, ndr_charset_length(r->loadordergroup, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->dependencies) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->dependencies, ndr_charset_length(r->dependencies, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->startname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->startname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->startname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->startname, ndr_charset_length(r->startname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->displayname) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->displayname, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->displayname, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->displayname, ndr_charset_length(r->displayname, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_QUERY_SERVICE_CONFIG(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct QUERY_SERVICE_CONFIG *r)
{
	uint32_t _ptr_executablepath;
	uint32_t size_executablepath_1 = 0;
	uint32_t length_executablepath_1 = 0;
	TALLOC_CTX *_mem_save_executablepath_0 = NULL;
	uint32_t _ptr_loadordergroup;
	uint32_t size_loadordergroup_1 = 0;
	uint32_t length_loadordergroup_1 = 0;
	TALLOC_CTX *_mem_save_loadordergroup_0 = NULL;
	uint32_t _ptr_dependencies;
	uint32_t size_dependencies_1 = 0;
	uint32_t length_dependencies_1 = 0;
	TALLOC_CTX *_mem_save_dependencies_0 = NULL;
	uint32_t _ptr_startname;
	uint32_t size_startname_1 = 0;
	uint32_t length_startname_1 = 0;
	TALLOC_CTX *_mem_save_startname_0 = NULL;
	uint32_t _ptr_displayname;
	uint32_t size_displayname_1 = 0;
	uint32_t length_displayname_1 = 0;
	TALLOC_CTX *_mem_save_displayname_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->service_type));
		NDR_CHECK(ndr_pull_svcctl_StartType(ndr, NDR_SCALARS, &r->start_type));
		NDR_CHECK(ndr_pull_svcctl_ErrorControl(ndr, NDR_SCALARS, &r->error_control));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_executablepath));
		if (_ptr_executablepath) {
			NDR_PULL_ALLOC(ndr, r->executablepath);
		} else {
			r->executablepath = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_loadordergroup));
		if (_ptr_loadordergroup) {
			NDR_PULL_ALLOC(ndr, r->loadordergroup);
		} else {
			r->loadordergroup = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->tag_id));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->dependencies);
		} else {
			r->dependencies = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_startname));
		if (_ptr_startname) {
			NDR_PULL_ALLOC(ndr, r->startname);
		} else {
			r->startname = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_displayname));
		if (_ptr_displayname) {
			NDR_PULL_ALLOC(ndr, r->displayname);
		} else {
			r->displayname = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->executablepath) {
			_mem_save_executablepath_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->executablepath, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->executablepath));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->executablepath));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->executablepath, &size_executablepath_1));
			if (size_executablepath_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_executablepath_1, (uint32_t)(0), (uint32_t)(8192));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->executablepath, &length_executablepath_1));
			if (length_executablepath_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_executablepath_1, (uint32_t)(0), (uint32_t)(8192));
			}
			if (length_executablepath_1 > size_executablepath_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_executablepath_1, length_executablepath_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_executablepath_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->executablepath, length_executablepath_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_executablepath_0, 0);
		}
		if (r->loadordergroup) {
			_mem_save_loadordergroup_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->loadordergroup, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->loadordergroup));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->loadordergroup));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->loadordergroup, &size_loadordergroup_1));
			if (size_loadordergroup_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_loadordergroup_1, (uint32_t)(0), (uint32_t)(8192));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->loadordergroup, &length_loadordergroup_1));
			if (length_loadordergroup_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_loadordergroup_1, (uint32_t)(0), (uint32_t)(8192));
			}
			if (length_loadordergroup_1 > size_loadordergroup_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_loadordergroup_1, length_loadordergroup_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_loadordergroup_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->loadordergroup, length_loadordergroup_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_loadordergroup_0, 0);
		}
		if (r->dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->dependencies));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->dependencies));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->dependencies, &size_dependencies_1));
			if (size_dependencies_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_dependencies_1, (uint32_t)(0), (uint32_t)(8192));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->dependencies, &length_dependencies_1));
			if (length_dependencies_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_dependencies_1, (uint32_t)(0), (uint32_t)(8192));
			}
			if (length_dependencies_1 > size_dependencies_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dependencies_1, length_dependencies_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dependencies_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->dependencies, length_dependencies_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		if (r->startname) {
			_mem_save_startname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->startname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->startname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->startname));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->startname, &size_startname_1));
			if (size_startname_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_startname_1, (uint32_t)(0), (uint32_t)(8192));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->startname, &length_startname_1));
			if (length_startname_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_startname_1, (uint32_t)(0), (uint32_t)(8192));
			}
			if (length_startname_1 > size_startname_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_startname_1, length_startname_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_startname_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->startname, length_startname_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_startname_0, 0);
		}
		if (r->displayname) {
			_mem_save_displayname_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->displayname, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->displayname));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->displayname));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->displayname, &size_displayname_1));
			if (size_displayname_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_displayname_1, (uint32_t)(0), (uint32_t)(8192));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->displayname, &length_displayname_1));
			if (length_displayname_1 > 8192) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_displayname_1, (uint32_t)(0), (uint32_t)(8192));
			}
			if (length_displayname_1 > size_displayname_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_displayname_1, length_displayname_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_displayname_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->displayname, length_displayname_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_displayname_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_QUERY_SERVICE_CONFIG(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct QUERY_SERVICE_CONFIG *r)
{
	ndr_print_QUERY_SERVICE_CONFIG(ndr, name, r);
}

_PUBLIC_ void ndr_print_QUERY_SERVICE_CONFIG(struct ndr_print *ndr, const char *name, const struct QUERY_SERVICE_CONFIG *r)
{
	ndr_print_struct(ndr, name, "QUERY_SERVICE_CONFIG");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "service_type", r->service_type);
	ndr_print_svcctl_StartType(ndr, "start_type", r->start_type);
	ndr_print_svcctl_ErrorControl(ndr, "error_control", r->error_control);
	ndr_print_ptr(ndr, "executablepath", r->executablepath);
	ndr->depth++;
	if (r->executablepath) {
		ndr_print_string(ndr, "executablepath", r->executablepath);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "loadordergroup", r->loadordergroup);
	ndr->depth++;
	if (r->loadordergroup) {
		ndr_print_string(ndr, "loadordergroup", r->loadordergroup);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "tag_id", r->tag_id);
	ndr_print_ptr(ndr, "dependencies", r->dependencies);
	ndr->depth++;
	if (r->dependencies) {
		ndr_print_string(ndr, "dependencies", r->dependencies);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "startname", r->startname);
	ndr->depth++;
	if (r->startname) {
		ndr_print_string(ndr, "startname", r->startname);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "displayname", r->displayname);
	ndr->depth++;
	if (r->displayname) {
		ndr_print_string(ndr, "displayname", r->displayname);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_QUERY_SERVICE_CONFIG(const struct QUERY_SERVICE_CONFIG *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_QUERY_SERVICE_CONFIG);
}

static enum ndr_err_code ndr_push_svcctl_ArgumentString(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct svcctl_ArgumentString *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->string));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->string, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->string, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->string, ndr_charset_length(r->string, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ArgumentString(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct svcctl_ArgumentString *r)
{
	uint32_t _ptr_string;
	uint32_t size_string_1 = 0;
	uint32_t length_string_1 = 0;
	TALLOC_CTX *_mem_save_string_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_string));
		if (_ptr_string) {
			NDR_PULL_ALLOC(ndr, r->string);
		} else {
			r->string = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->string) {
			_mem_save_string_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->string, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->string));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->string));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->string, &size_string_1));
			if (size_string_1 > SC_MAX_ARGUMENT_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_string_1, (uint32_t)(0), (uint32_t)(SC_MAX_ARGUMENT_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->string, &length_string_1));
			if (length_string_1 > SC_MAX_ARGUMENT_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_string_1, (uint32_t)(0), (uint32_t)(SC_MAX_ARGUMENT_LENGTH));
			}
			if (length_string_1 > size_string_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_string_1, length_string_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_string_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->string, length_string_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_string_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ArgumentString(struct ndr_print *ndr, const char *name, const struct svcctl_ArgumentString *r)
{
	ndr_print_struct(ndr, name, "svcctl_ArgumentString");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "string", r->string);
	ndr->depth++;
	if (r->string) {
		ndr_print_string(ndr, "string", r->string);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ConfigLevel(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum svcctl_ConfigLevel r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ConfigLevel(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum svcctl_ConfigLevel *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ConfigLevel(struct ndr_print *ndr, const char *name, enum svcctl_ConfigLevel r)
{
	const char *val = NULL;

	switch (r) {
		case SERVICE_CONFIG_DESCRIPTION: val = "SERVICE_CONFIG_DESCRIPTION"; break;
		case SERVICE_CONFIG_FAILURE_ACTIONS: val = "SERVICE_CONFIG_FAILURE_ACTIONS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVICE_DESCRIPTION(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_DESCRIPTION *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->description));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->description) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->description));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->description));
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->description));
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVICE_DESCRIPTION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_DESCRIPTION *r)
{
	uint32_t _ptr_description;
	TALLOC_CTX *_mem_save_description_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_description));
			if (_ptr_description) {
				NDR_PULL_ALLOC(ndr, r->description);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->description, _ptr_description));
			} else {
				r->description = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->description) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->description));
				_mem_save_description_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->description, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->description));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_description_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_SERVICE_DESCRIPTION(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct SERVICE_DESCRIPTION *r)
{
	ndr_print_SERVICE_DESCRIPTION(ndr, name, r);
}

_PUBLIC_ void ndr_print_SERVICE_DESCRIPTION(struct ndr_print *ndr, const char *name, const struct SERVICE_DESCRIPTION *r)
{
	ndr_print_struct(ndr, name, "SERVICE_DESCRIPTION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "description", r->description);
		ndr->depth++;
		if (r->description) {
			ndr_print_string(ndr, "description", r->description);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_SERVICE_DESCRIPTION(const struct SERVICE_DESCRIPTION *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_SERVICE_DESCRIPTION);
}

static enum ndr_err_code ndr_push_SC_ACTION_TYPE(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum SC_ACTION_TYPE r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_ACTION_TYPE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum SC_ACTION_TYPE *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_ACTION_TYPE(struct ndr_print *ndr, const char *name, enum SC_ACTION_TYPE r)
{
	const char *val = NULL;

	switch (r) {
		case SC_ACTION_NONE: val = "SC_ACTION_NONE"; break;
		case SC_ACTION_RESTART: val = "SC_ACTION_RESTART"; break;
		case SC_ACTION_REBOOT: val = "SC_ACTION_REBOOT"; break;
		case SC_ACTION_RUN_COMMAND: val = "SC_ACTION_RUN_COMMAND"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_SC_ACTION(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SC_ACTION *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_SC_ACTION_TYPE(ndr, NDR_SCALARS, r->type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->delay));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_ACTION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SC_ACTION *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_SC_ACTION_TYPE(ndr, NDR_SCALARS, &r->type));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->delay));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_ACTION(struct ndr_print *ndr, const char *name, const struct SC_ACTION *r)
{
	ndr_print_struct(ndr, name, "SC_ACTION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_SC_ACTION_TYPE(ndr, "type", r->type);
	ndr_print_uint32(ndr, "delay", r->delay);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_SERVICE_FAILURE_ACTIONSW(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_FAILURE_ACTIONSW *r)
{
	uint32_t cntr_actions_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->reset_period));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->rebootmsg));
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->command));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->num_actions));
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->actions));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->rebootmsg) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->rebootmsg));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->rebootmsg));
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->rebootmsg));
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->command) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->command));
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->command));
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->command));
			}
			ndr->flags = _flags_save_string;
		}
		if (r->actions) {
			NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->actions));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->num_actions));
			for (cntr_actions_1 = 0; cntr_actions_1 < (r->num_actions); cntr_actions_1++) {
				NDR_CHECK(ndr_push_SC_ACTION(ndr, NDR_SCALARS, &r->actions[cntr_actions_1]));
			}
			NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->actions));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_SERVICE_FAILURE_ACTIONSW(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_FAILURE_ACTIONSW *r)
{
	uint32_t _ptr_rebootmsg;
	TALLOC_CTX *_mem_save_rebootmsg_0 = NULL;
	uint32_t _ptr_command;
	TALLOC_CTX *_mem_save_command_0 = NULL;
	uint32_t _ptr_actions;
	uint32_t size_actions_1 = 0;
	uint32_t cntr_actions_1;
	TALLOC_CTX *_mem_save_actions_0 = NULL;
	TALLOC_CTX *_mem_save_actions_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reset_period));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rebootmsg));
			if (_ptr_rebootmsg) {
				NDR_PULL_ALLOC(ndr, r->rebootmsg);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->rebootmsg, _ptr_rebootmsg));
			} else {
				r->rebootmsg = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_command));
			if (_ptr_command) {
				NDR_PULL_ALLOC(ndr, r->command);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->command, _ptr_command));
			} else {
				r->command = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->num_actions));
		if (r->num_actions > 1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->num_actions), (uint32_t)(0), (uint32_t)(1024));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_actions));
		if (_ptr_actions) {
			NDR_PULL_ALLOC(ndr, r->actions);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->actions, _ptr_actions));
		} else {
			r->actions = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->rebootmsg) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->rebootmsg));
				_mem_save_rebootmsg_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->rebootmsg, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->rebootmsg));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rebootmsg_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
			if (r->command) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->command));
				_mem_save_command_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->command, 0);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->command));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_command_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		if (r->actions) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->actions));
			_mem_save_actions_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->actions, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->actions));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->actions, &size_actions_1));
			NDR_PULL_ALLOC_N(ndr, r->actions, size_actions_1);
			_mem_save_actions_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->actions, 0);
			for (cntr_actions_1 = 0; cntr_actions_1 < (size_actions_1); cntr_actions_1++) {
				NDR_CHECK(ndr_pull_SC_ACTION(ndr, NDR_SCALARS, &r->actions[cntr_actions_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_actions_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_actions_0, 0);
			if (ndr->offset > ndr->relative_highest_offset) {
				ndr->relative_highest_offset = ndr->offset;
			}
			ndr->offset = _relative_save_offset;
		}
		if (r->actions) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->actions, r->num_actions));
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_SERVICE_FAILURE_ACTIONSW(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct SERVICE_FAILURE_ACTIONSW *r)
{
	ndr_print_SERVICE_FAILURE_ACTIONSW(ndr, name, r);
}

_PUBLIC_ void ndr_print_SERVICE_FAILURE_ACTIONSW(struct ndr_print *ndr, const char *name, const struct SERVICE_FAILURE_ACTIONSW *r)
{
	uint32_t cntr_actions_1;
	ndr_print_struct(ndr, name, "SERVICE_FAILURE_ACTIONSW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "reset_period", r->reset_period);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "rebootmsg", r->rebootmsg);
		ndr->depth++;
		if (r->rebootmsg) {
			ndr_print_string(ndr, "rebootmsg", r->rebootmsg);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NULLTERM|LIBNDR_FLAG_ALIGN2);
		ndr_print_ptr(ndr, "command", r->command);
		ndr->depth++;
		if (r->command) {
			ndr_print_string(ndr, "command", r->command);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr_print_uint32(ndr, "num_actions", r->num_actions);
	ndr_print_ptr(ndr, "actions", r->actions);
	ndr->depth++;
	if (r->actions) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "actions", (uint32_t)(r->num_actions));
		ndr->depth++;
		for (cntr_actions_1 = 0; cntr_actions_1 < (r->num_actions); cntr_actions_1++) {
			ndr_print_SC_ACTION(ndr, "actions", &r->actions[cntr_actions_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ size_t ndr_size_SERVICE_FAILURE_ACTIONSW(const struct SERVICE_FAILURE_ACTIONSW *r, libndr_flags flags)
{
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_SERVICE_FAILURE_ACTIONSW);
}

static enum ndr_err_code ndr_push_svcctl_StatusLevel(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum svcctl_StatusLevel r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_StatusLevel(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum svcctl_StatusLevel *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_StatusLevel(struct ndr_print *ndr, const char *name, enum svcctl_StatusLevel r)
{
	const char *val = NULL;

	switch (r) {
		case SVC_STATUS_PROCESS_INFO: val = "SVC_STATUS_PROCESS_INFO"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->ullThreadId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwNotifyMask));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->CallbackAddressArray, 16));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->CallbackParamAddressArray, 16));
		NDR_CHECK(ndr_push_SERVICE_STATUS_PROCESS(ndr, NDR_SCALARS, &r->ServiceStatus));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwNotificationStatus));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwSequence));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *r)
{
	uint32_t size_CallbackAddressArray_0 = 0;
	uint32_t size_CallbackParamAddressArray_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->ullThreadId));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwNotifyMask));
		size_CallbackAddressArray_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->CallbackAddressArray, size_CallbackAddressArray_0));
		size_CallbackParamAddressArray_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->CallbackParamAddressArray, size_CallbackParamAddressArray_0));
		NDR_CHECK(ndr_pull_SERVICE_STATUS_PROCESS(ndr, NDR_SCALARS, &r->ServiceStatus));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwNotificationStatus));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwSequence));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1(struct ndr_print *ndr, const char *name, const struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1 *r)
{
	ndr_print_struct(ndr, name, "SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "ullThreadId", r->ullThreadId);
	ndr_print_uint32(ndr, "dwNotifyMask", r->dwNotifyMask);
	ndr_print_array_uint8(ndr, "CallbackAddressArray", r->CallbackAddressArray, 16);
	ndr_print_array_uint8(ndr, "CallbackParamAddressArray", r->CallbackParamAddressArray, 16);
	ndr_print_SERVICE_STATUS_PROCESS(ndr, "ServiceStatus", &r->ServiceStatus);
	ndr_print_uint32(ndr, "dwNotificationStatus", r->dwNotificationStatus);
	ndr_print_uint32(ndr, "dwSequence", r->dwSequence);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->ullThreadId));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwNotifyMask));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->CallbackAddressArray, 16));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->CallbackParamAddressArray, 16));
		NDR_CHECK(ndr_push_SERVICE_STATUS_PROCESS(ndr, NDR_SCALARS, &r->ServiceStatus));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwNotificationStatus));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwSequence));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwNotificationTriggered));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszServiceNames));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszServiceNames) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszServiceNames, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszServiceNames, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszServiceNames, ndr_charset_length(r->pszServiceNames, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *r)
{
	uint32_t size_CallbackAddressArray_0 = 0;
	uint32_t size_CallbackParamAddressArray_0 = 0;
	uint32_t _ptr_pszServiceNames;
	uint32_t size_pszServiceNames_1 = 0;
	uint32_t length_pszServiceNames_1 = 0;
	TALLOC_CTX *_mem_save_pszServiceNames_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->ullThreadId));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwNotifyMask));
		size_CallbackAddressArray_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->CallbackAddressArray, size_CallbackAddressArray_0));
		size_CallbackParamAddressArray_0 = 16;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->CallbackParamAddressArray, size_CallbackParamAddressArray_0));
		NDR_CHECK(ndr_pull_SERVICE_STATUS_PROCESS(ndr, NDR_SCALARS, &r->ServiceStatus));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwNotificationStatus));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwSequence));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwNotificationTriggered));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszServiceNames));
		if (_ptr_pszServiceNames) {
			NDR_PULL_ALLOC(ndr, r->pszServiceNames);
		} else {
			r->pszServiceNames = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszServiceNames) {
			_mem_save_pszServiceNames_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszServiceNames, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszServiceNames));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszServiceNames));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszServiceNames, &size_pszServiceNames_1));
			if (size_pszServiceNames_1 > 64*1024) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_pszServiceNames_1, (uint32_t)(0), (uint32_t)(64*1024));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszServiceNames, &length_pszServiceNames_1));
			if (length_pszServiceNames_1 > 64*1024) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_pszServiceNames_1, (uint32_t)(0), (uint32_t)(64*1024));
			}
			if (length_pszServiceNames_1 > size_pszServiceNames_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszServiceNames_1, length_pszServiceNames_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszServiceNames_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszServiceNames, length_pszServiceNames_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszServiceNames_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2(struct ndr_print *ndr, const char *name, const struct SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2 *r)
{
	ndr_print_struct(ndr, name, "SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "ullThreadId", r->ullThreadId);
	ndr_print_uint32(ndr, "dwNotifyMask", r->dwNotifyMask);
	ndr_print_array_uint8(ndr, "CallbackAddressArray", r->CallbackAddressArray, 16);
	ndr_print_array_uint8(ndr, "CallbackParamAddressArray", r->CallbackParamAddressArray, 16);
	ndr_print_SERVICE_STATUS_PROCESS(ndr, "ServiceStatus", &r->ServiceStatus);
	ndr_print_uint32(ndr, "dwNotificationStatus", r->dwNotificationStatus);
	ndr_print_uint32(ndr, "dwSequence", r->dwSequence);
	ndr_print_uint32(ndr, "dwNotificationTriggered", r->dwNotificationTriggered);
	ndr_print_ptr(ndr, "pszServiceNames", r->pszServiceNames);
	ndr->depth++;
	if (r->pszServiceNames) {
		ndr_print_string(ndr, "pszServiceNames", r->pszServiceNames);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SC_RPC_NOTIFY_PARAMS_u(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union SC_RPC_NOTIFY_PARAMS_u *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->pStatusChangeParam1));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->pStatusChangeParams));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->pStatusChangeParam1) {
					NDR_CHECK(ndr_push_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1(ndr, NDR_SCALARS, r->pStatusChangeParam1));
				}
			break;

			case 2:
				if (r->pStatusChangeParams) {
					NDR_CHECK(ndr_push_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2(ndr, NDR_SCALARS|NDR_BUFFERS, r->pStatusChangeParams));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_RPC_NOTIFY_PARAMS_u(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union SC_RPC_NOTIFY_PARAMS_u *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_pStatusChangeParam1_0 = NULL;
	uint32_t _ptr_pStatusChangeParam1;
	TALLOC_CTX *_mem_save_pStatusChangeParams_0 = NULL;
	uint32_t _ptr_pStatusChangeParams;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pStatusChangeParam1));
				if (_ptr_pStatusChangeParam1) {
					NDR_PULL_ALLOC(ndr, r->pStatusChangeParam1);
				} else {
					r->pStatusChangeParam1 = NULL;
				}
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pStatusChangeParams));
				if (_ptr_pStatusChangeParams) {
					NDR_PULL_ALLOC(ndr, r->pStatusChangeParams);
				} else {
					r->pStatusChangeParams = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->pStatusChangeParam1) {
					_mem_save_pStatusChangeParam1_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->pStatusChangeParam1, 0);
					NDR_CHECK(ndr_pull_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1(ndr, NDR_SCALARS, r->pStatusChangeParam1));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pStatusChangeParam1_0, 0);
				}
			break;

			case 2:
				if (r->pStatusChangeParams) {
					_mem_save_pStatusChangeParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->pStatusChangeParams, 0);
					NDR_CHECK(ndr_pull_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2(ndr, NDR_SCALARS|NDR_BUFFERS, r->pStatusChangeParams));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pStatusChangeParams_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_RPC_NOTIFY_PARAMS_u(struct ndr_print *ndr, const char *name, const union SC_RPC_NOTIFY_PARAMS_u *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "SC_RPC_NOTIFY_PARAMS_u");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "pStatusChangeParam1", r->pStatusChangeParam1);
			ndr->depth++;
			if (r->pStatusChangeParam1) {
				ndr_print_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_1(ndr, "pStatusChangeParam1", r->pStatusChangeParam1);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "pStatusChangeParams", r->pStatusChangeParams);
			ndr->depth++;
			if (r->pStatusChangeParams) {
				ndr_print_SERVICE_NOTIFY_STATUS_CHANGE_PARAMS_2(ndr, "pStatusChangeParams", r->pStatusChangeParams);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_SC_RPC_NOTIFY_PARAMS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SC_RPC_NOTIFY_PARAMS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwInfoLevel));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->u, r->dwInfoLevel));
		NDR_CHECK(ndr_push_SC_RPC_NOTIFY_PARAMS_u(ndr, NDR_SCALARS, &r->u));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->u, r->dwInfoLevel));
		NDR_CHECK(ndr_push_SC_RPC_NOTIFY_PARAMS_u(ndr, NDR_BUFFERS, &r->u));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_RPC_NOTIFY_PARAMS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SC_RPC_NOTIFY_PARAMS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwInfoLevel));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->u, r->dwInfoLevel));
		NDR_CHECK(ndr_pull_SC_RPC_NOTIFY_PARAMS_u(ndr, NDR_SCALARS, &r->u));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->u, r->dwInfoLevel));
		NDR_CHECK(ndr_pull_SC_RPC_NOTIFY_PARAMS_u(ndr, NDR_BUFFERS, &r->u));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_RPC_NOTIFY_PARAMS(struct ndr_print *ndr, const char *name, const struct SC_RPC_NOTIFY_PARAMS *r)
{
	ndr_print_struct(ndr, name, "SC_RPC_NOTIFY_PARAMS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwInfoLevel", r->dwInfoLevel);
	ndr_print_set_switch_value(ndr, &r->u, r->dwInfoLevel);
	ndr_print_SC_RPC_NOTIFY_PARAMS_u(ndr, "u", &r->u);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SC_RPC_NOTIFY_PARAMS_LIST(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SC_RPC_NOTIFY_PARAMS_LIST *r)
{
	uint32_t cntr_NotifyParamsArray_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cElements));
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cElements));
		for (cntr_NotifyParamsArray_0 = 0; cntr_NotifyParamsArray_0 < (r->cElements); cntr_NotifyParamsArray_0++) {
			NDR_CHECK(ndr_push_SC_RPC_NOTIFY_PARAMS(ndr, NDR_SCALARS, &r->NotifyParamsArray[cntr_NotifyParamsArray_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_NotifyParamsArray_0 = 0; cntr_NotifyParamsArray_0 < (r->cElements); cntr_NotifyParamsArray_0++) {
			NDR_CHECK(ndr_push_SC_RPC_NOTIFY_PARAMS(ndr, NDR_BUFFERS, &r->NotifyParamsArray[cntr_NotifyParamsArray_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_RPC_NOTIFY_PARAMS_LIST(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SC_RPC_NOTIFY_PARAMS_LIST *r)
{
	uint32_t size_NotifyParamsArray_0 = 0;
	uint32_t cntr_NotifyParamsArray_0;
	TALLOC_CTX *_mem_save_NotifyParamsArray_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->NotifyParamsArray));
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cElements));
		if (r->cElements > 1024*4) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->cElements), (uint32_t)(0), (uint32_t)(1024*4));
		}
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->NotifyParamsArray, &size_NotifyParamsArray_0));
		NDR_PULL_ALLOC_N(ndr, r->NotifyParamsArray, size_NotifyParamsArray_0);
		_mem_save_NotifyParamsArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->NotifyParamsArray, 0);
		for (cntr_NotifyParamsArray_0 = 0; cntr_NotifyParamsArray_0 < (size_NotifyParamsArray_0); cntr_NotifyParamsArray_0++) {
			NDR_CHECK(ndr_pull_SC_RPC_NOTIFY_PARAMS(ndr, NDR_SCALARS, &r->NotifyParamsArray[cntr_NotifyParamsArray_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NotifyParamsArray_0, 0);
		if (r->NotifyParamsArray) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->NotifyParamsArray, r->cElements));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->NotifyParamsArray, &size_NotifyParamsArray_0));
		_mem_save_NotifyParamsArray_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->NotifyParamsArray, 0);
		for (cntr_NotifyParamsArray_0 = 0; cntr_NotifyParamsArray_0 < (size_NotifyParamsArray_0); cntr_NotifyParamsArray_0++) {
			NDR_CHECK(ndr_pull_SC_RPC_NOTIFY_PARAMS(ndr, NDR_BUFFERS, &r->NotifyParamsArray[cntr_NotifyParamsArray_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NotifyParamsArray_0, 0);
		for (cntr_NotifyParamsArray_0 = 0; cntr_NotifyParamsArray_0 < (size_NotifyParamsArray_0); cntr_NotifyParamsArray_0++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_RPC_NOTIFY_PARAMS_LIST(struct ndr_print *ndr, const char *name, const struct SC_RPC_NOTIFY_PARAMS_LIST *r)
{
	uint32_t cntr_NotifyParamsArray_0;
	ndr_print_struct(ndr, name, "SC_RPC_NOTIFY_PARAMS_LIST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "cElements", r->cElements);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "NotifyParamsArray", (uint32_t)(r->cElements));
	ndr->depth++;
	for (cntr_NotifyParamsArray_0 = 0; cntr_NotifyParamsArray_0 < (r->cElements); cntr_NotifyParamsArray_0++) {
		ndr_print_SC_RPC_NOTIFY_PARAMS(ndr, "NotifyParamsArray", &r->NotifyParamsArray[cntr_NotifyParamsArray_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReason));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->szComment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->szComment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->szComment, CH_DOS)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->szComment, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->szComment, ndr_charset_length(r->szComment, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA *r)
{
	uint32_t _ptr_szComment;
	uint32_t size_szComment_1 = 0;
	uint32_t length_szComment_1 = 0;
	TALLOC_CTX *_mem_save_szComment_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReason));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_szComment));
		if (_ptr_szComment) {
			NDR_PULL_ALLOC(ndr, r->szComment);
		} else {
			r->szComment = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->szComment) {
			_mem_save_szComment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->szComment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->szComment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->szComment));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->szComment, &size_szComment_1));
			if (size_szComment_1 > SC_MAX_COMMENT_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_szComment_1, (uint32_t)(0), (uint32_t)(SC_MAX_COMMENT_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->szComment, &length_szComment_1));
			if (length_szComment_1 > SC_MAX_COMMENT_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_szComment_1, (uint32_t)(0), (uint32_t)(SC_MAX_COMMENT_LENGTH));
			}
			if (length_szComment_1 > size_szComment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_szComment_1, length_szComment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_szComment_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->szComment, length_szComment_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_szComment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA(struct ndr_print *ndr, const char *name, const struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA *r)
{
	ndr_print_struct(ndr, name, "SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwReason", r->dwReason);
	ndr_print_ptr(ndr, "szComment", r->szComment);
	ndr->depth++;
	if (r->szComment) {
		ndr_print_string(ndr, "szComment", r->szComment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_SERVICE_STATUS_PROCESS(ndr, NDR_SCALARS, &r->ServiceStatus));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_SERVICE_STATUS_PROCESS(ndr, NDR_SCALARS, &r->ServiceStatus));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS(struct ndr_print *ndr, const char *name, const struct SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS *r)
{
	ndr_print_struct(ndr, name, "SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_SERVICE_STATUS_PROCESS(ndr, "ServiceStatus", &r->ServiceStatus);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psrInParams));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psrInParams) {
					NDR_CHECK(ndr_push_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA(ndr, NDR_SCALARS|NDR_BUFFERS, r->psrInParams));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_psrInParams_0 = NULL;
	uint32_t _ptr_psrInParams;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psrInParams));
				if (_ptr_psrInParams) {
					NDR_PULL_ALLOC(ndr, r->psrInParams);
				} else {
					r->psrInParams = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psrInParams) {
					_mem_save_psrInParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psrInParams, 0);
					NDR_CHECK(ndr_pull_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA(ndr, NDR_SCALARS|NDR_BUFFERS, r->psrInParams));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psrInParams_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(struct ndr_print *ndr, const char *name, const union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "SC_RPC_SERVICE_CONTROL_IN_PARAMSA");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "psrInParams", r->psrInParams);
			ndr->depth++;
			if (r->psrInParams) {
				ndr_print_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSA(ndr, "psrInParams", r->psrInParams);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psrOutParams));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psrOutParams) {
					NDR_CHECK(ndr_push_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS(ndr, NDR_SCALARS, r->psrOutParams));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_psrOutParams_0 = NULL;
	uint32_t _ptr_psrOutParams;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psrOutParams));
				if (_ptr_psrOutParams) {
					NDR_PULL_ALLOC(ndr, r->psrOutParams);
				} else {
					r->psrOutParams = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psrOutParams) {
					_mem_save_psrOutParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psrOutParams, 0);
					NDR_CHECK(ndr_pull_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS(ndr, NDR_SCALARS, r->psrOutParams));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psrOutParams_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(struct ndr_print *ndr, const char *name, const union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "SC_RPC_SERVICE_CONTROL_OUT_PARAMSA");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "psrOutParams", r->psrOutParams);
			ndr->depth++;
			if (r->psrOutParams) {
				ndr_print_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS(ndr, "psrOutParams", r->psrOutParams);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwReason));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pszComment));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszComment) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszComment, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->pszComment, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->pszComment, ndr_charset_length(r->pszComment, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW *r)
{
	uint32_t _ptr_pszComment;
	uint32_t size_pszComment_1 = 0;
	uint32_t length_pszComment_1 = 0;
	TALLOC_CTX *_mem_save_pszComment_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwReason));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pszComment));
		if (_ptr_pszComment) {
			NDR_PULL_ALLOC(ndr, r->pszComment);
		} else {
			r->pszComment = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pszComment) {
			_mem_save_pszComment_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pszComment, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pszComment));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->pszComment));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->pszComment, &size_pszComment_1));
			if (size_pszComment_1 > SC_MAX_COMMENT_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_pszComment_1, (uint32_t)(0), (uint32_t)(SC_MAX_COMMENT_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->pszComment, &length_pszComment_1));
			if (length_pszComment_1 > SC_MAX_COMMENT_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_pszComment_1, (uint32_t)(0), (uint32_t)(SC_MAX_COMMENT_LENGTH));
			}
			if (length_pszComment_1 > size_pszComment_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_pszComment_1, length_pszComment_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_pszComment_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->pszComment, length_pszComment_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pszComment_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW(struct ndr_print *ndr, const char *name, const struct SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW *r)
{
	ndr_print_struct(ndr, name, "SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwReason", r->dwReason);
	ndr_print_ptr(ndr, "pszComment", r->pszComment);
	ndr->depth++;
	if (r->pszComment) {
		ndr_print_string(ndr, "pszComment", r->pszComment);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psrInParams));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psrInParams) {
					NDR_CHECK(ndr_push_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW(ndr, NDR_SCALARS|NDR_BUFFERS, r->psrInParams));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_psrInParams_0 = NULL;
	uint32_t _ptr_psrInParams;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psrInParams));
				if (_ptr_psrInParams) {
					NDR_PULL_ALLOC(ndr, r->psrInParams);
				} else {
					r->psrInParams = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psrInParams) {
					_mem_save_psrInParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psrInParams, 0);
					NDR_CHECK(ndr_pull_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW(ndr, NDR_SCALARS|NDR_BUFFERS, r->psrInParams));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psrInParams_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(struct ndr_print *ndr, const char *name, const union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "SC_RPC_SERVICE_CONTROL_IN_PARAMSW");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "psrInParams", r->psrInParams);
			ndr->depth++;
			if (r->psrInParams) {
				ndr_print_SERVICE_CONTROL_STATUS_REASON_IN_PARAMSW(ndr, "psrInParams", r->psrInParams);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psrOutParams));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psrOutParams) {
					NDR_CHECK(ndr_push_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS(ndr, NDR_SCALARS, r->psrOutParams));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_psrOutParams_0 = NULL;
	uint32_t _ptr_psrOutParams;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psrOutParams));
				if (_ptr_psrOutParams) {
					NDR_PULL_ALLOC(ndr, r->psrOutParams);
				} else {
					r->psrOutParams = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psrOutParams) {
					_mem_save_psrOutParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psrOutParams, 0);
					NDR_CHECK(ndr_pull_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS(ndr, NDR_SCALARS, r->psrOutParams));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psrOutParams_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(struct ndr_print *ndr, const char *name, const union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "SC_RPC_SERVICE_CONTROL_OUT_PARAMSW");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "psrOutParams", r->psrOutParams);
			ndr->depth++;
			if (r->psrOutParams) {
				ndr_print_SERVICE_CONTROL_STATUS_REASON_OUT_PARAMS(ndr, "psrOutParams", r->psrOutParams);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_SERVICE_DESCRIPTIONW(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_DESCRIPTIONW *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->lpDescription));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpDescription) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpDescription, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->lpDescription, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->lpDescription, ndr_charset_length(r->lpDescription, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_DESCRIPTIONW(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_DESCRIPTIONW *r)
{
	uint32_t _ptr_lpDescription;
	uint32_t size_lpDescription_1 = 0;
	uint32_t length_lpDescription_1 = 0;
	TALLOC_CTX *_mem_save_lpDescription_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpDescription));
		if (_ptr_lpDescription) {
			NDR_PULL_ALLOC(ndr, r->lpDescription);
		} else {
			r->lpDescription = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->lpDescription) {
			_mem_save_lpDescription_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->lpDescription, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->lpDescription));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->lpDescription));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->lpDescription, &size_lpDescription_1));
			if (size_lpDescription_1 > 8*1024) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpDescription_1, (uint32_t)(0), (uint32_t)(8*1024));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->lpDescription, &length_lpDescription_1));
			if (length_lpDescription_1 > 8*1024) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpDescription_1, (uint32_t)(0), (uint32_t)(8*1024));
			}
			if (length_lpDescription_1 > size_lpDescription_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpDescription_1, length_lpDescription_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpDescription_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->lpDescription, length_lpDescription_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpDescription_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_DESCRIPTIONW(struct ndr_print *ndr, const char *name, const struct SERVICE_DESCRIPTIONW *r)
{
	ndr_print_struct(ndr, name, "SERVICE_DESCRIPTIONW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "lpDescription", r->lpDescription);
	ndr->depth++;
	if (r->lpDescription) {
		ndr_print_string(ndr, "lpDescription", r->lpDescription);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_DELAYED_AUTO_START_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_DELAYED_AUTO_START_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fDelayedAutostart));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_DELAYED_AUTO_START_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_DELAYED_AUTO_START_INFO *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fDelayedAutostart));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_DELAYED_AUTO_START_INFO(struct ndr_print *ndr, const char *name, const struct SERVICE_DELAYED_AUTO_START_INFO *r)
{
	ndr_print_struct(ndr, name, "SERVICE_DELAYED_AUTO_START_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "fDelayedAutostart", r->fDelayedAutostart);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_FAILURE_ACTIONS_FLAG(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_FAILURE_ACTIONS_FLAG *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fFailureActionsOnNonCrashFailures));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_FAILURE_ACTIONS_FLAG(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_FAILURE_ACTIONS_FLAG *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fFailureActionsOnNonCrashFailures));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_FAILURE_ACTIONS_FLAG(struct ndr_print *ndr, const char *name, const struct SERVICE_FAILURE_ACTIONS_FLAG *r)
{
	ndr_print_struct(ndr, name, "SERVICE_FAILURE_ACTIONS_FLAG");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "fFailureActionsOnNonCrashFailures", r->fFailureActionsOnNonCrashFailures);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_SID_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_SID_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwServiceSidType));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_SID_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_SID_INFO *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwServiceSidType));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_SID_INFO(struct ndr_print *ndr, const char *name, const struct SERVICE_SID_INFO *r)
{
	ndr_print_struct(ndr, name, "SERVICE_SID_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwServiceSidType", r->dwServiceSidType);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbRequiredPrivileges));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pRequiredPrivileges));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pRequiredPrivileges) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbRequiredPrivileges));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pRequiredPrivileges, r->cbRequiredPrivileges));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO *r)
{
	uint32_t _ptr_pRequiredPrivileges;
	uint32_t size_pRequiredPrivileges_1 = 0;
	TALLOC_CTX *_mem_save_pRequiredPrivileges_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbRequiredPrivileges));
		if (r->cbRequiredPrivileges > 1024*4) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->cbRequiredPrivileges), (uint32_t)(0), (uint32_t)(1024*4));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pRequiredPrivileges));
		if (_ptr_pRequiredPrivileges) {
			NDR_PULL_ALLOC(ndr, r->pRequiredPrivileges);
		} else {
			r->pRequiredPrivileges = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pRequiredPrivileges) {
			_mem_save_pRequiredPrivileges_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pRequiredPrivileges, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pRequiredPrivileges));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pRequiredPrivileges, &size_pRequiredPrivileges_1));
			NDR_PULL_ALLOC_N(ndr, r->pRequiredPrivileges, size_pRequiredPrivileges_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pRequiredPrivileges, size_pRequiredPrivileges_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pRequiredPrivileges_0, 0);
		}
		if (r->pRequiredPrivileges) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->pRequiredPrivileges, r->cbRequiredPrivileges));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO(struct ndr_print *ndr, const char *name, const struct SERVICE_RPC_REQUIRED_PRIVILEGES_INFO *r)
{
	ndr_print_struct(ndr, name, "SERVICE_RPC_REQUIRED_PRIVILEGES_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "cbRequiredPrivileges", r->cbRequiredPrivileges);
	ndr_print_ptr(ndr, "pRequiredPrivileges", r->pRequiredPrivileges);
	ndr->depth++;
	if (r->pRequiredPrivileges) {
		ndr_print_array_uint8(ndr, "pRequiredPrivileges", r->pRequiredPrivileges, r->cbRequiredPrivileges);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_PRESHUTDOWN_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_PRESHUTDOWN_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwPreshutdownTimeout));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_PRESHUTDOWN_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_PRESHUTDOWN_INFO *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwPreshutdownTimeout));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_PRESHUTDOWN_INFO(struct ndr_print *ndr, const char *name, const struct SERVICE_PRESHUTDOWN_INFO *r)
{
	ndr_print_struct(ndr, name, "SERVICE_PRESHUTDOWN_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwPreshutdownTimeout", r->dwPreshutdownTimeout);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwDataType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbData));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pData));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pData) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cbData));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->pData, r->cbData));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *r)
{
	uint32_t _ptr_pData;
	uint32_t size_pData_1 = 0;
	TALLOC_CTX *_mem_save_pData_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwDataType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbData));
		if (r->cbData > 1024) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->cbData), (uint32_t)(0), (uint32_t)(1024));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pData));
		if (_ptr_pData) {
			NDR_PULL_ALLOC(ndr, r->pData);
		} else {
			r->pData = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pData) {
			_mem_save_pData_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pData, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pData));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pData, &size_pData_1));
			NDR_PULL_ALLOC_N(ndr, r->pData, size_pData_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->pData, size_pData_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pData_0, 0);
		}
		if (r->pData) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->pData, r->cbData));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM(struct ndr_print *ndr, const char *name, const struct SERVICE_TRIGGER_SPECIFIC_DATA_ITEM *r)
{
	ndr_print_struct(ndr, name, "SERVICE_TRIGGER_SPECIFIC_DATA_ITEM");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwDataType", r->dwDataType);
	ndr_print_uint32(ndr, "cbData", r->cbData);
	ndr_print_ptr(ndr, "pData", r->pData);
	ndr->depth++;
	if (r->pData) {
		ndr_print_array_uint8(ndr, "pData", r->pData, r->cbData);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_TRIGGER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_TRIGGER *r)
{
	uint32_t cntr_pDataItems_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwTriggerType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwAction));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pTriggerSubtype));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cDataItems));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pDataItems));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pTriggerSubtype) {
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->pTriggerSubtype));
		}
		if (r->pDataItems) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cDataItems));
			for (cntr_pDataItems_1 = 0; cntr_pDataItems_1 < (r->cDataItems); cntr_pDataItems_1++) {
				NDR_CHECK(ndr_push_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM(ndr, NDR_SCALARS, &r->pDataItems[cntr_pDataItems_1]));
			}
			for (cntr_pDataItems_1 = 0; cntr_pDataItems_1 < (r->cDataItems); cntr_pDataItems_1++) {
				NDR_CHECK(ndr_push_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM(ndr, NDR_BUFFERS, &r->pDataItems[cntr_pDataItems_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_TRIGGER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_TRIGGER *r)
{
	uint32_t _ptr_pTriggerSubtype;
	TALLOC_CTX *_mem_save_pTriggerSubtype_0 = NULL;
	uint32_t _ptr_pDataItems;
	uint32_t size_pDataItems_1 = 0;
	uint32_t cntr_pDataItems_1;
	TALLOC_CTX *_mem_save_pDataItems_0 = NULL;
	TALLOC_CTX *_mem_save_pDataItems_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwTriggerType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwAction));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pTriggerSubtype));
		if (_ptr_pTriggerSubtype) {
			NDR_PULL_ALLOC(ndr, r->pTriggerSubtype);
		} else {
			r->pTriggerSubtype = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cDataItems));
		if (r->cDataItems > 64) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->cDataItems), (uint32_t)(0), (uint32_t)(64));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pDataItems));
		if (_ptr_pDataItems) {
			NDR_PULL_ALLOC(ndr, r->pDataItems);
		} else {
			r->pDataItems = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pTriggerSubtype) {
			_mem_save_pTriggerSubtype_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pTriggerSubtype, 0);
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->pTriggerSubtype));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pTriggerSubtype_0, 0);
		}
		if (r->pDataItems) {
			_mem_save_pDataItems_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pDataItems, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pDataItems));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pDataItems, &size_pDataItems_1));
			NDR_PULL_ALLOC_N(ndr, r->pDataItems, size_pDataItems_1);
			_mem_save_pDataItems_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pDataItems, 0);
			for (cntr_pDataItems_1 = 0; cntr_pDataItems_1 < (size_pDataItems_1); cntr_pDataItems_1++) {
				NDR_CHECK(ndr_pull_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM(ndr, NDR_SCALARS, &r->pDataItems[cntr_pDataItems_1]));
			}
			for (cntr_pDataItems_1 = 0; cntr_pDataItems_1 < (size_pDataItems_1); cntr_pDataItems_1++) {
				NDR_CHECK(ndr_pull_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM(ndr, NDR_BUFFERS, &r->pDataItems[cntr_pDataItems_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDataItems_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pDataItems_0, 0);
		}
		if (r->pDataItems) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pDataItems, r->cDataItems));
		}
		for (cntr_pDataItems_1 = 0; cntr_pDataItems_1 < (size_pDataItems_1); cntr_pDataItems_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_TRIGGER(struct ndr_print *ndr, const char *name, const struct SERVICE_TRIGGER *r)
{
	uint32_t cntr_pDataItems_1;
	ndr_print_struct(ndr, name, "SERVICE_TRIGGER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwTriggerType", r->dwTriggerType);
	ndr_print_uint32(ndr, "dwAction", r->dwAction);
	ndr_print_ptr(ndr, "pTriggerSubtype", r->pTriggerSubtype);
	ndr->depth++;
	if (r->pTriggerSubtype) {
		ndr_print_GUID(ndr, "pTriggerSubtype", r->pTriggerSubtype);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "cDataItems", r->cDataItems);
	ndr_print_ptr(ndr, "pDataItems", r->pDataItems);
	ndr->depth++;
	if (r->pDataItems) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pDataItems", (uint32_t)(r->cDataItems));
		ndr->depth++;
		for (cntr_pDataItems_1 = 0; cntr_pDataItems_1 < (r->cDataItems); cntr_pDataItems_1++) {
			ndr_print_SERVICE_TRIGGER_SPECIFIC_DATA_ITEM(ndr, "pDataItems", &r->pDataItems[cntr_pDataItems_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_TRIGGER_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_TRIGGER_INFO *r)
{
	uint32_t cntr_pTriggers_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cTriggers));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pTriggers));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->pReserved));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pTriggers) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->cTriggers));
			for (cntr_pTriggers_1 = 0; cntr_pTriggers_1 < (r->cTriggers); cntr_pTriggers_1++) {
				NDR_CHECK(ndr_push_SERVICE_TRIGGER(ndr, NDR_SCALARS, &r->pTriggers[cntr_pTriggers_1]));
			}
			for (cntr_pTriggers_1 = 0; cntr_pTriggers_1 < (r->cTriggers); cntr_pTriggers_1++) {
				NDR_CHECK(ndr_push_SERVICE_TRIGGER(ndr, NDR_BUFFERS, &r->pTriggers[cntr_pTriggers_1]));
			}
		}
		if (r->pReserved) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->pReserved));
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_TRIGGER_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_TRIGGER_INFO *r)
{
	uint32_t _ptr_pTriggers;
	uint32_t size_pTriggers_1 = 0;
	uint32_t cntr_pTriggers_1;
	TALLOC_CTX *_mem_save_pTriggers_0 = NULL;
	TALLOC_CTX *_mem_save_pTriggers_1 = NULL;
	uint32_t _ptr_pReserved;
	TALLOC_CTX *_mem_save_pReserved_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cTriggers));
		if (r->cTriggers > 64) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->cTriggers), (uint32_t)(0), (uint32_t)(64));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pTriggers));
		if (_ptr_pTriggers) {
			NDR_PULL_ALLOC(ndr, r->pTriggers);
		} else {
			r->pTriggers = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pReserved));
		if (_ptr_pReserved) {
			NDR_PULL_ALLOC(ndr, r->pReserved);
		} else {
			r->pReserved = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->pTriggers) {
			_mem_save_pTriggers_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pTriggers, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->pTriggers));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->pTriggers, &size_pTriggers_1));
			NDR_PULL_ALLOC_N(ndr, r->pTriggers, size_pTriggers_1);
			_mem_save_pTriggers_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pTriggers, 0);
			for (cntr_pTriggers_1 = 0; cntr_pTriggers_1 < (size_pTriggers_1); cntr_pTriggers_1++) {
				NDR_CHECK(ndr_pull_SERVICE_TRIGGER(ndr, NDR_SCALARS, &r->pTriggers[cntr_pTriggers_1]));
			}
			for (cntr_pTriggers_1 = 0; cntr_pTriggers_1 < (size_pTriggers_1); cntr_pTriggers_1++) {
				NDR_CHECK(ndr_pull_SERVICE_TRIGGER(ndr, NDR_BUFFERS, &r->pTriggers[cntr_pTriggers_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pTriggers_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pTriggers_0, 0);
		}
		if (r->pReserved) {
			_mem_save_pReserved_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->pReserved, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->pReserved));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pReserved_0, 0);
		}
		if (r->pTriggers) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->pTriggers, r->cTriggers));
		}
		for (cntr_pTriggers_1 = 0; cntr_pTriggers_1 < (size_pTriggers_1); cntr_pTriggers_1++) {
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_TRIGGER_INFO(struct ndr_print *ndr, const char *name, const struct SERVICE_TRIGGER_INFO *r)
{
	uint32_t cntr_pTriggers_1;
	ndr_print_struct(ndr, name, "SERVICE_TRIGGER_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "cTriggers", r->cTriggers);
	ndr_print_ptr(ndr, "pTriggers", r->pTriggers);
	ndr->depth++;
	if (r->pTriggers) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pTriggers", (uint32_t)(r->cTriggers));
		ndr->depth++;
		for (cntr_pTriggers_1 = 0; cntr_pTriggers_1 < (r->cTriggers); cntr_pTriggers_1++) {
			ndr_print_SERVICE_TRIGGER(ndr, "pTriggers", &r->pTriggers[cntr_pTriggers_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "pReserved", r->pReserved);
	ndr->depth++;
	if (r->pReserved) {
		ndr_print_uint8(ndr, "pReserved", *r->pReserved);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SERVICE_PREFERRED_NODE_INFO(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SERVICE_PREFERRED_NODE_INFO *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->usPreferredNode));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->fDelete));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SERVICE_PREFERRED_NODE_INFO(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SERVICE_PREFERRED_NODE_INFO *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->usPreferredNode));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->fDelete));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SERVICE_PREFERRED_NODE_INFO(struct ndr_print *ndr, const char *name, const struct SERVICE_PREFERRED_NODE_INFO *r)
{
	ndr_print_struct(ndr, name, "SERVICE_PREFERRED_NODE_INFO");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "usPreferredNode", r->usPreferredNode);
	ndr_print_uint32(ndr, "fDelete", r->fDelete);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_SC_RPC_CONFIG_INFOW_u(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union SC_RPC_CONFIG_INFOW_u *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, level));
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_push_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psd));
			break; }

			case 2: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psfa));
			break; }

			case 3: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psda));
			break; }

			case 4: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psfaf));
			break; }

			case 5: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->pssid));
			break; }

			case 6: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psrp));
			break; }

			case 7: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psps));
			break; }

			case 8: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->psti));
			break; }

			case 9: {
				NDR_CHECK(ndr_push_unique_ptr(ndr, r->pspn));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psd) {
					NDR_CHECK(ndr_push_SERVICE_DESCRIPTIONW(ndr, NDR_SCALARS|NDR_BUFFERS, r->psd));
				}
			break;

			case 2:
				if (r->psfa) {
					NDR_CHECK(ndr_push_SERVICE_FAILURE_ACTIONSW(ndr, NDR_SCALARS|NDR_BUFFERS, r->psfa));
				}
			break;

			case 3:
				if (r->psda) {
					NDR_CHECK(ndr_push_SERVICE_DELAYED_AUTO_START_INFO(ndr, NDR_SCALARS, r->psda));
				}
			break;

			case 4:
				if (r->psfaf) {
					NDR_CHECK(ndr_push_SERVICE_FAILURE_ACTIONS_FLAG(ndr, NDR_SCALARS, r->psfaf));
				}
			break;

			case 5:
				if (r->pssid) {
					NDR_CHECK(ndr_push_SERVICE_SID_INFO(ndr, NDR_SCALARS, r->pssid));
				}
			break;

			case 6:
				if (r->psrp) {
					NDR_CHECK(ndr_push_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->psrp));
				}
			break;

			case 7:
				if (r->psps) {
					NDR_CHECK(ndr_push_SERVICE_PRESHUTDOWN_INFO(ndr, NDR_SCALARS, r->psps));
				}
			break;

			case 8:
				if (r->psti) {
					NDR_CHECK(ndr_push_SERVICE_TRIGGER_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->psti));
				}
			break;

			case 9:
				if (r->pspn) {
					NDR_CHECK(ndr_push_SERVICE_PREFERRED_NODE_INFO(ndr, NDR_SCALARS, r->pspn));
				}
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_RPC_CONFIG_INFOW_u(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union SC_RPC_CONFIG_INFOW_u *r)
{
	uint32_t level;
	uint32_t _level;
	TALLOC_CTX *_mem_save_psd_0 = NULL;
	uint32_t _ptr_psd;
	TALLOC_CTX *_mem_save_psfa_0 = NULL;
	uint32_t _ptr_psfa;
	TALLOC_CTX *_mem_save_psda_0 = NULL;
	uint32_t _ptr_psda;
	TALLOC_CTX *_mem_save_psfaf_0 = NULL;
	uint32_t _ptr_psfaf;
	TALLOC_CTX *_mem_save_pssid_0 = NULL;
	uint32_t _ptr_pssid;
	TALLOC_CTX *_mem_save_psrp_0 = NULL;
	uint32_t _ptr_psrp;
	TALLOC_CTX *_mem_save_psps_0 = NULL;
	uint32_t _ptr_psps;
	TALLOC_CTX *_mem_save_psti_0 = NULL;
	uint32_t _ptr_psti;
	TALLOC_CTX *_mem_save_pspn_0 = NULL;
	uint32_t _ptr_pspn;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" for r at %s", (uint32_t)_level, __location__);
		}
		/* ms_union is always aligned to the largest union arm*/
		NDR_CHECK(ndr_pull_align(ndr, 5));
		switch (level) {
			case 1: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psd));
				if (_ptr_psd) {
					NDR_PULL_ALLOC(ndr, r->psd);
				} else {
					r->psd = NULL;
				}
			break; }

			case 2: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psfa));
				if (_ptr_psfa) {
					NDR_PULL_ALLOC(ndr, r->psfa);
				} else {
					r->psfa = NULL;
				}
			break; }

			case 3: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psda));
				if (_ptr_psda) {
					NDR_PULL_ALLOC(ndr, r->psda);
				} else {
					r->psda = NULL;
				}
			break; }

			case 4: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psfaf));
				if (_ptr_psfaf) {
					NDR_PULL_ALLOC(ndr, r->psfaf);
				} else {
					r->psfaf = NULL;
				}
			break; }

			case 5: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pssid));
				if (_ptr_pssid) {
					NDR_PULL_ALLOC(ndr, r->pssid);
				} else {
					r->pssid = NULL;
				}
			break; }

			case 6: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psrp));
				if (_ptr_psrp) {
					NDR_PULL_ALLOC(ndr, r->psrp);
				} else {
					r->psrp = NULL;
				}
			break; }

			case 7: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psps));
				if (_ptr_psps) {
					NDR_PULL_ALLOC(ndr, r->psps);
				} else {
					r->psps = NULL;
				}
			break; }

			case 8: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_psti));
				if (_ptr_psti) {
					NDR_PULL_ALLOC(ndr, r->psti);
				} else {
					r->psti = NULL;
				}
			break; }

			case 9: {
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_pspn));
				if (_ptr_pspn) {
					NDR_PULL_ALLOC(ndr, r->pspn);
				} else {
					r->pspn = NULL;
				}
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 1:
				if (r->psd) {
					_mem_save_psd_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psd, 0);
					NDR_CHECK(ndr_pull_SERVICE_DESCRIPTIONW(ndr, NDR_SCALARS|NDR_BUFFERS, r->psd));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psd_0, 0);
				}
			break;

			case 2:
				if (r->psfa) {
					_mem_save_psfa_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psfa, 0);
					NDR_CHECK(ndr_pull_SERVICE_FAILURE_ACTIONSW(ndr, NDR_SCALARS|NDR_BUFFERS, r->psfa));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psfa_0, 0);
				}
			break;

			case 3:
				if (r->psda) {
					_mem_save_psda_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psda, 0);
					NDR_CHECK(ndr_pull_SERVICE_DELAYED_AUTO_START_INFO(ndr, NDR_SCALARS, r->psda));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psda_0, 0);
				}
			break;

			case 4:
				if (r->psfaf) {
					_mem_save_psfaf_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psfaf, 0);
					NDR_CHECK(ndr_pull_SERVICE_FAILURE_ACTIONS_FLAG(ndr, NDR_SCALARS, r->psfaf));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psfaf_0, 0);
				}
			break;

			case 5:
				if (r->pssid) {
					_mem_save_pssid_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->pssid, 0);
					NDR_CHECK(ndr_pull_SERVICE_SID_INFO(ndr, NDR_SCALARS, r->pssid));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pssid_0, 0);
				}
			break;

			case 6:
				if (r->psrp) {
					_mem_save_psrp_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psrp, 0);
					NDR_CHECK(ndr_pull_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->psrp));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psrp_0, 0);
				}
			break;

			case 7:
				if (r->psps) {
					_mem_save_psps_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psps, 0);
					NDR_CHECK(ndr_pull_SERVICE_PRESHUTDOWN_INFO(ndr, NDR_SCALARS, r->psps));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psps_0, 0);
				}
			break;

			case 8:
				if (r->psti) {
					_mem_save_psti_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->psti, 0);
					NDR_CHECK(ndr_pull_SERVICE_TRIGGER_INFO(ndr, NDR_SCALARS|NDR_BUFFERS, r->psti));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_psti_0, 0);
				}
			break;

			case 9:
				if (r->pspn) {
					_mem_save_pspn_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->pspn, 0);
					NDR_CHECK(ndr_pull_SERVICE_PREFERRED_NODE_INFO(ndr, NDR_SCALARS, r->pspn));
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pspn_0, 0);
				}
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_RPC_CONFIG_INFOW_u(struct ndr_print *ndr, const char *name, const union SC_RPC_CONFIG_INFOW_u *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "SC_RPC_CONFIG_INFOW_u");
	switch (level) {
		case 1:
			ndr_print_ptr(ndr, "psd", r->psd);
			ndr->depth++;
			if (r->psd) {
				ndr_print_SERVICE_DESCRIPTIONW(ndr, "psd", r->psd);
			}
			ndr->depth--;
		break;

		case 2:
			ndr_print_ptr(ndr, "psfa", r->psfa);
			ndr->depth++;
			if (r->psfa) {
				ndr_print_SERVICE_FAILURE_ACTIONSW(ndr, "psfa", r->psfa);
			}
			ndr->depth--;
		break;

		case 3:
			ndr_print_ptr(ndr, "psda", r->psda);
			ndr->depth++;
			if (r->psda) {
				ndr_print_SERVICE_DELAYED_AUTO_START_INFO(ndr, "psda", r->psda);
			}
			ndr->depth--;
		break;

		case 4:
			ndr_print_ptr(ndr, "psfaf", r->psfaf);
			ndr->depth++;
			if (r->psfaf) {
				ndr_print_SERVICE_FAILURE_ACTIONS_FLAG(ndr, "psfaf", r->psfaf);
			}
			ndr->depth--;
		break;

		case 5:
			ndr_print_ptr(ndr, "pssid", r->pssid);
			ndr->depth++;
			if (r->pssid) {
				ndr_print_SERVICE_SID_INFO(ndr, "pssid", r->pssid);
			}
			ndr->depth--;
		break;

		case 6:
			ndr_print_ptr(ndr, "psrp", r->psrp);
			ndr->depth++;
			if (r->psrp) {
				ndr_print_SERVICE_RPC_REQUIRED_PRIVILEGES_INFO(ndr, "psrp", r->psrp);
			}
			ndr->depth--;
		break;

		case 7:
			ndr_print_ptr(ndr, "psps", r->psps);
			ndr->depth++;
			if (r->psps) {
				ndr_print_SERVICE_PRESHUTDOWN_INFO(ndr, "psps", r->psps);
			}
			ndr->depth--;
		break;

		case 8:
			ndr_print_ptr(ndr, "psti", r->psti);
			ndr->depth++;
			if (r->psti) {
				ndr_print_SERVICE_TRIGGER_INFO(ndr, "psti", r->psti);
			}
			ndr->depth--;
		break;

		case 9:
			ndr_print_ptr(ndr, "pspn", r->pspn);
			ndr->depth++;
			if (r->pspn) {
				ndr_print_SERVICE_PREFERRED_NODE_INFO(ndr, "pspn", r->pspn);
			}
			ndr->depth--;
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_SC_RPC_CONFIG_INFOW(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct SC_RPC_CONFIG_INFOW *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->dwInfoLevel));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->u, r->dwInfoLevel));
		NDR_CHECK(ndr_push_SC_RPC_CONFIG_INFOW_u(ndr, NDR_SCALARS, &r->u));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->u, r->dwInfoLevel));
		NDR_CHECK(ndr_push_SC_RPC_CONFIG_INFOW_u(ndr, NDR_BUFFERS, &r->u));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_SC_RPC_CONFIG_INFOW(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct SC_RPC_CONFIG_INFOW *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->dwInfoLevel));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->u, r->dwInfoLevel));
		NDR_CHECK(ndr_pull_SC_RPC_CONFIG_INFOW_u(ndr, NDR_SCALARS, &r->u));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->u, r->dwInfoLevel));
		NDR_CHECK(ndr_pull_SC_RPC_CONFIG_INFOW_u(ndr, NDR_BUFFERS, &r->u));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_SC_RPC_CONFIG_INFOW(struct ndr_print *ndr, const char *name, const struct SC_RPC_CONFIG_INFOW *r)
{
	ndr_print_struct(ndr, name, "SC_RPC_CONFIG_INFOW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "dwInfoLevel", r->dwInfoLevel);
	ndr_print_set_switch_value(ndr, &r->u, r->dwInfoLevel);
	ndr_print_SC_RPC_CONFIG_INFOW_u(ndr, "u", &r->u);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_CloseServiceHandle(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_CloseServiceHandle *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CloseServiceHandle(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_CloseServiceHandle *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.handle);
		*r->out.handle = *r->in.handle;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CloseServiceHandle(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_CloseServiceHandle *r)
{
	ndr_print_struct(ndr, name, "svcctl_CloseServiceHandle");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CloseServiceHandle");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CloseServiceHandle");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ControlService(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_ControlService *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_SERVICE_CONTROL(ndr, NDR_SCALARS, r->in.control));
	}
	if (flags & NDR_OUT) {
		if (r->out.service_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SERVICE_STATUS(ndr, NDR_SCALARS, r->out.service_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ControlService(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_ControlService *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_service_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SERVICE_CONTROL(ndr, NDR_SCALARS, &r->in.control));
		NDR_PULL_ALLOC(ndr, r->out.service_status);
		NDR_ZERO_STRUCTP(r->out.service_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.service_status);
		}
		_mem_save_service_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.service_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SERVICE_STATUS(ndr, NDR_SCALARS, r->out.service_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ControlService(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_ControlService *r)
{
	ndr_print_struct(ndr, name, "svcctl_ControlService");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ControlService");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_SERVICE_CONTROL(ndr, "control", r->in.control);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ControlService");
		ndr->depth++;
		ndr_print_ptr(ndr, "service_status", r->out.service_status);
		ndr->depth++;
		ndr_print_SERVICE_STATUS(ndr, "service_status", r->out.service_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_DeleteService(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_DeleteService *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_DeleteService(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_DeleteService *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_DeleteService(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_DeleteService *r)
{
	ndr_print_struct(ndr, name, "svcctl_DeleteService");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_DeleteService");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_DeleteService");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_LockServiceDatabase(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_LockServiceDatabase *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.lock == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.lock));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_LockServiceDatabase(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_LockServiceDatabase *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_lock_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.lock);
		NDR_ZERO_STRUCTP(r->out.lock);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lock);
		}
		_mem_save_lock_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lock, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.lock));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_LockServiceDatabase(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_LockServiceDatabase *r)
{
	ndr_print_struct(ndr, name, "svcctl_LockServiceDatabase");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_LockServiceDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_LockServiceDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock", r->out.lock);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "lock", r->out.lock);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceObjectSecurity(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceObjectSecurity *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.security_flags));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceObjectSecurity(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceObjectSecurity *r)
{
	uint32_t size_buffer_1 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.security_flags));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		if (r->in.offered > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.offered), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, r->in.offered);
		memset(r->out.buffer, 0, (r->in.offered) * sizeof(*r->out.buffer));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.buffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.buffer, &size_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.buffer, size_buffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, size_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		if (*r->out.needed > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.needed), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.buffer, r->in.offered));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceObjectSecurity(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceObjectSecurity *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceObjectSecurity");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceObjectSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_security_secinfo(ndr, "security_flags", r->in.security_flags);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceObjectSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.offered);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SetServiceObjectSecurity(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_SetServiceObjectSecurity *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_security_secinfo(ndr, NDR_SCALARS, r->in.security_flags));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.buffer, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SetServiceObjectSecurity(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_SetServiceObjectSecurity *r)
{
	uint32_t size_buffer_1 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_security_secinfo(ndr, NDR_SCALARS, &r->in.security_flags));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.buffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.buffer, &size_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.buffer, size_buffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.buffer, size_buffer_1));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		if (r->in.buffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.buffer, r->in.offered));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SetServiceObjectSecurity(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_SetServiceObjectSecurity *r)
{
	ndr_print_struct(ndr, name, "svcctl_SetServiceObjectSecurity");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SetServiceObjectSecurity");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_security_secinfo(ndr, "security_flags", r->in.security_flags);
		ndr_print_ptr(ndr, "buffer", r->in.buffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->in.buffer, r->in.offered);
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SetServiceObjectSecurity");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceStatus(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceStatus *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
	}
	if (flags & NDR_OUT) {
		if (r->out.service_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SERVICE_STATUS(ndr, NDR_SCALARS, r->out.service_status));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceStatus(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceStatus *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_service_status_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.service_status);
		NDR_ZERO_STRUCTP(r->out.service_status);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.service_status);
		}
		_mem_save_service_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.service_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SERVICE_STATUS(ndr, NDR_SCALARS, r->out.service_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_status_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceStatus(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceStatus *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceStatus");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceStatus");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceStatus");
		ndr->depth++;
		ndr_print_ptr(ndr, "service_status", r->out.service_status);
		ndr->depth++;
		ndr_print_SERVICE_STATUS(ndr, "service_status", r->out.service_status);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SetServiceStatus(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_SetServiceStatus *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SetServiceStatus(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_SetServiceStatus *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SetServiceStatus(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_SetServiceStatus *r)
{
	ndr_print_struct(ndr, name, "svcctl_SetServiceStatus");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SetServiceStatus");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SetServiceStatus");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_UnlockServiceDatabase(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_UnlockServiceDatabase *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lock == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.lock));
	}
	if (flags & NDR_OUT) {
		if (r->out.lock == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.lock));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_UnlockServiceDatabase(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_UnlockServiceDatabase *r)
{
	TALLOC_CTX *_mem_save_lock_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.lock);
		}
		_mem_save_lock_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.lock, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.lock));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.lock);
		*r->out.lock = *r->in.lock;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.lock == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.lock);
			NDR_ZERO_STRUCTP(r->in.lock);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lock);
		}
		_mem_save_lock_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lock, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.lock));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_UnlockServiceDatabase(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_UnlockServiceDatabase *r)
{
	ndr_print_struct(ndr, name, "svcctl_UnlockServiceDatabase");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_UnlockServiceDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock", r->in.lock);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "lock", r->in.lock);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_UnlockServiceDatabase");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock", r->out.lock);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "lock", r->out.lock);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_NotifyBootConfigStatus(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_NotifyBootConfigStatus *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_NotifyBootConfigStatus(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_NotifyBootConfigStatus *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_NotifyBootConfigStatus(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_NotifyBootConfigStatus *r)
{
	ndr_print_struct(ndr, name, "svcctl_NotifyBootConfigStatus");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_NotifyBootConfigStatus");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_NotifyBootConfigStatus");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SCSetServiceBitsW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_SCSetServiceBitsW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bits));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bitson));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.immediate));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SCSetServiceBitsW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_SCSetServiceBitsW *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bits));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bitson));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.immediate));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SCSetServiceBitsW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_SCSetServiceBitsW *r)
{
	ndr_print_struct(ndr, name, "svcctl_SCSetServiceBitsW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SCSetServiceBitsW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "bits", r->in.bits);
		ndr_print_uint32(ndr, "bitson", r->in.bitson);
		ndr_print_uint32(ndr, "immediate", r->in.immediate);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SCSetServiceBitsW");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_svcctl_ChangeServiceConfigW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_ChangeServiceConfigW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_svcctl_StartType(ndr, NDR_SCALARS, r->in.start_type));
		NDR_CHECK(ndr_push_svcctl_ErrorControl(ndr, NDR_SCALARS, r->in.error_control));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.binary_path));
		if (r->in.binary_path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.binary_path, ndr_charset_length(r->in.binary_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.load_order_group));
		if (r->in.load_order_group) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.load_order_group, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.load_order_group, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.load_order_group, ndr_charset_length(r->in.load_order_group, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.tag_id));
		if (r->in.tag_id) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.tag_id));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dependencies));
		if (r->in.dependencies) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwDependSize));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwDependSize));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dependencies, r->in.dwDependSize, sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwDependSize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_start_name));
		if (r->in.service_start_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_start_name, ndr_charset_length(r->in.service_start_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password));
		if (r->in.password) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwPwSize));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwPwSize));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.password, r->in.dwPwSize, sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwPwSize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name));
		if (r->in.display_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.display_name, ndr_charset_length(r->in.display_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.tag_id));
		if (r->out.tag_id) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.tag_id));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_svcctl_ChangeServiceConfigW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_ChangeServiceConfigW *r)
{
	uint32_t _ptr_binary_path;
	uint32_t size_binary_path_1 = 0;
	uint32_t length_binary_path_1 = 0;
	uint32_t _ptr_load_order_group;
	uint32_t size_load_order_group_1 = 0;
	uint32_t length_load_order_group_1 = 0;
	uint32_t _ptr_tag_id;
	uint32_t _ptr_dependencies;
	uint32_t size_dependencies_1 = 0;
	uint32_t length_dependencies_1 = 0;
	uint32_t _ptr_service_start_name;
	uint32_t size_service_start_name_1 = 0;
	uint32_t length_service_start_name_1 = 0;
	uint32_t _ptr_password;
	uint32_t size_password_1 = 0;
	uint32_t length_password_1 = 0;
	uint32_t _ptr_display_name;
	uint32_t size_display_name_1 = 0;
	uint32_t length_display_name_1 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_binary_path_0 = NULL;
	TALLOC_CTX *_mem_save_load_order_group_0 = NULL;
	TALLOC_CTX *_mem_save_tag_id_0 = NULL;
	TALLOC_CTX *_mem_save_dependencies_0 = NULL;
	TALLOC_CTX *_mem_save_service_start_name_0 = NULL;
	TALLOC_CTX *_mem_save_password_0 = NULL;
	TALLOC_CTX *_mem_save_display_name_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_svcctl_StartType(ndr, NDR_SCALARS, &r->in.start_type));
		NDR_CHECK(ndr_pull_svcctl_ErrorControl(ndr, NDR_SCALARS, &r->in.error_control));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary_path));
		if (_ptr_binary_path) {
			NDR_PULL_ALLOC(ndr, r->in.binary_path);
		} else {
			r->in.binary_path = NULL;
		}
		if (r->in.binary_path) {
			_mem_save_binary_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.binary_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.binary_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.binary_path));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.binary_path, &size_binary_path_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.binary_path, &length_binary_path_1));
			if (length_binary_path_1 > size_binary_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_binary_path_1, length_binary_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_binary_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.binary_path, length_binary_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_path_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_load_order_group));
		if (_ptr_load_order_group) {
			NDR_PULL_ALLOC(ndr, r->in.load_order_group);
		} else {
			r->in.load_order_group = NULL;
		}
		if (r->in.load_order_group) {
			_mem_save_load_order_group_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.load_order_group, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.load_order_group));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.load_order_group));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.load_order_group, &size_load_order_group_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.load_order_group, &length_load_order_group_1));
			if (length_load_order_group_1 > size_load_order_group_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_load_order_group_1, length_load_order_group_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_load_order_group_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.load_order_group, length_load_order_group_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_load_order_group_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_tag_id));
		if (_ptr_tag_id) {
			NDR_PULL_ALLOC(ndr, r->in.tag_id);
		} else {
			r->in.tag_id = NULL;
		}
		if (r->in.tag_id) {
			_mem_save_tag_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.tag_id, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.tag_id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tag_id_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->in.dependencies);
		} else {
			r->in.dependencies = NULL;
		}
		if (r->in.dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.dependencies, &size_dependencies_1));
			NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->in.dependencies, &length_dependencies_1));
			if (length_dependencies_1 > size_dependencies_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dependencies_1, length_dependencies_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dependencies_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dependencies, length_dependencies_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwDependSize));
		if (r->in.dwDependSize > SC_MAX_DEPEND_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.dwDependSize), (uint32_t)(0), (uint32_t)(SC_MAX_DEPEND_SIZE));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_start_name));
		if (_ptr_service_start_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_start_name);
		} else {
			r->in.service_start_name = NULL;
		}
		if (r->in.service_start_name) {
			_mem_save_service_start_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_start_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.service_start_name, &size_service_start_name_1));
			if (size_service_start_name_1 > SC_MAX_ACCOUNT_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_service_start_name_1, (uint32_t)(0), (uint32_t)(SC_MAX_ACCOUNT_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.service_start_name, &length_service_start_name_1));
			if (length_service_start_name_1 > SC_MAX_ACCOUNT_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_service_start_name_1, (uint32_t)(0), (uint32_t)(SC_MAX_ACCOUNT_NAME_LENGTH));
			}
			if (length_service_start_name_1 > size_service_start_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_service_start_name_1, length_service_start_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_service_start_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_start_name, length_service_start_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_start_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->in.password);
		} else {
			r->in.password = NULL;
		}
		if (r->in.password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.password));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.password, &size_password_1));
			NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->in.password, &length_password_1));
			if (length_password_1 > size_password_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_password_1, length_password_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_password_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.password, length_password_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwPwSize));
		if (r->in.dwPwSize > SC_MAX_PWD_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.dwPwSize), (uint32_t)(0), (uint32_t)(SC_MAX_PWD_SIZE));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
		if (_ptr_display_name) {
			NDR_PULL_ALLOC(ndr, r->in.display_name);
		} else {
			r->in.display_name = NULL;
		}
		if (r->in.display_name) {
			_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.display_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.display_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.display_name, &size_display_name_1));
			if (size_display_name_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_display_name_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.display_name, &length_display_name_1));
			if (length_display_name_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_display_name_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			if (length_display_name_1 > size_display_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_display_name_1, length_display_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_display_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.display_name, length_display_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, 0);
		}
		if (r->in.dependencies) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.dependencies, r->in.dwDependSize));
		}
		if (r->in.dependencies) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->in.dependencies, r->in.dwDependSize));
		}
		if (r->in.password) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.password, r->in.dwPwSize));
		}
		if (r->in.password) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->in.password, r->in.dwPwSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_tag_id));
		if (_ptr_tag_id) {
			NDR_PULL_ALLOC(ndr, r->out.tag_id);
		} else {
			r->out.tag_id = NULL;
		}
		if (r->out.tag_id) {
			_mem_save_tag_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.tag_id, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.tag_id));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tag_id_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ChangeServiceConfigW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_ChangeServiceConfigW *r)
{
	ndr_print_struct(ndr, name, "svcctl_ChangeServiceConfigW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ChangeServiceConfigW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_svcctl_StartType(ndr, "start_type", r->in.start_type);
		ndr_print_svcctl_ErrorControl(ndr, "error_control", r->in.error_control);
		ndr_print_ptr(ndr, "binary_path", r->in.binary_path);
		ndr->depth++;
		if (r->in.binary_path) {
			ndr_print_string(ndr, "binary_path", r->in.binary_path);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "load_order_group", r->in.load_order_group);
		ndr->depth++;
		if (r->in.load_order_group) {
			ndr_print_string(ndr, "load_order_group", r->in.load_order_group);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "tag_id", r->in.tag_id);
		ndr->depth++;
		if (r->in.tag_id) {
			ndr_print_uint32(ndr, "tag_id", *r->in.tag_id);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dependencies", r->in.dependencies);
		ndr->depth++;
		if (r->in.dependencies) {
			ndr_print_string(ndr, "dependencies", r->in.dependencies);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwDependSize", r->in.dwDependSize);
		ndr_print_ptr(ndr, "service_start_name", r->in.service_start_name);
		ndr->depth++;
		if (r->in.service_start_name) {
			ndr_print_string(ndr, "service_start_name", r->in.service_start_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwPwSize", r->in.dwPwSize);
		ndr_print_ptr(ndr, "display_name", r->in.display_name);
		ndr->depth++;
		if (r->in.display_name) {
			ndr_print_string(ndr, "display_name", r->in.display_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ChangeServiceConfigW");
		ndr->depth++;
		ndr_print_ptr(ndr, "tag_id", r->out.tag_id);
		ndr->depth++;
		if (r->out.tag_id) {
			ndr_print_uint32(ndr, "tag_id", *r->out.tag_id);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_CreateServiceW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_CreateServiceW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.scmanager_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.scmanager_handle));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ServiceName, ndr_charset_length(r->in.ServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.DisplayName));
		if (r->in.DisplayName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.DisplayName, ndr_charset_length(r->in.DisplayName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.desired_access));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_svcctl_StartType(ndr, NDR_SCALARS, r->in.start_type));
		NDR_CHECK(ndr_push_svcctl_ErrorControl(ndr, NDR_SCALARS, r->in.error_control));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.binary_path, ndr_charset_length(r->in.binary_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.LoadOrderGroupKey));
		if (r->in.LoadOrderGroupKey) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.LoadOrderGroupKey, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.TagId));
		if (r->in.TagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.TagId));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dependencies));
		if (r->in.dependencies) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dependencies_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.dependencies, r->in.dependencies_size));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dependencies_size));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_start_name));
		if (r->in.service_start_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_start_name, ndr_charset_length(r->in.service_start_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password));
		if (r->in.password) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.password_size));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.password, r->in.password_size));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.password_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.TagId));
		if (r->out.TagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.TagId));
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CreateServiceW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_CreateServiceW *r)
{
	uint32_t size_ServiceName_0 = 0;
	uint32_t length_ServiceName_0 = 0;
	uint32_t _ptr_DisplayName;
	uint32_t size_DisplayName_1 = 0;
	uint32_t length_DisplayName_1 = 0;
	uint32_t size_binary_path_0 = 0;
	uint32_t length_binary_path_0 = 0;
	uint32_t _ptr_LoadOrderGroupKey;
	uint32_t size_LoadOrderGroupKey_1 = 0;
	uint32_t length_LoadOrderGroupKey_1 = 0;
	uint32_t _ptr_TagId;
	uint32_t _ptr_dependencies;
	uint32_t size_dependencies_1 = 0;
	uint32_t _ptr_service_start_name;
	uint32_t size_service_start_name_1 = 0;
	uint32_t length_service_start_name_1 = 0;
	uint32_t _ptr_password;
	uint32_t size_password_1 = 0;
	TALLOC_CTX *_mem_save_scmanager_handle_0 = NULL;
	TALLOC_CTX *_mem_save_DisplayName_0 = NULL;
	TALLOC_CTX *_mem_save_LoadOrderGroupKey_0 = NULL;
	TALLOC_CTX *_mem_save_TagId_0 = NULL;
	TALLOC_CTX *_mem_save_dependencies_0 = NULL;
	TALLOC_CTX *_mem_save_service_start_name_0 = NULL;
	TALLOC_CTX *_mem_save_password_0 = NULL;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager_handle);
		}
		_mem_save_scmanager_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.scmanager_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ServiceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ServiceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.ServiceName, &size_ServiceName_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.ServiceName, &length_ServiceName_0));
		if (length_ServiceName_0 > size_ServiceName_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ServiceName_0, length_ServiceName_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_ServiceName_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ServiceName, length_ServiceName_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DisplayName));
		if (_ptr_DisplayName) {
			NDR_PULL_ALLOC(ndr, r->in.DisplayName);
		} else {
			r->in.DisplayName = NULL;
		}
		if (r->in.DisplayName) {
			_mem_save_DisplayName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.DisplayName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.DisplayName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.DisplayName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.DisplayName, &size_DisplayName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.DisplayName, &length_DisplayName_1));
			if (length_DisplayName_1 > size_DisplayName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_DisplayName_1, length_DisplayName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_DisplayName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.DisplayName, length_DisplayName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DisplayName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.desired_access));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_svcctl_StartType(ndr, NDR_SCALARS, &r->in.start_type));
		NDR_CHECK(ndr_pull_svcctl_ErrorControl(ndr, NDR_SCALARS, &r->in.error_control));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.binary_path));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.binary_path));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.binary_path, &size_binary_path_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.binary_path, &length_binary_path_0));
		if (length_binary_path_0 > size_binary_path_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_binary_path_0, length_binary_path_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_binary_path_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.binary_path, length_binary_path_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_LoadOrderGroupKey));
		if (_ptr_LoadOrderGroupKey) {
			NDR_PULL_ALLOC(ndr, r->in.LoadOrderGroupKey);
		} else {
			r->in.LoadOrderGroupKey = NULL;
		}
		if (r->in.LoadOrderGroupKey) {
			_mem_save_LoadOrderGroupKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.LoadOrderGroupKey, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.LoadOrderGroupKey));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.LoadOrderGroupKey));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.LoadOrderGroupKey, &size_LoadOrderGroupKey_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.LoadOrderGroupKey, &length_LoadOrderGroupKey_1));
			if (length_LoadOrderGroupKey_1 > size_LoadOrderGroupKey_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_LoadOrderGroupKey_1, length_LoadOrderGroupKey_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_LoadOrderGroupKey_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.LoadOrderGroupKey, length_LoadOrderGroupKey_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LoadOrderGroupKey_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_TagId));
		if (_ptr_TagId) {
			NDR_PULL_ALLOC(ndr, r->in.TagId);
		} else {
			r->in.TagId = NULL;
		}
		if (r->in.TagId) {
			_mem_save_TagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.TagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.TagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_TagId_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->in.dependencies);
		} else {
			r->in.dependencies = NULL;
		}
		if (r->in.dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.dependencies, &size_dependencies_1));
			NDR_PULL_ALLOC_N(ndr, r->in.dependencies, size_dependencies_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.dependencies, size_dependencies_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dependencies_size));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_start_name));
		if (_ptr_service_start_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_start_name);
		} else {
			r->in.service_start_name = NULL;
		}
		if (r->in.service_start_name) {
			_mem_save_service_start_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_start_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.service_start_name, &size_service_start_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.service_start_name, &length_service_start_name_1));
			if (length_service_start_name_1 > size_service_start_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_service_start_name_1, length_service_start_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_service_start_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_start_name, length_service_start_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_start_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->in.password);
		} else {
			r->in.password = NULL;
		}
		if (r->in.password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.password));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.password, &size_password_1));
			NDR_PULL_ALLOC_N(ndr, r->in.password, size_password_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.password, size_password_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.password_size));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		NDR_ZERO_STRUCTP(r->out.handle);
		if (r->in.dependencies) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.dependencies, r->in.dependencies_size));
		}
		if (r->in.password) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.password, r->in.password_size));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.scmanager_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager_handle);
			NDR_ZERO_STRUCTP(r->in.scmanager_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_TagId));
		if (_ptr_TagId) {
			NDR_PULL_ALLOC(ndr, r->out.TagId);
		} else {
			r->out.TagId = NULL;
		}
		if (r->out.TagId) {
			_mem_save_TagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.TagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.TagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_TagId_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CreateServiceW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_CreateServiceW *r)
{
	ndr_print_struct(ndr, name, "svcctl_CreateServiceW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CreateServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth--;
		ndr_print_string(ndr, "ServiceName", r->in.ServiceName);
		ndr_print_ptr(ndr, "DisplayName", r->in.DisplayName);
		ndr->depth++;
		if (r->in.DisplayName) {
			ndr_print_string(ndr, "DisplayName", r->in.DisplayName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "desired_access", r->in.desired_access);
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_svcctl_StartType(ndr, "start_type", r->in.start_type);
		ndr_print_svcctl_ErrorControl(ndr, "error_control", r->in.error_control);
		ndr_print_string(ndr, "binary_path", r->in.binary_path);
		ndr_print_ptr(ndr, "LoadOrderGroupKey", r->in.LoadOrderGroupKey);
		ndr->depth++;
		if (r->in.LoadOrderGroupKey) {
			ndr_print_string(ndr, "LoadOrderGroupKey", r->in.LoadOrderGroupKey);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "TagId", r->in.TagId);
		ndr->depth++;
		if (r->in.TagId) {
			ndr_print_uint32(ndr, "TagId", *r->in.TagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dependencies", r->in.dependencies);
		ndr->depth++;
		if (r->in.dependencies) {
			ndr_print_array_uint8(ndr, "dependencies", r->in.dependencies, r->in.dependencies_size);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dependencies_size", r->in.dependencies_size);
		ndr_print_ptr(ndr, "service_start_name", r->in.service_start_name);
		ndr->depth++;
		if (r->in.service_start_name) {
			ndr_print_string(ndr, "service_start_name", r->in.service_start_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_array_uint8(ndr, "password", r->in.password, r->in.password_size);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "password_size", r->in.password_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CreateServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "TagId", r->out.TagId);
		ndr->depth++;
		if (r->out.TagId) {
			ndr_print_uint32(ndr, "TagId", *r->out.TagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumDependentServicesW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_EnumDependentServicesW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.service == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.service));
		NDR_CHECK(ndr_push_svcctl_ServiceState(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.service_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.services_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.service_status, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.services_returned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumDependentServicesW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_EnumDependentServicesW *r)
{
	uint32_t size_service_status_1 = 0;
	TALLOC_CTX *_mem_save_service_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	TALLOC_CTX *_mem_save_services_returned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.service);
		}
		_mem_save_service_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.service, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.service));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_svcctl_ServiceState(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		if (r->in.offered > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.offered), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_ALLOC_N(ndr, r->out.service_status, r->in.offered);
		memset(r->out.service_status, 0, (r->in.offered) * sizeof(*r->out.service_status));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.services_returned);
		NDR_ZERO_STRUCTP(r->out.services_returned);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.service == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.service);
			NDR_ZERO_STRUCTP(r->in.service);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.service_status));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.service_status, &size_service_status_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.service_status, size_service_status_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.service_status, size_service_status_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		if (*r->out.needed > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.needed), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.services_returned);
		}
		_mem_save_services_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.services_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.services_returned));
		if (*r->out.services_returned > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.services_returned), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_services_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.service_status) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.service_status, r->in.offered));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumDependentServicesW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_EnumDependentServicesW *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumDependentServicesW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumDependentServicesW");
		ndr->depth++;
		ndr_print_ptr(ndr, "service", r->in.service);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "service", r->in.service);
		ndr->depth--;
		ndr_print_svcctl_ServiceState(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumDependentServicesW");
		ndr->depth++;
		ndr_print_ptr(ndr, "service_status", r->out.service_status);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "service_status", r->out.service_status, r->in.offered);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "services_returned", r->out.services_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "services_returned", *r->out.services_returned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumServicesStatusW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_EnumServicesStatusW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_svcctl_ServiceState(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.service == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.services_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.service, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.services_returned));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumServicesStatusW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_EnumServicesStatusW *r)
{
	uint32_t size_service_1 = 0;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	TALLOC_CTX *_mem_save_services_returned_0 = NULL;
	TALLOC_CTX *_mem_save_resume_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_svcctl_ServiceState(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		if (r->in.offered > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.offered), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC_N(ndr, r->out.service, r->in.offered);
		memset(r->out.service, 0, (r->in.offered) * sizeof(*r->out.service));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.services_returned);
		NDR_ZERO_STRUCTP(r->out.services_returned);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.service));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.service, &size_service_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.service, size_service_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.service, size_service_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		if (*r->out.needed > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.needed), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.services_returned);
		}
		_mem_save_services_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.services_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.services_returned));
		if (*r->out.services_returned > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.services_returned), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_services_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.service) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.service, r->in.offered));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumServicesStatusW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_EnumServicesStatusW *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumServicesStatusW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumServicesStatusW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_svcctl_ServiceState(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumServicesStatusW");
		ndr->depth++;
		ndr_print_ptr(ndr, "service", r->out.service);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "service", r->out.service, r->in.offered);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "services_returned", r->out.services_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "services_returned", *r->out.services_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_OpenSCManagerW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_OpenSCManagerW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.MachineName));
		if (r->in.MachineName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.MachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.MachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.MachineName, ndr_charset_length(r->in.MachineName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.DatabaseName));
		if (r->in.DatabaseName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.DatabaseName, ndr_charset_length(r->in.DatabaseName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_svcctl_MgrAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_OpenSCManagerW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_OpenSCManagerW *r)
{
	uint32_t _ptr_MachineName;
	uint32_t size_MachineName_1 = 0;
	uint32_t length_MachineName_1 = 0;
	uint32_t _ptr_DatabaseName;
	uint32_t size_DatabaseName_1 = 0;
	uint32_t length_DatabaseName_1 = 0;
	TALLOC_CTX *_mem_save_MachineName_0 = NULL;
	TALLOC_CTX *_mem_save_DatabaseName_0 = NULL;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_MachineName));
		if (_ptr_MachineName) {
			NDR_PULL_ALLOC(ndr, r->in.MachineName);
		} else {
			r->in.MachineName = NULL;
		}
		if (r->in.MachineName) {
			_mem_save_MachineName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.MachineName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.MachineName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.MachineName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.MachineName, &size_MachineName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.MachineName, &length_MachineName_1));
			if (length_MachineName_1 > size_MachineName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_MachineName_1, length_MachineName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_MachineName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.MachineName, length_MachineName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_MachineName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DatabaseName));
		if (_ptr_DatabaseName) {
			NDR_PULL_ALLOC(ndr, r->in.DatabaseName);
		} else {
			r->in.DatabaseName = NULL;
		}
		if (r->in.DatabaseName) {
			_mem_save_DatabaseName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.DatabaseName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.DatabaseName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.DatabaseName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.DatabaseName, &size_DatabaseName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.DatabaseName, &length_DatabaseName_1));
			if (length_DatabaseName_1 > size_DatabaseName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_DatabaseName_1, length_DatabaseName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_DatabaseName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.DatabaseName, length_DatabaseName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DatabaseName_0, 0);
		}
		NDR_CHECK(ndr_pull_svcctl_MgrAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		NDR_ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_OpenSCManagerW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_OpenSCManagerW *r)
{
	ndr_print_struct(ndr, name, "svcctl_OpenSCManagerW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_OpenSCManagerW");
		ndr->depth++;
		ndr_print_ptr(ndr, "MachineName", r->in.MachineName);
		ndr->depth++;
		if (r->in.MachineName) {
			ndr_print_string(ndr, "MachineName", r->in.MachineName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "DatabaseName", r->in.DatabaseName);
		ndr->depth++;
		if (r->in.DatabaseName) {
			ndr_print_string(ndr, "DatabaseName", r->in.DatabaseName);
		}
		ndr->depth--;
		ndr_print_svcctl_MgrAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_OpenSCManagerW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_OpenServiceW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_OpenServiceW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.scmanager_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.scmanager_handle));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ServiceName, ndr_charset_length(r->in.ServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_svcctl_ServiceAccessMask(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_OpenServiceW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_OpenServiceW *r)
{
	uint32_t size_ServiceName_0 = 0;
	uint32_t length_ServiceName_0 = 0;
	TALLOC_CTX *_mem_save_scmanager_handle_0 = NULL;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager_handle);
		}
		_mem_save_scmanager_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.scmanager_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ServiceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ServiceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.ServiceName, &size_ServiceName_0));
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.ServiceName, &length_ServiceName_0));
		if (length_ServiceName_0 > size_ServiceName_0) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ServiceName_0, length_ServiceName_0);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_ServiceName_0, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ServiceName, length_ServiceName_0, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_svcctl_ServiceAccessMask(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		NDR_ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.scmanager_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager_handle);
			NDR_ZERO_STRUCTP(r->in.scmanager_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_OpenServiceW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_OpenServiceW *r)
{
	ndr_print_struct(ndr, name, "svcctl_OpenServiceW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_OpenServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth--;
		ndr_print_string(ndr, "ServiceName", r->in.ServiceName);
		ndr_print_svcctl_ServiceAccessMask(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_OpenServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceConfigW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceConfigW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.query == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_QUERY_SERVICE_CONFIG(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceConfigW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceConfigW *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_query_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		if (r->in.offered > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.offered), (uint32_t)(0), (uint32_t)(8192));
		}
		NDR_PULL_ALLOC(ndr, r->out.query);
		NDR_ZERO_STRUCTP(r->out.query);
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.query);
		}
		_mem_save_query_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.query, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_QUERY_SERVICE_CONFIG(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.query));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_query_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		if (*r->out.needed > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.needed), (uint32_t)(0), (uint32_t)(8192));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceConfigW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceConfigW *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceConfigW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceConfigW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceConfigW");
		ndr->depth++;
		ndr_print_ptr(ndr, "query", r->out.query);
		ndr->depth++;
		ndr_print_QUERY_SERVICE_CONFIG(ndr, "query", r->out.query);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceLockStatusW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceLockStatusW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.lock_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SERVICE_LOCK_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock_status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceLockStatusW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceLockStatusW *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_lock_status_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.lock_status);
		NDR_ZERO_STRUCTP(r->out.lock_status);
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lock_status);
		}
		_mem_save_lock_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lock_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SERVICE_LOCK_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceLockStatusW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceLockStatusW *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceLockStatusW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceLockStatusW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceLockStatusW");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock_status", r->out.lock_status);
		ndr->depth++;
		ndr_print_SERVICE_LOCK_STATUS(ndr, "lock_status", r->out.lock_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_StartServiceW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_StartServiceW *r)
{
	uint32_t cntr_Arguments_1;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.NumArgs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Arguments));
		if (r->in.Arguments) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.NumArgs));
			for (cntr_Arguments_1 = 0; cntr_Arguments_1 < (r->in.NumArgs); cntr_Arguments_1++) {
				NDR_CHECK(ndr_push_svcctl_ArgumentString(ndr, NDR_SCALARS, &r->in.Arguments[cntr_Arguments_1]));
			}
			for (cntr_Arguments_1 = 0; cntr_Arguments_1 < (r->in.NumArgs); cntr_Arguments_1++) {
				NDR_CHECK(ndr_push_svcctl_ArgumentString(ndr, NDR_BUFFERS, &r->in.Arguments[cntr_Arguments_1]));
			}
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_StartServiceW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_StartServiceW *r)
{
	uint32_t _ptr_Arguments;
	uint32_t size_Arguments_1 = 0;
	uint32_t cntr_Arguments_1;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_Arguments_0 = NULL;
	TALLOC_CTX *_mem_save_Arguments_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.NumArgs));
		if (r->in.NumArgs > SC_MAX_ARGUMENTS) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.NumArgs), (uint32_t)(0), (uint32_t)(SC_MAX_ARGUMENTS));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Arguments));
		if (_ptr_Arguments) {
			NDR_PULL_ALLOC(ndr, r->in.Arguments);
		} else {
			r->in.Arguments = NULL;
		}
		if (r->in.Arguments) {
			_mem_save_Arguments_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Arguments, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Arguments));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.Arguments, &size_Arguments_1));
			NDR_PULL_ALLOC_N(ndr, r->in.Arguments, size_Arguments_1);
			_mem_save_Arguments_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Arguments, 0);
			for (cntr_Arguments_1 = 0; cntr_Arguments_1 < (size_Arguments_1); cntr_Arguments_1++) {
				NDR_CHECK(ndr_pull_svcctl_ArgumentString(ndr, NDR_SCALARS, &r->in.Arguments[cntr_Arguments_1]));
			}
			for (cntr_Arguments_1 = 0; cntr_Arguments_1 < (size_Arguments_1); cntr_Arguments_1++) {
				NDR_CHECK(ndr_pull_svcctl_ArgumentString(ndr, NDR_BUFFERS, &r->in.Arguments[cntr_Arguments_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Arguments_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Arguments_0, 0);
		}
		if (r->in.Arguments) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->in.Arguments, r->in.NumArgs));
		}
		for (cntr_Arguments_1 = 0; cntr_Arguments_1 < (size_Arguments_1); cntr_Arguments_1++) {
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_StartServiceW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_StartServiceW *r)
{
	uint32_t cntr_Arguments_1;
	ndr_print_struct(ndr, name, "svcctl_StartServiceW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_StartServiceW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "NumArgs", r->in.NumArgs);
		ndr_print_ptr(ndr, "Arguments", r->in.Arguments);
		ndr->depth++;
		if (r->in.Arguments) {
			ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "Arguments", (uint32_t)(r->in.NumArgs));
			ndr->depth++;
			for (cntr_Arguments_1 = 0; cntr_Arguments_1 < (r->in.NumArgs); cntr_Arguments_1++) {
				ndr_print_svcctl_ArgumentString(ndr, "Arguments", &r->in.Arguments[cntr_Arguments_1]);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_StartServiceW");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetServiceDisplayNameW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_GetServiceDisplayNameW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_name));
		if (r->in.service_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_name, ndr_charset_length(r->in.service_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name_length));
		if (r->in.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.display_name_length));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.display_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.display_name));
		if (*r->out.display_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.display_name, ndr_charset_length(*r->out.display_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.display_name_length));
		if (r->out.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.display_name_length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetServiceDisplayNameW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_GetServiceDisplayNameW *r)
{
	uint32_t _ptr_service_name;
	uint32_t size_service_name_1 = 0;
	uint32_t length_service_name_1 = 0;
	uint32_t _ptr_display_name;
	uint32_t size_display_name_2 = 0;
	uint32_t length_display_name_2 = 0;
	uint32_t _ptr_display_name_length;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_service_name_0 = NULL;
	TALLOC_CTX *_mem_save_display_name_0 = NULL;
	TALLOC_CTX *_mem_save_display_name_1 = NULL;
	TALLOC_CTX *_mem_save_display_name_length_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
		if (_ptr_service_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_name);
		} else {
			r->in.service_name = NULL;
		}
		if (r->in.service_name) {
			_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.service_name, &size_service_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.service_name, &length_service_name_1));
			if (length_service_name_1 > size_service_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_service_name_1, length_service_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_service_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_name, length_service_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->in.display_name_length);
		} else {
			r->in.display_name_length = NULL;
		}
		if (r->in.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.display_name);
		NDR_ZERO_STRUCTP(r->out.display_name);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.display_name);
		}
		_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
		if (_ptr_display_name) {
			NDR_PULL_ALLOC(ndr, *r->out.display_name);
		} else {
			*r->out.display_name = NULL;
		}
		if (*r->out.display_name) {
			_mem_save_display_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.display_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.display_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.display_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.display_name, &size_display_name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.display_name, &length_display_name_2));
			if (length_display_name_2 > size_display_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_display_name_2, length_display_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_display_name_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.display_name, length_display_name_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->out.display_name_length);
		} else {
			r->out.display_name_length = NULL;
		}
		if (r->out.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetServiceDisplayNameW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_GetServiceDisplayNameW *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetServiceDisplayNameW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetServiceDisplayNameW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_name", r->in.service_name);
		ndr->depth++;
		if (r->in.service_name) {
			ndr_print_string(ndr, "service_name", r->in.service_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->in.display_name_length);
		ndr->depth++;
		if (r->in.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->in.display_name_length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetServiceDisplayNameW");
		ndr->depth++;
		ndr_print_ptr(ndr, "display_name", r->out.display_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "display_name", *r->out.display_name);
		ndr->depth++;
		if (*r->out.display_name) {
			ndr_print_string(ndr, "display_name", *r->out.display_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->out.display_name_length);
		ndr->depth++;
		if (r->out.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->out.display_name_length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetServiceKeyNameW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_GetServiceKeyNameW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_name));
		if (r->in.service_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_name, ndr_charset_length(r->in.service_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name_length));
		if (r->in.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.display_name_length));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.key_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.key_name));
		if (*r->out.key_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.key_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.key_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.key_name, ndr_charset_length(*r->out.key_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.display_name_length));
		if (r->out.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.display_name_length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetServiceKeyNameW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_GetServiceKeyNameW *r)
{
	uint32_t _ptr_service_name;
	uint32_t size_service_name_1 = 0;
	uint32_t length_service_name_1 = 0;
	uint32_t _ptr_key_name;
	uint32_t size_key_name_2 = 0;
	uint32_t length_key_name_2 = 0;
	uint32_t _ptr_display_name_length;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_service_name_0 = NULL;
	TALLOC_CTX *_mem_save_key_name_0 = NULL;
	TALLOC_CTX *_mem_save_key_name_1 = NULL;
	TALLOC_CTX *_mem_save_display_name_length_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
		if (_ptr_service_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_name);
		} else {
			r->in.service_name = NULL;
		}
		if (r->in.service_name) {
			_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.service_name, &size_service_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.service_name, &length_service_name_1));
			if (length_service_name_1 > size_service_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_service_name_1, length_service_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_service_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_name, length_service_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->in.display_name_length);
		} else {
			r->in.display_name_length = NULL;
		}
		if (r->in.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.key_name);
		NDR_ZERO_STRUCTP(r->out.key_name);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.key_name);
		}
		_mem_save_key_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.key_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_key_name));
		if (_ptr_key_name) {
			NDR_PULL_ALLOC(ndr, *r->out.key_name);
		} else {
			*r->out.key_name = NULL;
		}
		if (*r->out.key_name) {
			_mem_save_key_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.key_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.key_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.key_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.key_name, &size_key_name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.key_name, &length_key_name_2));
			if (length_key_name_2 > size_key_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_key_name_2, length_key_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_key_name_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.key_name, length_key_name_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_key_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_key_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->out.display_name_length);
		} else {
			r->out.display_name_length = NULL;
		}
		if (r->out.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetServiceKeyNameW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_GetServiceKeyNameW *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetServiceKeyNameW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetServiceKeyNameW");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_name", r->in.service_name);
		ndr->depth++;
		if (r->in.service_name) {
			ndr_print_string(ndr, "service_name", r->in.service_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->in.display_name_length);
		ndr->depth++;
		if (r->in.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->in.display_name_length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetServiceKeyNameW");
		ndr->depth++;
		ndr_print_ptr(ndr, "key_name", r->out.key_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "key_name", *r->out.key_name);
		ndr->depth++;
		if (*r->out.key_name) {
			ndr_print_string(ndr, "key_name", *r->out.key_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->out.display_name_length);
		ndr->depth++;
		if (r->out.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->out.display_name_length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SCSetServiceBitsA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_SCSetServiceBitsA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bits));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.bitson));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.immediate));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SCSetServiceBitsA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_SCSetServiceBitsA *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bits));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.bitson));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.immediate));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SCSetServiceBitsA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_SCSetServiceBitsA *r)
{
	ndr_print_struct(ndr, name, "svcctl_SCSetServiceBitsA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SCSetServiceBitsA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "bits", r->in.bits);
		ndr_print_uint32(ndr, "bitson", r->in.bitson);
		ndr_print_uint32(ndr, "immediate", r->in.immediate);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SCSetServiceBitsA");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ChangeServiceConfigA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_ChangeServiceConfigA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_svcctl_StartType(ndr, NDR_SCALARS, r->in.start_type));
		NDR_CHECK(ndr_push_svcctl_ErrorControl(ndr, NDR_SCALARS, r->in.error_control));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.binary_path));
		if (r->in.binary_path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.binary_path, ndr_charset_length(r->in.binary_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.load_order_group));
		if (r->in.load_order_group) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.load_order_group, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.load_order_group, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.load_order_group, ndr_charset_length(r->in.load_order_group, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dependencies));
		if (r->in.dependencies) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dependencies, ndr_charset_length(r->in.dependencies, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_start_name));
		if (r->in.service_start_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_start_name, ndr_charset_length(r->in.service_start_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password));
		if (r->in.password) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.password, ndr_charset_length(r->in.password, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name));
		if (r->in.display_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.display_name, ndr_charset_length(r->in.display_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.tag_id == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.tag_id));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ChangeServiceConfigA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_ChangeServiceConfigA *r)
{
	uint32_t _ptr_binary_path;
	uint32_t size_binary_path_1 = 0;
	uint32_t length_binary_path_1 = 0;
	uint32_t _ptr_load_order_group;
	uint32_t size_load_order_group_1 = 0;
	uint32_t length_load_order_group_1 = 0;
	uint32_t _ptr_dependencies;
	uint32_t size_dependencies_1 = 0;
	uint32_t length_dependencies_1 = 0;
	uint32_t _ptr_service_start_name;
	uint32_t size_service_start_name_1 = 0;
	uint32_t length_service_start_name_1 = 0;
	uint32_t _ptr_password;
	uint32_t size_password_1 = 0;
	uint32_t length_password_1 = 0;
	uint32_t _ptr_display_name;
	uint32_t size_display_name_1 = 0;
	uint32_t length_display_name_1 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_binary_path_0 = NULL;
	TALLOC_CTX *_mem_save_load_order_group_0 = NULL;
	TALLOC_CTX *_mem_save_tag_id_0 = NULL;
	TALLOC_CTX *_mem_save_dependencies_0 = NULL;
	TALLOC_CTX *_mem_save_service_start_name_0 = NULL;
	TALLOC_CTX *_mem_save_password_0 = NULL;
	TALLOC_CTX *_mem_save_display_name_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_svcctl_StartType(ndr, NDR_SCALARS, &r->in.start_type));
		NDR_CHECK(ndr_pull_svcctl_ErrorControl(ndr, NDR_SCALARS, &r->in.error_control));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary_path));
		if (_ptr_binary_path) {
			NDR_PULL_ALLOC(ndr, r->in.binary_path);
		} else {
			r->in.binary_path = NULL;
		}
		if (r->in.binary_path) {
			_mem_save_binary_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.binary_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.binary_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.binary_path));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.binary_path, &size_binary_path_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.binary_path, &length_binary_path_1));
			if (length_binary_path_1 > size_binary_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_binary_path_1, length_binary_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_binary_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.binary_path, length_binary_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_path_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_load_order_group));
		if (_ptr_load_order_group) {
			NDR_PULL_ALLOC(ndr, r->in.load_order_group);
		} else {
			r->in.load_order_group = NULL;
		}
		if (r->in.load_order_group) {
			_mem_save_load_order_group_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.load_order_group, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.load_order_group));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.load_order_group));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.load_order_group, &size_load_order_group_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.load_order_group, &length_load_order_group_1));
			if (length_load_order_group_1 > size_load_order_group_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_load_order_group_1, length_load_order_group_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_load_order_group_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.load_order_group, length_load_order_group_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_load_order_group_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->in.dependencies);
		} else {
			r->in.dependencies = NULL;
		}
		if (r->in.dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.dependencies, &size_dependencies_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.dependencies, &length_dependencies_1));
			if (length_dependencies_1 > size_dependencies_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dependencies_1, length_dependencies_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dependencies_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dependencies, length_dependencies_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_start_name));
		if (_ptr_service_start_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_start_name);
		} else {
			r->in.service_start_name = NULL;
		}
		if (r->in.service_start_name) {
			_mem_save_service_start_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_start_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.service_start_name, &size_service_start_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.service_start_name, &length_service_start_name_1));
			if (length_service_start_name_1 > size_service_start_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_service_start_name_1, length_service_start_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_service_start_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_start_name, length_service_start_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_start_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->in.password);
		} else {
			r->in.password = NULL;
		}
		if (r->in.password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.password));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.password, &size_password_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.password, &length_password_1));
			if (length_password_1 > size_password_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_password_1, length_password_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_password_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.password, length_password_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
		if (_ptr_display_name) {
			NDR_PULL_ALLOC(ndr, r->in.display_name);
		} else {
			r->in.display_name = NULL;
		}
		if (r->in.display_name) {
			_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.display_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.display_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.display_name, &size_display_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.display_name, &length_display_name_1));
			if (length_display_name_1 > size_display_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_display_name_1, length_display_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_display_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.display_name, length_display_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.tag_id);
		NDR_ZERO_STRUCTP(r->out.tag_id);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.tag_id);
		}
		_mem_save_tag_id_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.tag_id, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.tag_id));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_tag_id_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ChangeServiceConfigA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_ChangeServiceConfigA *r)
{
	ndr_print_struct(ndr, name, "svcctl_ChangeServiceConfigA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ChangeServiceConfigA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_svcctl_StartType(ndr, "start_type", r->in.start_type);
		ndr_print_svcctl_ErrorControl(ndr, "error_control", r->in.error_control);
		ndr_print_ptr(ndr, "binary_path", r->in.binary_path);
		ndr->depth++;
		if (r->in.binary_path) {
			ndr_print_string(ndr, "binary_path", r->in.binary_path);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "load_order_group", r->in.load_order_group);
		ndr->depth++;
		if (r->in.load_order_group) {
			ndr_print_string(ndr, "load_order_group", r->in.load_order_group);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dependencies", r->in.dependencies);
		ndr->depth++;
		if (r->in.dependencies) {
			ndr_print_string(ndr, "dependencies", r->in.dependencies);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "service_start_name", r->in.service_start_name);
		ndr->depth++;
		if (r->in.service_start_name) {
			ndr_print_string(ndr, "service_start_name", r->in.service_start_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name", r->in.display_name);
		ndr->depth++;
		if (r->in.display_name) {
			ndr_print_string(ndr, "display_name", r->in.display_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ChangeServiceConfigA");
		ndr->depth++;
		ndr_print_ptr(ndr, "tag_id", r->out.tag_id);
		ndr->depth++;
		ndr_print_uint32(ndr, "tag_id", *r->out.tag_id);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_CreateServiceA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_CreateServiceA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ServiceName));
		if (r->in.ServiceName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ServiceName, ndr_charset_length(r->in.ServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.DisplayName));
		if (r->in.DisplayName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.DisplayName, ndr_charset_length(r->in.DisplayName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.desired_access));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_svcctl_StartType(ndr, NDR_SCALARS, r->in.start_type));
		NDR_CHECK(ndr_push_svcctl_ErrorControl(ndr, NDR_SCALARS, r->in.error_control));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.binary_path));
		if (r->in.binary_path) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.binary_path, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.binary_path, ndr_charset_length(r->in.binary_path, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.LoadOrderGroupKey));
		if (r->in.LoadOrderGroupKey) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.LoadOrderGroupKey, ndr_charset_length(r->in.LoadOrderGroupKey, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.dependencies));
		if (r->in.dependencies) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.dependencies, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.dependencies, ndr_charset_length(r->in.dependencies, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_start_name));
		if (r->in.service_start_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_start_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_start_name, ndr_charset_length(r->in.service_start_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.password));
		if (r->in.password) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.password, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.password, ndr_charset_length(r->in.password, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.TagId));
		if (r->out.TagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.TagId));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CreateServiceA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_CreateServiceA *r)
{
	uint32_t _ptr_ServiceName;
	uint32_t size_ServiceName_1 = 0;
	uint32_t length_ServiceName_1 = 0;
	uint32_t _ptr_DisplayName;
	uint32_t size_DisplayName_1 = 0;
	uint32_t length_DisplayName_1 = 0;
	uint32_t _ptr_binary_path;
	uint32_t size_binary_path_1 = 0;
	uint32_t length_binary_path_1 = 0;
	uint32_t _ptr_LoadOrderGroupKey;
	uint32_t size_LoadOrderGroupKey_1 = 0;
	uint32_t length_LoadOrderGroupKey_1 = 0;
	uint32_t _ptr_TagId;
	uint32_t _ptr_dependencies;
	uint32_t size_dependencies_1 = 0;
	uint32_t length_dependencies_1 = 0;
	uint32_t _ptr_service_start_name;
	uint32_t size_service_start_name_1 = 0;
	uint32_t length_service_start_name_1 = 0;
	uint32_t _ptr_password;
	uint32_t size_password_1 = 0;
	uint32_t length_password_1 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_ServiceName_0 = NULL;
	TALLOC_CTX *_mem_save_DisplayName_0 = NULL;
	TALLOC_CTX *_mem_save_binary_path_0 = NULL;
	TALLOC_CTX *_mem_save_LoadOrderGroupKey_0 = NULL;
	TALLOC_CTX *_mem_save_TagId_0 = NULL;
	TALLOC_CTX *_mem_save_dependencies_0 = NULL;
	TALLOC_CTX *_mem_save_service_start_name_0 = NULL;
	TALLOC_CTX *_mem_save_password_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ServiceName));
		if (_ptr_ServiceName) {
			NDR_PULL_ALLOC(ndr, r->in.ServiceName);
		} else {
			r->in.ServiceName = NULL;
		}
		if (r->in.ServiceName) {
			_mem_save_ServiceName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ServiceName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ServiceName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ServiceName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.ServiceName, &size_ServiceName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.ServiceName, &length_ServiceName_1));
			if (length_ServiceName_1 > size_ServiceName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ServiceName_1, length_ServiceName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ServiceName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ServiceName, length_ServiceName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ServiceName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DisplayName));
		if (_ptr_DisplayName) {
			NDR_PULL_ALLOC(ndr, r->in.DisplayName);
		} else {
			r->in.DisplayName = NULL;
		}
		if (r->in.DisplayName) {
			_mem_save_DisplayName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.DisplayName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.DisplayName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.DisplayName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.DisplayName, &size_DisplayName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.DisplayName, &length_DisplayName_1));
			if (length_DisplayName_1 > size_DisplayName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_DisplayName_1, length_DisplayName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_DisplayName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.DisplayName, length_DisplayName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DisplayName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.desired_access));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_svcctl_StartType(ndr, NDR_SCALARS, &r->in.start_type));
		NDR_CHECK(ndr_pull_svcctl_ErrorControl(ndr, NDR_SCALARS, &r->in.error_control));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_binary_path));
		if (_ptr_binary_path) {
			NDR_PULL_ALLOC(ndr, r->in.binary_path);
		} else {
			r->in.binary_path = NULL;
		}
		if (r->in.binary_path) {
			_mem_save_binary_path_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.binary_path, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.binary_path));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.binary_path));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.binary_path, &size_binary_path_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.binary_path, &length_binary_path_1));
			if (length_binary_path_1 > size_binary_path_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_binary_path_1, length_binary_path_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_binary_path_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.binary_path, length_binary_path_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_binary_path_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_LoadOrderGroupKey));
		if (_ptr_LoadOrderGroupKey) {
			NDR_PULL_ALLOC(ndr, r->in.LoadOrderGroupKey);
		} else {
			r->in.LoadOrderGroupKey = NULL;
		}
		if (r->in.LoadOrderGroupKey) {
			_mem_save_LoadOrderGroupKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.LoadOrderGroupKey, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.LoadOrderGroupKey));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.LoadOrderGroupKey));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.LoadOrderGroupKey, &size_LoadOrderGroupKey_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.LoadOrderGroupKey, &length_LoadOrderGroupKey_1));
			if (length_LoadOrderGroupKey_1 > size_LoadOrderGroupKey_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_LoadOrderGroupKey_1, length_LoadOrderGroupKey_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_LoadOrderGroupKey_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.LoadOrderGroupKey, length_LoadOrderGroupKey_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LoadOrderGroupKey_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_dependencies));
		if (_ptr_dependencies) {
			NDR_PULL_ALLOC(ndr, r->in.dependencies);
		} else {
			r->in.dependencies = NULL;
		}
		if (r->in.dependencies) {
			_mem_save_dependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.dependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.dependencies));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.dependencies, &size_dependencies_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.dependencies, &length_dependencies_1));
			if (length_dependencies_1 > size_dependencies_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_dependencies_1, length_dependencies_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_dependencies_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.dependencies, length_dependencies_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_dependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_start_name));
		if (_ptr_service_start_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_start_name);
		} else {
			r->in.service_start_name = NULL;
		}
		if (r->in.service_start_name) {
			_mem_save_service_start_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_start_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_start_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.service_start_name, &size_service_start_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.service_start_name, &length_service_start_name_1));
			if (length_service_start_name_1 > size_service_start_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_service_start_name_1, length_service_start_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_service_start_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_start_name, length_service_start_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_start_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_password));
		if (_ptr_password) {
			NDR_PULL_ALLOC(ndr, r->in.password);
		} else {
			r->in.password = NULL;
		}
		if (r->in.password) {
			_mem_save_password_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.password, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.password));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.password));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.password, &size_password_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.password, &length_password_1));
			if (length_password_1 > size_password_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_password_1, length_password_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_password_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.password, length_password_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_password_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_TagId));
		if (_ptr_TagId) {
			NDR_PULL_ALLOC(ndr, r->out.TagId);
		} else {
			r->out.TagId = NULL;
		}
		if (r->out.TagId) {
			_mem_save_TagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.TagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.TagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_TagId_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CreateServiceA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_CreateServiceA *r)
{
	ndr_print_struct(ndr, name, "svcctl_CreateServiceA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CreateServiceA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "ServiceName", r->in.ServiceName);
		ndr->depth++;
		if (r->in.ServiceName) {
			ndr_print_string(ndr, "ServiceName", r->in.ServiceName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "DisplayName", r->in.DisplayName);
		ndr->depth++;
		if (r->in.DisplayName) {
			ndr_print_string(ndr, "DisplayName", r->in.DisplayName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "desired_access", r->in.desired_access);
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_svcctl_StartType(ndr, "start_type", r->in.start_type);
		ndr_print_svcctl_ErrorControl(ndr, "error_control", r->in.error_control);
		ndr_print_ptr(ndr, "binary_path", r->in.binary_path);
		ndr->depth++;
		if (r->in.binary_path) {
			ndr_print_string(ndr, "binary_path", r->in.binary_path);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "LoadOrderGroupKey", r->in.LoadOrderGroupKey);
		ndr->depth++;
		if (r->in.LoadOrderGroupKey) {
			ndr_print_string(ndr, "LoadOrderGroupKey", r->in.LoadOrderGroupKey);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "dependencies", r->in.dependencies);
		ndr->depth++;
		if (r->in.dependencies) {
			ndr_print_string(ndr, "dependencies", r->in.dependencies);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "service_start_name", r->in.service_start_name);
		ndr->depth++;
		if (r->in.service_start_name) {
			ndr_print_string(ndr, "service_start_name", r->in.service_start_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "password", r->in.password);
		ndr->depth++;
		if (r->in.password) {
			ndr_print_string(ndr, "password", r->in.password);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CreateServiceA");
		ndr->depth++;
		ndr_print_ptr(ndr, "TagId", r->out.TagId);
		ndr->depth++;
		if (r->out.TagId) {
			ndr_print_uint32(ndr, "TagId", *r->out.TagId);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumDependentServicesA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_EnumDependentServicesA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.service == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.service));
		NDR_CHECK(ndr_push_svcctl_ServiceState(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.services_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.service_status));
		if (r->out.service_status) {
			NDR_CHECK(ndr_push_ENUM_SERVICE_STATUSA(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.service_status));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.services_returned));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumDependentServicesA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_EnumDependentServicesA *r)
{
	uint32_t _ptr_service_status;
	TALLOC_CTX *_mem_save_service_0 = NULL;
	TALLOC_CTX *_mem_save_service_status_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	TALLOC_CTX *_mem_save_services_returned_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.service);
		}
		_mem_save_service_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.service, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.service));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_svcctl_ServiceState(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.services_returned);
		NDR_ZERO_STRUCTP(r->out.services_returned);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.service == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.service);
			NDR_ZERO_STRUCTP(r->in.service);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_status));
		if (_ptr_service_status) {
			NDR_PULL_ALLOC(ndr, r->out.service_status);
		} else {
			r->out.service_status = NULL;
		}
		if (r->out.service_status) {
			_mem_save_service_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.service_status, 0);
			NDR_CHECK(ndr_pull_ENUM_SERVICE_STATUSA(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.service_status));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_status_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.services_returned);
		}
		_mem_save_services_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.services_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.services_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_services_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumDependentServicesA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_EnumDependentServicesA *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumDependentServicesA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumDependentServicesA");
		ndr->depth++;
		ndr_print_ptr(ndr, "service", r->in.service);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "service", r->in.service);
		ndr->depth--;
		ndr_print_svcctl_ServiceState(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumDependentServicesA");
		ndr->depth++;
		ndr_print_ptr(ndr, "service_status", r->out.service_status);
		ndr->depth++;
		if (r->out.service_status) {
			ndr_print_ENUM_SERVICE_STATUSA(ndr, "service_status", r->out.service_status);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "services_returned", r->out.services_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "services_returned", *r->out.services_returned);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumServicesStatusA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_EnumServicesStatusA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_svcctl_ServiceState(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.services_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.service, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.services_returned));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumServicesStatusA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_EnumServicesStatusA *r)
{
	uint32_t size_service_0 = 0;
	uint32_t _ptr_resume_handle;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	TALLOC_CTX *_mem_save_services_returned_0 = NULL;
	TALLOC_CTX *_mem_save_resume_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_svcctl_ServiceState(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.services_returned);
		NDR_ZERO_STRUCTP(r->out.services_returned);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.service));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.service, &size_service_0));
		NDR_PULL_ALLOC_N(ndr, r->out.service, size_service_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.service, size_service_0));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.services_returned);
		}
		_mem_save_services_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.services_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.services_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_services_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.service) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.service, r->in.offered));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumServicesStatusA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_EnumServicesStatusA *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumServicesStatusA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumServicesStatusA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_svcctl_ServiceState(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumServicesStatusA");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "service", r->out.service, r->in.offered);
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "services_returned", r->out.services_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "services_returned", *r->out.services_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_OpenSCManagerA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_OpenSCManagerA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.MachineName));
		if (r->in.MachineName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.MachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.MachineName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.MachineName, ndr_charset_length(r->in.MachineName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.DatabaseName));
		if (r->in.DatabaseName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.DatabaseName, ndr_charset_length(r->in.DatabaseName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_OpenSCManagerA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_OpenSCManagerA *r)
{
	uint32_t _ptr_MachineName;
	uint32_t size_MachineName_1 = 0;
	uint32_t length_MachineName_1 = 0;
	uint32_t _ptr_DatabaseName;
	uint32_t size_DatabaseName_1 = 0;
	uint32_t length_DatabaseName_1 = 0;
	TALLOC_CTX *_mem_save_MachineName_0 = NULL;
	TALLOC_CTX *_mem_save_DatabaseName_0 = NULL;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_MachineName));
		if (_ptr_MachineName) {
			NDR_PULL_ALLOC(ndr, r->in.MachineName);
		} else {
			r->in.MachineName = NULL;
		}
		if (r->in.MachineName) {
			_mem_save_MachineName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.MachineName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.MachineName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.MachineName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.MachineName, &size_MachineName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.MachineName, &length_MachineName_1));
			if (length_MachineName_1 > size_MachineName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_MachineName_1, length_MachineName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_MachineName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.MachineName, length_MachineName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_MachineName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DatabaseName));
		if (_ptr_DatabaseName) {
			NDR_PULL_ALLOC(ndr, r->in.DatabaseName);
		} else {
			r->in.DatabaseName = NULL;
		}
		if (r->in.DatabaseName) {
			_mem_save_DatabaseName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.DatabaseName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.DatabaseName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.DatabaseName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.DatabaseName, &size_DatabaseName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.DatabaseName, &length_DatabaseName_1));
			if (length_DatabaseName_1 > size_DatabaseName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_DatabaseName_1, length_DatabaseName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_DatabaseName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.DatabaseName, length_DatabaseName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DatabaseName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		NDR_ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_OpenSCManagerA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_OpenSCManagerA *r)
{
	ndr_print_struct(ndr, name, "svcctl_OpenSCManagerA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_OpenSCManagerA");
		ndr->depth++;
		ndr_print_ptr(ndr, "MachineName", r->in.MachineName);
		ndr->depth++;
		if (r->in.MachineName) {
			ndr_print_string(ndr, "MachineName", r->in.MachineName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "DatabaseName", r->in.DatabaseName);
		ndr->depth++;
		if (r->in.DatabaseName) {
			ndr_print_string(ndr, "DatabaseName", r->in.DatabaseName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_OpenSCManagerA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_OpenServiceA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_OpenServiceA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.scmanager_handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.scmanager_handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.ServiceName));
		if (r->in.ServiceName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.ServiceName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.ServiceName, ndr_charset_length(r->in.ServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.access_mask));
	}
	if (flags & NDR_OUT) {
		if (r->out.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_OpenServiceA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_OpenServiceA *r)
{
	uint32_t _ptr_ServiceName;
	uint32_t size_ServiceName_1 = 0;
	uint32_t length_ServiceName_1 = 0;
	TALLOC_CTX *_mem_save_scmanager_handle_0 = NULL;
	TALLOC_CTX *_mem_save_ServiceName_0 = NULL;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager_handle);
		}
		_mem_save_scmanager_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager_handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.scmanager_handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_ServiceName));
		if (_ptr_ServiceName) {
			NDR_PULL_ALLOC(ndr, r->in.ServiceName);
		} else {
			r->in.ServiceName = NULL;
		}
		if (r->in.ServiceName) {
			_mem_save_ServiceName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.ServiceName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.ServiceName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.ServiceName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.ServiceName, &size_ServiceName_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.ServiceName, &length_ServiceName_1));
			if (length_ServiceName_1 > size_ServiceName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_ServiceName_1, length_ServiceName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_ServiceName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.ServiceName, length_ServiceName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ServiceName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.access_mask));
		NDR_PULL_ALLOC(ndr, r->out.handle);
		NDR_ZERO_STRUCTP(r->out.handle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.scmanager_handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager_handle);
			NDR_ZERO_STRUCTP(r->in.scmanager_handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_OpenServiceA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_OpenServiceA *r)
{
	ndr_print_struct(ndr, name, "svcctl_OpenServiceA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_OpenServiceA");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager_handle", r->in.scmanager_handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "ServiceName", r->in.ServiceName);
		ndr->depth++;
		if (r->in.ServiceName) {
			ndr_print_string(ndr, "ServiceName", r->in.ServiceName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "access_mask", r->in.access_mask);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_OpenServiceA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->out.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->out.handle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceConfigA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceConfigA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.query, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceConfigA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceConfigA *r)
{
	uint32_t size_query_0 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		size_query_0 = r->in.offered;
		NDR_PULL_ALLOC_N(ndr, r->out.query, size_query_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.query, size_query_0));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceConfigA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceConfigA *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceConfigA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceConfigA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceConfigA");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "query", r->out.query, r->in.offered);
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceLockStatusA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceLockStatusA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.lock_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SERVICE_LOCK_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock_status));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceLockStatusA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceLockStatusA *r)
{
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_lock_status_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.lock_status);
		NDR_ZERO_STRUCTP(r->out.lock_status);
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lock_status);
		}
		_mem_save_lock_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lock_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SERVICE_LOCK_STATUS(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.lock_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lock_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceLockStatusA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceLockStatusA *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceLockStatusA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceLockStatusA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceLockStatusA");
		ndr->depth++;
		ndr_print_ptr(ndr, "lock_status", r->out.lock_status);
		ndr->depth++;
		ndr_print_SERVICE_LOCK_STATUS(ndr, "lock_status", r->out.lock_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_StartServiceA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_StartServiceA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.NumArgs));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.Arguments));
		if (r->in.Arguments) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.Arguments, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.Arguments, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.Arguments, ndr_charset_length(r->in.Arguments, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_StartServiceA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_StartServiceA *r)
{
	uint32_t _ptr_Arguments;
	uint32_t size_Arguments_1 = 0;
	uint32_t length_Arguments_1 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_Arguments_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.NumArgs));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Arguments));
		if (_ptr_Arguments) {
			NDR_PULL_ALLOC(ndr, r->in.Arguments);
		} else {
			r->in.Arguments = NULL;
		}
		if (r->in.Arguments) {
			_mem_save_Arguments_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.Arguments, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.Arguments));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.Arguments));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.Arguments, &size_Arguments_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.Arguments, &length_Arguments_1));
			if (length_Arguments_1 > size_Arguments_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_Arguments_1, length_Arguments_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_Arguments_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.Arguments, length_Arguments_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Arguments_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_StartServiceA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_StartServiceA *r)
{
	ndr_print_struct(ndr, name, "svcctl_StartServiceA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_StartServiceA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "NumArgs", r->in.NumArgs);
		ndr_print_ptr(ndr, "Arguments", r->in.Arguments);
		ndr->depth++;
		if (r->in.Arguments) {
			ndr_print_string(ndr, "Arguments", r->in.Arguments);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_StartServiceA");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetServiceDisplayNameA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_GetServiceDisplayNameA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_name));
		if (r->in.service_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_name, ndr_charset_length(r->in.service_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name_length));
		if (r->in.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.display_name_length));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.display_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.display_name));
		if (*r->out.display_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.display_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.display_name, ndr_charset_length(*r->out.display_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.display_name_length));
		if (r->out.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.display_name_length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetServiceDisplayNameA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_GetServiceDisplayNameA *r)
{
	uint32_t _ptr_service_name;
	uint32_t size_service_name_1 = 0;
	uint32_t length_service_name_1 = 0;
	uint32_t _ptr_display_name;
	uint32_t size_display_name_2 = 0;
	uint32_t length_display_name_2 = 0;
	uint32_t _ptr_display_name_length;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_service_name_0 = NULL;
	TALLOC_CTX *_mem_save_display_name_0 = NULL;
	TALLOC_CTX *_mem_save_display_name_1 = NULL;
	TALLOC_CTX *_mem_save_display_name_length_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
		if (_ptr_service_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_name);
		} else {
			r->in.service_name = NULL;
		}
		if (r->in.service_name) {
			_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.service_name, &size_service_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.service_name, &length_service_name_1));
			if (length_service_name_1 > size_service_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_service_name_1, length_service_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_service_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_name, length_service_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->in.display_name_length);
		} else {
			r->in.display_name_length = NULL;
		}
		if (r->in.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.display_name);
		NDR_ZERO_STRUCTP(r->out.display_name);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.display_name);
		}
		_mem_save_display_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name));
		if (_ptr_display_name) {
			NDR_PULL_ALLOC(ndr, *r->out.display_name);
		} else {
			*r->out.display_name = NULL;
		}
		if (*r->out.display_name) {
			_mem_save_display_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.display_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.display_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.display_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.display_name, &size_display_name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.display_name, &length_display_name_2));
			if (length_display_name_2 > size_display_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_display_name_2, length_display_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_display_name_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.display_name, length_display_name_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->out.display_name_length);
		} else {
			r->out.display_name_length = NULL;
		}
		if (r->out.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetServiceDisplayNameA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_GetServiceDisplayNameA *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetServiceDisplayNameA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetServiceDisplayNameA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_name", r->in.service_name);
		ndr->depth++;
		if (r->in.service_name) {
			ndr_print_string(ndr, "service_name", r->in.service_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->in.display_name_length);
		ndr->depth++;
		if (r->in.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->in.display_name_length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetServiceDisplayNameA");
		ndr->depth++;
		ndr_print_ptr(ndr, "display_name", r->out.display_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "display_name", *r->out.display_name);
		ndr->depth++;
		if (*r->out.display_name) {
			ndr_print_string(ndr, "display_name", *r->out.display_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->out.display_name_length);
		ndr->depth++;
		if (r->out.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->out.display_name_length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetServiceKeyNameA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_GetServiceKeyNameA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.service_name));
		if (r->in.service_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.service_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.service_name, ndr_charset_length(r->in.service_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.display_name_length));
		if (r->in.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.display_name_length));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.key_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.key_name));
		if (*r->out.key_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.key_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.key_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.key_name, ndr_charset_length(*r->out.key_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.display_name_length));
		if (r->out.display_name_length) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.display_name_length));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetServiceKeyNameA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_GetServiceKeyNameA *r)
{
	uint32_t _ptr_service_name;
	uint32_t size_service_name_1 = 0;
	uint32_t length_service_name_1 = 0;
	uint32_t _ptr_key_name;
	uint32_t size_key_name_2 = 0;
	uint32_t length_key_name_2 = 0;
	uint32_t _ptr_display_name_length;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_service_name_0 = NULL;
	TALLOC_CTX *_mem_save_key_name_0 = NULL;
	TALLOC_CTX *_mem_save_key_name_1 = NULL;
	TALLOC_CTX *_mem_save_display_name_length_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_service_name));
		if (_ptr_service_name) {
			NDR_PULL_ALLOC(ndr, r->in.service_name);
		} else {
			r->in.service_name = NULL;
		}
		if (r->in.service_name) {
			_mem_save_service_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.service_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.service_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.service_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.service_name, &size_service_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.service_name, &length_service_name_1));
			if (length_service_name_1 > size_service_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_service_name_1, length_service_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_service_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.service_name, length_service_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_name_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->in.display_name_length);
		} else {
			r->in.display_name_length = NULL;
		}
		if (r->in.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.key_name);
		NDR_ZERO_STRUCTP(r->out.key_name);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.key_name);
		}
		_mem_save_key_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.key_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_key_name));
		if (_ptr_key_name) {
			NDR_PULL_ALLOC(ndr, *r->out.key_name);
		} else {
			*r->out.key_name = NULL;
		}
		if (*r->out.key_name) {
			_mem_save_key_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.key_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.key_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.key_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.key_name, &size_key_name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.key_name, &length_key_name_2));
			if (length_key_name_2 > size_key_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_key_name_2, length_key_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_key_name_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.key_name, length_key_name_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_key_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_key_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_display_name_length));
		if (_ptr_display_name_length) {
			NDR_PULL_ALLOC(ndr, r->out.display_name_length);
		} else {
			r->out.display_name_length = NULL;
		}
		if (r->out.display_name_length) {
			_mem_save_display_name_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.display_name_length, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.display_name_length));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_display_name_length_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetServiceKeyNameA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_GetServiceKeyNameA *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetServiceKeyNameA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetServiceKeyNameA");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_name", r->in.service_name);
		ndr->depth++;
		if (r->in.service_name) {
			ndr_print_string(ndr, "service_name", r->in.service_name);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->in.display_name_length);
		ndr->depth++;
		if (r->in.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->in.display_name_length);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetServiceKeyNameA");
		ndr->depth++;
		ndr_print_ptr(ndr, "key_name", r->out.key_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "key_name", *r->out.key_name);
		ndr->depth++;
		if (*r->out.key_name) {
			ndr_print_string(ndr, "key_name", *r->out.key_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "display_name_length", r->out.display_name_length);
		ndr->depth++;
		if (r->out.display_name_length) {
			ndr_print_uint32(ndr, "display_name_length", *r->out.display_name_length);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetCurrentGroupeStateW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_GetCurrentGroupeStateW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetCurrentGroupeStateW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_GetCurrentGroupeStateW *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetCurrentGroupeStateW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_GetCurrentGroupeStateW *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetCurrentGroupeStateW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetCurrentGroupeStateW");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetCurrentGroupeStateW");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumServiceGroupW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_EnumServiceGroupW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumServiceGroupW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_EnumServiceGroupW *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumServiceGroupW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_EnumServiceGroupW *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumServiceGroupW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumServiceGroupW");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumServiceGroupW");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ChangeServiceConfig2A(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_ChangeServiceConfig2A *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.info));
		if (r->in.info) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->in.info));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ChangeServiceConfig2A(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_ChangeServiceConfig2A *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		} else {
			r->in.info = NULL;
		}
		if (r->in.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.info, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->in.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ChangeServiceConfig2A(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_ChangeServiceConfig2A *r)
{
	ndr_print_struct(ndr, name, "svcctl_ChangeServiceConfig2A");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ChangeServiceConfig2A");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		if (r->in.info) {
			ndr_print_uint8(ndr, "info", *r->in.info);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ChangeServiceConfig2A");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ChangeServiceConfig2W(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_ChangeServiceConfig2W *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.info));
		if (r->in.info) {
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, *r->in.info));
		}
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ChangeServiceConfig2W(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_ChangeServiceConfig2W *r)
{
	uint32_t _ptr_info;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_info_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_info));
		if (_ptr_info) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		} else {
			r->in.info = NULL;
		}
		if (r->in.info) {
			_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.info, 0);
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, r->in.info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, 0);
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ChangeServiceConfig2W(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_ChangeServiceConfig2W *r)
{
	ndr_print_struct(ndr, name, "svcctl_ChangeServiceConfig2W");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ChangeServiceConfig2W");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		if (r->in.info) {
			ndr_print_uint8(ndr, "info", *r->in.info);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ChangeServiceConfig2W");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceConfig2A(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceConfig2A *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_svcctl_ConfigLevel(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceConfig2A(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceConfig2A *r)
{
	uint32_t size_buffer_0 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_svcctl_ConfigLevel(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		size_buffer_0 = r->in.offered;
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, size_buffer_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, size_buffer_0));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceConfig2A(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceConfig2A *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceConfig2A");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceConfig2A");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_svcctl_ConfigLevel(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceConfig2A");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.offered);
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceConfig2W(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceConfig2W *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_svcctl_ConfigLevel(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceConfig2W(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceConfig2W *r)
{
	uint32_t size_buffer_1 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_svcctl_ConfigLevel(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		if (r->in.offered > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.offered), (uint32_t)(0), (uint32_t)(8192));
		}
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, r->in.offered);
		memset(r->out.buffer, 0, (r->in.offered) * sizeof(*r->out.buffer));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.buffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.buffer, &size_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.buffer, size_buffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, size_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		if (*r->out.needed > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.needed), (uint32_t)(0), (uint32_t)(8192));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.buffer, r->in.offered));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceConfig2W(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceConfig2W *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceConfig2W");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceConfig2W");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_svcctl_ConfigLevel(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceConfig2W");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.offered);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceStatusEx(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceStatusEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.handle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_CHECK(ndr_push_svcctl_StatusLevel(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
	}
	if (flags & NDR_OUT) {
		if (r->out.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceStatusEx(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceStatusEx *r)
{
	uint32_t size_buffer_1 = 0;
	TALLOC_CTX *_mem_save_handle_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
		}
		_mem_save_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.handle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.handle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_handle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_svcctl_StatusLevel(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		if (r->in.offered > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.offered), (uint32_t)(0), (uint32_t)(8192));
		}
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, r->in.offered);
		memset(r->out.buffer, 0, (r->in.offered) * sizeof(*r->out.buffer));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.handle == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.handle);
			NDR_ZERO_STRUCTP(r->in.handle);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.buffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.buffer, &size_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.buffer, size_buffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, size_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		if (*r->out.needed > 8192) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.needed), (uint32_t)(0), (uint32_t)(8192));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.buffer, r->in.offered));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceStatusEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceStatusEx *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceStatusEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceStatusEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "handle", r->in.handle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "handle", r->in.handle);
		ndr->depth--;
		ndr_print_svcctl_StatusLevel(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceStatusEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, r->in.offered);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumServicesStatusExA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_EnumServicesStatusExA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.scmanager == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.scmanager));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_svcctl_ServiceState(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.service_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.group_name == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.services, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.service_returned));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.group_name));
		if (*r->out.group_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.group_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.group_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.group_name, ndr_charset_length(*r->out.group_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumServicesStatusExA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_EnumServicesStatusExA *r)
{
	uint32_t size_services_0 = 0;
	uint32_t _ptr_resume_handle;
	uint32_t _ptr_group_name;
	uint32_t size_group_name_2 = 0;
	uint32_t length_group_name_2 = 0;
	TALLOC_CTX *_mem_save_scmanager_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	TALLOC_CTX *_mem_save_service_returned_0 = NULL;
	TALLOC_CTX *_mem_save_resume_handle_0 = NULL;
	TALLOC_CTX *_mem_save_group_name_0 = NULL;
	TALLOC_CTX *_mem_save_group_name_1 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager);
		}
		_mem_save_scmanager_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.scmanager));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_svcctl_ServiceState(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.service_returned);
		NDR_ZERO_STRUCTP(r->out.service_returned);
		NDR_PULL_ALLOC(ndr, r->out.group_name);
		NDR_ZERO_STRUCTP(r->out.group_name);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.scmanager == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager);
			NDR_ZERO_STRUCTP(r->in.scmanager);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		size_services_0 = r->in.offered;
		NDR_PULL_ALLOC_N(ndr, r->out.services, size_services_0);
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.services, size_services_0));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.service_returned);
		}
		_mem_save_service_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.service_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.service_returned));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.group_name);
		}
		_mem_save_group_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.group_name, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_group_name));
		if (_ptr_group_name) {
			NDR_PULL_ALLOC(ndr, *r->out.group_name);
		} else {
			*r->out.group_name = NULL;
		}
		if (*r->out.group_name) {
			_mem_save_group_name_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.group_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, r->out.group_name));
			NDR_CHECK(ndr_pull_array_length(ndr, r->out.group_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)r->out.group_name, &size_group_name_2));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)r->out.group_name, &length_group_name_2));
			if (length_group_name_2 > size_group_name_2) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_group_name_2, length_group_name_2);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_group_name_2, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.group_name, length_group_name_2, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_name_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_name_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumServicesStatusExA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_EnumServicesStatusExA *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumServicesStatusExA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumServicesStatusExA");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager", r->in.scmanager);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager", r->in.scmanager);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_svcctl_ServiceState(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumServicesStatusExA");
		ndr->depth++;
		ndr_print_array_uint8(ndr, "services", r->out.services, r->in.offered);
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_returned", r->out.service_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "service_returned", *r->out.service_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "group_name", r->out.group_name);
		ndr->depth++;
		ndr_print_ptr(ndr, "group_name", *r->out.group_name);
		ndr->depth++;
		if (*r->out.group_name) {
			ndr_print_string(ndr, "group_name", *r->out.group_name);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_EnumServicesStatusExW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_EnumServicesStatusExW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.scmanager == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.scmanager));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.info_level));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.type));
		NDR_CHECK(ndr_push_svcctl_ServiceState(ndr, NDR_SCALARS, r->in.state));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.resume_handle));
		if (r->in.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.resume_handle));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.group_name));
		if (r->in.group_name) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.group_name, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.group_name, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.group_name, ndr_charset_length(r->in.group_name, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.services == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.service_returned == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.offered));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.services, r->in.offered));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.service_returned));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.resume_handle));
		if (r->out.resume_handle) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.resume_handle));
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_EnumServicesStatusExW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_EnumServicesStatusExW *r)
{
	uint32_t size_services_1 = 0;
	uint32_t _ptr_resume_handle;
	uint32_t _ptr_group_name;
	uint32_t size_group_name_1 = 0;
	uint32_t length_group_name_1 = 0;
	TALLOC_CTX *_mem_save_scmanager_0 = NULL;
	TALLOC_CTX *_mem_save_needed_0 = NULL;
	TALLOC_CTX *_mem_save_service_returned_0 = NULL;
	TALLOC_CTX *_mem_save_resume_handle_0 = NULL;
	TALLOC_CTX *_mem_save_group_name_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager);
		}
		_mem_save_scmanager_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.scmanager, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.scmanager));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_scmanager_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.info_level));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.type));
		NDR_CHECK(ndr_pull_svcctl_ServiceState(ndr, NDR_SCALARS, &r->in.state));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.offered));
		if (r->in.offered > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.offered), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->in.resume_handle);
		} else {
			r->in.resume_handle = NULL;
		}
		if (r->in.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.resume_handle));
			if (*r->in.resume_handle > 262144) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->in.resume_handle), (uint32_t)(0), (uint32_t)(262144));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_group_name));
		if (_ptr_group_name) {
			NDR_PULL_ALLOC(ndr, r->in.group_name);
		} else {
			r->in.group_name = NULL;
		}
		if (r->in.group_name) {
			_mem_save_group_name_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.group_name, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.group_name));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.group_name));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.group_name, &size_group_name_1));
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.group_name, &length_group_name_1));
			if (length_group_name_1 > size_group_name_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_group_name_1, length_group_name_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_group_name_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.group_name, length_group_name_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_group_name_0, 0);
		}
		NDR_PULL_ALLOC_N(ndr, r->out.services, r->in.offered);
		memset(r->out.services, 0, (r->in.offered) * sizeof(*r->out.services));
		NDR_PULL_ALLOC(ndr, r->out.needed);
		NDR_ZERO_STRUCTP(r->out.needed);
		NDR_PULL_ALLOC(ndr, r->out.service_returned);
		NDR_ZERO_STRUCTP(r->out.service_returned);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.scmanager == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.scmanager);
			NDR_ZERO_STRUCTP(r->in.scmanager);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.services));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.services, &size_services_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.services, size_services_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.services, size_services_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		if (*r->out.needed > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.needed), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.service_returned);
		}
		_mem_save_service_returned_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.service_returned, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.service_returned));
		if (*r->out.service_returned > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.service_returned), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_service_returned_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_resume_handle));
		if (_ptr_resume_handle) {
			NDR_PULL_ALLOC(ndr, r->out.resume_handle);
		} else {
			r->out.resume_handle = NULL;
		}
		if (r->out.resume_handle) {
			_mem_save_resume_handle_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.resume_handle, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.resume_handle));
			if (*r->out.resume_handle > 262144) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(*r->out.resume_handle), (uint32_t)(0), (uint32_t)(262144));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_resume_handle_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.services) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.services, r->in.offered));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_EnumServicesStatusExW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_EnumServicesStatusExW *r)
{
	ndr_print_struct(ndr, name, "svcctl_EnumServicesStatusExW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_EnumServicesStatusExW");
		ndr->depth++;
		ndr_print_ptr(ndr, "scmanager", r->in.scmanager);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "scmanager", r->in.scmanager);
		ndr->depth--;
		ndr_print_uint32(ndr, "info_level", r->in.info_level);
		ndr_print_uint32(ndr, "type", r->in.type);
		ndr_print_svcctl_ServiceState(ndr, "state", r->in.state);
		ndr_print_uint32(ndr, "offered", r->in.offered);
		ndr_print_ptr(ndr, "resume_handle", r->in.resume_handle);
		ndr->depth++;
		if (r->in.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->in.resume_handle);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "group_name", r->in.group_name);
		ndr->depth++;
		if (r->in.group_name) {
			ndr_print_string(ndr, "group_name", r->in.group_name);
		}
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_EnumServicesStatusExW");
		ndr->depth++;
		ndr_print_ptr(ndr, "services", r->out.services);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "services", r->out.services, r->in.offered);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_ptr(ndr, "service_returned", r->out.service_returned);
		ndr->depth++;
		ndr_print_uint32(ndr, "service_returned", *r->out.service_returned);
		ndr->depth--;
		ndr_print_ptr(ndr, "resume_handle", r->out.resume_handle);
		ndr->depth++;
		if (r->out.resume_handle) {
			ndr_print_uint32(ndr, "resume_handle", *r->out.resume_handle);
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_SCSendTSMessage(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_SCSendTSMessage *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_SCSendTSMessage(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_SCSendTSMessage *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_SCSendTSMessage(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_SCSendTSMessage *r)
{
	ndr_print_struct(ndr, name, "svcctl_SCSendTSMessage");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_SCSendTSMessage");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_SCSendTSMessage");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_CreateServiceWOW64A(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_CreateServiceWOW64A *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpServiceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.lpBinaryPathName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hSCManager));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceName, CH_DOS)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceName, CH_DOS)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpServiceName, ndr_charset_length(r->in.lpServiceName, CH_DOS), sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpDisplayName));
		if (r->in.lpDisplayName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpDisplayName, CH_DOS)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpDisplayName, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpDisplayName, ndr_charset_length(r->in.lpDisplayName, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwDesiredAccess));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwServiceType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwStartType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwErrorControl));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpBinaryPathName, CH_DOS)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpBinaryPathName, CH_DOS)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpBinaryPathName, ndr_charset_length(r->in.lpBinaryPathName, CH_DOS), sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpLoadOrderGroup));
		if (r->in.lpLoadOrderGroup) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpLoadOrderGroup, CH_DOS)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpLoadOrderGroup, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpLoadOrderGroup, ndr_charset_length(r->in.lpLoadOrderGroup, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpdwTagId));
		if (r->in.lpdwTagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.lpdwTagId));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpDependencies));
		if (r->in.lpDependencies) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwDependSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpDependencies, r->in.dwDependSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwDependSize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpServiceStartName));
		if (r->in.lpServiceStartName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceStartName, CH_DOS)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceStartName, CH_DOS)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpServiceStartName, ndr_charset_length(r->in.lpServiceStartName, CH_DOS), sizeof(uint8_t), CH_DOS));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpPassword));
		if (r->in.lpPassword) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwPwSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpPassword, r->in.dwPwSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwPwSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpServiceHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.lpdwTagId));
		if (r->out.lpdwTagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwTagId));
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.lpServiceHandle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CreateServiceWOW64A(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_CreateServiceWOW64A *r)
{
	uint32_t size_lpServiceName_1 = 0;
	uint32_t length_lpServiceName_1 = 0;
	uint32_t _ptr_lpDisplayName;
	uint32_t size_lpDisplayName_1 = 0;
	uint32_t length_lpDisplayName_1 = 0;
	uint32_t size_lpBinaryPathName_1 = 0;
	uint32_t length_lpBinaryPathName_1 = 0;
	uint32_t _ptr_lpLoadOrderGroup;
	uint32_t size_lpLoadOrderGroup_1 = 0;
	uint32_t length_lpLoadOrderGroup_1 = 0;
	uint32_t _ptr_lpdwTagId;
	uint32_t _ptr_lpDependencies;
	uint32_t size_lpDependencies_1 = 0;
	uint32_t _ptr_lpServiceStartName;
	uint32_t size_lpServiceStartName_1 = 0;
	uint32_t length_lpServiceStartName_1 = 0;
	uint32_t _ptr_lpPassword;
	uint32_t size_lpPassword_1 = 0;
	TALLOC_CTX *_mem_save_lpDisplayName_0 = NULL;
	TALLOC_CTX *_mem_save_lpLoadOrderGroup_0 = NULL;
	TALLOC_CTX *_mem_save_lpdwTagId_0 = NULL;
	TALLOC_CTX *_mem_save_lpDependencies_0 = NULL;
	TALLOC_CTX *_mem_save_lpServiceStartName_0 = NULL;
	TALLOC_CTX *_mem_save_lpPassword_0 = NULL;
	TALLOC_CTX *_mem_save_lpServiceHandle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hSCManager));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpServiceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpServiceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpServiceName, &size_lpServiceName_1));
		if (size_lpServiceName_1 > SC_MAX_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpServiceName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
		}
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpServiceName, &length_lpServiceName_1));
		if (length_lpServiceName_1 > SC_MAX_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpServiceName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
		}
		if (length_lpServiceName_1 > size_lpServiceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpServiceName_1, length_lpServiceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpServiceName_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpServiceName, length_lpServiceName_1, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpDisplayName));
		if (_ptr_lpDisplayName) {
			NDR_PULL_ALLOC(ndr, r->in.lpDisplayName);
		} else {
			r->in.lpDisplayName = NULL;
		}
		if (r->in.lpDisplayName) {
			_mem_save_lpDisplayName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpDisplayName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpDisplayName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpDisplayName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpDisplayName, &size_lpDisplayName_1));
			if (size_lpDisplayName_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpDisplayName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpDisplayName, &length_lpDisplayName_1));
			if (length_lpDisplayName_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpDisplayName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			if (length_lpDisplayName_1 > size_lpDisplayName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpDisplayName_1, length_lpDisplayName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpDisplayName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpDisplayName, length_lpDisplayName_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpDisplayName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwDesiredAccess));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwServiceType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwStartType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwErrorControl));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpBinaryPathName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpBinaryPathName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpBinaryPathName, &size_lpBinaryPathName_1));
		if (size_lpBinaryPathName_1 > SC_MAX_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpBinaryPathName_1, (uint32_t)(0), (uint32_t)(SC_MAX_PATH_LENGTH));
		}
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpBinaryPathName, &length_lpBinaryPathName_1));
		if (length_lpBinaryPathName_1 > SC_MAX_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpBinaryPathName_1, (uint32_t)(0), (uint32_t)(SC_MAX_PATH_LENGTH));
		}
		if (length_lpBinaryPathName_1 > size_lpBinaryPathName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpBinaryPathName_1, length_lpBinaryPathName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpBinaryPathName_1, sizeof(uint8_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpBinaryPathName, length_lpBinaryPathName_1, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpLoadOrderGroup));
		if (_ptr_lpLoadOrderGroup) {
			NDR_PULL_ALLOC(ndr, r->in.lpLoadOrderGroup);
		} else {
			r->in.lpLoadOrderGroup = NULL;
		}
		if (r->in.lpLoadOrderGroup) {
			_mem_save_lpLoadOrderGroup_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpLoadOrderGroup, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpLoadOrderGroup));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpLoadOrderGroup));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpLoadOrderGroup, &size_lpLoadOrderGroup_1));
			if (size_lpLoadOrderGroup_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpLoadOrderGroup_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpLoadOrderGroup, &length_lpLoadOrderGroup_1));
			if (length_lpLoadOrderGroup_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpLoadOrderGroup_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			if (length_lpLoadOrderGroup_1 > size_lpLoadOrderGroup_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpLoadOrderGroup_1, length_lpLoadOrderGroup_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpLoadOrderGroup_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpLoadOrderGroup, length_lpLoadOrderGroup_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpLoadOrderGroup_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpdwTagId));
		if (_ptr_lpdwTagId) {
			NDR_PULL_ALLOC(ndr, r->in.lpdwTagId);
		} else {
			r->in.lpdwTagId = NULL;
		}
		if (r->in.lpdwTagId) {
			_mem_save_lpdwTagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpdwTagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.lpdwTagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwTagId_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpDependencies));
		if (_ptr_lpDependencies) {
			NDR_PULL_ALLOC(ndr, r->in.lpDependencies);
		} else {
			r->in.lpDependencies = NULL;
		}
		if (r->in.lpDependencies) {
			_mem_save_lpDependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpDependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpDependencies));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpDependencies, &size_lpDependencies_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpDependencies, size_lpDependencies_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpDependencies, size_lpDependencies_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpDependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwDependSize));
		if (r->in.dwDependSize > SC_MAX_DEPEND_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.dwDependSize), (uint32_t)(0), (uint32_t)(SC_MAX_DEPEND_SIZE));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpServiceStartName));
		if (_ptr_lpServiceStartName) {
			NDR_PULL_ALLOC(ndr, r->in.lpServiceStartName);
		} else {
			r->in.lpServiceStartName = NULL;
		}
		if (r->in.lpServiceStartName) {
			_mem_save_lpServiceStartName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpServiceStartName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpServiceStartName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpServiceStartName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpServiceStartName, &size_lpServiceStartName_1));
			if (size_lpServiceStartName_1 > SC_MAX_ACCOUNT_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpServiceStartName_1, (uint32_t)(0), (uint32_t)(SC_MAX_ACCOUNT_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpServiceStartName, &length_lpServiceStartName_1));
			if (length_lpServiceStartName_1 > SC_MAX_ACCOUNT_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpServiceStartName_1, (uint32_t)(0), (uint32_t)(SC_MAX_ACCOUNT_NAME_LENGTH));
			}
			if (length_lpServiceStartName_1 > size_lpServiceStartName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpServiceStartName_1, length_lpServiceStartName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpServiceStartName_1, sizeof(uint8_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpServiceStartName, length_lpServiceStartName_1, sizeof(uint8_t), CH_DOS));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpServiceStartName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpPassword));
		if (_ptr_lpPassword) {
			NDR_PULL_ALLOC(ndr, r->in.lpPassword);
		} else {
			r->in.lpPassword = NULL;
		}
		if (r->in.lpPassword) {
			_mem_save_lpPassword_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpPassword, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpPassword));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpPassword, &size_lpPassword_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpPassword, size_lpPassword_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpPassword, size_lpPassword_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpPassword_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwPwSize));
		if (r->in.dwPwSize > SC_MAX_PWD_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.dwPwSize), (uint32_t)(0), (uint32_t)(SC_MAX_PWD_SIZE));
		}
		NDR_PULL_ALLOC(ndr, r->out.lpServiceHandle);
		NDR_ZERO_STRUCTP(r->out.lpServiceHandle);
		if (r->in.lpDependencies) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpDependencies, r->in.dwDependSize));
		}
		if (r->in.lpPassword) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpPassword, r->in.dwPwSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpdwTagId));
		if (_ptr_lpdwTagId) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwTagId);
		} else {
			r->out.lpdwTagId = NULL;
		}
		if (r->out.lpdwTagId) {
			_mem_save_lpdwTagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwTagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwTagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwTagId_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpServiceHandle);
		}
		_mem_save_lpServiceHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpServiceHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.lpServiceHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpServiceHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CreateServiceWOW64A(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_CreateServiceWOW64A *r)
{
	ndr_print_struct(ndr, name, "svcctl_CreateServiceWOW64A");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CreateServiceWOW64A");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hSCManager", &r->in.hSCManager);
		ndr_print_ptr(ndr, "lpServiceName", r->in.lpServiceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpServiceName", r->in.lpServiceName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpDisplayName", r->in.lpDisplayName);
		ndr->depth++;
		if (r->in.lpDisplayName) {
			ndr_print_string(ndr, "lpDisplayName", r->in.lpDisplayName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwDesiredAccess", r->in.dwDesiredAccess);
		ndr_print_uint32(ndr, "dwServiceType", r->in.dwServiceType);
		ndr_print_uint32(ndr, "dwStartType", r->in.dwStartType);
		ndr_print_uint32(ndr, "dwErrorControl", r->in.dwErrorControl);
		ndr_print_ptr(ndr, "lpBinaryPathName", r->in.lpBinaryPathName);
		ndr->depth++;
		ndr_print_string(ndr, "lpBinaryPathName", r->in.lpBinaryPathName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpLoadOrderGroup", r->in.lpLoadOrderGroup);
		ndr->depth++;
		if (r->in.lpLoadOrderGroup) {
			ndr_print_string(ndr, "lpLoadOrderGroup", r->in.lpLoadOrderGroup);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpdwTagId", r->in.lpdwTagId);
		ndr->depth++;
		if (r->in.lpdwTagId) {
			ndr_print_uint32(ndr, "lpdwTagId", *r->in.lpdwTagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpDependencies", r->in.lpDependencies);
		ndr->depth++;
		if (r->in.lpDependencies) {
			ndr_print_array_uint8(ndr, "lpDependencies", r->in.lpDependencies, r->in.dwDependSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwDependSize", r->in.dwDependSize);
		ndr_print_ptr(ndr, "lpServiceStartName", r->in.lpServiceStartName);
		ndr->depth++;
		if (r->in.lpServiceStartName) {
			ndr_print_string(ndr, "lpServiceStartName", r->in.lpServiceStartName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpPassword", r->in.lpPassword);
		ndr->depth++;
		if (r->in.lpPassword) {
			ndr_print_array_uint8(ndr, "lpPassword", r->in.lpPassword, r->in.dwPwSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwPwSize", r->in.dwPwSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CreateServiceWOW64A");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwTagId", r->out.lpdwTagId);
		ndr->depth++;
		if (r->out.lpdwTagId) {
			ndr_print_uint32(ndr, "lpdwTagId", *r->out.lpdwTagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpServiceHandle", r->out.lpServiceHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "lpServiceHandle", r->out.lpServiceHandle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_CreateServiceWOW64W(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_CreateServiceWOW64W *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpServiceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.lpBinaryPathName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hSCManager));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpServiceName, ndr_charset_length(r->in.lpServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpDisplayName));
		if (r->in.lpDisplayName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpDisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpDisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpDisplayName, ndr_charset_length(r->in.lpDisplayName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwDesiredAccess));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwServiceType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwStartType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwErrorControl));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpBinaryPathName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpBinaryPathName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpBinaryPathName, ndr_charset_length(r->in.lpBinaryPathName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpLoadOrderGroup));
		if (r->in.lpLoadOrderGroup) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpLoadOrderGroup, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpLoadOrderGroup, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpLoadOrderGroup, ndr_charset_length(r->in.lpLoadOrderGroup, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpdwTagId));
		if (r->in.lpdwTagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.lpdwTagId));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpDependencies));
		if (r->in.lpDependencies) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwDependSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpDependencies, r->in.dwDependSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwDependSize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpServiceStartName));
		if (r->in.lpServiceStartName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceStartName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceStartName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpServiceStartName, ndr_charset_length(r->in.lpServiceStartName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpPassword));
		if (r->in.lpPassword) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwPwSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpPassword, r->in.dwPwSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwPwSize));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpServiceHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.lpdwTagId));
		if (r->out.lpdwTagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwTagId));
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.lpServiceHandle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CreateServiceWOW64W(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_CreateServiceWOW64W *r)
{
	uint32_t size_lpServiceName_1 = 0;
	uint32_t length_lpServiceName_1 = 0;
	uint32_t _ptr_lpDisplayName;
	uint32_t size_lpDisplayName_1 = 0;
	uint32_t length_lpDisplayName_1 = 0;
	uint32_t size_lpBinaryPathName_1 = 0;
	uint32_t length_lpBinaryPathName_1 = 0;
	uint32_t _ptr_lpLoadOrderGroup;
	uint32_t size_lpLoadOrderGroup_1 = 0;
	uint32_t length_lpLoadOrderGroup_1 = 0;
	uint32_t _ptr_lpdwTagId;
	uint32_t _ptr_lpDependencies;
	uint32_t size_lpDependencies_1 = 0;
	uint32_t _ptr_lpServiceStartName;
	uint32_t size_lpServiceStartName_1 = 0;
	uint32_t length_lpServiceStartName_1 = 0;
	uint32_t _ptr_lpPassword;
	uint32_t size_lpPassword_1 = 0;
	TALLOC_CTX *_mem_save_lpDisplayName_0 = NULL;
	TALLOC_CTX *_mem_save_lpLoadOrderGroup_0 = NULL;
	TALLOC_CTX *_mem_save_lpdwTagId_0 = NULL;
	TALLOC_CTX *_mem_save_lpDependencies_0 = NULL;
	TALLOC_CTX *_mem_save_lpServiceStartName_0 = NULL;
	TALLOC_CTX *_mem_save_lpPassword_0 = NULL;
	TALLOC_CTX *_mem_save_lpServiceHandle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hSCManager));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpServiceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpServiceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpServiceName, &size_lpServiceName_1));
		if (size_lpServiceName_1 > SC_MAX_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpServiceName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
		}
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpServiceName, &length_lpServiceName_1));
		if (length_lpServiceName_1 > SC_MAX_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpServiceName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
		}
		if (length_lpServiceName_1 > size_lpServiceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpServiceName_1, length_lpServiceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpServiceName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpServiceName, length_lpServiceName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpDisplayName));
		if (_ptr_lpDisplayName) {
			NDR_PULL_ALLOC(ndr, r->in.lpDisplayName);
		} else {
			r->in.lpDisplayName = NULL;
		}
		if (r->in.lpDisplayName) {
			_mem_save_lpDisplayName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpDisplayName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpDisplayName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpDisplayName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpDisplayName, &size_lpDisplayName_1));
			if (size_lpDisplayName_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpDisplayName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpDisplayName, &length_lpDisplayName_1));
			if (length_lpDisplayName_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpDisplayName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			if (length_lpDisplayName_1 > size_lpDisplayName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpDisplayName_1, length_lpDisplayName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpDisplayName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpDisplayName, length_lpDisplayName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpDisplayName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwDesiredAccess));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwServiceType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwStartType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwErrorControl));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpBinaryPathName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpBinaryPathName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpBinaryPathName, &size_lpBinaryPathName_1));
		if (size_lpBinaryPathName_1 > SC_MAX_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpBinaryPathName_1, (uint32_t)(0), (uint32_t)(SC_MAX_PATH_LENGTH));
		}
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpBinaryPathName, &length_lpBinaryPathName_1));
		if (length_lpBinaryPathName_1 > SC_MAX_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpBinaryPathName_1, (uint32_t)(0), (uint32_t)(SC_MAX_PATH_LENGTH));
		}
		if (length_lpBinaryPathName_1 > size_lpBinaryPathName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpBinaryPathName_1, length_lpBinaryPathName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpBinaryPathName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpBinaryPathName, length_lpBinaryPathName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpLoadOrderGroup));
		if (_ptr_lpLoadOrderGroup) {
			NDR_PULL_ALLOC(ndr, r->in.lpLoadOrderGroup);
		} else {
			r->in.lpLoadOrderGroup = NULL;
		}
		if (r->in.lpLoadOrderGroup) {
			_mem_save_lpLoadOrderGroup_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpLoadOrderGroup, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpLoadOrderGroup));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpLoadOrderGroup));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpLoadOrderGroup, &size_lpLoadOrderGroup_1));
			if (size_lpLoadOrderGroup_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpLoadOrderGroup_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpLoadOrderGroup, &length_lpLoadOrderGroup_1));
			if (length_lpLoadOrderGroup_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpLoadOrderGroup_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			if (length_lpLoadOrderGroup_1 > size_lpLoadOrderGroup_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpLoadOrderGroup_1, length_lpLoadOrderGroup_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpLoadOrderGroup_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpLoadOrderGroup, length_lpLoadOrderGroup_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpLoadOrderGroup_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpdwTagId));
		if (_ptr_lpdwTagId) {
			NDR_PULL_ALLOC(ndr, r->in.lpdwTagId);
		} else {
			r->in.lpdwTagId = NULL;
		}
		if (r->in.lpdwTagId) {
			_mem_save_lpdwTagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpdwTagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.lpdwTagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwTagId_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpDependencies));
		if (_ptr_lpDependencies) {
			NDR_PULL_ALLOC(ndr, r->in.lpDependencies);
		} else {
			r->in.lpDependencies = NULL;
		}
		if (r->in.lpDependencies) {
			_mem_save_lpDependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpDependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpDependencies));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpDependencies, &size_lpDependencies_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpDependencies, size_lpDependencies_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpDependencies, size_lpDependencies_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpDependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwDependSize));
		if (r->in.dwDependSize > SC_MAX_DEPEND_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.dwDependSize), (uint32_t)(0), (uint32_t)(SC_MAX_DEPEND_SIZE));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpServiceStartName));
		if (_ptr_lpServiceStartName) {
			NDR_PULL_ALLOC(ndr, r->in.lpServiceStartName);
		} else {
			r->in.lpServiceStartName = NULL;
		}
		if (r->in.lpServiceStartName) {
			_mem_save_lpServiceStartName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpServiceStartName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpServiceStartName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpServiceStartName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpServiceStartName, &size_lpServiceStartName_1));
			if (size_lpServiceStartName_1 > SC_MAX_ACCOUNT_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpServiceStartName_1, (uint32_t)(0), (uint32_t)(SC_MAX_ACCOUNT_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpServiceStartName, &length_lpServiceStartName_1));
			if (length_lpServiceStartName_1 > SC_MAX_ACCOUNT_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpServiceStartName_1, (uint32_t)(0), (uint32_t)(SC_MAX_ACCOUNT_NAME_LENGTH));
			}
			if (length_lpServiceStartName_1 > size_lpServiceStartName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpServiceStartName_1, length_lpServiceStartName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpServiceStartName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpServiceStartName, length_lpServiceStartName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpServiceStartName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpPassword));
		if (_ptr_lpPassword) {
			NDR_PULL_ALLOC(ndr, r->in.lpPassword);
		} else {
			r->in.lpPassword = NULL;
		}
		if (r->in.lpPassword) {
			_mem_save_lpPassword_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpPassword, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpPassword));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpPassword, &size_lpPassword_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpPassword, size_lpPassword_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpPassword, size_lpPassword_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpPassword_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwPwSize));
		if (r->in.dwPwSize > SC_MAX_PWD_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.dwPwSize), (uint32_t)(0), (uint32_t)(SC_MAX_PWD_SIZE));
		}
		NDR_PULL_ALLOC(ndr, r->out.lpServiceHandle);
		NDR_ZERO_STRUCTP(r->out.lpServiceHandle);
		if (r->in.lpDependencies) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpDependencies, r->in.dwDependSize));
		}
		if (r->in.lpPassword) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpPassword, r->in.dwPwSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpdwTagId));
		if (_ptr_lpdwTagId) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwTagId);
		} else {
			r->out.lpdwTagId = NULL;
		}
		if (r->out.lpdwTagId) {
			_mem_save_lpdwTagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwTagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwTagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwTagId_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpServiceHandle);
		}
		_mem_save_lpServiceHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpServiceHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.lpServiceHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpServiceHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CreateServiceWOW64W(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_CreateServiceWOW64W *r)
{
	ndr_print_struct(ndr, name, "svcctl_CreateServiceWOW64W");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CreateServiceWOW64W");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hSCManager", &r->in.hSCManager);
		ndr_print_ptr(ndr, "lpServiceName", r->in.lpServiceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpServiceName", r->in.lpServiceName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpDisplayName", r->in.lpDisplayName);
		ndr->depth++;
		if (r->in.lpDisplayName) {
			ndr_print_string(ndr, "lpDisplayName", r->in.lpDisplayName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwDesiredAccess", r->in.dwDesiredAccess);
		ndr_print_uint32(ndr, "dwServiceType", r->in.dwServiceType);
		ndr_print_uint32(ndr, "dwStartType", r->in.dwStartType);
		ndr_print_uint32(ndr, "dwErrorControl", r->in.dwErrorControl);
		ndr_print_ptr(ndr, "lpBinaryPathName", r->in.lpBinaryPathName);
		ndr->depth++;
		ndr_print_string(ndr, "lpBinaryPathName", r->in.lpBinaryPathName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpLoadOrderGroup", r->in.lpLoadOrderGroup);
		ndr->depth++;
		if (r->in.lpLoadOrderGroup) {
			ndr_print_string(ndr, "lpLoadOrderGroup", r->in.lpLoadOrderGroup);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpdwTagId", r->in.lpdwTagId);
		ndr->depth++;
		if (r->in.lpdwTagId) {
			ndr_print_uint32(ndr, "lpdwTagId", *r->in.lpdwTagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpDependencies", r->in.lpDependencies);
		ndr->depth++;
		if (r->in.lpDependencies) {
			ndr_print_array_uint8(ndr, "lpDependencies", r->in.lpDependencies, r->in.dwDependSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwDependSize", r->in.dwDependSize);
		ndr_print_ptr(ndr, "lpServiceStartName", r->in.lpServiceStartName);
		ndr->depth++;
		if (r->in.lpServiceStartName) {
			ndr_print_string(ndr, "lpServiceStartName", r->in.lpServiceStartName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpPassword", r->in.lpPassword);
		ndr->depth++;
		if (r->in.lpPassword) {
			ndr_print_array_uint8(ndr, "lpPassword", r->in.lpPassword, r->in.dwPwSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwPwSize", r->in.dwPwSize);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CreateServiceWOW64W");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwTagId", r->out.lpdwTagId);
		ndr->depth++;
		if (r->out.lpdwTagId) {
			ndr_print_uint32(ndr, "lpdwTagId", *r->out.lpdwTagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpServiceHandle", r->out.lpServiceHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "lpServiceHandle", r->out.lpServiceHandle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum46NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum46NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum46NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum46NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum46NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum46NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum46NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum46NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum46NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_NotifyServiceStatusChange(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_NotifyServiceStatusChange *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pClientProcessGuid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hService));
		NDR_CHECK(ndr_push_SC_RPC_NOTIFY_PARAMS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.NotifyParams));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->in.pClientProcessGuid));
	}
	if (flags & NDR_OUT) {
		if (r->out.pSCMProcessGuid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pfCreateRemoteQueue == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.phNotify == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->out.pSCMProcessGuid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pfCreateRemoteQueue));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phNotify));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_NotifyServiceStatusChange(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_NotifyServiceStatusChange *r)
{
	TALLOC_CTX *_mem_save_pClientProcessGuid_0 = NULL;
	TALLOC_CTX *_mem_save_pSCMProcessGuid_0 = NULL;
	TALLOC_CTX *_mem_save_pfCreateRemoteQueue_0 = NULL;
	TALLOC_CTX *_mem_save_phNotify_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hService));
		NDR_CHECK(ndr_pull_SC_RPC_NOTIFY_PARAMS(ndr, NDR_SCALARS|NDR_BUFFERS, &r->in.NotifyParams));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pClientProcessGuid);
		}
		_mem_save_pClientProcessGuid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pClientProcessGuid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->in.pClientProcessGuid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pClientProcessGuid_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pSCMProcessGuid);
		NDR_ZERO_STRUCTP(r->out.pSCMProcessGuid);
		NDR_PULL_ALLOC(ndr, r->out.pfCreateRemoteQueue);
		NDR_ZERO_STRUCTP(r->out.pfCreateRemoteQueue);
		NDR_PULL_ALLOC(ndr, r->out.phNotify);
		NDR_ZERO_STRUCTP(r->out.phNotify);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pClientProcessGuid == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pClientProcessGuid);
			NDR_ZERO_STRUCTP(r->in.pClientProcessGuid);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pSCMProcessGuid);
		}
		_mem_save_pSCMProcessGuid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pSCMProcessGuid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->out.pSCMProcessGuid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pSCMProcessGuid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pfCreateRemoteQueue);
		}
		_mem_save_pfCreateRemoteQueue_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pfCreateRemoteQueue, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pfCreateRemoteQueue));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pfCreateRemoteQueue_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phNotify);
		}
		_mem_save_phNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phNotify, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phNotify));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phNotify_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_NotifyServiceStatusChange(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_NotifyServiceStatusChange *r)
{
	ndr_print_struct(ndr, name, "svcctl_NotifyServiceStatusChange");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_NotifyServiceStatusChange");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hService", &r->in.hService);
		ndr_print_SC_RPC_NOTIFY_PARAMS(ndr, "NotifyParams", &r->in.NotifyParams);
		ndr_print_ptr(ndr, "pClientProcessGuid", r->in.pClientProcessGuid);
		ndr->depth++;
		ndr_print_GUID(ndr, "pClientProcessGuid", r->in.pClientProcessGuid);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_NotifyServiceStatusChange");
		ndr->depth++;
		ndr_print_ptr(ndr, "pSCMProcessGuid", r->out.pSCMProcessGuid);
		ndr->depth++;
		ndr_print_GUID(ndr, "pSCMProcessGuid", r->out.pSCMProcessGuid);
		ndr->depth--;
		ndr_print_ptr(ndr, "pfCreateRemoteQueue", r->out.pfCreateRemoteQueue);
		ndr->depth++;
		ndr_print_uint32(ndr, "pfCreateRemoteQueue", *r->out.pfCreateRemoteQueue);
		ndr->depth--;
		ndr_print_ptr(ndr, "phNotify", r->out.phNotify);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phNotify", r->out.phNotify);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_GetNotifyResults(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_GetNotifyResults *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
	}
	if (flags & NDR_OUT) {
		if (r->out.ppNotifyParams == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SC_RPC_NOTIFY_PARAMS_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppNotifyParams));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_GetNotifyResults(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_GetNotifyResults *r)
{
	TALLOC_CTX *_mem_save_ppNotifyParams_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hNotify));
		NDR_PULL_ALLOC(ndr, r->out.ppNotifyParams);
		NDR_ZERO_STRUCTP(r->out.ppNotifyParams);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ppNotifyParams);
		}
		_mem_save_ppNotifyParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ppNotifyParams, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SC_RPC_NOTIFY_PARAMS_LIST(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.ppNotifyParams));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ppNotifyParams_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_GetNotifyResults(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_GetNotifyResults *r)
{
	ndr_print_struct(ndr, name, "svcctl_GetNotifyResults");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_GetNotifyResults");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hNotify", &r->in.hNotify);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_GetNotifyResults");
		ndr->depth++;
		ndr_print_ptr(ndr, "ppNotifyParams", r->out.ppNotifyParams);
		ndr->depth++;
		ndr_print_SC_RPC_NOTIFY_PARAMS_LIST(ndr, "ppNotifyParams", r->out.ppNotifyParams);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_CloseNotifyHandle(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_CloseNotifyHandle *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.phNotify == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.phNotify));
	}
	if (flags & NDR_OUT) {
		if (r->out.phNotify == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.pfApcFired == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.phNotify));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.pfApcFired));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CloseNotifyHandle(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_CloseNotifyHandle *r)
{
	TALLOC_CTX *_mem_save_phNotify_0 = NULL;
	TALLOC_CTX *_mem_save_pfApcFired_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.phNotify);
		}
		_mem_save_phNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.phNotify, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.phNotify));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phNotify_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.phNotify);
		*r->out.phNotify = *r->in.phNotify;
		NDR_PULL_ALLOC(ndr, r->out.pfApcFired);
		NDR_ZERO_STRUCTP(r->out.pfApcFired);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.phNotify == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.phNotify);
			NDR_ZERO_STRUCTP(r->in.phNotify);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.phNotify);
		}
		_mem_save_phNotify_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.phNotify, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.phNotify));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_phNotify_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pfApcFired);
		}
		_mem_save_pfApcFired_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pfApcFired, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.pfApcFired));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pfApcFired_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CloseNotifyHandle(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_CloseNotifyHandle *r)
{
	ndr_print_struct(ndr, name, "svcctl_CloseNotifyHandle");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CloseNotifyHandle");
		ndr->depth++;
		ndr_print_ptr(ndr, "phNotify", r->in.phNotify);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phNotify", r->in.phNotify);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CloseNotifyHandle");
		ndr->depth++;
		ndr_print_ptr(ndr, "phNotify", r->out.phNotify);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "phNotify", r->out.phNotify);
		ndr->depth--;
		ndr_print_ptr(ndr, "pfApcFired", r->out.pfApcFired);
		ndr->depth++;
		ndr_print_uint32(ndr, "pfApcFired", *r->out.pfApcFired);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ControlServiceExA(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_ControlServiceExA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pControlInParams == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hService));
		NDR_CHECK(ndr_push_SERVICE_CONTROL(ndr, NDR_SCALARS, r->in.dwControl));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwInfoLevel));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.pControlInParams, r->in.dwInfoLevel));
		NDR_CHECK(ndr_push_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pControlInParams));
	}
	if (flags & NDR_OUT) {
		if (r->out.pControlOutParams == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.pControlOutParams, r->in.dwInfoLevel));
		NDR_CHECK(ndr_push_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pControlOutParams));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ControlServiceExA(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_ControlServiceExA *r)
{
	TALLOC_CTX *_mem_save_pControlInParams_0 = NULL;
	TALLOC_CTX *_mem_save_pControlOutParams_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hService));
		NDR_CHECK(ndr_pull_SERVICE_CONTROL(ndr, NDR_SCALARS, &r->in.dwControl));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwInfoLevel));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pControlInParams);
		}
		_mem_save_pControlInParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pControlInParams, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.pControlInParams, r->in.dwInfoLevel));
		NDR_CHECK(ndr_pull_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pControlInParams));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pControlInParams_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pControlOutParams);
		NDR_ZERO_STRUCTP(r->out.pControlOutParams);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pControlInParams == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pControlInParams);
			NDR_ZERO_STRUCTP(r->in.pControlInParams);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pControlOutParams);
		}
		_mem_save_pControlOutParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pControlOutParams, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.pControlOutParams, r->in.dwInfoLevel));
		NDR_CHECK(ndr_pull_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pControlOutParams));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pControlOutParams_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ControlServiceExA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_ControlServiceExA *r)
{
	ndr_print_struct(ndr, name, "svcctl_ControlServiceExA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ControlServiceExA");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hService", &r->in.hService);
		ndr_print_SERVICE_CONTROL(ndr, "dwControl", r->in.dwControl);
		ndr_print_uint32(ndr, "dwInfoLevel", r->in.dwInfoLevel);
		ndr_print_ptr(ndr, "pControlInParams", r->in.pControlInParams);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.pControlInParams, r->in.dwInfoLevel);
		ndr_print_SC_RPC_SERVICE_CONTROL_IN_PARAMSA(ndr, "pControlInParams", r->in.pControlInParams);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ControlServiceExA");
		ndr->depth++;
		ndr_print_ptr(ndr, "pControlOutParams", r->out.pControlOutParams);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.pControlOutParams, r->in.dwInfoLevel);
		ndr_print_SC_RPC_SERVICE_CONTROL_OUT_PARAMSA(ndr, "pControlOutParams", r->out.pControlOutParams);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_ControlServiceExW(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_ControlServiceExW *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.pControlInParams == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hService));
		NDR_CHECK(ndr_push_SERVICE_CONTROL(ndr, NDR_SCALARS, r->in.dwControl));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwInfoLevel));
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->in.pControlInParams, r->in.dwInfoLevel));
		NDR_CHECK(ndr_push_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pControlInParams));
	}
	if (flags & NDR_OUT) {
		if (r->out.pControlOutParams == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, r->out.pControlOutParams, r->in.dwInfoLevel));
		NDR_CHECK(ndr_push_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pControlOutParams));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_ControlServiceExW(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_ControlServiceExW *r)
{
	TALLOC_CTX *_mem_save_pControlInParams_0 = NULL;
	TALLOC_CTX *_mem_save_pControlOutParams_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hService));
		NDR_CHECK(ndr_pull_SERVICE_CONTROL(ndr, NDR_SCALARS, &r->in.dwControl));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwInfoLevel));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.pControlInParams);
		}
		_mem_save_pControlInParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.pControlInParams, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->in.pControlInParams, r->in.dwInfoLevel));
		NDR_CHECK(ndr_pull_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(ndr, NDR_SCALARS|NDR_BUFFERS, r->in.pControlInParams));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pControlInParams_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.pControlOutParams);
		NDR_ZERO_STRUCTP(r->out.pControlOutParams);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.pControlInParams == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.pControlInParams);
			NDR_ZERO_STRUCTP(r->in.pControlInParams);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pControlOutParams);
		}
		_mem_save_pControlOutParams_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pControlOutParams, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_set_switch_value(ndr, r->out.pControlOutParams, r->in.dwInfoLevel));
		NDR_CHECK(ndr_pull_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pControlOutParams));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pControlOutParams_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_ControlServiceExW(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_ControlServiceExW *r)
{
	ndr_print_struct(ndr, name, "svcctl_ControlServiceExW");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_ControlServiceExW");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hService", &r->in.hService);
		ndr_print_SERVICE_CONTROL(ndr, "dwControl", r->in.dwControl);
		ndr_print_uint32(ndr, "dwInfoLevel", r->in.dwInfoLevel);
		ndr_print_ptr(ndr, "pControlInParams", r->in.pControlInParams);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->in.pControlInParams, r->in.dwInfoLevel);
		ndr_print_SC_RPC_SERVICE_CONTROL_IN_PARAMSW(ndr, "pControlInParams", r->in.pControlInParams);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_ControlServiceExW");
		ndr->depth++;
		ndr_print_ptr(ndr, "pControlOutParams", r->out.pControlOutParams);
		ndr->depth++;
		ndr_print_set_switch_value(ndr, r->out.pControlOutParams, r->in.dwInfoLevel);
		ndr_print_SC_RPC_SERVICE_CONTROL_OUT_PARAMSW(ndr, "pControlOutParams", r->out.pControlOutParams);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum52NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum52NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum52NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum52NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum52NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum52NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum52NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum52NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum52NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum53NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum53NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum53NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum53NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum53NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum53NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum53NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum53NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum53NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum54NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum54NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum54NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum54NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum54NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum54NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum54NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum54NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum54NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum55NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum55NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum55NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum55NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum55NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum55NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum55NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum55NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum55NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_QueryServiceConfigEx(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_QueryServiceConfigEx *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hService));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwInfoLevel));
	}
	if (flags & NDR_OUT) {
		if (r->out.pInfo == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_SC_RPC_CONFIG_INFOW(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pInfo));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_QueryServiceConfigEx(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_QueryServiceConfigEx *r)
{
	TALLOC_CTX *_mem_save_pInfo_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hService));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwInfoLevel));
		NDR_PULL_ALLOC(ndr, r->out.pInfo);
		NDR_ZERO_STRUCTP(r->out.pInfo);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.pInfo);
		}
		_mem_save_pInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.pInfo, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_SC_RPC_CONFIG_INFOW(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.pInfo));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_pInfo_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_QueryServiceConfigEx(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_QueryServiceConfigEx *r)
{
	ndr_print_struct(ndr, name, "svcctl_QueryServiceConfigEx");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_QueryServiceConfigEx");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hService", &r->in.hService);
		ndr_print_uint32(ndr, "dwInfoLevel", r->in.dwInfoLevel);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_QueryServiceConfigEx");
		ndr->depth++;
		ndr_print_ptr(ndr, "pInfo", r->out.pInfo);
		ndr->depth++;
		ndr_print_SC_RPC_CONFIG_INFOW(ndr, "pInfo", r->out.pInfo);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum57NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum57NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum57NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum57NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum57NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum57NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum57NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum57NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum57NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum58NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum58NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum58NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum58NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum58NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum58NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum58NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum58NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum58NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_Opnum59NotUsedOnWire(struct ndr_push *ndr, ndr_flags_type flags, const struct Opnum59NotUsedOnWire *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_Opnum59NotUsedOnWire(struct ndr_pull *ndr, ndr_flags_type flags, struct Opnum59NotUsedOnWire *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_Opnum59NotUsedOnWire(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct Opnum59NotUsedOnWire *r)
{
	ndr_print_struct(ndr, name, "Opnum59NotUsedOnWire");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "Opnum59NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "Opnum59NotUsedOnWire");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_CreateWowService(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_CreateWowService *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.lpServiceName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.lpBinaryPathName == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.hSCManager));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpServiceName, ndr_charset_length(r->in.lpServiceName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpDisplayName));
		if (r->in.lpDisplayName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpDisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpDisplayName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpDisplayName, ndr_charset_length(r->in.lpDisplayName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwDesiredAccess));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwServiceType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwStartType));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwErrorControl));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpBinaryPathName, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpBinaryPathName, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpBinaryPathName, ndr_charset_length(r->in.lpBinaryPathName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpLoadOrderGroup));
		if (r->in.lpLoadOrderGroup) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpLoadOrderGroup, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpLoadOrderGroup, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpLoadOrderGroup, ndr_charset_length(r->in.lpLoadOrderGroup, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpdwTagId));
		if (r->in.lpdwTagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.lpdwTagId));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpDependencies));
		if (r->in.lpDependencies) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwDependSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpDependencies, r->in.dwDependSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwDependSize));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpServiceStartName));
		if (r->in.lpServiceStartName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceStartName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.lpServiceStartName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.lpServiceStartName, ndr_charset_length(r->in.lpServiceStartName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.lpPassword));
		if (r->in.lpPassword) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.dwPwSize));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->in.lpPassword, r->in.dwPwSize));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.dwPwSize));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->in.dwServiceWowType));
	}
	if (flags & NDR_OUT) {
		if (r->out.lpServiceHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.lpdwTagId));
		if (r->out.lpdwTagId) {
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.lpdwTagId));
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.lpServiceHandle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_CreateWowService(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_CreateWowService *r)
{
	uint32_t size_lpServiceName_1 = 0;
	uint32_t length_lpServiceName_1 = 0;
	uint32_t _ptr_lpDisplayName;
	uint32_t size_lpDisplayName_1 = 0;
	uint32_t length_lpDisplayName_1 = 0;
	uint32_t size_lpBinaryPathName_1 = 0;
	uint32_t length_lpBinaryPathName_1 = 0;
	uint32_t _ptr_lpLoadOrderGroup;
	uint32_t size_lpLoadOrderGroup_1 = 0;
	uint32_t length_lpLoadOrderGroup_1 = 0;
	uint32_t _ptr_lpdwTagId;
	uint32_t _ptr_lpDependencies;
	uint32_t size_lpDependencies_1 = 0;
	uint32_t _ptr_lpServiceStartName;
	uint32_t size_lpServiceStartName_1 = 0;
	uint32_t length_lpServiceStartName_1 = 0;
	uint32_t _ptr_lpPassword;
	uint32_t size_lpPassword_1 = 0;
	TALLOC_CTX *_mem_save_lpDisplayName_0 = NULL;
	TALLOC_CTX *_mem_save_lpLoadOrderGroup_0 = NULL;
	TALLOC_CTX *_mem_save_lpdwTagId_0 = NULL;
	TALLOC_CTX *_mem_save_lpDependencies_0 = NULL;
	TALLOC_CTX *_mem_save_lpServiceStartName_0 = NULL;
	TALLOC_CTX *_mem_save_lpPassword_0 = NULL;
	TALLOC_CTX *_mem_save_lpServiceHandle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.hSCManager));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpServiceName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpServiceName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpServiceName, &size_lpServiceName_1));
		if (size_lpServiceName_1 > SC_MAX_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpServiceName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
		}
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpServiceName, &length_lpServiceName_1));
		if (length_lpServiceName_1 > SC_MAX_NAME_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpServiceName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
		}
		if (length_lpServiceName_1 > size_lpServiceName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpServiceName_1, length_lpServiceName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpServiceName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpServiceName, length_lpServiceName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpDisplayName));
		if (_ptr_lpDisplayName) {
			NDR_PULL_ALLOC(ndr, r->in.lpDisplayName);
		} else {
			r->in.lpDisplayName = NULL;
		}
		if (r->in.lpDisplayName) {
			_mem_save_lpDisplayName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpDisplayName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpDisplayName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpDisplayName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpDisplayName, &size_lpDisplayName_1));
			if (size_lpDisplayName_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpDisplayName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpDisplayName, &length_lpDisplayName_1));
			if (length_lpDisplayName_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpDisplayName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			if (length_lpDisplayName_1 > size_lpDisplayName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpDisplayName_1, length_lpDisplayName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpDisplayName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpDisplayName, length_lpDisplayName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpDisplayName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwDesiredAccess));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwServiceType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwStartType));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwErrorControl));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpBinaryPathName));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpBinaryPathName));
		NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpBinaryPathName, &size_lpBinaryPathName_1));
		if (size_lpBinaryPathName_1 > SC_MAX_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpBinaryPathName_1, (uint32_t)(0), (uint32_t)(SC_MAX_PATH_LENGTH));
		}
		NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpBinaryPathName, &length_lpBinaryPathName_1));
		if (length_lpBinaryPathName_1 > SC_MAX_PATH_LENGTH) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpBinaryPathName_1, (uint32_t)(0), (uint32_t)(SC_MAX_PATH_LENGTH));
		}
		if (length_lpBinaryPathName_1 > size_lpBinaryPathName_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpBinaryPathName_1, length_lpBinaryPathName_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_lpBinaryPathName_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpBinaryPathName, length_lpBinaryPathName_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpLoadOrderGroup));
		if (_ptr_lpLoadOrderGroup) {
			NDR_PULL_ALLOC(ndr, r->in.lpLoadOrderGroup);
		} else {
			r->in.lpLoadOrderGroup = NULL;
		}
		if (r->in.lpLoadOrderGroup) {
			_mem_save_lpLoadOrderGroup_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpLoadOrderGroup, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpLoadOrderGroup));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpLoadOrderGroup));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpLoadOrderGroup, &size_lpLoadOrderGroup_1));
			if (size_lpLoadOrderGroup_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpLoadOrderGroup_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpLoadOrderGroup, &length_lpLoadOrderGroup_1));
			if (length_lpLoadOrderGroup_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpLoadOrderGroup_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			if (length_lpLoadOrderGroup_1 > size_lpLoadOrderGroup_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpLoadOrderGroup_1, length_lpLoadOrderGroup_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpLoadOrderGroup_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpLoadOrderGroup, length_lpLoadOrderGroup_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpLoadOrderGroup_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpdwTagId));
		if (_ptr_lpdwTagId) {
			NDR_PULL_ALLOC(ndr, r->in.lpdwTagId);
		} else {
			r->in.lpdwTagId = NULL;
		}
		if (r->in.lpdwTagId) {
			_mem_save_lpdwTagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpdwTagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.lpdwTagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwTagId_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpDependencies));
		if (_ptr_lpDependencies) {
			NDR_PULL_ALLOC(ndr, r->in.lpDependencies);
		} else {
			r->in.lpDependencies = NULL;
		}
		if (r->in.lpDependencies) {
			_mem_save_lpDependencies_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpDependencies, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpDependencies));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpDependencies, &size_lpDependencies_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpDependencies, size_lpDependencies_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpDependencies, size_lpDependencies_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpDependencies_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwDependSize));
		if (r->in.dwDependSize > SC_MAX_DEPEND_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.dwDependSize), (uint32_t)(0), (uint32_t)(SC_MAX_DEPEND_SIZE));
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpServiceStartName));
		if (_ptr_lpServiceStartName) {
			NDR_PULL_ALLOC(ndr, r->in.lpServiceStartName);
		} else {
			r->in.lpServiceStartName = NULL;
		}
		if (r->in.lpServiceStartName) {
			_mem_save_lpServiceStartName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpServiceStartName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpServiceStartName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.lpServiceStartName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.lpServiceStartName, &size_lpServiceStartName_1));
			if (size_lpServiceStartName_1 > SC_MAX_ACCOUNT_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_lpServiceStartName_1, (uint32_t)(0), (uint32_t)(SC_MAX_ACCOUNT_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.lpServiceStartName, &length_lpServiceStartName_1));
			if (length_lpServiceStartName_1 > SC_MAX_ACCOUNT_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_lpServiceStartName_1, (uint32_t)(0), (uint32_t)(SC_MAX_ACCOUNT_NAME_LENGTH));
			}
			if (length_lpServiceStartName_1 > size_lpServiceStartName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_lpServiceStartName_1, length_lpServiceStartName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_lpServiceStartName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.lpServiceStartName, length_lpServiceStartName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpServiceStartName_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpPassword));
		if (_ptr_lpPassword) {
			NDR_PULL_ALLOC(ndr, r->in.lpPassword);
		} else {
			r->in.lpPassword = NULL;
		}
		if (r->in.lpPassword) {
			_mem_save_lpPassword_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.lpPassword, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.lpPassword));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.lpPassword, &size_lpPassword_1));
			NDR_PULL_ALLOC_N(ndr, r->in.lpPassword, size_lpPassword_1);
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->in.lpPassword, size_lpPassword_1));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpPassword_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.dwPwSize));
		if (r->in.dwPwSize > SC_MAX_PWD_SIZE) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.dwPwSize), (uint32_t)(0), (uint32_t)(SC_MAX_PWD_SIZE));
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->in.dwServiceWowType));
		NDR_PULL_ALLOC(ndr, r->out.lpServiceHandle);
		NDR_ZERO_STRUCTP(r->out.lpServiceHandle);
		if (r->in.lpDependencies) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpDependencies, r->in.dwDependSize));
		}
		if (r->in.lpPassword) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.lpPassword, r->in.dwPwSize));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_lpdwTagId));
		if (_ptr_lpdwTagId) {
			NDR_PULL_ALLOC(ndr, r->out.lpdwTagId);
		} else {
			r->out.lpdwTagId = NULL;
		}
		if (r->out.lpdwTagId) {
			_mem_save_lpdwTagId_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.lpdwTagId, 0);
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.lpdwTagId));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpdwTagId_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.lpServiceHandle);
		}
		_mem_save_lpServiceHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.lpServiceHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.lpServiceHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_lpServiceHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_CreateWowService(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_CreateWowService *r)
{
	ndr_print_struct(ndr, name, "svcctl_CreateWowService");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_CreateWowService");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "hSCManager", &r->in.hSCManager);
		ndr_print_ptr(ndr, "lpServiceName", r->in.lpServiceName);
		ndr->depth++;
		ndr_print_string(ndr, "lpServiceName", r->in.lpServiceName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpDisplayName", r->in.lpDisplayName);
		ndr->depth++;
		if (r->in.lpDisplayName) {
			ndr_print_string(ndr, "lpDisplayName", r->in.lpDisplayName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwDesiredAccess", r->in.dwDesiredAccess);
		ndr_print_uint32(ndr, "dwServiceType", r->in.dwServiceType);
		ndr_print_uint32(ndr, "dwStartType", r->in.dwStartType);
		ndr_print_uint32(ndr, "dwErrorControl", r->in.dwErrorControl);
		ndr_print_ptr(ndr, "lpBinaryPathName", r->in.lpBinaryPathName);
		ndr->depth++;
		ndr_print_string(ndr, "lpBinaryPathName", r->in.lpBinaryPathName);
		ndr->depth--;
		ndr_print_ptr(ndr, "lpLoadOrderGroup", r->in.lpLoadOrderGroup);
		ndr->depth++;
		if (r->in.lpLoadOrderGroup) {
			ndr_print_string(ndr, "lpLoadOrderGroup", r->in.lpLoadOrderGroup);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpdwTagId", r->in.lpdwTagId);
		ndr->depth++;
		if (r->in.lpdwTagId) {
			ndr_print_uint32(ndr, "lpdwTagId", *r->in.lpdwTagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpDependencies", r->in.lpDependencies);
		ndr->depth++;
		if (r->in.lpDependencies) {
			ndr_print_array_uint8(ndr, "lpDependencies", r->in.lpDependencies, r->in.dwDependSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwDependSize", r->in.dwDependSize);
		ndr_print_ptr(ndr, "lpServiceStartName", r->in.lpServiceStartName);
		ndr->depth++;
		if (r->in.lpServiceStartName) {
			ndr_print_string(ndr, "lpServiceStartName", r->in.lpServiceStartName);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpPassword", r->in.lpPassword);
		ndr->depth++;
		if (r->in.lpPassword) {
			ndr_print_array_uint8(ndr, "lpPassword", r->in.lpPassword, r->in.dwPwSize);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "dwPwSize", r->in.dwPwSize);
		ndr_print_uint16(ndr, "dwServiceWowType", r->in.dwServiceWowType);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_CreateWowService");
		ndr->depth++;
		ndr_print_ptr(ndr, "lpdwTagId", r->out.lpdwTagId);
		ndr->depth++;
		if (r->out.lpdwTagId) {
			ndr_print_uint32(ndr, "lpdwTagId", *r->out.lpdwTagId);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "lpServiceHandle", r->out.lpServiceHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "lpServiceHandle", r->out.lpServiceHandle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_svcctl_OpenSCManager2(struct ndr_push *ndr, ndr_flags_type flags, const struct svcctl_OpenSCManager2 *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, &r->in.BindingHandle));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.DatabaseName));
		if (r->in.DatabaseName) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.DatabaseName, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.DatabaseName, ndr_charset_length(r->in.DatabaseName, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.DesiredAccess));
	}
	if (flags & NDR_OUT) {
		if (r->out.ScmHandle == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.ScmHandle));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_svcctl_OpenSCManager2(struct ndr_pull *ndr, ndr_flags_type flags, struct svcctl_OpenSCManager2 *r)
{
	uint32_t _ptr_DatabaseName;
	uint32_t size_DatabaseName_1 = 0;
	uint32_t length_DatabaseName_1 = 0;
	TALLOC_CTX *_mem_save_DatabaseName_0 = NULL;
	TALLOC_CTX *_mem_save_ScmHandle_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, &r->in.BindingHandle));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DatabaseName));
		if (_ptr_DatabaseName) {
			NDR_PULL_ALLOC(ndr, r->in.DatabaseName);
		} else {
			r->in.DatabaseName = NULL;
		}
		if (r->in.DatabaseName) {
			_mem_save_DatabaseName_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.DatabaseName, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.DatabaseName));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.DatabaseName));
			NDR_CHECK(ndr_steal_array_size(ndr, (void*)&r->in.DatabaseName, &size_DatabaseName_1));
			if (size_DatabaseName_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", size_DatabaseName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			NDR_CHECK(ndr_steal_array_length(ndr, (void*)&r->in.DatabaseName, &length_DatabaseName_1));
			if (length_DatabaseName_1 > SC_MAX_NAME_LENGTH) {
				return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", length_DatabaseName_1, (uint32_t)(0), (uint32_t)(SC_MAX_NAME_LENGTH));
			}
			if (length_DatabaseName_1 > size_DatabaseName_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_DatabaseName_1, length_DatabaseName_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_DatabaseName_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.DatabaseName, length_DatabaseName_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DatabaseName_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.DesiredAccess));
		NDR_PULL_ALLOC(ndr, r->out.ScmHandle);
		NDR_ZERO_STRUCTP(r->out.ScmHandle);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.ScmHandle);
		}
		_mem_save_ScmHandle_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.ScmHandle, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.ScmHandle));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_ScmHandle_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_svcctl_OpenSCManager2(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct svcctl_OpenSCManager2 *r)
{
	ndr_print_struct(ndr, name, "svcctl_OpenSCManager2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "svcctl_OpenSCManager2");
		ndr->depth++;
		ndr_print_policy_handle(ndr, "BindingHandle", &r->in.BindingHandle);
		ndr_print_ptr(ndr, "DatabaseName", r->in.DatabaseName);
		ndr->depth++;
		if (r->in.DatabaseName) {
			ndr_print_string(ndr, "DatabaseName", r->in.DatabaseName);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "DesiredAccess", r->in.DesiredAccess);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "svcctl_OpenSCManager2");
		ndr->depth++;
		ndr_print_ptr(ndr, "ScmHandle", r->out.ScmHandle);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "ScmHandle", r->out.ScmHandle);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_svcctl
static const struct ndr_interface_public_struct svcctl_public_structs[] = {
	{
		.name = "SERVICE_STATUS_PROCESS",
		.struct_size = sizeof(struct SERVICE_STATUS_PROCESS ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_SERVICE_STATUS_PROCESS,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_SERVICE_STATUS_PROCESS,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_SERVICE_STATUS_PROCESS,
	},
	{
		.name = "ENUM_SERVICE_STATUSW",
		.struct_size = sizeof(struct ENUM_SERVICE_STATUSW ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ENUM_SERVICE_STATUSW,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ENUM_SERVICE_STATUSW,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ENUM_SERVICE_STATUSW,
	},
	{
		.name = "ENUM_SERVICE_STATUSA",
		.struct_size = sizeof(struct ENUM_SERVICE_STATUSA ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ENUM_SERVICE_STATUSA,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ENUM_SERVICE_STATUSA,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ENUM_SERVICE_STATUSA,
	},
	{
		.name = "QUERY_SERVICE_CONFIG",
		.struct_size = sizeof(struct QUERY_SERVICE_CONFIG ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_QUERY_SERVICE_CONFIG,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_QUERY_SERVICE_CONFIG,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_QUERY_SERVICE_CONFIG,
	},
	{
		.name = "SERVICE_DESCRIPTION",
		.struct_size = sizeof(struct SERVICE_DESCRIPTION ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_SERVICE_DESCRIPTION,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_SERVICE_DESCRIPTION,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_SERVICE_DESCRIPTION,
	},
	{
		.name = "SERVICE_FAILURE_ACTIONSW",
		.struct_size = sizeof(struct SERVICE_FAILURE_ACTIONSW ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_SERVICE_FAILURE_ACTIONSW,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_SERVICE_FAILURE_ACTIONSW,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_SERVICE_FAILURE_ACTIONSW,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call svcctl_calls[] = {
	{
		"svcctl_CloseServiceHandle",
		sizeof(struct svcctl_CloseServiceHandle),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CloseServiceHandle,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CloseServiceHandle,
		(ndr_print_function_t) ndr_print_svcctl_CloseServiceHandle,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_ControlService",
		sizeof(struct svcctl_ControlService),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ControlService,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ControlService,
		(ndr_print_function_t) ndr_print_svcctl_ControlService,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_DeleteService",
		sizeof(struct svcctl_DeleteService),
		(ndr_push_flags_fn_t) ndr_push_svcctl_DeleteService,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_DeleteService,
		(ndr_print_function_t) ndr_print_svcctl_DeleteService,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_LockServiceDatabase",
		sizeof(struct svcctl_LockServiceDatabase),
		(ndr_push_flags_fn_t) ndr_push_svcctl_LockServiceDatabase,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_LockServiceDatabase,
		(ndr_print_function_t) ndr_print_svcctl_LockServiceDatabase,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceObjectSecurity",
		sizeof(struct svcctl_QueryServiceObjectSecurity),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceObjectSecurity,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceObjectSecurity,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceObjectSecurity,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_SetServiceObjectSecurity",
		sizeof(struct svcctl_SetServiceObjectSecurity),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SetServiceObjectSecurity,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SetServiceObjectSecurity,
		(ndr_print_function_t) ndr_print_svcctl_SetServiceObjectSecurity,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceStatus",
		sizeof(struct svcctl_QueryServiceStatus),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceStatus,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceStatus,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceStatus,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_SetServiceStatus",
		sizeof(struct svcctl_SetServiceStatus),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SetServiceStatus,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SetServiceStatus,
		(ndr_print_function_t) ndr_print_svcctl_SetServiceStatus,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_UnlockServiceDatabase",
		sizeof(struct svcctl_UnlockServiceDatabase),
		(ndr_push_flags_fn_t) ndr_push_svcctl_UnlockServiceDatabase,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_UnlockServiceDatabase,
		(ndr_print_function_t) ndr_print_svcctl_UnlockServiceDatabase,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_NotifyBootConfigStatus",
		sizeof(struct svcctl_NotifyBootConfigStatus),
		(ndr_push_flags_fn_t) ndr_push_svcctl_NotifyBootConfigStatus,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_NotifyBootConfigStatus,
		(ndr_print_function_t) ndr_print_svcctl_NotifyBootConfigStatus,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_SCSetServiceBitsW",
		sizeof(struct svcctl_SCSetServiceBitsW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SCSetServiceBitsW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SCSetServiceBitsW,
		(ndr_print_function_t) ndr_print_svcctl_SCSetServiceBitsW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_ChangeServiceConfigW",
		sizeof(struct svcctl_ChangeServiceConfigW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ChangeServiceConfigW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ChangeServiceConfigW,
		(ndr_print_function_t) ndr_print_svcctl_ChangeServiceConfigW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_CreateServiceW",
		sizeof(struct svcctl_CreateServiceW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CreateServiceW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CreateServiceW,
		(ndr_print_function_t) ndr_print_svcctl_CreateServiceW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_EnumDependentServicesW",
		sizeof(struct svcctl_EnumDependentServicesW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumDependentServicesW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumDependentServicesW,
		(ndr_print_function_t) ndr_print_svcctl_EnumDependentServicesW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_EnumServicesStatusW",
		sizeof(struct svcctl_EnumServicesStatusW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumServicesStatusW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumServicesStatusW,
		(ndr_print_function_t) ndr_print_svcctl_EnumServicesStatusW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_OpenSCManagerW",
		sizeof(struct svcctl_OpenSCManagerW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_OpenSCManagerW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_OpenSCManagerW,
		(ndr_print_function_t) ndr_print_svcctl_OpenSCManagerW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_OpenServiceW",
		sizeof(struct svcctl_OpenServiceW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_OpenServiceW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_OpenServiceW,
		(ndr_print_function_t) ndr_print_svcctl_OpenServiceW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceConfigW",
		sizeof(struct svcctl_QueryServiceConfigW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceConfigW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceConfigW,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceConfigW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceLockStatusW",
		sizeof(struct svcctl_QueryServiceLockStatusW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceLockStatusW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceLockStatusW,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceLockStatusW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_StartServiceW",
		sizeof(struct svcctl_StartServiceW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_StartServiceW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_StartServiceW,
		(ndr_print_function_t) ndr_print_svcctl_StartServiceW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_GetServiceDisplayNameW",
		sizeof(struct svcctl_GetServiceDisplayNameW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetServiceDisplayNameW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetServiceDisplayNameW,
		(ndr_print_function_t) ndr_print_svcctl_GetServiceDisplayNameW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_GetServiceKeyNameW",
		sizeof(struct svcctl_GetServiceKeyNameW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetServiceKeyNameW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetServiceKeyNameW,
		(ndr_print_function_t) ndr_print_svcctl_GetServiceKeyNameW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_SCSetServiceBitsA",
		sizeof(struct svcctl_SCSetServiceBitsA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SCSetServiceBitsA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SCSetServiceBitsA,
		(ndr_print_function_t) ndr_print_svcctl_SCSetServiceBitsA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_ChangeServiceConfigA",
		sizeof(struct svcctl_ChangeServiceConfigA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ChangeServiceConfigA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ChangeServiceConfigA,
		(ndr_print_function_t) ndr_print_svcctl_ChangeServiceConfigA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_CreateServiceA",
		sizeof(struct svcctl_CreateServiceA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CreateServiceA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CreateServiceA,
		(ndr_print_function_t) ndr_print_svcctl_CreateServiceA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_EnumDependentServicesA",
		sizeof(struct svcctl_EnumDependentServicesA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumDependentServicesA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumDependentServicesA,
		(ndr_print_function_t) ndr_print_svcctl_EnumDependentServicesA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_EnumServicesStatusA",
		sizeof(struct svcctl_EnumServicesStatusA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumServicesStatusA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumServicesStatusA,
		(ndr_print_function_t) ndr_print_svcctl_EnumServicesStatusA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_OpenSCManagerA",
		sizeof(struct svcctl_OpenSCManagerA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_OpenSCManagerA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_OpenSCManagerA,
		(ndr_print_function_t) ndr_print_svcctl_OpenSCManagerA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_OpenServiceA",
		sizeof(struct svcctl_OpenServiceA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_OpenServiceA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_OpenServiceA,
		(ndr_print_function_t) ndr_print_svcctl_OpenServiceA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceConfigA",
		sizeof(struct svcctl_QueryServiceConfigA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceConfigA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceConfigA,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceConfigA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceLockStatusA",
		sizeof(struct svcctl_QueryServiceLockStatusA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceLockStatusA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceLockStatusA,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceLockStatusA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_StartServiceA",
		sizeof(struct svcctl_StartServiceA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_StartServiceA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_StartServiceA,
		(ndr_print_function_t) ndr_print_svcctl_StartServiceA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_GetServiceDisplayNameA",
		sizeof(struct svcctl_GetServiceDisplayNameA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetServiceDisplayNameA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetServiceDisplayNameA,
		(ndr_print_function_t) ndr_print_svcctl_GetServiceDisplayNameA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_GetServiceKeyNameA",
		sizeof(struct svcctl_GetServiceKeyNameA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetServiceKeyNameA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetServiceKeyNameA,
		(ndr_print_function_t) ndr_print_svcctl_GetServiceKeyNameA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_GetCurrentGroupeStateW",
		sizeof(struct svcctl_GetCurrentGroupeStateW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetCurrentGroupeStateW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetCurrentGroupeStateW,
		(ndr_print_function_t) ndr_print_svcctl_GetCurrentGroupeStateW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_EnumServiceGroupW",
		sizeof(struct svcctl_EnumServiceGroupW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumServiceGroupW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumServiceGroupW,
		(ndr_print_function_t) ndr_print_svcctl_EnumServiceGroupW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_ChangeServiceConfig2A",
		sizeof(struct svcctl_ChangeServiceConfig2A),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ChangeServiceConfig2A,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ChangeServiceConfig2A,
		(ndr_print_function_t) ndr_print_svcctl_ChangeServiceConfig2A,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_ChangeServiceConfig2W",
		sizeof(struct svcctl_ChangeServiceConfig2W),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ChangeServiceConfig2W,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ChangeServiceConfig2W,
		(ndr_print_function_t) ndr_print_svcctl_ChangeServiceConfig2W,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceConfig2A",
		sizeof(struct svcctl_QueryServiceConfig2A),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceConfig2A,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceConfig2A,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceConfig2A,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceConfig2W",
		sizeof(struct svcctl_QueryServiceConfig2W),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceConfig2W,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceConfig2W,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceConfig2W,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceStatusEx",
		sizeof(struct svcctl_QueryServiceStatusEx),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceStatusEx,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceStatusEx,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceStatusEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_EnumServicesStatusExA",
		sizeof(struct svcctl_EnumServicesStatusExA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumServicesStatusExA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumServicesStatusExA,
		(ndr_print_function_t) ndr_print_svcctl_EnumServicesStatusExA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_EnumServicesStatusExW",
		sizeof(struct svcctl_EnumServicesStatusExW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_EnumServicesStatusExW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_EnumServicesStatusExW,
		(ndr_print_function_t) ndr_print_svcctl_EnumServicesStatusExW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_SCSendTSMessage",
		sizeof(struct svcctl_SCSendTSMessage),
		(ndr_push_flags_fn_t) ndr_push_svcctl_SCSendTSMessage,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_SCSendTSMessage,
		(ndr_print_function_t) ndr_print_svcctl_SCSendTSMessage,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_CreateServiceWOW64A",
		sizeof(struct svcctl_CreateServiceWOW64A),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CreateServiceWOW64A,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CreateServiceWOW64A,
		(ndr_print_function_t) ndr_print_svcctl_CreateServiceWOW64A,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_CreateServiceWOW64W",
		sizeof(struct svcctl_CreateServiceWOW64W),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CreateServiceWOW64W,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CreateServiceWOW64W,
		(ndr_print_function_t) ndr_print_svcctl_CreateServiceWOW64W,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum46NotUsedOnWire",
		sizeof(struct Opnum46NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum46NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum46NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum46NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_NotifyServiceStatusChange",
		sizeof(struct svcctl_NotifyServiceStatusChange),
		(ndr_push_flags_fn_t) ndr_push_svcctl_NotifyServiceStatusChange,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_NotifyServiceStatusChange,
		(ndr_print_function_t) ndr_print_svcctl_NotifyServiceStatusChange,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_GetNotifyResults",
		sizeof(struct svcctl_GetNotifyResults),
		(ndr_push_flags_fn_t) ndr_push_svcctl_GetNotifyResults,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_GetNotifyResults,
		(ndr_print_function_t) ndr_print_svcctl_GetNotifyResults,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_CloseNotifyHandle",
		sizeof(struct svcctl_CloseNotifyHandle),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CloseNotifyHandle,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CloseNotifyHandle,
		(ndr_print_function_t) ndr_print_svcctl_CloseNotifyHandle,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_ControlServiceExA",
		sizeof(struct svcctl_ControlServiceExA),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ControlServiceExA,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ControlServiceExA,
		(ndr_print_function_t) ndr_print_svcctl_ControlServiceExA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_ControlServiceExW",
		sizeof(struct svcctl_ControlServiceExW),
		(ndr_push_flags_fn_t) ndr_push_svcctl_ControlServiceExW,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_ControlServiceExW,
		(ndr_print_function_t) ndr_print_svcctl_ControlServiceExW,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum52NotUsedOnWire",
		sizeof(struct Opnum52NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum52NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum52NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum52NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum53NotUsedOnWire",
		sizeof(struct Opnum53NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum53NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum53NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum53NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum54NotUsedOnWire",
		sizeof(struct Opnum54NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum54NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum54NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum54NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum55NotUsedOnWire",
		sizeof(struct Opnum55NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum55NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum55NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum55NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_QueryServiceConfigEx",
		sizeof(struct svcctl_QueryServiceConfigEx),
		(ndr_push_flags_fn_t) ndr_push_svcctl_QueryServiceConfigEx,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_QueryServiceConfigEx,
		(ndr_print_function_t) ndr_print_svcctl_QueryServiceConfigEx,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum57NotUsedOnWire",
		sizeof(struct Opnum57NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum57NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum57NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum57NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum58NotUsedOnWire",
		sizeof(struct Opnum58NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum58NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum58NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum58NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"Opnum59NotUsedOnWire",
		sizeof(struct Opnum59NotUsedOnWire),
		(ndr_push_flags_fn_t) ndr_push_Opnum59NotUsedOnWire,
		(ndr_pull_flags_fn_t) ndr_pull_Opnum59NotUsedOnWire,
		(ndr_print_function_t) ndr_print_Opnum59NotUsedOnWire,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_CreateWowService",
		sizeof(struct svcctl_CreateWowService),
		(ndr_push_flags_fn_t) ndr_push_svcctl_CreateWowService,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_CreateWowService,
		(ndr_print_function_t) ndr_print_svcctl_CreateWowService,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"svcctl_OpenSCManager2",
		sizeof(struct svcctl_OpenSCManager2),
		(ndr_push_flags_fn_t) ndr_push_svcctl_OpenSCManager2,
		(ndr_pull_flags_fn_t) ndr_pull_svcctl_OpenSCManager2,
		(ndr_print_function_t) ndr_print_svcctl_OpenSCManager2,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ .name = NULL }
};

static const char * const svcctl_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\svcctl]", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array svcctl_endpoints = {
	.count	= 2,
	.names	= svcctl_endpoint_strings
};

static const char * const svcctl_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array svcctl_authservices = {
	.count	= 1,
	.names	= svcctl_authservice_strings
};


const struct ndr_interface_table ndr_table_svcctl = {
	.name		= "svcctl",
	.syntax_id	= {
		{0x367abb81,0x9844,0x35f1,{0xad,0x32},{0x98,0xf0,0x38,0x00,0x10,0x03}},
		NDR_SVCCTL_VERSION
	},
	.helpstring	= NDR_SVCCTL_HELPSTRING,
	.num_calls	= 62,
	.calls		= svcctl_calls,
	.num_public_structs	= 6,
	.public_structs		= svcctl_public_structs,
	.endpoints	= &svcctl_endpoints,
	.authservices	= &svcctl_authservices
};

#endif /* SKIP_NDR_TABLE_svcctl */
