/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_dfs.h"
#include "bin/default/librpc/gen_ndr/ndr_dfs_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* netdfs - dcerpc server boilerplate generated by pidl */
static NTSTATUS netdfs__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NETDFS_BIND
	return DCESRV_INTERFACE_NETDFS_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void netdfs__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NETDFS_UNBIND
	DCESRV_INTERFACE_NETDFS_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS netdfs__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_netdfs.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_netdfs.calls[opnum].struct_size, "struct %s", ndr_table_netdfs.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_netdfs.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS netdfs__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* dfs_GetManagerVersion */
		struct dfs_GetManagerVersion *r2 = (struct dfs_GetManagerVersion *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetManagerVersion, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.version = talloc_zero(r2, enum dfs_ManagerVersion);
		if (r2->out.version == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		_dfs_GetManagerVersion(p, r2);
		break;
	}
	case 1: { /* dfs_Add */
		struct dfs_Add *r2 = (struct dfs_Add *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Add, NDR_IN, r2);
		}
		r2->out.result = _dfs_Add(p, r2);
		break;
	}
	case 2: { /* dfs_Remove */
		struct dfs_Remove *r2 = (struct dfs_Remove *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Remove, NDR_IN, r2);
		}
		r2->out.result = _dfs_Remove(p, r2);
		break;
	}
	case 3: { /* dfs_SetInfo */
		struct dfs_SetInfo *r2 = (struct dfs_SetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetInfo, NDR_IN, r2);
		}
		r2->out.result = _dfs_SetInfo(p, r2);
		break;
	}
	case 4: { /* dfs_GetInfo */
		struct dfs_GetInfo *r2 = (struct dfs_GetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union dfs_Info);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _dfs_GetInfo(p, r2);
		break;
	}
	case 5: { /* dfs_Enum */
		struct dfs_Enum *r2 = (struct dfs_Enum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Enum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = r2->in.info;
		r2->out.total = r2->in.total;
		r2->out.result = _dfs_Enum(p, r2);
		break;
	}
	case 6: { /* dfs_Rename */
		struct dfs_Rename *r2 = (struct dfs_Rename *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Rename, NDR_IN, r2);
		}
		r2->out.result = _dfs_Rename(p, r2);
		break;
	}
	case 7: { /* dfs_Move */
		struct dfs_Move *r2 = (struct dfs_Move *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Move, NDR_IN, r2);
		}
		r2->out.result = _dfs_Move(p, r2);
		break;
	}
	case 8: { /* dfs_ManagerGetConfigInfo */
		struct dfs_ManagerGetConfigInfo *r2 = (struct dfs_ManagerGetConfigInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerGetConfigInfo, NDR_IN, r2);
		}
		r2->out.result = _dfs_ManagerGetConfigInfo(p, r2);
		break;
	}
	case 9: { /* dfs_ManagerSendSiteInfo */
		struct dfs_ManagerSendSiteInfo *r2 = (struct dfs_ManagerSendSiteInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerSendSiteInfo, NDR_IN, r2);
		}
		r2->out.result = _dfs_ManagerSendSiteInfo(p, r2);
		break;
	}
	case 10: { /* dfs_AddFtRoot */
		struct dfs_AddFtRoot *r2 = (struct dfs_AddFtRoot *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddFtRoot, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.unknown2 = r2->in.unknown2;
		r2->out.result = _dfs_AddFtRoot(p, r2);
		break;
	}
	case 11: { /* dfs_RemoveFtRoot */
		struct dfs_RemoveFtRoot *r2 = (struct dfs_RemoveFtRoot *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_RemoveFtRoot, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.unknown = r2->in.unknown;
		r2->out.result = _dfs_RemoveFtRoot(p, r2);
		break;
	}
	case 12: { /* dfs_AddStdRoot */
		struct dfs_AddStdRoot *r2 = (struct dfs_AddStdRoot *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddStdRoot, NDR_IN, r2);
		}
		r2->out.result = _dfs_AddStdRoot(p, r2);
		break;
	}
	case 13: { /* dfs_RemoveStdRoot */
		struct dfs_RemoveStdRoot *r2 = (struct dfs_RemoveStdRoot *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_RemoveStdRoot, NDR_IN, r2);
		}
		r2->out.result = _dfs_RemoveStdRoot(p, r2);
		break;
	}
	case 14: { /* dfs_ManagerInitialize */
		struct dfs_ManagerInitialize *r2 = (struct dfs_ManagerInitialize *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerInitialize, NDR_IN, r2);
		}
		r2->out.result = _dfs_ManagerInitialize(p, r2);
		break;
	}
	case 15: { /* dfs_AddStdRootForced */
		struct dfs_AddStdRootForced *r2 = (struct dfs_AddStdRootForced *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddStdRootForced, NDR_IN, r2);
		}
		r2->out.result = _dfs_AddStdRootForced(p, r2);
		break;
	}
	case 16: { /* dfs_GetDcAddress */
		struct dfs_GetDcAddress *r2 = (struct dfs_GetDcAddress *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetDcAddress, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.server_fullname = r2->in.server_fullname;
		r2->out.is_root = r2->in.is_root;
		r2->out.ttl = r2->in.ttl;
		r2->out.result = _dfs_GetDcAddress(p, r2);
		break;
	}
	case 17: { /* dfs_SetDcAddress */
		struct dfs_SetDcAddress *r2 = (struct dfs_SetDcAddress *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetDcAddress, NDR_IN, r2);
		}
		r2->out.result = _dfs_SetDcAddress(p, r2);
		break;
	}
	case 18: { /* dfs_FlushFtTable */
		struct dfs_FlushFtTable *r2 = (struct dfs_FlushFtTable *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_FlushFtTable, NDR_IN, r2);
		}
		r2->out.result = _dfs_FlushFtTable(p, r2);
		break;
	}
	case 19: { /* dfs_Add2 */
		struct dfs_Add2 *r2 = (struct dfs_Add2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Add2, NDR_IN, r2);
		}
		r2->out.result = _dfs_Add2(p, r2);
		break;
	}
	case 20: { /* dfs_Remove2 */
		struct dfs_Remove2 *r2 = (struct dfs_Remove2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Remove2, NDR_IN, r2);
		}
		r2->out.result = _dfs_Remove2(p, r2);
		break;
	}
	case 21: { /* dfs_EnumEx */
		struct dfs_EnumEx *r2 = (struct dfs_EnumEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_EnumEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = r2->in.info;
		r2->out.total = r2->in.total;
		r2->out.result = _dfs_EnumEx(p, r2);
		break;
	}
	case 22: { /* dfs_SetInfo2 */
		struct dfs_SetInfo2 *r2 = (struct dfs_SetInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetInfo2, NDR_IN, r2);
		}
		r2->out.result = _dfs_SetInfo2(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS netdfs__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return netdfs__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS netdfs__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* dfs_GetManagerVersion */
		struct dfs_GetManagerVersion *r2 = (struct dfs_GetManagerVersion *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_GetManagerVersion replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetManagerVersion, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_GetManagerVersion\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* dfs_Add */
		struct dfs_Add *r2 = (struct dfs_Add *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Add replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Add, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_Add\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* dfs_Remove */
		struct dfs_Remove *r2 = (struct dfs_Remove *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Remove replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Remove, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_Remove\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* dfs_SetInfo */
		struct dfs_SetInfo *r2 = (struct dfs_SetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_SetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_SetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* dfs_GetInfo */
		struct dfs_GetInfo *r2 = (struct dfs_GetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_GetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_GetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* dfs_Enum */
		struct dfs_Enum *r2 = (struct dfs_Enum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Enum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Enum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_Enum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* dfs_Rename */
		struct dfs_Rename *r2 = (struct dfs_Rename *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Rename replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Rename, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_Rename\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* dfs_Move */
		struct dfs_Move *r2 = (struct dfs_Move *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Move replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Move, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_Move\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* dfs_ManagerGetConfigInfo */
		struct dfs_ManagerGetConfigInfo *r2 = (struct dfs_ManagerGetConfigInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_ManagerGetConfigInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerGetConfigInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_ManagerGetConfigInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* dfs_ManagerSendSiteInfo */
		struct dfs_ManagerSendSiteInfo *r2 = (struct dfs_ManagerSendSiteInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_ManagerSendSiteInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerSendSiteInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_ManagerSendSiteInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* dfs_AddFtRoot */
		struct dfs_AddFtRoot *r2 = (struct dfs_AddFtRoot *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_AddFtRoot replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddFtRoot, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_AddFtRoot\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* dfs_RemoveFtRoot */
		struct dfs_RemoveFtRoot *r2 = (struct dfs_RemoveFtRoot *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_RemoveFtRoot replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_RemoveFtRoot, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_RemoveFtRoot\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* dfs_AddStdRoot */
		struct dfs_AddStdRoot *r2 = (struct dfs_AddStdRoot *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_AddStdRoot replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddStdRoot, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_AddStdRoot\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* dfs_RemoveStdRoot */
		struct dfs_RemoveStdRoot *r2 = (struct dfs_RemoveStdRoot *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_RemoveStdRoot replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_RemoveStdRoot, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_RemoveStdRoot\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* dfs_ManagerInitialize */
		struct dfs_ManagerInitialize *r2 = (struct dfs_ManagerInitialize *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_ManagerInitialize replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_ManagerInitialize, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_ManagerInitialize\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* dfs_AddStdRootForced */
		struct dfs_AddStdRootForced *r2 = (struct dfs_AddStdRootForced *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_AddStdRootForced replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_AddStdRootForced, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_AddStdRootForced\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* dfs_GetDcAddress */
		struct dfs_GetDcAddress *r2 = (struct dfs_GetDcAddress *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_GetDcAddress replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_GetDcAddress, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_GetDcAddress\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* dfs_SetDcAddress */
		struct dfs_SetDcAddress *r2 = (struct dfs_SetDcAddress *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_SetDcAddress replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetDcAddress, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_SetDcAddress\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* dfs_FlushFtTable */
		struct dfs_FlushFtTable *r2 = (struct dfs_FlushFtTable *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_FlushFtTable replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_FlushFtTable, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_FlushFtTable\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* dfs_Add2 */
		struct dfs_Add2 *r2 = (struct dfs_Add2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Add2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Add2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_Add2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* dfs_Remove2 */
		struct dfs_Remove2 *r2 = (struct dfs_Remove2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_Remove2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_Remove2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_Remove2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* dfs_EnumEx */
		struct dfs_EnumEx *r2 = (struct dfs_EnumEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_EnumEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_EnumEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_EnumEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* dfs_SetInfo2 */
		struct dfs_SetInfo2 *r2 = (struct dfs_SetInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function dfs_SetInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(dfs_SetInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in dfs_SetInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS netdfs__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_netdfs.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS netdfs__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return netdfs__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_netdfs_interface = {
	.name      = "netdfs",
	.syntax_id = {{0x4fc742e0,0x4a10,0x11cf,{0x82,0x73},{0x00,0xaa,0x00,0x4a,0xe6,0x73}},3.0},
	.bind      = netdfs__op_bind,
	.unbind    = netdfs__op_unbind,
	.ndr_pull  = netdfs__op_ndr_pull,
	.dispatch  = netdfs__op_dispatch,
	.reply     = netdfs__op_reply,
	.ndr_push  = netdfs__op_ndr_push,
	.local     = netdfs__op_local,
#ifdef DCESRV_INTERFACE_NETDFS_FLAGS
	.flags     = DCESRV_INTERFACE_NETDFS_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS netdfs__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_NETDFS_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_NETDFS_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_netdfs.endpoints->count;i++) {
		const char *name = ndr_table_netdfs.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_netdfs_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS netdfs__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool netdfs__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_netdfs_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_netdfs_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_netdfs_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool netdfs__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_netdfs_interface.name, name)==0) {
		memcpy(iface, &dcesrv_netdfs_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server netdfs_ep_server = {
	/* fill in our name */
	.name = "netdfs",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_NETDFS_INIT_SERVER
	.init_server = DCESRV_INTERFACE_NETDFS_INIT_SERVER,
#else
	.init_server = netdfs__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_NETDFS_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_NETDFS_SHUTDOWN_SERVER,
#else
	.shutdown_server = netdfs__op_shutdown_server,
#endif
	.interface_by_uuid = netdfs__op_interface_by_uuid,
	.interface_by_name = netdfs__op_interface_by_name
};

const struct dcesrv_endpoint_server *netdfs_get_ep_server(void)
{
	return &netdfs_ep_server;
}
