#include "../../shared/environment.h"
#include "solution_map.h"
/* solution-shipping.py:212 */
solution_map::solution_map() {
  if (!rocfft_getenv("ROCFFT_USE_EMPTY_SOL_MAP").empty()) {
    return;
  }
  SolutionNode solution;

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type = StrToSolutionNodeType(
      "SOL_BUILTIN_KERNEL");                 /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme = CS_NONE;           /* solution-shipping.py:197 */
  solution.solution_childnodes = {};         /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      125, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 5, 5}, 18, 450, {25, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len125_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      125, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 5, 5}, 10, 250, {25, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len125_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      2187, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 9, 3, 3, 3}, 1, 243, {243, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len2187_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 3, 3, 3}, 8, 216, {27, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len243_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 3, 3, 3}, 4, 108, {27, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len243_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      256, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 2, 8, 4}, 4, 128, {32, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len256_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      256, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 2, 8, 2}, 4, 128, {32, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len256_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      4096, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 16, 4, 8}, 2, 256, {128, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len4096_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      4096, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 8, 16, 4}, 2, 512, {256, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len4096_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      4096, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 8, 8, 4, 4}, 2, 512, {256, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len4096_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      56, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 2, 7, 2}, 32, 256, {8, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len56_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      56, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {7, 4, 2}, 32, 256, {8, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len56_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {10, 5, 2}, 12, 120, {10, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len100_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(125, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 5, 5}, 26, 130, {5, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len125_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(125, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 5, 5}, 25, 125, {5, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len125_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {7, 3, 8}, 8, 64, {8, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len168_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 7, 2}, 12, 168, {14, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len168_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {6, 7, 2, 2}, 12, 168, {14, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len168_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {7, 8, 3}, 8, 168, {21, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len168_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {7, 6, 2, 2}, 8, 112, {14, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len168_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {7, 8, 3}, 12, 252, {21, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len168_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(243, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {9, 9, 3}, 8, 216, {27, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len243_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(243, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 3, 9, 3}, 15, 405, {27, 0}, true, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len243_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 7, 6, 4}, 4, 112, {28, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 16, 3}, 6, 126, {21, 0}, true, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {6, 7, 2, 4}, 4, 112, {28, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 16, 3}, 6, 126, {21, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(343, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {7, 7, 7}, 4, 196, {49, 0}, true, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len343_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 2, 4, 2}, 16, 64, {4, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len64_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 4, 2}, 16, 64, {4, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len64_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 8, 4}, 16, 64, {4, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len64_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 2, 2}, 16, 64, {4, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len64_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {9, 3, 3}, 28, 252, {9, 0}, true, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len81_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {9, 3, 3}, 28, 252, {9, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len81_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 9, 3}, 28, 252, {9, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len81_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(96, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 6, 2}, 16, 192, {12, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len96_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {5, 10, 2}, 20, 200, {10, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len100_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(112, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {4, 7, 2, 2}, 8, 64, {8, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len112_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {4, 4, 4, 2}, 16, 128, {8, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len128_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {4, 8, 2, 2}, 16, 128, {8, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len128_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {4, 3, 2, 8}, 8, 192, {24, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len192_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {16, 4, 4}, 8, 128, {16, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len256_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {8, 2, 4, 4}, 8, 128, {16, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len256_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {16, 2, 8}, 8, 128, {16, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len256_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(49, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {7, 7}, 28, 196, {7, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len49_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {3, 9, 3}, 15, 135, {9, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len81_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {3, 9, 3}, 36, 324, {9, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len81_single_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CR"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 3, 4, 4}, 6, 168, {28, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len336_double_sbcr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(56, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CR"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 4, 2}, 16, 128, {8, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len56_double_sbcr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_TRANSPOSE_XY_Z"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {4, 4, 8, 2}, 16, 256, {16, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len256_single_sbrc_xy_z"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "2187_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len2187_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "2187_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "4096_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len4096_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "4096_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len4096_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "4096_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len4096_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "4096_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_double_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_168_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_168_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_double_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_168_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_double_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_168_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_double_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_168_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_double_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_168_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len343_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_343_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_64_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_64_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_double_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_64_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_double_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_64_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_81_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_81_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_81_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_96_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len112_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_112_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_double_sbrc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_192_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_double_sbrc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_double_sbrc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len49_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_49_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_81_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_single_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_81_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcr_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_double_sbcr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcr_56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_TRANSPOSE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_TRANSPOSE_XY_Z"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_TRANSPOSE_Z_XY"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_TRANSPOSE_XY_Z"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_single_sbrc_xy_z", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbrc_xy_z_256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_TRTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 0},
      {"6561_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 0},
      {"2187_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "14348907_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_TRTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 0},
      {"4096_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 0},
      {"4096_sp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "16777216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_100_dp_ip_complex", 0},
      {"sbrc_100_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "10000_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_96_dp_ip_complex", 0},
      {"sbrc_112_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "10752_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_64_dp_ip_complex", 3},
      {"sbrc_256_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "16384_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_343_dp_ip_complex", 0},
      {"sbrc_49_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "16807_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_dp_ip_complex", 5},
      {"sbrc_112_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "18816_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_243_dp_ip_complex", 0},
      {"sbrc_81_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "19683_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_dp_ip_complex", 2},
      {"sbrc_128_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "21504_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_dp_ip_complex", 2},
      {"sbrc_192_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "32256_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_dp_ip_complex", 4},
      {"sbrc_256_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "43008_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_81_sp_ip_complex", 0},
      {"sbrc_81_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_81_sp_ip_complex", 1},
      {"sbrc_81_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_81_sp_ip_complex", 2},
      {"sbrc_81_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_64_dp_ip_complex", 3},
      {"sbrc_128_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "8192_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"4096_sp_ip_complex", 3},
      {"leafnode_token_builtin_kernel", 0},
      {"4096_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "4096_4096_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"6561_sp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 0},
      {"6561_sp_ip_complex", 3},
      {"leafnode_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "6561_6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "125_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"125_sp_ip_complex", 1},
      {"sbcc_125_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "125_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"125_sp_ip_complex", 2},
      {"sbcc_125_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "125_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "243_243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"243_sp_ip_complex", 1},
      {"sbcc_243_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "243_243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "56_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_dp_ip_complex", 1},
      {"sbcc_336_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "56_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_dp_ip_complex", 2},
      {"sbcc_336_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "56_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_RTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"243_243_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 1},
      {"243_sp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "243_243_243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcr_336_dp_ip_complex", 0},
      {"sbcr_336_dp_ip_complex", 0},
      {"sbcr_56_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "56_336_336_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"125_125_sp_ip_complex", 2},
      {"sbcc_125_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "125_125_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_336_dp_ip_complex", 2},
      {"sbcc_336_dp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "56_336_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      100, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 5, 4}, 6, 120, {20, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len100_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 5, 10}, 16, 320, {20, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 5, 5}, 16, 320, {20, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx908"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"200_sp_ip_complex", 1},
      {"sbcc_200_sp_ip_complex", 0},
      {"sbcc_200_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx908", "200_200_200_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type = StrToSolutionNodeType(
      "SOL_BUILTIN_KERNEL");                 /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme = CS_NONE;           /* solution-shipping.py:197 */
  solution.solution_childnodes = {};         /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      100, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 4, 5}, 10, 250, {25, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      100, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {10, 10}, 20, 200, {10, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      100, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 5, 5}, 6, 120, {20, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      100, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {10, 10}, 19, 190, {10, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      108, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 4, 3}, 16, 192, {12, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len108_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      108, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 4, 3}, 10, 120, {12, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len108_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      112, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 4, 7}, 18, 126, {7, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len112_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      112, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 7, 8}, 8, 64, {8, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len112_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      125, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 5, 5}, 10, 250, {25, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len125_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      125, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 5, 5}, 10, 250, {25, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len125_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      128, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 2, 8}, 8, 128, {16, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      128, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 2, 8}, 8, 128, {16, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      128, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 8, 8}, 8, 128, {16, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      192, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 3, 4, 8}, 16, 256, {16, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      192, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 4, 4, 3, 2}, 16, 256, {16, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      192, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 2, 3, 4, 4}, 16, 256, {16, 0}, true, true, false,
                   StrToEBType("NONE"), 1, 3, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      192, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 4, 4, 4}, 16, 256, {16, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      192, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 2, 3, 4, 4}, 16, 192, {12, 0}, false, true, false,
                   StrToEBType("NONE"), 1, 3, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      2187, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 9, 9, 3}, 1, 243, {243, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len2187_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      2187, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 3, 3, 3, 3, 3}, 1, 243, {243, 0}, true, true,
                   false, StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len2187_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 3, 3, 3, 3}, 3, 243, {81, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 9, 3}, 4, 108, {27, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 3, 9}, 7, 189, {27, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 3, 3, 3, 3}, 2, 162, {81, 0}, false, true, false,
                   StrToEBType("NONE"), 1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 3, 3, 3, 3}, 2, 162, {81, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("HI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 9, 9}, 4, 108, {27, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("HI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 9, 3}, 4, 108, {27, 0}, false, false, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      243, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 9, 3}, 7, 189, {27, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      256, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 4, 4, 8}, 4, 128, {32, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len256_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      25, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 5}, 13, 65, {5, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len25_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      25, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 5}, 25, 125, {5, 0}, false, true, false,
                   StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len25_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      26, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {13, 2}, 32, 64, {2, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len26_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      26, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {13, 2}, 64, 128, {2, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len26_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      4096, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 16, 4, 8}, 2, 256, {128, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len4096_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      40, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 4, 2}, 20, 200, {10, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len40_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      42, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 3, 7}, 9, 63, {7, 0}, false, true, false,
                   StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len42_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      48, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 4, 6}, 10, 60, {6, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len48_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      48, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 2, 6}, 10, 60, {6, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len48_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      48, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 2, 6}, 10, 60, {6, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len48_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      48, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 4, 6}, 10, 60, {6, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len48_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      50, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {10, 5}, 25, 125, {5, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len50_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      50, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 5, 5}, 6, 60, {10, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len50_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      50, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 2, 5}, 6, 60, {10, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len50_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      50, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 5, 5}, 6, 60, {10, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len50_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      50, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 5, 2}, 6, 60, {10, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len50_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      50, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 5, 5}, 6, 60, {10, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len50_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      50, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 5, 5}, 12, 60, {5, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len50_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      50, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 5, 5}, 25, 125, {5, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len50_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      52, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {13, 4}, 16, 64, {4, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len52_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      52, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {13, 4}, 32, 128, {4, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len52_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      52, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 13}, 9, 117, {13, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len52_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      54, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 3, 6}, 21, 126, {6, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len54_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      54, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 3, 3, 3}, 10, 60, {6, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len54_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      54, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 3, 6}, 10, 60, {6, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len54_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      54, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 3, 3, 3}, 10, 60, {6, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len54_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      55, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 11}, 12, 132, {11, 0}, true, true, false,
                   StrToEBType("NONE"), 1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len55_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      55, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 11}, 5, 55, {11, 0}, false, true, false,
                   StrToEBType("NONE"), 1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len55_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      55, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 11}, 12, 132, {11, 0}, false, true, false,
                   StrToEBType("NONE"), 1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len55_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      55, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 11}, 12, 132, {11, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len55_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      55, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 11}, 11, 121, {11, 0}, true, true, false,
                   StrToEBType("NONE"), -1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len55_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      55, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 11}, 11, 121, {11, 0}, false, true, false,
                   StrToEBType("NONE"), 1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len55_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      55, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 11}, 6, 66, {11, 0}, false, true, false,
                   StrToEBType("NONE"), 1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len55_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      56, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {7, 4, 2}, 16, 128, {8, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len56_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      56, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {7, 4, 2}, 8, 64, {8, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len56_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      56, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {7, 2, 4}, 24, 192, {8, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len56_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      56, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 7, 2}, 16, 128, {8, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len56_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      56, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {7, 4, 2}, 18, 252, {14, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len56_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      56, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 4, 7}, 4, 56, {14, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len56_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      64, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 8}, 8, 64, {8, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      64, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 8}, 8, 64, {8, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      72, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 3, 8}, 8, 64, {8, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len72_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      72, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 3, 3, 4}, 8, 64, {8, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len72_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      75, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 3, 5}, 13, 195, {15, 0}, false, true, false,
                   StrToEBType("NONE"), 1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len75_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      75, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 5, 5}, 8, 120, {15, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len75_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      81, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 3, 3}, 21, 189, {9, 0}, false, true, false,
                   StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len81_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      84, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 6, 7}, 9, 126, {14, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      84, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 6, 7}, 9, 126, {14, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      84, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {7, 6, 2}, 18, 252, {14, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      84, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 6, 7}, 9, 126, {14, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      96, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 2, 3, 8}, 8, 64, {8, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      96, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 3, 4, 4}, 8, 64, {8, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      96, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 6, 8}, 8, 64, {8, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      96, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 3, 4, 4}, 8, 64, {8, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      96, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 6, 8}, 8, 64, {8, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      96, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 3, 4, 4}, 16, 128, {8, 0}, true, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      96, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 3, 8}, 8, 64, {8, 0}, true, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      96, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 3, 8}, 16, 128, {8, 0}, false, true, false,
                   StrToEBType("C2R_PRE"), 1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {10, 2, 5}, 12, 120, {10, 0}, true, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 10, 5}, 20, 200, {10, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 5, 5}, 13, 130, {10, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {10, 5, 2}, 19, 190, {10, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("HI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {10, 10}, 19, 190, {10, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {10, 5, 2}, 25, 250, {10, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 2, 10}, 25, 250, {10, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 10, 2}, 25, 250, {10, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("HI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {10, 10}, 25, 250, {10, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(104, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 13, 2}, 19, 152, {8, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len104_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(104, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 13, 2}, 8, 208, {26, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len104_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(104, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 13, 2}, 8, 208, {26, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len104_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(104, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 13, 2, 2}, 8, 208, {26, 0}, true, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len104_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(108, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {9, 2, 6}, 21, 252, {12, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len108_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(108, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {9, 3, 4}, 21, 252, {12, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len108_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(108, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 4, 9}, 22, 198, {9, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len108_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(108, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 9}, 28, 252, {9, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len108_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(108, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 3, 9}, 28, 252, {9, 0}, true, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len108_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(108, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 3, 9}, 28, 252, {9, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len108_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(108, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {6, 2, 9}, 28, 252, {9, 0}, false, true, false,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len108_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(112, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 2, 2, 7}, 28, 196, {7, 0}, true, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len112_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(112, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 7}, 19, 133, {7, 0}, false, true, false,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len112_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(112, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 7}, 19, 133, {7, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len112_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(125, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {5, 5, 5}, 9, 225, {25, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len125_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(125, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {5, 5, 5}, 10, 250, {25, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len125_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(125, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 5, 5}, 32, 160, {5, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len125_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(125, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 5, 5}, 20, 500, {25, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len125_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(125, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 5, 5}, 20, 500, {25, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len125_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 4, 2, 2}, 16, 128, {8, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 4, 4}, 32, 128, {4, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 4, 2}, 16, 128, {8, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 4, 4}, 32, 128, {4, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(160, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 8, 10}, 20, 200, {10, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len160_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(160, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 10}, 19, 190, {10, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len160_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(160, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 4, 5}, 25, 250, {10, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len160_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(160, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 4, 5}, 20, 200, {10, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len160_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(160, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 4, 5}, 20, 200, {10, 0}, true, true,
                         true, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len160_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(160, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 8, 10}, 19, 190, {10, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len160_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {7, 8, 3}, 12, 252, {21, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {7, 6, 2, 2}, 12, 168, {14, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {2, 7, 6, 2}, 12, 168, {14, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 4, 3, 2}, 18, 252, {14, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 3, 4, 7}, 10, 140, {14, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 6, 7}, 14, 196, {14, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 7, 2}, 10, 140, {14, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 3, 4, 7}, 14, 196, {14, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 6, 2, 2}, 14, 196, {14, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 7, 8}, 24, 192, {8, 0}, false, true, false,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 4, 7, 2}, 14, 196, {14, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 4, 3, 2}, 18, 252, {14, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(168, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 3, 4, 7}, 18, 252, {14, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len168_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 3, 16}, 16, 256, {16, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 2, 2, 3, 4}, 16, 256, {16, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 16}, 16, 256, {16, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 6, 8}, 16, 256, {16, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 2, 3, 4}, 16, 192, {12, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 2, 2, 3}, 21, 252, {12, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 3, 4, 4}, 16, 256, {16, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {16, 4, 3}, 16, 192, {12, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 3, 4}, 16, 256, {16, 0}, true, true,
                         true, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 6, 2}, 16, 192, {12, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 3, 4, 4}, 16, 256, {16, 0}, true, true,
                         true, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {10, 2, 10}, 10, 200, {20, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len200_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 10, 5, 2}, 12, 240, {20, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 5, 10, 2}, 10, 200, {20, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 5, 10}, 12, 240, {20, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 10, 10}, 12, 240, {20, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 5, 5}, 16, 320, {20, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 5, 10}, 16, 320, {20, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(208, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {13, 8, 2}, 9, 234, {26, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len208_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(208, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {13, 8, 2}, 9, 234, {26, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("HI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len208_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(208, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 4, 13}, 19, 247, {13, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len208_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(208, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 4, 13}, 19, 247, {13, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("HI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len208_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(208, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 8, 13}, 19, 247, {13, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len208_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(216, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 3, 3, 6}, 8, 144, {18, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len216_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(216, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 9, 2}, 8, 144, {18, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len216_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(216, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {9, 6, 2, 2}, 14, 252, {18, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len216_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(216, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 2, 6, 6}, 14, 252, {18, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len216_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(216, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {9, 4, 3, 2}, 14, 252, {18, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len216_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(216, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {6, 4, 3, 3}, 14, 252, {18, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len216_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(224, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 2, 4, 4}, 9, 252, {28, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len224_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(224, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 4, 7}, 18, 252, {14, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len224_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(224, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 7, 2, 2, 2}, 14, 196, {14, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len224_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(224, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 2, 4, 7}, 14, 196, {14, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len224_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(224, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 7, 8}, 16, 256, {16, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len224_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(224, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 4, 4, 7}, 18, 252, {14, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len224_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(240, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 5, 3, 4}, 12, 240, {20, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len240_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(240, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 3, 5}, 12, 240, {20, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len240_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(240, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 3, 4, 5, 2}, 7, 140, {20, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len240_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(240, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 3, 10, 2, 2}, 9, 180, {20, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len240_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(240, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 10, 3, 2}, 9, 180, {20, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len240_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(240, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 3, 4, 4}, 12, 240, {20, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len240_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(240, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 5, 3, 4}, 12, 240, {20, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len240_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(243, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {3, 9, 3, 3}, 7, 189, {27, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(243, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {9, 3, 3, 3}, 7, 189, {27, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(243, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {9, 9, 3}, 8, 216, {27, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(243, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 3, 9, 3}, 16, 432, {27, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len243_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(280, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 7, 10, 2}, 9, 252, {28, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len280_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(280, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 7, 5, 2}, 9, 252, {28, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len280_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 7, 3, 4}, 6, 168, {28, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 8, 2, 3}, 6, 126, {21, 0}, true, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 7, 6, 4}, 4, 112, {28, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 7, 8, 2}, 6, 252, {42, 0}, true, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 3, 4, 4}, 6, 168, {28, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 7, 8, 2}, 4, 168, {42, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 8, 2, 3}, 6, 252, {42, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 16, 3}, 6, 126, {21, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(343, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {7, 7, 7}, 4, 196, {49, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len343_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(343, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {7, 7, 7}, 4, 196, {49, 0}, false, true, false,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len343_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(60, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 2, 6}, 11, 132, {12, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len60_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(60, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 4, 5}, 38, 190, {5, 0}, true, true, true,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len60_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {8, 2, 4}, 16, 64, {4, 0}, true, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {4, 4, 2, 2}, 16, 64, {4, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 2, 2, 2}, 16, 64, {4, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("OP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 8, 2}, 16, 64, {4, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("OP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 2, 2}, 16, 64, {4, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("OP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 4, 4}, 16, 64, {4, 0}, true, true, false,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 4}, 16, 64, {4, 0}, true, true, true,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(64, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 4, 4}, 16, 64, {4, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(72, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 3, 2}, 32, 192, {6, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len72_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(72, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 6}, 32, 192, {6, 0}, true, true, true,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len72_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(72, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 4, 6}, 42, 252, {6, 0}, true, true, false,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len72_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(72, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 6}, 32, 192, {6, 0}, true, true, false,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len72_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(80, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 5}, 51, 255, {5, 0}, true, true, false,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len80_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(80, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 4, 5}, 51, 255, {5, 0}, true, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len80_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(80, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 4, 5}, 38, 190, {5, 0}, true, true, true,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len80_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(80, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 4, 5}, 38, 190, {5, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len80_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(80, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 4, 5}, 25, 125, {5, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len80_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 9, 3}, 21, 189, {9, 0}, false, false, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len81_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {9, 3, 3}, 21, 189, {9, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len81_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(true, {3, 9, 3}, 21, 189, {9, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len81_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(84, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 7}, 14, 196, {14, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(84, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {6, 2, 7}, 36, 252, {7, 0}, true, true, false,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(84, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 4, 7}, 27, 189, {7, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(84, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 7}, 27, 189, {7, 0}, false, true, false,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(96, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 3, 4}, 16, 192, {12, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(96, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 2, 3, 4}, 16, 128, {8, 0}, true, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(96, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 4, 6}, 21, 126, {6, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(96, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 4, 8}, 24, 192, {8, 0}, false, true, false,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(96, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 6, 8}, 24, 192, {8, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(96, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 3, 8}, 24, 192, {8, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(96, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {3, 4, 8}, 24, 192, {8, 0}, false, true, true,
                         StrToEBType("NONE"), 1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(96, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {4, 2, 3, 4}, 24, 192, {8, 0}, false, true,
                         true, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(100, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {10, 5, 2}, 20, 200, {10, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len100_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(112, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {7, 2, 8}, 16, 128, {8, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len112_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(112, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {2, 4, 7, 2}, 16, 128, {8, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len112_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(112, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {7, 2, 8}, 8, 64, {8, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len112_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(125, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {5, 5, 5}, 10, 250, {25, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len125_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {8, 8, 2}, 8, 128, {16, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {8, 2, 8}, 16, 128, {8, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {4, 2, 2, 8}, 16, 128, {8, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("OP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {4, 16, 2}, 16, 128, {8, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("OP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(128, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {2, 4, 4, 4}, 16, 128, {8, 0}, false, true,
                         false, StrToEBType("NONE"), 1, 2,
                         StrToPlacementCode("OP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {2, 8, 6, 2}, 4, 64, {16, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {8, 4, 3, 2}, 8, 128, {16, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(192, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {8, 3, 8}, 8, 192, {24, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len192_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {8, 4, 4, 2}, 8, 256, {32, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len256_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(49, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {7, 7}, 28, 196, {7, 0}, false, false, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len49_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(49, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {7, 7}, 28, 196, {7, 0}, false, true, false,
                         StrToEBType("NONE"), 1, 2, StrToPlacementCode("OP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len49_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {9, 3, 3}, 22, 198, {9, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len81_double_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {9, 3, 3}, 36, 324, {9, 0}, false, false, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len81_single_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {9, 3, 3}, 36, 324, {9, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len81_single_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(81, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_RC"),
            StrToSBRCTransType("TILE_UNALIGNED"),
            KernelConfig(false, {3, 9, 3}, 36, 324, {9, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len81_single_sbrc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CR"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 2, 3, 7}, 6, 252, {42, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CR"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 8, 2, 3}, 6, 252, {42, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CR"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {7, 2, 4, 6}, 6, 252, {42, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(336, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CR"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 2, 3, 7}, 6, 252, {42, 0}, false, true,
                         true, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len336_double_sbcr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(56, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CR"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 7, 4}, 16, 128, {8, 0}, false, true, true,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len56_double_sbcr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(56, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CR"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 7, 4}, 16, 128, {8, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 0, StrToPlacementCode("NA"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len56_double_sbcr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_TRANSPOSE_XY_Z"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {4, 2, 2, 16}, 16, 256, {16, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len256_single_sbrc_xy_z"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_TRANSPOSE_XY_Z"),
            StrToSBRCTransType("TILE_ALIGNED"),
            KernelConfig(false, {8, 2, 16}, 16, 256, {16, 0}, false, true,
                         false, StrToEBType("NONE"), -1, 0,
                         StrToPlacementCode("NA"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len256_single_sbrc_xy_z"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      10, 20, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {10, 2, 10}, 1, 100, {1, 10}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len10x20_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      20, 10, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 4, 5, 2}, 1, 100, {5, 5}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len20x10_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      26, 64, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {13, 2, 8, 8}, 1, 208, {2, 8}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len26x64_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      26, 72, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {13, 2, 9, 8}, 1, 234, {2, 9}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len26x72_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      30, 60, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {10, 3, 6, 10}, 1, 180, {3, 6}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len30x60_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      32, 16, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 2, 2, 4, 2, 2, 4}, 1, 256, {16, 8}, false, false,
                   false, StrToEBType("C2R_PRE"), 1, 3,
                   StrToPlacementCode("OP"), StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len32x16_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      32, 64, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 16, 8, 8}, 1, 256, {2, 8}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len32x64_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      36, 72, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {6, 6, 2, 6, 6}, 1, 432, {6, 12}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len36x72_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      36, 80, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {6, 6, 8, 10}, 1, 480, {6, 10}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len36x80_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      36, 84, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {6, 6, 3, 4, 7}, 1, 504, {6, 12}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len36x84_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      40, 80, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 8, 10, 8}, 1, 400, {5, 10}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len40x80_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      42, 84, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {6, 7, 3, 4, 7}, 1, 504, {6, 12}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len42x84_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      42, 96, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {7, 6, 4, 4, 6}, 1, 672, {7, 16}, false, false, false,
                   StrToEBType("R2C_POST"), -1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len42x96_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      60, 30, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {10, 6, 10, 3}, 1, 180, {6, 3}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len60x30_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      64, 26, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 16, 2, 13}, 1, 128, {4, 2}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64x26_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      64, 32, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 8, 2, 2, 8}, 1, 256, {8, 4}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len64x32_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      72, 26, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {9, 8, 13, 2}, 1, 234, {9, 2}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len72x26_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      72, 36, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {2, 6, 6, 6, 6}, 1, 432, {12, 6}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len72x36_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      80, 36, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {10, 8, 6, 6}, 1, 480, {10, 6}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len80x36_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      80, 40, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 10, 5, 8}, 1, 400, {10, 5}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len80x40_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      84, 36, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 3, 7, 6, 6}, 1, 504, {12, 6}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84x36_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      84, 42, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 3, 7, 6, 7}, 1, 504, {12, 6}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84x42_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      84, 7, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {3, 7, 4, 7}, 1, 84, {12, 1}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len84x7_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      96, 42, StrToPrecision("single"),
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"), StrToSBRCTransType("NONE"),
      KernelConfig(false, {4, 4, 6, 6, 7}, 1, 672, {16, 7}, false, false, false,
                   StrToEBType("C2R_PRE"), 1, 3, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len96x42_single_2d_single"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"50_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"54_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"54_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len108_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len108_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "112_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "112_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len112_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "112_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len112_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "112_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "128_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "128_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"64_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "128_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "128_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbrr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbrr", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "2187_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len2187_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "2187_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len2187_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "2187_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbrr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbrr", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbrr", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "25_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len25_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "25_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len25_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "25_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "26_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len26_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "26_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len26_double_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "26_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "4096_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len4096_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "4096_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "40_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len40_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "40_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "42_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len42_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "42_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "48_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len48_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "48_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len48_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "48_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len48_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "48_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len48_single_sbrr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "48_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len50_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len50_double_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len50_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len50_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len50_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len50_single_sbrr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len50_single_sbrr", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len50_single_sbrr", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "50_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"26_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len52_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len52_double_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len52_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "54_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len54_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "54_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len54_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "54_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len54_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "54_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len54_single_sbrr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "54_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len55_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len55_double_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len55_double_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"54_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"54_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len55_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len55_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len55_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len55_single_sbrr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_double_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_double_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_double_sbrr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len72_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len72_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "75_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len75_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "75_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "75_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len75_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "75_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "81_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "81_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84_single_sbrr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_double_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_double_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_double_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len104_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_104_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len104_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_104_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len104_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_104_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len104_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_104_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len108_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len108_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len108_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len108_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len108_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len108_single_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len108_single_sbcc", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_108_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len112_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_112_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len112_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_112_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len112_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_112_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_125_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_125_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_128_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_128_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_128_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_128_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len160_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_160_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len160_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_160_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len160_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_160_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len160_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_160_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len160_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_160_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len160_single_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_160_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_double_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 8}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len168_single_sbcc", 9}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 8}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 9}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_single_sbcc", 10}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_192_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_200_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len208_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_208_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len208_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_208_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len208_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_208_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len208_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_208_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len208_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_208_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len216_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len216_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len216_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len216_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len216_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len216_single_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len224_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_224_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len224_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_224_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len224_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_224_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len224_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_224_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len224_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_224_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len224_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_224_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len240_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_240_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len240_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_240_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len240_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_240_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len240_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_240_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len240_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_240_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len240_single_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_240_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len240_single_sbcc", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_240_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_double_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_243_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len243_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len280_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_280_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len280_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_280_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcc", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len343_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_343_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len343_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_343_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len60_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_60_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len60_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_60_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_64_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_64_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_double_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_64_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_double_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_64_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_double_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_64_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len72_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len72_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len72_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len72_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len80_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len80_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len80_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len80_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len80_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_81_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_81_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_81_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_96_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_96_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbcc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbcc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbcc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbcc", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_100_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len112_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_112_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len112_double_sbrc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_112_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len112_double_sbrc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_112_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len125_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_125_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_double_sbrc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_double_sbrc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_double_sbrc", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_double_sbrc", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_192_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_double_sbrc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_192_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len192_double_sbrc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_192_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len49_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_49_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len49_double_sbrc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_49_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_double_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_81_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_single_sbrc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_81_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_single_sbrc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_81_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len81_single_sbrc", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_81_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcr_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcr_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcr_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len336_double_sbcr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcr_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_double_sbcr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcr_56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len56_double_sbcr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcr_56_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_TRANSPOSE_XY_Z"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_single_sbrc_xy_z", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_xy_z_256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_TRANSPOSE_XY_Z"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_single_sbrc_xy_z", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbrc_xy_z_256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_TRANSPOSE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_TRANSPOSE_XY_Z"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_TRANSPOSE_Z_XY"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_COPY_R_TO_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_COPY_CMPLX_TO_HERM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_R_TO_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_COPY_HERM_TO_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_COPY_CMPLX_TO_R"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_CMPLX_TO_R"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "leafnode_token_builtin_kernel"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "10_20_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len10x20_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "10_20_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "20_10_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len20x10_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "20_10_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "26_64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len26x64_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "26_64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "26_72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len26x72_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "26_72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "30_60_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len30x60_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "30_60_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "32_16_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len32x16_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "32_16_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "32_64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len32x64_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "32_64_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "36_72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len36x72_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "36_72_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "36_80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len36x80_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "36_80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "36_84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len36x84_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "36_84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "40_80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len40x80_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "40_80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "42_84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len42x84_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "42_84_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "42_96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len42x96_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "42_96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "60_30_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len60x30_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "60_30_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "64_26_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64x26_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "64_26_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "64_32_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len64x32_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "64_32_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_26_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len72x26_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_26_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_36_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len72x36_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_36_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_36_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len80x36_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_36_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_40_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len80x40_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_40_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_36_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84x36_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_36_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_42_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84x42_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_42_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_7_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len84x7_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_7_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_42_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_2D_SINGLE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96x42_single_2d_single", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_42_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_USING_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 6},
      {"16807_dp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16807_dp_ip_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_USING_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 6},
      {"16807_dp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16807_dp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_USING_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 6},
      {"243_dp_ip_complex", 4},
      {"leafnode_token_builtin_kernel", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_ip_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_USING_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 3},
      {"243_dp_ip_complex", 3},
      {"leafnode_token_builtin_kernel", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_ip_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_USING_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 3},
      {"243_dp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_dp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_USING_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 6},
      {"55_55_75_dp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_75_dp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_USING_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 6},
      {"55_55_75_sp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_75_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_USING_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 3},
      {"55_55_75_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_75_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_USING_CMPLX"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 6},
      {"55_55_dp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_dp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"50_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"50_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"50_sp_ip_complex", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "101_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "101_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "104_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"52_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "104_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "104_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"52_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "104_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "109_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"108_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "109_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "113_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"112_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "113_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "129_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"128_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "129_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "144_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"72_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "144_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 8},
      {"8192_dp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16384_dp_ip_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"8192_dp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16384_dp_ip_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"8192_dp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16384_dp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"84_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"84_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "168_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_sp_ip_complex", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"108_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "224_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"112_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "224_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"128_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"128_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"243_dp_ip_complex", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "486_dp_ip_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"243_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "486_dp_ip_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"243_dp_ip_complex", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "486_dp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"243_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "486_dp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "49_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"48_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "49_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"48_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "49_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"48_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "49_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "51_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"50_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "51_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "51_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"50_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "51_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"50_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "51_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"50_sp_ip_complex", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "51_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "53_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"52_dp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "53_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "57_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "57_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "65_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"64_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "65_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "73_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"72_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "73_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"40_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "85_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"84_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "85_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"84_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "85_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbrr", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbrr", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbrr", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbrr", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbrr", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbrr", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len96_single_sbrr", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"48_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"48_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "97_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "97_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "97_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "97_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 8}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "97_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_2D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"52_dp_ip_complex", 1},
      {"26_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_26_dp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_100_dp_ip_complex", 3},
      {"sbcc_100_dp_ip_complex", 4},
      {"51_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_100_100_dp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_dp_ip_complex", 1},
      {"sbcc_100_dp_ip_complex", 1},
      {"sbcc_100_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_100_100_dp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_100_sp_ip_complex", 2},
      {"sbcc_100_sp_ip_complex", 3},
      {"51_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_100_100_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_sp_ip_complex", 1},
      {"sbcc_100_sp_ip_complex", 0},
      {"sbcc_100_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_100_100_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_208_sp_ip_complex", 2},
      {"sbcc_100_sp_ip_complex", 3},
      {"51_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_100_208_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_sp_ip_complex", 2},
      {"sbcc_208_sp_ip_complex", 0},
      {"sbcc_100_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_100_208_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_216_sp_ip_complex", 1},
      {"sbcc_104_sp_ip_complex", 1},
      {"51_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_104_216_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_sp_ip_complex", 6},
      {"sbcc_216_sp_ip_complex", 0},
      {"sbcc_104_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "100_104_216_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_208_dp_ip_complex", 1},
      {"sbcc_104_dp_ip_complex", 1},
      {"53_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "104_104_208_dp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"104_dp_ip_complex", 1},
      {"sbcc_208_dp_ip_complex", 0},
      {"sbcc_104_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "104_104_208_dp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"104_sp_ip_complex", 1},
      {"sbcc_224_sp_ip_complex", 0},
      {"sbcc_108_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "104_108_224_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_224_sp_ip_complex", 2},
      {"sbcc_108_sp_ip_complex", 4},
      {"55_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_108_224_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"108_sp_ip_complex", 1},
      {"sbcc_224_sp_ip_complex", 1},
      {"sbcc_108_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_108_224_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_240_sp_ip_complex", 1},
      {"sbcc_108_sp_ip_complex", 6},
      {"55_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_108_240_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"108_sp_ip_complex", 1},
      {"sbcc_240_sp_ip_complex", 0},
      {"sbcc_108_sp_ip_complex", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_108_240_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_240_sp_ip_complex", 2},
      {"sbcc_112_sp_ip_complex", 1},
      {"55_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_112_240_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"108_sp_ip_complex", 2},
      {"sbcc_240_sp_ip_complex", 2},
      {"sbcc_112_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "108_112_240_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_240_sp_ip_complex", 4},
      {"sbcc_112_sp_ip_complex", 2},
      {"57_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "112_112_240_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"112_sp_ip_complex", 1},
      {"sbcc_240_sp_ip_complex", 3},
      {"sbcc_112_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "112_112_240_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_280_sp_ip_complex", 1},
      {"sbcc_128_sp_ip_complex", 3},
      {"65_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "128_128_280_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"128_sp_ip_complex", 2},
      {"sbcc_280_sp_ip_complex", 0},
      {"sbcc_128_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "128_128_280_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_80_sp_ip_complex", 4},
      {"sbcc_84_sp_ip_complex", 3},
      {"73_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "144_84_80_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"144_sp_ip_complex", 1},
      {"sbcc_80_sp_ip_complex", 3},
      {"sbcc_84_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "144_84_80_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_80_sp_ip_complex", 2},
      {"84_7_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "14_84_80_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_160_sp_ip_complex", 0},
      {"sbcc_160_sp_ip_complex", 1},
      {"85_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "168_160_160_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"168_sp_ip_complex", 1},
      {"sbcc_160_sp_ip_complex", 0},
      {"sbcc_160_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "168_160_160_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_160_sp_ip_complex", 1},
      {"sbcc_168_sp_ip_complex", 1},
      {"85_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "168_168_160_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"168_sp_ip_complex", 2},
      {"sbcc_160_sp_ip_complex", 0},
      {"sbcc_168_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "168_168_160_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_160_sp_ip_complex", 3},
      {"sbcc_168_sp_ip_complex", 3},
      {"97_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_168_160_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"192_sp_ip_complex", 1},
      {"sbcc_160_sp_ip_complex", 2},
      {"sbcc_168_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_168_160_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_sp_ip_complex", 2},
      {"sbcc_168_sp_ip_complex", 6},
      {"97_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_168_168_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"192_sp_ip_complex", 2},
      {"sbcc_168_sp_ip_complex", 4},
      {"sbcc_168_sp_ip_complex", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_168_168_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_sp_ip_complex", 7},
      {"192_sp_ip_complex", 4},
      {"97_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_192_168_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"192_sp_ip_complex", 3},
      {"sbcc_168_sp_ip_complex", 5},
      {"192_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_192_168_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_192_sp_ip_complex", 2},
      {"sbcc_192_sp_ip_complex", 3},
      {"97_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_192_192_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"192_sp_ip_complex", 5},
      {"sbcc_192_sp_ip_complex", 0},
      {"sbcc_192_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "192_192_192_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_192_sp_ip_complex", 5},
      {"sbcc_192_sp_ip_complex", 6},
      {"101_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_192_192_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"200_sp_ip_complex", 1},
      {"sbcc_192_sp_ip_complex", 0},
      {"sbcc_192_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_192_192_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"192_sp_ip_complex", 7},
      {"sbcc_200_sp_ip_complex", 1},
      {"101_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_200_192_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"200_sp_ip_complex", 2},
      {"192_sp_ip_complex", 6},
      {"sbcc_200_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_200_192_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"200_dp_ip_complex", 1},
      {"sbcc_200_dp_ip_complex", 0},
      {"sbcc_200_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_200_200_dp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"200_sp_ip_complex", 1},
      {"sbcc_200_sp_ip_complex", 4},
      {"sbcc_200_sp_ip_complex", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "200_200_200_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"25_sp_ip_complex", 2},
      {"20_10_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "20_20_25_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"10_20_sp_ip_complex", 1},
      {"25_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "20_20_25_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_216_sp_ip_complex", 4},
      {"sbcc_216_sp_ip_complex", 5},
      {"109_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "216_216_216_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"216_sp_ip_complex", 1},
      {"sbcc_216_sp_ip_complex", 2},
      {"sbcc_216_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "216_216_216_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_240_sp_ip_complex", 6},
      {"sbcc_224_sp_ip_complex", 4},
      {"113_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "224_224_240_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"224_sp_ip_complex", 1},
      {"sbcc_240_sp_ip_complex", 5},
      {"sbcc_224_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "224_224_240_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_128_sp_ip_complex", 0},
      {"sbcc_128_sp_ip_complex", 0},
      {"129_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_128_128_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"256_sp_ip_complex", 3},
      {"sbcc_128_sp_ip_complex", 2},
      {"sbcc_128_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_128_128_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"42_sp_ip_complex", 1},
      {"32_16_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "32_32_42_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_64_sp_ip_complex", 1},
      {"64_26_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_64_64_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"26_64_sp_ip_complex", 1},
      {"sbcc_64_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_64_64_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_72_sp_ip_complex", 1},
      {"72_26_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_72_72_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"26_72_sp_ip_complex", 1},
      {"sbcc_72_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "52_72_72_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_60_sp_ip_complex", 1},
      {"60_30_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "60_60_60_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"30_60_sp_ip_complex", 1},
      {"sbcc_60_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "60_60_60_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_160_sp_ip_complex", 4},
      {"72_36_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_72_160_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"36_72_sp_ip_complex", 1},
      {"sbcc_160_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_72_160_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_72_sp_ip_complex", 3},
      {"72_36_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_72_72_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"36_72_sp_ip_complex", 1},
      {"sbcc_72_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_72_72_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_160_sp_ip_complex", 4},
      {"80_36_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_80_160_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"36_80_sp_ip_complex", 1},
      {"sbcc_160_sp_ip_complex", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_80_160_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_84_sp_ip_complex", 1},
      {"84_36_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_84_84_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"36_84_sp_ip_complex", 1},
      {"sbcc_84_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "72_84_84_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"80_sp_ip_complex", 1},
      {"sbcc_108_sp_ip_complex", 0},
      {"sbcc_108_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_108_108_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_160_sp_ip_complex", 4},
      {"80_40_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_80_160_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"40_80_sp_ip_complex", 1},
      {"sbcc_160_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_80_160_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_sp_ip_complex", 9},
      {"80_40_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_80_168_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"40_80_sp_ip_complex", 1},
      {"sbcc_168_sp_ip_complex", 8}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_80_168_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_80_sp_ip_complex", 1},
      {"80_40_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_80_80_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"40_80_sp_ip_complex", 1},
      {"sbcc_80_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "80_80_80_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_192_sp_ip_complex", 8},
      {"84_42_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_84_192_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"42_84_sp_ip_complex", 1},
      {"sbcc_192_sp_ip_complex", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_84_192_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_192_sp_ip_complex", 10},
      {"96_42_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_96_192_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"42_96_sp_ip_complex", 1},
      {"sbcc_192_sp_ip_complex", 9}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "84_96_192_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_200_sp_ip_complex", 3},
      {"sbcc_100_sp_ip_complex", 1},
      {"49_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_100_200_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 9},
      {"sbcc_200_sp_ip_complex", 2},
      {"sbcc_100_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_100_200_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"192_sp_ip_complex", 9},
      {"sbcc_96_sp_ip_complex", 1},
      {"49_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_96_192_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 9},
      {"192_sp_ip_complex", 8},
      {"sbcc_96_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_96_192_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 9},
      {"sbcc_200_sp_ip_complex", 3},
      {"sbcc_96_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_96_200_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_96_sp_ip_complex", 4},
      {"sbcc_96_sp_ip_complex", 5},
      {"49_sp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_96_96_sp_op_real_bwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"96_sp_ip_complex", 10},
      {"sbcc_96_sp_ip_complex", 3},
      {"sbcc_96_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "96_96_96_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_TRTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 0},
      {"6561_sp_ip_complex", 3},
      {"leafnode_token_builtin_kernel", 0},
      {"2187_sp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "14348907_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_TRTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 0},
      {"4096_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 0},
      {"4096_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16777216_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_100_dp_ip_complex", 0},
      {"sbrc_100_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "10000_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_96_dp_ip_complex", 1},
      {"sbrc_112_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "10752_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_125_dp_ip_complex", 1},
      {"sbrc_125_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "15625_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_64_dp_ip_complex", 1},
      {"sbrc_256_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16384_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16807_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_343_dp_ip_complex", 1},
      {"sbrc_49_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16807_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_343_dp_ip_complex", 0},
      {"sbrc_49_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "16807_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_dp_ip_complex", 0},
      {"sbrc_112_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "18816_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_dp_ip_complex", 0},
      {"sbrc_128_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "21504_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_168_dp_ip_complex", 2},
      {"sbrc_192_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "32256_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_224_dp_ip_complex", 0},
      {"sbrc_192_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "43008_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_81_sp_ip_complex", 0},
      {"sbrc_81_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_81_sp_ip_complex", 0},
      {"sbrc_81_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_81_sp_ip_complex", 1},
      {"sbrc_81_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "8192_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_64_dp_ip_complex", 2},
      {"sbrc_128_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "8192_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_64_dp_ip_complex", 3},
      {"sbrc_128_dp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "8192_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_64_dp_ip_complex", 4},
      {"sbrc_128_dp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "8192_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_L1D_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcc_64_dp_ip_complex", 0},
      {"sbrc_128_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "8192_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"4096_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 0},
      {"4096_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "4096_4096_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"55_dp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 0},
      {"55_dp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"6561_sp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 0},
      {"6561_sp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "6561_6561_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "125_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"125_sp_ip_complex", 1},
      {"sbcc_125_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "125_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"125_sp_ip_complex", 2},
      {"sbcc_125_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "125_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"243_sp_ip_complex", 1},
      {"sbcc_243_sp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_dp_ip_complex", 1},
      {"sbcc_336_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_dp_ip_complex", 2},
      {"sbcc_336_dp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_dp_ip_complex", 3},
      {"sbcc_336_dp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_dp_ip_complex", 4},
      {"sbcc_336_dp_ip_complex", 5}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_dp_ip_complex", 1},
      {"sbcc_336_dp_ip_complex", 7}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "81_81_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"81_dp_ip_complex", 1},
      {"sbcc_81_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "81_81_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_2D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"81_dp_ip_complex", 1},
      {"sbcc_81_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "81_81_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_75_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_TRTRTR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 2},
      {"55_dp_ip_complex", 3},
      {"leafnode_token_builtin_kernel", 2},
      {"75_dp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 2},
      {"55_dp_ip_complex", 3}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_75_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_75_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_TRTRTR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 2},
      {"55_sp_ip_complex", 3},
      {"leafnode_token_builtin_kernel", 2},
      {"75_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 2},
      {"55_sp_ip_complex", 4}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_75_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_TRTRTR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"leafnode_token_builtin_kernel", 2},
      {"55_sp_ip_complex", 5},
      {"leafnode_token_builtin_kernel", 2},
      {"75_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 2},
      {"55_sp_ip_complex", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "55_55_75_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_RTRT"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"243_243_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 1},
      {"243_sp_ip_complex", 2},
      {"leafnode_token_builtin_kernel", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "243_243_243_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_BLOCK_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbrc_xy_z_256_sp_ip_complex", 0},
      {"sbrc_xy_z_256_sp_ip_complex", 1},
      {"256_sp_ip_complex", 1},
      {"leafnode_token_builtin_kernel", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_256_256_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcr_336_dp_ip_complex", 2},
      {"sbcr_336_dp_ip_complex", 3},
      {"sbcr_56_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_336_336_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_BLOCK_CR"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"sbcr_336_dp_ip_complex", 0},
      {"sbcr_336_dp_ip_complex", 1},
      {"sbcr_56_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(
      ProblemKey(
          "gfx90a",
          "56_336_336_dp_op_complex_fwd_batch_1_istride_1_56_18816_ostride_1_"
          "56_18816_idist_6322176_odist_6322176_ioffset_0_ooffset_0"),
      solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"125_125_sp_ip_complex", 2},
      {"sbcc_125_sp_ip_complex", 2}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "125_125_125_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_336_dp_ip_complex", 5},
      {"sbcc_336_dp_ip_complex", 6}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "56_336_336_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"56_336_dp_ip_complex", 4},
      {"sbcc_336_dp_ip_complex", 6}}; /* solution-shipping.py:199 */
  add_solution_private(
      ProblemKey(
          "gfx90a",
          "56_336_336_dp_ip_complex_fwd_batch_1_istride_1_56_18816_ostride_1_"
          "56_18816_idist_6322176_odist_6322176_ioffset_0_ooffset_0"),
      solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_3D_RC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"81_81_dp_ip_complex", 1},
      {"sbcc_81_dp_ip_complex", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "81_81_81_dp_op_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      128, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 2, 8}, 8, 128, {16, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len128_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 4, 8}, 16, 512, {32, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len256_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 4, 8}, 16, 512, {32, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "kernel_len256_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "sbcc_256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"128_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx90a"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"256_dp_ip_complex", 1},
      {"sbcc_256_dp_ip_complex", 0},
      {"sbcc_256_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx90a", "256_256_256_dp_ip_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      100, StrToPrecision("single"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {5, 5, 4}, 6, 120, {20, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("OP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "kernel_len100_single_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {5, 5, 2, 4}, 20, 400, {20, 0}, true, true,
                         true, StrToEBType("NONE"), -1, 3,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(200, StrToPrecision("single"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {2, 2, 5, 10}, 16, 320, {20, 0}, true, true,
                         true, StrToEBType("NONE"), -1, 2,
                         StrToPlacementCode("IP"), StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "kernel_len200_single_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len100_single_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "100_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len200_single_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "sbcc_200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"100_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "200_sp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"200_sp_ip_complex", 1},
      {"sbcc_200_sp_ip_complex", 0},
      {"sbcc_200_sp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "200_200_200_sp_op_real_fwd"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey(
      128, StrToPrecision("double"), StrToComputeScheme("CS_KERNEL_STOCKHAM"),
      StrToSBRCTransType("NONE"),
      KernelConfig(false, {8, 2, 8}, 8, 128, {16, 0}, false, true, false,
                   StrToEBType("R2C_POST"), -1, 1, StrToPlacementCode("IP"),
                   StrToArrayType("CI"),
                   StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "kernel_len128_double_sbrr"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 4, 8}, 16, 512, {32, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 3, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("CI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "kernel_len256_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_KERNEL_ONLY"); /* solution-shipping.py:175 */
  solution.kernel_key =
      FMKey(256, StrToPrecision("double"),
            StrToComputeScheme("CS_KERNEL_STOCKHAM_BLOCK_CC"),
            StrToSBRCTransType("NONE"),
            KernelConfig(false, {8, 4, 8}, 16, 512, {32, 0}, false, true, false,
                         StrToEBType("NONE"), -1, 2, StrToPlacementCode("IP"),
                         StrToArrayType("CI"),
                         StrToArrayType("HI"))); /* solution-shipping.py:180 */
  solution.using_scheme =
      solution.kernel_key.scheme;    /* solution-shipping.py:192 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "kernel_len256_double_sbcc"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_KERNEL_STOCKHAM"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len128_double_sbrr", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "128_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_double_sbcc", 0}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "sbcc_256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_LEAF_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();  /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_KERNEL_STOCKHAM_BLOCK_CC"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"kernel_len256_double_sbcc", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "sbcc_256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_DUMMY");    /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey(); /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_NONE"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme = StrToComputeScheme(
      "CS_REAL_TRANSFORM_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"128_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "256_dp_ip_complex"),
                       solution); /* solution-shipping.py:207 */

  // add new solution
  solution.arch_name = "gfx942"; /* solution-shipping.py:172 */
  solution.sol_node_type =
      StrToSolutionNodeType("SOL_INTERNAL_NODE"); /* solution-shipping.py:175 */
  solution.kernel_key = FMKey::EmptyFMKey();      /* solution-shipping.py:180 */
  solution.using_scheme =
      StrToComputeScheme("CS_REAL_3D_EVEN"); /* solution-shipping.py:187 */
  solution.solution_childnodes = {
      {"256_dp_ip_complex", 1},
      {"sbcc_256_dp_ip_complex", 0},
      {"sbcc_256_dp_ip_complex", 1}}; /* solution-shipping.py:199 */
  add_solution_private(ProblemKey("gfx942", "256_256_256_dp_ip_real_fwd"),
                       solution); /* solution-shipping.py:207 */
}
