/* preview.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from preview.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <graphene-gobject.h>
#include <float.h>
#include <math.h>
#include <gsk/gsk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PREVIEW (preview_get_type ())
#define PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREVIEW, Preview))
#define PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREVIEW, PreviewClass))
#define IS_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREVIEW))
#define IS_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREVIEW))
#define PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREVIEW, PreviewClass))

typedef struct _Preview Preview;
typedef struct _PreviewClass PreviewClass;
typedef struct _PreviewPrivate PreviewPrivate;

#define TYPE_BLOCK_WIDGET (block_widget_get_type ())
#define BLOCK_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK_WIDGET, BlockWidget))
#define BLOCK_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK_WIDGET, BlockWidgetClass))
#define IS_BLOCK_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK_WIDGET))
#define IS_BLOCK_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK_WIDGET))
#define BLOCK_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK_WIDGET, BlockWidgetClass))

typedef struct _BlockWidget BlockWidget;
typedef struct _BlockWidgetClass BlockWidgetClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	PREVIEW_0_PROPERTY,
	PREVIEW_THEME_PROPERTY,
	PREVIEW_GAME_PROPERTY,
	PREVIEW_ENABLED_PROPERTY,
	PREVIEW_NUM_PROPERTIES
};
static GParamSpec* preview_properties[PREVIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _BlockWidgetPrivate BlockWidgetPrivate;

#define TYPE_BLOCK (block_get_type ())
#define BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK, Block))
#define BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK, BlockClass))
#define IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK))
#define IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK))
#define BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK, BlockClass))

typedef struct _Block Block;
typedef struct _BlockClass BlockClass;
typedef struct _BlockPrivate BlockPrivate;
#define _gsk_transform_unref0(var) ((var == NULL) ? NULL : (var = (gsk_transform_unref (var), NULL)))
typedef struct _GamePrivate GamePrivate;

#define TYPE_SHAPE (shape_get_type ())
#define SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHAPE, Shape))
#define SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHAPE, ShapeClass))
#define IS_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHAPE))
#define IS_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHAPE))
#define SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHAPE, ShapeClass))

typedef struct _Shape Shape;
typedef struct _ShapeClass ShapeClass;
typedef struct _ShapePrivate ShapePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Preview {
	GtkWidget parent_instance;
	PreviewPrivate * priv;
};

struct _PreviewClass {
	GtkWidgetClass parent_class;
};

struct _PreviewPrivate {
	GtkAspectFrame* parent_frame;
	gchar* _theme;
	GArray* block_widgets;
	gint piece_width;
	gint piece_height;
	Game* _game;
	gboolean _enabled;
};

struct _BlockWidget {
	GtkWidget parent_instance;
	BlockWidgetPrivate * priv;
	Block* block;
};

struct _BlockWidgetClass {
	GtkWidgetClass parent_class;
};

struct _Block {
	GObject parent_instance;
	BlockPrivate * priv;
	gint x;
	gint y;
	gint color;
};

struct _BlockClass {
	GObjectClass parent_class;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Shape* shape;
	Shape* next_shape;
	Block** blocks;
	gint blocks_length1;
	gint blocks_length2;
	gint n_lines_destroyed;
	gint score;
	gint difficulty;
	gboolean game_over;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Shape {
	GObject parent_instance;
	ShapePrivate * priv;
	gint x;
	gint y;
	gint rotation;
	gint type;
	GList* blocks;
};

struct _ShapeClass {
	GObjectClass parent_class;
};

static gint Preview_private_offset;
static gpointer preview_parent_class = NULL;

VALA_EXTERN GType preview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Preview, g_object_unref)
VALA_EXTERN GType block_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BlockWidget, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static void _vala_BlockWidget_free_function_content_of (gpointer data);
VALA_EXTERN Preview* preview_new (GtkAspectFrame* parent);
VALA_EXTERN Preview* preview_construct (GType object_type,
                            GtkAspectFrame* parent);
static void preview_shape_added_cb (Preview* self);
static void preview_update_block (Preview* self);
static void preview_real_snapshot (GtkWidget* base,
                            GtkSnapshot* snapshot);
static void preview_real_size_allocate (GtkWidget* base,
                                 gint width,
                                 gint height,
                                 gint baseline);
VALA_EXTERN GType block_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Block, g_object_unref)
static void preview_real_dispose (GObject* base);
VALA_EXTERN void preview_clear (Preview* self);
VALA_EXTERN Game* preview_get_game (Preview* self);
VALA_EXTERN GType shape_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Shape, g_object_unref)
VALA_EXTERN gboolean preview_get_enabled (Preview* self);
VALA_EXTERN void preview_set_visible (Preview* self,
                          gboolean visible);
VALA_EXTERN const gchar* preview_get_theme (Preview* self);
VALA_EXTERN BlockWidget* block_widget_new (Block* block,
                               const gchar* theme);
VALA_EXTERN BlockWidget* block_widget_construct (GType object_type,
                                     Block* block,
                                     const gchar* theme);
VALA_EXTERN void block_widget_set_color (BlockWidget* self,
                             gint value);
VALA_EXTERN void block_widget_set_theme (BlockWidget* self,
                             const gchar* value);
VALA_EXTERN void preview_set_hidden (Preview* self,
                         gboolean hide);
VALA_EXTERN void preview_set_theme (Preview* self,
                        const gchar* value);
static gint preview_get_cell_size (Preview* self);
VALA_EXTERN void preview_set_game (Preview* self,
                       Game* value);
static void _preview_shape_added_cb_game_shape_added (Game* _sender,
                                               gpointer self);
VALA_EXTERN void preview_set_enabled (Preview* self,
                          gboolean value);
static void preview_finalize (GObject * obj);
static GType preview_get_type_once (void);
static void _vala_preview_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec);
static void _vala_preview_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
preview_get_instance_private (Preview* self)
{
	return G_STRUCT_MEMBER_P (self, Preview_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_BlockWidget_free_function_content_of (gpointer data)
{
	BlockWidget* self;
	self = *((BlockWidget**) data);
	_g_object_unref0_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Preview*
preview_construct (GType object_type,
                   GtkAspectFrame* parent)
{
	Preview * self = NULL;
	GtkAspectFrame* _tmp0_;
	self = (Preview*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (self->priv->parent_frame);
	self->priv->parent_frame = _tmp0_;
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	return self;
}

Preview*
preview_new (GtkAspectFrame* parent)
{
	return preview_construct (TYPE_PREVIEW, parent);
}

static void
preview_shape_added_cb (Preview* self)
{
	g_return_if_fail (self != NULL);
	preview_update_block (self);
}

static void
preview_real_snapshot (GtkWidget* base,
                       GtkSnapshot* snapshot)
{
	Preview * self;
	GArray* _tmp0_;
	self = (Preview*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = self->priv->block_widgets;
	{
		GArray* widget_collection = NULL;
		guint widget_index = 0U;
		widget_collection = _tmp0_;
		for (widget_index = 0; widget_index < widget_collection->len; widget_index = widget_index + 1) {
			BlockWidget* _tmp1_;
			BlockWidget* widget = NULL;
			_tmp1_ = _g_object_ref0 (g_array_index (widget_collection, BlockWidget*, widget_index));
			widget = _tmp1_;
			{
				BlockWidget* _tmp2_;
				_tmp2_ = widget;
				gtk_widget_snapshot_child ((GtkWidget*) self, (GtkWidget*) _tmp2_, snapshot);
				_g_object_unref0 (widget);
			}
		}
	}
}

static gpointer
_gsk_transform_ref0 (gpointer self)
{
	return self ? gsk_transform_ref (self) : NULL;
}

static void
preview_real_size_allocate (GtkWidget* base,
                            gint width,
                            gint height,
                            gint baseline)
{
	Preview * self;
	gint block_width = 0;
	gint block_height = 0;
	GArray* _tmp0_;
	self = (Preview*) base;
	block_width = width / 5;
	block_height = height / 5;
	_tmp0_ = self->priv->block_widgets;
	{
		GArray* widget_collection = NULL;
		guint widget_index = 0U;
		widget_collection = _tmp0_;
		for (widget_index = 0; widget_index < widget_collection->len; widget_index = widget_index + 1) {
			BlockWidget* _tmp1_;
			BlockWidget* widget = NULL;
			_tmp1_ = _g_object_ref0 (g_array_index (widget_collection, BlockWidget*, widget_index));
			widget = _tmp1_;
			{
				graphene_point_t pos = {0};
				BlockWidget* _tmp2_;
				Block* _tmp3_;
				BlockWidget* _tmp4_;
				Block* _tmp5_;
				graphene_point_t _tmp6_ = {0};
				GskTransform* transform = NULL;
				GskTransform* _tmp7_;
				GskTransform* _tmp8_;
				graphene_point_t _tmp9_;
				GskTransform* _tmp10_;
				BlockWidget* _tmp11_;
				GskTransform* _tmp12_;
				GskTransform* _tmp13_;
				_tmp2_ = widget;
				_tmp3_ = _tmp2_->block;
				_tmp4_ = widget;
				_tmp5_ = _tmp4_->block;
				memset (&_tmp6_, 0, sizeof (graphene_point_t));
				_tmp6_.x = (gfloat) ((((5 - self->priv->piece_width) * block_width) / 2) + (_tmp3_->x * block_width));
				_tmp6_.y = (gfloat) ((((5 - self->priv->piece_height) * block_height) / 2) + (_tmp5_->y * block_height));
				pos = _tmp6_;
				_tmp7_ = gsk_transform_new ();
				transform = _tmp7_;
				_tmp8_ = transform;
				transform = NULL;
				_tmp9_ = pos;
				_tmp10_ = gsk_transform_translate (_tmp8_, &_tmp9_);
				_gsk_transform_unref0 (transform);
				transform = _tmp10_;
				_tmp11_ = widget;
				_tmp12_ = transform;
				_tmp13_ = _gsk_transform_ref0 (_tmp12_);
				gtk_widget_allocate ((GtkWidget*) _tmp11_, block_width, block_height, -1, _tmp13_);
				_gsk_transform_unref0 (transform);
				_g_object_unref0 (widget);
			}
		}
	}
}

static void
preview_real_dispose (GObject* base)
{
	Preview * self;
	self = (Preview*) base;
	preview_clear (self);
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

void
preview_clear (Preview* self)
{
	GArray* _tmp0_;
	GArray* _tmp3_;
	GArray* _tmp4_;
	gint _tmp5_ = 0;
	gpointer* _tmp6_;
	BlockWidget** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->block_widgets;
	{
		GArray* widget_collection = NULL;
		guint widget_index = 0U;
		widget_collection = _tmp0_;
		for (widget_index = 0; widget_index < widget_collection->len; widget_index = widget_index + 1) {
			BlockWidget* _tmp1_;
			BlockWidget* widget = NULL;
			_tmp1_ = _g_object_ref0 (g_array_index (widget_collection, BlockWidget*, widget_index));
			widget = _tmp1_;
			{
				BlockWidget* _tmp2_;
				_tmp2_ = widget;
				g_signal_emit_by_name ((GtkWidget*) _tmp2_, "destroy");
				_g_object_unref0 (widget);
			}
		}
	}
	_tmp3_ = self->priv->block_widgets;
	_tmp4_ = self->priv->block_widgets;
	_tmp6_ = vala_g_array_remove_range (_tmp3_, (guint) 0, _tmp4_->len, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
preview_update_block (Preview* self)
{
	GArray* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Game* _tmp3_;
	Game* _tmp4_;
	gint min_width = 0;
	gint max_width = 0;
	gint min_height = 0;
	gint max_height = 0;
	Game* _tmp12_;
	Game* _tmp13_;
	Shape* _tmp14_;
	GList* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->block_widgets;
	if (_tmp0_->len != ((guint) 0)) {
		preview_clear (self);
	}
	_tmp3_ = preview_get_game (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		Game* _tmp5_;
		Game* _tmp6_;
		Shape* _tmp7_;
		_tmp5_ = preview_get_game (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->next_shape;
		_tmp2_ = _tmp7_ == NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = preview_get_enabled (self);
		_tmp9_ = _tmp8_;
		_tmp1_ = !_tmp9_;
	}
	if (_tmp1_) {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = preview_get_enabled (self);
		_tmp11_ = _tmp10_;
		preview_set_visible (self, _tmp11_);
		return;
	}
	preview_set_visible (self, TRUE);
	min_width = 4;
	max_width = 0;
	min_height = 4;
	max_height = 0;
	_tmp12_ = preview_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_->next_shape;
	_tmp15_ = _tmp14_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp15_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp16_;
			Block* b = NULL;
			_tmp16_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp16_;
			{
				Block* _tmp17_;
				Block* _tmp18_;
				Block* _tmp19_;
				Block* _tmp20_;
				BlockWidget* widget = NULL;
				Block* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				BlockWidget* _tmp24_;
				BlockWidget* _tmp25_;
				Block* _tmp26_;
				BlockWidget* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				BlockWidget* _tmp30_;
				GArray* _tmp31_;
				BlockWidget* _tmp32_;
				BlockWidget* _tmp33_;
				_tmp17_ = b;
				min_width = MIN (_tmp17_->x, min_width);
				_tmp18_ = b;
				max_width = MAX (_tmp18_->x + 1, max_width);
				_tmp19_ = b;
				min_height = MIN (_tmp19_->y, min_height);
				_tmp20_ = b;
				max_height = MAX (_tmp20_->y + 1, max_height);
				_tmp21_ = b;
				_tmp22_ = preview_get_theme (self);
				_tmp23_ = _tmp22_;
				_tmp24_ = block_widget_new (_tmp21_, _tmp23_);
				g_object_ref_sink (_tmp24_);
				widget = _tmp24_;
				_tmp25_ = widget;
				_tmp26_ = b;
				block_widget_set_color (_tmp25_, _tmp26_->color);
				_tmp27_ = widget;
				_tmp28_ = preview_get_theme (self);
				_tmp29_ = _tmp28_;
				block_widget_set_theme (_tmp27_, _tmp29_);
				_tmp30_ = widget;
				gtk_widget_set_parent ((GtkWidget*) _tmp30_, (GtkWidget*) self);
				_tmp31_ = self->priv->block_widgets;
				_tmp32_ = widget;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				g_array_append_val (_tmp31_, _tmp33_);
				_g_object_unref0 (widget);
				_g_object_unref0 (b);
			}
		}
	}
	self->priv->piece_width = min_width + max_width;
	self->priv->piece_height = min_height + max_height;
	gtk_widget_queue_allocate ((GtkWidget*) self);
}

void
preview_set_visible (Preview* self,
                     gboolean visible)
{
	GtkAspectFrame* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), visible);
	_tmp0_ = self->priv->parent_frame;
	if (_tmp0_ != NULL) {
		GtkAspectFrame* _tmp1_;
		_tmp1_ = self->priv->parent_frame;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, visible);
	}
}

void
preview_set_hidden (Preview* self,
                    gboolean hide)
{
	GArray* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->block_widgets;
	{
		GArray* widget_collection = NULL;
		guint widget_index = 0U;
		widget_collection = _tmp0_;
		for (widget_index = 0; widget_index < widget_collection->len; widget_index = widget_index + 1) {
			BlockWidget* _tmp1_;
			BlockWidget* widget = NULL;
			_tmp1_ = _g_object_ref0 (g_array_index (widget_collection, BlockWidget*, widget_index));
			widget = _tmp1_;
			{
				BlockWidget* _tmp2_;
				_tmp2_ = widget;
				gtk_widget_set_visible ((GtkWidget*) _tmp2_, !hide);
				_g_object_unref0 (widget);
			}
		}
	}
}

const gchar*
preview_get_theme (Preview* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}

void
preview_set_theme (Preview* self,
                   const gchar* value)
{
	GArray* _tmp0_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->block_widgets;
	{
		GArray* block_collection = NULL;
		guint block_index = 0U;
		block_collection = _tmp0_;
		for (block_index = 0; block_index < block_collection->len; block_index = block_index + 1) {
			BlockWidget* _tmp1_;
			BlockWidget* block = NULL;
			_tmp1_ = _g_object_ref0 (g_array_index (block_collection, BlockWidget*, block_index));
			block = _tmp1_;
			{
				BlockWidget* _tmp2_;
				_tmp2_ = block;
				block_widget_set_theme (_tmp2_, value);
				_g_object_unref0 (block);
			}
		}
	}
	_tmp3_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, preview_properties[PREVIEW_THEME_PROPERTY]);
}

static gint
preview_get_cell_size (Preview* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = ((gtk_widget_get_width ((GtkWidget*) self) + gtk_widget_get_height ((GtkWidget*) self)) / 2) / 5;
	return result;
}

Game*
preview_get_game (Preview* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}

static void
_preview_shape_added_cb_game_shape_added (Game* _sender,
                                          gpointer self)
{
	preview_shape_added_cb ((Preview*) self);
}

void
preview_set_game (Preview* self,
                  Game* value)
{
	Game* _tmp0_;
	Game* _tmp2_;
	Game* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_;
		_tmp1_ = self->priv->_game;
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp2_;
	_tmp3_ = self->priv->_game;
	g_signal_connect_object (_tmp3_, "shape-added", (GCallback) _preview_shape_added_cb_game_shape_added, self, 0);
	preview_update_block (self);
	g_object_notify_by_pspec ((GObject *) self, preview_properties[PREVIEW_GAME_PROPERTY]);
}

gboolean
preview_get_enabled (Preview* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enabled;
	return result;
}

void
preview_set_enabled (Preview* self,
                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_enabled = value;
	preview_update_block (self);
	g_object_notify_by_pspec ((GObject *) self, preview_properties[PREVIEW_ENABLED_PROPERTY]);
}

static void
preview_class_init (PreviewClass * klass,
                    gpointer klass_data)
{
	preview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Preview_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) preview_real_snapshot;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) preview_real_size_allocate;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) preview_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_preview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_preview_set_property;
	G_OBJECT_CLASS (klass)->finalize = preview_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREVIEW_THEME_PROPERTY, preview_properties[PREVIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREVIEW_GAME_PROPERTY, preview_properties[PREVIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PREVIEW_ENABLED_PROPERTY, preview_properties[PREVIEW_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "preview");
}

static void
preview_instance_init (Preview * self,
                       gpointer klass)
{
	GArray* _tmp0_;
	self->priv = preview_get_instance_private (self);
	self->priv->parent_frame = NULL;
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (BlockWidget*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_BlockWidget_free_function_content_of);
	self->priv->block_widgets = _tmp0_;
	self->priv->_game = NULL;
	self->priv->_enabled = TRUE;
}

static void
preview_finalize (GObject * obj)
{
	Preview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREVIEW, Preview);
	_g_object_unref0 (self->priv->parent_frame);
	_g_free0 (self->priv->_theme);
	_g_array_unref0 (self->priv->block_widgets);
	_g_object_unref0 (self->priv->_game);
	G_OBJECT_CLASS (preview_parent_class)->finalize (obj);
}

static GType
preview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Preview), 0, (GInstanceInitFunc) preview_instance_init, NULL };
	GType preview_type_id;
	preview_type_id = g_type_register_static (gtk_widget_get_type (), "Preview", &g_define_type_info, 0);
	Preview_private_offset = g_type_add_instance_private (preview_type_id, sizeof (PreviewPrivate));
	return preview_type_id;
}

GType
preview_get_type (void)
{
	static volatile gsize preview_type_id__once = 0;
	if (g_once_init_enter (&preview_type_id__once)) {
		GType preview_type_id;
		preview_type_id = preview_get_type_once ();
		g_once_init_leave (&preview_type_id__once, preview_type_id);
	}
	return preview_type_id__once;
}

static void
_vala_preview_get_property (GObject * object,
                            guint property_id,
                            GValue * value,
                            GParamSpec * pspec)
{
	Preview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREVIEW, Preview);
	switch (property_id) {
		case PREVIEW_THEME_PROPERTY:
		g_value_set_string (value, preview_get_theme (self));
		break;
		case PREVIEW_GAME_PROPERTY:
		g_value_set_object (value, preview_get_game (self));
		break;
		case PREVIEW_ENABLED_PROPERTY:
		g_value_set_boolean (value, preview_get_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_preview_set_property (GObject * object,
                            guint property_id,
                            const GValue * value,
                            GParamSpec * pspec)
{
	Preview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PREVIEW, Preview);
	switch (property_id) {
		case PREVIEW_THEME_PROPERTY:
		preview_set_theme (self, g_value_get_string (value));
		break;
		case PREVIEW_GAME_PROPERTY:
		preview_set_game (self, g_value_get_object (value));
		break;
		case PREVIEW_ENABLED_PROPERTY:
		preview_set_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

