// services/network/public/mojom/proxy_config_with_annotation.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_WITH_ANNOTATION_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_WITH_ANNOTATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/proxy_config_with_annotation.mojom-shared-internal.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/proxy_config.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class ProxyConfigWithAnnotationDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ProxyConfigWithAnnotationDataView> {
  using Data = ::network::mojom::internal::ProxyConfigWithAnnotation_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class ProxyConfigClientInterfaceBase {};

using ProxyConfigClientPtrDataView =
    mojo::InterfacePtrDataView<ProxyConfigClientInterfaceBase>;
using ProxyConfigClientRequestDataView =
    mojo::InterfaceRequestDataView<ProxyConfigClientInterfaceBase>;
using ProxyConfigClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProxyConfigClientInterfaceBase>;
using ProxyConfigClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProxyConfigClientInterfaceBase>;
class ProxyConfigPollerClientInterfaceBase {};

using ProxyConfigPollerClientPtrDataView =
    mojo::InterfacePtrDataView<ProxyConfigPollerClientInterfaceBase>;
using ProxyConfigPollerClientRequestDataView =
    mojo::InterfaceRequestDataView<ProxyConfigPollerClientInterfaceBase>;
using ProxyConfigPollerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProxyConfigPollerClientInterfaceBase>;
using ProxyConfigPollerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProxyConfigPollerClientInterfaceBase>;
class ProxyErrorClientInterfaceBase {};

using ProxyErrorClientPtrDataView =
    mojo::InterfacePtrDataView<ProxyErrorClientInterfaceBase>;
using ProxyErrorClientRequestDataView =
    mojo::InterfaceRequestDataView<ProxyErrorClientInterfaceBase>;
using ProxyErrorClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ProxyErrorClientInterfaceBase>;
using ProxyErrorClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ProxyErrorClientInterfaceBase>;


class ProxyConfigWithAnnotationDataView {
 public:
  ProxyConfigWithAnnotationDataView() = default;

  ProxyConfigWithAnnotationDataView(
      internal::ProxyConfigWithAnnotation_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetValueDataView(
      ::network::mojom::ProxyConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyConfigDataView>(
        pointer, output, message_);
  }
  inline void GetTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProxyConfigWithAnnotation_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyConfigWithAnnotationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyConfigWithAnnotationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyConfigWithAnnotation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyConfigDataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in ProxyConfigWithAnnotation struct");
    decltype(Traits::traffic_annotation(input)) in_traffic_annotation = Traits::traffic_annotation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->traffic_annotation)::BaseType> traffic_annotation_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        in_traffic_annotation, traffic_annotation_fragment);
    fragment->traffic_annotation.Set(
        traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->traffic_annotation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null traffic_annotation in ProxyConfigWithAnnotation struct");
  }

  static bool Deserialize(::network::mojom::internal::ProxyConfigWithAnnotation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyConfigWithAnnotationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ProxyConfigWithAnnotationDataView::GetValueDataView(
    ::network::mojom::ProxyConfigDataView* output) {
  auto pointer = data_->value.Get();
  *output = ::network::mojom::ProxyConfigDataView(pointer, message_);
}
inline void ProxyConfigWithAnnotationDataView::GetTrafficAnnotationDataView(
    ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output) {
  auto pointer = data_->traffic_annotation.Get();
  *output = ::network::mojom::MutableNetworkTrafficAnnotationTagDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_CONFIG_WITH_ANNOTATION_MOJOM_SHARED_H_