// services/network/public/mojom/ct_log_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ct_log_info.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/ct_log_info.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/ct_log_info.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>








namespace network::mojom {









class  PreviousOperatorEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PreviousOperatorEntry, T>::value>;
  using DataView = PreviousOperatorEntryDataView;
  using Data_ = internal::PreviousOperatorEntry_Data;

  template <typename... Args>
  static PreviousOperatorEntryPtr New(Args&&... args) {
    return PreviousOperatorEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PreviousOperatorEntryPtr From(const U& u) {
    return mojo::TypeConverter<PreviousOperatorEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PreviousOperatorEntry>::Convert(*this);
  }


  PreviousOperatorEntry();

  PreviousOperatorEntry(
      const std::string& name,
      ::base::Time end_time);


  ~PreviousOperatorEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PreviousOperatorEntryPtr>
  PreviousOperatorEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PreviousOperatorEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PreviousOperatorEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PreviousOperatorEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PreviousOperatorEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PreviousOperatorEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PreviousOperatorEntry_UnserializedMessageContext<
            UserType, PreviousOperatorEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PreviousOperatorEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PreviousOperatorEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PreviousOperatorEntry_UnserializedMessageContext<
            UserType, PreviousOperatorEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PreviousOperatorEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ::base::Time end_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PreviousOperatorEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PreviousOperatorEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PreviousOperatorEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PreviousOperatorEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CTLogInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CTLogInfo, T>::value>;
  using DataView = CTLogInfoDataView;
  using Data_ = internal::CTLogInfo_Data;
  using LogType = CTLogInfo_LogType;

  template <typename... Args>
  static CTLogInfoPtr New(Args&&... args) {
    return CTLogInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CTLogInfoPtr From(const U& u) {
    return mojo::TypeConverter<CTLogInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CTLogInfo>::Convert(*this);
  }


  CTLogInfo();

  CTLogInfo(
      const std::string& id,
      const std::string& public_key,
      const std::string& name,
      std::optional<::base::Time> disqualified_at,
      ::base::TimeDelta mmd,
      const std::string& current_operator,
      std::vector<PreviousOperatorEntryPtr> previous_operators,
      CTLogInfo::LogType log_type);

CTLogInfo(const CTLogInfo&) = delete;
CTLogInfo& operator=(const CTLogInfo&) = delete;

  ~CTLogInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CTLogInfoPtr>
  CTLogInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CTLogInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CTLogInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CTLogInfo_UnserializedMessageContext<
            UserType, CTLogInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CTLogInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CTLogInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CTLogInfo_UnserializedMessageContext<
            UserType, CTLogInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CTLogInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string public_key;
  
  std::string name;
  
  std::optional<::base::Time> disqualified_at;
  
  ::base::TimeDelta mmd;
  
  std::string current_operator;
  
  std::vector<PreviousOperatorEntryPtr> previous_operators;
  
  CTLogInfo::LogType log_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CTLogInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PreviousOperatorEntryPtr PreviousOperatorEntry::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(end_time)
  );
}

template <typename T, PreviousOperatorEntry::EnableIfSame<T>*>
bool PreviousOperatorEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->end_time, other_struct.end_time))
    return false;
  return true;
}

template <typename T, PreviousOperatorEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.end_time < rhs.end_time)
    return true;
  if (rhs.end_time < lhs.end_time)
    return false;
  return false;
}
template <typename StructPtrType>
CTLogInfoPtr CTLogInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(public_key),
      mojo::Clone(name),
      mojo::Clone(disqualified_at),
      mojo::Clone(mmd),
      mojo::Clone(current_operator),
      mojo::Clone(previous_operators),
      mojo::Clone(log_type)
  );
}

template <typename T, CTLogInfo::EnableIfSame<T>*>
bool CTLogInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->public_key, other_struct.public_key))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->disqualified_at, other_struct.disqualified_at))
    return false;
  if (!mojo::Equals(this->mmd, other_struct.mmd))
    return false;
  if (!mojo::Equals(this->current_operator, other_struct.current_operator))
    return false;
  if (!mojo::Equals(this->previous_operators, other_struct.previous_operators))
    return false;
  if (!mojo::Equals(this->log_type, other_struct.log_type))
    return false;
  return true;
}

template <typename T, CTLogInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.public_key < rhs.public_key)
    return true;
  if (rhs.public_key < lhs.public_key)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.disqualified_at < rhs.disqualified_at)
    return true;
  if (rhs.disqualified_at < lhs.disqualified_at)
    return false;
  if (lhs.mmd < rhs.mmd)
    return true;
  if (rhs.mmd < lhs.mmd)
    return false;
  if (lhs.current_operator < rhs.current_operator)
    return true;
  if (rhs.current_operator < lhs.current_operator)
    return false;
  if (lhs.previous_operators < rhs.previous_operators)
    return true;
  if (rhs.previous_operators < lhs.previous_operators)
    return false;
  if (lhs.log_type < rhs.log_type)
    return true;
  if (rhs.log_type < lhs.log_type)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::PreviousOperatorEntry::DataView,
                                         ::network::mojom::PreviousOperatorEntryPtr> {
  static bool IsNull(const ::network::mojom::PreviousOperatorEntryPtr& input) { return !input; }
  static void SetToNull(::network::mojom::PreviousOperatorEntryPtr* output) { output->reset(); }

  static const decltype(::network::mojom::PreviousOperatorEntry::name)& name(
      const ::network::mojom::PreviousOperatorEntryPtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::PreviousOperatorEntry::end_time)& end_time(
      const ::network::mojom::PreviousOperatorEntryPtr& input) {
    return input->end_time;
  }

  static bool Read(::network::mojom::PreviousOperatorEntry::DataView input, ::network::mojom::PreviousOperatorEntryPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CTLogInfo::DataView,
                                         ::network::mojom::CTLogInfoPtr> {
  static bool IsNull(const ::network::mojom::CTLogInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CTLogInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CTLogInfo::id)& id(
      const ::network::mojom::CTLogInfoPtr& input) {
    return input->id;
  }

  static const decltype(::network::mojom::CTLogInfo::public_key)& public_key(
      const ::network::mojom::CTLogInfoPtr& input) {
    return input->public_key;
  }

  static const decltype(::network::mojom::CTLogInfo::name)& name(
      const ::network::mojom::CTLogInfoPtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::CTLogInfo::disqualified_at)& disqualified_at(
      const ::network::mojom::CTLogInfoPtr& input) {
    return input->disqualified_at;
  }

  static const decltype(::network::mojom::CTLogInfo::mmd)& mmd(
      const ::network::mojom::CTLogInfoPtr& input) {
    return input->mmd;
  }

  static const decltype(::network::mojom::CTLogInfo::current_operator)& current_operator(
      const ::network::mojom::CTLogInfoPtr& input) {
    return input->current_operator;
  }

  static const decltype(::network::mojom::CTLogInfo::previous_operators)& previous_operators(
      const ::network::mojom::CTLogInfoPtr& input) {
    return input->previous_operators;
  }

  static decltype(::network::mojom::CTLogInfo::log_type) log_type(
      const ::network::mojom::CTLogInfoPtr& input) {
    return input->log_type;
  }

  static bool Read(::network::mojom::CTLogInfo::DataView input, ::network::mojom::CTLogInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CT_LOG_INFO_MOJOM_H_