// services/network/public/mojom/cookie_access_observer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cookie_access_observer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cookie_access_observer.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* CookieAccessDetails_TypeToStringHelper(CookieAccessDetails_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CookieAccessDetails_Type::kRead:
      return "kRead";
    case CookieAccessDetails_Type::kChange:
      return "kChange";
    default:
      return nullptr;
  }
}

std::string CookieAccessDetails_TypeToString(CookieAccessDetails_Type value) {
  const char *str = CookieAccessDetails_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CookieAccessDetails_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CookieAccessDetails_Type value) {
  return os << CookieAccessDetails_TypeToString(value);
}

namespace internal {


// static
bool CookieAccessDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookieAccessDetails_Data* object =
      static_cast<const CookieAccessDetails_Data*>(data);


  if (!::network::mojom::internal::CookieAccessDetails_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_list, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookie_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookie_list, validation_context,
                                         &cookie_list_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& devtools_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtools_request_id, validation_context,
                                         &devtools_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_setting_overrides, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie_setting_overrides, validation_context))
    return false;

  return true;
}

CookieAccessDetails_Data::CookieAccessDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieAccessObserver_OnCookiesAccessed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookieAccessObserver_OnCookiesAccessed_Params_Data* object =
      static_cast<const CookieAccessObserver_OnCookiesAccessed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  return true;
}

CookieAccessObserver_OnCookiesAccessed_Params_Data::CookieAccessObserver_OnCookiesAccessed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookieAccessObserver_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookieAccessObserver_Clone_Params_Data* object =
      static_cast<const CookieAccessObserver_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CookieAccessObserver_Clone_Params_Data::CookieAccessObserver_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::CookieAccessDetails_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::CookieAccessDetails_Type value) {
  return std::move(context).WriteString(::network::mojom::CookieAccessDetails_TypeToString(value));
}

} // namespace perfetto