// content/browser/indexed_db/indexed_db_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "content/browser/indexed_db/indexed_db_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/browser/indexed_db/indexed_db_internals.mojom-params-data.h"
#include "content/browser/indexed_db/indexed_db_internals.mojom-shared-message-ids.h"

#include "content/browser/indexed_db/indexed_db_internals.mojom-import-headers.h"
#include "content/browser/indexed_db/indexed_db_internals.mojom-test-utils.h"


namespace storage::mojom {
IdbPartitionMetadata::IdbPartitionMetadata()
    : partition_path(),
      origin_list() {}

IdbPartitionMetadata::IdbPartitionMetadata(
    const ::base::FilePath& partition_path_in,
    std::vector<::storage::mojom::IdbOriginMetadataPtr> origin_list_in)
    : partition_path(std::move(partition_path_in)),
      origin_list(std::move(origin_list_in)) {}

IdbPartitionMetadata::~IdbPartitionMetadata() = default;

void IdbPartitionMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "partition_path"), this->partition_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_list"), this->origin_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::storage::mojom::IdbOriginMetadataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdbPartitionMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char IdbInternalsHandler::Name_[] = "storage.mojom.IdbInternalsHandler";

IdbInternalsHandler::IPCStableHashFunction IdbInternalsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IdbInternalsHandler>(message.name())) {
    case messages::IdbInternalsHandler::kGetAllBucketsAcrossAllStorageKeys: {
      return &IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeys_Sym::IPCStableHash;
    }
    case messages::IdbInternalsHandler::kDownloadBucketData: {
      return &IdbInternalsHandler::DownloadBucketData_Sym::IPCStableHash;
    }
    case messages::IdbInternalsHandler::kForceClose: {
      return &IdbInternalsHandler::ForceClose_Sym::IPCStableHash;
    }
    case messages::IdbInternalsHandler::kStartMetadataRecording: {
      return &IdbInternalsHandler::StartMetadataRecording_Sym::IPCStableHash;
    }
    case messages::IdbInternalsHandler::kStopMetadataRecording: {
      return &IdbInternalsHandler::StopMetadataRecording_Sym::IPCStableHash;
    }
    case messages::IdbInternalsHandler::kInspectClient: {
      return &IdbInternalsHandler::InspectClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IdbInternalsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IdbInternalsHandler>(message.name())) {
      case messages::IdbInternalsHandler::kGetAllBucketsAcrossAllStorageKeys:
            return "Receive storage::mojom::IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeys";
      case messages::IdbInternalsHandler::kDownloadBucketData:
            return "Receive storage::mojom::IdbInternalsHandler::DownloadBucketData";
      case messages::IdbInternalsHandler::kForceClose:
            return "Receive storage::mojom::IdbInternalsHandler::ForceClose";
      case messages::IdbInternalsHandler::kStartMetadataRecording:
            return "Receive storage::mojom::IdbInternalsHandler::StartMetadataRecording";
      case messages::IdbInternalsHandler::kStopMetadataRecording:
            return "Receive storage::mojom::IdbInternalsHandler::StopMetadataRecording";
      case messages::IdbInternalsHandler::kInspectClient:
            return "Receive storage::mojom::IdbInternalsHandler::InspectClient";
    }
  } else {
    switch (static_cast<messages::IdbInternalsHandler>(message.name())) {
      case messages::IdbInternalsHandler::kGetAllBucketsAcrossAllStorageKeys:
            return "Receive reply storage::mojom::IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeys";
      case messages::IdbInternalsHandler::kDownloadBucketData:
            return "Receive reply storage::mojom::IdbInternalsHandler::DownloadBucketData";
      case messages::IdbInternalsHandler::kForceClose:
            return "Receive reply storage::mojom::IdbInternalsHandler::ForceClose";
      case messages::IdbInternalsHandler::kStartMetadataRecording:
            return "Receive reply storage::mojom::IdbInternalsHandler::StartMetadataRecording";
      case messages::IdbInternalsHandler::kStopMetadataRecording:
            return "Receive reply storage::mojom::IdbInternalsHandler::StopMetadataRecording";
      case messages::IdbInternalsHandler::kInspectClient:
            return "Receive reply storage::mojom::IdbInternalsHandler::InspectClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeys_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeys");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IdbInternalsHandler::DownloadBucketData_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::IdbInternalsHandler::DownloadBucketData");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IdbInternalsHandler::ForceClose_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::IdbInternalsHandler::ForceClose");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IdbInternalsHandler::StartMetadataRecording_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::IdbInternalsHandler::StartMetadataRecording");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IdbInternalsHandler::StopMetadataRecording_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::IdbInternalsHandler::StopMetadataRecording");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t IdbInternalsHandler::InspectClient_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::IdbInternalsHandler::InspectClient");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ForwardToCallback(
      IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeysCallback callback
      ) : callback_(std::move(callback)) {
  }

  IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ForwardToCallback(const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ForwardToCallback&) = delete;
  IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ForwardToCallback& operator=(const IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeysCallback callback_;
};

class IdbInternalsHandler_DownloadBucketData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IdbInternalsHandler_DownloadBucketData_ForwardToCallback(
      IdbInternalsHandler::DownloadBucketDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  IdbInternalsHandler_DownloadBucketData_ForwardToCallback(const IdbInternalsHandler_DownloadBucketData_ForwardToCallback&) = delete;
  IdbInternalsHandler_DownloadBucketData_ForwardToCallback& operator=(const IdbInternalsHandler_DownloadBucketData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IdbInternalsHandler::DownloadBucketDataCallback callback_;
};

class IdbInternalsHandler_ForceClose_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IdbInternalsHandler_ForceClose_ForwardToCallback(
      IdbInternalsHandler::ForceCloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  IdbInternalsHandler_ForceClose_ForwardToCallback(const IdbInternalsHandler_ForceClose_ForwardToCallback&) = delete;
  IdbInternalsHandler_ForceClose_ForwardToCallback& operator=(const IdbInternalsHandler_ForceClose_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IdbInternalsHandler::ForceCloseCallback callback_;
};

class IdbInternalsHandler_StartMetadataRecording_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IdbInternalsHandler_StartMetadataRecording_ForwardToCallback(
      IdbInternalsHandler::StartMetadataRecordingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IdbInternalsHandler_StartMetadataRecording_ForwardToCallback(const IdbInternalsHandler_StartMetadataRecording_ForwardToCallback&) = delete;
  IdbInternalsHandler_StartMetadataRecording_ForwardToCallback& operator=(const IdbInternalsHandler_StartMetadataRecording_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IdbInternalsHandler::StartMetadataRecordingCallback callback_;
};

class IdbInternalsHandler_StopMetadataRecording_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IdbInternalsHandler_StopMetadataRecording_ForwardToCallback(
      IdbInternalsHandler::StopMetadataRecordingCallback callback
      ) : callback_(std::move(callback)) {
  }

  IdbInternalsHandler_StopMetadataRecording_ForwardToCallback(const IdbInternalsHandler_StopMetadataRecording_ForwardToCallback&) = delete;
  IdbInternalsHandler_StopMetadataRecording_ForwardToCallback& operator=(const IdbInternalsHandler_StopMetadataRecording_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IdbInternalsHandler::StopMetadataRecordingCallback callback_;
};

class IdbInternalsHandler_InspectClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  IdbInternalsHandler_InspectClient_ForwardToCallback(
      IdbInternalsHandler::InspectClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  IdbInternalsHandler_InspectClient_ForwardToCallback(const IdbInternalsHandler_InspectClient_ForwardToCallback&) = delete;
  IdbInternalsHandler_InspectClient_ForwardToCallback& operator=(const IdbInternalsHandler_InspectClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  IdbInternalsHandler::InspectClientCallback callback_;
};

IdbInternalsHandlerProxy::IdbInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IdbInternalsHandlerProxy::GetAllBucketsAcrossAllStorageKeys(
    GetAllBucketsAcrossAllStorageKeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeys");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kGetAllBucketsAcrossAllStorageKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("GetAllBucketsAcrossAllStorageKeys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IdbInternalsHandlerProxy::DownloadBucketData(
    ::storage::BucketId in_bucketId, DownloadBucketDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IdbInternalsHandler::DownloadBucketData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucketId"), in_bucketId,
                        "<value of type ::storage::BucketId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kDownloadBucketData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_DownloadBucketData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucketId)::BaseType> bucketId_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketIdDataView>(
      in_bucketId, bucketId_fragment);
  params->bucketId.Set(
      bucketId_fragment.is_null() ? nullptr : bucketId_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucketId.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucketId in IdbInternalsHandler.DownloadBucketData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("DownloadBucketData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IdbInternalsHandler_DownloadBucketData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IdbInternalsHandlerProxy::ForceClose(
    ::storage::BucketId in_bucketId, ForceCloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IdbInternalsHandler::ForceClose", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucketId"), in_bucketId,
                        "<value of type ::storage::BucketId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kForceClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_ForceClose_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucketId)::BaseType> bucketId_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketIdDataView>(
      in_bucketId, bucketId_fragment);
  params->bucketId.Set(
      bucketId_fragment.is_null() ? nullptr : bucketId_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucketId.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucketId in IdbInternalsHandler.ForceClose request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("ForceClose");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IdbInternalsHandler_ForceClose_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IdbInternalsHandlerProxy::StartMetadataRecording(
    ::storage::BucketId in_bucket_id, StartMetadataRecordingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IdbInternalsHandler::StartMetadataRecording", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_id"), in_bucket_id,
                        "<value of type ::storage::BucketId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kStartMetadataRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_StartMetadataRecording_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_id)::BaseType> bucket_id_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketIdDataView>(
      in_bucket_id, bucket_id_fragment);
  params->bucket_id.Set(
      bucket_id_fragment.is_null() ? nullptr : bucket_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucket_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket_id in IdbInternalsHandler.StartMetadataRecording request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("StartMetadataRecording");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IdbInternalsHandler_StartMetadataRecording_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IdbInternalsHandlerProxy::StopMetadataRecording(
    ::storage::BucketId in_bucket_id, StopMetadataRecordingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IdbInternalsHandler::StopMetadataRecording", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_id"), in_bucket_id,
                        "<value of type ::storage::BucketId>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kStopMetadataRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_StopMetadataRecording_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_id)::BaseType> bucket_id_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketIdDataView>(
      in_bucket_id, bucket_id_fragment);
  params->bucket_id.Set(
      bucket_id_fragment.is_null() ? nullptr : bucket_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucket_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket_id in IdbInternalsHandler.StopMetadataRecording request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("StopMetadataRecording");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IdbInternalsHandler_StopMetadataRecording_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void IdbInternalsHandlerProxy::InspectClient(
    const ::storage::BucketClientInfo& in_client_info, InspectClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::IdbInternalsHandler::InspectClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_info"), in_client_info,
                        "<value of type const ::storage::BucketClientInfo&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kInspectClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_InspectClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->client_info)::BaseType> client_info_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketClientInfoDataView>(
      in_client_info, client_info_fragment);
  params->client_info.Set(
      client_info_fragment.is_null() ? nullptr : client_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->client_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_info in IdbInternalsHandler.InspectClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("InspectClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new IdbInternalsHandler_InspectClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeysCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ProxyToResponder> proxy(
        new IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeysCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_error, std::vector<IdbPartitionMetadataPtr> in_partitions);
};

bool IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for IdbInternalsHandler.0
  bool success = true;
  std::optional<std::string> p_error{};
  std::vector<IdbPartitionMetadataPtr> p_partitions{};
  IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadPartitions(&p_partitions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IdbInternalsHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_partitions));
  return true;
}

void IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ProxyToResponder::Run(
    const std::optional<std::string>& in_error, std::vector<IdbPartitionMetadataPtr> in_partitions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeys", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("partitions"), in_partitions,
                        "<value of type std::vector<IdbPartitionMetadataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kGetAllBucketsAcrossAllStorageKeys), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->partitions)::BaseType>
      partitions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& partitions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbPartitionMetadataDataView>>(
      in_partitions, partitions_fragment, &partitions_validate_params);
  params->partitions.Set(
      partitions_fragment.is_null() ? nullptr : partitions_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->partitions.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null partitions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("GetAllBucketsAcrossAllStorageKeys");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IdbInternalsHandler_DownloadBucketData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IdbInternalsHandler::DownloadBucketDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IdbInternalsHandler_DownloadBucketData_ProxyToResponder> proxy(
        new IdbInternalsHandler_DownloadBucketData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IdbInternalsHandler_DownloadBucketData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IdbInternalsHandler_DownloadBucketData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IdbInternalsHandler_DownloadBucketData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IdbInternalsHandler::DownloadBucketDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_error);
};

bool IdbInternalsHandler_DownloadBucketData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IdbInternalsHandler_DownloadBucketData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IdbInternalsHandler_DownloadBucketData_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for IdbInternalsHandler.1
  bool success = true;
  std::optional<std::string> p_error{};
  IdbInternalsHandler_DownloadBucketData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IdbInternalsHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void IdbInternalsHandler_DownloadBucketData_ProxyToResponder::Run(
    const std::optional<std::string>& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IdbInternalsHandler::DownloadBucketData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kDownloadBucketData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_DownloadBucketData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("DownloadBucketData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IdbInternalsHandler_ForceClose_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IdbInternalsHandler::ForceCloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IdbInternalsHandler_ForceClose_ProxyToResponder> proxy(
        new IdbInternalsHandler_ForceClose_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IdbInternalsHandler_ForceClose_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IdbInternalsHandler_ForceClose_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IdbInternalsHandler_ForceClose_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IdbInternalsHandler::ForceCloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_error);
};

bool IdbInternalsHandler_ForceClose_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IdbInternalsHandler_ForceClose_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IdbInternalsHandler_ForceClose_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for IdbInternalsHandler.2
  bool success = true;
  std::optional<std::string> p_error{};
  IdbInternalsHandler_ForceClose_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IdbInternalsHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void IdbInternalsHandler_ForceClose_ProxyToResponder::Run(
    const std::optional<std::string>& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IdbInternalsHandler::ForceClose", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kForceClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_ForceClose_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("ForceClose");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IdbInternalsHandler_StartMetadataRecording_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IdbInternalsHandler::StartMetadataRecordingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IdbInternalsHandler_StartMetadataRecording_ProxyToResponder> proxy(
        new IdbInternalsHandler_StartMetadataRecording_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IdbInternalsHandler_StartMetadataRecording_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IdbInternalsHandler_StartMetadataRecording_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IdbInternalsHandler_StartMetadataRecording_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IdbInternalsHandler::StartMetadataRecordingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_error);
};

bool IdbInternalsHandler_StartMetadataRecording_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IdbInternalsHandler_StartMetadataRecording_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IdbInternalsHandler_StartMetadataRecording_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for IdbInternalsHandler.3
  bool success = true;
  std::optional<std::string> p_error{};
  IdbInternalsHandler_StartMetadataRecording_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IdbInternalsHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void IdbInternalsHandler_StartMetadataRecording_ProxyToResponder::Run(
    const std::optional<std::string>& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IdbInternalsHandler::StartMetadataRecording", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kStartMetadataRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_StartMetadataRecording_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("StartMetadataRecording");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IdbInternalsHandler_StopMetadataRecording_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IdbInternalsHandler::StopMetadataRecordingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IdbInternalsHandler_StopMetadataRecording_ProxyToResponder> proxy(
        new IdbInternalsHandler_StopMetadataRecording_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IdbInternalsHandler_StopMetadataRecording_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IdbInternalsHandler_StopMetadataRecording_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IdbInternalsHandler_StopMetadataRecording_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IdbInternalsHandler::StopMetadataRecordingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_error, std::vector<::storage::mojom::IdbBucketMetadataPtr> in_metadata);
};

bool IdbInternalsHandler_StopMetadataRecording_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IdbInternalsHandler_StopMetadataRecording_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IdbInternalsHandler_StopMetadataRecording_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for IdbInternalsHandler.4
  bool success = true;
  std::optional<std::string> p_error{};
  std::vector<::storage::mojom::IdbBucketMetadataPtr> p_metadata{};
  IdbInternalsHandler_StopMetadataRecording_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadMetadata(&p_metadata))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IdbInternalsHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_metadata));
  return true;
}

void IdbInternalsHandler_StopMetadataRecording_ProxyToResponder::Run(
    const std::optional<std::string>& in_error, std::vector<::storage::mojom::IdbBucketMetadataPtr> in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IdbInternalsHandler::StopMetadataRecording", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type std::vector<::storage::mojom::IdbBucketMetadataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kStopMetadataRecording), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_StopMetadataRecording_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType>
      metadata_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::IdbBucketMetadataDataView>>(
      in_metadata, metadata_fragment, &metadata_validate_params);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("StopMetadataRecording");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class IdbInternalsHandler_InspectClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static IdbInternalsHandler::InspectClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<IdbInternalsHandler_InspectClient_ProxyToResponder> proxy(
        new IdbInternalsHandler_InspectClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&IdbInternalsHandler_InspectClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~IdbInternalsHandler_InspectClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  IdbInternalsHandler_InspectClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "IdbInternalsHandler::InspectClientCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_error);
};

bool IdbInternalsHandler_InspectClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::IdbInternalsHandler_InspectClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::IdbInternalsHandler_InspectClient_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for IdbInternalsHandler.5
  bool success = true;
  std::optional<std::string> p_error{};
  IdbInternalsHandler_InspectClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        IdbInternalsHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void IdbInternalsHandler_InspectClient_ProxyToResponder::Run(
    const std::optional<std::string>& in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::IdbInternalsHandler::InspectClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdbInternalsHandler::kInspectClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::IdbInternalsHandler_InspectClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error, error_fragment);
  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdbInternalsHandler::Name_);
  message.set_method_name("InspectClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool IdbInternalsHandlerStubDispatch::Accept(
    IdbInternalsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IdbInternalsHandler>(message->header()->name)) {
    case messages::IdbInternalsHandler::kGetAllBucketsAcrossAllStorageKeys: {
      break;
    }
    case messages::IdbInternalsHandler::kDownloadBucketData: {
      break;
    }
    case messages::IdbInternalsHandler::kForceClose: {
      break;
    }
    case messages::IdbInternalsHandler::kStartMetadataRecording: {
      break;
    }
    case messages::IdbInternalsHandler::kStopMetadataRecording: {
      break;
    }
    case messages::IdbInternalsHandler::kInspectClient: {
      break;
    }
  }
  return false;
}

// static
bool IdbInternalsHandlerStubDispatch::AcceptWithResponder(
    IdbInternalsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IdbInternalsHandler>(message->header()->name)) {
    case messages::IdbInternalsHandler::kGetAllBucketsAcrossAllStorageKeys: {
      internal::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params_Data* params =
          reinterpret_cast<
              internal::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for IdbInternalsHandler.0
      bool success = true;
      IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IdbInternalsHandler::Name_, 0, false);
        return false;
      }
      IdbInternalsHandler::GetAllBucketsAcrossAllStorageKeysCallback callback =
          IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllBucketsAcrossAllStorageKeys(std::move(callback));
      return true;
    }
    case messages::IdbInternalsHandler::kDownloadBucketData: {
      internal::IdbInternalsHandler_DownloadBucketData_Params_Data* params =
          reinterpret_cast<
              internal::IdbInternalsHandler_DownloadBucketData_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for IdbInternalsHandler.1
      bool success = true;
      ::storage::BucketId p_bucketId{};
      IdbInternalsHandler_DownloadBucketData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketId(&p_bucketId))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IdbInternalsHandler::Name_, 1, false);
        return false;
      }
      IdbInternalsHandler::DownloadBucketDataCallback callback =
          IdbInternalsHandler_DownloadBucketData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DownloadBucketData(        
        std::move(p_bucketId), std::move(callback));
      return true;
    }
    case messages::IdbInternalsHandler::kForceClose: {
      internal::IdbInternalsHandler_ForceClose_Params_Data* params =
          reinterpret_cast<
              internal::IdbInternalsHandler_ForceClose_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for IdbInternalsHandler.2
      bool success = true;
      ::storage::BucketId p_bucketId{};
      IdbInternalsHandler_ForceClose_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketId(&p_bucketId))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IdbInternalsHandler::Name_, 2, false);
        return false;
      }
      IdbInternalsHandler::ForceCloseCallback callback =
          IdbInternalsHandler_ForceClose_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceClose(        
        std::move(p_bucketId), std::move(callback));
      return true;
    }
    case messages::IdbInternalsHandler::kStartMetadataRecording: {
      internal::IdbInternalsHandler_StartMetadataRecording_Params_Data* params =
          reinterpret_cast<
              internal::IdbInternalsHandler_StartMetadataRecording_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for IdbInternalsHandler.3
      bool success = true;
      ::storage::BucketId p_bucket_id{};
      IdbInternalsHandler_StartMetadataRecording_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketId(&p_bucket_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IdbInternalsHandler::Name_, 3, false);
        return false;
      }
      IdbInternalsHandler::StartMetadataRecordingCallback callback =
          IdbInternalsHandler_StartMetadataRecording_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartMetadataRecording(        
        std::move(p_bucket_id), std::move(callback));
      return true;
    }
    case messages::IdbInternalsHandler::kStopMetadataRecording: {
      internal::IdbInternalsHandler_StopMetadataRecording_Params_Data* params =
          reinterpret_cast<
              internal::IdbInternalsHandler_StopMetadataRecording_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for IdbInternalsHandler.4
      bool success = true;
      ::storage::BucketId p_bucket_id{};
      IdbInternalsHandler_StopMetadataRecording_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketId(&p_bucket_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IdbInternalsHandler::Name_, 4, false);
        return false;
      }
      IdbInternalsHandler::StopMetadataRecordingCallback callback =
          IdbInternalsHandler_StopMetadataRecording_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopMetadataRecording(        
        std::move(p_bucket_id), std::move(callback));
      return true;
    }
    case messages::IdbInternalsHandler::kInspectClient: {
      internal::IdbInternalsHandler_InspectClient_Params_Data* params =
          reinterpret_cast<
              internal::IdbInternalsHandler_InspectClient_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for IdbInternalsHandler.5
      bool success = true;
      ::storage::BucketClientInfo p_client_info{};
      IdbInternalsHandler_InspectClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClientInfo(&p_client_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IdbInternalsHandler::Name_, 5, false);
        return false;
      }
      IdbInternalsHandler::InspectClientCallback callback =
          IdbInternalsHandler_InspectClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InspectClient(        
        std::move(p_client_info), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kIdbInternalsHandlerValidationInfo[] = {
    {base::to_underlying(messages::IdbInternalsHandler::kGetAllBucketsAcrossAllStorageKeys),
     { &internal::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_Params_Data::Validate,
      &internal::IdbInternalsHandler_GetAllBucketsAcrossAllStorageKeys_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IdbInternalsHandler::kDownloadBucketData),
     { &internal::IdbInternalsHandler_DownloadBucketData_Params_Data::Validate,
      &internal::IdbInternalsHandler_DownloadBucketData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IdbInternalsHandler::kForceClose),
     { &internal::IdbInternalsHandler_ForceClose_Params_Data::Validate,
      &internal::IdbInternalsHandler_ForceClose_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IdbInternalsHandler::kStartMetadataRecording),
     { &internal::IdbInternalsHandler_StartMetadataRecording_Params_Data::Validate,
      &internal::IdbInternalsHandler_StartMetadataRecording_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IdbInternalsHandler::kStopMetadataRecording),
     { &internal::IdbInternalsHandler_StopMetadataRecording_Params_Data::Validate,
      &internal::IdbInternalsHandler_StopMetadataRecording_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::IdbInternalsHandler::kInspectClient),
     { &internal::IdbInternalsHandler_InspectClient_Params_Data::Validate,
      &internal::IdbInternalsHandler_InspectClient_ResponseParams_Data::Validate}},
};

bool IdbInternalsHandlerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IdbInternalsHandler::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kIdbInternalsHandlerValidationInfo);
}

bool IdbInternalsHandlerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::IdbInternalsHandler::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kIdbInternalsHandlerValidationInfo);

}


}  // storage::mojom


namespace mojo {


// static
bool StructTraits<::storage::mojom::IdbPartitionMetadata::DataView, ::storage::mojom::IdbPartitionMetadataPtr>::Read(
    ::storage::mojom::IdbPartitionMetadata::DataView input,
    ::storage::mojom::IdbPartitionMetadataPtr* output) {
  bool success = true;
  ::storage::mojom::IdbPartitionMetadataPtr result(::storage::mojom::IdbPartitionMetadata::New());
  
      if (success && !input.ReadPartitionPath(&result->partition_path))
        success = false;
      if (success && !input.ReadOriginList(&result->origin_list))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void IdbInternalsHandlerInterceptorForTesting::GetAllBucketsAcrossAllStorageKeys(GetAllBucketsAcrossAllStorageKeysCallback callback) {
  GetForwardingInterface()->GetAllBucketsAcrossAllStorageKeys(std::move(callback));
}
void IdbInternalsHandlerInterceptorForTesting::DownloadBucketData(::storage::BucketId bucketId, DownloadBucketDataCallback callback) {
  GetForwardingInterface()->DownloadBucketData(
    std::move(bucketId)
    , std::move(callback));
}
void IdbInternalsHandlerInterceptorForTesting::ForceClose(::storage::BucketId bucketId, ForceCloseCallback callback) {
  GetForwardingInterface()->ForceClose(
    std::move(bucketId)
    , std::move(callback));
}
void IdbInternalsHandlerInterceptorForTesting::StartMetadataRecording(::storage::BucketId bucket_id, StartMetadataRecordingCallback callback) {
  GetForwardingInterface()->StartMetadataRecording(
    std::move(bucket_id)
    , std::move(callback));
}
void IdbInternalsHandlerInterceptorForTesting::StopMetadataRecording(::storage::BucketId bucket_id, StopMetadataRecordingCallback callback) {
  GetForwardingInterface()->StopMetadataRecording(
    std::move(bucket_id)
    , std::move(callback));
}
void IdbInternalsHandlerInterceptorForTesting::InspectClient(const ::storage::BucketClientInfo& client_info, InspectClientCallback callback) {
  GetForwardingInterface()->InspectClient(
    std::move(client_info)
    , std::move(callback));
}
IdbInternalsHandlerAsyncWaiter::IdbInternalsHandlerAsyncWaiter(
    IdbInternalsHandler* proxy) : proxy_(proxy) {}

IdbInternalsHandlerAsyncWaiter::~IdbInternalsHandlerAsyncWaiter() = default;

void IdbInternalsHandlerAsyncWaiter::GetAllBucketsAcrossAllStorageKeys(
    std::optional<std::string>* out_error, std::vector<IdbPartitionMetadataPtr>* out_partitions) {
  base::RunLoop loop;
  proxy_->GetAllBucketsAcrossAllStorageKeys(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_error
,
             std::vector<IdbPartitionMetadataPtr>* out_partitions
,
             const std::optional<std::string>& error,
             std::vector<IdbPartitionMetadataPtr> partitions) {*out_error = std::move(error);*out_partitions = std::move(partitions);
            loop->Quit();
          },
          &loop,
          out_error,
          out_partitions));
  loop.Run();
}



void IdbInternalsHandlerAsyncWaiter::DownloadBucketData(
    ::storage::BucketId bucketId, std::optional<std::string>* out_error) {
  base::RunLoop loop;
  proxy_->DownloadBucketData(
      std::move(bucketId),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_error
,
             const std::optional<std::string>& error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

std::optional<std::string> IdbInternalsHandlerAsyncWaiter::DownloadBucketData(
    ::storage::BucketId bucketId) {
  std::optional<std::string> async_wait_result;
  DownloadBucketData(std::move(bucketId),&async_wait_result);
  return async_wait_result;
}

void IdbInternalsHandlerAsyncWaiter::ForceClose(
    ::storage::BucketId bucketId, std::optional<std::string>* out_error) {
  base::RunLoop loop;
  proxy_->ForceClose(
      std::move(bucketId),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_error
,
             const std::optional<std::string>& error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

std::optional<std::string> IdbInternalsHandlerAsyncWaiter::ForceClose(
    ::storage::BucketId bucketId) {
  std::optional<std::string> async_wait_result;
  ForceClose(std::move(bucketId),&async_wait_result);
  return async_wait_result;
}

void IdbInternalsHandlerAsyncWaiter::StartMetadataRecording(
    ::storage::BucketId bucket_id, std::optional<std::string>* out_error) {
  base::RunLoop loop;
  proxy_->StartMetadataRecording(
      std::move(bucket_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_error
,
             const std::optional<std::string>& error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

std::optional<std::string> IdbInternalsHandlerAsyncWaiter::StartMetadataRecording(
    ::storage::BucketId bucket_id) {
  std::optional<std::string> async_wait_result;
  StartMetadataRecording(std::move(bucket_id),&async_wait_result);
  return async_wait_result;
}

void IdbInternalsHandlerAsyncWaiter::StopMetadataRecording(
    ::storage::BucketId bucket_id, std::optional<std::string>* out_error, std::vector<::storage::mojom::IdbBucketMetadataPtr>* out_metadata) {
  base::RunLoop loop;
  proxy_->StopMetadataRecording(
      std::move(bucket_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_error
,
             std::vector<::storage::mojom::IdbBucketMetadataPtr>* out_metadata
,
             const std::optional<std::string>& error,
             std::vector<::storage::mojom::IdbBucketMetadataPtr> metadata) {*out_error = std::move(error);*out_metadata = std::move(metadata);
            loop->Quit();
          },
          &loop,
          out_error,
          out_metadata));
  loop.Run();
}



void IdbInternalsHandlerAsyncWaiter::InspectClient(
    const ::storage::BucketClientInfo& client_info, std::optional<std::string>* out_error) {
  base::RunLoop loop;
  proxy_->InspectClient(
      std::move(client_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_error
,
             const std::optional<std::string>& error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

std::optional<std::string> IdbInternalsHandlerAsyncWaiter::InspectClient(
    const ::storage::BucketClientInfo& client_info) {
  std::optional<std::string> async_wait_result;
  InspectClient(std::move(client_info),&async_wait_result);
  return async_wait_result;
}






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif