// components/attribution_reporting/data_host.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/attribution_reporting/data_host.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/attribution_reporting/data_host.mojom-params-data.h"
namespace attribution_reporting {
namespace mojom {

NOINLINE static const char* DataAvailableCallsiteToStringHelper(DataAvailableCallsite value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DataAvailableCallsite::kBlink:
      return "kBlink";
    case DataAvailableCallsite::kBrowser:
      return "kBrowser";
    default:
      return nullptr;
  }
}

std::string DataAvailableCallsiteToString(DataAvailableCallsite value) {
  const char *str = DataAvailableCallsiteToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DataAvailableCallsite value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DataAvailableCallsite value) {
  return os << DataAvailableCallsiteToString(value);
}

namespace internal {


// static
bool DataHost_SourceDataAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DataHost_SourceDataAvailable_Params_Data* object =
      static_cast<const DataHost_SourceDataAvailable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

DataHost_SourceDataAvailable_Params_Data::DataHost_SourceDataAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataHost_TriggerDataAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DataHost_TriggerDataAvailable_Params_Data* object =
      static_cast<const DataHost_TriggerDataAvailable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

DataHost_TriggerDataAvailable_Params_Data::DataHost_TriggerDataAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataHost_OsSourceDataAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DataHost_OsSourceDataAvailable_Params_Data* object =
      static_cast<const DataHost_OsSourceDataAvailable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;

  return true;
}

DataHost_OsSourceDataAvailable_Params_Data::DataHost_OsSourceDataAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataHost_OsTriggerDataAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DataHost_OsTriggerDataAvailable_Params_Data* object =
      static_cast<const DataHost_OsTriggerDataAvailable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registration, validation_context))
    return false;

  return true;
}

DataHost_OsTriggerDataAvailable_Params_Data::DataHost_OsTriggerDataAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DataHost_ReportRegistrationHeaderError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DataHost_ReportRegistrationHeaderError_Params_Data* object =
      static_cast<const DataHost_ReportRegistrationHeaderError_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->error, validation_context))
    return false;

  return true;
}

DataHost_ReportRegistrationHeaderError_Params_Data::DataHost_ReportRegistrationHeaderError_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace attribution_reporting

namespace perfetto {

// static
void TraceFormatTraits<::attribution_reporting::mojom::DataAvailableCallsite>::WriteIntoTrace(
   perfetto::TracedValue context, ::attribution_reporting::mojom::DataAvailableCallsite value) {
  return std::move(context).WriteString(::attribution_reporting::mojom::DataAvailableCallsiteToString(value));
}

} // namespace perfetto