// ui/ozone/public/mojom/device_cursor.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_OZONE_PUBLIC_MOJOM_DEVICE_CURSOR_MOJOM_H_
#define UI_OZONE_PUBLIC_MOJOM_DEVICE_CURSOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "ui/ozone/public/mojom/device_cursor.mojom-shared.h"
#include "ui/ozone/public/mojom/device_cursor.mojom-forward.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/accelerated_widget.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace ui {
namespace ozone {
namespace mojom {

class DeviceCursorProxy;

template <typename ImplRefTraits>
class DeviceCursorStub;

class DeviceCursorRequestValidator;


class  DeviceCursor
    : public DeviceCursorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DeviceCursorInterfaceBase;
  using Proxy_ = DeviceCursorProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceCursorStub<ImplRefTraits>;

  using RequestValidator_ = DeviceCursorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetCursorMinVersion = 0,
    kMoveCursorMinVersion = 0,
  };
  virtual ~DeviceCursor() {}

  
  virtual void SetCursor(::gfx::AcceleratedWidget window, const std::vector<::SkBitmap>& bitmaps, const ::gfx::Point& point, int32_t frame_delay_ms) = 0;

  
  virtual void MoveCursor(::gfx::AcceleratedWidget window, const ::gfx::Point& point) = 0;
};



class  DeviceCursorProxy
    : public DeviceCursor {
 public:
  using InterfaceType = DeviceCursor;

  explicit DeviceCursorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCursor(::gfx::AcceleratedWidget window, const std::vector<::SkBitmap>& bitmaps, const ::gfx::Point& point, int32_t frame_delay_ms) final;
  
  void MoveCursor(::gfx::AcceleratedWidget window, const ::gfx::Point& point) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DeviceCursorStubDispatch {
 public:
  static bool Accept(DeviceCursor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceCursor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceCursor>>
class DeviceCursorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceCursorStub() {}
  ~DeviceCursorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceCursorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceCursorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeviceCursorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace ozone
}  // namespace ui

namespace mojo {

}  // namespace mojo

#endif  // UI_OZONE_PUBLIC_MOJOM_DEVICE_CURSOR_MOJOM_H_